/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.linuxforhealth.fhir.core.lifecycle.EventCallback;

public class EventManager {
    private final List<EventCallback> callbacks = new ArrayList<EventCallback>();
    private Object serviceManagerId;

    public static EventManager getInstance() {
        return Helper.INSTANCE;
    }

    public static void registerServiceManagerId(Object serviceManagerId) {
        EventManager impl = EventManager.getInstance();
        if (impl.serviceManagerId != null) {
            throw new IllegalStateException("serviceManagerId already registered");
        }
        impl.serviceManagerId = serviceManagerId;
    }

    public static void register(EventCallback cb) {
        EventManager.getInstance().addCallback(cb);
    }

    private void addCallback(EventCallback cb) {
        this.callbacks.add(cb);
    }

    private void checkServiceManagerId(Object serviceManagerId) {
        EventManager impl = EventManager.getInstance();
        if (impl.serviceManagerId == null) {
            throw new IllegalStateException("serviceManagerId has not been registered yet");
        }
        if (impl.serviceManagerId != serviceManagerId) {
            throw new IllegalArgumentException("serviceManagerId is incorrect");
        }
    }

    public static void serverReady(Object serviceManagerId) {
        EventManager impl = EventManager.getInstance();
        impl.checkServiceManagerId(serviceManagerId);
        for (EventCallback cb : impl.callbacks) {
            cb.serverReady();
        }
    }

    public static void startShutdown(Object serviceManagerId) {
        EventManager impl = EventManager.getInstance();
        impl.checkServiceManagerId(serviceManagerId);
        for (EventCallback cb : impl.callbacks) {
            cb.startShutdown();
        }
    }

    public static void finalShutdown(Object serviceManagerId) {
        EventManager impl = EventManager.getInstance();
        impl.checkServiceManagerId(serviceManagerId);
        for (EventCallback cb : impl.callbacks) {
            cb.finalShutdown();
        }
    }

    private static class Helper {
        private static final EventManager INSTANCE = new EventManager();

        private Helper() {
        }
    }
}

