/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogSupport {
    private static final String MASK = "*****";
    private static final Pattern PASSWORD_EQ_PATTERN = Pattern.compile("[^\"]password[= ]*\"([^\"]*)\"", 2);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("\"password\"[: ]*\"([^\"]*)\"", 2);

    public static String hidePassword(String input) {
        String result = LogSupport.hidePassword(input, PASSWORD_EQ_PATTERN);
        result = LogSupport.hidePassword(result, PASSWORD_PATTERN);
        return result;
    }

    private static String hidePassword(String input, Pattern pattern) {
        Matcher m = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            int start = m.start();
            m.appendReplacement(result, match.substring(0, m.start(1) - start) + MASK + match.substring(m.end(1) - start, m.end() - start));
        }
        m.appendTail(result);
        return result.toString();
    }
}

