/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.linuxforhealth.fhir.core.FHIRVersionParam;
import org.linuxforhealth.fhir.core.ResourceType;

public class ResourceTypeUtil {
    private static final Set<ResourceType> R4_ENUMS = ResourceTypeUtil.collectResourceTypesFor(FHIRVersionParam.VERSION_40);
    private static final Set<ResourceType> R4B_ENUMS = ResourceTypeUtil.collectResourceTypesFor(FHIRVersionParam.VERSION_43);
    private static final Set<ResourceType> R4B_ONLY_RESOURCE_ENUMS = ResourceTypeUtil.collectR4bOnlyResourceTypes();
    private static final Set<ResourceType> ABSTRACT_TYPE_ENUMS = Set.of(ResourceType.RESOURCE, ResourceType.DOMAIN_RESOURCE);
    private static final Set<ResourceType> BACKWARD_BREAKING_R4B_ENUMS = Set.of(ResourceType.EVIDENCE, ResourceType.EVIDENCE_VARIABLE);
    private static final Set<ResourceType> FORWARD_BREAKING_R4B_ENUMS = Set.of(ResourceType.EVIDENCE, ResourceType.EVIDENCE_VARIABLE, ResourceType.ACTIVITY_DEFINITION, ResourceType.PLAN_DEFINITION);
    private static final Set<String> R4_COMPATIBLE_RESOURCES = Collections.unmodifiableSet(new LinkedHashSet(R4_ENUMS.stream().filter(rtn -> !ABSTRACT_TYPE_ENUMS.contains(rtn)).map(ResourceType::value).collect(Collectors.toList())));
    private static final Set<String> R4B_COMPATIBLE_RESOURCES = Collections.unmodifiableSet(new LinkedHashSet(R4B_ENUMS.stream().filter(rtn -> !ABSTRACT_TYPE_ENUMS.contains(rtn)).map(ResourceType::value).collect(Collectors.toList())));
    private static final Set<String> R4_AND_R4B_COMPATIBLE_RESOURCES = Collections.unmodifiableSet(new LinkedHashSet(R4B_ENUMS.stream().filter(rtn -> !R4B_ONLY_RESOURCE_ENUMS.contains(rtn)).filter(rtn -> !BACKWARD_BREAKING_R4B_ENUMS.contains(rtn)).filter(rtn -> !ABSTRACT_TYPE_ENUMS.contains(rtn)).map(ResourceType::value).collect(Collectors.toList())));
    private static final Set<String> ABSTRACT_RESOURCES = Collections.unmodifiableSet(ABSTRACT_TYPE_ENUMS.stream().map(ResourceType::value).collect(Collectors.toSet()));
    private static final Set<String> BACKWARD_BREAKING_R4B_RESOURCES = Collections.unmodifiableSet(BACKWARD_BREAKING_R4B_ENUMS.stream().map(ResourceType::value).collect(Collectors.toSet()));
    private static final Set<String> FORWARD_BREAKING_R4B_RESOURCES = Collections.unmodifiableSet(FORWARD_BREAKING_R4B_ENUMS.stream().map(ResourceType::value).collect(Collectors.toSet()));

    public static Set<String> getAbstractResourceTypeNames() {
        return ABSTRACT_RESOURCES;
    }

    public static Set<String> getRemovedResourceTypes(FHIRVersionParam fhirVersion) {
        return Arrays.stream(ResourceType.values()).filter(rt -> rt.getRetired() != null && rt.getRetired().compareTo(fhirVersion) <= 0).map(ResourceType::value).collect(Collectors.toSet());
    }

    public static Set<String> getCompatibleResourceTypes(FHIRVersionParam sourceFhirVersion, FHIRVersionParam targetFhirVersion) {
        if (sourceFhirVersion == FHIRVersionParam.VERSION_40) {
            switch (targetFhirVersion) {
                case VERSION_40: {
                    return R4_COMPATIBLE_RESOURCES;
                }
                case VERSION_43: {
                    return R4_AND_R4B_COMPATIBLE_RESOURCES;
                }
            }
        }
        if (targetFhirVersion == FHIRVersionParam.VERSION_40) {
            return new LinkedHashSet<String>(R4B_ENUMS.stream().filter(rtn -> !R4B_ONLY_RESOURCE_ENUMS.contains(rtn)).filter(rtn -> !FORWARD_BREAKING_R4B_ENUMS.contains(rtn)).filter(rtn -> !ABSTRACT_TYPE_ENUMS.contains(rtn)).map(ResourceType::value).collect(Collectors.toList()));
        }
        return R4B_COMPATIBLE_RESOURCES;
    }

    public static boolean isCompatible(String resourceType, FHIRVersionParam knownValidFhirVersion, FHIRVersionParam fhirVersionUnderTest) {
        if (ABSTRACT_RESOURCES.contains(resourceType) || !ResourceTypeUtil.getResourceTypesFor(knownValidFhirVersion).contains(resourceType)) {
            throw new IllegalArgumentException(resourceType + " is not a valid concrete resourceType for fhirVersion " + knownValidFhirVersion.value());
        }
        if (knownValidFhirVersion == fhirVersionUnderTest) {
            return true;
        }
        if (!ResourceTypeUtil.getResourceTypesFor(fhirVersionUnderTest).contains(resourceType)) {
            return false;
        }
        switch (knownValidFhirVersion) {
            case VERSION_40: {
                return !BACKWARD_BREAKING_R4B_RESOURCES.contains(resourceType);
            }
            case VERSION_43: {
                return !FORWARD_BREAKING_R4B_RESOURCES.contains(resourceType);
            }
        }
        throw new IllegalArgumentException("unexpected fhirVersion " + knownValidFhirVersion.value());
    }

    public static Set<String> getResourceTypesFor(FHIRVersionParam fhirVersion) {
        switch (fhirVersion) {
            case VERSION_40: {
                return R4_COMPATIBLE_RESOURCES;
            }
            case VERSION_43: {
                return R4B_COMPATIBLE_RESOURCES;
            }
        }
        throw new IllegalArgumentException("unexpected fhirVersion " + fhirVersion.value());
    }

    public static Set<String> getAllResourceTypeNames() {
        HashSet<String> resourceTypes = new HashSet<String>();
        for (FHIRVersionParam v : FHIRVersionParam.values()) {
            resourceTypes.addAll(ResourceTypeUtil.getResourceTypesFor(v));
        }
        return Collections.unmodifiableSet(resourceTypes);
    }

    private static Set<ResourceType> collectResourceTypesFor(FHIRVersionParam fhirVersion) {
        LinkedHashSet<ResourceType> set = new LinkedHashSet<ResourceType>();
        for (ResourceType r : ResourceType.values()) {
            if (r.getIntroduced().compareTo(fhirVersion) > 0 || r.getRetired() != null && fhirVersion.compareTo(r.getRetired()) >= 0) continue;
            set.add(r);
        }
        return set;
    }

    private static Set<ResourceType> collectR4bOnlyResourceTypes() {
        HashSet<ResourceType> set = new HashSet<ResourceType>();
        set.add(ResourceType.ADMINISTRABLE_PRODUCT_DEFINITION);
        set.add(ResourceType.CITATION);
        set.add(ResourceType.CLINICAL_USE_DEFINITION);
        set.add(ResourceType.EVIDENCE_REPORT);
        set.add(ResourceType.INGREDIENT);
        set.add(ResourceType.MANUFACTURED_ITEM_DEFINITION);
        set.add(ResourceType.MEDICINAL_PRODUCT_DEFINITION);
        set.add(ResourceType.NUTRITION_PRODUCT);
        set.add(ResourceType.PACKAGED_PRODUCT_DEFINITION);
        set.add(ResourceType.REGULATED_AUTHORIZATION);
        set.add(ResourceType.SUBSCRIPTION_STATUS);
        set.add(ResourceType.SUBSCRIPTION_TOPIC);
        set.add(ResourceType.SUBSTANCE_DEFINITION);
        return set;
    }
}

