/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class URLSupport {
    private URLSupport() {
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFirst(Map<String, List<String>> map, String key) {
        List<String> values = map.get(key);
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }

    public static String getPath(String url) {
        return URLSupport.getURL(url).getPath();
    }

    public static List<String> getPathSegments(String url) {
        return URLSupport.getPathSegments(url, true);
    }

    public static List<String> getPathSegments(String url, boolean decode) {
        return URLSupport.parsePath(URLSupport.getPath(url), decode);
    }

    public static String getQuery(String url) {
        return URLSupport.getURL(url).getQuery();
    }

    public static Map<String, List<String>> getQueryParameters(String url) {
        return URLSupport.getQueryParameters(url, true);
    }

    public static Map<String, List<String>> getQueryParameters(String url, boolean decode) {
        return URLSupport.parseQuery(URLSupport.getQuery(url), decode);
    }

    public static URL getURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> parsePath(String path) {
        return URLSupport.parsePath(path, true);
    }

    public static List<String> parsePath(String path, boolean decode) {
        return Arrays.stream(path.split("/")).skip(1L).map(s -> decode ? URLSupport.decode(s) : s).collect(Collectors.toList());
    }

    public static Map<String, List<String>> parseQuery(String query) {
        return URLSupport.parseQuery(query, true);
    }

    public static Map<String, List<String>> parseQuery(String query, boolean decode) {
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        return Arrays.stream(query.split("&")).map(pair -> Arrays.asList(pair.split("=", 2))).collect(Collectors.collectingAndThen(Collectors.toMap(pair -> decode ? URLSupport.decode((String)pair.get(0)) : (String)pair.get(0), pair -> pair.size() > 1 ? Collections.unmodifiableList(Arrays.stream(((String)pair.get(1)).split(",")).map(s -> decode ? URLSupport.decode(s) : s).collect(Collectors.toList())) : Collections.emptyList(), (u, v) -> {
            ArrayList merged = new ArrayList(u);
            merged.addAll(v);
            return Collections.unmodifiableList(merged);
        }, LinkedHashMap::new), Collections::unmodifiableMap));
    }
}

