/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core.util.handler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class HostnameHandler {
    private static final String CLASSNAME = HostnameHandler.class.getName();
    private static final Logger log = Logger.getLogger(CLASSNAME);
    private static final String HOSTNAME = HostnameHandler.determineHostname();

    private static String determineHostname() {
        String osName = System.getProperty("os.name");
        String hostname = System.getenv("defaultHostName");
        if (hostname == null && (hostname = osName.contains("win") ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME")) == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = "UNKNOWN";
                log.warning("Hostname not determined switching to UNKNOWN -> '" + e.getMessage() + "'");
            }
        }
        return hostname;
    }

    public String getHostname() {
        return HOSTNAME;
    }
}

