/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core.util.handler;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPHandler {
    private static final String CLASSNAME = IPHandler.class.getName();
    private static final Logger log = Logger.getLogger(CLASSNAME);
    private static final String IPS = IPHandler.determineIPS();
    private static final String IP = IPHandler.determineIP();

    private static String determineIP() {
        String ip = null;
        try {
            ip = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (NumberFormatException | UnknownHostException e) {
            log.log(Level.SEVERE, "Failure acquiring local host IP address - be sure the name is registered in the name resolution service", e);
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static String determineIPS() {
        String componentIp;
        ArrayList<String> componentIps = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> iaddrs = iface.getInetAddresses();
                while (iaddrs.hasMoreElements()) {
                    InetAddress iaddr = iaddrs.nextElement();
                    componentIps.add(iaddr.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            log.severe("Failure acquiring host name or IP: " + e.getMessage());
        }
        if (componentIps.isEmpty()) {
            componentIp = "UNKNOWN";
        } else {
            StringJoiner joiner = new StringJoiner(",");
            for (String s : componentIps) {
                joiner.add(s);
            }
            componentIp = joiner.toString();
        }
        return componentIp;
    }

    public String getIpAddress() {
        return IP;
    }

    public String getIpAddresses() {
        return IPS;
    }
}

