/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.exception;

import java.util.UUID;
import org.linuxforhealth.fhir.core.util.handler.IPHandler;

public class FHIRException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String uniqueId = null;

    public FHIRException() {
    }

    public FHIRException(String message) {
        super(message);
    }

    public FHIRException(String message, Throwable cause) {
        super(message, cause);
    }

    public FHIRException(Throwable cause) {
        super(cause);
    }

    public String getUniqueId() {
        StringBuffer uniqueIdPrefix = new StringBuffer();
        String localIpAddr = "";
        if (this.uniqueId == null) {
            IPHandler ipHandler = new IPHandler();
            localIpAddr = ipHandler.getIpAddress();
            String[] localIpAddrParts = localIpAddr.split("\\.");
            for (int i = 0; i < localIpAddrParts.length; ++i) {
                int localIpAddrPart = Integer.parseInt(localIpAddrParts[i]);
                uniqueIdPrefix.append(Integer.toHexString(localIpAddrPart));
                uniqueIdPrefix.append("-");
            }
            this.uniqueId = uniqueIdPrefix + UUID.randomUUID().toString();
        }
        return this.uniqueId;
    }

    @Override
    public String toString() {
        String superMsg = super.toString();
        StringBuilder myMsg = new StringBuilder();
        if (superMsg != null && !superMsg.isEmpty()) {
            myMsg.append(superMsg).append("  ");
        }
        myMsg.append("[probeId=").append(this.getUniqueId()).append("]");
        return myMsg.toString();
    }

    public String addProbeId(String msg) {
        StringBuilder result = new StringBuilder();
        result.append(msg);
        result.append(" [probeId=").append(this.getUniqueId()).append("]");
        return result.toString();
    }
}

