/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.linuxforhealth.fhir.exception.FHIRException;
import org.linuxforhealth.fhir.model.resource.OperationOutcome;
import org.linuxforhealth.fhir.model.util.FHIRUtil;

public class FHIROperationException
extends FHIRException {
    private static final long serialVersionUID = 1L;
    private List<OperationOutcome.Issue> issues = new ArrayList<OperationOutcome.Issue>();

    public FHIROperationException(String message) {
        super(message);
    }

    public FHIROperationException(String message, Throwable cause) {
        super(message, cause);
    }

    public OperationOutcome buildOperationOutcome() {
        return FHIRUtil.buildOperationOutcome(this.getIssues()).toBuilder().id(this.getUniqueId()).build();
    }

    public List<OperationOutcome.Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<OperationOutcome.Issue> issues) {
        this.issues = issues;
    }

    public FHIROperationException withIssue(OperationOutcome.Issue ... issues) {
        if (issues != null) {
            for (OperationOutcome.Issue issue : issues) {
                this.getIssues().add(issue);
            }
        }
        return this;
    }

    public FHIROperationException withIssue(Collection<OperationOutcome.Issue> issues) {
        if (issues != null) {
            this.getIssues().addAll(issues);
        }
        return this;
    }
}

