/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.constraint.spi.ConstraintValidator;
import org.linuxforhealth.fhir.model.visitor.Visitable;

@Repeatable(value=Constraints.class)
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Constraint {
    public static final String LEVEL_RULE = "Rule";
    public static final String LEVEL_WARNING = "Warning";
    public static final String LOCATION_BASE = "(base)";
    public static final String SOURCE_UNKNOWN = "(unknown)";

    public String id();

    public String level();

    public String location();

    public String description();

    public String expression();

    public String source();

    public boolean modelChecked() default false;

    public boolean generated() default false;

    public Class<? extends ConstraintValidator<?>> validatorClass() default FHIRPathConstraintValidator.class;

    public static final class Factory {
        private Factory() {
        }

        public static Constraint createConstraint(String id, String level, String location, String description, String expression, String source, boolean modelChecked, boolean generated) {
            return Factory.createConstraint(id, level, location, description, expression, source, modelChecked, generated, FHIRPathConstraintValidator.class);
        }

        public static Constraint createConstraint(final String id, final String level, final String location, final String description, final String expression, final String source, final boolean modelChecked, final boolean generated, final Class<? extends ConstraintValidator<?>> validatorClass) {
            return new Constraint(){

                @Override
                public String id() {
                    return id;
                }

                @Override
                public String level() {
                    return level;
                }

                @Override
                public String location() {
                    return location;
                }

                @Override
                public String description() {
                    return description;
                }

                @Override
                public String expression() {
                    return expression;
                }

                @Override
                public String source() {
                    return source;
                }

                @Override
                public boolean modelChecked() {
                    return modelChecked;
                }

                @Override
                public boolean generated() {
                    return generated;
                }

                @Override
                public Class<? extends ConstraintValidator<?>> validatorClass() {
                    return validatorClass;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Constraint.class;
                }

                @Override
                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Constraint other = (Constraint)obj;
                    return Objects.equals(this.id(), other.id()) && Objects.equals(level, other.level()) && Objects.equals(location, other.location()) && Objects.equals(description, other.description()) && Objects.equals(expression, other.expression()) && Objects.equals(source, other.source()) && Objects.equals(modelChecked, other.modelChecked()) && Objects.equals(generated, other.generated()) && Objects.equals(validatorClass, other.validatorClass());
                }

                @Override
                public int hashCode() {
                    return Objects.hash(id, level, location, description, expression, source, modelChecked, generated, validatorClass);
                }

                @Override
                public String toString() {
                    return "@org.linuxforhealth.fhir.model.annotation.Constraint(" + "id=\"" + id + "\", " + "level=\"" + level + "\", " + "location=\"" + location + "\", " + "description=\"" + description + "\", " + "expression=\"" + expression + "\", " + "source=\"" + source + "\", " + "modelChecked=" + modelChecked + ", " + "generated=" + generated + ", " + "validatorClass=" + validatorClass + ")";
                }
            };
        }
    }

    public static interface FHIRPathConstraintValidator
    extends ConstraintValidator<Visitable> {
    }
}

