/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.config;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.linuxforhealth.fhir.model.format.Format;

public final class FHIRModelConfig {
    public static final String PROPERTY_TO_STRING_FORMAT = "org.linuxforhealth.fhir.model.toStringFormat";
    public static final String PROPERTY_TO_STRING_INDENT_AMOUNT = "org.linuxforhealth.fhir.model.toStringIndentAmount";
    public static final String PROPERTY_TO_STRING_PRETTY_PRINTING = "org.linuxforhealth.fhir.model.toStringPrettyPrinting";
    public static final String PROPERTY_CHECK_REFERENCE_TYPES = "org.linuxforhealth.fhir.model.checkReferenceTypes";
    public static final String PROPERTY_EXTENDED_CODEABLE_CONCEPT_VALIDATION = "org.linuxforhealth.fhir.model.extendedCodeableConceptValidation";
    public static final String PROPERTY_CHECK_CONTROL_CHARS = "org.linuxforhealth.fhir.model.checkControlChars";
    private static final Format DEFAULT_TO_STRING_FORMAT = Format.JSON;
    private static final int DEFAULT_TO_STRING_INDENT_AMOUNT = 2;
    private static final boolean DEFAULT_TO_STRING_PRETTY_PRINTING = true;
    private static final boolean DEFAULT_CHECK_REFERENCE_TYPES = true;
    private static final boolean DEFAULT_CHECK_UNICODE_CONTROL_CHARS = true;
    private static final boolean DEFAULT_EXTENDED_CODEABLE_CONCEPT_VALIDATION = true;
    private static final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    private FHIRModelConfig() {
    }

    public static void setToStringFormat(Format format) {
        FHIRModelConfig.setProperty(PROPERTY_TO_STRING_FORMAT, (Object)format);
    }

    public static Format getToStringFormat() {
        return FHIRModelConfig.getPropertyOrDefault(PROPERTY_TO_STRING_FORMAT, DEFAULT_TO_STRING_FORMAT, Format.class);
    }

    public static void setToStringIndentAmount(int indentAmount) {
        FHIRModelConfig.setProperty(PROPERTY_TO_STRING_INDENT_AMOUNT, indentAmount);
    }

    public static int getToStringIndentAmount() {
        return FHIRModelConfig.getPropertyOrDefault(PROPERTY_TO_STRING_INDENT_AMOUNT, 2, Integer.class);
    }

    public static void setToStringPrettyPrinting(boolean prettyPrinting) {
        FHIRModelConfig.setProperty(PROPERTY_TO_STRING_PRETTY_PRINTING, prettyPrinting);
    }

    public static boolean getToStringPrettyPrinting() {
        return FHIRModelConfig.getPropertyOrDefault(PROPERTY_TO_STRING_PRETTY_PRINTING, true, Boolean.class);
    }

    public static void setCheckReferenceTypes(boolean checkReferenceTypes) {
        FHIRModelConfig.setProperty(PROPERTY_CHECK_REFERENCE_TYPES, checkReferenceTypes);
    }

    public static boolean getCheckReferenceTypes() {
        return FHIRModelConfig.getPropertyOrDefault(PROPERTY_CHECK_REFERENCE_TYPES, true, Boolean.class);
    }

    public static void setCheckForControlChars(boolean checkControlChars) {
        FHIRModelConfig.setProperty(PROPERTY_CHECK_CONTROL_CHARS, checkControlChars);
    }

    public static boolean shouldCheckForControlChars() {
        return FHIRModelConfig.getPropertyOrDefault(PROPERTY_CHECK_CONTROL_CHARS, true, Boolean.class);
    }

    public static void setExtendedCodeableConceptValidation(boolean extendedCodeableConceptValidation) {
        FHIRModelConfig.setProperty(PROPERTY_EXTENDED_CODEABLE_CONCEPT_VALIDATION, extendedCodeableConceptValidation);
    }

    public static boolean getExtendedCodeableConceptValidation() {
        return FHIRModelConfig.getPropertyOrDefault(PROPERTY_EXTENDED_CODEABLE_CONCEPT_VALIDATION, true, Boolean.class);
    }

    public static void setProperty(String name, Object value) {
        properties.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
    }

    public static Object removeProperty(String name) {
        return properties.remove(Objects.requireNonNull(name));
    }

    public static <T> T removeProperty(String name, Class<T> type) {
        return Objects.requireNonNull(type).cast(FHIRModelConfig.removeProperty(name));
    }

    public static Object getProperty(String name) {
        return properties.get(Objects.requireNonNull(name));
    }

    public static Object getPropertyOrDefault(String name, Object defaultValue) {
        return properties.getOrDefault(Objects.requireNonNull(name), Objects.requireNonNull(defaultValue));
    }

    public static <T> T getProperty(String name, Class<T> type) {
        return Objects.requireNonNull(type).cast(FHIRModelConfig.getProperty(name));
    }

    public static <T> T getPropertyOrDefault(String name, T defaultValue, Class<T> type) {
        return Objects.requireNonNull(type).cast(FHIRModelConfig.getPropertyOrDefault(name, defaultValue));
    }

    public static Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(properties);
    }

    public static Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(properties.keySet());
    }
}

