/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.constraint.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.constraint.spi.ConstraintProvider;
import org.linuxforhealth.fhir.model.constraint.spi.ConstraintValidator;

public abstract class AbstractConstraintProvider
implements ConstraintProvider {
    private final List<Predicate<Constraint>> removalPredicates = this.buildRemovalPredicates();
    private final List<Constraint> constraints = this.buildConstraints();

    @Override
    public final List<Predicate<Constraint>> getRemovalPredicates() {
        return this.removalPredicates;
    }

    @Override
    public final List<Constraint> getConstraints() {
        return this.constraints;
    }

    protected abstract void addRemovalPredicates(List<Predicate<Constraint>> var1);

    protected abstract void addConstraints(List<Constraint> var1);

    protected Predicate<Constraint> idEquals(String id) {
        return constraint -> constraint.id().equals(id);
    }

    protected Predicate<Constraint> locationEquals(String location) {
        return constraint -> constraint.location().equals(location);
    }

    protected Predicate<Constraint> sourceEquals(String source) {
        return constraint -> constraint.source().equals(source);
    }

    protected Constraint constraint(String id, String level, String location, String description, Class<? extends ConstraintValidator<?>> validationClass) {
        return Constraint.Factory.createConstraint(id, level, location, description, "", "", false, false, validationClass);
    }

    protected Constraint constraint(String id, String level, String location, String description, String expression, String source) {
        return Constraint.Factory.createConstraint(id, level, location, description, expression, source, false, false);
    }

    protected Constraint constraint(String id, String level, String location, String description, String expression, String source, Class<? extends ConstraintValidator<?>> validatorClass) {
        return Constraint.Factory.createConstraint(id, level, location, description, expression, source, false, false, validatorClass);
    }

    private List<Predicate<Constraint>> buildRemovalPredicates() {
        ArrayList<Predicate<Constraint>> removalPredicates = new ArrayList<Predicate<Constraint>>();
        this.addRemovalPredicates(removalPredicates);
        return Collections.unmodifiableList(removalPredicates);
    }

    private List<Constraint> buildConstraints() {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        this.addConstraints(constraints);
        return Collections.unmodifiableList(constraints);
    }
}

