/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.constraint.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import org.linuxforhealth.fhir.model.annotation.Constraint;

public interface ConstraintProvider {
    public List<Predicate<Constraint>> getRemovalPredicates();

    public List<Constraint> getConstraints();

    public static <T extends ConstraintProvider> List<T> providers(Class<T> providerClass) {
        ArrayList<ConstraintProvider> providers = new ArrayList<ConstraintProvider>();
        for (ConstraintProvider provider : ServiceLoader.load(providerClass)) {
            providers.add(provider);
        }
        return Collections.unmodifiableList(providers);
    }
}

