/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.generator;

import java.io.OutputStream;
import java.io.Writer;
import org.linuxforhealth.fhir.model.format.Format;
import org.linuxforhealth.fhir.model.generator.FHIRJsonGenerator;
import org.linuxforhealth.fhir.model.generator.FHIRXMLGenerator;
import org.linuxforhealth.fhir.model.generator.exception.FHIRGeneratorException;
import org.linuxforhealth.fhir.model.visitor.Visitable;

public interface FHIRGenerator {
    public static final String PROPERTY_INDENT_AMOUNT = "org.linuxforhealth.fhir.model.generator.indentAmount";

    public void generate(Visitable var1, OutputStream var2) throws FHIRGeneratorException;

    public void generate(Visitable var1, Writer var2) throws FHIRGeneratorException;

    public boolean isPrettyPrinting();

    public void setProperty(String var1, Object var2);

    public Object getProperty(String var1);

    public Object getPropertyOrDefault(String var1, Object var2);

    public <T> T getProperty(String var1, Class<T> var2);

    public <T> T getPropertyOrDefault(String var1, T var2, Class<T> var3);

    public boolean isPropertySupported(String var1);

    public <T extends FHIRGenerator> T as(Class<T> var1);

    public static FHIRGenerator generator(Format format) {
        return FHIRGenerator.generator(format, false);
    }

    public static FHIRGenerator generator(Format format, boolean prettyPrinting) {
        switch (format) {
            case JSON: {
                return new FHIRJsonGenerator(prettyPrinting);
            }
            case XML: {
                return new FHIRXMLGenerator(prettyPrinting);
            }
        }
        throw new IllegalArgumentException("Unsupported format: " + format);
    }
}

