/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.generator;

import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.Base64;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamSource;
import org.linuxforhealth.fhir.model.generator.FHIRAbstractGenerator;
import org.linuxforhealth.fhir.model.generator.GeneratingVisitor;
import org.linuxforhealth.fhir.model.generator.exception.FHIRGeneratorException;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Time;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.Xhtml;
import org.linuxforhealth.fhir.model.util.ModelSupport;
import org.linuxforhealth.fhir.model.util.XMLSupport;
import org.linuxforhealth.fhir.model.visitor.PathAwareVisitor;
import org.linuxforhealth.fhir.model.visitor.Visitable;

public class FHIRXMLGenerator
extends FHIRAbstractGenerator {
    private static final int DEFAULT_INDENT_AMOUNT = 2;

    protected FHIRXMLGenerator(boolean prettyPrinting) {
        super(prettyPrinting);
    }

    @Override
    public void generate(Visitable visitable, OutputStream out) throws FHIRGeneratorException {
        PathAwareVisitor visitor = null;
        try (XMLSupport.StreamWriterDelegate delegate = XMLSupport.createStreamWriterDelegate(out);){
            int indentAmount = this.getPropertyOrDefault("org.linuxforhealth.fhir.model.generator.indentAmount", 2, java.lang.Integer.class);
            visitor = new XMLGeneratingVisitor(delegate, this.prettyPrinting, indentAmount);
            delegate.setDefaultNamespace("http://hl7.org/fhir");
            visitable.accept(visitor);
            delegate.flush();
        }
        catch (Exception e) {
            throw new FHIRGeneratorException(e.getMessage(), visitor != null ? visitor.getPath() : null, e);
        }
    }

    @Override
    public void generate(Visitable visitable, Writer writer) throws FHIRGeneratorException {
        PathAwareVisitor visitor = null;
        try (XMLSupport.StreamWriterDelegate delegate = XMLSupport.createStreamWriterDelegate(writer);){
            int indentAmount = this.getPropertyOrDefault("org.linuxforhealth.fhir.model.generator.indentAmount", 2, java.lang.Integer.class);
            visitor = new XMLGeneratingVisitor(delegate, this.prettyPrinting, indentAmount);
            delegate.setDefaultNamespace("http://hl7.org/fhir");
            visitable.accept(visitor);
            delegate.getWriter().writeEndDocument();
            delegate.flush();
        }
        catch (Exception e) {
            throw new FHIRGeneratorException(e.getMessage(), visitor != null ? visitor.getPath() : null, e);
        }
    }

    @Override
    public boolean isPropertySupported(java.lang.String name) {
        return "org.linuxforhealth.fhir.model.generator.indentAmount".equals(name);
    }

    private static class XMLGeneratingVisitor
    extends GeneratingVisitor {
        private final XMLStreamWriter writer;
        private final boolean prettyPrinting;
        private final int indentAmount;
        private static final ThreadLocal<Transformer> THREAD_LOCAL_TRANSFORMER = new ThreadLocal<Transformer>(){

            @Override
            public Transformer initialValue() {
                return XMLSupport.createTransformer();
            }
        };
        private int indentLevel = 0;

        private XMLGeneratingVisitor(XMLStreamWriter writer, boolean prettyPrinting, int indentAmount) {
            this.writer = writer;
            this.prettyPrinting = prettyPrinting;
            this.indentAmount = indentAmount;
            if (this.indentAmount < 0) {
                throw new IllegalStateException("Indent amount must be a non-negative number");
            }
        }

        private void indent() {
            if (this.prettyPrinting) {
                for (int i = 0; i < this.indentLevel; ++i) {
                    try {
                        for (int j = 0; j < this.indentAmount; ++j) {
                            this.writer.writeCharacters(" ");
                        }
                        continue;
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        private void newLine() {
            if (this.prettyPrinting) {
                try {
                    this.writer.writeCharacters(System.lineSeparator());
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void writeAttributes(Element element) {
            try {
                Class<?> elementType = element.getClass();
                if (element.getId() != null) {
                    this.writer.writeAttribute("id", element.getId());
                }
                if (element instanceof Extension) {
                    Extension extension = (Extension)element;
                    if (extension.getUrl() != null) {
                        this.writer.writeAttribute("url", extension.getUrl());
                    }
                } else if (ModelSupport.isPrimitiveType(elementType)) {
                    this.writeValue(element);
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeValue(Element element) throws XMLStreamException {
            Uri uri;
            java.lang.String value = null;
            if (element instanceof Base64Binary) {
                Base64Binary base64Binary = (Base64Binary)element;
                if (base64Binary.getValue() != null) {
                    value = Base64.getEncoder().encodeToString(base64Binary.getValue());
                }
            } else if (element instanceof Boolean) {
                Boolean _boolean = (Boolean)element;
                if (_boolean.getValue() != null) {
                    value = _boolean.getValue().toString();
                }
            } else if (element instanceof Date) {
                Date date = (Date)element;
                if (date.getValue() != null) {
                    value = Date.PARSER_FORMATTER.format(date.getValue());
                }
            } else if (element instanceof DateTime) {
                DateTime dateTime = (DateTime)element;
                if (dateTime.getValue() != null) {
                    value = DateTime.PARSER_FORMATTER.format(dateTime.getValue());
                }
            } else if (element instanceof Decimal) {
                Decimal decimal = (Decimal)element;
                if (decimal.getValue() != null) {
                    value = decimal.getValue().toString();
                }
            } else if (element instanceof Instant) {
                Instant instant = (Instant)element;
                if (instant.getValue() != null) {
                    value = Instant.PARSER_FORMATTER.format(instant.getValue());
                }
            } else if (element instanceof Integer) {
                Integer integer = (Integer)element;
                if (integer.getValue() != null) {
                    value = integer.getValue().toString();
                }
            } else if (element instanceof String) {
                String string = (String)element;
                if (string.getValue() != null) {
                    value = string.getValue();
                }
            } else if (element instanceof Time) {
                Time time = (Time)element;
                if (time.getValue() != null) {
                    value = Time.PARSER_FORMATTER.format(time.getValue());
                }
            } else if (element instanceof Uri && (uri = (Uri)element).getValue() != null) {
                value = uri.getValue();
            }
            if (value != null) {
                this.writer.writeAttribute("value", value);
            }
        }

        private void writeXhtml(java.lang.String elementName, Xhtml xhtml) {
            try {
                Transformer transformer = THREAD_LOCAL_TRANSFORMER.get();
                transformer.reset();
                transformer.transform(new StreamSource(new StringReader(xhtml.getValue())), new StAXResult(XMLSupport.createNonClosingStreamWriterDelegate(this.writer)));
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void doVisitEnd(java.lang.String elementName, int elementIndex, Element element) {
            try {
                --this.indentLevel;
                Class<?> elementType = element.getClass();
                if (!ModelSupport.isPrimitiveType(elementType) || !element.getExtension().isEmpty()) {
                    this.indent();
                    this.writer.writeEndElement();
                    this.newLine();
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void doVisitEnd(java.lang.String elementName, int elementIndex, Resource resource) {
            try {
                if (this.getDepth() > 1) {
                    --this.indentLevel;
                    this.indent();
                    this.writer.writeEndElement();
                    this.newLine();
                }
                --this.indentLevel;
                this.indent();
                this.writer.writeEndElement();
                if (this.getDepth() > 1) {
                    this.newLine();
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void doVisitStart(java.lang.String elementName, int elementIndex, Element element) {
            try {
                this.indent();
                Class<?> elementType = element.getClass();
                if (this.isChoiceElement(elementName)) {
                    elementName = this.getChoiceElementName(elementName, element.getClass());
                }
                if (!ModelSupport.isPrimitiveType(elementType) || !element.getExtension().isEmpty()) {
                    this.writer.writeStartElement("http://hl7.org/fhir", elementName);
                } else if (Xhtml.class.equals(elementType)) {
                    this.writeXhtml(elementName, (Xhtml)element);
                } else {
                    this.writer.writeEmptyElement("http://hl7.org/fhir", elementName);
                }
                this.writeAttributes(element);
                this.newLine();
                ++this.indentLevel;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void doVisitStart(java.lang.String elementName, int elementIndex, Resource resource) {
            try {
                int depth = this.getDepth();
                if (depth > 1) {
                    this.indent();
                    this.writer.writeStartElement(elementName);
                    this.newLine();
                    ++this.indentLevel;
                }
                this.indent();
                Class<?> resourceType = resource.getClass();
                java.lang.String resourceTypeName = resourceType.getSimpleName();
                this.writer.writeStartElement("http://hl7.org/fhir", resourceTypeName);
                if (depth == 1) {
                    this.writer.writeDefaultNamespace("http://hl7.org/fhir");
                }
                this.newLine();
                ++this.indentLevel;
                if (resource.getId() != null) {
                    this.indent();
                    this.writer.writeEmptyElement("id");
                    this.writer.writeAttribute("value", resource.getId());
                    this.newLine();
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

