/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.lang.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class LanguageRegistry {
    private static final Set<String> languages = LanguageRegistryInitializer.buildLanguages();
    private static final Map<String, String> extlangs = LanguageRegistryInitializer.buildExtlangs();
    private static final Set<String> scripts = LanguageRegistryInitializer.buildScripts();
    private static final Set<String> regions = LanguageRegistryInitializer.buildRegions();
    private static final Map<String, List<String>> variants = LanguageRegistryInitializer.buildVariants();
    private static final Set<String> grandfathereds = LanguageRegistryInitializer.buildGrandfathereds();

    private LanguageRegistry() {
    }

    static void init() {
    }

    static boolean isLanguageSubtag(String subtag) {
        return languages.contains(subtag);
    }

    static boolean isExtlangSubtag(String subtag) {
        return extlangs.containsKey(subtag);
    }

    static String getExtlangPrefix(String subtag) {
        return extlangs.get(subtag);
    }

    static boolean isScriptSubtag(String subtag) {
        return scripts.contains(subtag);
    }

    static boolean isRegionSubtag(String subtag) {
        return regions.contains(subtag);
    }

    static boolean isVariantSubtag(String subtag) {
        return variants.containsKey(subtag);
    }

    static List<String> getVariantPrefixes(String subtag) {
        return variants.get(subtag);
    }

    static boolean isGrandfatheredTag(String tag) {
        return grandfathereds.contains(tag);
    }

    private static class LanguageRegistryInitializer {
        private static final String REGISTRY_FILE = "language-subtag-registry";
        private static final String FILE_DATE_ROW = "File-Date:";
        private static final String RECORD_DELIMITER = "%%";
        private static final String ROW_DELIMITER = ": ";
        private static final String TYPE = "Type";
        private static final String LANGUAGE = "language";
        private static final String EXTLANG = "extlang";
        private static final String SCRIPT = "script";
        private static final String REGION = "region";
        private static final String VARIANT = "variant";
        private static final String GRANDFATHERED = "grandfathered";
        private static final String DEPRECATED = "Deprecated";
        private static final String SUBTAG = "Subtag";
        private static final String PREFIX = "Prefix";
        private static final String TAG = "Tag";
        private static final String PRIVATE_USE_LANG_SUBTAG = "qaa..qtz";
        private static final String PRIVATE_USE_SCRIPT_SUBTAG = "Qaaa..Qabx";
        private static final String PRIVATE_USE_REGION_SUBTAG_1 = "QM..QZ";
        private static final String PRIVATE_USE_REGION_SUBTAG_2 = "XA..XZ";

        private LanguageRegistryInitializer() {
        }

        private static Set<String> buildLanguages() {
            HashSet<String> languages = new HashSet<String>();
            for (Map<String, String> entryMap : LanguageRegistryInitializer.getLanguageSubTagRegistryEntries(REGISTRY_FILE)) {
                if (!LANGUAGE.equals(entryMap.get(TYPE))) continue;
                String subTag = entryMap.get(SUBTAG);
                String deprecated = entryMap.get(DEPRECATED);
                if (subTag == null || PRIVATE_USE_LANG_SUBTAG.equalsIgnoreCase(subTag) || deprecated != null) continue;
                languages.add(subTag.toLowerCase());
            }
            return languages;
        }

        private static Map<String, String> buildExtlangs() {
            HashMap<String, String> extLangs = new HashMap<String, String>();
            for (Map<String, String> entryMap : LanguageRegistryInitializer.getLanguageSubTagRegistryEntries(REGISTRY_FILE)) {
                if (!EXTLANG.equals(entryMap.get(TYPE))) continue;
                String subTag = entryMap.get(SUBTAG);
                String prefix = entryMap.get(PREFIX);
                String deprecated = entryMap.get(DEPRECATED);
                if (subTag == null || prefix == null || deprecated != null) continue;
                extLangs.put(subTag.toLowerCase(), prefix.toLowerCase());
            }
            return extLangs;
        }

        private static Set<String> buildScripts() {
            HashSet<String> scripts = new HashSet<String>();
            for (Map<String, String> entryMap : LanguageRegistryInitializer.getLanguageSubTagRegistryEntries(REGISTRY_FILE)) {
                if (!SCRIPT.equals(entryMap.get(TYPE))) continue;
                String subTag = entryMap.get(SUBTAG);
                String deprecated = entryMap.get(DEPRECATED);
                if (subTag == null || PRIVATE_USE_SCRIPT_SUBTAG.equalsIgnoreCase(subTag) || deprecated != null) continue;
                scripts.add(subTag.toLowerCase());
            }
            return scripts;
        }

        private static Set<String> buildRegions() {
            HashSet<String> regions = new HashSet<String>();
            for (Map<String, String> entryMap : LanguageRegistryInitializer.getLanguageSubTagRegistryEntries(REGISTRY_FILE)) {
                if (!REGION.equals(entryMap.get(TYPE))) continue;
                String subTag = entryMap.get(SUBTAG);
                String deprecated = entryMap.get(DEPRECATED);
                if (subTag == null || PRIVATE_USE_REGION_SUBTAG_1.equalsIgnoreCase(subTag) || PRIVATE_USE_REGION_SUBTAG_2.equalsIgnoreCase(subTag) || deprecated != null) continue;
                regions.add(subTag.toLowerCase());
            }
            return regions;
        }

        private static Map<String, List<String>> buildVariants() {
            HashMap<String, List<String>> variants = new HashMap<String, List<String>>();
            for (Map<String, String> entryMap : LanguageRegistryInitializer.getLanguageSubTagRegistryEntries(REGISTRY_FILE)) {
                if (!VARIANT.equals(entryMap.get(TYPE))) continue;
                String subTag = entryMap.get(SUBTAG);
                String deprecated = entryMap.get(DEPRECATED);
                if (subTag == null || deprecated != null) continue;
                ArrayList<String> prefixList = new ArrayList<String>();
                String prefix = entryMap.get(PREFIX);
                if (prefix != null) {
                    String[] prefixes;
                    for (String prefixPart : prefixes = prefix.split(",")) {
                        prefixList.add(prefixPart.trim().toLowerCase());
                    }
                }
                variants.put(subTag.toLowerCase(), prefixList);
            }
            return variants;
        }

        private static Set<String> buildGrandfathereds() {
            HashSet<String> grandfathereds = new HashSet<String>();
            for (Map<String, String> entryMap : LanguageRegistryInitializer.getLanguageSubTagRegistryEntries(REGISTRY_FILE)) {
                if (!GRANDFATHERED.equals(entryMap.get(TYPE))) continue;
                String tag = entryMap.get(TAG);
                String deprecated = entryMap.get(DEPRECATED);
                if (tag == null || deprecated != null) continue;
                grandfathereds.add(tag.toLowerCase());
            }
            return grandfathereds;
        }

        private static List<Map<String, String>> getLanguageSubTagRegistryEntries(String path) {
            ArrayList<Map<String, String>> registry = new ArrayList<Map<String, String>>();
            HashMap<String, String> curEntry = new HashMap<String, String>();
            String curKey = null;
            String curValue = null;
            try (BufferedReader reader = LanguageRegistryInitializer.getBufferedReader(path);){
                int rowNum = 1;
                while (true) {
                    String fileLine;
                    if ((fileLine = reader.readLine()) == null) {
                        if (!curEntry.isEmpty()) {
                            registry.add(curEntry);
                        }
                        break;
                    }
                    if (RECORD_DELIMITER.equals(fileLine)) {
                        if (!curEntry.isEmpty()) {
                            registry.add(curEntry);
                        }
                        curEntry = new HashMap();
                        curKey = null;
                        curValue = null;
                    } else if (!fileLine.startsWith(FILE_DATE_ROW)) {
                        String[] entryParts = fileLine.split(ROW_DELIMITER);
                        if (entryParts.length == 2 && !entryParts[0].trim().isEmpty() && !entryParts[1].trim().isEmpty()) {
                            curKey = entryParts[0].trim();
                            String existingValue = (String)curEntry.get(curKey);
                            curValue = ((String)(existingValue != null ? existingValue + ", " + entryParts[1] : entryParts[1])).trim();
                            curEntry.put(curKey, curValue);
                        } else if (entryParts.length == 1 && !entryParts[0].trim().isEmpty() && curKey != null && curValue != null) {
                            curValue = (curValue + entryParts[0]).trim();
                        } else {
                            throw new RuntimeException("Invalid language subtag registry file, rowNum: " + rowNum + ", fileLine: " + fileLine);
                        }
                    }
                    ++rowNum;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
            return registry;
        }

        private static BufferedReader getBufferedReader(String filePath) throws IOException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(filePath);
            if (is == null) {
                is = LanguageRegistryInitializer.class.getResourceAsStream(filePath);
            }
            if (is == null) {
                throw new FileNotFoundException("File not found: " + filePath);
            }
            return new BufferedReader(new InputStreamReader(is));
        }
    }
}

