/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.lang.util;

import java.util.ArrayList;
import java.util.List;
import org.linuxforhealth.fhir.model.lang.util.LanguageRegistry;

public class LanguageRegistryUtil {
    private LanguageRegistryUtil() {
    }

    public static void init() {
        LanguageRegistry.init();
    }

    public static boolean isValidLanguageTag(String tag) {
        if (tag == null || tag.isEmpty() || tag.indexOf("--") > -1 || !tag.matches("^[a-zA-Z0-9-]+$")) {
            return false;
        }
        if (LanguageRegistry.isGrandfatheredTag(tag = tag.toLowerCase())) {
            return true;
        }
        if (LanguageRegistryUtil.containsExtensionOrPrivateUseSubtags(tag)) {
            return false;
        }
        String[] subtags = tag.split("-");
        if (subtags.length < 1) {
            return false;
        }
        String language = subtags[0];
        if (!LanguageRegistry.isLanguageSubtag(language)) {
            return false;
        }
        if (subtags.length > 1) {
            String extlangFound = null;
            String scriptFound = null;
            String regionFound = null;
            ArrayList<String> variantWithPrefixesFound = new ArrayList<String>();
            ArrayList<String> variantsWithoutPrefixesFound = new ArrayList<String>();
            for (int i = 1; i < subtags.length; ++i) {
                String subtag = subtags[i];
                if (LanguageRegistry.isExtlangSubtag(subtag)) {
                    if (extlangFound != null || scriptFound != null || regionFound != null || !variantWithPrefixesFound.isEmpty() || !variantWithPrefixesFound.isEmpty()) {
                        return false;
                    }
                    extlangFound = subtag;
                    continue;
                }
                if (LanguageRegistry.isScriptSubtag(subtag)) {
                    if (scriptFound != null || regionFound != null || !variantWithPrefixesFound.isEmpty() || !variantWithPrefixesFound.isEmpty()) {
                        return false;
                    }
                    scriptFound = subtag;
                    continue;
                }
                if (LanguageRegistry.isRegionSubtag(subtag)) {
                    if (regionFound != null || !variantWithPrefixesFound.isEmpty() || !variantWithPrefixesFound.isEmpty()) {
                        return false;
                    }
                    regionFound = subtag;
                    continue;
                }
                if (LanguageRegistry.isVariantSubtag(subtag)) {
                    if (variantWithPrefixesFound.contains(subtag) || variantsWithoutPrefixesFound.contains(subtag)) {
                        return false;
                    }
                    List<String> variantPrefixes = LanguageRegistry.getVariantPrefixes(subtag);
                    if (!variantPrefixes.isEmpty()) {
                        if (!variantsWithoutPrefixesFound.isEmpty()) {
                            return false;
                        }
                        StringBuilder prefixToCheck1Sb = new StringBuilder(language);
                        StringBuilder prefixToCheck2Sb = new StringBuilder(language);
                        if (extlangFound != null) {
                            prefixToCheck1Sb.append("-").append(extlangFound);
                            prefixToCheck2Sb.append("-").append(extlangFound);
                        }
                        if (scriptFound != null) {
                            prefixToCheck1Sb.append("-").append(scriptFound);
                            prefixToCheck2Sb.append("-").append(scriptFound);
                        }
                        if (regionFound != null) {
                            prefixToCheck1Sb.append("-").append(regionFound);
                        }
                        for (String variantWithPrefixFound : variantWithPrefixesFound) {
                            prefixToCheck1Sb.append("-").append(variantWithPrefixFound);
                            prefixToCheck2Sb.append("-").append(variantWithPrefixFound);
                        }
                        if (!variantPrefixes.contains(prefixToCheck1Sb.toString()) && !variantPrefixes.contains(prefixToCheck2Sb.toString())) {
                            return false;
                        }
                        variantWithPrefixesFound.add(subtag);
                        continue;
                    }
                    variantsWithoutPrefixesFound.add(subtag);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean containsExtensionOrPrivateUseSubtags(String tag) {
        return tag.matches("^.-") || tag.matches("-.-");
    }
}

