/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.parser;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import java.util.StringJoiner;
import net.jcip.annotations.NotThreadSafe;
import org.linuxforhealth.fhir.model.parser.FHIRAbstractParser;
import org.linuxforhealth.fhir.model.parser.exception.FHIRParserException;
import org.linuxforhealth.fhir.model.resource.Account;
import org.linuxforhealth.fhir.model.resource.ActivityDefinition;
import org.linuxforhealth.fhir.model.resource.AdministrableProductDefinition;
import org.linuxforhealth.fhir.model.resource.AdverseEvent;
import org.linuxforhealth.fhir.model.resource.AllergyIntolerance;
import org.linuxforhealth.fhir.model.resource.Appointment;
import org.linuxforhealth.fhir.model.resource.AppointmentResponse;
import org.linuxforhealth.fhir.model.resource.AuditEvent;
import org.linuxforhealth.fhir.model.resource.Basic;
import org.linuxforhealth.fhir.model.resource.Binary;
import org.linuxforhealth.fhir.model.resource.BiologicallyDerivedProduct;
import org.linuxforhealth.fhir.model.resource.BodyStructure;
import org.linuxforhealth.fhir.model.resource.Bundle;
import org.linuxforhealth.fhir.model.resource.CapabilityStatement;
import org.linuxforhealth.fhir.model.resource.CarePlan;
import org.linuxforhealth.fhir.model.resource.CareTeam;
import org.linuxforhealth.fhir.model.resource.CatalogEntry;
import org.linuxforhealth.fhir.model.resource.ChargeItem;
import org.linuxforhealth.fhir.model.resource.ChargeItemDefinition;
import org.linuxforhealth.fhir.model.resource.Citation;
import org.linuxforhealth.fhir.model.resource.Claim;
import org.linuxforhealth.fhir.model.resource.ClaimResponse;
import org.linuxforhealth.fhir.model.resource.ClinicalImpression;
import org.linuxforhealth.fhir.model.resource.ClinicalUseDefinition;
import org.linuxforhealth.fhir.model.resource.CodeSystem;
import org.linuxforhealth.fhir.model.resource.Communication;
import org.linuxforhealth.fhir.model.resource.CommunicationRequest;
import org.linuxforhealth.fhir.model.resource.CompartmentDefinition;
import org.linuxforhealth.fhir.model.resource.Composition;
import org.linuxforhealth.fhir.model.resource.ConceptMap;
import org.linuxforhealth.fhir.model.resource.Condition;
import org.linuxforhealth.fhir.model.resource.Consent;
import org.linuxforhealth.fhir.model.resource.Contract;
import org.linuxforhealth.fhir.model.resource.Coverage;
import org.linuxforhealth.fhir.model.resource.CoverageEligibilityRequest;
import org.linuxforhealth.fhir.model.resource.CoverageEligibilityResponse;
import org.linuxforhealth.fhir.model.resource.DetectedIssue;
import org.linuxforhealth.fhir.model.resource.Device;
import org.linuxforhealth.fhir.model.resource.DeviceDefinition;
import org.linuxforhealth.fhir.model.resource.DeviceMetric;
import org.linuxforhealth.fhir.model.resource.DeviceRequest;
import org.linuxforhealth.fhir.model.resource.DeviceUseStatement;
import org.linuxforhealth.fhir.model.resource.DiagnosticReport;
import org.linuxforhealth.fhir.model.resource.DocumentManifest;
import org.linuxforhealth.fhir.model.resource.DocumentReference;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Encounter;
import org.linuxforhealth.fhir.model.resource.Endpoint;
import org.linuxforhealth.fhir.model.resource.EnrollmentRequest;
import org.linuxforhealth.fhir.model.resource.EnrollmentResponse;
import org.linuxforhealth.fhir.model.resource.EpisodeOfCare;
import org.linuxforhealth.fhir.model.resource.EventDefinition;
import org.linuxforhealth.fhir.model.resource.Evidence;
import org.linuxforhealth.fhir.model.resource.EvidenceReport;
import org.linuxforhealth.fhir.model.resource.EvidenceVariable;
import org.linuxforhealth.fhir.model.resource.ExampleScenario;
import org.linuxforhealth.fhir.model.resource.ExplanationOfBenefit;
import org.linuxforhealth.fhir.model.resource.FamilyMemberHistory;
import org.linuxforhealth.fhir.model.resource.Flag;
import org.linuxforhealth.fhir.model.resource.Goal;
import org.linuxforhealth.fhir.model.resource.GraphDefinition;
import org.linuxforhealth.fhir.model.resource.Group;
import org.linuxforhealth.fhir.model.resource.GuidanceResponse;
import org.linuxforhealth.fhir.model.resource.HealthcareService;
import org.linuxforhealth.fhir.model.resource.ImagingStudy;
import org.linuxforhealth.fhir.model.resource.Immunization;
import org.linuxforhealth.fhir.model.resource.ImmunizationEvaluation;
import org.linuxforhealth.fhir.model.resource.ImmunizationRecommendation;
import org.linuxforhealth.fhir.model.resource.ImplementationGuide;
import org.linuxforhealth.fhir.model.resource.Ingredient;
import org.linuxforhealth.fhir.model.resource.InsurancePlan;
import org.linuxforhealth.fhir.model.resource.Invoice;
import org.linuxforhealth.fhir.model.resource.Library;
import org.linuxforhealth.fhir.model.resource.Linkage;
import org.linuxforhealth.fhir.model.resource.List;
import org.linuxforhealth.fhir.model.resource.Location;
import org.linuxforhealth.fhir.model.resource.ManufacturedItemDefinition;
import org.linuxforhealth.fhir.model.resource.Measure;
import org.linuxforhealth.fhir.model.resource.MeasureReport;
import org.linuxforhealth.fhir.model.resource.Media;
import org.linuxforhealth.fhir.model.resource.Medication;
import org.linuxforhealth.fhir.model.resource.MedicationAdministration;
import org.linuxforhealth.fhir.model.resource.MedicationDispense;
import org.linuxforhealth.fhir.model.resource.MedicationKnowledge;
import org.linuxforhealth.fhir.model.resource.MedicationRequest;
import org.linuxforhealth.fhir.model.resource.MedicationStatement;
import org.linuxforhealth.fhir.model.resource.MedicinalProductDefinition;
import org.linuxforhealth.fhir.model.resource.MessageDefinition;
import org.linuxforhealth.fhir.model.resource.MessageHeader;
import org.linuxforhealth.fhir.model.resource.MolecularSequence;
import org.linuxforhealth.fhir.model.resource.NamingSystem;
import org.linuxforhealth.fhir.model.resource.NutritionOrder;
import org.linuxforhealth.fhir.model.resource.NutritionProduct;
import org.linuxforhealth.fhir.model.resource.Observation;
import org.linuxforhealth.fhir.model.resource.ObservationDefinition;
import org.linuxforhealth.fhir.model.resource.OperationDefinition;
import org.linuxforhealth.fhir.model.resource.OperationOutcome;
import org.linuxforhealth.fhir.model.resource.Organization;
import org.linuxforhealth.fhir.model.resource.OrganizationAffiliation;
import org.linuxforhealth.fhir.model.resource.PackagedProductDefinition;
import org.linuxforhealth.fhir.model.resource.Parameters;
import org.linuxforhealth.fhir.model.resource.Patient;
import org.linuxforhealth.fhir.model.resource.PaymentNotice;
import org.linuxforhealth.fhir.model.resource.PaymentReconciliation;
import org.linuxforhealth.fhir.model.resource.Person;
import org.linuxforhealth.fhir.model.resource.PlanDefinition;
import org.linuxforhealth.fhir.model.resource.Practitioner;
import org.linuxforhealth.fhir.model.resource.PractitionerRole;
import org.linuxforhealth.fhir.model.resource.Procedure;
import org.linuxforhealth.fhir.model.resource.Provenance;
import org.linuxforhealth.fhir.model.resource.Questionnaire;
import org.linuxforhealth.fhir.model.resource.QuestionnaireResponse;
import org.linuxforhealth.fhir.model.resource.RegulatedAuthorization;
import org.linuxforhealth.fhir.model.resource.RelatedPerson;
import org.linuxforhealth.fhir.model.resource.RequestGroup;
import org.linuxforhealth.fhir.model.resource.ResearchDefinition;
import org.linuxforhealth.fhir.model.resource.ResearchElementDefinition;
import org.linuxforhealth.fhir.model.resource.ResearchStudy;
import org.linuxforhealth.fhir.model.resource.ResearchSubject;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.resource.RiskAssessment;
import org.linuxforhealth.fhir.model.resource.Schedule;
import org.linuxforhealth.fhir.model.resource.SearchParameter;
import org.linuxforhealth.fhir.model.resource.ServiceRequest;
import org.linuxforhealth.fhir.model.resource.Slot;
import org.linuxforhealth.fhir.model.resource.Specimen;
import org.linuxforhealth.fhir.model.resource.SpecimenDefinition;
import org.linuxforhealth.fhir.model.resource.StructureDefinition;
import org.linuxforhealth.fhir.model.resource.StructureMap;
import org.linuxforhealth.fhir.model.resource.Subscription;
import org.linuxforhealth.fhir.model.resource.SubscriptionStatus;
import org.linuxforhealth.fhir.model.resource.SubscriptionTopic;
import org.linuxforhealth.fhir.model.resource.Substance;
import org.linuxforhealth.fhir.model.resource.SubstanceDefinition;
import org.linuxforhealth.fhir.model.resource.SupplyDelivery;
import org.linuxforhealth.fhir.model.resource.SupplyRequest;
import org.linuxforhealth.fhir.model.resource.Task;
import org.linuxforhealth.fhir.model.resource.TerminologyCapabilities;
import org.linuxforhealth.fhir.model.resource.TestReport;
import org.linuxforhealth.fhir.model.resource.TestScript;
import org.linuxforhealth.fhir.model.resource.ValueSet;
import org.linuxforhealth.fhir.model.resource.VerificationResult;
import org.linuxforhealth.fhir.model.resource.VisionPrescription;
import org.linuxforhealth.fhir.model.type.Address;
import org.linuxforhealth.fhir.model.type.Age;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Contributor;
import org.linuxforhealth.fhir.model.type.Count;
import org.linuxforhealth.fhir.model.type.DataRequirement;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Distance;
import org.linuxforhealth.fhir.model.type.Dosage;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.ElementDefinition;
import org.linuxforhealth.fhir.model.type.Expression;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.HumanName;
import org.linuxforhealth.fhir.model.type.Id;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.MarketingStatus;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Money;
import org.linuxforhealth.fhir.model.type.MoneyQuantity;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Oid;
import org.linuxforhealth.fhir.model.type.ParameterDefinition;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Population;
import org.linuxforhealth.fhir.model.type.PositiveInt;
import org.linuxforhealth.fhir.model.type.ProdCharacteristic;
import org.linuxforhealth.fhir.model.type.ProductShelfLife;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Ratio;
import org.linuxforhealth.fhir.model.type.RatioRange;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.RelatedArtifact;
import org.linuxforhealth.fhir.model.type.SampledData;
import org.linuxforhealth.fhir.model.type.Signature;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Time;
import org.linuxforhealth.fhir.model.type.Timing;
import org.linuxforhealth.fhir.model.type.TriggerDefinition;
import org.linuxforhealth.fhir.model.type.UnsignedInt;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.Url;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.Uuid;
import org.linuxforhealth.fhir.model.type.Xhtml;
import org.linuxforhealth.fhir.model.type.code.AccountStatus;
import org.linuxforhealth.fhir.model.type.code.ActionCardinalityBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionConditionKind;
import org.linuxforhealth.fhir.model.type.code.ActionGroupingBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionParticipantType;
import org.linuxforhealth.fhir.model.type.code.ActionPrecheckBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionRelationshipType;
import org.linuxforhealth.fhir.model.type.code.ActionRequiredBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionSelectionBehavior;
import org.linuxforhealth.fhir.model.type.code.ActivityDefinitionKind;
import org.linuxforhealth.fhir.model.type.code.ActivityParticipantType;
import org.linuxforhealth.fhir.model.type.code.AddressType;
import org.linuxforhealth.fhir.model.type.code.AddressUse;
import org.linuxforhealth.fhir.model.type.code.AdministrativeGender;
import org.linuxforhealth.fhir.model.type.code.AdverseEventActuality;
import org.linuxforhealth.fhir.model.type.code.AggregationMode;
import org.linuxforhealth.fhir.model.type.code.AllergyIntoleranceCategory;
import org.linuxforhealth.fhir.model.type.code.AllergyIntoleranceCriticality;
import org.linuxforhealth.fhir.model.type.code.AllergyIntoleranceSeverity;
import org.linuxforhealth.fhir.model.type.code.AllergyIntoleranceType;
import org.linuxforhealth.fhir.model.type.code.AppointmentStatus;
import org.linuxforhealth.fhir.model.type.code.AssertionDirectionType;
import org.linuxforhealth.fhir.model.type.code.AssertionOperatorType;
import org.linuxforhealth.fhir.model.type.code.AssertionResponseTypes;
import org.linuxforhealth.fhir.model.type.code.AuditEventAction;
import org.linuxforhealth.fhir.model.type.code.AuditEventAgentNetworkType;
import org.linuxforhealth.fhir.model.type.code.AuditEventOutcome;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.BiologicallyDerivedProductCategory;
import org.linuxforhealth.fhir.model.type.code.BiologicallyDerivedProductStatus;
import org.linuxforhealth.fhir.model.type.code.BiologicallyDerivedProductStorageScale;
import org.linuxforhealth.fhir.model.type.code.BundleType;
import org.linuxforhealth.fhir.model.type.code.CapabilityStatementKind;
import org.linuxforhealth.fhir.model.type.code.CarePlanActivityKind;
import org.linuxforhealth.fhir.model.type.code.CarePlanActivityStatus;
import org.linuxforhealth.fhir.model.type.code.CarePlanIntent;
import org.linuxforhealth.fhir.model.type.code.CarePlanStatus;
import org.linuxforhealth.fhir.model.type.code.CareTeamStatus;
import org.linuxforhealth.fhir.model.type.code.CatalogEntryRelationType;
import org.linuxforhealth.fhir.model.type.code.CharacteristicCombination;
import org.linuxforhealth.fhir.model.type.code.ChargeItemDefinitionPriceComponentType;
import org.linuxforhealth.fhir.model.type.code.ChargeItemStatus;
import org.linuxforhealth.fhir.model.type.code.ClaimResponseStatus;
import org.linuxforhealth.fhir.model.type.code.ClaimStatus;
import org.linuxforhealth.fhir.model.type.code.ClinicalImpressionStatus;
import org.linuxforhealth.fhir.model.type.code.ClinicalUseDefinitionType;
import org.linuxforhealth.fhir.model.type.code.CodeSearchSupport;
import org.linuxforhealth.fhir.model.type.code.CodeSystemContentMode;
import org.linuxforhealth.fhir.model.type.code.CodeSystemHierarchyMeaning;
import org.linuxforhealth.fhir.model.type.code.CommunicationPriority;
import org.linuxforhealth.fhir.model.type.code.CommunicationRequestStatus;
import org.linuxforhealth.fhir.model.type.code.CommunicationStatus;
import org.linuxforhealth.fhir.model.type.code.CompartmentCode;
import org.linuxforhealth.fhir.model.type.code.CompartmentType;
import org.linuxforhealth.fhir.model.type.code.CompositionAttestationMode;
import org.linuxforhealth.fhir.model.type.code.CompositionStatus;
import org.linuxforhealth.fhir.model.type.code.ConceptMapEquivalence;
import org.linuxforhealth.fhir.model.type.code.ConceptMapGroupUnmappedMode;
import org.linuxforhealth.fhir.model.type.code.ConditionalDeleteStatus;
import org.linuxforhealth.fhir.model.type.code.ConditionalReadStatus;
import org.linuxforhealth.fhir.model.type.code.ConsentDataMeaning;
import org.linuxforhealth.fhir.model.type.code.ConsentProvisionType;
import org.linuxforhealth.fhir.model.type.code.ConsentState;
import org.linuxforhealth.fhir.model.type.code.ConstraintSeverity;
import org.linuxforhealth.fhir.model.type.code.ContactPointSystem;
import org.linuxforhealth.fhir.model.type.code.ContactPointUse;
import org.linuxforhealth.fhir.model.type.code.ContractPublicationStatus;
import org.linuxforhealth.fhir.model.type.code.ContractStatus;
import org.linuxforhealth.fhir.model.type.code.ContributorType;
import org.linuxforhealth.fhir.model.type.code.CoverageStatus;
import org.linuxforhealth.fhir.model.type.code.CriteriaNotExistsBehavior;
import org.linuxforhealth.fhir.model.type.code.DayOfWeek;
import org.linuxforhealth.fhir.model.type.code.DaysOfWeek;
import org.linuxforhealth.fhir.model.type.code.DetectedIssueSeverity;
import org.linuxforhealth.fhir.model.type.code.DetectedIssueStatus;
import org.linuxforhealth.fhir.model.type.code.DeviceMetricCalibrationState;
import org.linuxforhealth.fhir.model.type.code.DeviceMetricCalibrationType;
import org.linuxforhealth.fhir.model.type.code.DeviceMetricCategory;
import org.linuxforhealth.fhir.model.type.code.DeviceMetricColor;
import org.linuxforhealth.fhir.model.type.code.DeviceMetricOperationalStatus;
import org.linuxforhealth.fhir.model.type.code.DeviceNameType;
import org.linuxforhealth.fhir.model.type.code.DeviceRequestStatus;
import org.linuxforhealth.fhir.model.type.code.DeviceUseStatementStatus;
import org.linuxforhealth.fhir.model.type.code.DiagnosticReportStatus;
import org.linuxforhealth.fhir.model.type.code.DiscriminatorType;
import org.linuxforhealth.fhir.model.type.code.DocumentConfidentiality;
import org.linuxforhealth.fhir.model.type.code.DocumentMode;
import org.linuxforhealth.fhir.model.type.code.DocumentReferenceStatus;
import org.linuxforhealth.fhir.model.type.code.DocumentRelationshipType;
import org.linuxforhealth.fhir.model.type.code.EligibilityRequestPurpose;
import org.linuxforhealth.fhir.model.type.code.EligibilityRequestStatus;
import org.linuxforhealth.fhir.model.type.code.EligibilityResponsePurpose;
import org.linuxforhealth.fhir.model.type.code.EligibilityResponseStatus;
import org.linuxforhealth.fhir.model.type.code.EnableWhenBehavior;
import org.linuxforhealth.fhir.model.type.code.EncounterLocationStatus;
import org.linuxforhealth.fhir.model.type.code.EncounterStatus;
import org.linuxforhealth.fhir.model.type.code.EndpointStatus;
import org.linuxforhealth.fhir.model.type.code.EnrollmentRequestStatus;
import org.linuxforhealth.fhir.model.type.code.EnrollmentResponseStatus;
import org.linuxforhealth.fhir.model.type.code.EpisodeOfCareStatus;
import org.linuxforhealth.fhir.model.type.code.EventCapabilityMode;
import org.linuxforhealth.fhir.model.type.code.EventTiming;
import org.linuxforhealth.fhir.model.type.code.EvidenceVariableHandling;
import org.linuxforhealth.fhir.model.type.code.ExampleScenarioActorType;
import org.linuxforhealth.fhir.model.type.code.ExplanationOfBenefitStatus;
import org.linuxforhealth.fhir.model.type.code.ExtensionContextType;
import org.linuxforhealth.fhir.model.type.code.FHIRAllTypes;
import org.linuxforhealth.fhir.model.type.code.FHIRDefinedType;
import org.linuxforhealth.fhir.model.type.code.FHIRDeviceStatus;
import org.linuxforhealth.fhir.model.type.code.FHIRSubstanceStatus;
import org.linuxforhealth.fhir.model.type.code.FHIRVersion;
import org.linuxforhealth.fhir.model.type.code.FamilyHistoryStatus;
import org.linuxforhealth.fhir.model.type.code.FilterOperator;
import org.linuxforhealth.fhir.model.type.code.FlagStatus;
import org.linuxforhealth.fhir.model.type.code.GoalLifecycleStatus;
import org.linuxforhealth.fhir.model.type.code.GraphCompartmentRule;
import org.linuxforhealth.fhir.model.type.code.GraphCompartmentUse;
import org.linuxforhealth.fhir.model.type.code.GroupMeasure;
import org.linuxforhealth.fhir.model.type.code.GroupType;
import org.linuxforhealth.fhir.model.type.code.GuidanceResponseStatus;
import org.linuxforhealth.fhir.model.type.code.GuidePageGeneration;
import org.linuxforhealth.fhir.model.type.code.GuideParameterCode;
import org.linuxforhealth.fhir.model.type.code.HTTPVerb;
import org.linuxforhealth.fhir.model.type.code.IdentifierUse;
import org.linuxforhealth.fhir.model.type.code.IdentityAssuranceLevel;
import org.linuxforhealth.fhir.model.type.code.ImagingStudyStatus;
import org.linuxforhealth.fhir.model.type.code.ImmunizationEvaluationStatus;
import org.linuxforhealth.fhir.model.type.code.ImmunizationStatus;
import org.linuxforhealth.fhir.model.type.code.IngredientManufacturerRole;
import org.linuxforhealth.fhir.model.type.code.InvoicePriceComponentType;
import org.linuxforhealth.fhir.model.type.code.InvoiceStatus;
import org.linuxforhealth.fhir.model.type.code.IssueSeverity;
import org.linuxforhealth.fhir.model.type.code.IssueType;
import org.linuxforhealth.fhir.model.type.code.LinkType;
import org.linuxforhealth.fhir.model.type.code.LinkageType;
import org.linuxforhealth.fhir.model.type.code.ListMode;
import org.linuxforhealth.fhir.model.type.code.ListStatus;
import org.linuxforhealth.fhir.model.type.code.LocationMode;
import org.linuxforhealth.fhir.model.type.code.LocationStatus;
import org.linuxforhealth.fhir.model.type.code.MeasureReportStatus;
import org.linuxforhealth.fhir.model.type.code.MeasureReportType;
import org.linuxforhealth.fhir.model.type.code.MediaStatus;
import org.linuxforhealth.fhir.model.type.code.MedicationAdministrationStatus;
import org.linuxforhealth.fhir.model.type.code.MedicationDispenseStatus;
import org.linuxforhealth.fhir.model.type.code.MedicationKnowledgeStatus;
import org.linuxforhealth.fhir.model.type.code.MedicationRequestIntent;
import org.linuxforhealth.fhir.model.type.code.MedicationRequestPriority;
import org.linuxforhealth.fhir.model.type.code.MedicationRequestStatus;
import org.linuxforhealth.fhir.model.type.code.MedicationStatementStatus;
import org.linuxforhealth.fhir.model.type.code.MedicationStatus;
import org.linuxforhealth.fhir.model.type.code.MessageHeaderResponseRequest;
import org.linuxforhealth.fhir.model.type.code.MessageSignificanceCategory;
import org.linuxforhealth.fhir.model.type.code.MethodCode;
import org.linuxforhealth.fhir.model.type.code.NameUse;
import org.linuxforhealth.fhir.model.type.code.NamingSystemIdentifierType;
import org.linuxforhealth.fhir.model.type.code.NamingSystemType;
import org.linuxforhealth.fhir.model.type.code.NarrativeStatus;
import org.linuxforhealth.fhir.model.type.code.NoteType;
import org.linuxforhealth.fhir.model.type.code.NutritionOrderIntent;
import org.linuxforhealth.fhir.model.type.code.NutritionOrderStatus;
import org.linuxforhealth.fhir.model.type.code.NutritionProductStatus;
import org.linuxforhealth.fhir.model.type.code.ObservationDataType;
import org.linuxforhealth.fhir.model.type.code.ObservationRangeCategory;
import org.linuxforhealth.fhir.model.type.code.ObservationStatus;
import org.linuxforhealth.fhir.model.type.code.OperationKind;
import org.linuxforhealth.fhir.model.type.code.OperationParameterUse;
import org.linuxforhealth.fhir.model.type.code.OrientationType;
import org.linuxforhealth.fhir.model.type.code.ParameterUse;
import org.linuxforhealth.fhir.model.type.code.ParticipantRequired;
import org.linuxforhealth.fhir.model.type.code.ParticipantStatus;
import org.linuxforhealth.fhir.model.type.code.ParticipationStatus;
import org.linuxforhealth.fhir.model.type.code.PaymentNoticeStatus;
import org.linuxforhealth.fhir.model.type.code.PaymentReconciliationStatus;
import org.linuxforhealth.fhir.model.type.code.ProcedureStatus;
import org.linuxforhealth.fhir.model.type.code.PropertyRepresentation;
import org.linuxforhealth.fhir.model.type.code.PropertyType;
import org.linuxforhealth.fhir.model.type.code.ProvenanceEntityRole;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.QualityType;
import org.linuxforhealth.fhir.model.type.code.QuantityComparator;
import org.linuxforhealth.fhir.model.type.code.QuestionnaireItemOperator;
import org.linuxforhealth.fhir.model.type.code.QuestionnaireItemType;
import org.linuxforhealth.fhir.model.type.code.QuestionnaireResponseStatus;
import org.linuxforhealth.fhir.model.type.code.ReferenceHandlingPolicy;
import org.linuxforhealth.fhir.model.type.code.ReferenceVersionRules;
import org.linuxforhealth.fhir.model.type.code.ReferredDocumentStatus;
import org.linuxforhealth.fhir.model.type.code.RelatedArtifactType;
import org.linuxforhealth.fhir.model.type.code.RemittanceOutcome;
import org.linuxforhealth.fhir.model.type.code.ReportRelationshipType;
import org.linuxforhealth.fhir.model.type.code.RepositoryType;
import org.linuxforhealth.fhir.model.type.code.RequestIntent;
import org.linuxforhealth.fhir.model.type.code.RequestPriority;
import org.linuxforhealth.fhir.model.type.code.RequestStatus;
import org.linuxforhealth.fhir.model.type.code.ResearchElementType;
import org.linuxforhealth.fhir.model.type.code.ResearchStudyStatus;
import org.linuxforhealth.fhir.model.type.code.ResearchSubjectStatus;
import org.linuxforhealth.fhir.model.type.code.ResourceTypeCode;
import org.linuxforhealth.fhir.model.type.code.ResourceVersionPolicy;
import org.linuxforhealth.fhir.model.type.code.ResponseType;
import org.linuxforhealth.fhir.model.type.code.RestfulCapabilityMode;
import org.linuxforhealth.fhir.model.type.code.RiskAssessmentStatus;
import org.linuxforhealth.fhir.model.type.code.SPDXLicense;
import org.linuxforhealth.fhir.model.type.code.SearchComparator;
import org.linuxforhealth.fhir.model.type.code.SearchEntryMode;
import org.linuxforhealth.fhir.model.type.code.SearchModifierCode;
import org.linuxforhealth.fhir.model.type.code.SearchParamType;
import org.linuxforhealth.fhir.model.type.code.SectionMode;
import org.linuxforhealth.fhir.model.type.code.SequenceType;
import org.linuxforhealth.fhir.model.type.code.ServiceRequestIntent;
import org.linuxforhealth.fhir.model.type.code.ServiceRequestPriority;
import org.linuxforhealth.fhir.model.type.code.ServiceRequestStatus;
import org.linuxforhealth.fhir.model.type.code.SlicingRules;
import org.linuxforhealth.fhir.model.type.code.SlotStatus;
import org.linuxforhealth.fhir.model.type.code.SortDirection;
import org.linuxforhealth.fhir.model.type.code.SpecimenContainedPreference;
import org.linuxforhealth.fhir.model.type.code.SpecimenStatus;
import org.linuxforhealth.fhir.model.type.code.Status;
import org.linuxforhealth.fhir.model.type.code.StrandType;
import org.linuxforhealth.fhir.model.type.code.StructureDefinitionKind;
import org.linuxforhealth.fhir.model.type.code.StructureMapContextType;
import org.linuxforhealth.fhir.model.type.code.StructureMapGroupTypeMode;
import org.linuxforhealth.fhir.model.type.code.StructureMapInputMode;
import org.linuxforhealth.fhir.model.type.code.StructureMapModelMode;
import org.linuxforhealth.fhir.model.type.code.StructureMapSourceListMode;
import org.linuxforhealth.fhir.model.type.code.StructureMapTargetListMode;
import org.linuxforhealth.fhir.model.type.code.StructureMapTransform;
import org.linuxforhealth.fhir.model.type.code.SubscriptionChannelType;
import org.linuxforhealth.fhir.model.type.code.SubscriptionNotificationType;
import org.linuxforhealth.fhir.model.type.code.SubscriptionStatusCode;
import org.linuxforhealth.fhir.model.type.code.SubscriptionTopicFilterBySearchModifier;
import org.linuxforhealth.fhir.model.type.code.SupplyDeliveryStatus;
import org.linuxforhealth.fhir.model.type.code.SupplyRequestStatus;
import org.linuxforhealth.fhir.model.type.code.SystemRestfulInteraction;
import org.linuxforhealth.fhir.model.type.code.TaskIntent;
import org.linuxforhealth.fhir.model.type.code.TaskPriority;
import org.linuxforhealth.fhir.model.type.code.TaskStatus;
import org.linuxforhealth.fhir.model.type.code.TestReportActionResult;
import org.linuxforhealth.fhir.model.type.code.TestReportParticipantType;
import org.linuxforhealth.fhir.model.type.code.TestReportResult;
import org.linuxforhealth.fhir.model.type.code.TestReportStatus;
import org.linuxforhealth.fhir.model.type.code.TestScriptRequestMethodCode;
import org.linuxforhealth.fhir.model.type.code.TriggerType;
import org.linuxforhealth.fhir.model.type.code.TypeDerivationRule;
import org.linuxforhealth.fhir.model.type.code.TypeRestfulInteraction;
import org.linuxforhealth.fhir.model.type.code.UDIEntryType;
import org.linuxforhealth.fhir.model.type.code.UnitsOfTime;
import org.linuxforhealth.fhir.model.type.code.Use;
import org.linuxforhealth.fhir.model.type.code.VariableType;
import org.linuxforhealth.fhir.model.type.code.VisionBase;
import org.linuxforhealth.fhir.model.type.code.VisionEyes;
import org.linuxforhealth.fhir.model.type.code.VisionStatus;
import org.linuxforhealth.fhir.model.type.code.XPathUsageType;
import org.linuxforhealth.fhir.model.util.ElementFilter;
import org.linuxforhealth.fhir.model.util.JsonSupport;
import org.linuxforhealth.fhir.model.util.ModelSupport;

@NotThreadSafe
public class FHIRJsonParser
extends FHIRAbstractParser {
    public static boolean DEBUG = false;
    private static final JsonReaderFactory JSON_READER_FACTORY = Json.createReaderFactory(Collections.singletonMap("org.eclipse.parsson.rejectDuplicateKeys", true));
    private final Stack<String> stack = new Stack();

    FHIRJsonParser() {
    }

    @Override
    public <T extends Resource> T parse(InputStream in) throws FHIRParserException {
        return this.parseAndFilter(in, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Resource> T parseAndFilter(InputStream in, Collection<String> elementsToInclude) throws FHIRParserException {
        try (JsonReader jsonReader = JSON_READER_FACTORY.createReader(JsonSupport.nonClosingInputStream(in), StandardCharsets.UTF_8);){
            JsonObject jsonObject = jsonReader.readObject();
            T t = this.parseAndFilter(jsonObject, elementsToInclude);
            return t;
        }
        catch (FHIRParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    @Override
    public <T extends Resource> T parse(Reader reader) throws FHIRParserException {
        return this.parseAndFilter(reader, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Resource> T parseAndFilter(Reader reader, Collection<String> elementsToInclude) throws FHIRParserException {
        try (JsonReader jsonReader = JSON_READER_FACTORY.createReader(JsonSupport.nonClosingReader(reader));){
            JsonObject jsonObject = jsonReader.readObject();
            T t = this.parseAndFilter(jsonObject, elementsToInclude);
            return t;
        }
        catch (FHIRParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    public <T extends Resource> T parse(JsonObject jsonObject) throws FHIRParserException {
        return this.parseAndFilter(jsonObject, null);
    }

    public <T extends Resource> T parseAndFilter(JsonObject jsonObject, Collection<String> elementsToInclude) throws FHIRParserException {
        try {
            this.reset();
            Class<?> resourceType = JsonSupport.getResourceType(jsonObject);
            if (elementsToInclude != null) {
                ElementFilter elementFilter = new ElementFilter(resourceType, elementsToInclude);
                jsonObject = elementFilter.apply(jsonObject);
            }
            return (T)this.parseResource(resourceType.getSimpleName(), jsonObject, -1);
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    private void reset() {
        this.stack.clear();
    }

    private Resource parseResource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        Class<?> resourceType = JsonSupport.getResourceType(jsonObject);
        switch (resourceType.getSimpleName()) {
            case "Account": {
                return this.parseAccount(elementName, jsonObject, elementIndex);
            }
            case "ActivityDefinition": {
                return this.parseActivityDefinition(elementName, jsonObject, elementIndex);
            }
            case "AdministrableProductDefinition": {
                return this.parseAdministrableProductDefinition(elementName, jsonObject, elementIndex);
            }
            case "AdverseEvent": {
                return this.parseAdverseEvent(elementName, jsonObject, elementIndex);
            }
            case "AllergyIntolerance": {
                return this.parseAllergyIntolerance(elementName, jsonObject, elementIndex);
            }
            case "Appointment": {
                return this.parseAppointment(elementName, jsonObject, elementIndex);
            }
            case "AppointmentResponse": {
                return this.parseAppointmentResponse(elementName, jsonObject, elementIndex);
            }
            case "AuditEvent": {
                return this.parseAuditEvent(elementName, jsonObject, elementIndex);
            }
            case "Basic": {
                return this.parseBasic(elementName, jsonObject, elementIndex);
            }
            case "Binary": {
                return this.parseBinary(elementName, jsonObject, elementIndex);
            }
            case "BiologicallyDerivedProduct": {
                return this.parseBiologicallyDerivedProduct(elementName, jsonObject, elementIndex);
            }
            case "BodyStructure": {
                return this.parseBodyStructure(elementName, jsonObject, elementIndex);
            }
            case "Bundle": {
                return this.parseBundle(elementName, jsonObject, elementIndex);
            }
            case "CapabilityStatement": {
                return this.parseCapabilityStatement(elementName, jsonObject, elementIndex);
            }
            case "CarePlan": {
                return this.parseCarePlan(elementName, jsonObject, elementIndex);
            }
            case "CareTeam": {
                return this.parseCareTeam(elementName, jsonObject, elementIndex);
            }
            case "CatalogEntry": {
                return this.parseCatalogEntry(elementName, jsonObject, elementIndex);
            }
            case "ChargeItem": {
                return this.parseChargeItem(elementName, jsonObject, elementIndex);
            }
            case "ChargeItemDefinition": {
                return this.parseChargeItemDefinition(elementName, jsonObject, elementIndex);
            }
            case "Citation": {
                return this.parseCitation(elementName, jsonObject, elementIndex);
            }
            case "Claim": {
                return this.parseClaim(elementName, jsonObject, elementIndex);
            }
            case "ClaimResponse": {
                return this.parseClaimResponse(elementName, jsonObject, elementIndex);
            }
            case "ClinicalImpression": {
                return this.parseClinicalImpression(elementName, jsonObject, elementIndex);
            }
            case "ClinicalUseDefinition": {
                return this.parseClinicalUseDefinition(elementName, jsonObject, elementIndex);
            }
            case "CodeSystem": {
                return this.parseCodeSystem(elementName, jsonObject, elementIndex);
            }
            case "Communication": {
                return this.parseCommunication(elementName, jsonObject, elementIndex);
            }
            case "CommunicationRequest": {
                return this.parseCommunicationRequest(elementName, jsonObject, elementIndex);
            }
            case "CompartmentDefinition": {
                return this.parseCompartmentDefinition(elementName, jsonObject, elementIndex);
            }
            case "Composition": {
                return this.parseComposition(elementName, jsonObject, elementIndex);
            }
            case "ConceptMap": {
                return this.parseConceptMap(elementName, jsonObject, elementIndex);
            }
            case "Condition": {
                return this.parseCondition(elementName, jsonObject, elementIndex);
            }
            case "Consent": {
                return this.parseConsent(elementName, jsonObject, elementIndex);
            }
            case "Contract": {
                return this.parseContract(elementName, jsonObject, elementIndex);
            }
            case "Coverage": {
                return this.parseCoverage(elementName, jsonObject, elementIndex);
            }
            case "CoverageEligibilityRequest": {
                return this.parseCoverageEligibilityRequest(elementName, jsonObject, elementIndex);
            }
            case "CoverageEligibilityResponse": {
                return this.parseCoverageEligibilityResponse(elementName, jsonObject, elementIndex);
            }
            case "DetectedIssue": {
                return this.parseDetectedIssue(elementName, jsonObject, elementIndex);
            }
            case "Device": {
                return this.parseDevice(elementName, jsonObject, elementIndex);
            }
            case "DeviceDefinition": {
                return this.parseDeviceDefinition(elementName, jsonObject, elementIndex);
            }
            case "DeviceMetric": {
                return this.parseDeviceMetric(elementName, jsonObject, elementIndex);
            }
            case "DeviceRequest": {
                return this.parseDeviceRequest(elementName, jsonObject, elementIndex);
            }
            case "DeviceUseStatement": {
                return this.parseDeviceUseStatement(elementName, jsonObject, elementIndex);
            }
            case "DiagnosticReport": {
                return this.parseDiagnosticReport(elementName, jsonObject, elementIndex);
            }
            case "DocumentManifest": {
                return this.parseDocumentManifest(elementName, jsonObject, elementIndex);
            }
            case "DocumentReference": {
                return this.parseDocumentReference(elementName, jsonObject, elementIndex);
            }
            case "Encounter": {
                return this.parseEncounter(elementName, jsonObject, elementIndex);
            }
            case "Endpoint": {
                return this.parseEndpoint(elementName, jsonObject, elementIndex);
            }
            case "EnrollmentRequest": {
                return this.parseEnrollmentRequest(elementName, jsonObject, elementIndex);
            }
            case "EnrollmentResponse": {
                return this.parseEnrollmentResponse(elementName, jsonObject, elementIndex);
            }
            case "EpisodeOfCare": {
                return this.parseEpisodeOfCare(elementName, jsonObject, elementIndex);
            }
            case "EventDefinition": {
                return this.parseEventDefinition(elementName, jsonObject, elementIndex);
            }
            case "Evidence": {
                return this.parseEvidence(elementName, jsonObject, elementIndex);
            }
            case "EvidenceReport": {
                return this.parseEvidenceReport(elementName, jsonObject, elementIndex);
            }
            case "EvidenceVariable": {
                return this.parseEvidenceVariable(elementName, jsonObject, elementIndex);
            }
            case "ExampleScenario": {
                return this.parseExampleScenario(elementName, jsonObject, elementIndex);
            }
            case "ExplanationOfBenefit": {
                return this.parseExplanationOfBenefit(elementName, jsonObject, elementIndex);
            }
            case "FamilyMemberHistory": {
                return this.parseFamilyMemberHistory(elementName, jsonObject, elementIndex);
            }
            case "Flag": {
                return this.parseFlag(elementName, jsonObject, elementIndex);
            }
            case "Goal": {
                return this.parseGoal(elementName, jsonObject, elementIndex);
            }
            case "GraphDefinition": {
                return this.parseGraphDefinition(elementName, jsonObject, elementIndex);
            }
            case "Group": {
                return this.parseGroup(elementName, jsonObject, elementIndex);
            }
            case "GuidanceResponse": {
                return this.parseGuidanceResponse(elementName, jsonObject, elementIndex);
            }
            case "HealthcareService": {
                return this.parseHealthcareService(elementName, jsonObject, elementIndex);
            }
            case "ImagingStudy": {
                return this.parseImagingStudy(elementName, jsonObject, elementIndex);
            }
            case "Immunization": {
                return this.parseImmunization(elementName, jsonObject, elementIndex);
            }
            case "ImmunizationEvaluation": {
                return this.parseImmunizationEvaluation(elementName, jsonObject, elementIndex);
            }
            case "ImmunizationRecommendation": {
                return this.parseImmunizationRecommendation(elementName, jsonObject, elementIndex);
            }
            case "ImplementationGuide": {
                return this.parseImplementationGuide(elementName, jsonObject, elementIndex);
            }
            case "Ingredient": {
                return this.parseIngredient(elementName, jsonObject, elementIndex);
            }
            case "InsurancePlan": {
                return this.parseInsurancePlan(elementName, jsonObject, elementIndex);
            }
            case "Invoice": {
                return this.parseInvoice(elementName, jsonObject, elementIndex);
            }
            case "Library": {
                return this.parseLibrary(elementName, jsonObject, elementIndex);
            }
            case "Linkage": {
                return this.parseLinkage(elementName, jsonObject, elementIndex);
            }
            case "List": {
                return this.parseList(elementName, jsonObject, elementIndex);
            }
            case "Location": {
                return this.parseLocation(elementName, jsonObject, elementIndex);
            }
            case "ManufacturedItemDefinition": {
                return this.parseManufacturedItemDefinition(elementName, jsonObject, elementIndex);
            }
            case "Measure": {
                return this.parseMeasure(elementName, jsonObject, elementIndex);
            }
            case "MeasureReport": {
                return this.parseMeasureReport(elementName, jsonObject, elementIndex);
            }
            case "Media": {
                return this.parseMedia(elementName, jsonObject, elementIndex);
            }
            case "Medication": {
                return this.parseMedication(elementName, jsonObject, elementIndex);
            }
            case "MedicationAdministration": {
                return this.parseMedicationAdministration(elementName, jsonObject, elementIndex);
            }
            case "MedicationDispense": {
                return this.parseMedicationDispense(elementName, jsonObject, elementIndex);
            }
            case "MedicationKnowledge": {
                return this.parseMedicationKnowledge(elementName, jsonObject, elementIndex);
            }
            case "MedicationRequest": {
                return this.parseMedicationRequest(elementName, jsonObject, elementIndex);
            }
            case "MedicationStatement": {
                return this.parseMedicationStatement(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductDefinition": {
                return this.parseMedicinalProductDefinition(elementName, jsonObject, elementIndex);
            }
            case "MessageDefinition": {
                return this.parseMessageDefinition(elementName, jsonObject, elementIndex);
            }
            case "MessageHeader": {
                return this.parseMessageHeader(elementName, jsonObject, elementIndex);
            }
            case "MolecularSequence": {
                return this.parseMolecularSequence(elementName, jsonObject, elementIndex);
            }
            case "NamingSystem": {
                return this.parseNamingSystem(elementName, jsonObject, elementIndex);
            }
            case "NutritionOrder": {
                return this.parseNutritionOrder(elementName, jsonObject, elementIndex);
            }
            case "NutritionProduct": {
                return this.parseNutritionProduct(elementName, jsonObject, elementIndex);
            }
            case "Observation": {
                return this.parseObservation(elementName, jsonObject, elementIndex);
            }
            case "ObservationDefinition": {
                return this.parseObservationDefinition(elementName, jsonObject, elementIndex);
            }
            case "OperationDefinition": {
                return this.parseOperationDefinition(elementName, jsonObject, elementIndex);
            }
            case "OperationOutcome": {
                return this.parseOperationOutcome(elementName, jsonObject, elementIndex);
            }
            case "Organization": {
                return this.parseOrganization(elementName, jsonObject, elementIndex);
            }
            case "OrganizationAffiliation": {
                return this.parseOrganizationAffiliation(elementName, jsonObject, elementIndex);
            }
            case "PackagedProductDefinition": {
                return this.parsePackagedProductDefinition(elementName, jsonObject, elementIndex);
            }
            case "Parameters": {
                return this.parseParameters(elementName, jsonObject, elementIndex);
            }
            case "Patient": {
                return this.parsePatient(elementName, jsonObject, elementIndex);
            }
            case "PaymentNotice": {
                return this.parsePaymentNotice(elementName, jsonObject, elementIndex);
            }
            case "PaymentReconciliation": {
                return this.parsePaymentReconciliation(elementName, jsonObject, elementIndex);
            }
            case "Person": {
                return this.parsePerson(elementName, jsonObject, elementIndex);
            }
            case "PlanDefinition": {
                return this.parsePlanDefinition(elementName, jsonObject, elementIndex);
            }
            case "Practitioner": {
                return this.parsePractitioner(elementName, jsonObject, elementIndex);
            }
            case "PractitionerRole": {
                return this.parsePractitionerRole(elementName, jsonObject, elementIndex);
            }
            case "Procedure": {
                return this.parseProcedure(elementName, jsonObject, elementIndex);
            }
            case "Provenance": {
                return this.parseProvenance(elementName, jsonObject, elementIndex);
            }
            case "Questionnaire": {
                return this.parseQuestionnaire(elementName, jsonObject, elementIndex);
            }
            case "QuestionnaireResponse": {
                return this.parseQuestionnaireResponse(elementName, jsonObject, elementIndex);
            }
            case "RegulatedAuthorization": {
                return this.parseRegulatedAuthorization(elementName, jsonObject, elementIndex);
            }
            case "RelatedPerson": {
                return this.parseRelatedPerson(elementName, jsonObject, elementIndex);
            }
            case "RequestGroup": {
                return this.parseRequestGroup(elementName, jsonObject, elementIndex);
            }
            case "ResearchDefinition": {
                return this.parseResearchDefinition(elementName, jsonObject, elementIndex);
            }
            case "ResearchElementDefinition": {
                return this.parseResearchElementDefinition(elementName, jsonObject, elementIndex);
            }
            case "ResearchStudy": {
                return this.parseResearchStudy(elementName, jsonObject, elementIndex);
            }
            case "ResearchSubject": {
                return this.parseResearchSubject(elementName, jsonObject, elementIndex);
            }
            case "RiskAssessment": {
                return this.parseRiskAssessment(elementName, jsonObject, elementIndex);
            }
            case "Schedule": {
                return this.parseSchedule(elementName, jsonObject, elementIndex);
            }
            case "SearchParameter": {
                return this.parseSearchParameter(elementName, jsonObject, elementIndex);
            }
            case "ServiceRequest": {
                return this.parseServiceRequest(elementName, jsonObject, elementIndex);
            }
            case "Slot": {
                return this.parseSlot(elementName, jsonObject, elementIndex);
            }
            case "Specimen": {
                return this.parseSpecimen(elementName, jsonObject, elementIndex);
            }
            case "SpecimenDefinition": {
                return this.parseSpecimenDefinition(elementName, jsonObject, elementIndex);
            }
            case "StructureDefinition": {
                return this.parseStructureDefinition(elementName, jsonObject, elementIndex);
            }
            case "StructureMap": {
                return this.parseStructureMap(elementName, jsonObject, elementIndex);
            }
            case "Subscription": {
                return this.parseSubscription(elementName, jsonObject, elementIndex);
            }
            case "SubscriptionStatus": {
                return this.parseSubscriptionStatus(elementName, jsonObject, elementIndex);
            }
            case "SubscriptionTopic": {
                return this.parseSubscriptionTopic(elementName, jsonObject, elementIndex);
            }
            case "Substance": {
                return this.parseSubstance(elementName, jsonObject, elementIndex);
            }
            case "SubstanceDefinition": {
                return this.parseSubstanceDefinition(elementName, jsonObject, elementIndex);
            }
            case "SupplyDelivery": {
                return this.parseSupplyDelivery(elementName, jsonObject, elementIndex);
            }
            case "SupplyRequest": {
                return this.parseSupplyRequest(elementName, jsonObject, elementIndex);
            }
            case "Task": {
                return this.parseTask(elementName, jsonObject, elementIndex);
            }
            case "TerminologyCapabilities": {
                return this.parseTerminologyCapabilities(elementName, jsonObject, elementIndex);
            }
            case "TestReport": {
                return this.parseTestReport(elementName, jsonObject, elementIndex);
            }
            case "TestScript": {
                return this.parseTestScript(elementName, jsonObject, elementIndex);
            }
            case "ValueSet": {
                return this.parseValueSet(elementName, jsonObject, elementIndex);
            }
            case "VerificationResult": {
                return this.parseVerificationResult(elementName, jsonObject, elementIndex);
            }
            case "VisionPrescription": {
                return this.parseVisionPrescription(elementName, jsonObject, elementIndex);
            }
        }
        return null;
    }

    private Account parseAccount(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Account.class, jsonObject);
        }
        Account.Builder builder = Account.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((AccountStatus)this.parseString(AccountStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i = 0; i < subjectArray.size(); ++i) {
                if (((JsonValue)subjectArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subjectArray.get(i)).getValueType() + " for element: subject");
                }
                builder.subject(this.parseReference("subject", subjectArray.getJsonObject(i), i));
            }
        }
        builder.servicePeriod(this.parsePeriod("servicePeriod", JsonSupport.getJsonValue(jsonObject, "servicePeriod", JsonObject.class), -1));
        JsonArray coverageArray = JsonSupport.getJsonArray(jsonObject, "coverage");
        if (coverageArray != null) {
            for (int i = 0; i < coverageArray.size(); ++i) {
                if (((JsonValue)coverageArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)coverageArray.get(i)).getValueType() + " for element: coverage");
                }
                builder.coverage(this.parseAccountCoverage("coverage", coverageArray.getJsonObject(i), i));
            }
        }
        builder.owner(this.parseReference("owner", JsonSupport.getJsonValue(jsonObject, "owner", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray guarantorArray = JsonSupport.getJsonArray(jsonObject, "guarantor");
        if (guarantorArray != null) {
            for (int i = 0; i < guarantorArray.size(); ++i) {
                if (((JsonValue)guarantorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)guarantorArray.get(i)).getValueType() + " for element: guarantor");
                }
                builder.guarantor(this.parseAccountGuarantor("guarantor", guarantorArray.getJsonObject(i), i));
            }
        }
        builder.partOf(this.parseReference("partOf", JsonSupport.getJsonValue(jsonObject, "partOf", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Account.Coverage parseAccountCoverage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Account.Coverage.class, jsonObject);
        }
        Account.Coverage.Builder builder = Account.Coverage.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.priority((PositiveInt)this.parseInteger(PositiveInt.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        this.stackPop();
        return builder.build();
    }

    private Account.Guarantor parseAccountGuarantor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Account.Guarantor.class, jsonObject);
        }
        Account.Guarantor.Builder builder = Account.Guarantor.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        builder.onHold(this.parseBoolean("onHold", JsonSupport.getJsonValue(jsonObject, "onHold", JsonValue.class), (JsonValue)jsonObject.get((Object)"_onHold"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ActivityDefinition parseActivityDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray observationResultRequirementArray;
        JsonArray observationRequirementArray;
        JsonArray specimenRequirementArray;
        JsonArray bodySiteArray;
        int i;
        JsonArray libraryArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ActivityDefinition.class, jsonObject);
        }
        ActivityDefinition.Builder builder = ActivityDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class, Canonical.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i3 = 0; i3 < contactArray.size(); ++i3) {
                if (((JsonValue)contactArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i3)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i3), i3));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i4 = 0; i4 < useContextArray.size(); ++i4) {
                if (((JsonValue)useContextArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i4)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i4), i4));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i5 = 0; i5 < jurisdictionArray.size(); ++i5) {
                if (((JsonValue)jurisdictionArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i5)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i5), i5));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.usage(this.parseString("usage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "usage", JsonString.class), (JsonValue)jsonObject.get((Object)"_usage"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i6 = 0; i6 < topicArray.size(); ++i6) {
                if (((JsonValue)topicArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)topicArray.get(i6)).getValueType() + " for element: topic");
                }
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i6), i6));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i7 = 0; i7 < authorArray.size(); ++i7) {
                if (((JsonValue)authorArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i7)).getValueType() + " for element: author");
                }
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i7), i7));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i8 = 0; i8 < editorArray.size(); ++i8) {
                if (((JsonValue)editorArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)editorArray.get(i8)).getValueType() + " for element: editor");
                }
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i8), i8));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i9 = 0; i9 < reviewerArray.size(); ++i9) {
                if (((JsonValue)reviewerArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reviewerArray.get(i9)).getValueType() + " for element: reviewer");
                }
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i9), i9));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i10 = 0; i10 < endorserArray.size(); ++i10) {
                if (((JsonValue)endorserArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)endorserArray.get(i10)).getValueType() + " for element: endorser");
                }
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i10), i10));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i11 = 0; i11 < relatedArtifactArray.size(); ++i11) {
                if (((JsonValue)relatedArtifactArray.get(i11)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArtifactArray.get(i11)).getValueType() + " for element: relatedArtifact");
                }
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i11), i11));
            }
        }
        if ((libraryArray = JsonSupport.getJsonArray(jsonObject, "library", true)) != null) {
            JsonArray _libraryArray = jsonObject.getJsonArray("_library");
            for (i = 0; i < libraryArray.size(); ++i) {
                builder.library((Canonical)this.parseUri(Canonical.builder(), "library", (JsonValue)libraryArray.get(i), JsonSupport.getJsonValue(_libraryArray, i), i));
            }
        }
        builder.kind((ActivityDefinitionKind)this.parseString(ActivityDefinitionKind.builder(), "kind", (JsonValue)JsonSupport.getJsonValue(jsonObject, "kind", JsonString.class), (JsonValue)jsonObject.get((Object)"_kind"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.intent((RequestIntent)this.parseString(RequestIntent.builder(), "intent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "intent", JsonString.class), (JsonValue)jsonObject.get((Object)"_intent"), -1));
        builder.priority((RequestPriority)this.parseString(RequestPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        builder.timing(this.parseChoiceElement("timing", jsonObject, Timing.class, DateTime.class, Age.class, Period.class, Range.class, Duration.class));
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray participantArray = JsonSupport.getJsonArray(jsonObject, "participant");
        if (participantArray != null) {
            for (i = 0; i < participantArray.size(); ++i) {
                if (((JsonValue)participantArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)participantArray.get(i)).getValueType() + " for element: participant");
                }
                builder.participant(this.parseActivityDefinitionParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        builder.product(this.parseChoiceElement("product", jsonObject, Reference.class, CodeableConcept.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        JsonArray dosageArray = JsonSupport.getJsonArray(jsonObject, "dosage");
        if (dosageArray != null) {
            for (int i12 = 0; i12 < dosageArray.size(); ++i12) {
                if (((JsonValue)dosageArray.get(i12)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)dosageArray.get(i12)).getValueType() + " for element: dosage");
                }
                builder.dosage(this.parseDosage("dosage", dosageArray.getJsonObject(i12), i12));
            }
        }
        if ((bodySiteArray = JsonSupport.getJsonArray(jsonObject, "bodySite")) != null) {
            for (int i13 = 0; i13 < bodySiteArray.size(); ++i13) {
                if (((JsonValue)bodySiteArray.get(i13)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)bodySiteArray.get(i13)).getValueType() + " for element: bodySite");
                }
                builder.bodySite(this.parseCodeableConcept("bodySite", bodySiteArray.getJsonObject(i13), i13));
            }
        }
        if ((specimenRequirementArray = JsonSupport.getJsonArray(jsonObject, "specimenRequirement")) != null) {
            for (int i14 = 0; i14 < specimenRequirementArray.size(); ++i14) {
                if (((JsonValue)specimenRequirementArray.get(i14)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)specimenRequirementArray.get(i14)).getValueType() + " for element: specimenRequirement");
                }
                builder.specimenRequirement(this.parseReference("specimenRequirement", specimenRequirementArray.getJsonObject(i14), i14));
            }
        }
        if ((observationRequirementArray = JsonSupport.getJsonArray(jsonObject, "observationRequirement")) != null) {
            for (int i15 = 0; i15 < observationRequirementArray.size(); ++i15) {
                if (((JsonValue)observationRequirementArray.get(i15)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)observationRequirementArray.get(i15)).getValueType() + " for element: observationRequirement");
                }
                builder.observationRequirement(this.parseReference("observationRequirement", observationRequirementArray.getJsonObject(i15), i15));
            }
        }
        if ((observationResultRequirementArray = JsonSupport.getJsonArray(jsonObject, "observationResultRequirement")) != null) {
            for (int i16 = 0; i16 < observationResultRequirementArray.size(); ++i16) {
                if (((JsonValue)observationResultRequirementArray.get(i16)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)observationResultRequirementArray.get(i16)).getValueType() + " for element: observationResultRequirement");
                }
                builder.observationResultRequirement(this.parseReference("observationResultRequirement", observationResultRequirementArray.getJsonObject(i16), i16));
            }
        }
        builder.transform((Canonical)this.parseUri(Canonical.builder(), "transform", (JsonValue)JsonSupport.getJsonValue(jsonObject, "transform", JsonString.class), (JsonValue)jsonObject.get((Object)"_transform"), -1));
        JsonArray dynamicValueArray = JsonSupport.getJsonArray(jsonObject, "dynamicValue");
        if (dynamicValueArray != null) {
            for (int i17 = 0; i17 < dynamicValueArray.size(); ++i17) {
                if (((JsonValue)dynamicValueArray.get(i17)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)dynamicValueArray.get(i17)).getValueType() + " for element: dynamicValue");
                }
                builder.dynamicValue(this.parseActivityDefinitionDynamicValue("dynamicValue", dynamicValueArray.getJsonObject(i17), i17));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ActivityDefinition.DynamicValue parseActivityDefinitionDynamicValue(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ActivityDefinition.DynamicValue.class, jsonObject);
        }
        ActivityDefinition.DynamicValue.Builder builder = ActivityDefinition.DynamicValue.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.expression(this.parseExpression("expression", JsonSupport.getJsonValue(jsonObject, "expression", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ActivityDefinition.Participant parseActivityDefinitionParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ActivityDefinition.Participant.class, jsonObject);
        }
        ActivityDefinition.Participant.Builder builder = ActivityDefinition.Participant.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ActivityParticipantType)this.parseString(ActivityParticipantType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Address parseAddress(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Address.class, jsonObject);
        }
        Address.Builder builder = Address.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.use((AddressUse)this.parseString(AddressUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.type((AddressType)this.parseString(AddressType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray lineArray = JsonSupport.getJsonArray(jsonObject, "line", true);
        if (lineArray != null) {
            JsonArray _lineArray = jsonObject.getJsonArray("_line");
            for (int i = 0; i < lineArray.size(); ++i) {
                builder.line(this.parseString("line", (JsonValue)lineArray.get(i), JsonSupport.getJsonValue(_lineArray, i), i));
            }
        }
        builder.city(this.parseString("city", (JsonValue)JsonSupport.getJsonValue(jsonObject, "city", JsonString.class), (JsonValue)jsonObject.get((Object)"_city"), -1));
        builder.district(this.parseString("district", (JsonValue)JsonSupport.getJsonValue(jsonObject, "district", JsonString.class), (JsonValue)jsonObject.get((Object)"_district"), -1));
        builder.state(this.parseString("state", (JsonValue)JsonSupport.getJsonValue(jsonObject, "state", JsonString.class), (JsonValue)jsonObject.get((Object)"_state"), -1));
        builder.postalCode(this.parseString("postalCode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "postalCode", JsonString.class), (JsonValue)jsonObject.get((Object)"_postalCode"), -1));
        builder.country(this.parseString("country", (JsonValue)JsonSupport.getJsonValue(jsonObject, "country", JsonString.class), (JsonValue)jsonObject.get((Object)"_country"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private AdministrableProductDefinition parseAdministrableProductDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray routeOfAdministrationArray;
        JsonArray ingredientArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdministrableProductDefinition.class, jsonObject);
        }
        AdministrableProductDefinition.Builder builder = AdministrableProductDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray formOfArray = JsonSupport.getJsonArray(jsonObject, "formOf");
        if (formOfArray != null) {
            for (int i = 0; i < formOfArray.size(); ++i) {
                if (((JsonValue)formOfArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)formOfArray.get(i)).getValueType() + " for element: formOf");
                }
                builder.formOf(this.parseReference("formOf", formOfArray.getJsonObject(i), i));
            }
        }
        builder.administrableDoseForm(this.parseCodeableConcept("administrableDoseForm", JsonSupport.getJsonValue(jsonObject, "administrableDoseForm", JsonObject.class), -1));
        builder.unitOfPresentation(this.parseCodeableConcept("unitOfPresentation", JsonSupport.getJsonValue(jsonObject, "unitOfPresentation", JsonObject.class), -1));
        JsonArray producedFromArray = JsonSupport.getJsonArray(jsonObject, "producedFrom");
        if (producedFromArray != null) {
            for (int i = 0; i < producedFromArray.size(); ++i) {
                if (((JsonValue)producedFromArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)producedFromArray.get(i)).getValueType() + " for element: producedFrom");
                }
                builder.producedFrom(this.parseReference("producedFrom", producedFromArray.getJsonObject(i), i));
            }
        }
        if ((ingredientArray = JsonSupport.getJsonArray(jsonObject, "ingredient")) != null) {
            for (int i = 0; i < ingredientArray.size(); ++i) {
                if (((JsonValue)ingredientArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)ingredientArray.get(i)).getValueType() + " for element: ingredient");
                }
                builder.ingredient(this.parseCodeableConcept("ingredient", ingredientArray.getJsonObject(i), i));
            }
        }
        builder.device(this.parseReference("device", JsonSupport.getJsonValue(jsonObject, "device", JsonObject.class), -1));
        JsonArray propertyArray = JsonSupport.getJsonArray(jsonObject, "property");
        if (propertyArray != null) {
            for (int i = 0; i < propertyArray.size(); ++i) {
                if (((JsonValue)propertyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)propertyArray.get(i)).getValueType() + " for element: property");
                }
                builder.property(this.parseAdministrableProductDefinitionProperty("property", propertyArray.getJsonObject(i), i));
            }
        }
        if ((routeOfAdministrationArray = JsonSupport.getJsonArray(jsonObject, "routeOfAdministration")) != null) {
            for (int i = 0; i < routeOfAdministrationArray.size(); ++i) {
                if (((JsonValue)routeOfAdministrationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)routeOfAdministrationArray.get(i)).getValueType() + " for element: routeOfAdministration");
                }
                builder.routeOfAdministration(this.parseAdministrableProductDefinitionRouteOfAdministration("routeOfAdministration", routeOfAdministrationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AdministrableProductDefinition.Property parseAdministrableProductDefinitionProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdministrableProductDefinition.Property.class, jsonObject);
        }
        AdministrableProductDefinition.Property.Builder builder = AdministrableProductDefinition.Property.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class));
        builder.status(this.parseCodeableConcept("status", JsonSupport.getJsonValue(jsonObject, "status", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private AdministrableProductDefinition.RouteOfAdministration parseAdministrableProductDefinitionRouteOfAdministration(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdministrableProductDefinition.RouteOfAdministration.class, jsonObject);
        }
        AdministrableProductDefinition.RouteOfAdministration.Builder builder = AdministrableProductDefinition.RouteOfAdministration.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.firstDose(this.parseQuantity("firstDose", JsonSupport.getJsonValue(jsonObject, "firstDose", JsonObject.class), -1));
        builder.maxSingleDose(this.parseQuantity("maxSingleDose", JsonSupport.getJsonValue(jsonObject, "maxSingleDose", JsonObject.class), -1));
        builder.maxDosePerDay(this.parseQuantity("maxDosePerDay", JsonSupport.getJsonValue(jsonObject, "maxDosePerDay", JsonObject.class), -1));
        builder.maxDosePerTreatmentPeriod(this.parseRatio("maxDosePerTreatmentPeriod", JsonSupport.getJsonValue(jsonObject, "maxDosePerTreatmentPeriod", JsonObject.class), -1));
        builder.maxTreatmentPeriod((Duration)this.parseQuantity(Duration.builder(), "maxTreatmentPeriod", JsonSupport.getJsonValue(jsonObject, "maxTreatmentPeriod", JsonObject.class), -1));
        JsonArray targetSpeciesArray = JsonSupport.getJsonArray(jsonObject, "targetSpecies");
        if (targetSpeciesArray != null) {
            for (int i = 0; i < targetSpeciesArray.size(); ++i) {
                if (((JsonValue)targetSpeciesArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)targetSpeciesArray.get(i)).getValueType() + " for element: targetSpecies");
                }
                builder.targetSpecies(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpecies("targetSpecies", targetSpeciesArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AdministrableProductDefinition.RouteOfAdministration.TargetSpecies parseAdministrableProductDefinitionRouteOfAdministrationTargetSpecies(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdministrableProductDefinition.RouteOfAdministration.TargetSpecies.class, jsonObject);
        }
        AdministrableProductDefinition.RouteOfAdministration.TargetSpecies.Builder builder = AdministrableProductDefinition.RouteOfAdministration.TargetSpecies.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray withdrawalPeriodArray = JsonSupport.getJsonArray(jsonObject, "withdrawalPeriod");
        if (withdrawalPeriodArray != null) {
            for (int i = 0; i < withdrawalPeriodArray.size(); ++i) {
                if (((JsonValue)withdrawalPeriodArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)withdrawalPeriodArray.get(i)).getValueType() + " for element: withdrawalPeriod");
                }
                builder.withdrawalPeriod(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriod("withdrawalPeriod", withdrawalPeriodArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AdministrableProductDefinition.RouteOfAdministration.TargetSpecies.WithdrawalPeriod parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriod(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdministrableProductDefinition.RouteOfAdministration.TargetSpecies.WithdrawalPeriod.class, jsonObject);
        }
        AdministrableProductDefinition.RouteOfAdministration.TargetSpecies.WithdrawalPeriod.Builder builder = AdministrableProductDefinition.RouteOfAdministration.TargetSpecies.WithdrawalPeriod.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.tissue(this.parseCodeableConcept("tissue", JsonSupport.getJsonValue(jsonObject, "tissue", JsonObject.class), -1));
        builder.value(this.parseQuantity("value", JsonSupport.getJsonValue(jsonObject, "value", JsonObject.class), -1));
        builder.supportingInformation(this.parseString("supportingInformation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "supportingInformation", JsonString.class), (JsonValue)jsonObject.get((Object)"_supportingInformation"), -1));
        this.stackPop();
        return builder.build();
    }

    private AdverseEvent parseAdverseEvent(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray studyArray;
        JsonArray referenceDocumentArray;
        JsonArray subjectMedicalHistoryArray;
        JsonArray suspectEntityArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdverseEvent.class, jsonObject);
        }
        AdverseEvent.Builder builder = AdverseEvent.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.actuality((AdverseEventActuality)this.parseString(AdverseEventActuality.builder(), "actuality", (JsonValue)JsonSupport.getJsonValue(jsonObject, "actuality", JsonString.class), (JsonValue)jsonObject.get((Object)"_actuality"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.event(this.parseCodeableConcept("event", JsonSupport.getJsonValue(jsonObject, "event", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.detected(this.parseDateTime("detected", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detected", JsonString.class), (JsonValue)jsonObject.get((Object)"_detected"), -1));
        builder.recordedDate(this.parseDateTime("recordedDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedDate"), -1));
        JsonArray resultingConditionArray = JsonSupport.getJsonArray(jsonObject, "resultingCondition");
        if (resultingConditionArray != null) {
            for (int i = 0; i < resultingConditionArray.size(); ++i) {
                if (((JsonValue)resultingConditionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)resultingConditionArray.get(i)).getValueType() + " for element: resultingCondition");
                }
                builder.resultingCondition(this.parseReference("resultingCondition", resultingConditionArray.getJsonObject(i), i));
            }
        }
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        builder.seriousness(this.parseCodeableConcept("seriousness", JsonSupport.getJsonValue(jsonObject, "seriousness", JsonObject.class), -1));
        builder.severity(this.parseCodeableConcept("severity", JsonSupport.getJsonValue(jsonObject, "severity", JsonObject.class), -1));
        builder.outcome(this.parseCodeableConcept("outcome", JsonSupport.getJsonValue(jsonObject, "outcome", JsonObject.class), -1));
        builder.recorder(this.parseReference("recorder", JsonSupport.getJsonValue(jsonObject, "recorder", JsonObject.class), -1));
        JsonArray contributorArray = JsonSupport.getJsonArray(jsonObject, "contributor");
        if (contributorArray != null) {
            for (int i = 0; i < contributorArray.size(); ++i) {
                if (((JsonValue)contributorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contributorArray.get(i)).getValueType() + " for element: contributor");
                }
                builder.contributor(this.parseReference("contributor", contributorArray.getJsonObject(i), i));
            }
        }
        if ((suspectEntityArray = JsonSupport.getJsonArray(jsonObject, "suspectEntity")) != null) {
            for (int i = 0; i < suspectEntityArray.size(); ++i) {
                if (((JsonValue)suspectEntityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)suspectEntityArray.get(i)).getValueType() + " for element: suspectEntity");
                }
                builder.suspectEntity(this.parseAdverseEventSuspectEntity("suspectEntity", suspectEntityArray.getJsonObject(i), i));
            }
        }
        if ((subjectMedicalHistoryArray = JsonSupport.getJsonArray(jsonObject, "subjectMedicalHistory")) != null) {
            for (int i = 0; i < subjectMedicalHistoryArray.size(); ++i) {
                if (((JsonValue)subjectMedicalHistoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subjectMedicalHistoryArray.get(i)).getValueType() + " for element: subjectMedicalHistory");
                }
                builder.subjectMedicalHistory(this.parseReference("subjectMedicalHistory", subjectMedicalHistoryArray.getJsonObject(i), i));
            }
        }
        if ((referenceDocumentArray = JsonSupport.getJsonArray(jsonObject, "referenceDocument")) != null) {
            for (int i = 0; i < referenceDocumentArray.size(); ++i) {
                if (((JsonValue)referenceDocumentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)referenceDocumentArray.get(i)).getValueType() + " for element: referenceDocument");
                }
                builder.referenceDocument(this.parseReference("referenceDocument", referenceDocumentArray.getJsonObject(i), i));
            }
        }
        if ((studyArray = JsonSupport.getJsonArray(jsonObject, "study")) != null) {
            for (int i = 0; i < studyArray.size(); ++i) {
                if (((JsonValue)studyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)studyArray.get(i)).getValueType() + " for element: study");
                }
                builder.study(this.parseReference("study", studyArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AdverseEvent.SuspectEntity parseAdverseEventSuspectEntity(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdverseEvent.SuspectEntity.class, jsonObject);
        }
        AdverseEvent.SuspectEntity.Builder builder = AdverseEvent.SuspectEntity.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.instance(this.parseReference("instance", JsonSupport.getJsonValue(jsonObject, "instance", JsonObject.class), -1));
        JsonArray causalityArray = JsonSupport.getJsonArray(jsonObject, "causality");
        if (causalityArray != null) {
            for (int i = 0; i < causalityArray.size(); ++i) {
                if (((JsonValue)causalityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)causalityArray.get(i)).getValueType() + " for element: causality");
                }
                builder.causality(this.parseAdverseEventSuspectEntityCausality("causality", causalityArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AdverseEvent.SuspectEntity.Causality parseAdverseEventSuspectEntityCausality(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AdverseEvent.SuspectEntity.Causality.class, jsonObject);
        }
        AdverseEvent.SuspectEntity.Causality.Builder builder = AdverseEvent.SuspectEntity.Causality.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.assessment(this.parseCodeableConcept("assessment", JsonSupport.getJsonValue(jsonObject, "assessment", JsonObject.class), -1));
        builder.productRelatedness(this.parseString("productRelatedness", (JsonValue)JsonSupport.getJsonValue(jsonObject, "productRelatedness", JsonString.class), (JsonValue)jsonObject.get((Object)"_productRelatedness"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        builder.method(this.parseCodeableConcept("method", JsonSupport.getJsonValue(jsonObject, "method", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private AllergyIntolerance parseAllergyIntolerance(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray reactionArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AllergyIntolerance.class, jsonObject);
        }
        AllergyIntolerance.Builder builder = AllergyIntolerance.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.clinicalStatus(this.parseCodeableConcept("clinicalStatus", JsonSupport.getJsonValue(jsonObject, "clinicalStatus", JsonObject.class), -1));
        builder.verificationStatus(this.parseCodeableConcept("verificationStatus", JsonSupport.getJsonValue(jsonObject, "verificationStatus", JsonObject.class), -1));
        builder.type((AllergyIntoleranceType)this.parseString(AllergyIntoleranceType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category", true);
        if (categoryArray != null) {
            JsonArray _categoryArray = jsonObject.getJsonArray("_category");
            for (i = 0; i < categoryArray.size(); ++i) {
                builder.category((AllergyIntoleranceCategory)this.parseString(AllergyIntoleranceCategory.builder(), "category", (JsonValue)categoryArray.get(i), JsonSupport.getJsonValue(_categoryArray, i), i));
            }
        }
        builder.criticality((AllergyIntoleranceCriticality)this.parseString(AllergyIntoleranceCriticality.builder(), "criticality", (JsonValue)JsonSupport.getJsonValue(jsonObject, "criticality", JsonString.class), (JsonValue)jsonObject.get((Object)"_criticality"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.onset(this.parseChoiceElement("onset", jsonObject, DateTime.class, Age.class, Period.class, Range.class, org.linuxforhealth.fhir.model.type.String.class));
        builder.recordedDate(this.parseDateTime("recordedDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedDate"), -1));
        builder.recorder(this.parseReference("recorder", JsonSupport.getJsonValue(jsonObject, "recorder", JsonObject.class), -1));
        builder.asserter(this.parseReference("asserter", JsonSupport.getJsonValue(jsonObject, "asserter", JsonObject.class), -1));
        builder.lastOccurrence(this.parseDateTime("lastOccurrence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastOccurrence", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastOccurrence"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((reactionArray = JsonSupport.getJsonArray(jsonObject, "reaction")) != null) {
            for (int i3 = 0; i3 < reactionArray.size(); ++i3) {
                if (((JsonValue)reactionArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reactionArray.get(i3)).getValueType() + " for element: reaction");
                }
                builder.reaction(this.parseAllergyIntoleranceReaction("reaction", reactionArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AllergyIntolerance.Reaction parseAllergyIntoleranceReaction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AllergyIntolerance.Reaction.class, jsonObject);
        }
        AllergyIntolerance.Reaction.Builder builder = AllergyIntolerance.Reaction.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.substance(this.parseCodeableConcept("substance", JsonSupport.getJsonValue(jsonObject, "substance", JsonObject.class), -1));
        JsonArray manifestationArray = JsonSupport.getJsonArray(jsonObject, "manifestation");
        if (manifestationArray != null) {
            for (int i = 0; i < manifestationArray.size(); ++i) {
                if (((JsonValue)manifestationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)manifestationArray.get(i)).getValueType() + " for element: manifestation");
                }
                builder.manifestation(this.parseCodeableConcept("manifestation", manifestationArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.onset(this.parseDateTime("onset", (JsonValue)JsonSupport.getJsonValue(jsonObject, "onset", JsonString.class), (JsonValue)jsonObject.get((Object)"_onset"), -1));
        builder.severity((AllergyIntoleranceSeverity)this.parseString(AllergyIntoleranceSeverity.builder(), "severity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "severity", JsonString.class), (JsonValue)jsonObject.get((Object)"_severity"), -1));
        builder.exposureRoute(this.parseCodeableConcept("exposureRoute", JsonSupport.getJsonValue(jsonObject, "exposureRoute", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Annotation parseAnnotation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Annotation.class, jsonObject);
        }
        Annotation.Builder builder = Annotation.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.author(this.parseChoiceElement("author", jsonObject, Reference.class, org.linuxforhealth.fhir.model.type.String.class));
        builder.time(this.parseDateTime("time", (JsonValue)JsonSupport.getJsonValue(jsonObject, "time", JsonString.class), (JsonValue)jsonObject.get((Object)"_time"), -1));
        builder.text((Markdown)this.parseString(Markdown.builder(), "text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Appointment parseAppointment(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray requestedPeriodArray;
        JsonArray participantArray;
        JsonArray reasonReferenceArray;
        JsonArray specialtyArray;
        JsonArray serviceTypeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Appointment.class, jsonObject);
        }
        Appointment.Builder builder = Appointment.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((AppointmentStatus)this.parseString(AppointmentStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.cancelationReason(this.parseCodeableConcept("cancelationReason", JsonSupport.getJsonValue(jsonObject, "cancelationReason", JsonObject.class), -1));
        JsonArray serviceCategoryArray = JsonSupport.getJsonArray(jsonObject, "serviceCategory");
        if (serviceCategoryArray != null) {
            for (int i = 0; i < serviceCategoryArray.size(); ++i) {
                if (((JsonValue)serviceCategoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)serviceCategoryArray.get(i)).getValueType() + " for element: serviceCategory");
                }
                builder.serviceCategory(this.parseCodeableConcept("serviceCategory", serviceCategoryArray.getJsonObject(i), i));
            }
        }
        if ((serviceTypeArray = JsonSupport.getJsonArray(jsonObject, "serviceType")) != null) {
            for (int i = 0; i < serviceTypeArray.size(); ++i) {
                if (((JsonValue)serviceTypeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)serviceTypeArray.get(i)).getValueType() + " for element: serviceType");
                }
                builder.serviceType(this.parseCodeableConcept("serviceType", serviceTypeArray.getJsonObject(i), i));
            }
        }
        if ((specialtyArray = JsonSupport.getJsonArray(jsonObject, "specialty")) != null) {
            for (int i = 0; i < specialtyArray.size(); ++i) {
                if (((JsonValue)specialtyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)specialtyArray.get(i)).getValueType() + " for element: specialty");
                }
                builder.specialty(this.parseCodeableConcept("specialty", specialtyArray.getJsonObject(i), i));
            }
        }
        builder.appointmentType(this.parseCodeableConcept("appointmentType", JsonSupport.getJsonValue(jsonObject, "appointmentType", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                if (((JsonValue)reasonCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                if (((JsonValue)reasonReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        builder.priority((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray supportingInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingInformation");
        if (supportingInformationArray != null) {
            for (int i = 0; i < supportingInformationArray.size(); ++i) {
                if (((JsonValue)supportingInformationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInformationArray.get(i)).getValueType() + " for element: supportingInformation");
                }
                builder.supportingInformation(this.parseReference("supportingInformation", supportingInformationArray.getJsonObject(i), i));
            }
        }
        builder.start(this.parseInstant("start", (JsonValue)JsonSupport.getJsonValue(jsonObject, "start", JsonString.class), (JsonValue)jsonObject.get((Object)"_start"), -1));
        builder.end(this.parseInstant("end", (JsonValue)JsonSupport.getJsonValue(jsonObject, "end", JsonString.class), (JsonValue)jsonObject.get((Object)"_end"), -1));
        builder.minutesDuration((PositiveInt)this.parseInteger(PositiveInt.builder(), "minutesDuration", (JsonValue)JsonSupport.getJsonValue(jsonObject, "minutesDuration", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_minutesDuration"), -1));
        JsonArray slotArray = JsonSupport.getJsonArray(jsonObject, "slot");
        if (slotArray != null) {
            for (int i = 0; i < slotArray.size(); ++i) {
                if (((JsonValue)slotArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)slotArray.get(i)).getValueType() + " for element: slot");
                }
                builder.slot(this.parseReference("slot", slotArray.getJsonObject(i), i));
            }
        }
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        builder.patientInstruction(this.parseString("patientInstruction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "patientInstruction", JsonString.class), (JsonValue)jsonObject.get((Object)"_patientInstruction"), -1));
        JsonArray basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn");
        if (basedOnArray != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((participantArray = JsonSupport.getJsonArray(jsonObject, "participant")) != null) {
            for (int i = 0; i < participantArray.size(); ++i) {
                if (((JsonValue)participantArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)participantArray.get(i)).getValueType() + " for element: participant");
                }
                builder.participant(this.parseAppointmentParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        if ((requestedPeriodArray = JsonSupport.getJsonArray(jsonObject, "requestedPeriod")) != null) {
            for (int i = 0; i < requestedPeriodArray.size(); ++i) {
                if (((JsonValue)requestedPeriodArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)requestedPeriodArray.get(i)).getValueType() + " for element: requestedPeriod");
                }
                builder.requestedPeriod(this.parsePeriod("requestedPeriod", requestedPeriodArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Appointment.Participant parseAppointmentParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Appointment.Participant.class, jsonObject);
        }
        Appointment.Participant.Builder builder = Appointment.Participant.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        builder.required((ParticipantRequired)this.parseString(ParticipantRequired.builder(), "required", (JsonValue)JsonSupport.getJsonValue(jsonObject, "required", JsonString.class), (JsonValue)jsonObject.get((Object)"_required"), -1));
        builder.status((ParticipationStatus)this.parseString(ParticipationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private AppointmentResponse parseAppointmentResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AppointmentResponse.class, jsonObject);
        }
        AppointmentResponse.Builder builder = AppointmentResponse.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.appointment(this.parseReference("appointment", JsonSupport.getJsonValue(jsonObject, "appointment", JsonObject.class), -1));
        builder.start(this.parseInstant("start", (JsonValue)JsonSupport.getJsonValue(jsonObject, "start", JsonString.class), (JsonValue)jsonObject.get((Object)"_start"), -1));
        builder.end(this.parseInstant("end", (JsonValue)JsonSupport.getJsonValue(jsonObject, "end", JsonString.class), (JsonValue)jsonObject.get((Object)"_end"), -1));
        JsonArray participantTypeArray = JsonSupport.getJsonArray(jsonObject, "participantType");
        if (participantTypeArray != null) {
            for (int i = 0; i < participantTypeArray.size(); ++i) {
                if (((JsonValue)participantTypeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)participantTypeArray.get(i)).getValueType() + " for element: participantType");
                }
                builder.participantType(this.parseCodeableConcept("participantType", participantTypeArray.getJsonObject(i), i));
            }
        }
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        builder.participantStatus((ParticipantStatus)this.parseString(ParticipantStatus.builder(), "participantStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "participantStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_participantStatus"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        this.stackPop();
        return builder.build();
    }

    private Attachment parseAttachment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Attachment.class, jsonObject);
        }
        Attachment.Builder builder = Attachment.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.contentType((Code)this.parseString(Code.builder(), "contentType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "contentType", JsonString.class), (JsonValue)jsonObject.get((Object)"_contentType"), -1));
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.data(this.parseBase64Binary("data", (JsonValue)JsonSupport.getJsonValue(jsonObject, "data", JsonString.class), (JsonValue)jsonObject.get((Object)"_data"), -1));
        builder.url((Url)this.parseUri(Url.builder(), "url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.size((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "size", (JsonValue)JsonSupport.getJsonValue(jsonObject, "size", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_size"), -1));
        builder.hash(this.parseBase64Binary("hash", (JsonValue)JsonSupport.getJsonValue(jsonObject, "hash", JsonString.class), (JsonValue)jsonObject.get((Object)"_hash"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.creation(this.parseDateTime("creation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "creation", JsonString.class), (JsonValue)jsonObject.get((Object)"_creation"), -1));
        this.stackPop();
        return builder.build();
    }

    private AuditEvent parseAuditEvent(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray agentArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.class, jsonObject);
        }
        AuditEvent.Builder builder = AuditEvent.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.type(this.parseCoding("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray subtypeArray = JsonSupport.getJsonArray(jsonObject, "subtype");
        if (subtypeArray != null) {
            for (int i = 0; i < subtypeArray.size(); ++i) {
                if (((JsonValue)subtypeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subtypeArray.get(i)).getValueType() + " for element: subtype");
                }
                builder.subtype(this.parseCoding("subtype", subtypeArray.getJsonObject(i), i));
            }
        }
        builder.action((AuditEventAction)this.parseString(AuditEventAction.builder(), "action", (JsonValue)JsonSupport.getJsonValue(jsonObject, "action", JsonString.class), (JsonValue)jsonObject.get((Object)"_action"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.recorded(this.parseInstant("recorded", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recorded", JsonString.class), (JsonValue)jsonObject.get((Object)"_recorded"), -1));
        builder.outcome((AuditEventOutcome)this.parseString(AuditEventOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.outcomeDesc(this.parseString("outcomeDesc", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcomeDesc", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcomeDesc"), -1));
        JsonArray purposeOfEventArray = JsonSupport.getJsonArray(jsonObject, "purposeOfEvent");
        if (purposeOfEventArray != null) {
            for (int i = 0; i < purposeOfEventArray.size(); ++i) {
                if (((JsonValue)purposeOfEventArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)purposeOfEventArray.get(i)).getValueType() + " for element: purposeOfEvent");
                }
                builder.purposeOfEvent(this.parseCodeableConcept("purposeOfEvent", purposeOfEventArray.getJsonObject(i), i));
            }
        }
        if ((agentArray = JsonSupport.getJsonArray(jsonObject, "agent")) != null) {
            for (int i = 0; i < agentArray.size(); ++i) {
                if (((JsonValue)agentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)agentArray.get(i)).getValueType() + " for element: agent");
                }
                builder.agent(this.parseAuditEventAgent("agent", agentArray.getJsonObject(i), i));
            }
        }
        builder.source(this.parseAuditEventSource("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        JsonArray entityArray = JsonSupport.getJsonArray(jsonObject, "entity");
        if (entityArray != null) {
            for (int i = 0; i < entityArray.size(); ++i) {
                if (((JsonValue)entityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)entityArray.get(i)).getValueType() + " for element: entity");
                }
                builder.entity(this.parseAuditEventEntity("entity", entityArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Agent parseAuditEventAgent(String elementName, JsonObject jsonObject, int elementIndex) {
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Agent.class, jsonObject);
        }
        AuditEvent.Agent.Builder builder = AuditEvent.Agent.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray roleArray = JsonSupport.getJsonArray(jsonObject, "role");
        if (roleArray != null) {
            for (int i2 = 0; i2 < roleArray.size(); ++i2) {
                if (((JsonValue)roleArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)roleArray.get(i2)).getValueType() + " for element: role");
                }
                builder.role(this.parseCodeableConcept("role", roleArray.getJsonObject(i2), i2));
            }
        }
        builder.who(this.parseReference("who", JsonSupport.getJsonValue(jsonObject, "who", JsonObject.class), -1));
        builder.altId(this.parseString("altId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "altId", JsonString.class), (JsonValue)jsonObject.get((Object)"_altId"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.requestor(this.parseBoolean("requestor", JsonSupport.getJsonValue(jsonObject, "requestor", JsonValue.class), (JsonValue)jsonObject.get((Object)"_requestor"), -1));
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray policyArray = JsonSupport.getJsonArray(jsonObject, "policy", true);
        if (policyArray != null) {
            JsonArray _policyArray = jsonObject.getJsonArray("_policy");
            for (i = 0; i < policyArray.size(); ++i) {
                builder.policy(this.parseUri("policy", (JsonValue)policyArray.get(i), JsonSupport.getJsonValue(_policyArray, i), i));
            }
        }
        builder.media(this.parseCoding("media", JsonSupport.getJsonValue(jsonObject, "media", JsonObject.class), -1));
        builder.network(this.parseAuditEventAgentNetwork("network", JsonSupport.getJsonValue(jsonObject, "network", JsonObject.class), -1));
        JsonArray purposeOfUseArray = JsonSupport.getJsonArray(jsonObject, "purposeOfUse");
        if (purposeOfUseArray != null) {
            for (i = 0; i < purposeOfUseArray.size(); ++i) {
                if (((JsonValue)purposeOfUseArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)purposeOfUseArray.get(i)).getValueType() + " for element: purposeOfUse");
                }
                builder.purposeOfUse(this.parseCodeableConcept("purposeOfUse", purposeOfUseArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Agent.Network parseAuditEventAgentNetwork(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Agent.Network.class, jsonObject);
        }
        AuditEvent.Agent.Network.Builder builder = AuditEvent.Agent.Network.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.address(this.parseString("address", (JsonValue)JsonSupport.getJsonValue(jsonObject, "address", JsonString.class), (JsonValue)jsonObject.get((Object)"_address"), -1));
        builder.type((AuditEventAgentNetworkType)this.parseString(AuditEventAgentNetworkType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Entity parseAuditEventEntity(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Entity.class, jsonObject);
        }
        AuditEvent.Entity.Builder builder = AuditEvent.Entity.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.what(this.parseReference("what", JsonSupport.getJsonValue(jsonObject, "what", JsonObject.class), -1));
        builder.type(this.parseCoding("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.role(this.parseCoding("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.lifecycle(this.parseCoding("lifecycle", JsonSupport.getJsonValue(jsonObject, "lifecycle", JsonObject.class), -1));
        JsonArray securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel");
        if (securityLabelArray != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                if (((JsonValue)securityLabelArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)securityLabelArray.get(i)).getValueType() + " for element: securityLabel");
                }
                builder.securityLabel(this.parseCoding("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.query(this.parseBase64Binary("query", (JsonValue)JsonSupport.getJsonValue(jsonObject, "query", JsonString.class), (JsonValue)jsonObject.get((Object)"_query"), -1));
        JsonArray detailArray = JsonSupport.getJsonArray(jsonObject, "detail");
        if (detailArray != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                if (((JsonValue)detailArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseAuditEventEntityDetail("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Entity.Detail parseAuditEventEntityDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Entity.Detail.class, jsonObject);
        }
        AuditEvent.Entity.Detail.Builder builder = AuditEvent.Entity.Detail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseString("type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, org.linuxforhealth.fhir.model.type.String.class, Base64Binary.class));
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Source parseAuditEventSource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Source.class, jsonObject);
        }
        AuditEvent.Source.Builder builder = AuditEvent.Source.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.site(this.parseString("site", (JsonValue)JsonSupport.getJsonValue(jsonObject, "site", JsonString.class), (JsonValue)jsonObject.get((Object)"_site"), -1));
        builder.observer(this.parseReference("observer", JsonSupport.getJsonValue(jsonObject, "observer", JsonObject.class), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCoding("type", typeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private void parseBackboneElement(BackboneElement.Builder builder, JsonObject jsonObject) {
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        JsonArray modifierExtensionArray = JsonSupport.getJsonArray(jsonObject, "modifierExtension");
        if (modifierExtensionArray != null) {
            for (int i = 0; i < modifierExtensionArray.size(); ++i) {
                if (((JsonValue)modifierExtensionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierExtensionArray.get(i)).getValueType() + " for element: modifierExtension");
                }
                builder.modifierExtension(this.parseExtension("modifierExtension", modifierExtensionArray.getJsonObject(i), i));
            }
        }
    }

    private Base64Binary parseBase64Binary(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Base64Binary.Builder builder = Base64Binary.builder();
        builder.setValidating(this.validating);
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.ignoringUnrecognizedElements) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            JsonString jsonString = (JsonString)jsonValue;
            builder.value(jsonString.getString());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: STRING but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private Basic parseBasic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Basic.class, jsonObject);
        }
        Basic.Builder builder = Basic.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.created(this.parseDate("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Binary parseBinary(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Binary.class, jsonObject);
        }
        Binary.Builder builder = Binary.builder();
        builder.setValidating(this.validating);
        this.parseResource(builder, jsonObject);
        builder.contentType((Code)this.parseString(Code.builder(), "contentType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "contentType", JsonString.class), (JsonValue)jsonObject.get((Object)"_contentType"), -1));
        builder.securityContext(this.parseReference("securityContext", JsonSupport.getJsonValue(jsonObject, "securityContext", JsonObject.class), -1));
        builder.data(this.parseBase64Binary("data", (JsonValue)JsonSupport.getJsonValue(jsonObject, "data", JsonString.class), (JsonValue)jsonObject.get((Object)"_data"), -1));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct parseBiologicallyDerivedProduct(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.class, jsonObject);
        }
        BiologicallyDerivedProduct.Builder builder = BiologicallyDerivedProduct.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.productCategory((BiologicallyDerivedProductCategory)this.parseString(BiologicallyDerivedProductCategory.builder(), "productCategory", (JsonValue)JsonSupport.getJsonValue(jsonObject, "productCategory", JsonString.class), (JsonValue)jsonObject.get((Object)"_productCategory"), -1));
        builder.productCode(this.parseCodeableConcept("productCode", JsonSupport.getJsonValue(jsonObject, "productCode", JsonObject.class), -1));
        builder.status((BiologicallyDerivedProductStatus)this.parseString(BiologicallyDerivedProductStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray requestArray = JsonSupport.getJsonArray(jsonObject, "request");
        if (requestArray != null) {
            for (int i = 0; i < requestArray.size(); ++i) {
                if (((JsonValue)requestArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)requestArray.get(i)).getValueType() + " for element: request");
                }
                builder.request(this.parseReference("request", requestArray.getJsonObject(i), i));
            }
        }
        builder.quantity(this.parseInteger("quantity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "quantity", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_quantity"), -1));
        JsonArray parentArray = JsonSupport.getJsonArray(jsonObject, "parent");
        if (parentArray != null) {
            for (int i = 0; i < parentArray.size(); ++i) {
                if (((JsonValue)parentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)parentArray.get(i)).getValueType() + " for element: parent");
                }
                builder.parent(this.parseReference("parent", parentArray.getJsonObject(i), i));
            }
        }
        builder.collection(this.parseBiologicallyDerivedProductCollection("collection", JsonSupport.getJsonValue(jsonObject, "collection", JsonObject.class), -1));
        JsonArray processingArray = JsonSupport.getJsonArray(jsonObject, "processing");
        if (processingArray != null) {
            for (int i = 0; i < processingArray.size(); ++i) {
                if (((JsonValue)processingArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)processingArray.get(i)).getValueType() + " for element: processing");
                }
                builder.processing(this.parseBiologicallyDerivedProductProcessing("processing", processingArray.getJsonObject(i), i));
            }
        }
        builder.manipulation(this.parseBiologicallyDerivedProductManipulation("manipulation", JsonSupport.getJsonValue(jsonObject, "manipulation", JsonObject.class), -1));
        JsonArray storageArray = JsonSupport.getJsonArray(jsonObject, "storage");
        if (storageArray != null) {
            for (int i = 0; i < storageArray.size(); ++i) {
                if (((JsonValue)storageArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)storageArray.get(i)).getValueType() + " for element: storage");
                }
                builder.storage(this.parseBiologicallyDerivedProductStorage("storage", storageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Collection parseBiologicallyDerivedProductCollection(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Collection.class, jsonObject);
        }
        BiologicallyDerivedProduct.Collection.Builder builder = BiologicallyDerivedProduct.Collection.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.collector(this.parseReference("collector", JsonSupport.getJsonValue(jsonObject, "collector", JsonObject.class), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.collected(this.parseChoiceElement("collected", jsonObject, DateTime.class, Period.class));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Manipulation parseBiologicallyDerivedProductManipulation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Manipulation.class, jsonObject);
        }
        BiologicallyDerivedProduct.Manipulation.Builder builder = BiologicallyDerivedProduct.Manipulation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.time(this.parseChoiceElement("time", jsonObject, DateTime.class, Period.class));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Processing parseBiologicallyDerivedProductProcessing(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Processing.class, jsonObject);
        }
        BiologicallyDerivedProduct.Processing.Builder builder = BiologicallyDerivedProduct.Processing.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.procedure(this.parseCodeableConcept("procedure", JsonSupport.getJsonValue(jsonObject, "procedure", JsonObject.class), -1));
        builder.additive(this.parseReference("additive", JsonSupport.getJsonValue(jsonObject, "additive", JsonObject.class), -1));
        builder.time(this.parseChoiceElement("time", jsonObject, DateTime.class, Period.class));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Storage parseBiologicallyDerivedProductStorage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Storage.class, jsonObject);
        }
        BiologicallyDerivedProduct.Storage.Builder builder = BiologicallyDerivedProduct.Storage.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.temperature(this.parseDecimal("temperature", (JsonValue)JsonSupport.getJsonValue(jsonObject, "temperature", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_temperature"), -1));
        builder.scale((BiologicallyDerivedProductStorageScale)this.parseString(BiologicallyDerivedProductStorageScale.builder(), "scale", (JsonValue)JsonSupport.getJsonValue(jsonObject, "scale", JsonString.class), (JsonValue)jsonObject.get((Object)"_scale"), -1));
        builder.duration(this.parsePeriod("duration", JsonSupport.getJsonValue(jsonObject, "duration", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private BodyStructure parseBodyStructure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(BodyStructure.class, jsonObject);
        }
        BodyStructure.Builder builder = BodyStructure.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.active(this.parseBoolean("active", JsonSupport.getJsonValue(jsonObject, "active", JsonValue.class), (JsonValue)jsonObject.get((Object)"_active"), -1));
        builder.morphology(this.parseCodeableConcept("morphology", JsonSupport.getJsonValue(jsonObject, "morphology", JsonObject.class), -1));
        builder.location(this.parseCodeableConcept("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray locationQualifierArray = JsonSupport.getJsonArray(jsonObject, "locationQualifier");
        if (locationQualifierArray != null) {
            for (int i = 0; i < locationQualifierArray.size(); ++i) {
                if (((JsonValue)locationQualifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)locationQualifierArray.get(i)).getValueType() + " for element: locationQualifier");
                }
                builder.locationQualifier(this.parseCodeableConcept("locationQualifier", locationQualifierArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray imageArray = JsonSupport.getJsonArray(jsonObject, "image");
        if (imageArray != null) {
            for (int i = 0; i < imageArray.size(); ++i) {
                if (((JsonValue)imageArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)imageArray.get(i)).getValueType() + " for element: image");
                }
                builder.image(this.parseAttachment("image", imageArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Boolean parseBoolean(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Boolean.Builder builder = Boolean.builder();
        builder.setValidating(this.validating);
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.ignoringUnrecognizedElements) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (JsonValue.TRUE.equals(jsonValue) || JsonValue.FALSE.equals(jsonValue)) {
            builder.value(JsonValue.TRUE.equals(jsonValue) ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE);
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: TRUE or FALSE but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private Bundle parseBundle(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray entryArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Bundle.class, jsonObject);
        }
        Bundle.Builder builder = Bundle.builder();
        builder.setValidating(this.validating);
        this.parseResource(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.type((BundleType)this.parseString(BundleType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.timestamp(this.parseInstant("timestamp", (JsonValue)JsonSupport.getJsonValue(jsonObject, "timestamp", JsonString.class), (JsonValue)jsonObject.get((Object)"_timestamp"), -1));
        builder.total((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "total", (JsonValue)JsonSupport.getJsonValue(jsonObject, "total", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_total"), -1));
        JsonArray linkArray = JsonSupport.getJsonArray(jsonObject, "link");
        if (linkArray != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                if (((JsonValue)linkArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)linkArray.get(i)).getValueType() + " for element: link");
                }
                builder.link(this.parseBundleLink("link", linkArray.getJsonObject(i), i));
            }
        }
        if ((entryArray = JsonSupport.getJsonArray(jsonObject, "entry")) != null) {
            for (int i = 0; i < entryArray.size(); ++i) {
                if (((JsonValue)entryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)entryArray.get(i)).getValueType() + " for element: entry");
                }
                builder.entry(this.parseBundleEntry("entry", entryArray.getJsonObject(i), i));
            }
        }
        builder.signature(this.parseSignature("signature", JsonSupport.getJsonValue(jsonObject, "signature", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry parseBundleEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.class, jsonObject);
        }
        Bundle.Entry.Builder builder = Bundle.Entry.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray linkArray = JsonSupport.getJsonArray(jsonObject, "link");
        if (linkArray != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                if (((JsonValue)linkArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)linkArray.get(i)).getValueType() + " for element: link");
                }
                builder.link(this.parseBundleLink("link", linkArray.getJsonObject(i), i));
            }
        }
        builder.fullUrl(this.parseUri("fullUrl", (JsonValue)JsonSupport.getJsonValue(jsonObject, "fullUrl", JsonString.class), (JsonValue)jsonObject.get((Object)"_fullUrl"), -1));
        builder.resource(this.parseResource("resource", JsonSupport.getJsonValue(jsonObject, "resource", JsonObject.class), -1));
        builder.search(this.parseBundleEntrySearch("search", JsonSupport.getJsonValue(jsonObject, "search", JsonObject.class), -1));
        builder.request(this.parseBundleEntryRequest("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.response(this.parseBundleEntryResponse("response", JsonSupport.getJsonValue(jsonObject, "response", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry.Request parseBundleEntryRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.Request.class, jsonObject);
        }
        Bundle.Entry.Request.Builder builder = Bundle.Entry.Request.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.method((HTTPVerb)this.parseString(HTTPVerb.builder(), "method", (JsonValue)JsonSupport.getJsonValue(jsonObject, "method", JsonString.class), (JsonValue)jsonObject.get((Object)"_method"), -1));
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.ifNoneMatch(this.parseString("ifNoneMatch", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifNoneMatch", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifNoneMatch"), -1));
        builder.ifModifiedSince(this.parseInstant("ifModifiedSince", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifModifiedSince", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifModifiedSince"), -1));
        builder.ifMatch(this.parseString("ifMatch", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifMatch", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifMatch"), -1));
        builder.ifNoneExist(this.parseString("ifNoneExist", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifNoneExist", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifNoneExist"), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry.Response parseBundleEntryResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.Response.class, jsonObject);
        }
        Bundle.Entry.Response.Builder builder = Bundle.Entry.Response.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.status(this.parseString("status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.location(this.parseUri("location", (JsonValue)JsonSupport.getJsonValue(jsonObject, "location", JsonString.class), (JsonValue)jsonObject.get((Object)"_location"), -1));
        builder.etag(this.parseString("etag", (JsonValue)JsonSupport.getJsonValue(jsonObject, "etag", JsonString.class), (JsonValue)jsonObject.get((Object)"_etag"), -1));
        builder.lastModified(this.parseInstant("lastModified", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastModified", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastModified"), -1));
        builder.outcome(this.parseResource("outcome", JsonSupport.getJsonValue(jsonObject, "outcome", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry.Search parseBundleEntrySearch(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.Search.class, jsonObject);
        }
        Bundle.Entry.Search.Builder builder = Bundle.Entry.Search.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((SearchEntryMode)this.parseString(SearchEntryMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.score(this.parseDecimal("score", (JsonValue)JsonSupport.getJsonValue(jsonObject, "score", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_score"), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Link parseBundleLink(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Link.class, jsonObject);
        }
        Bundle.Link.Builder builder = Bundle.Link.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.relation(this.parseString("relation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "relation", JsonString.class), (JsonValue)jsonObject.get((Object)"_relation"), -1));
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement parseCapabilityStatement(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray documentArray;
        JsonArray messagingArray;
        JsonArray restArray;
        int i;
        JsonArray implementationGuideArray;
        JsonArray patchFormatArray;
        JsonArray importsArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.class, jsonObject);
        }
        CapabilityStatement.Builder builder = CapabilityStatement.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i2 = 0; i2 < contactArray.size(); ++i2) {
                if (((JsonValue)contactArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i2)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i2), i2));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i3 = 0; i3 < useContextArray.size(); ++i3) {
                if (((JsonValue)useContextArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i3)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i3), i3));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i4 = 0; i4 < jurisdictionArray.size(); ++i4) {
                if (((JsonValue)jurisdictionArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i4)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i4), i4));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.kind((CapabilityStatementKind)this.parseString(CapabilityStatementKind.builder(), "kind", (JsonValue)JsonSupport.getJsonValue(jsonObject, "kind", JsonString.class), (JsonValue)jsonObject.get((Object)"_kind"), -1));
        JsonArray instantiatesArray = JsonSupport.getJsonArray(jsonObject, "instantiates", true);
        if (instantiatesArray != null) {
            JsonArray _instantiatesArray = jsonObject.getJsonArray("_instantiates");
            for (int i5 = 0; i5 < instantiatesArray.size(); ++i5) {
                builder.instantiates((Canonical)this.parseUri(Canonical.builder(), "instantiates", (JsonValue)instantiatesArray.get(i5), JsonSupport.getJsonValue(_instantiatesArray, i5), i5));
            }
        }
        if ((importsArray = JsonSupport.getJsonArray(jsonObject, "imports", true)) != null) {
            JsonArray _importsArray = jsonObject.getJsonArray("_imports");
            for (int i6 = 0; i6 < importsArray.size(); ++i6) {
                builder.imports((Canonical)this.parseUri(Canonical.builder(), "imports", (JsonValue)importsArray.get(i6), JsonSupport.getJsonValue(_importsArray, i6), i6));
            }
        }
        builder.software(this.parseCapabilityStatementSoftware("software", JsonSupport.getJsonValue(jsonObject, "software", JsonObject.class), -1));
        builder.implementation(this.parseCapabilityStatementImplementation("implementation", JsonSupport.getJsonValue(jsonObject, "implementation", JsonObject.class), -1));
        builder.fhirVersion((FHIRVersion)this.parseString(FHIRVersion.builder(), "fhirVersion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "fhirVersion", JsonString.class), (JsonValue)jsonObject.get((Object)"_fhirVersion"), -1));
        JsonArray formatArray = JsonSupport.getJsonArray(jsonObject, "format", true);
        if (formatArray != null) {
            JsonArray _formatArray = jsonObject.getJsonArray("_format");
            for (int i7 = 0; i7 < formatArray.size(); ++i7) {
                builder.format((Code)this.parseString(Code.builder(), "format", (JsonValue)formatArray.get(i7), JsonSupport.getJsonValue(_formatArray, i7), i7));
            }
        }
        if ((patchFormatArray = JsonSupport.getJsonArray(jsonObject, "patchFormat", true)) != null) {
            JsonArray _patchFormatArray = jsonObject.getJsonArray("_patchFormat");
            for (int i8 = 0; i8 < patchFormatArray.size(); ++i8) {
                builder.patchFormat((Code)this.parseString(Code.builder(), "patchFormat", (JsonValue)patchFormatArray.get(i8), JsonSupport.getJsonValue(_patchFormatArray, i8), i8));
            }
        }
        if ((implementationGuideArray = JsonSupport.getJsonArray(jsonObject, "implementationGuide", true)) != null) {
            JsonArray _implementationGuideArray = jsonObject.getJsonArray("_implementationGuide");
            for (i = 0; i < implementationGuideArray.size(); ++i) {
                builder.implementationGuide((Canonical)this.parseUri(Canonical.builder(), "implementationGuide", (JsonValue)implementationGuideArray.get(i), JsonSupport.getJsonValue(_implementationGuideArray, i), i));
            }
        }
        if ((restArray = JsonSupport.getJsonArray(jsonObject, "rest")) != null) {
            for (i = 0; i < restArray.size(); ++i) {
                if (((JsonValue)restArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)restArray.get(i)).getValueType() + " for element: rest");
                }
                builder.rest(this.parseCapabilityStatementRest("rest", restArray.getJsonObject(i), i));
            }
        }
        if ((messagingArray = JsonSupport.getJsonArray(jsonObject, "messaging")) != null) {
            for (int i9 = 0; i9 < messagingArray.size(); ++i9) {
                if (((JsonValue)messagingArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)messagingArray.get(i9)).getValueType() + " for element: messaging");
                }
                builder.messaging(this.parseCapabilityStatementMessaging("messaging", messagingArray.getJsonObject(i9), i9));
            }
        }
        if ((documentArray = JsonSupport.getJsonArray(jsonObject, "document")) != null) {
            for (int i10 = 0; i10 < documentArray.size(); ++i10) {
                if (((JsonValue)documentArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)documentArray.get(i10)).getValueType() + " for element: document");
                }
                builder.document(this.parseCapabilityStatementDocument("document", documentArray.getJsonObject(i10), i10));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Document parseCapabilityStatementDocument(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Document.class, jsonObject);
        }
        CapabilityStatement.Document.Builder builder = CapabilityStatement.Document.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((DocumentMode)this.parseString(DocumentMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Implementation parseCapabilityStatementImplementation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Implementation.class, jsonObject);
        }
        CapabilityStatement.Implementation.Builder builder = CapabilityStatement.Implementation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.url((Url)this.parseUri(Url.builder(), "url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.custodian(this.parseReference("custodian", JsonSupport.getJsonValue(jsonObject, "custodian", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Messaging parseCapabilityStatementMessaging(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Messaging.class, jsonObject);
        }
        CapabilityStatement.Messaging.Builder builder = CapabilityStatement.Messaging.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray endpointArray = JsonSupport.getJsonArray(jsonObject, "endpoint");
        if (endpointArray != null) {
            for (int i = 0; i < endpointArray.size(); ++i) {
                if (((JsonValue)endpointArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)endpointArray.get(i)).getValueType() + " for element: endpoint");
                }
                builder.endpoint(this.parseCapabilityStatementMessagingEndpoint("endpoint", endpointArray.getJsonObject(i), i));
            }
        }
        builder.reliableCache((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "reliableCache", (JsonValue)JsonSupport.getJsonValue(jsonObject, "reliableCache", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_reliableCache"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        JsonArray supportedMessageArray = JsonSupport.getJsonArray(jsonObject, "supportedMessage");
        if (supportedMessageArray != null) {
            for (int i = 0; i < supportedMessageArray.size(); ++i) {
                if (((JsonValue)supportedMessageArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportedMessageArray.get(i)).getValueType() + " for element: supportedMessage");
                }
                builder.supportedMessage(this.parseCapabilityStatementMessagingSupportedMessage("supportedMessage", supportedMessageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Messaging.Endpoint parseCapabilityStatementMessagingEndpoint(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Messaging.Endpoint.class, jsonObject);
        }
        CapabilityStatement.Messaging.Endpoint.Builder builder = CapabilityStatement.Messaging.Endpoint.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.protocol(this.parseCoding("protocol", JsonSupport.getJsonValue(jsonObject, "protocol", JsonObject.class), -1));
        builder.address((Url)this.parseUri(Url.builder(), "address", (JsonValue)JsonSupport.getJsonValue(jsonObject, "address", JsonString.class), (JsonValue)jsonObject.get((Object)"_address"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Messaging.SupportedMessage parseCapabilityStatementMessagingSupportedMessage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Messaging.SupportedMessage.class, jsonObject);
        }
        CapabilityStatement.Messaging.SupportedMessage.Builder builder = CapabilityStatement.Messaging.SupportedMessage.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((EventCapabilityMode)this.parseString(EventCapabilityMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest parseCapabilityStatementRest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray compartmentArray;
        JsonArray operationArray;
        JsonArray searchParamArray;
        JsonArray interactionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.class, jsonObject);
        }
        CapabilityStatement.Rest.Builder builder = CapabilityStatement.Rest.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((RestfulCapabilityMode)this.parseString(RestfulCapabilityMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        builder.security(this.parseCapabilityStatementRestSecurity("security", JsonSupport.getJsonValue(jsonObject, "security", JsonObject.class), -1));
        JsonArray resourceArray = JsonSupport.getJsonArray(jsonObject, "resource");
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.size(); ++i) {
                if (((JsonValue)resourceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)resourceArray.get(i)).getValueType() + " for element: resource");
                }
                builder.resource(this.parseCapabilityStatementRestResource("resource", resourceArray.getJsonObject(i), i));
            }
        }
        if ((interactionArray = JsonSupport.getJsonArray(jsonObject, "interaction")) != null) {
            for (int i = 0; i < interactionArray.size(); ++i) {
                if (((JsonValue)interactionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)interactionArray.get(i)).getValueType() + " for element: interaction");
                }
                builder.interaction(this.parseCapabilityStatementRestInteraction("interaction", interactionArray.getJsonObject(i), i));
            }
        }
        if ((searchParamArray = JsonSupport.getJsonArray(jsonObject, "searchParam")) != null) {
            for (int i = 0; i < searchParamArray.size(); ++i) {
                if (((JsonValue)searchParamArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)searchParamArray.get(i)).getValueType() + " for element: searchParam");
                }
                builder.searchParam(this.parseCapabilityStatementRestResourceSearchParam("searchParam", searchParamArray.getJsonObject(i), i));
            }
        }
        if ((operationArray = JsonSupport.getJsonArray(jsonObject, "operation")) != null) {
            for (int i = 0; i < operationArray.size(); ++i) {
                if (((JsonValue)operationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)operationArray.get(i)).getValueType() + " for element: operation");
                }
                builder.operation(this.parseCapabilityStatementRestResourceOperation("operation", operationArray.getJsonObject(i), i));
            }
        }
        if ((compartmentArray = JsonSupport.getJsonArray(jsonObject, "compartment", true)) != null) {
            JsonArray _compartmentArray = jsonObject.getJsonArray("_compartment");
            for (int i = 0; i < compartmentArray.size(); ++i) {
                builder.compartment((Canonical)this.parseUri(Canonical.builder(), "compartment", (JsonValue)compartmentArray.get(i), JsonSupport.getJsonValue(_compartmentArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Interaction parseCapabilityStatementRestInteraction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Interaction.class, jsonObject);
        }
        CapabilityStatement.Rest.Interaction.Builder builder = CapabilityStatement.Rest.Interaction.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((SystemRestfulInteraction)this.parseString(SystemRestfulInteraction.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource parseCapabilityStatementRestResource(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray operationArray;
        JsonArray searchParamArray;
        int i;
        JsonArray searchRevIncludeArray;
        JsonArray searchIncludeArray;
        int i2;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.Builder builder = CapabilityStatement.Rest.Resource.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ResourceTypeCode)this.parseString(ResourceTypeCode.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        JsonArray supportedProfileArray = JsonSupport.getJsonArray(jsonObject, "supportedProfile", true);
        if (supportedProfileArray != null) {
            JsonArray _supportedProfileArray = jsonObject.getJsonArray("_supportedProfile");
            for (i2 = 0; i2 < supportedProfileArray.size(); ++i2) {
                builder.supportedProfile((Canonical)this.parseUri(Canonical.builder(), "supportedProfile", (JsonValue)supportedProfileArray.get(i2), JsonSupport.getJsonValue(_supportedProfileArray, i2), i2));
            }
        }
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        JsonArray interactionArray = JsonSupport.getJsonArray(jsonObject, "interaction");
        if (interactionArray != null) {
            for (i2 = 0; i2 < interactionArray.size(); ++i2) {
                if (((JsonValue)interactionArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)interactionArray.get(i2)).getValueType() + " for element: interaction");
                }
                builder.interaction(this.parseCapabilityStatementRestResourceInteraction("interaction", interactionArray.getJsonObject(i2), i2));
            }
        }
        builder.versioning((ResourceVersionPolicy)this.parseString(ResourceVersionPolicy.builder(), "versioning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versioning", JsonString.class), (JsonValue)jsonObject.get((Object)"_versioning"), -1));
        builder.readHistory(this.parseBoolean("readHistory", JsonSupport.getJsonValue(jsonObject, "readHistory", JsonValue.class), (JsonValue)jsonObject.get((Object)"_readHistory"), -1));
        builder.updateCreate(this.parseBoolean("updateCreate", JsonSupport.getJsonValue(jsonObject, "updateCreate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_updateCreate"), -1));
        builder.conditionalCreate(this.parseBoolean("conditionalCreate", JsonSupport.getJsonValue(jsonObject, "conditionalCreate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_conditionalCreate"), -1));
        builder.conditionalRead((ConditionalReadStatus)this.parseString(ConditionalReadStatus.builder(), "conditionalRead", (JsonValue)JsonSupport.getJsonValue(jsonObject, "conditionalRead", JsonString.class), (JsonValue)jsonObject.get((Object)"_conditionalRead"), -1));
        builder.conditionalUpdate(this.parseBoolean("conditionalUpdate", JsonSupport.getJsonValue(jsonObject, "conditionalUpdate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_conditionalUpdate"), -1));
        builder.conditionalDelete((ConditionalDeleteStatus)this.parseString(ConditionalDeleteStatus.builder(), "conditionalDelete", (JsonValue)JsonSupport.getJsonValue(jsonObject, "conditionalDelete", JsonString.class), (JsonValue)jsonObject.get((Object)"_conditionalDelete"), -1));
        JsonArray referencePolicyArray = JsonSupport.getJsonArray(jsonObject, "referencePolicy", true);
        if (referencePolicyArray != null) {
            JsonArray _referencePolicyArray = jsonObject.getJsonArray("_referencePolicy");
            for (int i3 = 0; i3 < referencePolicyArray.size(); ++i3) {
                builder.referencePolicy((ReferenceHandlingPolicy)this.parseString(ReferenceHandlingPolicy.builder(), "referencePolicy", (JsonValue)referencePolicyArray.get(i3), JsonSupport.getJsonValue(_referencePolicyArray, i3), i3));
            }
        }
        if ((searchIncludeArray = JsonSupport.getJsonArray(jsonObject, "searchInclude", true)) != null) {
            JsonArray _searchIncludeArray = jsonObject.getJsonArray("_searchInclude");
            for (int i4 = 0; i4 < searchIncludeArray.size(); ++i4) {
                builder.searchInclude(this.parseString("searchInclude", (JsonValue)searchIncludeArray.get(i4), JsonSupport.getJsonValue(_searchIncludeArray, i4), i4));
            }
        }
        if ((searchRevIncludeArray = JsonSupport.getJsonArray(jsonObject, "searchRevInclude", true)) != null) {
            JsonArray _searchRevIncludeArray = jsonObject.getJsonArray("_searchRevInclude");
            for (i = 0; i < searchRevIncludeArray.size(); ++i) {
                builder.searchRevInclude(this.parseString("searchRevInclude", (JsonValue)searchRevIncludeArray.get(i), JsonSupport.getJsonValue(_searchRevIncludeArray, i), i));
            }
        }
        if ((searchParamArray = JsonSupport.getJsonArray(jsonObject, "searchParam")) != null) {
            for (i = 0; i < searchParamArray.size(); ++i) {
                if (((JsonValue)searchParamArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)searchParamArray.get(i)).getValueType() + " for element: searchParam");
                }
                builder.searchParam(this.parseCapabilityStatementRestResourceSearchParam("searchParam", searchParamArray.getJsonObject(i), i));
            }
        }
        if ((operationArray = JsonSupport.getJsonArray(jsonObject, "operation")) != null) {
            for (int i5 = 0; i5 < operationArray.size(); ++i5) {
                if (((JsonValue)operationArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)operationArray.get(i5)).getValueType() + " for element: operation");
                }
                builder.operation(this.parseCapabilityStatementRestResourceOperation("operation", operationArray.getJsonObject(i5), i5));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource.Interaction parseCapabilityStatementRestResourceInteraction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.Interaction.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.Interaction.Builder builder = CapabilityStatement.Rest.Resource.Interaction.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((TypeRestfulInteraction)this.parseString(TypeRestfulInteraction.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource.Operation parseCapabilityStatementRestResourceOperation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.Operation.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.Operation.Builder builder = CapabilityStatement.Rest.Resource.Operation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource.SearchParam parseCapabilityStatementRestResourceSearchParam(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.SearchParam.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.SearchParam.Builder builder = CapabilityStatement.Rest.Resource.SearchParam.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        builder.type((SearchParamType)this.parseString(SearchParamType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Security parseCapabilityStatementRestSecurity(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Security.class, jsonObject);
        }
        CapabilityStatement.Rest.Security.Builder builder = CapabilityStatement.Rest.Security.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.cors(this.parseBoolean("cors", JsonSupport.getJsonValue(jsonObject, "cors", JsonValue.class), (JsonValue)jsonObject.get((Object)"_cors"), -1));
        JsonArray serviceArray = JsonSupport.getJsonArray(jsonObject, "service");
        if (serviceArray != null) {
            for (int i = 0; i < serviceArray.size(); ++i) {
                if (((JsonValue)serviceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)serviceArray.get(i)).getValueType() + " for element: service");
                }
                builder.service(this.parseCodeableConcept("service", serviceArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Software parseCapabilityStatementSoftware(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Software.class, jsonObject);
        }
        CapabilityStatement.Software.Builder builder = CapabilityStatement.Software.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.releaseDate(this.parseDateTime("releaseDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "releaseDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_releaseDate"), -1));
        this.stackPop();
        return builder.build();
    }

    private CarePlan parseCarePlan(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray activityArray;
        JsonArray goalArray;
        JsonArray supportingInfoArray;
        JsonArray addressesArray;
        JsonArray careTeamArray;
        JsonArray partOfArray;
        JsonArray replacesArray;
        JsonArray basedOnArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CarePlan.class, jsonObject);
        }
        CarePlan.Builder builder = CarePlan.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((replacesArray = JsonSupport.getJsonArray(jsonObject, "replaces")) != null) {
            for (int i4 = 0; i4 < replacesArray.size(); ++i4) {
                if (((JsonValue)replacesArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)replacesArray.get(i4)).getValueType() + " for element: replaces");
                }
                builder.replaces(this.parseReference("replaces", replacesArray.getJsonObject(i4), i4));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (int i5 = 0; i5 < partOfArray.size(); ++i5) {
                if (((JsonValue)partOfArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)partOfArray.get(i5)).getValueType() + " for element: partOf");
                }
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i5), i5));
            }
        }
        builder.status((CarePlanStatus)this.parseString(CarePlanStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.intent((CarePlanIntent)this.parseString(CarePlanIntent.builder(), "intent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "intent", JsonString.class), (JsonValue)jsonObject.get((Object)"_intent"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i6 = 0; i6 < categoryArray.size(); ++i6) {
                if (((JsonValue)categoryArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i6)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i6), i6));
            }
        }
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        JsonArray contributorArray = JsonSupport.getJsonArray(jsonObject, "contributor");
        if (contributorArray != null) {
            for (int i7 = 0; i7 < contributorArray.size(); ++i7) {
                if (((JsonValue)contributorArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contributorArray.get(i7)).getValueType() + " for element: contributor");
                }
                builder.contributor(this.parseReference("contributor", contributorArray.getJsonObject(i7), i7));
            }
        }
        if ((careTeamArray = JsonSupport.getJsonArray(jsonObject, "careTeam")) != null) {
            for (int i8 = 0; i8 < careTeamArray.size(); ++i8) {
                if (((JsonValue)careTeamArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)careTeamArray.get(i8)).getValueType() + " for element: careTeam");
                }
                builder.careTeam(this.parseReference("careTeam", careTeamArray.getJsonObject(i8), i8));
            }
        }
        if ((addressesArray = JsonSupport.getJsonArray(jsonObject, "addresses")) != null) {
            for (int i9 = 0; i9 < addressesArray.size(); ++i9) {
                if (((JsonValue)addressesArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)addressesArray.get(i9)).getValueType() + " for element: addresses");
                }
                builder.addresses(this.parseReference("addresses", addressesArray.getJsonObject(i9), i9));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i10 = 0; i10 < supportingInfoArray.size(); ++i10) {
                if (((JsonValue)supportingInfoArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInfoArray.get(i10)).getValueType() + " for element: supportingInfo");
                }
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i10), i10));
            }
        }
        if ((goalArray = JsonSupport.getJsonArray(jsonObject, "goal")) != null) {
            for (int i11 = 0; i11 < goalArray.size(); ++i11) {
                if (((JsonValue)goalArray.get(i11)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)goalArray.get(i11)).getValueType() + " for element: goal");
                }
                builder.goal(this.parseReference("goal", goalArray.getJsonObject(i11), i11));
            }
        }
        if ((activityArray = JsonSupport.getJsonArray(jsonObject, "activity")) != null) {
            for (int i12 = 0; i12 < activityArray.size(); ++i12) {
                if (((JsonValue)activityArray.get(i12)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)activityArray.get(i12)).getValueType() + " for element: activity");
                }
                builder.activity(this.parseCarePlanActivity("activity", activityArray.getJsonObject(i12), i12));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i13 = 0; i13 < noteArray.size(); ++i13) {
                if (((JsonValue)noteArray.get(i13)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i13)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i13), i13));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CarePlan.Activity parseCarePlanActivity(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray progressArray;
        JsonArray outcomeReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CarePlan.Activity.class, jsonObject);
        }
        CarePlan.Activity.Builder builder = CarePlan.Activity.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray outcomeCodeableConceptArray = JsonSupport.getJsonArray(jsonObject, "outcomeCodeableConcept");
        if (outcomeCodeableConceptArray != null) {
            for (int i = 0; i < outcomeCodeableConceptArray.size(); ++i) {
                if (((JsonValue)outcomeCodeableConceptArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)outcomeCodeableConceptArray.get(i)).getValueType() + " for element: outcomeCodeableConcept");
                }
                builder.outcomeCodeableConcept(this.parseCodeableConcept("outcomeCodeableConcept", outcomeCodeableConceptArray.getJsonObject(i), i));
            }
        }
        if ((outcomeReferenceArray = JsonSupport.getJsonArray(jsonObject, "outcomeReference")) != null) {
            for (int i = 0; i < outcomeReferenceArray.size(); ++i) {
                if (((JsonValue)outcomeReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)outcomeReferenceArray.get(i)).getValueType() + " for element: outcomeReference");
                }
                builder.outcomeReference(this.parseReference("outcomeReference", outcomeReferenceArray.getJsonObject(i), i));
            }
        }
        if ((progressArray = JsonSupport.getJsonArray(jsonObject, "progress")) != null) {
            for (int i = 0; i < progressArray.size(); ++i) {
                if (((JsonValue)progressArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)progressArray.get(i)).getValueType() + " for element: progress");
                }
                builder.progress(this.parseAnnotation("progress", progressArray.getJsonObject(i), i));
            }
        }
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        builder.detail(this.parseCarePlanActivityDetail("detail", JsonSupport.getJsonValue(jsonObject, "detail", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CarePlan.Activity.Detail parseCarePlanActivityDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray goalArray;
        JsonArray reasonReferenceArray;
        int i;
        JsonArray instantiatesUriArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CarePlan.Activity.Detail.class, jsonObject);
        }
        CarePlan.Activity.Detail.Builder builder = CarePlan.Activity.Detail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.kind((CarePlanActivityKind)this.parseString(CarePlanActivityKind.builder(), "kind", (JsonValue)JsonSupport.getJsonValue(jsonObject, "kind", JsonString.class), (JsonValue)jsonObject.get((Object)"_kind"), -1));
        JsonArray instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true);
        if (instantiatesCanonicalArray != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i2 = 0; i2 < instantiatesCanonicalArray.size(); ++i2) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i2), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i2), i2));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (i = 0; i < reasonCodeArray.size(); ++i) {
                if (((JsonValue)reasonCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i3 = 0; i3 < reasonReferenceArray.size(); ++i3) {
                if (((JsonValue)reasonReferenceArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i3)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i3), i3));
            }
        }
        if ((goalArray = JsonSupport.getJsonArray(jsonObject, "goal")) != null) {
            for (int i4 = 0; i4 < goalArray.size(); ++i4) {
                if (((JsonValue)goalArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)goalArray.get(i4)).getValueType() + " for element: goal");
                }
                builder.goal(this.parseReference("goal", goalArray.getJsonObject(i4), i4));
            }
        }
        builder.status((CarePlanActivityStatus)this.parseString(CarePlanActivityStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        builder.scheduled(this.parseChoiceElement("scheduled", jsonObject, Timing.class, Period.class, org.linuxforhealth.fhir.model.type.String.class));
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i5 = 0; i5 < performerArray.size(); ++i5) {
                if (((JsonValue)performerArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)performerArray.get(i5)).getValueType() + " for element: performer");
                }
                builder.performer(this.parseReference("performer", performerArray.getJsonObject(i5), i5));
            }
        }
        builder.product(this.parseChoiceElement("product", jsonObject, CodeableConcept.class, Reference.class));
        builder.dailyAmount((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "dailyAmount", JsonSupport.getJsonValue(jsonObject, "dailyAmount", JsonObject.class), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private CareTeam parseCareTeam(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray telecomArray;
        JsonArray managingOrganizationArray;
        JsonArray reasonReferenceArray;
        JsonArray reasonCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CareTeam.class, jsonObject);
        }
        CareTeam.Builder builder = CareTeam.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((CareTeamStatus)this.parseString(CareTeamStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray participantArray = JsonSupport.getJsonArray(jsonObject, "participant");
        if (participantArray != null) {
            for (int i = 0; i < participantArray.size(); ++i) {
                if (((JsonValue)participantArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)participantArray.get(i)).getValueType() + " for element: participant");
                }
                builder.participant(this.parseCareTeamParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        if ((reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode")) != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                if (((JsonValue)reasonCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                if (((JsonValue)reasonReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((managingOrganizationArray = JsonSupport.getJsonArray(jsonObject, "managingOrganization")) != null) {
            for (int i = 0; i < managingOrganizationArray.size(); ++i) {
                if (((JsonValue)managingOrganizationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)managingOrganizationArray.get(i)).getValueType() + " for element: managingOrganization");
                }
                builder.managingOrganization(this.parseReference("managingOrganization", managingOrganizationArray.getJsonObject(i), i));
            }
        }
        if ((telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom")) != null) {
            for (int i = 0; i < telecomArray.size(); ++i) {
                if (((JsonValue)telecomArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)telecomArray.get(i)).getValueType() + " for element: telecom");
                }
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CareTeam.Participant parseCareTeamParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CareTeam.Participant.class, jsonObject);
        }
        CareTeam.Participant.Builder builder = CareTeam.Participant.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray roleArray = JsonSupport.getJsonArray(jsonObject, "role");
        if (roleArray != null) {
            for (int i = 0; i < roleArray.size(); ++i) {
                if (((JsonValue)roleArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)roleArray.get(i)).getValueType() + " for element: role");
                }
                builder.role(this.parseCodeableConcept("role", roleArray.getJsonObject(i), i));
            }
        }
        builder.member(this.parseReference("member", JsonSupport.getJsonValue(jsonObject, "member", JsonObject.class), -1));
        builder.onBehalfOf(this.parseReference("onBehalfOf", JsonSupport.getJsonValue(jsonObject, "onBehalfOf", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CatalogEntry parseCatalogEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relatedEntryArray;
        JsonArray additionalClassificationArray;
        JsonArray classificationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CatalogEntry.class, jsonObject);
        }
        CatalogEntry.Builder builder = CatalogEntry.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.orderable(this.parseBoolean("orderable", JsonSupport.getJsonValue(jsonObject, "orderable", JsonValue.class), (JsonValue)jsonObject.get((Object)"_orderable"), -1));
        builder.referencedItem(this.parseReference("referencedItem", JsonSupport.getJsonValue(jsonObject, "referencedItem", JsonObject.class), -1));
        JsonArray additionalIdentifierArray = JsonSupport.getJsonArray(jsonObject, "additionalIdentifier");
        if (additionalIdentifierArray != null) {
            for (int i = 0; i < additionalIdentifierArray.size(); ++i) {
                if (((JsonValue)additionalIdentifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)additionalIdentifierArray.get(i)).getValueType() + " for element: additionalIdentifier");
                }
                builder.additionalIdentifier(this.parseIdentifier("additionalIdentifier", additionalIdentifierArray.getJsonObject(i), i));
            }
        }
        if ((classificationArray = JsonSupport.getJsonArray(jsonObject, "classification")) != null) {
            for (int i = 0; i < classificationArray.size(); ++i) {
                if (((JsonValue)classificationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classificationArray.get(i)).getValueType() + " for element: classification");
                }
                builder.classification(this.parseCodeableConcept("classification", classificationArray.getJsonObject(i), i));
            }
        }
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.validityPeriod(this.parsePeriod("validityPeriod", JsonSupport.getJsonValue(jsonObject, "validityPeriod", JsonObject.class), -1));
        builder.validTo(this.parseDateTime("validTo", (JsonValue)JsonSupport.getJsonValue(jsonObject, "validTo", JsonString.class), (JsonValue)jsonObject.get((Object)"_validTo"), -1));
        builder.lastUpdated(this.parseDateTime("lastUpdated", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastUpdated", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastUpdated"), -1));
        JsonArray additionalCharacteristicArray = JsonSupport.getJsonArray(jsonObject, "additionalCharacteristic");
        if (additionalCharacteristicArray != null) {
            for (int i = 0; i < additionalCharacteristicArray.size(); ++i) {
                if (((JsonValue)additionalCharacteristicArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)additionalCharacteristicArray.get(i)).getValueType() + " for element: additionalCharacteristic");
                }
                builder.additionalCharacteristic(this.parseCodeableConcept("additionalCharacteristic", additionalCharacteristicArray.getJsonObject(i), i));
            }
        }
        if ((additionalClassificationArray = JsonSupport.getJsonArray(jsonObject, "additionalClassification")) != null) {
            for (int i = 0; i < additionalClassificationArray.size(); ++i) {
                if (((JsonValue)additionalClassificationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)additionalClassificationArray.get(i)).getValueType() + " for element: additionalClassification");
                }
                builder.additionalClassification(this.parseCodeableConcept("additionalClassification", additionalClassificationArray.getJsonObject(i), i));
            }
        }
        if ((relatedEntryArray = JsonSupport.getJsonArray(jsonObject, "relatedEntry")) != null) {
            for (int i = 0; i < relatedEntryArray.size(); ++i) {
                if (((JsonValue)relatedEntryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedEntryArray.get(i)).getValueType() + " for element: relatedEntry");
                }
                builder.relatedEntry(this.parseCatalogEntryRelatedEntry("relatedEntry", relatedEntryArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CatalogEntry.RelatedEntry parseCatalogEntryRelatedEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CatalogEntry.RelatedEntry.class, jsonObject);
        }
        CatalogEntry.RelatedEntry.Builder builder = CatalogEntry.RelatedEntry.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.relationtype((CatalogEntryRelationType)this.parseString(CatalogEntryRelationType.builder(), "relationtype", (JsonValue)JsonSupport.getJsonValue(jsonObject, "relationtype", JsonString.class), (JsonValue)jsonObject.get((Object)"_relationtype"), -1));
        builder.item(this.parseReference("item", JsonSupport.getJsonValue(jsonObject, "item", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ChargeItem parseChargeItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray supportingInformationArray;
        JsonArray noteArray;
        JsonArray serviceArray;
        int i;
        JsonArray definitionCanonicalArray;
        JsonArray definitionUriArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ChargeItem.class, jsonObject);
        }
        ChargeItem.Builder builder = ChargeItem.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((definitionUriArray = JsonSupport.getJsonArray(jsonObject, "definitionUri", true)) != null) {
            JsonArray _definitionUriArray = jsonObject.getJsonArray("_definitionUri");
            for (int i3 = 0; i3 < definitionUriArray.size(); ++i3) {
                builder.definitionUri(this.parseUri("definitionUri", (JsonValue)definitionUriArray.get(i3), JsonSupport.getJsonValue(_definitionUriArray, i3), i3));
            }
        }
        if ((definitionCanonicalArray = JsonSupport.getJsonArray(jsonObject, "definitionCanonical", true)) != null) {
            JsonArray _definitionCanonicalArray = jsonObject.getJsonArray("_definitionCanonical");
            for (i = 0; i < definitionCanonicalArray.size(); ++i) {
                builder.definitionCanonical((Canonical)this.parseUri(Canonical.builder(), "definitionCanonical", (JsonValue)definitionCanonicalArray.get(i), JsonSupport.getJsonValue(_definitionCanonicalArray, i), i));
            }
        }
        builder.status((ChargeItemStatus)this.parseString(ChargeItemStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf");
        if (partOfArray != null) {
            for (i = 0; i < partOfArray.size(); ++i) {
                if (((JsonValue)partOfArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)partOfArray.get(i)).getValueType() + " for element: partOf");
                }
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.context(this.parseReference("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class, Timing.class));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i4 = 0; i4 < performerArray.size(); ++i4) {
                if (((JsonValue)performerArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)performerArray.get(i4)).getValueType() + " for element: performer");
                }
                builder.performer(this.parseChargeItemPerformer("performer", performerArray.getJsonObject(i4), i4));
            }
        }
        builder.performingOrganization(this.parseReference("performingOrganization", JsonSupport.getJsonValue(jsonObject, "performingOrganization", JsonObject.class), -1));
        builder.requestingOrganization(this.parseReference("requestingOrganization", JsonSupport.getJsonValue(jsonObject, "requestingOrganization", JsonObject.class), -1));
        builder.costCenter(this.parseReference("costCenter", JsonSupport.getJsonValue(jsonObject, "costCenter", JsonObject.class), -1));
        builder.quantity(this.parseQuantity("quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        JsonArray bodysiteArray = JsonSupport.getJsonArray(jsonObject, "bodysite");
        if (bodysiteArray != null) {
            for (int i5 = 0; i5 < bodysiteArray.size(); ++i5) {
                if (((JsonValue)bodysiteArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)bodysiteArray.get(i5)).getValueType() + " for element: bodysite");
                }
                builder.bodysite(this.parseCodeableConcept("bodysite", bodysiteArray.getJsonObject(i5), i5));
            }
        }
        builder.factorOverride(this.parseDecimal("factorOverride", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factorOverride", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factorOverride"), -1));
        builder.priceOverride(this.parseMoney("priceOverride", JsonSupport.getJsonValue(jsonObject, "priceOverride", JsonObject.class), -1));
        builder.overrideReason(this.parseString("overrideReason", (JsonValue)JsonSupport.getJsonValue(jsonObject, "overrideReason", JsonString.class), (JsonValue)jsonObject.get((Object)"_overrideReason"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.enteredDate(this.parseDateTime("enteredDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "enteredDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_enteredDate"), -1));
        JsonArray reasonArray = JsonSupport.getJsonArray(jsonObject, "reason");
        if (reasonArray != null) {
            for (int i6 = 0; i6 < reasonArray.size(); ++i6) {
                if (((JsonValue)reasonArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonArray.get(i6)).getValueType() + " for element: reason");
                }
                builder.reason(this.parseCodeableConcept("reason", reasonArray.getJsonObject(i6), i6));
            }
        }
        if ((serviceArray = JsonSupport.getJsonArray(jsonObject, "service")) != null) {
            for (int i7 = 0; i7 < serviceArray.size(); ++i7) {
                if (((JsonValue)serviceArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)serviceArray.get(i7)).getValueType() + " for element: service");
                }
                builder.service(this.parseReference("service", serviceArray.getJsonObject(i7), i7));
            }
        }
        builder.product(this.parseChoiceElement("product", jsonObject, Reference.class, CodeableConcept.class));
        JsonArray accountArray = JsonSupport.getJsonArray(jsonObject, "account");
        if (accountArray != null) {
            for (int i8 = 0; i8 < accountArray.size(); ++i8) {
                if (((JsonValue)accountArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)accountArray.get(i8)).getValueType() + " for element: account");
                }
                builder.account(this.parseReference("account", accountArray.getJsonObject(i8), i8));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i9 = 0; i9 < noteArray.size(); ++i9) {
                if (((JsonValue)noteArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i9)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i9), i9));
            }
        }
        if ((supportingInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingInformation")) != null) {
            for (int i10 = 0; i10 < supportingInformationArray.size(); ++i10) {
                if (((JsonValue)supportingInformationArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInformationArray.get(i10)).getValueType() + " for element: supportingInformation");
                }
                builder.supportingInformation(this.parseReference("supportingInformation", supportingInformationArray.getJsonObject(i10), i10));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ChargeItem.Performer parseChargeItemPerformer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ChargeItem.Performer.class, jsonObject);
        }
        ChargeItem.Performer.Builder builder = ChargeItem.Performer.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.function(this.parseCodeableConcept("function", JsonSupport.getJsonValue(jsonObject, "function", JsonObject.class), -1));
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition parseChargeItemDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray propertyGroupArray;
        JsonArray applicabilityArray;
        JsonArray jurisdictionArray;
        int i;
        JsonArray replacesArray;
        JsonArray partOfArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.class, jsonObject);
        }
        ChargeItemDefinition.Builder builder = ChargeItemDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        JsonArray derivedFromUriArray = JsonSupport.getJsonArray(jsonObject, "derivedFromUri", true);
        if (derivedFromUriArray != null) {
            JsonArray _derivedFromUriArray = jsonObject.getJsonArray("_derivedFromUri");
            for (int i3 = 0; i3 < derivedFromUriArray.size(); ++i3) {
                builder.derivedFromUri(this.parseUri("derivedFromUri", (JsonValue)derivedFromUriArray.get(i3), JsonSupport.getJsonValue(_derivedFromUriArray, i3), i3));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf", true)) != null) {
            JsonArray _partOfArray = jsonObject.getJsonArray("_partOf");
            for (int i4 = 0; i4 < partOfArray.size(); ++i4) {
                builder.partOf((Canonical)this.parseUri(Canonical.builder(), "partOf", (JsonValue)partOfArray.get(i4), JsonSupport.getJsonValue(_partOfArray, i4), i4));
            }
        }
        if ((replacesArray = JsonSupport.getJsonArray(jsonObject, "replaces", true)) != null) {
            JsonArray _replacesArray = jsonObject.getJsonArray("_replaces");
            for (i = 0; i < replacesArray.size(); ++i) {
                builder.replaces((Canonical)this.parseUri(Canonical.builder(), "replaces", (JsonValue)replacesArray.get(i), JsonSupport.getJsonValue(_replacesArray, i), i));
            }
        }
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i5 = 0; i5 < useContextArray.size(); ++i5) {
                if (((JsonValue)useContextArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i5)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i5), i5));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i6 = 0; i6 < jurisdictionArray.size(); ++i6) {
                if (((JsonValue)jurisdictionArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i6)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i6), i6));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray instanceArray = JsonSupport.getJsonArray(jsonObject, "instance");
        if (instanceArray != null) {
            for (int i7 = 0; i7 < instanceArray.size(); ++i7) {
                if (((JsonValue)instanceArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)instanceArray.get(i7)).getValueType() + " for element: instance");
                }
                builder.instance(this.parseReference("instance", instanceArray.getJsonObject(i7), i7));
            }
        }
        if ((applicabilityArray = JsonSupport.getJsonArray(jsonObject, "applicability")) != null) {
            for (int i8 = 0; i8 < applicabilityArray.size(); ++i8) {
                if (((JsonValue)applicabilityArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)applicabilityArray.get(i8)).getValueType() + " for element: applicability");
                }
                builder.applicability(this.parseChargeItemDefinitionApplicability("applicability", applicabilityArray.getJsonObject(i8), i8));
            }
        }
        if ((propertyGroupArray = JsonSupport.getJsonArray(jsonObject, "propertyGroup")) != null) {
            for (int i9 = 0; i9 < propertyGroupArray.size(); ++i9) {
                if (((JsonValue)propertyGroupArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)propertyGroupArray.get(i9)).getValueType() + " for element: propertyGroup");
                }
                builder.propertyGroup(this.parseChargeItemDefinitionPropertyGroup("propertyGroup", propertyGroupArray.getJsonObject(i9), i9));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition.Applicability parseChargeItemDefinitionApplicability(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.Applicability.class, jsonObject);
        }
        ChargeItemDefinition.Applicability.Builder builder = ChargeItemDefinition.Applicability.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.language(this.parseString("language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition.PropertyGroup parseChargeItemDefinitionPropertyGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray priceComponentArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.PropertyGroup.class, jsonObject);
        }
        ChargeItemDefinition.PropertyGroup.Builder builder = ChargeItemDefinition.PropertyGroup.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray applicabilityArray = JsonSupport.getJsonArray(jsonObject, "applicability");
        if (applicabilityArray != null) {
            for (int i = 0; i < applicabilityArray.size(); ++i) {
                if (((JsonValue)applicabilityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)applicabilityArray.get(i)).getValueType() + " for element: applicability");
                }
                builder.applicability(this.parseChargeItemDefinitionApplicability("applicability", applicabilityArray.getJsonObject(i), i));
            }
        }
        if ((priceComponentArray = JsonSupport.getJsonArray(jsonObject, "priceComponent")) != null) {
            for (int i = 0; i < priceComponentArray.size(); ++i) {
                if (((JsonValue)priceComponentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)priceComponentArray.get(i)).getValueType() + " for element: priceComponent");
                }
                builder.priceComponent(this.parseChargeItemDefinitionPropertyGroupPriceComponent("priceComponent", priceComponentArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition.PropertyGroup.PriceComponent parseChargeItemDefinitionPropertyGroupPriceComponent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.PropertyGroup.PriceComponent.class, jsonObject);
        }
        ChargeItemDefinition.PropertyGroup.PriceComponent.Builder builder = ChargeItemDefinition.PropertyGroup.PriceComponent.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ChargeItemDefinitionPriceComponentType)this.parseString(ChargeItemDefinitionPriceComponentType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation parseCitation(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relatesToArray;
        JsonArray statusDateArray;
        JsonArray currentStateArray;
        JsonArray noteArray;
        JsonArray classificationArray;
        JsonArray summaryArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.class, jsonObject);
        }
        Citation.Builder builder = Citation.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                if (((JsonValue)jurisdictionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                if (((JsonValue)editorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)editorArray.get(i)).getValueType() + " for element: editor");
                }
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                if (((JsonValue)reviewerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reviewerArray.get(i)).getValueType() + " for element: reviewer");
                }
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                if (((JsonValue)endorserArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)endorserArray.get(i)).getValueType() + " for element: endorser");
                }
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((summaryArray = JsonSupport.getJsonArray(jsonObject, "summary")) != null) {
            for (int i = 0; i < summaryArray.size(); ++i) {
                if (((JsonValue)summaryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)summaryArray.get(i)).getValueType() + " for element: summary");
                }
                builder.summary(this.parseCitationSummary("summary", summaryArray.getJsonObject(i), i));
            }
        }
        if ((classificationArray = JsonSupport.getJsonArray(jsonObject, "classification")) != null) {
            for (int i = 0; i < classificationArray.size(); ++i) {
                if (((JsonValue)classificationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classificationArray.get(i)).getValueType() + " for element: classification");
                }
                builder.classification(this.parseCitationClassification("classification", classificationArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((currentStateArray = JsonSupport.getJsonArray(jsonObject, "currentState")) != null) {
            for (int i = 0; i < currentStateArray.size(); ++i) {
                if (((JsonValue)currentStateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)currentStateArray.get(i)).getValueType() + " for element: currentState");
                }
                builder.currentState(this.parseCodeableConcept("currentState", currentStateArray.getJsonObject(i), i));
            }
        }
        if ((statusDateArray = JsonSupport.getJsonArray(jsonObject, "statusDate")) != null) {
            for (int i = 0; i < statusDateArray.size(); ++i) {
                if (((JsonValue)statusDateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)statusDateArray.get(i)).getValueType() + " for element: statusDate");
                }
                builder.statusDate(this.parseCitationStatusDate("statusDate", statusDateArray.getJsonObject(i), i));
            }
        }
        if ((relatesToArray = JsonSupport.getJsonArray(jsonObject, "relatesTo")) != null) {
            for (int i = 0; i < relatesToArray.size(); ++i) {
                if (((JsonValue)relatesToArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatesToArray.get(i)).getValueType() + " for element: relatesTo");
                }
                builder.relatesTo(this.parseCitationRelatesTo("relatesTo", relatesToArray.getJsonObject(i), i));
            }
        }
        builder.citedArtifact(this.parseCitationCitedArtifact("citedArtifact", JsonSupport.getJsonValue(jsonObject, "citedArtifact", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact parseCitationCitedArtifact(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray classificationArray;
        JsonArray webLocationArray;
        JsonArray publicationFormArray;
        JsonArray abstractArray;
        JsonArray titleArray;
        JsonArray statusDateArray;
        JsonArray relatedIdentifierArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.class, jsonObject);
        }
        Citation.CitedArtifact.Builder builder = Citation.CitedArtifact.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((relatedIdentifierArray = JsonSupport.getJsonArray(jsonObject, "relatedIdentifier")) != null) {
            for (int i = 0; i < relatedIdentifierArray.size(); ++i) {
                if (((JsonValue)relatedIdentifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedIdentifierArray.get(i)).getValueType() + " for element: relatedIdentifier");
                }
                builder.relatedIdentifier(this.parseIdentifier("relatedIdentifier", relatedIdentifierArray.getJsonObject(i), i));
            }
        }
        builder.dateAccessed(this.parseDateTime("dateAccessed", (JsonValue)JsonSupport.getJsonValue(jsonObject, "dateAccessed", JsonString.class), (JsonValue)jsonObject.get((Object)"_dateAccessed"), -1));
        builder.version(this.parseCitationCitedArtifactVersion("version", JsonSupport.getJsonValue(jsonObject, "version", JsonObject.class), -1));
        JsonArray currentStateArray = JsonSupport.getJsonArray(jsonObject, "currentState");
        if (currentStateArray != null) {
            for (int i = 0; i < currentStateArray.size(); ++i) {
                if (((JsonValue)currentStateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)currentStateArray.get(i)).getValueType() + " for element: currentState");
                }
                builder.currentState(this.parseCodeableConcept("currentState", currentStateArray.getJsonObject(i), i));
            }
        }
        if ((statusDateArray = JsonSupport.getJsonArray(jsonObject, "statusDate")) != null) {
            for (int i = 0; i < statusDateArray.size(); ++i) {
                if (((JsonValue)statusDateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)statusDateArray.get(i)).getValueType() + " for element: statusDate");
                }
                builder.statusDate(this.parseCitationCitedArtifactStatusDate("statusDate", statusDateArray.getJsonObject(i), i));
            }
        }
        if ((titleArray = JsonSupport.getJsonArray(jsonObject, "title")) != null) {
            for (int i = 0; i < titleArray.size(); ++i) {
                if (((JsonValue)titleArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)titleArray.get(i)).getValueType() + " for element: title");
                }
                builder.title(this.parseCitationCitedArtifactTitle("title", titleArray.getJsonObject(i), i));
            }
        }
        if ((abstractArray = JsonSupport.getJsonArray(jsonObject, "abstract")) != null) {
            for (int i = 0; i < abstractArray.size(); ++i) {
                if (((JsonValue)abstractArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)abstractArray.get(i)).getValueType() + " for element: abstract");
                }
                builder._abstract(this.parseCitationCitedArtifactAbstract("abstract", abstractArray.getJsonObject(i), i));
            }
        }
        builder.part(this.parseCitationCitedArtifactPart("part", JsonSupport.getJsonValue(jsonObject, "part", JsonObject.class), -1));
        JsonArray relatesToArray = JsonSupport.getJsonArray(jsonObject, "relatesTo");
        if (relatesToArray != null) {
            for (int i = 0; i < relatesToArray.size(); ++i) {
                if (((JsonValue)relatesToArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatesToArray.get(i)).getValueType() + " for element: relatesTo");
                }
                builder.relatesTo(this.parseCitationCitedArtifactRelatesTo("relatesTo", relatesToArray.getJsonObject(i), i));
            }
        }
        if ((publicationFormArray = JsonSupport.getJsonArray(jsonObject, "publicationForm")) != null) {
            for (int i = 0; i < publicationFormArray.size(); ++i) {
                if (((JsonValue)publicationFormArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)publicationFormArray.get(i)).getValueType() + " for element: publicationForm");
                }
                builder.publicationForm(this.parseCitationCitedArtifactPublicationForm("publicationForm", publicationFormArray.getJsonObject(i), i));
            }
        }
        if ((webLocationArray = JsonSupport.getJsonArray(jsonObject, "webLocation")) != null) {
            for (int i = 0; i < webLocationArray.size(); ++i) {
                if (((JsonValue)webLocationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)webLocationArray.get(i)).getValueType() + " for element: webLocation");
                }
                builder.webLocation(this.parseCitationCitedArtifactWebLocation("webLocation", webLocationArray.getJsonObject(i), i));
            }
        }
        if ((classificationArray = JsonSupport.getJsonArray(jsonObject, "classification")) != null) {
            for (int i = 0; i < classificationArray.size(); ++i) {
                if (((JsonValue)classificationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classificationArray.get(i)).getValueType() + " for element: classification");
                }
                builder.classification(this.parseCitationCitedArtifactClassification("classification", classificationArray.getJsonObject(i), i));
            }
        }
        builder.contributorship(this.parseCitationCitedArtifactContributorship("contributorship", JsonSupport.getJsonValue(jsonObject, "contributorship", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Abstract parseCitationCitedArtifactAbstract(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Abstract.class, jsonObject);
        }
        Citation.CitedArtifact.Abstract.Builder builder = Citation.CitedArtifact.Abstract.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.language(this.parseCodeableConcept("language", JsonSupport.getJsonValue(jsonObject, "language", JsonObject.class), -1));
        builder.text((Markdown)this.parseString(Markdown.builder(), "text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Classification parseCitationCitedArtifactClassification(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Classification.class, jsonObject);
        }
        Citation.CitedArtifact.Classification.Builder builder = Citation.CitedArtifact.Classification.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray classifierArray = JsonSupport.getJsonArray(jsonObject, "classifier");
        if (classifierArray != null) {
            for (int i = 0; i < classifierArray.size(); ++i) {
                if (((JsonValue)classifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classifierArray.get(i)).getValueType() + " for element: classifier");
                }
                builder.classifier(this.parseCodeableConcept("classifier", classifierArray.getJsonObject(i), i));
            }
        }
        builder.whoClassified(this.parseCitationCitedArtifactClassificationWhoClassified("whoClassified", JsonSupport.getJsonValue(jsonObject, "whoClassified", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Classification.WhoClassified parseCitationCitedArtifactClassificationWhoClassified(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Classification.WhoClassified.class, jsonObject);
        }
        Citation.CitedArtifact.Classification.WhoClassified.Builder builder = Citation.CitedArtifact.Classification.WhoClassified.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.person(this.parseReference("person", JsonSupport.getJsonValue(jsonObject, "person", JsonObject.class), -1));
        builder.organization(this.parseReference("organization", JsonSupport.getJsonValue(jsonObject, "organization", JsonObject.class), -1));
        builder.publisher(this.parseReference("publisher", JsonSupport.getJsonValue(jsonObject, "publisher", JsonObject.class), -1));
        builder.classifierCopyright(this.parseString("classifierCopyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "classifierCopyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_classifierCopyright"), -1));
        builder.freeToShare(this.parseBoolean("freeToShare", JsonSupport.getJsonValue(jsonObject, "freeToShare", JsonValue.class), (JsonValue)jsonObject.get((Object)"_freeToShare"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Contributorship parseCitationCitedArtifactContributorship(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray summaryArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Contributorship.class, jsonObject);
        }
        Citation.CitedArtifact.Contributorship.Builder builder = Citation.CitedArtifact.Contributorship.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.complete(this.parseBoolean("complete", JsonSupport.getJsonValue(jsonObject, "complete", JsonValue.class), (JsonValue)jsonObject.get((Object)"_complete"), -1));
        JsonArray entryArray = JsonSupport.getJsonArray(jsonObject, "entry");
        if (entryArray != null) {
            for (int i = 0; i < entryArray.size(); ++i) {
                if (((JsonValue)entryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)entryArray.get(i)).getValueType() + " for element: entry");
                }
                builder.entry(this.parseCitationCitedArtifactContributorshipEntry("entry", entryArray.getJsonObject(i), i));
            }
        }
        if ((summaryArray = JsonSupport.getJsonArray(jsonObject, "summary")) != null) {
            for (int i = 0; i < summaryArray.size(); ++i) {
                if (((JsonValue)summaryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)summaryArray.get(i)).getValueType() + " for element: summary");
                }
                builder.summary(this.parseCitationCitedArtifactContributorshipSummary("summary", summaryArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Contributorship.Entry parseCitationCitedArtifactContributorshipEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray contributionTypeArray;
        JsonArray telecomArray;
        JsonArray addressArray;
        JsonArray affiliationInfoArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Contributorship.Entry.class, jsonObject);
        }
        Citation.CitedArtifact.Contributorship.Entry.Builder builder = Citation.CitedArtifact.Contributorship.Entry.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseHumanName("name", JsonSupport.getJsonValue(jsonObject, "name", JsonObject.class), -1));
        builder.initials(this.parseString("initials", (JsonValue)JsonSupport.getJsonValue(jsonObject, "initials", JsonString.class), (JsonValue)jsonObject.get((Object)"_initials"), -1));
        builder.collectiveName(this.parseString("collectiveName", (JsonValue)JsonSupport.getJsonValue(jsonObject, "collectiveName", JsonString.class), (JsonValue)jsonObject.get((Object)"_collectiveName"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((affiliationInfoArray = JsonSupport.getJsonArray(jsonObject, "affiliationInfo")) != null) {
            for (int i = 0; i < affiliationInfoArray.size(); ++i) {
                if (((JsonValue)affiliationInfoArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)affiliationInfoArray.get(i)).getValueType() + " for element: affiliationInfo");
                }
                builder.affiliationInfo(this.parseCitationCitedArtifactContributorshipEntryAffiliationInfo("affiliationInfo", affiliationInfoArray.getJsonObject(i), i));
            }
        }
        if ((addressArray = JsonSupport.getJsonArray(jsonObject, "address")) != null) {
            for (int i = 0; i < addressArray.size(); ++i) {
                if (((JsonValue)addressArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)addressArray.get(i)).getValueType() + " for element: address");
                }
                builder.address(this.parseAddress("address", addressArray.getJsonObject(i), i));
            }
        }
        if ((telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom")) != null) {
            for (int i = 0; i < telecomArray.size(); ++i) {
                if (((JsonValue)telecomArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)telecomArray.get(i)).getValueType() + " for element: telecom");
                }
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i), i));
            }
        }
        if ((contributionTypeArray = JsonSupport.getJsonArray(jsonObject, "contributionType")) != null) {
            for (int i = 0; i < contributionTypeArray.size(); ++i) {
                if (((JsonValue)contributionTypeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contributionTypeArray.get(i)).getValueType() + " for element: contributionType");
                }
                builder.contributionType(this.parseCodeableConcept("contributionType", contributionTypeArray.getJsonObject(i), i));
            }
        }
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        JsonArray contributionInstanceArray = JsonSupport.getJsonArray(jsonObject, "contributionInstance");
        if (contributionInstanceArray != null) {
            for (int i = 0; i < contributionInstanceArray.size(); ++i) {
                if (((JsonValue)contributionInstanceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contributionInstanceArray.get(i)).getValueType() + " for element: contributionInstance");
                }
                builder.contributionInstance(this.parseCitationCitedArtifactContributorshipEntryContributionInstance("contributionInstance", contributionInstanceArray.getJsonObject(i), i));
            }
        }
        builder.correspondingContact(this.parseBoolean("correspondingContact", JsonSupport.getJsonValue(jsonObject, "correspondingContact", JsonValue.class), (JsonValue)jsonObject.get((Object)"_correspondingContact"), -1));
        builder.listOrder((PositiveInt)this.parseInteger(PositiveInt.builder(), "listOrder", (JsonValue)JsonSupport.getJsonValue(jsonObject, "listOrder", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_listOrder"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Contributorship.Entry.AffiliationInfo parseCitationCitedArtifactContributorshipEntryAffiliationInfo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Contributorship.Entry.AffiliationInfo.class, jsonObject);
        }
        Citation.CitedArtifact.Contributorship.Entry.AffiliationInfo.Builder builder = Citation.CitedArtifact.Contributorship.Entry.AffiliationInfo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.affiliation(this.parseString("affiliation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "affiliation", JsonString.class), (JsonValue)jsonObject.get((Object)"_affiliation"), -1));
        builder.role(this.parseString("role", (JsonValue)JsonSupport.getJsonValue(jsonObject, "role", JsonString.class), (JsonValue)jsonObject.get((Object)"_role"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Contributorship.Entry.ContributionInstance parseCitationCitedArtifactContributorshipEntryContributionInstance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Contributorship.Entry.ContributionInstance.class, jsonObject);
        }
        Citation.CitedArtifact.Contributorship.Entry.ContributionInstance.Builder builder = Citation.CitedArtifact.Contributorship.Entry.ContributionInstance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.time(this.parseDateTime("time", (JsonValue)JsonSupport.getJsonValue(jsonObject, "time", JsonString.class), (JsonValue)jsonObject.get((Object)"_time"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Contributorship.Summary parseCitationCitedArtifactContributorshipSummary(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Contributorship.Summary.class, jsonObject);
        }
        Citation.CitedArtifact.Contributorship.Summary.Builder builder = Citation.CitedArtifact.Contributorship.Summary.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.style(this.parseCodeableConcept("style", JsonSupport.getJsonValue(jsonObject, "style", JsonObject.class), -1));
        builder.source(this.parseCodeableConcept("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.value((Markdown)this.parseString(Markdown.builder(), "value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Part parseCitationCitedArtifactPart(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Part.class, jsonObject);
        }
        Citation.CitedArtifact.Part.Builder builder = Citation.CitedArtifact.Part.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.baseCitation(this.parseReference("baseCitation", JsonSupport.getJsonValue(jsonObject, "baseCitation", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.PublicationForm parseCitationCitedArtifactPublicationForm(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.PublicationForm.class, jsonObject);
        }
        Citation.CitedArtifact.PublicationForm.Builder builder = Citation.CitedArtifact.PublicationForm.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.publishedIn(this.parseCitationCitedArtifactPublicationFormPublishedIn("publishedIn", JsonSupport.getJsonValue(jsonObject, "publishedIn", JsonObject.class), -1));
        builder.periodicRelease(this.parseCitationCitedArtifactPublicationFormPeriodicRelease("periodicRelease", JsonSupport.getJsonValue(jsonObject, "periodicRelease", JsonObject.class), -1));
        builder.articleDate(this.parseDateTime("articleDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "articleDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_articleDate"), -1));
        builder.lastRevisionDate(this.parseDateTime("lastRevisionDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastRevisionDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastRevisionDate"), -1));
        JsonArray languageArray = JsonSupport.getJsonArray(jsonObject, "language");
        if (languageArray != null) {
            for (int i = 0; i < languageArray.size(); ++i) {
                if (((JsonValue)languageArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)languageArray.get(i)).getValueType() + " for element: language");
                }
                builder.language(this.parseCodeableConcept("language", languageArray.getJsonObject(i), i));
            }
        }
        builder.accessionNumber(this.parseString("accessionNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "accessionNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_accessionNumber"), -1));
        builder.pageString(this.parseString("pageString", (JsonValue)JsonSupport.getJsonValue(jsonObject, "pageString", JsonString.class), (JsonValue)jsonObject.get((Object)"_pageString"), -1));
        builder.firstPage(this.parseString("firstPage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "firstPage", JsonString.class), (JsonValue)jsonObject.get((Object)"_firstPage"), -1));
        builder.lastPage(this.parseString("lastPage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastPage", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastPage"), -1));
        builder.pageCount(this.parseString("pageCount", (JsonValue)JsonSupport.getJsonValue(jsonObject, "pageCount", JsonString.class), (JsonValue)jsonObject.get((Object)"_pageCount"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.PublicationForm.PeriodicRelease parseCitationCitedArtifactPublicationFormPeriodicRelease(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.PublicationForm.PeriodicRelease.class, jsonObject);
        }
        Citation.CitedArtifact.PublicationForm.PeriodicRelease.Builder builder = Citation.CitedArtifact.PublicationForm.PeriodicRelease.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.citedMedium(this.parseCodeableConcept("citedMedium", JsonSupport.getJsonValue(jsonObject, "citedMedium", JsonObject.class), -1));
        builder.volume(this.parseString("volume", (JsonValue)JsonSupport.getJsonValue(jsonObject, "volume", JsonString.class), (JsonValue)jsonObject.get((Object)"_volume"), -1));
        builder.issue(this.parseString("issue", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issue", JsonString.class), (JsonValue)jsonObject.get((Object)"_issue"), -1));
        builder.dateOfPublication(this.parseCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublication("dateOfPublication", JsonSupport.getJsonValue(jsonObject, "dateOfPublication", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.PublicationForm.PeriodicRelease.DateOfPublication parseCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublication(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.PublicationForm.PeriodicRelease.DateOfPublication.class, jsonObject);
        }
        Citation.CitedArtifact.PublicationForm.PeriodicRelease.DateOfPublication.Builder builder = Citation.CitedArtifact.PublicationForm.PeriodicRelease.DateOfPublication.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.year(this.parseString("year", (JsonValue)JsonSupport.getJsonValue(jsonObject, "year", JsonString.class), (JsonValue)jsonObject.get((Object)"_year"), -1));
        builder.month(this.parseString("month", (JsonValue)JsonSupport.getJsonValue(jsonObject, "month", JsonString.class), (JsonValue)jsonObject.get((Object)"_month"), -1));
        builder.day(this.parseString("day", (JsonValue)JsonSupport.getJsonValue(jsonObject, "day", JsonString.class), (JsonValue)jsonObject.get((Object)"_day"), -1));
        builder.season(this.parseString("season", (JsonValue)JsonSupport.getJsonValue(jsonObject, "season", JsonString.class), (JsonValue)jsonObject.get((Object)"_season"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.PublicationForm.PublishedIn parseCitationCitedArtifactPublicationFormPublishedIn(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.PublicationForm.PublishedIn.class, jsonObject);
        }
        Citation.CitedArtifact.PublicationForm.PublishedIn.Builder builder = Citation.CitedArtifact.PublicationForm.PublishedIn.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.publisher(this.parseReference("publisher", JsonSupport.getJsonValue(jsonObject, "publisher", JsonObject.class), -1));
        builder.publisherLocation(this.parseString("publisherLocation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisherLocation", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisherLocation"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.RelatesTo parseCitationCitedArtifactRelatesTo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.RelatesTo.class, jsonObject);
        }
        Citation.CitedArtifact.RelatesTo.Builder builder = Citation.CitedArtifact.RelatesTo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.relationshipType(this.parseCodeableConcept("relationshipType", JsonSupport.getJsonValue(jsonObject, "relationshipType", JsonObject.class), -1));
        JsonArray targetClassifierArray = JsonSupport.getJsonArray(jsonObject, "targetClassifier");
        if (targetClassifierArray != null) {
            for (int i = 0; i < targetClassifierArray.size(); ++i) {
                if (((JsonValue)targetClassifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)targetClassifierArray.get(i)).getValueType() + " for element: targetClassifier");
                }
                builder.targetClassifier(this.parseCodeableConcept("targetClassifier", targetClassifierArray.getJsonObject(i), i));
            }
        }
        builder.target(this.parseChoiceElement("target", jsonObject, Uri.class, Identifier.class, Reference.class, Attachment.class));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.StatusDate parseCitationCitedArtifactStatusDate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.StatusDate.class, jsonObject);
        }
        Citation.CitedArtifact.StatusDate.Builder builder = Citation.CitedArtifact.StatusDate.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.activity(this.parseCodeableConcept("activity", JsonSupport.getJsonValue(jsonObject, "activity", JsonObject.class), -1));
        builder.actual(this.parseBoolean("actual", JsonSupport.getJsonValue(jsonObject, "actual", JsonValue.class), (JsonValue)jsonObject.get((Object)"_actual"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Title parseCitationCitedArtifactTitle(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Title.class, jsonObject);
        }
        Citation.CitedArtifact.Title.Builder builder = Citation.CitedArtifact.Title.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.language(this.parseCodeableConcept("language", JsonSupport.getJsonValue(jsonObject, "language", JsonObject.class), -1));
        builder.text((Markdown)this.parseString(Markdown.builder(), "text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.Version parseCitationCitedArtifactVersion(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.Version.class, jsonObject);
        }
        Citation.CitedArtifact.Version.Builder builder = Citation.CitedArtifact.Version.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.baseCitation(this.parseReference("baseCitation", JsonSupport.getJsonValue(jsonObject, "baseCitation", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.CitedArtifact.WebLocation parseCitationCitedArtifactWebLocation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.CitedArtifact.WebLocation.class, jsonObject);
        }
        Citation.CitedArtifact.WebLocation.Builder builder = Citation.CitedArtifact.WebLocation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.Classification parseCitationClassification(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.Classification.class, jsonObject);
        }
        Citation.Classification.Builder builder = Citation.Classification.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray classifierArray = JsonSupport.getJsonArray(jsonObject, "classifier");
        if (classifierArray != null) {
            for (int i = 0; i < classifierArray.size(); ++i) {
                if (((JsonValue)classifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classifierArray.get(i)).getValueType() + " for element: classifier");
                }
                builder.classifier(this.parseCodeableConcept("classifier", classifierArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Citation.RelatesTo parseCitationRelatesTo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.RelatesTo.class, jsonObject);
        }
        Citation.RelatesTo.Builder builder = Citation.RelatesTo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.relationshipType(this.parseCodeableConcept("relationshipType", JsonSupport.getJsonValue(jsonObject, "relationshipType", JsonObject.class), -1));
        JsonArray targetClassifierArray = JsonSupport.getJsonArray(jsonObject, "targetClassifier");
        if (targetClassifierArray != null) {
            for (int i = 0; i < targetClassifierArray.size(); ++i) {
                if (((JsonValue)targetClassifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)targetClassifierArray.get(i)).getValueType() + " for element: targetClassifier");
                }
                builder.targetClassifier(this.parseCodeableConcept("targetClassifier", targetClassifierArray.getJsonObject(i), i));
            }
        }
        builder.target(this.parseChoiceElement("target", jsonObject, Uri.class, Identifier.class, Reference.class, Attachment.class));
        this.stackPop();
        return builder.build();
    }

    private Citation.StatusDate parseCitationStatusDate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.StatusDate.class, jsonObject);
        }
        Citation.StatusDate.Builder builder = Citation.StatusDate.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.activity(this.parseCodeableConcept("activity", JsonSupport.getJsonValue(jsonObject, "activity", JsonObject.class), -1));
        builder.actual(this.parseBoolean("actual", JsonSupport.getJsonValue(jsonObject, "actual", JsonValue.class), (JsonValue)jsonObject.get((Object)"_actual"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Citation.Summary parseCitationSummary(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Citation.Summary.class, jsonObject);
        }
        Citation.Summary.Builder builder = Citation.Summary.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.style(this.parseCodeableConcept("style", JsonSupport.getJsonValue(jsonObject, "style", JsonObject.class), -1));
        builder.text((Markdown)this.parseString(Markdown.builder(), "text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim parseClaim(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray insuranceArray;
        JsonArray procedureArray;
        JsonArray diagnosisArray;
        JsonArray supportingInfoArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.class, jsonObject);
        }
        Claim.Builder builder = Claim.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ClaimStatus)this.parseString(ClaimStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.use((Use)this.parseString(Use.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.billablePeriod(this.parsePeriod("billablePeriod", JsonSupport.getJsonValue(jsonObject, "billablePeriod", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.fundsReserve(this.parseCodeableConcept("fundsReserve", JsonSupport.getJsonValue(jsonObject, "fundsReserve", JsonObject.class), -1));
        JsonArray relatedArray = JsonSupport.getJsonArray(jsonObject, "related");
        if (relatedArray != null) {
            for (int i = 0; i < relatedArray.size(); ++i) {
                if (((JsonValue)relatedArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArray.get(i)).getValueType() + " for element: related");
                }
                builder.related(this.parseClaimRelated("related", relatedArray.getJsonObject(i), i));
            }
        }
        builder.prescription(this.parseReference("prescription", JsonSupport.getJsonValue(jsonObject, "prescription", JsonObject.class), -1));
        builder.originalPrescription(this.parseReference("originalPrescription", JsonSupport.getJsonValue(jsonObject, "originalPrescription", JsonObject.class), -1));
        builder.payee(this.parseClaimPayee("payee", JsonSupport.getJsonValue(jsonObject, "payee", JsonObject.class), -1));
        builder.referral(this.parseReference("referral", JsonSupport.getJsonValue(jsonObject, "referral", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        JsonArray careTeamArray = JsonSupport.getJsonArray(jsonObject, "careTeam");
        if (careTeamArray != null) {
            for (int i = 0; i < careTeamArray.size(); ++i) {
                if (((JsonValue)careTeamArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)careTeamArray.get(i)).getValueType() + " for element: careTeam");
                }
                builder.careTeam(this.parseClaimCareTeam("careTeam", careTeamArray.getJsonObject(i), i));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i = 0; i < supportingInfoArray.size(); ++i) {
                if (((JsonValue)supportingInfoArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInfoArray.get(i)).getValueType() + " for element: supportingInfo");
                }
                builder.supportingInfo(this.parseClaimSupportingInfo("supportingInfo", supportingInfoArray.getJsonObject(i), i));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i = 0; i < diagnosisArray.size(); ++i) {
                if (((JsonValue)diagnosisArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)diagnosisArray.get(i)).getValueType() + " for element: diagnosis");
                }
                builder.diagnosis(this.parseClaimDiagnosis("diagnosis", diagnosisArray.getJsonObject(i), i));
            }
        }
        if ((procedureArray = JsonSupport.getJsonArray(jsonObject, "procedure")) != null) {
            for (int i = 0; i < procedureArray.size(); ++i) {
                if (((JsonValue)procedureArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)procedureArray.get(i)).getValueType() + " for element: procedure");
                }
                builder.procedure(this.parseClaimProcedure("procedure", procedureArray.getJsonObject(i), i));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i = 0; i < insuranceArray.size(); ++i) {
                if (((JsonValue)insuranceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)insuranceArray.get(i)).getValueType() + " for element: insurance");
                }
                builder.insurance(this.parseClaimInsurance("insurance", insuranceArray.getJsonObject(i), i));
            }
        }
        builder.accident(this.parseClaimAccident("accident", JsonSupport.getJsonValue(jsonObject, "accident", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                if (((JsonValue)itemArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)itemArray.get(i)).getValueType() + " for element: item");
                }
                builder.item(this.parseClaimItem("item", itemArray.getJsonObject(i), i));
            }
        }
        builder.total(this.parseMoney("total", JsonSupport.getJsonValue(jsonObject, "total", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Accident parseClaimAccident(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Accident.class, jsonObject);
        }
        Claim.Accident.Builder builder = Claim.Accident.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.location(this.parseChoiceElement("location", jsonObject, Address.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Claim.CareTeam parseClaimCareTeam(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.CareTeam.class, jsonObject);
        }
        Claim.CareTeam.Builder builder = Claim.CareTeam.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.responsible(this.parseBoolean("responsible", JsonSupport.getJsonValue(jsonObject, "responsible", JsonValue.class), (JsonValue)jsonObject.get((Object)"_responsible"), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.qualification(this.parseCodeableConcept("qualification", JsonSupport.getJsonValue(jsonObject, "qualification", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Diagnosis parseClaimDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Diagnosis.class, jsonObject);
        }
        Claim.Diagnosis.Builder builder = Claim.Diagnosis.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.diagnosis(this.parseChoiceElement("diagnosis", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.onAdmission(this.parseCodeableConcept("onAdmission", JsonSupport.getJsonValue(jsonObject, "onAdmission", JsonObject.class), -1));
        builder.packageCode(this.parseCodeableConcept("packageCode", JsonSupport.getJsonValue(jsonObject, "packageCode", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Insurance parseClaimInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Insurance.class, jsonObject);
        }
        Claim.Insurance.Builder builder = Claim.Insurance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.businessArrangement(this.parseString("businessArrangement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "businessArrangement", JsonString.class), (JsonValue)jsonObject.get((Object)"_businessArrangement"), -1));
        JsonArray preAuthRefArray = JsonSupport.getJsonArray(jsonObject, "preAuthRef", true);
        if (preAuthRefArray != null) {
            JsonArray _preAuthRefArray = jsonObject.getJsonArray("_preAuthRef");
            for (int i = 0; i < preAuthRefArray.size(); ++i) {
                builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)preAuthRefArray.get(i), JsonSupport.getJsonValue(_preAuthRefArray, i), i));
            }
        }
        builder.claimResponse(this.parseReference("claimResponse", JsonSupport.getJsonValue(jsonObject, "claimResponse", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Item parseClaimItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray encounterArray;
        JsonArray programCodeArray;
        int i;
        JsonArray informationSequenceArray;
        JsonArray procedureSequenceArray;
        JsonArray diagnosisSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Item.class, jsonObject);
        }
        Claim.Item.Builder builder = Claim.Item.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray careTeamSequenceArray = JsonSupport.getJsonArray(jsonObject, "careTeamSequence", true);
        if (careTeamSequenceArray != null) {
            JsonArray _careTeamSequenceArray = jsonObject.getJsonArray("_careTeamSequence");
            for (int i2 = 0; i2 < careTeamSequenceArray.size(); ++i2) {
                builder.careTeamSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "careTeamSequence", (JsonValue)careTeamSequenceArray.get(i2), JsonSupport.getJsonValue(_careTeamSequenceArray, i2), i2));
            }
        }
        if ((diagnosisSequenceArray = JsonSupport.getJsonArray(jsonObject, "diagnosisSequence", true)) != null) {
            JsonArray _diagnosisSequenceArray = jsonObject.getJsonArray("_diagnosisSequence");
            for (int i3 = 0; i3 < diagnosisSequenceArray.size(); ++i3) {
                builder.diagnosisSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "diagnosisSequence", (JsonValue)diagnosisSequenceArray.get(i3), JsonSupport.getJsonValue(_diagnosisSequenceArray, i3), i3));
            }
        }
        if ((procedureSequenceArray = JsonSupport.getJsonArray(jsonObject, "procedureSequence", true)) != null) {
            JsonArray _procedureSequenceArray = jsonObject.getJsonArray("_procedureSequence");
            for (int i4 = 0; i4 < procedureSequenceArray.size(); ++i4) {
                builder.procedureSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "procedureSequence", (JsonValue)procedureSequenceArray.get(i4), JsonSupport.getJsonValue(_procedureSequenceArray, i4), i4));
            }
        }
        if ((informationSequenceArray = JsonSupport.getJsonArray(jsonObject, "informationSequence", true)) != null) {
            JsonArray _informationSequenceArray = jsonObject.getJsonArray("_informationSequence");
            for (i = 0; i < informationSequenceArray.size(); ++i) {
                builder.informationSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "informationSequence", (JsonValue)informationSequenceArray.get(i), JsonSupport.getJsonValue(_informationSequenceArray, i), i));
            }
        }
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (i = 0; i < modifierArray.size(); ++i) {
                if (((JsonValue)modifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i5 = 0; i5 < programCodeArray.size(); ++i5) {
                if (((JsonValue)programCodeArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i5)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i5), i5));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i6 = 0; i6 < udiArray.size(); ++i6) {
                if (((JsonValue)udiArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i6)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i6), i6));
            }
        }
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i7 = 0; i7 < subSiteArray.size(); ++i7) {
                if (((JsonValue)subSiteArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subSiteArray.get(i7)).getValueType() + " for element: subSite");
                }
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i7), i7));
            }
        }
        if ((encounterArray = JsonSupport.getJsonArray(jsonObject, "encounter")) != null) {
            for (int i8 = 0; i8 < encounterArray.size(); ++i8) {
                if (((JsonValue)encounterArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)encounterArray.get(i8)).getValueType() + " for element: encounter");
                }
                builder.encounter(this.parseReference("encounter", encounterArray.getJsonObject(i8), i8));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i9 = 0; i9 < detailArray.size(); ++i9) {
                if (((JsonValue)detailArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i9)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseClaimItemDetail("detail", detailArray.getJsonObject(i9), i9));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Item.Detail parseClaimItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Item.Detail.class, jsonObject);
        }
        Claim.Item.Detail.Builder builder = Claim.Item.Detail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i = 0; i < modifierArray.size(); ++i) {
                if (((JsonValue)modifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i = 0; i < programCodeArray.size(); ++i) {
                if (((JsonValue)programCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i), i));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                if (((JsonValue)udiArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i = 0; i < subDetailArray.size(); ++i) {
                if (((JsonValue)subDetailArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subDetailArray.get(i)).getValueType() + " for element: subDetail");
                }
                builder.subDetail(this.parseClaimItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Item.Detail.SubDetail parseClaimItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Item.Detail.SubDetail.class, jsonObject);
        }
        Claim.Item.Detail.SubDetail.Builder builder = Claim.Item.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i = 0; i < modifierArray.size(); ++i) {
                if (((JsonValue)modifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i = 0; i < programCodeArray.size(); ++i) {
                if (((JsonValue)programCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i), i));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                if (((JsonValue)udiArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Payee parseClaimPayee(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Payee.class, jsonObject);
        }
        Claim.Payee.Builder builder = Claim.Payee.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Procedure parseClaimProcedure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Procedure.class, jsonObject);
        }
        Claim.Procedure.Builder builder = Claim.Procedure.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.procedure(this.parseChoiceElement("procedure", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                if (((JsonValue)udiArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Related parseClaimRelated(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.Related.class, jsonObject);
        }
        Claim.Related.Builder builder = Claim.Related.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.claim(this.parseReference("claim", JsonSupport.getJsonValue(jsonObject, "claim", JsonObject.class), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.reference(this.parseIdentifier("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.SupportingInfo parseClaimSupportingInfo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Claim.SupportingInfo.class, jsonObject);
        }
        Claim.SupportingInfo.Builder builder = Claim.SupportingInfo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.timing(this.parseChoiceElement("timing", jsonObject, Date.class, Period.class));
        builder.value(this.parseChoiceElement("value", jsonObject, Boolean.class, org.linuxforhealth.fhir.model.type.String.class, Quantity.class, Attachment.class, Reference.class));
        builder.reason(this.parseCodeableConcept("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse parseClaimResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray errorArray;
        JsonArray insuranceArray;
        JsonArray communicationRequestArray;
        JsonArray totalArray;
        JsonArray adjudicationArray;
        JsonArray addItemArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.class, jsonObject);
        }
        ClaimResponse.Builder builder = ClaimResponse.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ClaimResponseStatus)this.parseString(ClaimResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.use((Use)this.parseString(Use.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.requestor(this.parseReference("requestor", JsonSupport.getJsonValue(jsonObject, "requestor", JsonObject.class), -1));
        builder.request(this.parseReference("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)JsonSupport.getJsonValue(jsonObject, "preAuthRef", JsonString.class), (JsonValue)jsonObject.get((Object)"_preAuthRef"), -1));
        builder.preAuthPeriod(this.parsePeriod("preAuthPeriod", JsonSupport.getJsonValue(jsonObject, "preAuthPeriod", JsonObject.class), -1));
        builder.payeeType(this.parseCodeableConcept("payeeType", JsonSupport.getJsonValue(jsonObject, "payeeType", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                if (((JsonValue)itemArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)itemArray.get(i)).getValueType() + " for element: item");
                }
                builder.item(this.parseClaimResponseItem("item", itemArray.getJsonObject(i), i));
            }
        }
        if ((addItemArray = JsonSupport.getJsonArray(jsonObject, "addItem")) != null) {
            for (int i = 0; i < addItemArray.size(); ++i) {
                if (((JsonValue)addItemArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)addItemArray.get(i)).getValueType() + " for element: addItem");
                }
                builder.addItem(this.parseClaimResponseAddItem("addItem", addItemArray.getJsonObject(i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (int i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((totalArray = JsonSupport.getJsonArray(jsonObject, "total")) != null) {
            for (int i = 0; i < totalArray.size(); ++i) {
                if (((JsonValue)totalArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)totalArray.get(i)).getValueType() + " for element: total");
                }
                builder.total(this.parseClaimResponseTotal("total", totalArray.getJsonObject(i), i));
            }
        }
        builder.payment(this.parseClaimResponsePayment("payment", JsonSupport.getJsonValue(jsonObject, "payment", JsonObject.class), -1));
        builder.fundsReserve(this.parseCodeableConcept("fundsReserve", JsonSupport.getJsonValue(jsonObject, "fundsReserve", JsonObject.class), -1));
        builder.formCode(this.parseCodeableConcept("formCode", JsonSupport.getJsonValue(jsonObject, "formCode", JsonObject.class), -1));
        builder.form(this.parseAttachment("form", JsonSupport.getJsonValue(jsonObject, "form", JsonObject.class), -1));
        JsonArray processNoteArray = JsonSupport.getJsonArray(jsonObject, "processNote");
        if (processNoteArray != null) {
            for (int i = 0; i < processNoteArray.size(); ++i) {
                if (((JsonValue)processNoteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)processNoteArray.get(i)).getValueType() + " for element: processNote");
                }
                builder.processNote(this.parseClaimResponseProcessNote("processNote", processNoteArray.getJsonObject(i), i));
            }
        }
        if ((communicationRequestArray = JsonSupport.getJsonArray(jsonObject, "communicationRequest")) != null) {
            for (int i = 0; i < communicationRequestArray.size(); ++i) {
                if (((JsonValue)communicationRequestArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)communicationRequestArray.get(i)).getValueType() + " for element: communicationRequest");
                }
                builder.communicationRequest(this.parseReference("communicationRequest", communicationRequestArray.getJsonObject(i), i));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i = 0; i < insuranceArray.size(); ++i) {
                if (((JsonValue)insuranceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)insuranceArray.get(i)).getValueType() + " for element: insurance");
                }
                builder.insurance(this.parseClaimResponseInsurance("insurance", insuranceArray.getJsonObject(i), i));
            }
        }
        if ((errorArray = JsonSupport.getJsonArray(jsonObject, "error")) != null) {
            for (int i = 0; i < errorArray.size(); ++i) {
                if (((JsonValue)errorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)errorArray.get(i)).getValueType() + " for element: error");
                }
                builder.error(this.parseClaimResponseError("error", errorArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.AddItem parseClaimResponseAddItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        JsonArray providerArray;
        int i2;
        JsonArray subdetailSequenceArray;
        JsonArray detailSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.AddItem.class, jsonObject);
        }
        ClaimResponse.AddItem.Builder builder = ClaimResponse.AddItem.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray itemSequenceArray = JsonSupport.getJsonArray(jsonObject, "itemSequence", true);
        if (itemSequenceArray != null) {
            JsonArray _itemSequenceArray = jsonObject.getJsonArray("_itemSequence");
            for (int i3 = 0; i3 < itemSequenceArray.size(); ++i3) {
                builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)itemSequenceArray.get(i3), JsonSupport.getJsonValue(_itemSequenceArray, i3), i3));
            }
        }
        if ((detailSequenceArray = JsonSupport.getJsonArray(jsonObject, "detailSequence", true)) != null) {
            JsonArray _detailSequenceArray = jsonObject.getJsonArray("_detailSequence");
            for (int i4 = 0; i4 < detailSequenceArray.size(); ++i4) {
                builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)detailSequenceArray.get(i4), JsonSupport.getJsonValue(_detailSequenceArray, i4), i4));
            }
        }
        if ((subdetailSequenceArray = JsonSupport.getJsonArray(jsonObject, "subdetailSequence", true)) != null) {
            JsonArray _subdetailSequenceArray = jsonObject.getJsonArray("_subdetailSequence");
            for (i2 = 0; i2 < subdetailSequenceArray.size(); ++i2) {
                builder.subdetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subdetailSequence", (JsonValue)subdetailSequenceArray.get(i2), JsonSupport.getJsonValue(_subdetailSequenceArray, i2), i2));
            }
        }
        if ((providerArray = JsonSupport.getJsonArray(jsonObject, "provider")) != null) {
            for (i2 = 0; i2 < providerArray.size(); ++i2) {
                if (((JsonValue)providerArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)providerArray.get(i2)).getValueType() + " for element: provider");
                }
                builder.provider(this.parseReference("provider", providerArray.getJsonObject(i2), i2));
            }
        }
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i5 = 0; i5 < modifierArray.size(); ++i5) {
                if (((JsonValue)modifierArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i5)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i5), i5));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i6 = 0; i6 < programCodeArray.size(); ++i6) {
                if (((JsonValue)programCodeArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i6)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i6), i6));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i7 = 0; i7 < subSiteArray.size(); ++i7) {
                if (((JsonValue)subSiteArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subSiteArray.get(i7)).getValueType() + " for element: subSite");
                }
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i7), i7));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i8 = 0; i8 < detailArray.size(); ++i8) {
                if (((JsonValue)detailArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i8)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseClaimResponseAddItemDetail("detail", detailArray.getJsonObject(i8), i8));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.AddItem.Detail parseClaimResponseAddItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.AddItem.Detail.class, jsonObject);
        }
        ClaimResponse.AddItem.Detail.Builder builder = ClaimResponse.AddItem.Detail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                if (((JsonValue)modifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i2)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i3 = 0; i3 < subDetailArray.size(); ++i3) {
                if (((JsonValue)subDetailArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subDetailArray.get(i3)).getValueType() + " for element: subDetail");
                }
                builder.subDetail(this.parseClaimResponseAddItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.AddItem.Detail.SubDetail parseClaimResponseAddItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.AddItem.Detail.SubDetail.class, jsonObject);
        }
        ClaimResponse.AddItem.Detail.SubDetail.Builder builder = ClaimResponse.AddItem.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                if (((JsonValue)modifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i2)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Error parseClaimResponseError(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Error.class, jsonObject);
        }
        ClaimResponse.Error.Builder builder = ClaimResponse.Error.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "itemSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_itemSequence"), -1));
        builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_detailSequence"), -1));
        builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subDetailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_subDetailSequence"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Insurance parseClaimResponseInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Insurance.class, jsonObject);
        }
        ClaimResponse.Insurance.Builder builder = ClaimResponse.Insurance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.businessArrangement(this.parseString("businessArrangement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "businessArrangement", JsonString.class), (JsonValue)jsonObject.get((Object)"_businessArrangement"), -1));
        builder.claimResponse(this.parseReference("claimResponse", JsonSupport.getJsonValue(jsonObject, "claimResponse", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item parseClaimResponseItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.class, jsonObject);
        }
        ClaimResponse.Item.Builder builder = ClaimResponse.Item.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "itemSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_itemSequence"), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i2 = 0; i2 < detailArray.size(); ++i2) {
                if (((JsonValue)detailArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i2)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseClaimResponseItemDetail("detail", detailArray.getJsonObject(i2), i2));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item.Adjudication parseClaimResponseItemAdjudication(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.Adjudication.class, jsonObject);
        }
        ClaimResponse.Item.Adjudication.Builder builder = ClaimResponse.Item.Adjudication.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.reason(this.parseCodeableConcept("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.value(this.parseDecimal("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item.Detail parseClaimResponseItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.Detail.class, jsonObject);
        }
        ClaimResponse.Item.Detail.Builder builder = ClaimResponse.Item.Detail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_detailSequence"), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i2 = 0; i2 < subDetailArray.size(); ++i2) {
                if (((JsonValue)subDetailArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subDetailArray.get(i2)).getValueType() + " for element: subDetail");
                }
                builder.subDetail(this.parseClaimResponseItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i2), i2));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item.Detail.SubDetail parseClaimResponseItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.Detail.SubDetail.class, jsonObject);
        }
        ClaimResponse.Item.Detail.SubDetail.Builder builder = ClaimResponse.Item.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subDetailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_subDetailSequence"), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Payment parseClaimResponsePayment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Payment.class, jsonObject);
        }
        ClaimResponse.Payment.Builder builder = ClaimResponse.Payment.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.adjustment(this.parseMoney("adjustment", JsonSupport.getJsonValue(jsonObject, "adjustment", JsonObject.class), -1));
        builder.adjustmentReason(this.parseCodeableConcept("adjustmentReason", JsonSupport.getJsonValue(jsonObject, "adjustmentReason", JsonObject.class), -1));
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.ProcessNote parseClaimResponseProcessNote(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.ProcessNote.class, jsonObject);
        }
        ClaimResponse.ProcessNote.Builder builder = ClaimResponse.ProcessNote.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.number((PositiveInt)this.parseInteger(PositiveInt.builder(), "number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.type((NoteType)this.parseString(NoteType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        builder.language(this.parseCodeableConcept("language", JsonSupport.getJsonValue(jsonObject, "language", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Total parseClaimResponseTotal(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Total.class, jsonObject);
        }
        ClaimResponse.Total.Builder builder = ClaimResponse.Total.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClinicalImpression parseClinicalImpression(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray supportingInfoArray;
        JsonArray prognosisReferenceArray;
        JsonArray prognosisCodeableConceptArray;
        int i;
        JsonArray protocolArray;
        JsonArray investigationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalImpression.class, jsonObject);
        }
        ClinicalImpression.Builder builder = ClinicalImpression.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((ClinicalImpressionStatus)this.parseString(ClinicalImpressionStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.effective(this.parseChoiceElement("effective", jsonObject, DateTime.class, Period.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.assessor(this.parseReference("assessor", JsonSupport.getJsonValue(jsonObject, "assessor", JsonObject.class), -1));
        builder.previous(this.parseReference("previous", JsonSupport.getJsonValue(jsonObject, "previous", JsonObject.class), -1));
        JsonArray problemArray = JsonSupport.getJsonArray(jsonObject, "problem");
        if (problemArray != null) {
            for (int i3 = 0; i3 < problemArray.size(); ++i3) {
                if (((JsonValue)problemArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)problemArray.get(i3)).getValueType() + " for element: problem");
                }
                builder.problem(this.parseReference("problem", problemArray.getJsonObject(i3), i3));
            }
        }
        if ((investigationArray = JsonSupport.getJsonArray(jsonObject, "investigation")) != null) {
            for (int i4 = 0; i4 < investigationArray.size(); ++i4) {
                if (((JsonValue)investigationArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)investigationArray.get(i4)).getValueType() + " for element: investigation");
                }
                builder.investigation(this.parseClinicalImpressionInvestigation("investigation", investigationArray.getJsonObject(i4), i4));
            }
        }
        if ((protocolArray = JsonSupport.getJsonArray(jsonObject, "protocol", true)) != null) {
            JsonArray _protocolArray = jsonObject.getJsonArray("_protocol");
            for (i = 0; i < protocolArray.size(); ++i) {
                builder.protocol(this.parseUri("protocol", (JsonValue)protocolArray.get(i), JsonSupport.getJsonValue(_protocolArray, i), i));
            }
        }
        builder.summary(this.parseString("summary", (JsonValue)JsonSupport.getJsonValue(jsonObject, "summary", JsonString.class), (JsonValue)jsonObject.get((Object)"_summary"), -1));
        JsonArray findingArray = JsonSupport.getJsonArray(jsonObject, "finding");
        if (findingArray != null) {
            for (i = 0; i < findingArray.size(); ++i) {
                if (((JsonValue)findingArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)findingArray.get(i)).getValueType() + " for element: finding");
                }
                builder.finding(this.parseClinicalImpressionFinding("finding", findingArray.getJsonObject(i), i));
            }
        }
        if ((prognosisCodeableConceptArray = JsonSupport.getJsonArray(jsonObject, "prognosisCodeableConcept")) != null) {
            for (int i5 = 0; i5 < prognosisCodeableConceptArray.size(); ++i5) {
                if (((JsonValue)prognosisCodeableConceptArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)prognosisCodeableConceptArray.get(i5)).getValueType() + " for element: prognosisCodeableConcept");
                }
                builder.prognosisCodeableConcept(this.parseCodeableConcept("prognosisCodeableConcept", prognosisCodeableConceptArray.getJsonObject(i5), i5));
            }
        }
        if ((prognosisReferenceArray = JsonSupport.getJsonArray(jsonObject, "prognosisReference")) != null) {
            for (int i6 = 0; i6 < prognosisReferenceArray.size(); ++i6) {
                if (((JsonValue)prognosisReferenceArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)prognosisReferenceArray.get(i6)).getValueType() + " for element: prognosisReference");
                }
                builder.prognosisReference(this.parseReference("prognosisReference", prognosisReferenceArray.getJsonObject(i6), i6));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i7 = 0; i7 < supportingInfoArray.size(); ++i7) {
                if (((JsonValue)supportingInfoArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInfoArray.get(i7)).getValueType() + " for element: supportingInfo");
                }
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i7), i7));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i8 = 0; i8 < noteArray.size(); ++i8) {
                if (((JsonValue)noteArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i8)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i8), i8));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClinicalImpression.Finding parseClinicalImpressionFinding(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalImpression.Finding.class, jsonObject);
        }
        ClinicalImpression.Finding.Builder builder = ClinicalImpression.Finding.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.itemCodeableConcept(this.parseCodeableConcept("itemCodeableConcept", JsonSupport.getJsonValue(jsonObject, "itemCodeableConcept", JsonObject.class), -1));
        builder.itemReference(this.parseReference("itemReference", JsonSupport.getJsonValue(jsonObject, "itemReference", JsonObject.class), -1));
        builder.basis(this.parseString("basis", (JsonValue)JsonSupport.getJsonValue(jsonObject, "basis", JsonString.class), (JsonValue)jsonObject.get((Object)"_basis"), -1));
        this.stackPop();
        return builder.build();
    }

    private ClinicalImpression.Investigation parseClinicalImpressionInvestigation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalImpression.Investigation.class, jsonObject);
        }
        ClinicalImpression.Investigation.Builder builder = ClinicalImpression.Investigation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                if (((JsonValue)itemArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)itemArray.get(i)).getValueType() + " for element: item");
                }
                builder.item(this.parseReference("item", itemArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition parseClinicalUseDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subjectArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.class, jsonObject);
        }
        ClinicalUseDefinition.Builder builder = ClinicalUseDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.type((ClinicalUseDefinitionType)this.parseString(ClinicalUseDefinitionType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        if ((subjectArray = JsonSupport.getJsonArray(jsonObject, "subject")) != null) {
            for (int i = 0; i < subjectArray.size(); ++i) {
                if (((JsonValue)subjectArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subjectArray.get(i)).getValueType() + " for element: subject");
                }
                builder.subject(this.parseReference("subject", subjectArray.getJsonObject(i), i));
            }
        }
        builder.status(this.parseCodeableConcept("status", JsonSupport.getJsonValue(jsonObject, "status", JsonObject.class), -1));
        builder.contraindication(this.parseClinicalUseDefinitionContraindication("contraindication", JsonSupport.getJsonValue(jsonObject, "contraindication", JsonObject.class), -1));
        builder.indication(this.parseClinicalUseDefinitionIndication("indication", JsonSupport.getJsonValue(jsonObject, "indication", JsonObject.class), -1));
        builder.interaction(this.parseClinicalUseDefinitionInteraction("interaction", JsonSupport.getJsonValue(jsonObject, "interaction", JsonObject.class), -1));
        JsonArray populationArray = JsonSupport.getJsonArray(jsonObject, "population");
        if (populationArray != null) {
            for (int i = 0; i < populationArray.size(); ++i) {
                if (((JsonValue)populationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)populationArray.get(i)).getValueType() + " for element: population");
                }
                builder.population(this.parseReference("population", populationArray.getJsonObject(i), i));
            }
        }
        builder.undesirableEffect(this.parseClinicalUseDefinitionUndesirableEffect("undesirableEffect", JsonSupport.getJsonValue(jsonObject, "undesirableEffect", JsonObject.class), -1));
        builder.warning(this.parseClinicalUseDefinitionWarning("warning", JsonSupport.getJsonValue(jsonObject, "warning", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition.Contraindication parseClinicalUseDefinitionContraindication(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray otherTherapyArray;
        JsonArray indicationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.Contraindication.class, jsonObject);
        }
        ClinicalUseDefinition.Contraindication.Builder builder = ClinicalUseDefinition.Contraindication.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.diseaseSymptomProcedure(this.parseCodeableReference("diseaseSymptomProcedure", JsonSupport.getJsonValue(jsonObject, "diseaseSymptomProcedure", JsonObject.class), -1));
        builder.diseaseStatus(this.parseCodeableReference("diseaseStatus", JsonSupport.getJsonValue(jsonObject, "diseaseStatus", JsonObject.class), -1));
        JsonArray comorbidityArray = JsonSupport.getJsonArray(jsonObject, "comorbidity");
        if (comorbidityArray != null) {
            for (int i = 0; i < comorbidityArray.size(); ++i) {
                if (((JsonValue)comorbidityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)comorbidityArray.get(i)).getValueType() + " for element: comorbidity");
                }
                builder.comorbidity(this.parseCodeableReference("comorbidity", comorbidityArray.getJsonObject(i), i));
            }
        }
        if ((indicationArray = JsonSupport.getJsonArray(jsonObject, "indication")) != null) {
            for (int i = 0; i < indicationArray.size(); ++i) {
                if (((JsonValue)indicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)indicationArray.get(i)).getValueType() + " for element: indication");
                }
                builder.indication(this.parseReference("indication", indicationArray.getJsonObject(i), i));
            }
        }
        if ((otherTherapyArray = JsonSupport.getJsonArray(jsonObject, "otherTherapy")) != null) {
            for (int i = 0; i < otherTherapyArray.size(); ++i) {
                if (((JsonValue)otherTherapyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)otherTherapyArray.get(i)).getValueType() + " for element: otherTherapy");
                }
                builder.otherTherapy(this.parseClinicalUseDefinitionContraindicationOtherTherapy("otherTherapy", otherTherapyArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition.Contraindication.OtherTherapy parseClinicalUseDefinitionContraindicationOtherTherapy(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.Contraindication.OtherTherapy.class, jsonObject);
        }
        ClinicalUseDefinition.Contraindication.OtherTherapy.Builder builder = ClinicalUseDefinition.Contraindication.OtherTherapy.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.relationshipType(this.parseCodeableConcept("relationshipType", JsonSupport.getJsonValue(jsonObject, "relationshipType", JsonObject.class), -1));
        builder.therapy(this.parseCodeableReference("therapy", JsonSupport.getJsonValue(jsonObject, "therapy", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition.Indication parseClinicalUseDefinitionIndication(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray otherTherapyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.Indication.class, jsonObject);
        }
        ClinicalUseDefinition.Indication.Builder builder = ClinicalUseDefinition.Indication.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.diseaseSymptomProcedure(this.parseCodeableReference("diseaseSymptomProcedure", JsonSupport.getJsonValue(jsonObject, "diseaseSymptomProcedure", JsonObject.class), -1));
        builder.diseaseStatus(this.parseCodeableReference("diseaseStatus", JsonSupport.getJsonValue(jsonObject, "diseaseStatus", JsonObject.class), -1));
        JsonArray comorbidityArray = JsonSupport.getJsonArray(jsonObject, "comorbidity");
        if (comorbidityArray != null) {
            for (int i = 0; i < comorbidityArray.size(); ++i) {
                if (((JsonValue)comorbidityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)comorbidityArray.get(i)).getValueType() + " for element: comorbidity");
                }
                builder.comorbidity(this.parseCodeableReference("comorbidity", comorbidityArray.getJsonObject(i), i));
            }
        }
        builder.intendedEffect(this.parseCodeableReference("intendedEffect", JsonSupport.getJsonValue(jsonObject, "intendedEffect", JsonObject.class), -1));
        builder.duration(this.parseChoiceElement("duration", jsonObject, Range.class, org.linuxforhealth.fhir.model.type.String.class));
        JsonArray undesirableEffectArray = JsonSupport.getJsonArray(jsonObject, "undesirableEffect");
        if (undesirableEffectArray != null) {
            for (int i = 0; i < undesirableEffectArray.size(); ++i) {
                if (((JsonValue)undesirableEffectArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)undesirableEffectArray.get(i)).getValueType() + " for element: undesirableEffect");
                }
                builder.undesirableEffect(this.parseReference("undesirableEffect", undesirableEffectArray.getJsonObject(i), i));
            }
        }
        if ((otherTherapyArray = JsonSupport.getJsonArray(jsonObject, "otherTherapy")) != null) {
            for (int i = 0; i < otherTherapyArray.size(); ++i) {
                if (((JsonValue)otherTherapyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)otherTherapyArray.get(i)).getValueType() + " for element: otherTherapy");
                }
                builder.otherTherapy(this.parseClinicalUseDefinitionContraindicationOtherTherapy("otherTherapy", otherTherapyArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition.Interaction parseClinicalUseDefinitionInteraction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.Interaction.class, jsonObject);
        }
        ClinicalUseDefinition.Interaction.Builder builder = ClinicalUseDefinition.Interaction.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray interactantArray = JsonSupport.getJsonArray(jsonObject, "interactant");
        if (interactantArray != null) {
            for (int i = 0; i < interactantArray.size(); ++i) {
                if (((JsonValue)interactantArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)interactantArray.get(i)).getValueType() + " for element: interactant");
                }
                builder.interactant(this.parseClinicalUseDefinitionInteractionInteractant("interactant", interactantArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.effect(this.parseCodeableReference("effect", JsonSupport.getJsonValue(jsonObject, "effect", JsonObject.class), -1));
        builder.incidence(this.parseCodeableConcept("incidence", JsonSupport.getJsonValue(jsonObject, "incidence", JsonObject.class), -1));
        JsonArray managementArray = JsonSupport.getJsonArray(jsonObject, "management");
        if (managementArray != null) {
            for (int i = 0; i < managementArray.size(); ++i) {
                if (((JsonValue)managementArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)managementArray.get(i)).getValueType() + " for element: management");
                }
                builder.management(this.parseCodeableConcept("management", managementArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition.Interaction.Interactant parseClinicalUseDefinitionInteractionInteractant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.Interaction.Interactant.class, jsonObject);
        }
        ClinicalUseDefinition.Interaction.Interactant.Builder builder = ClinicalUseDefinition.Interaction.Interactant.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.item(this.parseChoiceElement("item", jsonObject, Reference.class, CodeableConcept.class));
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition.UndesirableEffect parseClinicalUseDefinitionUndesirableEffect(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.UndesirableEffect.class, jsonObject);
        }
        ClinicalUseDefinition.UndesirableEffect.Builder builder = ClinicalUseDefinition.UndesirableEffect.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.symptomConditionEffect(this.parseCodeableReference("symptomConditionEffect", JsonSupport.getJsonValue(jsonObject, "symptomConditionEffect", JsonObject.class), -1));
        builder.classification(this.parseCodeableConcept("classification", JsonSupport.getJsonValue(jsonObject, "classification", JsonObject.class), -1));
        builder.frequencyOfOccurrence(this.parseCodeableConcept("frequencyOfOccurrence", JsonSupport.getJsonValue(jsonObject, "frequencyOfOccurrence", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClinicalUseDefinition.Warning parseClinicalUseDefinitionWarning(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ClinicalUseDefinition.Warning.class, jsonObject);
        }
        ClinicalUseDefinition.Warning.Builder builder = ClinicalUseDefinition.Warning.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeSystem parseCodeSystem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray conceptArray;
        JsonArray propertyArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.class, jsonObject);
        }
        CodeSystem.Builder builder = CodeSystem.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                if (((JsonValue)jurisdictionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.caseSensitive(this.parseBoolean("caseSensitive", JsonSupport.getJsonValue(jsonObject, "caseSensitive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_caseSensitive"), -1));
        builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", (JsonValue)JsonSupport.getJsonValue(jsonObject, "valueSet", JsonString.class), (JsonValue)jsonObject.get((Object)"_valueSet"), -1));
        builder.hierarchyMeaning((CodeSystemHierarchyMeaning)this.parseString(CodeSystemHierarchyMeaning.builder(), "hierarchyMeaning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "hierarchyMeaning", JsonString.class), (JsonValue)jsonObject.get((Object)"_hierarchyMeaning"), -1));
        builder.compositional(this.parseBoolean("compositional", JsonSupport.getJsonValue(jsonObject, "compositional", JsonValue.class), (JsonValue)jsonObject.get((Object)"_compositional"), -1));
        builder.versionNeeded(this.parseBoolean("versionNeeded", JsonSupport.getJsonValue(jsonObject, "versionNeeded", JsonValue.class), (JsonValue)jsonObject.get((Object)"_versionNeeded"), -1));
        builder.content((CodeSystemContentMode)this.parseString(CodeSystemContentMode.builder(), "content", (JsonValue)JsonSupport.getJsonValue(jsonObject, "content", JsonString.class), (JsonValue)jsonObject.get((Object)"_content"), -1));
        builder.supplements((Canonical)this.parseUri(Canonical.builder(), "supplements", (JsonValue)JsonSupport.getJsonValue(jsonObject, "supplements", JsonString.class), (JsonValue)jsonObject.get((Object)"_supplements"), -1));
        builder.count((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "count", (JsonValue)JsonSupport.getJsonValue(jsonObject, "count", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_count"), -1));
        JsonArray filterArray = JsonSupport.getJsonArray(jsonObject, "filter");
        if (filterArray != null) {
            for (int i = 0; i < filterArray.size(); ++i) {
                if (((JsonValue)filterArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)filterArray.get(i)).getValueType() + " for element: filter");
                }
                builder.filter(this.parseCodeSystemFilter("filter", filterArray.getJsonObject(i), i));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i = 0; i < propertyArray.size(); ++i) {
                if (((JsonValue)propertyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)propertyArray.get(i)).getValueType() + " for element: property");
                }
                builder.property(this.parseCodeSystemProperty("property", propertyArray.getJsonObject(i), i));
            }
        }
        if ((conceptArray = JsonSupport.getJsonArray(jsonObject, "concept")) != null) {
            for (int i = 0; i < conceptArray.size(); ++i) {
                if (((JsonValue)conceptArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)conceptArray.get(i)).getValueType() + " for element: concept");
                }
                builder.concept(this.parseCodeSystemConcept("concept", conceptArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Concept parseCodeSystemConcept(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray conceptArray;
        JsonArray propertyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Concept.class, jsonObject);
        }
        CodeSystem.Concept.Builder builder = CodeSystem.Concept.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.definition(this.parseString("definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        JsonArray designationArray = JsonSupport.getJsonArray(jsonObject, "designation");
        if (designationArray != null) {
            for (int i = 0; i < designationArray.size(); ++i) {
                if (((JsonValue)designationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)designationArray.get(i)).getValueType() + " for element: designation");
                }
                builder.designation(this.parseCodeSystemConceptDesignation("designation", designationArray.getJsonObject(i), i));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i = 0; i < propertyArray.size(); ++i) {
                if (((JsonValue)propertyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)propertyArray.get(i)).getValueType() + " for element: property");
                }
                builder.property(this.parseCodeSystemConceptProperty("property", propertyArray.getJsonObject(i), i));
            }
        }
        if ((conceptArray = JsonSupport.getJsonArray(jsonObject, "concept")) != null) {
            for (int i = 0; i < conceptArray.size(); ++i) {
                if (((JsonValue)conceptArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)conceptArray.get(i)).getValueType() + " for element: concept");
                }
                builder.concept(this.parseCodeSystemConcept("concept", conceptArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Concept.Designation parseCodeSystemConceptDesignation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Concept.Designation.class, jsonObject);
        }
        CodeSystem.Concept.Designation.Builder builder = CodeSystem.Concept.Designation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.use(this.parseCoding("use", JsonSupport.getJsonValue(jsonObject, "use", JsonObject.class), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Concept.Property parseCodeSystemConceptProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Concept.Property.class, jsonObject);
        }
        CodeSystem.Concept.Property.Builder builder = CodeSystem.Concept.Property.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, Code.class, Coding.class, org.linuxforhealth.fhir.model.type.String.class, Integer.class, Boolean.class, DateTime.class, Decimal.class));
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Filter parseCodeSystemFilter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Filter.class, jsonObject);
        }
        CodeSystem.Filter.Builder builder = CodeSystem.Filter.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray operatorArray = JsonSupport.getJsonArray(jsonObject, "operator", true);
        if (operatorArray != null) {
            JsonArray _operatorArray = jsonObject.getJsonArray("_operator");
            for (int i = 0; i < operatorArray.size(); ++i) {
                builder.operator((FilterOperator)this.parseString(FilterOperator.builder(), "operator", (JsonValue)operatorArray.get(i), JsonSupport.getJsonValue(_operatorArray, i), i));
            }
        }
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Property parseCodeSystemProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Property.class, jsonObject);
        }
        CodeSystem.Property.Builder builder = CodeSystem.Property.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.uri(this.parseUri("uri", (JsonValue)JsonSupport.getJsonValue(jsonObject, "uri", JsonString.class), (JsonValue)jsonObject.get((Object)"_uri"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.type((PropertyType)this.parseString(PropertyType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeableConcept parseCodeableConcept(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeableConcept.class, jsonObject);
        }
        CodeableConcept.Builder builder = CodeableConcept.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        JsonArray codingArray = JsonSupport.getJsonArray(jsonObject, "coding");
        if (codingArray != null) {
            for (int i = 0; i < codingArray.size(); ++i) {
                if (((JsonValue)codingArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codingArray.get(i)).getValueType() + " for element: coding");
                }
                builder.coding(this.parseCoding("coding", codingArray.getJsonObject(i), i));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeableReference parseCodeableReference(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CodeableReference.class, jsonObject);
        }
        CodeableReference.Builder builder = CodeableReference.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.concept(this.parseCodeableConcept("concept", JsonSupport.getJsonValue(jsonObject, "concept", JsonObject.class), -1));
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Coding parseCoding(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Coding.class, jsonObject);
        }
        Coding.Builder builder = Coding.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.system(this.parseUri("system", (JsonValue)JsonSupport.getJsonValue(jsonObject, "system", JsonString.class), (JsonValue)jsonObject.get((Object)"_system"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.userSelected(this.parseBoolean("userSelected", JsonSupport.getJsonValue(jsonObject, "userSelected", JsonValue.class), (JsonValue)jsonObject.get((Object)"_userSelected"), -1));
        this.stackPop();
        return builder.build();
    }

    private Communication parseCommunication(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray payloadArray;
        JsonArray reasonReferenceArray;
        JsonArray inResponseToArray;
        JsonArray partOfArray;
        JsonArray basedOnArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Communication.class, jsonObject);
        }
        Communication.Builder builder = Communication.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (int i4 = 0; i4 < partOfArray.size(); ++i4) {
                if (((JsonValue)partOfArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)partOfArray.get(i4)).getValueType() + " for element: partOf");
                }
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i4), i4));
            }
        }
        if ((inResponseToArray = JsonSupport.getJsonArray(jsonObject, "inResponseTo")) != null) {
            for (int i5 = 0; i5 < inResponseToArray.size(); ++i5) {
                if (((JsonValue)inResponseToArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)inResponseToArray.get(i5)).getValueType() + " for element: inResponseTo");
                }
                builder.inResponseTo(this.parseReference("inResponseTo", inResponseToArray.getJsonObject(i5), i5));
            }
        }
        builder.status((CommunicationStatus)this.parseString(CommunicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i6 = 0; i6 < categoryArray.size(); ++i6) {
                if (((JsonValue)categoryArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i6)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i6), i6));
            }
        }
        builder.priority((CommunicationPriority)this.parseString(CommunicationPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        JsonArray mediumArray = JsonSupport.getJsonArray(jsonObject, "medium");
        if (mediumArray != null) {
            for (int i7 = 0; i7 < mediumArray.size(); ++i7) {
                if (((JsonValue)mediumArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)mediumArray.get(i7)).getValueType() + " for element: medium");
                }
                builder.medium(this.parseCodeableConcept("medium", mediumArray.getJsonObject(i7), i7));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.topic(this.parseCodeableConcept("topic", JsonSupport.getJsonValue(jsonObject, "topic", JsonObject.class), -1));
        JsonArray aboutArray = JsonSupport.getJsonArray(jsonObject, "about");
        if (aboutArray != null) {
            for (int i8 = 0; i8 < aboutArray.size(); ++i8) {
                if (((JsonValue)aboutArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)aboutArray.get(i8)).getValueType() + " for element: about");
                }
                builder.about(this.parseReference("about", aboutArray.getJsonObject(i8), i8));
            }
        }
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.sent(this.parseDateTime("sent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sent", JsonString.class), (JsonValue)jsonObject.get((Object)"_sent"), -1));
        builder.received(this.parseDateTime("received", (JsonValue)JsonSupport.getJsonValue(jsonObject, "received", JsonString.class), (JsonValue)jsonObject.get((Object)"_received"), -1));
        JsonArray recipientArray = JsonSupport.getJsonArray(jsonObject, "recipient");
        if (recipientArray != null) {
            for (int i9 = 0; i9 < recipientArray.size(); ++i9) {
                if (((JsonValue)recipientArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)recipientArray.get(i9)).getValueType() + " for element: recipient");
                }
                builder.recipient(this.parseReference("recipient", recipientArray.getJsonObject(i9), i9));
            }
        }
        builder.sender(this.parseReference("sender", JsonSupport.getJsonValue(jsonObject, "sender", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i10 = 0; i10 < reasonCodeArray.size(); ++i10) {
                if (((JsonValue)reasonCodeArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i10)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i10), i10));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i11 = 0; i11 < reasonReferenceArray.size(); ++i11) {
                if (((JsonValue)reasonReferenceArray.get(i11)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i11)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i11), i11));
            }
        }
        if ((payloadArray = JsonSupport.getJsonArray(jsonObject, "payload")) != null) {
            for (int i12 = 0; i12 < payloadArray.size(); ++i12) {
                if (((JsonValue)payloadArray.get(i12)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)payloadArray.get(i12)).getValueType() + " for element: payload");
                }
                builder.payload(this.parseCommunicationPayload("payload", payloadArray.getJsonObject(i12), i12));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i13 = 0; i13 < noteArray.size(); ++i13) {
                if (((JsonValue)noteArray.get(i13)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i13)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i13), i13));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Communication.Payload parseCommunicationPayload(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Communication.Payload.class, jsonObject);
        }
        Communication.Payload.Builder builder = Communication.Payload.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, org.linuxforhealth.fhir.model.type.String.class, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private CommunicationRequest parseCommunicationRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        JsonArray replacesArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CommunicationRequest.class, jsonObject);
        }
        CommunicationRequest.Builder builder = CommunicationRequest.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((replacesArray = JsonSupport.getJsonArray(jsonObject, "replaces")) != null) {
            for (int i = 0; i < replacesArray.size(); ++i) {
                if (((JsonValue)replacesArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)replacesArray.get(i)).getValueType() + " for element: replaces");
                }
                builder.replaces(this.parseReference("replaces", replacesArray.getJsonObject(i), i));
            }
        }
        builder.groupIdentifier(this.parseIdentifier("groupIdentifier", JsonSupport.getJsonValue(jsonObject, "groupIdentifier", JsonObject.class), -1));
        builder.status((CommunicationRequestStatus)this.parseString(CommunicationRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.priority((CommunicationPriority)this.parseString(CommunicationPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        JsonArray mediumArray = JsonSupport.getJsonArray(jsonObject, "medium");
        if (mediumArray != null) {
            for (int i = 0; i < mediumArray.size(); ++i) {
                if (((JsonValue)mediumArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)mediumArray.get(i)).getValueType() + " for element: medium");
                }
                builder.medium(this.parseCodeableConcept("medium", mediumArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        JsonArray aboutArray = JsonSupport.getJsonArray(jsonObject, "about");
        if (aboutArray != null) {
            for (int i = 0; i < aboutArray.size(); ++i) {
                if (((JsonValue)aboutArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)aboutArray.get(i)).getValueType() + " for element: about");
                }
                builder.about(this.parseReference("about", aboutArray.getJsonObject(i), i));
            }
        }
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        JsonArray payloadArray = JsonSupport.getJsonArray(jsonObject, "payload");
        if (payloadArray != null) {
            for (int i = 0; i < payloadArray.size(); ++i) {
                if (((JsonValue)payloadArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)payloadArray.get(i)).getValueType() + " for element: payload");
                }
                builder.payload(this.parseCommunicationRequestPayload("payload", payloadArray.getJsonObject(i), i));
            }
        }
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class));
        builder.authoredOn(this.parseDateTime("authoredOn", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authoredOn", JsonString.class), (JsonValue)jsonObject.get((Object)"_authoredOn"), -1));
        builder.requester(this.parseReference("requester", JsonSupport.getJsonValue(jsonObject, "requester", JsonObject.class), -1));
        JsonArray recipientArray = JsonSupport.getJsonArray(jsonObject, "recipient");
        if (recipientArray != null) {
            for (int i = 0; i < recipientArray.size(); ++i) {
                if (((JsonValue)recipientArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)recipientArray.get(i)).getValueType() + " for element: recipient");
                }
                builder.recipient(this.parseReference("recipient", recipientArray.getJsonObject(i), i));
            }
        }
        builder.sender(this.parseReference("sender", JsonSupport.getJsonValue(jsonObject, "sender", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                if (((JsonValue)reasonCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                if (((JsonValue)reasonReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CommunicationRequest.Payload parseCommunicationRequestPayload(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CommunicationRequest.Payload.class, jsonObject);
        }
        CommunicationRequest.Payload.Builder builder = CommunicationRequest.Payload.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, org.linuxforhealth.fhir.model.type.String.class, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private CompartmentDefinition parseCompartmentDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CompartmentDefinition.class, jsonObject);
        }
        CompartmentDefinition.Builder builder = CompartmentDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.code((CompartmentType)this.parseString(CompartmentType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.search(this.parseBoolean("search", JsonSupport.getJsonValue(jsonObject, "search", JsonValue.class), (JsonValue)jsonObject.get((Object)"_search"), -1));
        JsonArray resourceArray = JsonSupport.getJsonArray(jsonObject, "resource");
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.size(); ++i) {
                if (((JsonValue)resourceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)resourceArray.get(i)).getValueType() + " for element: resource");
                }
                builder.resource(this.parseCompartmentDefinitionResource("resource", resourceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CompartmentDefinition.Resource parseCompartmentDefinitionResource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CompartmentDefinition.Resource.class, jsonObject);
        }
        CompartmentDefinition.Resource.Builder builder = CompartmentDefinition.Resource.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((ResourceTypeCode)this.parseString(ResourceTypeCode.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        JsonArray paramArray = JsonSupport.getJsonArray(jsonObject, "param", true);
        if (paramArray != null) {
            JsonArray _paramArray = jsonObject.getJsonArray("_param");
            for (int i = 0; i < paramArray.size(); ++i) {
                builder.param(this.parseString("param", (JsonValue)paramArray.get(i), JsonSupport.getJsonValue(_paramArray, i), i));
            }
        }
        builder.documentation(this.parseString("documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private Composition parseComposition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray sectionArray;
        JsonArray eventArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Composition.class, jsonObject);
        }
        Composition.Builder builder = Composition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.status((CompositionStatus)this.parseString(CompositionStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.confidentiality((DocumentConfidentiality)this.parseString(DocumentConfidentiality.builder(), "confidentiality", (JsonValue)JsonSupport.getJsonValue(jsonObject, "confidentiality", JsonString.class), (JsonValue)jsonObject.get((Object)"_confidentiality"), -1));
        JsonArray attesterArray = JsonSupport.getJsonArray(jsonObject, "attester");
        if (attesterArray != null) {
            for (int i = 0; i < attesterArray.size(); ++i) {
                if (((JsonValue)attesterArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)attesterArray.get(i)).getValueType() + " for element: attester");
                }
                builder.attester(this.parseCompositionAttester("attester", attesterArray.getJsonObject(i), i));
            }
        }
        builder.custodian(this.parseReference("custodian", JsonSupport.getJsonValue(jsonObject, "custodian", JsonObject.class), -1));
        JsonArray relatesToArray = JsonSupport.getJsonArray(jsonObject, "relatesTo");
        if (relatesToArray != null) {
            for (int i = 0; i < relatesToArray.size(); ++i) {
                if (((JsonValue)relatesToArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatesToArray.get(i)).getValueType() + " for element: relatesTo");
                }
                builder.relatesTo(this.parseCompositionRelatesTo("relatesTo", relatesToArray.getJsonObject(i), i));
            }
        }
        if ((eventArray = JsonSupport.getJsonArray(jsonObject, "event")) != null) {
            for (int i = 0; i < eventArray.size(); ++i) {
                if (((JsonValue)eventArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)eventArray.get(i)).getValueType() + " for element: event");
                }
                builder.event(this.parseCompositionEvent("event", eventArray.getJsonObject(i), i));
            }
        }
        if ((sectionArray = JsonSupport.getJsonArray(jsonObject, "section")) != null) {
            for (int i = 0; i < sectionArray.size(); ++i) {
                if (((JsonValue)sectionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)sectionArray.get(i)).getValueType() + " for element: section");
                }
                builder.section(this.parseCompositionSection("section", sectionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Composition.Attester parseCompositionAttester(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Composition.Attester.class, jsonObject);
        }
        Composition.Attester.Builder builder = Composition.Attester.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((CompositionAttestationMode)this.parseString(CompositionAttestationMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.time(this.parseDateTime("time", (JsonValue)JsonSupport.getJsonValue(jsonObject, "time", JsonString.class), (JsonValue)jsonObject.get((Object)"_time"), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Composition.Event parseCompositionEvent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Composition.Event.class, jsonObject);
        }
        Composition.Event.Builder builder = Composition.Event.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                if (((JsonValue)codeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeArray.get(i)).getValueType() + " for element: code");
                }
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray detailArray = JsonSupport.getJsonArray(jsonObject, "detail");
        if (detailArray != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                if (((JsonValue)detailArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Composition.RelatesTo parseCompositionRelatesTo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Composition.RelatesTo.class, jsonObject);
        }
        Composition.RelatesTo.Builder builder = Composition.RelatesTo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((DocumentRelationshipType)this.parseString(DocumentRelationshipType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.target(this.parseChoiceElement("target", jsonObject, Identifier.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Composition.Section parseCompositionSection(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Composition.Section.class, jsonObject);
        }
        Composition.Section.Builder builder = Composition.Section.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        builder.focus(this.parseReference("focus", JsonSupport.getJsonValue(jsonObject, "focus", JsonObject.class), -1));
        builder.text(this.parseNarrative("text", JsonSupport.getJsonValue(jsonObject, "text", JsonObject.class), -1));
        builder.mode((SectionMode)this.parseString(SectionMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.orderedBy(this.parseCodeableConcept("orderedBy", JsonSupport.getJsonValue(jsonObject, "orderedBy", JsonObject.class), -1));
        JsonArray entryArray = JsonSupport.getJsonArray(jsonObject, "entry");
        if (entryArray != null) {
            for (int i = 0; i < entryArray.size(); ++i) {
                if (((JsonValue)entryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)entryArray.get(i)).getValueType() + " for element: entry");
                }
                builder.entry(this.parseReference("entry", entryArray.getJsonObject(i), i));
            }
        }
        builder.emptyReason(this.parseCodeableConcept("emptyReason", JsonSupport.getJsonValue(jsonObject, "emptyReason", JsonObject.class), -1));
        JsonArray sectionArray = JsonSupport.getJsonArray(jsonObject, "section");
        if (sectionArray != null) {
            for (int i = 0; i < sectionArray.size(); ++i) {
                if (((JsonValue)sectionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)sectionArray.get(i)).getValueType() + " for element: section");
                }
                builder.section(this.parseCompositionSection("section", sectionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap parseConceptMap(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.class, jsonObject);
        }
        ConceptMap.Builder builder = ConceptMap.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                if (((JsonValue)jurisdictionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.source(this.parseChoiceElement("source", jsonObject, Uri.class, Canonical.class));
        builder.target(this.parseChoiceElement("target", jsonObject, Uri.class, Canonical.class));
        JsonArray groupArray = JsonSupport.getJsonArray(jsonObject, "group");
        if (groupArray != null) {
            for (int i = 0; i < groupArray.size(); ++i) {
                if (((JsonValue)groupArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)groupArray.get(i)).getValueType() + " for element: group");
                }
                builder.group(this.parseConceptMapGroup("group", groupArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group parseConceptMapGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.class, jsonObject);
        }
        ConceptMap.Group.Builder builder = ConceptMap.Group.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.source(this.parseUri("source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        builder.sourceVersion(this.parseString("sourceVersion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sourceVersion", JsonString.class), (JsonValue)jsonObject.get((Object)"_sourceVersion"), -1));
        builder.target(this.parseUri("target", (JsonValue)JsonSupport.getJsonValue(jsonObject, "target", JsonString.class), (JsonValue)jsonObject.get((Object)"_target"), -1));
        builder.targetVersion(this.parseString("targetVersion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "targetVersion", JsonString.class), (JsonValue)jsonObject.get((Object)"_targetVersion"), -1));
        JsonArray elementArray = JsonSupport.getJsonArray(jsonObject, "element");
        if (elementArray != null) {
            for (int i = 0; i < elementArray.size(); ++i) {
                if (((JsonValue)elementArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)elementArray.get(i)).getValueType() + " for element: element");
                }
                builder.element(this.parseConceptMapGroupElement("element", elementArray.getJsonObject(i), i));
            }
        }
        builder.unmapped(this.parseConceptMapGroupUnmapped("unmapped", JsonSupport.getJsonValue(jsonObject, "unmapped", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Element parseConceptMapGroupElement(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Element.class, jsonObject);
        }
        ConceptMap.Group.Element.Builder builder = ConceptMap.Group.Element.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        JsonArray targetArray = JsonSupport.getJsonArray(jsonObject, "target");
        if (targetArray != null) {
            for (int i = 0; i < targetArray.size(); ++i) {
                if (((JsonValue)targetArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)targetArray.get(i)).getValueType() + " for element: target");
                }
                builder.target(this.parseConceptMapGroupElementTarget("target", targetArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Element.Target parseConceptMapGroupElementTarget(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray productArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Element.Target.class, jsonObject);
        }
        ConceptMap.Group.Element.Target.Builder builder = ConceptMap.Group.Element.Target.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.equivalence((ConceptMapEquivalence)this.parseString(ConceptMapEquivalence.builder(), "equivalence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "equivalence", JsonString.class), (JsonValue)jsonObject.get((Object)"_equivalence"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        JsonArray dependsOnArray = JsonSupport.getJsonArray(jsonObject, "dependsOn");
        if (dependsOnArray != null) {
            for (int i = 0; i < dependsOnArray.size(); ++i) {
                if (((JsonValue)dependsOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)dependsOnArray.get(i)).getValueType() + " for element: dependsOn");
                }
                builder.dependsOn(this.parseConceptMapGroupElementTargetDependsOn("dependsOn", dependsOnArray.getJsonObject(i), i));
            }
        }
        if ((productArray = JsonSupport.getJsonArray(jsonObject, "product")) != null) {
            for (int i = 0; i < productArray.size(); ++i) {
                if (((JsonValue)productArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)productArray.get(i)).getValueType() + " for element: product");
                }
                builder.product(this.parseConceptMapGroupElementTargetDependsOn("product", productArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Element.Target.DependsOn parseConceptMapGroupElementTargetDependsOn(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Element.Target.DependsOn.class, jsonObject);
        }
        ConceptMap.Group.Element.Target.DependsOn.Builder builder = ConceptMap.Group.Element.Target.DependsOn.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.property(this.parseUri("property", (JsonValue)JsonSupport.getJsonValue(jsonObject, "property", JsonString.class), (JsonValue)jsonObject.get((Object)"_property"), -1));
        builder.system((Canonical)this.parseUri(Canonical.builder(), "system", (JsonValue)JsonSupport.getJsonValue(jsonObject, "system", JsonString.class), (JsonValue)jsonObject.get((Object)"_system"), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Unmapped parseConceptMapGroupUnmapped(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Unmapped.class, jsonObject);
        }
        ConceptMap.Group.Unmapped.Builder builder = ConceptMap.Group.Unmapped.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((ConceptMapGroupUnmappedMode)this.parseString(ConceptMapGroupUnmappedMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.url((Canonical)this.parseUri(Canonical.builder(), "url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        this.stackPop();
        return builder.build();
    }

    private Condition parseCondition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray evidenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Condition.class, jsonObject);
        }
        Condition.Builder builder = Condition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.clinicalStatus(this.parseCodeableConcept("clinicalStatus", JsonSupport.getJsonValue(jsonObject, "clinicalStatus", JsonObject.class), -1));
        builder.verificationStatus(this.parseCodeableConcept("verificationStatus", JsonSupport.getJsonValue(jsonObject, "verificationStatus", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.severity(this.parseCodeableConcept("severity", JsonSupport.getJsonValue(jsonObject, "severity", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray bodySiteArray = JsonSupport.getJsonArray(jsonObject, "bodySite");
        if (bodySiteArray != null) {
            for (int i = 0; i < bodySiteArray.size(); ++i) {
                if (((JsonValue)bodySiteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)bodySiteArray.get(i)).getValueType() + " for element: bodySite");
                }
                builder.bodySite(this.parseCodeableConcept("bodySite", bodySiteArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.onset(this.parseChoiceElement("onset", jsonObject, DateTime.class, Age.class, Period.class, Range.class, org.linuxforhealth.fhir.model.type.String.class));
        builder.abatement(this.parseChoiceElement("abatement", jsonObject, DateTime.class, Age.class, Period.class, Range.class, org.linuxforhealth.fhir.model.type.String.class));
        builder.recordedDate(this.parseDateTime("recordedDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedDate"), -1));
        builder.recorder(this.parseReference("recorder", JsonSupport.getJsonValue(jsonObject, "recorder", JsonObject.class), -1));
        builder.asserter(this.parseReference("asserter", JsonSupport.getJsonValue(jsonObject, "asserter", JsonObject.class), -1));
        JsonArray stageArray = JsonSupport.getJsonArray(jsonObject, "stage");
        if (stageArray != null) {
            for (int i = 0; i < stageArray.size(); ++i) {
                if (((JsonValue)stageArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)stageArray.get(i)).getValueType() + " for element: stage");
                }
                builder.stage(this.parseConditionStage("stage", stageArray.getJsonObject(i), i));
            }
        }
        if ((evidenceArray = JsonSupport.getJsonArray(jsonObject, "evidence")) != null) {
            for (int i = 0; i < evidenceArray.size(); ++i) {
                if (((JsonValue)evidenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)evidenceArray.get(i)).getValueType() + " for element: evidence");
                }
                builder.evidence(this.parseConditionEvidence("evidence", evidenceArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Condition.Evidence parseConditionEvidence(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Condition.Evidence.class, jsonObject);
        }
        Condition.Evidence.Builder builder = Condition.Evidence.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                if (((JsonValue)codeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeArray.get(i)).getValueType() + " for element: code");
                }
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                if (((JsonValue)detailArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Condition.Stage parseConditionStage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Condition.Stage.class, jsonObject);
        }
        Condition.Stage.Builder builder = Condition.Stage.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.summary(this.parseCodeableConcept("summary", JsonSupport.getJsonValue(jsonObject, "summary", JsonObject.class), -1));
        JsonArray assessmentArray = JsonSupport.getJsonArray(jsonObject, "assessment");
        if (assessmentArray != null) {
            for (int i = 0; i < assessmentArray.size(); ++i) {
                if (((JsonValue)assessmentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)assessmentArray.get(i)).getValueType() + " for element: assessment");
                }
                builder.assessment(this.parseReference("assessment", assessmentArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent parseConsent(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray organizationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Consent.class, jsonObject);
        }
        Consent.Builder builder = Consent.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ConsentState)this.parseString(ConsentState.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.scope(this.parseCodeableConcept("scope", JsonSupport.getJsonValue(jsonObject, "scope", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.dateTime(this.parseDateTime("dateTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "dateTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_dateTime"), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i = 0; i < performerArray.size(); ++i) {
                if (((JsonValue)performerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)performerArray.get(i)).getValueType() + " for element: performer");
                }
                builder.performer(this.parseReference("performer", performerArray.getJsonObject(i), i));
            }
        }
        if ((organizationArray = JsonSupport.getJsonArray(jsonObject, "organization")) != null) {
            for (int i = 0; i < organizationArray.size(); ++i) {
                if (((JsonValue)organizationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)organizationArray.get(i)).getValueType() + " for element: organization");
                }
                builder.organization(this.parseReference("organization", organizationArray.getJsonObject(i), i));
            }
        }
        builder.source(this.parseChoiceElement("source", jsonObject, Attachment.class, Reference.class));
        JsonArray policyArray = JsonSupport.getJsonArray(jsonObject, "policy");
        if (policyArray != null) {
            for (int i = 0; i < policyArray.size(); ++i) {
                if (((JsonValue)policyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)policyArray.get(i)).getValueType() + " for element: policy");
                }
                builder.policy(this.parseConsentPolicy("policy", policyArray.getJsonObject(i), i));
            }
        }
        builder.policyRule(this.parseCodeableConcept("policyRule", JsonSupport.getJsonValue(jsonObject, "policyRule", JsonObject.class), -1));
        JsonArray verificationArray = JsonSupport.getJsonArray(jsonObject, "verification");
        if (verificationArray != null) {
            for (int i = 0; i < verificationArray.size(); ++i) {
                if (((JsonValue)verificationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)verificationArray.get(i)).getValueType() + " for element: verification");
                }
                builder.verification(this.parseConsentVerification("verification", verificationArray.getJsonObject(i), i));
            }
        }
        builder.provision(this.parseConsentProvision("provision", JsonSupport.getJsonValue(jsonObject, "provision", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Policy parseConsentPolicy(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Consent.Policy.class, jsonObject);
        }
        Consent.Policy.Builder builder = Consent.Policy.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.authority(this.parseUri("authority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authority", JsonString.class), (JsonValue)jsonObject.get((Object)"_authority"), -1));
        builder.uri(this.parseUri("uri", (JsonValue)JsonSupport.getJsonValue(jsonObject, "uri", JsonString.class), (JsonValue)jsonObject.get((Object)"_uri"), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Provision parseConsentProvision(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray provisionArray;
        JsonArray codeArray;
        JsonArray classArray;
        JsonArray purposeArray;
        JsonArray securityLabelArray;
        JsonArray actionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Consent.Provision.class, jsonObject);
        }
        Consent.Provision.Builder builder = Consent.Provision.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ConsentProvisionType)this.parseString(ConsentProvisionType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray actorArray = JsonSupport.getJsonArray(jsonObject, "actor");
        if (actorArray != null) {
            for (int i = 0; i < actorArray.size(); ++i) {
                if (((JsonValue)actorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)actorArray.get(i)).getValueType() + " for element: actor");
                }
                builder.actor(this.parseConsentProvisionActor("actor", actorArray.getJsonObject(i), i));
            }
        }
        if ((actionArray = JsonSupport.getJsonArray(jsonObject, "action")) != null) {
            for (int i = 0; i < actionArray.size(); ++i) {
                if (((JsonValue)actionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)actionArray.get(i)).getValueType() + " for element: action");
                }
                builder.action(this.parseCodeableConcept("action", actionArray.getJsonObject(i), i));
            }
        }
        if ((securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel")) != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                if (((JsonValue)securityLabelArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)securityLabelArray.get(i)).getValueType() + " for element: securityLabel");
                }
                builder.securityLabel(this.parseCoding("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        if ((purposeArray = JsonSupport.getJsonArray(jsonObject, "purpose")) != null) {
            for (int i = 0; i < purposeArray.size(); ++i) {
                if (((JsonValue)purposeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)purposeArray.get(i)).getValueType() + " for element: purpose");
                }
                builder.purpose(this.parseCoding("purpose", purposeArray.getJsonObject(i), i));
            }
        }
        if ((classArray = JsonSupport.getJsonArray(jsonObject, "class")) != null) {
            for (int i = 0; i < classArray.size(); ++i) {
                if (((JsonValue)classArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classArray.get(i)).getValueType() + " for element: class");
                }
                builder.clazz(this.parseCoding("class", classArray.getJsonObject(i), i));
            }
        }
        if ((codeArray = JsonSupport.getJsonArray(jsonObject, "code")) != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                if (((JsonValue)codeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeArray.get(i)).getValueType() + " for element: code");
                }
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        builder.dataPeriod(this.parsePeriod("dataPeriod", JsonSupport.getJsonValue(jsonObject, "dataPeriod", JsonObject.class), -1));
        JsonArray dataArray = JsonSupport.getJsonArray(jsonObject, "data");
        if (dataArray != null) {
            for (int i = 0; i < dataArray.size(); ++i) {
                if (((JsonValue)dataArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)dataArray.get(i)).getValueType() + " for element: data");
                }
                builder.data(this.parseConsentProvisionData("data", dataArray.getJsonObject(i), i));
            }
        }
        if ((provisionArray = JsonSupport.getJsonArray(jsonObject, "provision")) != null) {
            for (int i = 0; i < provisionArray.size(); ++i) {
                if (((JsonValue)provisionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)provisionArray.get(i)).getValueType() + " for element: provision");
                }
                builder.provision(this.parseConsentProvision("provision", provisionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Consent.Provision.Actor parseConsentProvisionActor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Consent.Provision.Actor.class, jsonObject);
        }
        Consent.Provision.Actor.Builder builder = Consent.Provision.Actor.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Provision.Data parseConsentProvisionData(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Consent.Provision.Data.class, jsonObject);
        }
        Consent.Provision.Data.Builder builder = Consent.Provision.Data.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.meaning((ConsentDataMeaning)this.parseString(ConsentDataMeaning.builder(), "meaning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "meaning", JsonString.class), (JsonValue)jsonObject.get((Object)"_meaning"), -1));
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Verification parseConsentVerification(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Consent.Verification.class, jsonObject);
        }
        Consent.Verification.Builder builder = Consent.Verification.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.verified(this.parseBoolean("verified", JsonSupport.getJsonValue(jsonObject, "verified", JsonValue.class), (JsonValue)jsonObject.get((Object)"_verified"), -1));
        builder.verifiedWith(this.parseReference("verifiedWith", JsonSupport.getJsonValue(jsonObject, "verifiedWith", JsonObject.class), -1));
        builder.verificationDate(this.parseDateTime("verificationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "verificationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_verificationDate"), -1));
        this.stackPop();
        return builder.build();
    }

    private ContactDetail parseContactDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ContactDetail.class, jsonObject);
        }
        ContactDetail.Builder builder = ContactDetail.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom");
        if (telecomArray != null) {
            for (int i = 0; i < telecomArray.size(); ++i) {
                if (((JsonValue)telecomArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)telecomArray.get(i)).getValueType() + " for element: telecom");
                }
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ContactPoint parseContactPoint(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ContactPoint.class, jsonObject);
        }
        ContactPoint.Builder builder = ContactPoint.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.system((ContactPointSystem)this.parseString(ContactPointSystem.builder(), "system", (JsonValue)JsonSupport.getJsonValue(jsonObject, "system", JsonString.class), (JsonValue)jsonObject.get((Object)"_system"), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.use((ContactPointUse)this.parseString(ContactPointUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.rank((PositiveInt)this.parseInteger(PositiveInt.builder(), "rank", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rank", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_rank"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract parseContract(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray ruleArray;
        JsonArray legalArray;
        JsonArray friendlyArray;
        JsonArray signerArray;
        JsonArray relevantHistoryArray;
        JsonArray supportingInfoArray;
        int i;
        JsonArray siteArray;
        JsonArray domainArray;
        JsonArray authorityArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.class, jsonObject);
        }
        Contract.Builder builder = Contract.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.status((ContractStatus)this.parseString(ContractStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.legalState(this.parseCodeableConcept("legalState", JsonSupport.getJsonValue(jsonObject, "legalState", JsonObject.class), -1));
        builder.instantiatesCanonical(this.parseReference("instantiatesCanonical", JsonSupport.getJsonValue(jsonObject, "instantiatesCanonical", JsonObject.class), -1));
        builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)JsonSupport.getJsonValue(jsonObject, "instantiatesUri", JsonString.class), (JsonValue)jsonObject.get((Object)"_instantiatesUri"), -1));
        builder.contentDerivative(this.parseCodeableConcept("contentDerivative", JsonSupport.getJsonValue(jsonObject, "contentDerivative", JsonObject.class), -1));
        builder.issued(this.parseDateTime("issued", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issued", JsonString.class), (JsonValue)jsonObject.get((Object)"_issued"), -1));
        builder.applies(this.parsePeriod("applies", JsonSupport.getJsonValue(jsonObject, "applies", JsonObject.class), -1));
        builder.expirationType(this.parseCodeableConcept("expirationType", JsonSupport.getJsonValue(jsonObject, "expirationType", JsonObject.class), -1));
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i3 = 0; i3 < subjectArray.size(); ++i3) {
                if (((JsonValue)subjectArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subjectArray.get(i3)).getValueType() + " for element: subject");
                }
                builder.subject(this.parseReference("subject", subjectArray.getJsonObject(i3), i3));
            }
        }
        if ((authorityArray = JsonSupport.getJsonArray(jsonObject, "authority")) != null) {
            for (int i4 = 0; i4 < authorityArray.size(); ++i4) {
                if (((JsonValue)authorityArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorityArray.get(i4)).getValueType() + " for element: authority");
                }
                builder.authority(this.parseReference("authority", authorityArray.getJsonObject(i4), i4));
            }
        }
        if ((domainArray = JsonSupport.getJsonArray(jsonObject, "domain")) != null) {
            for (int i5 = 0; i5 < domainArray.size(); ++i5) {
                if (((JsonValue)domainArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)domainArray.get(i5)).getValueType() + " for element: domain");
                }
                builder.domain(this.parseReference("domain", domainArray.getJsonObject(i5), i5));
            }
        }
        if ((siteArray = JsonSupport.getJsonArray(jsonObject, "site")) != null) {
            for (int i6 = 0; i6 < siteArray.size(); ++i6) {
                if (((JsonValue)siteArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)siteArray.get(i6)).getValueType() + " for element: site");
                }
                builder.site(this.parseReference("site", siteArray.getJsonObject(i6), i6));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        JsonArray aliasArray = JsonSupport.getJsonArray(jsonObject, "alias", true);
        if (aliasArray != null) {
            JsonArray _aliasArray = jsonObject.getJsonArray("_alias");
            for (i = 0; i < aliasArray.size(); ++i) {
                builder.alias(this.parseString("alias", (JsonValue)aliasArray.get(i), JsonSupport.getJsonValue(_aliasArray, i), i));
            }
        }
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        builder.scope(this.parseCodeableConcept("scope", JsonSupport.getJsonValue(jsonObject, "scope", JsonObject.class), -1));
        builder.topic(this.parseChoiceElement("topic", jsonObject, CodeableConcept.class, Reference.class));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray subTypeArray = JsonSupport.getJsonArray(jsonObject, "subType");
        if (subTypeArray != null) {
            for (i = 0; i < subTypeArray.size(); ++i) {
                if (((JsonValue)subTypeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subTypeArray.get(i)).getValueType() + " for element: subType");
                }
                builder.subType(this.parseCodeableConcept("subType", subTypeArray.getJsonObject(i), i));
            }
        }
        builder.contentDefinition(this.parseContractContentDefinition("contentDefinition", JsonSupport.getJsonValue(jsonObject, "contentDefinition", JsonObject.class), -1));
        JsonArray termArray = JsonSupport.getJsonArray(jsonObject, "term");
        if (termArray != null) {
            for (int i7 = 0; i7 < termArray.size(); ++i7) {
                if (((JsonValue)termArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)termArray.get(i7)).getValueType() + " for element: term");
                }
                builder.term(this.parseContractTerm("term", termArray.getJsonObject(i7), i7));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i8 = 0; i8 < supportingInfoArray.size(); ++i8) {
                if (((JsonValue)supportingInfoArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInfoArray.get(i8)).getValueType() + " for element: supportingInfo");
                }
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i8), i8));
            }
        }
        if ((relevantHistoryArray = JsonSupport.getJsonArray(jsonObject, "relevantHistory")) != null) {
            for (int i9 = 0; i9 < relevantHistoryArray.size(); ++i9) {
                if (((JsonValue)relevantHistoryArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relevantHistoryArray.get(i9)).getValueType() + " for element: relevantHistory");
                }
                builder.relevantHistory(this.parseReference("relevantHistory", relevantHistoryArray.getJsonObject(i9), i9));
            }
        }
        if ((signerArray = JsonSupport.getJsonArray(jsonObject, "signer")) != null) {
            for (int i10 = 0; i10 < signerArray.size(); ++i10) {
                if (((JsonValue)signerArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)signerArray.get(i10)).getValueType() + " for element: signer");
                }
                builder.signer(this.parseContractSigner("signer", signerArray.getJsonObject(i10), i10));
            }
        }
        if ((friendlyArray = JsonSupport.getJsonArray(jsonObject, "friendly")) != null) {
            for (int i11 = 0; i11 < friendlyArray.size(); ++i11) {
                if (((JsonValue)friendlyArray.get(i11)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)friendlyArray.get(i11)).getValueType() + " for element: friendly");
                }
                builder.friendly(this.parseContractFriendly("friendly", friendlyArray.getJsonObject(i11), i11));
            }
        }
        if ((legalArray = JsonSupport.getJsonArray(jsonObject, "legal")) != null) {
            for (int i12 = 0; i12 < legalArray.size(); ++i12) {
                if (((JsonValue)legalArray.get(i12)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)legalArray.get(i12)).getValueType() + " for element: legal");
                }
                builder.legal(this.parseContractLegal("legal", legalArray.getJsonObject(i12), i12));
            }
        }
        if ((ruleArray = JsonSupport.getJsonArray(jsonObject, "rule")) != null) {
            for (int i13 = 0; i13 < ruleArray.size(); ++i13) {
                if (((JsonValue)ruleArray.get(i13)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)ruleArray.get(i13)).getValueType() + " for element: rule");
                }
                builder.rule(this.parseContractRule("rule", ruleArray.getJsonObject(i13), i13));
            }
        }
        builder.legallyBinding(this.parseChoiceElement("legallyBinding", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.ContentDefinition parseContractContentDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.ContentDefinition.class, jsonObject);
        }
        Contract.ContentDefinition.Builder builder = Contract.ContentDefinition.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.publisher(this.parseReference("publisher", JsonSupport.getJsonValue(jsonObject, "publisher", JsonObject.class), -1));
        builder.publicationDate(this.parseDateTime("publicationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publicationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_publicationDate"), -1));
        builder.publicationStatus((ContractPublicationStatus)this.parseString(ContractPublicationStatus.builder(), "publicationStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publicationStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_publicationStatus"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Friendly parseContractFriendly(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Friendly.class, jsonObject);
        }
        Contract.Friendly.Builder builder = Contract.Friendly.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Legal parseContractLegal(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Legal.class, jsonObject);
        }
        Contract.Legal.Builder builder = Contract.Legal.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Rule parseContractRule(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Rule.class, jsonObject);
        }
        Contract.Rule.Builder builder = Contract.Rule.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Signer parseContractSigner(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Signer.class, jsonObject);
        }
        Contract.Signer.Builder builder = Contract.Signer.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCoding("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        JsonArray signatureArray = JsonSupport.getJsonArray(jsonObject, "signature");
        if (signatureArray != null) {
            for (int i = 0; i < signatureArray.size(); ++i) {
                if (((JsonValue)signatureArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)signatureArray.get(i)).getValueType() + " for element: signature");
                }
                builder.signature(this.parseSignature("signature", signatureArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term parseContractTerm(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray groupArray;
        JsonArray actionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.class, jsonObject);
        }
        Contract.Term.Builder builder = Contract.Term.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.issued(this.parseDateTime("issued", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issued", JsonString.class), (JsonValue)jsonObject.get((Object)"_issued"), -1));
        builder.applies(this.parsePeriod("applies", JsonSupport.getJsonValue(jsonObject, "applies", JsonObject.class), -1));
        builder.topic(this.parseChoiceElement("topic", jsonObject, CodeableConcept.class, Reference.class));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel");
        if (securityLabelArray != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                if (((JsonValue)securityLabelArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)securityLabelArray.get(i)).getValueType() + " for element: securityLabel");
                }
                builder.securityLabel(this.parseContractTermSecurityLabel("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        builder.offer(this.parseContractTermOffer("offer", JsonSupport.getJsonValue(jsonObject, "offer", JsonObject.class), -1));
        JsonArray assetArray = JsonSupport.getJsonArray(jsonObject, "asset");
        if (assetArray != null) {
            for (int i = 0; i < assetArray.size(); ++i) {
                if (((JsonValue)assetArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)assetArray.get(i)).getValueType() + " for element: asset");
                }
                builder.asset(this.parseContractTermAsset("asset", assetArray.getJsonObject(i), i));
            }
        }
        if ((actionArray = JsonSupport.getJsonArray(jsonObject, "action")) != null) {
            for (int i = 0; i < actionArray.size(); ++i) {
                if (((JsonValue)actionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)actionArray.get(i)).getValueType() + " for element: action");
                }
                builder.action(this.parseContractTermAction("action", actionArray.getJsonObject(i), i));
            }
        }
        if ((groupArray = JsonSupport.getJsonArray(jsonObject, "group")) != null) {
            for (int i = 0; i < groupArray.size(); ++i) {
                if (((JsonValue)groupArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)groupArray.get(i)).getValueType() + " for element: group");
                }
                builder.group(this.parseContractTerm("group", groupArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Action parseContractTermAction(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray securityLabelNumberArray;
        JsonArray noteArray;
        int i;
        JsonArray reasonLinkIdArray;
        JsonArray reasonArray;
        JsonArray reasonReferenceArray;
        JsonArray reasonCodeArray;
        int i2;
        JsonArray performerTypeArray;
        int i3;
        JsonArray requesterLinkIdArray;
        int i4;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Action.class, jsonObject);
        }
        Contract.Term.Action.Builder builder = Contract.Term.Action.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i5 = 0; i5 < subjectArray.size(); ++i5) {
                if (((JsonValue)subjectArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subjectArray.get(i5)).getValueType() + " for element: subject");
                }
                builder.subject(this.parseContractTermActionSubject("subject", subjectArray.getJsonObject(i5), i5));
            }
        }
        builder.intent(this.parseCodeableConcept("intent", JsonSupport.getJsonValue(jsonObject, "intent", JsonObject.class), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (int i6 = 0; i6 < linkIdArray.size(); ++i6) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i6), JsonSupport.getJsonValue(_linkIdArray, i6), i6));
            }
        }
        builder.status(this.parseCodeableConcept("status", JsonSupport.getJsonValue(jsonObject, "status", JsonObject.class), -1));
        builder.context(this.parseReference("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        JsonArray contextLinkIdArray = JsonSupport.getJsonArray(jsonObject, "contextLinkId", true);
        if (contextLinkIdArray != null) {
            JsonArray _contextLinkIdArray = jsonObject.getJsonArray("_contextLinkId");
            for (i4 = 0; i4 < contextLinkIdArray.size(); ++i4) {
                builder.contextLinkId(this.parseString("contextLinkId", (JsonValue)contextLinkIdArray.get(i4), JsonSupport.getJsonValue(_contextLinkIdArray, i4), i4));
            }
        }
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class, Timing.class));
        JsonArray requesterArray = JsonSupport.getJsonArray(jsonObject, "requester");
        if (requesterArray != null) {
            for (i4 = 0; i4 < requesterArray.size(); ++i4) {
                if (((JsonValue)requesterArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)requesterArray.get(i4)).getValueType() + " for element: requester");
                }
                builder.requester(this.parseReference("requester", requesterArray.getJsonObject(i4), i4));
            }
        }
        if ((requesterLinkIdArray = JsonSupport.getJsonArray(jsonObject, "requesterLinkId", true)) != null) {
            JsonArray _requesterLinkIdArray = jsonObject.getJsonArray("_requesterLinkId");
            for (i3 = 0; i3 < requesterLinkIdArray.size(); ++i3) {
                builder.requesterLinkId(this.parseString("requesterLinkId", (JsonValue)requesterLinkIdArray.get(i3), JsonSupport.getJsonValue(_requesterLinkIdArray, i3), i3));
            }
        }
        if ((performerTypeArray = JsonSupport.getJsonArray(jsonObject, "performerType")) != null) {
            for (i3 = 0; i3 < performerTypeArray.size(); ++i3) {
                if (((JsonValue)performerTypeArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)performerTypeArray.get(i3)).getValueType() + " for element: performerType");
                }
                builder.performerType(this.parseCodeableConcept("performerType", performerTypeArray.getJsonObject(i3), i3));
            }
        }
        builder.performerRole(this.parseCodeableConcept("performerRole", JsonSupport.getJsonValue(jsonObject, "performerRole", JsonObject.class), -1));
        builder.performer(this.parseReference("performer", JsonSupport.getJsonValue(jsonObject, "performer", JsonObject.class), -1));
        JsonArray performerLinkIdArray = JsonSupport.getJsonArray(jsonObject, "performerLinkId", true);
        if (performerLinkIdArray != null) {
            JsonArray _performerLinkIdArray = jsonObject.getJsonArray("_performerLinkId");
            for (i2 = 0; i2 < performerLinkIdArray.size(); ++i2) {
                builder.performerLinkId(this.parseString("performerLinkId", (JsonValue)performerLinkIdArray.get(i2), JsonSupport.getJsonValue(_performerLinkIdArray, i2), i2));
            }
        }
        if ((reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode")) != null) {
            for (i2 = 0; i2 < reasonCodeArray.size(); ++i2) {
                if (((JsonValue)reasonCodeArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i2)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i2), i2));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i7 = 0; i7 < reasonReferenceArray.size(); ++i7) {
                if (((JsonValue)reasonReferenceArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i7)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i7), i7));
            }
        }
        if ((reasonArray = JsonSupport.getJsonArray(jsonObject, "reason", true)) != null) {
            JsonArray _reasonArray = jsonObject.getJsonArray("_reason");
            for (int i8 = 0; i8 < reasonArray.size(); ++i8) {
                builder.reason(this.parseString("reason", (JsonValue)reasonArray.get(i8), JsonSupport.getJsonValue(_reasonArray, i8), i8));
            }
        }
        if ((reasonLinkIdArray = JsonSupport.getJsonArray(jsonObject, "reasonLinkId", true)) != null) {
            JsonArray _reasonLinkIdArray = jsonObject.getJsonArray("_reasonLinkId");
            for (i = 0; i < reasonLinkIdArray.size(); ++i) {
                builder.reasonLinkId(this.parseString("reasonLinkId", (JsonValue)reasonLinkIdArray.get(i), JsonSupport.getJsonValue(_reasonLinkIdArray, i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (int i9 = 0; i9 < securityLabelNumberArray.size(); ++i9) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i9), JsonSupport.getJsonValue(_securityLabelNumberArray, i9), i9));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Action.Subject parseContractTermActionSubject(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Action.Subject.class, jsonObject);
        }
        Contract.Term.Action.Subject.Builder builder = Contract.Term.Action.Subject.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray referenceArray = JsonSupport.getJsonArray(jsonObject, "reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                if (((JsonValue)referenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)referenceArray.get(i)).getValueType() + " for element: reference");
                }
                builder.reference(this.parseReference("reference", referenceArray.getJsonObject(i), i));
            }
        }
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Asset parseContractTermAsset(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray valuedItemArray;
        int i;
        JsonArray securityLabelNumberArray;
        JsonArray answerArray;
        int i2;
        JsonArray usePeriodArray;
        JsonArray periodArray;
        JsonArray subtypeArray;
        JsonArray typeReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Asset.class, jsonObject);
        }
        Contract.Term.Asset.Builder builder = Contract.Term.Asset.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.scope(this.parseCodeableConcept("scope", JsonSupport.getJsonValue(jsonObject, "scope", JsonObject.class), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i3 = 0; i3 < typeArray.size(); ++i3) {
                if (((JsonValue)typeArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i3)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i3), i3));
            }
        }
        if ((typeReferenceArray = JsonSupport.getJsonArray(jsonObject, "typeReference")) != null) {
            for (int i4 = 0; i4 < typeReferenceArray.size(); ++i4) {
                if (((JsonValue)typeReferenceArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeReferenceArray.get(i4)).getValueType() + " for element: typeReference");
                }
                builder.typeReference(this.parseReference("typeReference", typeReferenceArray.getJsonObject(i4), i4));
            }
        }
        if ((subtypeArray = JsonSupport.getJsonArray(jsonObject, "subtype")) != null) {
            for (int i5 = 0; i5 < subtypeArray.size(); ++i5) {
                if (((JsonValue)subtypeArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subtypeArray.get(i5)).getValueType() + " for element: subtype");
                }
                builder.subtype(this.parseCodeableConcept("subtype", subtypeArray.getJsonObject(i5), i5));
            }
        }
        builder.relationship(this.parseCoding("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        JsonArray contextArray = JsonSupport.getJsonArray(jsonObject, "context");
        if (contextArray != null) {
            for (int i6 = 0; i6 < contextArray.size(); ++i6) {
                if (((JsonValue)contextArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contextArray.get(i6)).getValueType() + " for element: context");
                }
                builder.context(this.parseContractTermAssetContext("context", contextArray.getJsonObject(i6), i6));
            }
        }
        builder.condition(this.parseString("condition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "condition", JsonString.class), (JsonValue)jsonObject.get((Object)"_condition"), -1));
        JsonArray periodTypeArray = JsonSupport.getJsonArray(jsonObject, "periodType");
        if (periodTypeArray != null) {
            for (int i7 = 0; i7 < periodTypeArray.size(); ++i7) {
                if (((JsonValue)periodTypeArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)periodTypeArray.get(i7)).getValueType() + " for element: periodType");
                }
                builder.periodType(this.parseCodeableConcept("periodType", periodTypeArray.getJsonObject(i7), i7));
            }
        }
        if ((periodArray = JsonSupport.getJsonArray(jsonObject, "period")) != null) {
            for (int i8 = 0; i8 < periodArray.size(); ++i8) {
                if (((JsonValue)periodArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)periodArray.get(i8)).getValueType() + " for element: period");
                }
                builder.period(this.parsePeriod("period", periodArray.getJsonObject(i8), i8));
            }
        }
        if ((usePeriodArray = JsonSupport.getJsonArray(jsonObject, "usePeriod")) != null) {
            for (int i9 = 0; i9 < usePeriodArray.size(); ++i9) {
                if (((JsonValue)usePeriodArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)usePeriodArray.get(i9)).getValueType() + " for element: usePeriod");
                }
                builder.usePeriod(this.parsePeriod("usePeriod", usePeriodArray.getJsonObject(i9), i9));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (i2 = 0; i2 < linkIdArray.size(); ++i2) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i2), JsonSupport.getJsonValue(_linkIdArray, i2), i2));
            }
        }
        if ((answerArray = JsonSupport.getJsonArray(jsonObject, "answer")) != null) {
            for (i2 = 0; i2 < answerArray.size(); ++i2) {
                if (((JsonValue)answerArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)answerArray.get(i2)).getValueType() + " for element: answer");
                }
                builder.answer(this.parseContractTermOfferAnswer("answer", answerArray.getJsonObject(i2), i2));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (i = 0; i < securityLabelNumberArray.size(); ++i) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i), JsonSupport.getJsonValue(_securityLabelNumberArray, i), i));
            }
        }
        if ((valuedItemArray = JsonSupport.getJsonArray(jsonObject, "valuedItem")) != null) {
            for (i = 0; i < valuedItemArray.size(); ++i) {
                if (((JsonValue)valuedItemArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valuedItemArray.get(i)).getValueType() + " for element: valuedItem");
                }
                builder.valuedItem(this.parseContractTermAssetValuedItem("valuedItem", valuedItemArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Asset.Context parseContractTermAssetContext(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Asset.Context.class, jsonObject);
        }
        Contract.Term.Asset.Context.Builder builder = Contract.Term.Asset.Context.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                if (((JsonValue)codeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeArray.get(i)).getValueType() + " for element: code");
                }
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Asset.ValuedItem parseContractTermAssetValuedItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray securityLabelNumberArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Asset.ValuedItem.class, jsonObject);
        }
        Contract.Term.Asset.ValuedItem.Builder builder = Contract.Term.Asset.ValuedItem.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.entity(this.parseChoiceElement("entity", jsonObject, CodeableConcept.class, Reference.class));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.effectiveTime(this.parseDateTime("effectiveTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "effectiveTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_effectiveTime"), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.points(this.parseDecimal("points", (JsonValue)JsonSupport.getJsonValue(jsonObject, "points", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_points"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        builder.payment(this.parseString("payment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "payment", JsonString.class), (JsonValue)jsonObject.get((Object)"_payment"), -1));
        builder.paymentDate(this.parseDateTime("paymentDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "paymentDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_paymentDate"), -1));
        builder.responsible(this.parseReference("responsible", JsonSupport.getJsonValue(jsonObject, "responsible", JsonObject.class), -1));
        builder.recipient(this.parseReference("recipient", JsonSupport.getJsonValue(jsonObject, "recipient", JsonObject.class), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (int i = 0; i < linkIdArray.size(); ++i) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i), JsonSupport.getJsonValue(_linkIdArray, i), i));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (int i = 0; i < securityLabelNumberArray.size(); ++i) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i), JsonSupport.getJsonValue(_securityLabelNumberArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Offer parseContractTermOffer(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray securityLabelNumberArray;
        JsonArray answerArray;
        JsonArray partyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Offer.class, jsonObject);
        }
        Contract.Term.Offer.Builder builder = Contract.Term.Offer.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((partyArray = JsonSupport.getJsonArray(jsonObject, "party")) != null) {
            for (int i = 0; i < partyArray.size(); ++i) {
                if (((JsonValue)partyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)partyArray.get(i)).getValueType() + " for element: party");
                }
                builder.party(this.parseContractTermOfferParty("party", partyArray.getJsonObject(i), i));
            }
        }
        builder.topic(this.parseReference("topic", JsonSupport.getJsonValue(jsonObject, "topic", JsonObject.class), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.decision(this.parseCodeableConcept("decision", JsonSupport.getJsonValue(jsonObject, "decision", JsonObject.class), -1));
        JsonArray decisionModeArray = JsonSupport.getJsonArray(jsonObject, "decisionMode");
        if (decisionModeArray != null) {
            for (int i = 0; i < decisionModeArray.size(); ++i) {
                if (((JsonValue)decisionModeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)decisionModeArray.get(i)).getValueType() + " for element: decisionMode");
                }
                builder.decisionMode(this.parseCodeableConcept("decisionMode", decisionModeArray.getJsonObject(i), i));
            }
        }
        if ((answerArray = JsonSupport.getJsonArray(jsonObject, "answer")) != null) {
            for (int i = 0; i < answerArray.size(); ++i) {
                if (((JsonValue)answerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)answerArray.get(i)).getValueType() + " for element: answer");
                }
                builder.answer(this.parseContractTermOfferAnswer("answer", answerArray.getJsonObject(i), i));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (int i = 0; i < linkIdArray.size(); ++i) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i), JsonSupport.getJsonValue(_linkIdArray, i), i));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (int i = 0; i < securityLabelNumberArray.size(); ++i) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i), JsonSupport.getJsonValue(_securityLabelNumberArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Offer.Answer parseContractTermOfferAnswer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Offer.Answer.class, jsonObject);
        }
        Contract.Term.Offer.Answer.Builder builder = Contract.Term.Offer.Answer.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.value(this.parseChoiceElement("value", jsonObject, Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, org.linuxforhealth.fhir.model.type.String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Offer.Party parseContractTermOfferParty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Offer.Party.class, jsonObject);
        }
        Contract.Term.Offer.Party.Builder builder = Contract.Term.Offer.Party.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray referenceArray = JsonSupport.getJsonArray(jsonObject, "reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                if (((JsonValue)referenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)referenceArray.get(i)).getValueType() + " for element: reference");
                }
                builder.reference(this.parseReference("reference", referenceArray.getJsonObject(i), i));
            }
        }
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.SecurityLabel parseContractTermSecurityLabel(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray controlArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.SecurityLabel.class, jsonObject);
        }
        Contract.Term.SecurityLabel.Builder builder = Contract.Term.SecurityLabel.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray numberArray = JsonSupport.getJsonArray(jsonObject, "number", true);
        if (numberArray != null) {
            JsonArray _numberArray = jsonObject.getJsonArray("_number");
            for (i = 0; i < numberArray.size(); ++i) {
                builder.number((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "number", (JsonValue)numberArray.get(i), JsonSupport.getJsonValue(_numberArray, i), i));
            }
        }
        builder.classification(this.parseCoding("classification", JsonSupport.getJsonValue(jsonObject, "classification", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCoding("category", categoryArray.getJsonObject(i), i));
            }
        }
        if ((controlArray = JsonSupport.getJsonArray(jsonObject, "control")) != null) {
            for (int i2 = 0; i2 < controlArray.size(); ++i2) {
                if (((JsonValue)controlArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)controlArray.get(i2)).getValueType() + " for element: control");
                }
                builder.control(this.parseCoding("control", controlArray.getJsonObject(i2), i2));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contributor parseContributor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Contributor.class, jsonObject);
        }
        Contributor.Builder builder = Contributor.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.type((ContributorType)this.parseString(ContributorType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Coverage parseCoverage(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray classArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Coverage.class, jsonObject);
        }
        Coverage.Builder builder = Coverage.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((CoverageStatus)this.parseString(CoverageStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.policyHolder(this.parseReference("policyHolder", JsonSupport.getJsonValue(jsonObject, "policyHolder", JsonObject.class), -1));
        builder.subscriber(this.parseReference("subscriber", JsonSupport.getJsonValue(jsonObject, "subscriber", JsonObject.class), -1));
        builder.subscriberId(this.parseString("subscriberId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subscriberId", JsonString.class), (JsonValue)jsonObject.get((Object)"_subscriberId"), -1));
        builder.beneficiary(this.parseReference("beneficiary", JsonSupport.getJsonValue(jsonObject, "beneficiary", JsonObject.class), -1));
        builder.dependent(this.parseString("dependent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "dependent", JsonString.class), (JsonValue)jsonObject.get((Object)"_dependent"), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray payorArray = JsonSupport.getJsonArray(jsonObject, "payor");
        if (payorArray != null) {
            for (int i = 0; i < payorArray.size(); ++i) {
                if (((JsonValue)payorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)payorArray.get(i)).getValueType() + " for element: payor");
                }
                builder.payor(this.parseReference("payor", payorArray.getJsonObject(i), i));
            }
        }
        if ((classArray = JsonSupport.getJsonArray(jsonObject, "class")) != null) {
            for (int i = 0; i < classArray.size(); ++i) {
                if (((JsonValue)classArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classArray.get(i)).getValueType() + " for element: class");
                }
                builder.clazz(this.parseCoverageClass("class", classArray.getJsonObject(i), i));
            }
        }
        builder.order((PositiveInt)this.parseInteger(PositiveInt.builder(), "order", (JsonValue)JsonSupport.getJsonValue(jsonObject, "order", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_order"), -1));
        builder.network(this.parseString("network", (JsonValue)JsonSupport.getJsonValue(jsonObject, "network", JsonString.class), (JsonValue)jsonObject.get((Object)"_network"), -1));
        JsonArray costToBeneficiaryArray = JsonSupport.getJsonArray(jsonObject, "costToBeneficiary");
        if (costToBeneficiaryArray != null) {
            for (int i = 0; i < costToBeneficiaryArray.size(); ++i) {
                if (((JsonValue)costToBeneficiaryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)costToBeneficiaryArray.get(i)).getValueType() + " for element: costToBeneficiary");
                }
                builder.costToBeneficiary(this.parseCoverageCostToBeneficiary("costToBeneficiary", costToBeneficiaryArray.getJsonObject(i), i));
            }
        }
        builder.subrogation(this.parseBoolean("subrogation", JsonSupport.getJsonValue(jsonObject, "subrogation", JsonValue.class), (JsonValue)jsonObject.get((Object)"_subrogation"), -1));
        JsonArray contractArray = JsonSupport.getJsonArray(jsonObject, "contract");
        if (contractArray != null) {
            for (int i = 0; i < contractArray.size(); ++i) {
                if (((JsonValue)contractArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contractArray.get(i)).getValueType() + " for element: contract");
                }
                builder.contract(this.parseReference("contract", contractArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Coverage.Class parseCoverageClass(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Coverage.Class.class, jsonObject);
        }
        Coverage.Class.Builder builder = Coverage.Class.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        this.stackPop();
        return builder.build();
    }

    private Coverage.CostToBeneficiary parseCoverageCostToBeneficiary(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Coverage.CostToBeneficiary.class, jsonObject);
        }
        Coverage.CostToBeneficiary.Builder builder = Coverage.CostToBeneficiary.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, SimpleQuantity.class, Money.class));
        JsonArray exceptionArray = JsonSupport.getJsonArray(jsonObject, "exception");
        if (exceptionArray != null) {
            for (int i = 0; i < exceptionArray.size(); ++i) {
                if (((JsonValue)exceptionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)exceptionArray.get(i)).getValueType() + " for element: exception");
                }
                builder.exception(this.parseCoverageCostToBeneficiaryException("exception", exceptionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Coverage.CostToBeneficiary.Exception parseCoverageCostToBeneficiaryException(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Coverage.CostToBeneficiary.Exception.class, jsonObject);
        }
        Coverage.CostToBeneficiary.Exception.Builder builder = Coverage.CostToBeneficiary.Exception.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest parseCoverageEligibilityRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray itemArray;
        JsonArray insuranceArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.class, jsonObject);
        }
        CoverageEligibilityRequest.Builder builder = CoverageEligibilityRequest.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((EligibilityRequestStatus)this.parseString(EligibilityRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        JsonArray purposeArray = JsonSupport.getJsonArray(jsonObject, "purpose", true);
        if (purposeArray != null) {
            JsonArray _purposeArray = jsonObject.getJsonArray("_purpose");
            for (i = 0; i < purposeArray.size(); ++i) {
                builder.purpose((EligibilityRequestPurpose)this.parseString(EligibilityRequestPurpose.builder(), "purpose", (JsonValue)purposeArray.get(i), JsonSupport.getJsonValue(_purposeArray, i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        JsonArray supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo");
        if (supportingInfoArray != null) {
            for (i = 0; i < supportingInfoArray.size(); ++i) {
                if (((JsonValue)supportingInfoArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInfoArray.get(i)).getValueType() + " for element: supportingInfo");
                }
                builder.supportingInfo(this.parseCoverageEligibilityRequestSupportingInfo("supportingInfo", supportingInfoArray.getJsonObject(i), i));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i3 = 0; i3 < insuranceArray.size(); ++i3) {
                if (((JsonValue)insuranceArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)insuranceArray.get(i3)).getValueType() + " for element: insurance");
                }
                builder.insurance(this.parseCoverageEligibilityRequestInsurance("insurance", insuranceArray.getJsonObject(i3), i3));
            }
        }
        if ((itemArray = JsonSupport.getJsonArray(jsonObject, "item")) != null) {
            for (int i4 = 0; i4 < itemArray.size(); ++i4) {
                if (((JsonValue)itemArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)itemArray.get(i4)).getValueType() + " for element: item");
                }
                builder.item(this.parseCoverageEligibilityRequestItem("item", itemArray.getJsonObject(i4), i4));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.Insurance parseCoverageEligibilityRequestInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.Insurance.class, jsonObject);
        }
        CoverageEligibilityRequest.Insurance.Builder builder = CoverageEligibilityRequest.Insurance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.businessArrangement(this.parseString("businessArrangement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "businessArrangement", JsonString.class), (JsonValue)jsonObject.get((Object)"_businessArrangement"), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.Item parseCoverageEligibilityRequestItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.Item.class, jsonObject);
        }
        CoverageEligibilityRequest.Item.Builder builder = CoverageEligibilityRequest.Item.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray supportingInfoSequenceArray = JsonSupport.getJsonArray(jsonObject, "supportingInfoSequence", true);
        if (supportingInfoSequenceArray != null) {
            JsonArray _supportingInfoSequenceArray = jsonObject.getJsonArray("_supportingInfoSequence");
            for (i = 0; i < supportingInfoSequenceArray.size(); ++i) {
                builder.supportingInfoSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "supportingInfoSequence", (JsonValue)supportingInfoSequenceArray.get(i), JsonSupport.getJsonValue(_supportingInfoSequenceArray, i), i));
            }
        }
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (i = 0; i < modifierArray.size(); ++i) {
                if (((JsonValue)modifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        JsonArray diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis");
        if (diagnosisArray != null) {
            for (int i2 = 0; i2 < diagnosisArray.size(); ++i2) {
                if (((JsonValue)diagnosisArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)diagnosisArray.get(i2)).getValueType() + " for element: diagnosis");
                }
                builder.diagnosis(this.parseCoverageEligibilityRequestItemDiagnosis("diagnosis", diagnosisArray.getJsonObject(i2), i2));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i3 = 0; i3 < detailArray.size(); ++i3) {
                if (((JsonValue)detailArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i3)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.Item.Diagnosis parseCoverageEligibilityRequestItemDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.Item.Diagnosis.class, jsonObject);
        }
        CoverageEligibilityRequest.Item.Diagnosis.Builder builder = CoverageEligibilityRequest.Item.Diagnosis.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.diagnosis(this.parseChoiceElement("diagnosis", jsonObject, CodeableConcept.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.SupportingInfo parseCoverageEligibilityRequestSupportingInfo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.SupportingInfo.class, jsonObject);
        }
        CoverageEligibilityRequest.SupportingInfo.Builder builder = CoverageEligibilityRequest.SupportingInfo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.information(this.parseReference("information", JsonSupport.getJsonValue(jsonObject, "information", JsonObject.class), -1));
        builder.appliesToAll(this.parseBoolean("appliesToAll", JsonSupport.getJsonValue(jsonObject, "appliesToAll", JsonValue.class), (JsonValue)jsonObject.get((Object)"_appliesToAll"), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse parseCoverageEligibilityResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.class, jsonObject);
        }
        CoverageEligibilityResponse.Builder builder = CoverageEligibilityResponse.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((EligibilityResponseStatus)this.parseString(EligibilityResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray purposeArray = JsonSupport.getJsonArray(jsonObject, "purpose", true);
        if (purposeArray != null) {
            JsonArray _purposeArray = jsonObject.getJsonArray("_purpose");
            for (i = 0; i < purposeArray.size(); ++i) {
                builder.purpose((EligibilityResponsePurpose)this.parseString(EligibilityResponsePurpose.builder(), "purpose", (JsonValue)purposeArray.get(i), JsonSupport.getJsonValue(_purposeArray, i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.requestor(this.parseReference("requestor", JsonSupport.getJsonValue(jsonObject, "requestor", JsonObject.class), -1));
        builder.request(this.parseReference("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        JsonArray insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance");
        if (insuranceArray != null) {
            for (i = 0; i < insuranceArray.size(); ++i) {
                if (((JsonValue)insuranceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)insuranceArray.get(i)).getValueType() + " for element: insurance");
                }
                builder.insurance(this.parseCoverageEligibilityResponseInsurance("insurance", insuranceArray.getJsonObject(i), i));
            }
        }
        builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)JsonSupport.getJsonValue(jsonObject, "preAuthRef", JsonString.class), (JsonValue)jsonObject.get((Object)"_preAuthRef"), -1));
        builder.form(this.parseCodeableConcept("form", JsonSupport.getJsonValue(jsonObject, "form", JsonObject.class), -1));
        JsonArray errorArray = JsonSupport.getJsonArray(jsonObject, "error");
        if (errorArray != null) {
            for (int i3 = 0; i3 < errorArray.size(); ++i3) {
                if (((JsonValue)errorArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)errorArray.get(i3)).getValueType() + " for element: error");
                }
                builder.error(this.parseCoverageEligibilityResponseError("error", errorArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Error parseCoverageEligibilityResponseError(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Error.class, jsonObject);
        }
        CoverageEligibilityResponse.Error.Builder builder = CoverageEligibilityResponse.Error.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Insurance parseCoverageEligibilityResponseInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Insurance.class, jsonObject);
        }
        CoverageEligibilityResponse.Insurance.Builder builder = CoverageEligibilityResponse.Insurance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.inforce(this.parseBoolean("inforce", JsonSupport.getJsonValue(jsonObject, "inforce", JsonValue.class), (JsonValue)jsonObject.get((Object)"_inforce"), -1));
        builder.benefitPeriod(this.parsePeriod("benefitPeriod", JsonSupport.getJsonValue(jsonObject, "benefitPeriod", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                if (((JsonValue)itemArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)itemArray.get(i)).getValueType() + " for element: item");
                }
                builder.item(this.parseCoverageEligibilityResponseInsuranceItem("item", itemArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Insurance.Item parseCoverageEligibilityResponseInsuranceItem(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Insurance.Item.class, jsonObject);
        }
        CoverageEligibilityResponse.Insurance.Item.Builder builder = CoverageEligibilityResponse.Insurance.Item.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i = 0; i < modifierArray.size(); ++i) {
                if (((JsonValue)modifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.excluded(this.parseBoolean("excluded", JsonSupport.getJsonValue(jsonObject, "excluded", JsonValue.class), (JsonValue)jsonObject.get((Object)"_excluded"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.network(this.parseCodeableConcept("network", JsonSupport.getJsonValue(jsonObject, "network", JsonObject.class), -1));
        builder.unit(this.parseCodeableConcept("unit", JsonSupport.getJsonValue(jsonObject, "unit", JsonObject.class), -1));
        builder.term(this.parseCodeableConcept("term", JsonSupport.getJsonValue(jsonObject, "term", JsonObject.class), -1));
        JsonArray benefitArray = JsonSupport.getJsonArray(jsonObject, "benefit");
        if (benefitArray != null) {
            for (int i = 0; i < benefitArray.size(); ++i) {
                if (((JsonValue)benefitArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)benefitArray.get(i)).getValueType() + " for element: benefit");
                }
                builder.benefit(this.parseCoverageEligibilityResponseInsuranceItemBenefit("benefit", benefitArray.getJsonObject(i), i));
            }
        }
        builder.authorizationRequired(this.parseBoolean("authorizationRequired", JsonSupport.getJsonValue(jsonObject, "authorizationRequired", JsonValue.class), (JsonValue)jsonObject.get((Object)"_authorizationRequired"), -1));
        JsonArray authorizationSupportingArray = JsonSupport.getJsonArray(jsonObject, "authorizationSupporting");
        if (authorizationSupportingArray != null) {
            for (int i = 0; i < authorizationSupportingArray.size(); ++i) {
                if (((JsonValue)authorizationSupportingArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorizationSupportingArray.get(i)).getValueType() + " for element: authorizationSupporting");
                }
                builder.authorizationSupporting(this.parseCodeableConcept("authorizationSupporting", authorizationSupportingArray.getJsonObject(i), i));
            }
        }
        builder.authorizationUrl(this.parseUri("authorizationUrl", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authorizationUrl", JsonString.class), (JsonValue)jsonObject.get((Object)"_authorizationUrl"), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Insurance.Item.Benefit parseCoverageEligibilityResponseInsuranceItemBenefit(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Insurance.Item.Benefit.class, jsonObject);
        }
        CoverageEligibilityResponse.Insurance.Item.Benefit.Builder builder = CoverageEligibilityResponse.Insurance.Item.Benefit.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.allowed(this.parseChoiceElement("allowed", jsonObject, UnsignedInt.class, org.linuxforhealth.fhir.model.type.String.class, Money.class));
        builder.used(this.parseChoiceElement("used", jsonObject, UnsignedInt.class, org.linuxforhealth.fhir.model.type.String.class, Money.class));
        this.stackPop();
        return builder.build();
    }

    private DataRequirement parseDataRequirement(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray dateFilterArray;
        JsonArray codeFilterArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.class, jsonObject);
        }
        DataRequirement.Builder builder = DataRequirement.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.type((FHIRAllTypes)this.parseString(FHIRAllTypes.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        JsonArray profileArray = JsonSupport.getJsonArray(jsonObject, "profile", true);
        if (profileArray != null) {
            JsonArray _profileArray = jsonObject.getJsonArray("_profile");
            for (int i2 = 0; i2 < profileArray.size(); ++i2) {
                builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)profileArray.get(i2), JsonSupport.getJsonValue(_profileArray, i2), i2));
            }
        }
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray mustSupportArray = JsonSupport.getJsonArray(jsonObject, "mustSupport", true);
        if (mustSupportArray != null) {
            JsonArray _mustSupportArray = jsonObject.getJsonArray("_mustSupport");
            for (i = 0; i < mustSupportArray.size(); ++i) {
                builder.mustSupport(this.parseString("mustSupport", (JsonValue)mustSupportArray.get(i), JsonSupport.getJsonValue(_mustSupportArray, i), i));
            }
        }
        if ((codeFilterArray = JsonSupport.getJsonArray(jsonObject, "codeFilter")) != null) {
            for (i = 0; i < codeFilterArray.size(); ++i) {
                if (((JsonValue)codeFilterArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeFilterArray.get(i)).getValueType() + " for element: codeFilter");
                }
                builder.codeFilter(this.parseDataRequirementCodeFilter("codeFilter", codeFilterArray.getJsonObject(i), i));
            }
        }
        if ((dateFilterArray = JsonSupport.getJsonArray(jsonObject, "dateFilter")) != null) {
            for (int i3 = 0; i3 < dateFilterArray.size(); ++i3) {
                if (((JsonValue)dateFilterArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)dateFilterArray.get(i3)).getValueType() + " for element: dateFilter");
                }
                builder.dateFilter(this.parseDataRequirementDateFilter("dateFilter", dateFilterArray.getJsonObject(i3), i3));
            }
        }
        builder.limit((PositiveInt)this.parseInteger(PositiveInt.builder(), "limit", (JsonValue)JsonSupport.getJsonValue(jsonObject, "limit", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_limit"), -1));
        JsonArray sortArray = JsonSupport.getJsonArray(jsonObject, "sort");
        if (sortArray != null) {
            for (int i4 = 0; i4 < sortArray.size(); ++i4) {
                if (((JsonValue)sortArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)sortArray.get(i4)).getValueType() + " for element: sort");
                }
                builder.sort(this.parseDataRequirementSort("sort", sortArray.getJsonObject(i4), i4));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DataRequirement.CodeFilter parseDataRequirementCodeFilter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.CodeFilter.class, jsonObject);
        }
        DataRequirement.CodeFilter.Builder builder = DataRequirement.CodeFilter.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.searchParam(this.parseString("searchParam", (JsonValue)JsonSupport.getJsonValue(jsonObject, "searchParam", JsonString.class), (JsonValue)jsonObject.get((Object)"_searchParam"), -1));
        builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", (JsonValue)JsonSupport.getJsonValue(jsonObject, "valueSet", JsonString.class), (JsonValue)jsonObject.get((Object)"_valueSet"), -1));
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                if (((JsonValue)codeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeArray.get(i)).getValueType() + " for element: code");
                }
                builder.code(this.parseCoding("code", codeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DataRequirement.DateFilter parseDataRequirementDateFilter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.DateFilter.class, jsonObject);
        }
        DataRequirement.DateFilter.Builder builder = DataRequirement.DateFilter.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.searchParam(this.parseString("searchParam", (JsonValue)JsonSupport.getJsonValue(jsonObject, "searchParam", JsonString.class), (JsonValue)jsonObject.get((Object)"_searchParam"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, DateTime.class, Period.class, Duration.class));
        this.stackPop();
        return builder.build();
    }

    private DataRequirement.Sort parseDataRequirementSort(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.Sort.class, jsonObject);
        }
        DataRequirement.Sort.Builder builder = DataRequirement.Sort.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.direction((SortDirection)this.parseString(SortDirection.builder(), "direction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "direction", JsonString.class), (JsonValue)jsonObject.get((Object)"_direction"), -1));
        this.stackPop();
        return builder.build();
    }

    private Date parseDate(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Date.Builder builder = Date.builder();
        builder.setValidating(this.validating);
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.ignoringUnrecognizedElements) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            JsonString jsonString = (JsonString)jsonValue;
            builder.value(jsonString.getString());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: STRING but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private DateTime parseDateTime(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        DateTime.Builder builder = DateTime.builder();
        builder.setValidating(this.validating);
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.ignoringUnrecognizedElements) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            JsonString jsonString = (JsonString)jsonValue;
            builder.value(jsonString.getString());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: STRING but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private Decimal parseDecimal(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Decimal.Builder builder = Decimal.builder();
        builder.setValidating(this.validating);
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.ignoringUnrecognizedElements) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
            JsonNumber jsonNumber = (JsonNumber)jsonValue;
            builder.value(jsonNumber.bigDecimalValue());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: NUMBER but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private DetectedIssue parseDetectedIssue(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray evidenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DetectedIssue.class, jsonObject);
        }
        DetectedIssue.Builder builder = DetectedIssue.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((DetectedIssueStatus)this.parseString(DetectedIssueStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.severity((DetectedIssueSeverity)this.parseString(DetectedIssueSeverity.builder(), "severity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "severity", JsonString.class), (JsonValue)jsonObject.get((Object)"_severity"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.identified(this.parseChoiceElement("identified", jsonObject, DateTime.class, Period.class));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        JsonArray implicatedArray = JsonSupport.getJsonArray(jsonObject, "implicated");
        if (implicatedArray != null) {
            for (int i = 0; i < implicatedArray.size(); ++i) {
                if (((JsonValue)implicatedArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)implicatedArray.get(i)).getValueType() + " for element: implicated");
                }
                builder.implicated(this.parseReference("implicated", implicatedArray.getJsonObject(i), i));
            }
        }
        if ((evidenceArray = JsonSupport.getJsonArray(jsonObject, "evidence")) != null) {
            for (int i = 0; i < evidenceArray.size(); ++i) {
                if (((JsonValue)evidenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)evidenceArray.get(i)).getValueType() + " for element: evidence");
                }
                builder.evidence(this.parseDetectedIssueEvidence("evidence", evidenceArray.getJsonObject(i), i));
            }
        }
        builder.detail(this.parseString("detail", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detail", JsonString.class), (JsonValue)jsonObject.get((Object)"_detail"), -1));
        builder.reference(this.parseUri("reference", (JsonValue)JsonSupport.getJsonValue(jsonObject, "reference", JsonString.class), (JsonValue)jsonObject.get((Object)"_reference"), -1));
        JsonArray mitigationArray = JsonSupport.getJsonArray(jsonObject, "mitigation");
        if (mitigationArray != null) {
            for (int i = 0; i < mitigationArray.size(); ++i) {
                if (((JsonValue)mitigationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)mitigationArray.get(i)).getValueType() + " for element: mitigation");
                }
                builder.mitigation(this.parseDetectedIssueMitigation("mitigation", mitigationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DetectedIssue.Evidence parseDetectedIssueEvidence(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DetectedIssue.Evidence.class, jsonObject);
        }
        DetectedIssue.Evidence.Builder builder = DetectedIssue.Evidence.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                if (((JsonValue)codeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeArray.get(i)).getValueType() + " for element: code");
                }
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                if (((JsonValue)detailArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DetectedIssue.Mitigation parseDetectedIssueMitigation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DetectedIssue.Mitigation.class, jsonObject);
        }
        DetectedIssue.Mitigation.Builder builder = DetectedIssue.Mitigation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.action(this.parseCodeableConcept("action", JsonSupport.getJsonValue(jsonObject, "action", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Device parseDevice(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray safetyArray;
        JsonArray propertyArray;
        JsonArray versionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Device.class, jsonObject);
        }
        Device.Builder builder = Device.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.definition(this.parseReference("definition", JsonSupport.getJsonValue(jsonObject, "definition", JsonObject.class), -1));
        JsonArray udiCarrierArray = JsonSupport.getJsonArray(jsonObject, "udiCarrier");
        if (udiCarrierArray != null) {
            for (int i = 0; i < udiCarrierArray.size(); ++i) {
                if (((JsonValue)udiCarrierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiCarrierArray.get(i)).getValueType() + " for element: udiCarrier");
                }
                builder.udiCarrier(this.parseDeviceUdiCarrier("udiCarrier", udiCarrierArray.getJsonObject(i), i));
            }
        }
        builder.status((FHIRDeviceStatus)this.parseString(FHIRDeviceStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusReasonArray = JsonSupport.getJsonArray(jsonObject, "statusReason");
        if (statusReasonArray != null) {
            for (int i = 0; i < statusReasonArray.size(); ++i) {
                if (((JsonValue)statusReasonArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)statusReasonArray.get(i)).getValueType() + " for element: statusReason");
                }
                builder.statusReason(this.parseCodeableConcept("statusReason", statusReasonArray.getJsonObject(i), i));
            }
        }
        builder.distinctIdentifier(this.parseString("distinctIdentifier", (JsonValue)JsonSupport.getJsonValue(jsonObject, "distinctIdentifier", JsonString.class), (JsonValue)jsonObject.get((Object)"_distinctIdentifier"), -1));
        builder.manufacturer(this.parseString("manufacturer", (JsonValue)JsonSupport.getJsonValue(jsonObject, "manufacturer", JsonString.class), (JsonValue)jsonObject.get((Object)"_manufacturer"), -1));
        builder.manufactureDate(this.parseDateTime("manufactureDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "manufactureDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_manufactureDate"), -1));
        builder.expirationDate(this.parseDateTime("expirationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expirationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_expirationDate"), -1));
        builder.lotNumber(this.parseString("lotNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lotNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_lotNumber"), -1));
        builder.serialNumber(this.parseString("serialNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "serialNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_serialNumber"), -1));
        JsonArray deviceNameArray = JsonSupport.getJsonArray(jsonObject, "deviceName");
        if (deviceNameArray != null) {
            for (int i = 0; i < deviceNameArray.size(); ++i) {
                if (((JsonValue)deviceNameArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)deviceNameArray.get(i)).getValueType() + " for element: deviceName");
                }
                builder.deviceName(this.parseDeviceDeviceName("deviceName", deviceNameArray.getJsonObject(i), i));
            }
        }
        builder.modelNumber(this.parseString("modelNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "modelNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_modelNumber"), -1));
        builder.partNumber(this.parseString("partNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "partNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_partNumber"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray specializationArray = JsonSupport.getJsonArray(jsonObject, "specialization");
        if (specializationArray != null) {
            for (int i = 0; i < specializationArray.size(); ++i) {
                if (((JsonValue)specializationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)specializationArray.get(i)).getValueType() + " for element: specialization");
                }
                builder.specialization(this.parseDeviceSpecialization("specialization", specializationArray.getJsonObject(i), i));
            }
        }
        if ((versionArray = JsonSupport.getJsonArray(jsonObject, "version")) != null) {
            for (int i = 0; i < versionArray.size(); ++i) {
                if (((JsonValue)versionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)versionArray.get(i)).getValueType() + " for element: version");
                }
                builder.version(this.parseDeviceVersion("version", versionArray.getJsonObject(i), i));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i = 0; i < propertyArray.size(); ++i) {
                if (((JsonValue)propertyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)propertyArray.get(i)).getValueType() + " for element: property");
                }
                builder.property(this.parseDeviceProperty("property", propertyArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.owner(this.parseReference("owner", JsonSupport.getJsonValue(jsonObject, "owner", JsonObject.class), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactPoint("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((safetyArray = JsonSupport.getJsonArray(jsonObject, "safety")) != null) {
            for (int i = 0; i < safetyArray.size(); ++i) {
                if (((JsonValue)safetyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)safetyArray.get(i)).getValueType() + " for element: safety");
                }
                builder.safety(this.parseCodeableConcept("safety", safetyArray.getJsonObject(i), i));
            }
        }
        builder.parent(this.parseReference("parent", JsonSupport.getJsonValue(jsonObject, "parent", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.DeviceName parseDeviceDeviceName(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Device.DeviceName.class, jsonObject);
        }
        Device.DeviceName.Builder builder = Device.DeviceName.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.type((DeviceNameType)this.parseString(DeviceNameType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.Property parseDeviceProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray valueCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Device.Property.class, jsonObject);
        }
        Device.Property.Builder builder = Device.Property.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray valueQuantityArray = JsonSupport.getJsonArray(jsonObject, "valueQuantity");
        if (valueQuantityArray != null) {
            for (int i = 0; i < valueQuantityArray.size(); ++i) {
                if (((JsonValue)valueQuantityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valueQuantityArray.get(i)).getValueType() + " for element: valueQuantity");
                }
                builder.valueQuantity(this.parseQuantity("valueQuantity", valueQuantityArray.getJsonObject(i), i));
            }
        }
        if ((valueCodeArray = JsonSupport.getJsonArray(jsonObject, "valueCode")) != null) {
            for (int i = 0; i < valueCodeArray.size(); ++i) {
                if (((JsonValue)valueCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valueCodeArray.get(i)).getValueType() + " for element: valueCode");
                }
                builder.valueCode(this.parseCodeableConcept("valueCode", valueCodeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Device.Specialization parseDeviceSpecialization(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Device.Specialization.class, jsonObject);
        }
        Device.Specialization.Builder builder = Device.Specialization.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.systemType(this.parseCodeableConcept("systemType", JsonSupport.getJsonValue(jsonObject, "systemType", JsonObject.class), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.UdiCarrier parseDeviceUdiCarrier(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Device.UdiCarrier.class, jsonObject);
        }
        Device.UdiCarrier.Builder builder = Device.UdiCarrier.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.deviceIdentifier(this.parseString("deviceIdentifier", (JsonValue)JsonSupport.getJsonValue(jsonObject, "deviceIdentifier", JsonString.class), (JsonValue)jsonObject.get((Object)"_deviceIdentifier"), -1));
        builder.issuer(this.parseUri("issuer", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issuer", JsonString.class), (JsonValue)jsonObject.get((Object)"_issuer"), -1));
        builder.jurisdiction(this.parseUri("jurisdiction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "jurisdiction", JsonString.class), (JsonValue)jsonObject.get((Object)"_jurisdiction"), -1));
        builder.carrierAIDC(this.parseBase64Binary("carrierAIDC", (JsonValue)JsonSupport.getJsonValue(jsonObject, "carrierAIDC", JsonString.class), (JsonValue)jsonObject.get((Object)"_carrierAIDC"), -1));
        builder.carrierHRF(this.parseString("carrierHRF", (JsonValue)JsonSupport.getJsonValue(jsonObject, "carrierHRF", JsonString.class), (JsonValue)jsonObject.get((Object)"_carrierHRF"), -1));
        builder.entryType((UDIEntryType)this.parseString(UDIEntryType.builder(), "entryType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "entryType", JsonString.class), (JsonValue)jsonObject.get((Object)"_entryType"), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.Version parseDeviceVersion(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Device.Version.class, jsonObject);
        }
        Device.Version.Builder builder = Device.Version.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.component(this.parseIdentifier("component", JsonSupport.getJsonValue(jsonObject, "component", JsonObject.class), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition parseDeviceDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray propertyArray;
        JsonArray capabilityArray;
        JsonArray shelfLifeStorageArray;
        JsonArray safetyArray;
        int i;
        JsonArray versionArray;
        JsonArray udiDeviceIdentifierArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.class, jsonObject);
        }
        DeviceDefinition.Builder builder = DeviceDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((udiDeviceIdentifierArray = JsonSupport.getJsonArray(jsonObject, "udiDeviceIdentifier")) != null) {
            for (int i3 = 0; i3 < udiDeviceIdentifierArray.size(); ++i3) {
                if (((JsonValue)udiDeviceIdentifierArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiDeviceIdentifierArray.get(i3)).getValueType() + " for element: udiDeviceIdentifier");
                }
                builder.udiDeviceIdentifier(this.parseDeviceDefinitionUdiDeviceIdentifier("udiDeviceIdentifier", udiDeviceIdentifierArray.getJsonObject(i3), i3));
            }
        }
        builder.manufacturer(this.parseChoiceElement("manufacturer", jsonObject, org.linuxforhealth.fhir.model.type.String.class, Reference.class));
        JsonArray deviceNameArray = JsonSupport.getJsonArray(jsonObject, "deviceName");
        if (deviceNameArray != null) {
            for (int i4 = 0; i4 < deviceNameArray.size(); ++i4) {
                if (((JsonValue)deviceNameArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)deviceNameArray.get(i4)).getValueType() + " for element: deviceName");
                }
                builder.deviceName(this.parseDeviceDefinitionDeviceName("deviceName", deviceNameArray.getJsonObject(i4), i4));
            }
        }
        builder.modelNumber(this.parseString("modelNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "modelNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_modelNumber"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray specializationArray = JsonSupport.getJsonArray(jsonObject, "specialization");
        if (specializationArray != null) {
            for (int i5 = 0; i5 < specializationArray.size(); ++i5) {
                if (((JsonValue)specializationArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)specializationArray.get(i5)).getValueType() + " for element: specialization");
                }
                builder.specialization(this.parseDeviceDefinitionSpecialization("specialization", specializationArray.getJsonObject(i5), i5));
            }
        }
        if ((versionArray = JsonSupport.getJsonArray(jsonObject, "version", true)) != null) {
            JsonArray _versionArray = jsonObject.getJsonArray("_version");
            for (i = 0; i < versionArray.size(); ++i) {
                builder.version(this.parseString("version", (JsonValue)versionArray.get(i), JsonSupport.getJsonValue(_versionArray, i), i));
            }
        }
        if ((safetyArray = JsonSupport.getJsonArray(jsonObject, "safety")) != null) {
            for (i = 0; i < safetyArray.size(); ++i) {
                if (((JsonValue)safetyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)safetyArray.get(i)).getValueType() + " for element: safety");
                }
                builder.safety(this.parseCodeableConcept("safety", safetyArray.getJsonObject(i), i));
            }
        }
        if ((shelfLifeStorageArray = JsonSupport.getJsonArray(jsonObject, "shelfLifeStorage")) != null) {
            for (int i6 = 0; i6 < shelfLifeStorageArray.size(); ++i6) {
                if (((JsonValue)shelfLifeStorageArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)shelfLifeStorageArray.get(i6)).getValueType() + " for element: shelfLifeStorage");
                }
                builder.shelfLifeStorage(this.parseProductShelfLife("shelfLifeStorage", shelfLifeStorageArray.getJsonObject(i6), i6));
            }
        }
        builder.physicalCharacteristics(this.parseProdCharacteristic("physicalCharacteristics", JsonSupport.getJsonValue(jsonObject, "physicalCharacteristics", JsonObject.class), -1));
        JsonArray languageCodeArray = JsonSupport.getJsonArray(jsonObject, "languageCode");
        if (languageCodeArray != null) {
            for (int i7 = 0; i7 < languageCodeArray.size(); ++i7) {
                if (((JsonValue)languageCodeArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)languageCodeArray.get(i7)).getValueType() + " for element: languageCode");
                }
                builder.languageCode(this.parseCodeableConcept("languageCode", languageCodeArray.getJsonObject(i7), i7));
            }
        }
        if ((capabilityArray = JsonSupport.getJsonArray(jsonObject, "capability")) != null) {
            for (int i8 = 0; i8 < capabilityArray.size(); ++i8) {
                if (((JsonValue)capabilityArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)capabilityArray.get(i8)).getValueType() + " for element: capability");
                }
                builder.capability(this.parseDeviceDefinitionCapability("capability", capabilityArray.getJsonObject(i8), i8));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i9 = 0; i9 < propertyArray.size(); ++i9) {
                if (((JsonValue)propertyArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)propertyArray.get(i9)).getValueType() + " for element: property");
                }
                builder.property(this.parseDeviceDefinitionProperty("property", propertyArray.getJsonObject(i9), i9));
            }
        }
        builder.owner(this.parseReference("owner", JsonSupport.getJsonValue(jsonObject, "owner", JsonObject.class), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i10 = 0; i10 < contactArray.size(); ++i10) {
                if (((JsonValue)contactArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i10)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactPoint("contact", contactArray.getJsonObject(i10), i10));
            }
        }
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.onlineInformation(this.parseUri("onlineInformation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "onlineInformation", JsonString.class), (JsonValue)jsonObject.get((Object)"_onlineInformation"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i11 = 0; i11 < noteArray.size(); ++i11) {
                if (((JsonValue)noteArray.get(i11)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i11)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i11), i11));
            }
        }
        builder.quantity(this.parseQuantity("quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.parentDevice(this.parseReference("parentDevice", JsonSupport.getJsonValue(jsonObject, "parentDevice", JsonObject.class), -1));
        JsonArray materialArray = JsonSupport.getJsonArray(jsonObject, "material");
        if (materialArray != null) {
            for (int i12 = 0; i12 < materialArray.size(); ++i12) {
                if (((JsonValue)materialArray.get(i12)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)materialArray.get(i12)).getValueType() + " for element: material");
                }
                builder.material(this.parseDeviceDefinitionMaterial("material", materialArray.getJsonObject(i12), i12));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Capability parseDeviceDefinitionCapability(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Capability.class, jsonObject);
        }
        DeviceDefinition.Capability.Builder builder = DeviceDefinition.Capability.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray descriptionArray = JsonSupport.getJsonArray(jsonObject, "description");
        if (descriptionArray != null) {
            for (int i = 0; i < descriptionArray.size(); ++i) {
                if (((JsonValue)descriptionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)descriptionArray.get(i)).getValueType() + " for element: description");
                }
                builder.description(this.parseCodeableConcept("description", descriptionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.DeviceName parseDeviceDefinitionDeviceName(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.DeviceName.class, jsonObject);
        }
        DeviceDefinition.DeviceName.Builder builder = DeviceDefinition.DeviceName.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.type((DeviceNameType)this.parseString(DeviceNameType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Material parseDeviceDefinitionMaterial(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Material.class, jsonObject);
        }
        DeviceDefinition.Material.Builder builder = DeviceDefinition.Material.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.substance(this.parseCodeableConcept("substance", JsonSupport.getJsonValue(jsonObject, "substance", JsonObject.class), -1));
        builder.alternate(this.parseBoolean("alternate", JsonSupport.getJsonValue(jsonObject, "alternate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_alternate"), -1));
        builder.allergenicIndicator(this.parseBoolean("allergenicIndicator", JsonSupport.getJsonValue(jsonObject, "allergenicIndicator", JsonValue.class), (JsonValue)jsonObject.get((Object)"_allergenicIndicator"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Property parseDeviceDefinitionProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray valueCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Property.class, jsonObject);
        }
        DeviceDefinition.Property.Builder builder = DeviceDefinition.Property.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray valueQuantityArray = JsonSupport.getJsonArray(jsonObject, "valueQuantity");
        if (valueQuantityArray != null) {
            for (int i = 0; i < valueQuantityArray.size(); ++i) {
                if (((JsonValue)valueQuantityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valueQuantityArray.get(i)).getValueType() + " for element: valueQuantity");
                }
                builder.valueQuantity(this.parseQuantity("valueQuantity", valueQuantityArray.getJsonObject(i), i));
            }
        }
        if ((valueCodeArray = JsonSupport.getJsonArray(jsonObject, "valueCode")) != null) {
            for (int i = 0; i < valueCodeArray.size(); ++i) {
                if (((JsonValue)valueCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valueCodeArray.get(i)).getValueType() + " for element: valueCode");
                }
                builder.valueCode(this.parseCodeableConcept("valueCode", valueCodeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Specialization parseDeviceDefinitionSpecialization(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Specialization.class, jsonObject);
        }
        DeviceDefinition.Specialization.Builder builder = DeviceDefinition.Specialization.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.systemType(this.parseString("systemType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "systemType", JsonString.class), (JsonValue)jsonObject.get((Object)"_systemType"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.UdiDeviceIdentifier parseDeviceDefinitionUdiDeviceIdentifier(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.UdiDeviceIdentifier.class, jsonObject);
        }
        DeviceDefinition.UdiDeviceIdentifier.Builder builder = DeviceDefinition.UdiDeviceIdentifier.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.deviceIdentifier(this.parseString("deviceIdentifier", (JsonValue)JsonSupport.getJsonValue(jsonObject, "deviceIdentifier", JsonString.class), (JsonValue)jsonObject.get((Object)"_deviceIdentifier"), -1));
        builder.issuer(this.parseUri("issuer", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issuer", JsonString.class), (JsonValue)jsonObject.get((Object)"_issuer"), -1));
        builder.jurisdiction(this.parseUri("jurisdiction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "jurisdiction", JsonString.class), (JsonValue)jsonObject.get((Object)"_jurisdiction"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceMetric parseDeviceMetric(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceMetric.class, jsonObject);
        }
        DeviceMetric.Builder builder = DeviceMetric.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.unit(this.parseCodeableConcept("unit", JsonSupport.getJsonValue(jsonObject, "unit", JsonObject.class), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.parent(this.parseReference("parent", JsonSupport.getJsonValue(jsonObject, "parent", JsonObject.class), -1));
        builder.operationalStatus((DeviceMetricOperationalStatus)this.parseString(DeviceMetricOperationalStatus.builder(), "operationalStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "operationalStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_operationalStatus"), -1));
        builder.color((DeviceMetricColor)this.parseString(DeviceMetricColor.builder(), "color", (JsonValue)JsonSupport.getJsonValue(jsonObject, "color", JsonString.class), (JsonValue)jsonObject.get((Object)"_color"), -1));
        builder.category((DeviceMetricCategory)this.parseString(DeviceMetricCategory.builder(), "category", (JsonValue)JsonSupport.getJsonValue(jsonObject, "category", JsonString.class), (JsonValue)jsonObject.get((Object)"_category"), -1));
        builder.measurementPeriod(this.parseTiming("measurementPeriod", JsonSupport.getJsonValue(jsonObject, "measurementPeriod", JsonObject.class), -1));
        JsonArray calibrationArray = JsonSupport.getJsonArray(jsonObject, "calibration");
        if (calibrationArray != null) {
            for (int i = 0; i < calibrationArray.size(); ++i) {
                if (((JsonValue)calibrationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)calibrationArray.get(i)).getValueType() + " for element: calibration");
                }
                builder.calibration(this.parseDeviceMetricCalibration("calibration", calibrationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceMetric.Calibration parseDeviceMetricCalibration(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceMetric.Calibration.class, jsonObject);
        }
        DeviceMetric.Calibration.Builder builder = DeviceMetric.Calibration.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type((DeviceMetricCalibrationType)this.parseString(DeviceMetricCalibrationType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.state((DeviceMetricCalibrationState)this.parseString(DeviceMetricCalibrationState.builder(), "state", (JsonValue)JsonSupport.getJsonValue(jsonObject, "state", JsonString.class), (JsonValue)jsonObject.get((Object)"_state"), -1));
        builder.time(this.parseInstant("time", (JsonValue)JsonSupport.getJsonValue(jsonObject, "time", JsonString.class), (JsonValue)jsonObject.get((Object)"_time"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceRequest parseDeviceRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relevantHistoryArray;
        JsonArray noteArray;
        JsonArray supportingInfoArray;
        JsonArray insuranceArray;
        JsonArray reasonReferenceArray;
        JsonArray priorRequestArray;
        JsonArray basedOnArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceRequest.class, jsonObject);
        }
        DeviceRequest.Builder builder = DeviceRequest.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((priorRequestArray = JsonSupport.getJsonArray(jsonObject, "priorRequest")) != null) {
            for (int i4 = 0; i4 < priorRequestArray.size(); ++i4) {
                if (((JsonValue)priorRequestArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)priorRequestArray.get(i4)).getValueType() + " for element: priorRequest");
                }
                builder.priorRequest(this.parseReference("priorRequest", priorRequestArray.getJsonObject(i4), i4));
            }
        }
        builder.groupIdentifier(this.parseIdentifier("groupIdentifier", JsonSupport.getJsonValue(jsonObject, "groupIdentifier", JsonObject.class), -1));
        builder.status((DeviceRequestStatus)this.parseString(DeviceRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.intent((RequestIntent)this.parseString(RequestIntent.builder(), "intent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "intent", JsonString.class), (JsonValue)jsonObject.get((Object)"_intent"), -1));
        builder.priority((RequestPriority)this.parseString(RequestPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.code(this.parseChoiceElement("code", jsonObject, Reference.class, CodeableConcept.class));
        JsonArray parameterArray = JsonSupport.getJsonArray(jsonObject, "parameter");
        if (parameterArray != null) {
            for (int i5 = 0; i5 < parameterArray.size(); ++i5) {
                if (((JsonValue)parameterArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)parameterArray.get(i5)).getValueType() + " for element: parameter");
                }
                builder.parameter(this.parseDeviceRequestParameter("parameter", parameterArray.getJsonObject(i5), i5));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class, Timing.class));
        builder.authoredOn(this.parseDateTime("authoredOn", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authoredOn", JsonString.class), (JsonValue)jsonObject.get((Object)"_authoredOn"), -1));
        builder.requester(this.parseReference("requester", JsonSupport.getJsonValue(jsonObject, "requester", JsonObject.class), -1));
        builder.performerType(this.parseCodeableConcept("performerType", JsonSupport.getJsonValue(jsonObject, "performerType", JsonObject.class), -1));
        builder.performer(this.parseReference("performer", JsonSupport.getJsonValue(jsonObject, "performer", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i6 = 0; i6 < reasonCodeArray.size(); ++i6) {
                if (((JsonValue)reasonCodeArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i6)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i6), i6));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i7 = 0; i7 < reasonReferenceArray.size(); ++i7) {
                if (((JsonValue)reasonReferenceArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i7)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i7), i7));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i8 = 0; i8 < insuranceArray.size(); ++i8) {
                if (((JsonValue)insuranceArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)insuranceArray.get(i8)).getValueType() + " for element: insurance");
                }
                builder.insurance(this.parseReference("insurance", insuranceArray.getJsonObject(i8), i8));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i9 = 0; i9 < supportingInfoArray.size(); ++i9) {
                if (((JsonValue)supportingInfoArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInfoArray.get(i9)).getValueType() + " for element: supportingInfo");
                }
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i9), i9));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i10 = 0; i10 < noteArray.size(); ++i10) {
                if (((JsonValue)noteArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i10)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i10), i10));
            }
        }
        if ((relevantHistoryArray = JsonSupport.getJsonArray(jsonObject, "relevantHistory")) != null) {
            for (int i11 = 0; i11 < relevantHistoryArray.size(); ++i11) {
                if (((JsonValue)relevantHistoryArray.get(i11)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relevantHistoryArray.get(i11)).getValueType() + " for element: relevantHistory");
                }
                builder.relevantHistory(this.parseReference("relevantHistory", relevantHistoryArray.getJsonObject(i11), i11));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceRequest.Parameter parseDeviceRequestParameter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceRequest.Parameter.class, jsonObject);
        }
        DeviceRequest.Parameter.Builder builder = DeviceRequest.Parameter.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, CodeableConcept.class, Quantity.class, Range.class, Boolean.class));
        this.stackPop();
        return builder.build();
    }

    private DeviceUseStatement parseDeviceUseStatement(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray reasonReferenceArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DeviceUseStatement.class, jsonObject);
        }
        DeviceUseStatement.Builder builder = DeviceUseStatement.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        builder.status((DeviceUseStatementStatus)this.parseString(DeviceUseStatementStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        JsonArray derivedFromArray = JsonSupport.getJsonArray(jsonObject, "derivedFrom");
        if (derivedFromArray != null) {
            for (int i = 0; i < derivedFromArray.size(); ++i) {
                if (((JsonValue)derivedFromArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)derivedFromArray.get(i)).getValueType() + " for element: derivedFrom");
                }
                builder.derivedFrom(this.parseReference("derivedFrom", derivedFromArray.getJsonObject(i), i));
            }
        }
        builder.timing(this.parseChoiceElement("timing", jsonObject, Timing.class, Period.class, DateTime.class));
        builder.recordedOn(this.parseDateTime("recordedOn", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedOn", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedOn"), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.device(this.parseReference("device", JsonSupport.getJsonValue(jsonObject, "device", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                if (((JsonValue)reasonCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                if (((JsonValue)reasonReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DiagnosticReport parseDiagnosticReport(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray presentedFormArray;
        JsonArray mediaArray;
        JsonArray imagingStudyArray;
        JsonArray resultArray;
        JsonArray specimenArray;
        JsonArray resultsInterpreterArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DiagnosticReport.class, jsonObject);
        }
        DiagnosticReport.Builder builder = DiagnosticReport.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        builder.status((DiagnosticReportStatus)this.parseString(DiagnosticReportStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.effective(this.parseChoiceElement("effective", jsonObject, DateTime.class, Period.class));
        builder.issued(this.parseInstant("issued", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issued", JsonString.class), (JsonValue)jsonObject.get((Object)"_issued"), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i = 0; i < performerArray.size(); ++i) {
                if (((JsonValue)performerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)performerArray.get(i)).getValueType() + " for element: performer");
                }
                builder.performer(this.parseReference("performer", performerArray.getJsonObject(i), i));
            }
        }
        if ((resultsInterpreterArray = JsonSupport.getJsonArray(jsonObject, "resultsInterpreter")) != null) {
            for (int i = 0; i < resultsInterpreterArray.size(); ++i) {
                if (((JsonValue)resultsInterpreterArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)resultsInterpreterArray.get(i)).getValueType() + " for element: resultsInterpreter");
                }
                builder.resultsInterpreter(this.parseReference("resultsInterpreter", resultsInterpreterArray.getJsonObject(i), i));
            }
        }
        if ((specimenArray = JsonSupport.getJsonArray(jsonObject, "specimen")) != null) {
            for (int i = 0; i < specimenArray.size(); ++i) {
                if (((JsonValue)specimenArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)specimenArray.get(i)).getValueType() + " for element: specimen");
                }
                builder.specimen(this.parseReference("specimen", specimenArray.getJsonObject(i), i));
            }
        }
        if ((resultArray = JsonSupport.getJsonArray(jsonObject, "result")) != null) {
            for (int i = 0; i < resultArray.size(); ++i) {
                if (((JsonValue)resultArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)resultArray.get(i)).getValueType() + " for element: result");
                }
                builder.result(this.parseReference("result", resultArray.getJsonObject(i), i));
            }
        }
        if ((imagingStudyArray = JsonSupport.getJsonArray(jsonObject, "imagingStudy")) != null) {
            for (int i = 0; i < imagingStudyArray.size(); ++i) {
                if (((JsonValue)imagingStudyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)imagingStudyArray.get(i)).getValueType() + " for element: imagingStudy");
                }
                builder.imagingStudy(this.parseReference("imagingStudy", imagingStudyArray.getJsonObject(i), i));
            }
        }
        if ((mediaArray = JsonSupport.getJsonArray(jsonObject, "media")) != null) {
            for (int i = 0; i < mediaArray.size(); ++i) {
                if (((JsonValue)mediaArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)mediaArray.get(i)).getValueType() + " for element: media");
                }
                builder.media(this.parseDiagnosticReportMedia("media", mediaArray.getJsonObject(i), i));
            }
        }
        builder.conclusion(this.parseString("conclusion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "conclusion", JsonString.class), (JsonValue)jsonObject.get((Object)"_conclusion"), -1));
        JsonArray conclusionCodeArray = JsonSupport.getJsonArray(jsonObject, "conclusionCode");
        if (conclusionCodeArray != null) {
            for (int i = 0; i < conclusionCodeArray.size(); ++i) {
                if (((JsonValue)conclusionCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)conclusionCodeArray.get(i)).getValueType() + " for element: conclusionCode");
                }
                builder.conclusionCode(this.parseCodeableConcept("conclusionCode", conclusionCodeArray.getJsonObject(i), i));
            }
        }
        if ((presentedFormArray = JsonSupport.getJsonArray(jsonObject, "presentedForm")) != null) {
            for (int i = 0; i < presentedFormArray.size(); ++i) {
                if (((JsonValue)presentedFormArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)presentedFormArray.get(i)).getValueType() + " for element: presentedForm");
                }
                builder.presentedForm(this.parseAttachment("presentedForm", presentedFormArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DiagnosticReport.Media parseDiagnosticReportMedia(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DiagnosticReport.Media.class, jsonObject);
        }
        DiagnosticReport.Media.Builder builder = DiagnosticReport.Media.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        builder.link(this.parseReference("link", JsonSupport.getJsonValue(jsonObject, "link", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentManifest parseDocumentManifest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relatedArray;
        JsonArray recipientArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DocumentManifest.class, jsonObject);
        }
        DocumentManifest.Builder builder = DocumentManifest.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.masterIdentifier(this.parseIdentifier("masterIdentifier", JsonSupport.getJsonValue(jsonObject, "masterIdentifier", JsonObject.class), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((DocumentReferenceStatus)this.parseString(DocumentReferenceStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((recipientArray = JsonSupport.getJsonArray(jsonObject, "recipient")) != null) {
            for (int i = 0; i < recipientArray.size(); ++i) {
                if (((JsonValue)recipientArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)recipientArray.get(i)).getValueType() + " for element: recipient");
                }
                builder.recipient(this.parseReference("recipient", recipientArray.getJsonObject(i), i));
            }
        }
        builder.source(this.parseUri("source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray contentArray = JsonSupport.getJsonArray(jsonObject, "content");
        if (contentArray != null) {
            for (int i = 0; i < contentArray.size(); ++i) {
                if (((JsonValue)contentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contentArray.get(i)).getValueType() + " for element: content");
                }
                builder.content(this.parseReference("content", contentArray.getJsonObject(i), i));
            }
        }
        if ((relatedArray = JsonSupport.getJsonArray(jsonObject, "related")) != null) {
            for (int i = 0; i < relatedArray.size(); ++i) {
                if (((JsonValue)relatedArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArray.get(i)).getValueType() + " for element: related");
                }
                builder.related(this.parseDocumentManifestRelated("related", relatedArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DocumentManifest.Related parseDocumentManifestRelated(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DocumentManifest.Related.class, jsonObject);
        }
        DocumentManifest.Related.Builder builder = DocumentManifest.Related.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.ref(this.parseReference("ref", JsonSupport.getJsonValue(jsonObject, "ref", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentReference parseDocumentReference(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray contentArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.class, jsonObject);
        }
        DocumentReference.Builder builder = DocumentReference.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.masterIdentifier(this.parseIdentifier("masterIdentifier", JsonSupport.getJsonValue(jsonObject, "masterIdentifier", JsonObject.class), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((DocumentReferenceStatus)this.parseString(DocumentReferenceStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.docStatus((ReferredDocumentStatus)this.parseString(ReferredDocumentStatus.builder(), "docStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "docStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_docStatus"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.date(this.parseInstant("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        builder.authenticator(this.parseReference("authenticator", JsonSupport.getJsonValue(jsonObject, "authenticator", JsonObject.class), -1));
        builder.custodian(this.parseReference("custodian", JsonSupport.getJsonValue(jsonObject, "custodian", JsonObject.class), -1));
        JsonArray relatesToArray = JsonSupport.getJsonArray(jsonObject, "relatesTo");
        if (relatesToArray != null) {
            for (int i = 0; i < relatesToArray.size(); ++i) {
                if (((JsonValue)relatesToArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatesToArray.get(i)).getValueType() + " for element: relatesTo");
                }
                builder.relatesTo(this.parseDocumentReferenceRelatesTo("relatesTo", relatesToArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel");
        if (securityLabelArray != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                if (((JsonValue)securityLabelArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)securityLabelArray.get(i)).getValueType() + " for element: securityLabel");
                }
                builder.securityLabel(this.parseCodeableConcept("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        if ((contentArray = JsonSupport.getJsonArray(jsonObject, "content")) != null) {
            for (int i = 0; i < contentArray.size(); ++i) {
                if (((JsonValue)contentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contentArray.get(i)).getValueType() + " for element: content");
                }
                builder.content(this.parseDocumentReferenceContent("content", contentArray.getJsonObject(i), i));
            }
        }
        builder.context(this.parseDocumentReferenceContext("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentReference.Content parseDocumentReferenceContent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.Content.class, jsonObject);
        }
        DocumentReference.Content.Builder builder = DocumentReference.Content.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.attachment(this.parseAttachment("attachment", JsonSupport.getJsonValue(jsonObject, "attachment", JsonObject.class), -1));
        builder.format(this.parseCoding("format", JsonSupport.getJsonValue(jsonObject, "format", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentReference.Context parseDocumentReferenceContext(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray eventArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.Context.class, jsonObject);
        }
        DocumentReference.Context.Builder builder = DocumentReference.Context.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray encounterArray = JsonSupport.getJsonArray(jsonObject, "encounter");
        if (encounterArray != null) {
            for (int i = 0; i < encounterArray.size(); ++i) {
                if (((JsonValue)encounterArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)encounterArray.get(i)).getValueType() + " for element: encounter");
                }
                builder.encounter(this.parseReference("encounter", encounterArray.getJsonObject(i), i));
            }
        }
        if ((eventArray = JsonSupport.getJsonArray(jsonObject, "event")) != null) {
            for (int i = 0; i < eventArray.size(); ++i) {
                if (((JsonValue)eventArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)eventArray.get(i)).getValueType() + " for element: event");
                }
                builder.event(this.parseCodeableConcept("event", eventArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.facilityType(this.parseCodeableConcept("facilityType", JsonSupport.getJsonValue(jsonObject, "facilityType", JsonObject.class), -1));
        builder.practiceSetting(this.parseCodeableConcept("practiceSetting", JsonSupport.getJsonValue(jsonObject, "practiceSetting", JsonObject.class), -1));
        builder.sourcePatientInfo(this.parseReference("sourcePatientInfo", JsonSupport.getJsonValue(jsonObject, "sourcePatientInfo", JsonObject.class), -1));
        JsonArray relatedArray = JsonSupport.getJsonArray(jsonObject, "related");
        if (relatedArray != null) {
            for (int i = 0; i < relatedArray.size(); ++i) {
                if (((JsonValue)relatedArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArray.get(i)).getValueType() + " for element: related");
                }
                builder.related(this.parseReference("related", relatedArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DocumentReference.RelatesTo parseDocumentReferenceRelatesTo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.RelatesTo.class, jsonObject);
        }
        DocumentReference.RelatesTo.Builder builder = DocumentReference.RelatesTo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((DocumentRelationshipType)this.parseString(DocumentRelationshipType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.target(this.parseReference("target", JsonSupport.getJsonValue(jsonObject, "target", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private void parseDomainResource(DomainResource.Builder builder, JsonObject jsonObject) {
        JsonArray modifierExtensionArray;
        JsonArray extensionArray;
        builder.setValidating(this.validating);
        this.parseResource(builder, jsonObject);
        builder.text(this.parseNarrative("text", JsonSupport.getJsonValue(jsonObject, "text", JsonObject.class), -1));
        JsonArray containedArray = JsonSupport.getJsonArray(jsonObject, "contained");
        if (containedArray != null) {
            for (int i = 0; i < containedArray.size(); ++i) {
                if (((JsonValue)containedArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)containedArray.get(i)).getValueType() + " for element: contained");
                }
                builder.contained(this.parseResource("contained", containedArray.getJsonObject(i), i));
            }
        }
        if ((extensionArray = JsonSupport.getJsonArray(jsonObject, "extension")) != null) {
            for (int i = 0; i < extensionArray.size(); ++i) {
                if (((JsonValue)extensionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)extensionArray.get(i)).getValueType() + " for element: extension");
                }
                builder.extension(this.parseExtension("extension", extensionArray.getJsonObject(i), i));
            }
        }
        if ((modifierExtensionArray = JsonSupport.getJsonArray(jsonObject, "modifierExtension")) != null) {
            for (int i = 0; i < modifierExtensionArray.size(); ++i) {
                if (((JsonValue)modifierExtensionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierExtensionArray.get(i)).getValueType() + " for element: modifierExtension");
                }
                builder.modifierExtension(this.parseExtension("modifierExtension", modifierExtensionArray.getJsonObject(i), i));
            }
        }
    }

    private Dosage parseDosage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Dosage.class, jsonObject);
        }
        Dosage.Builder builder = Dosage.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence(this.parseInteger("sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray additionalInstructionArray = JsonSupport.getJsonArray(jsonObject, "additionalInstruction");
        if (additionalInstructionArray != null) {
            for (int i = 0; i < additionalInstructionArray.size(); ++i) {
                if (((JsonValue)additionalInstructionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)additionalInstructionArray.get(i)).getValueType() + " for element: additionalInstruction");
                }
                builder.additionalInstruction(this.parseCodeableConcept("additionalInstruction", additionalInstructionArray.getJsonObject(i), i));
            }
        }
        builder.patientInstruction(this.parseString("patientInstruction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "patientInstruction", JsonString.class), (JsonValue)jsonObject.get((Object)"_patientInstruction"), -1));
        builder.timing(this.parseTiming("timing", JsonSupport.getJsonValue(jsonObject, "timing", JsonObject.class), -1));
        builder.asNeeded(this.parseChoiceElement("asNeeded", jsonObject, Boolean.class, CodeableConcept.class));
        builder.site(this.parseCodeableConcept("site", JsonSupport.getJsonValue(jsonObject, "site", JsonObject.class), -1));
        builder.route(this.parseCodeableConcept("route", JsonSupport.getJsonValue(jsonObject, "route", JsonObject.class), -1));
        builder.method(this.parseCodeableConcept("method", JsonSupport.getJsonValue(jsonObject, "method", JsonObject.class), -1));
        JsonArray doseAndRateArray = JsonSupport.getJsonArray(jsonObject, "doseAndRate");
        if (doseAndRateArray != null) {
            for (int i = 0; i < doseAndRateArray.size(); ++i) {
                if (((JsonValue)doseAndRateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)doseAndRateArray.get(i)).getValueType() + " for element: doseAndRate");
                }
                builder.doseAndRate(this.parseDosageDoseAndRate("doseAndRate", doseAndRateArray.getJsonObject(i), i));
            }
        }
        builder.maxDosePerPeriod(this.parseRatio("maxDosePerPeriod", JsonSupport.getJsonValue(jsonObject, "maxDosePerPeriod", JsonObject.class), -1));
        builder.maxDosePerAdministration((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "maxDosePerAdministration", JsonSupport.getJsonValue(jsonObject, "maxDosePerAdministration", JsonObject.class), -1));
        builder.maxDosePerLifetime((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "maxDosePerLifetime", JsonSupport.getJsonValue(jsonObject, "maxDosePerLifetime", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Dosage.DoseAndRate parseDosageDoseAndRate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Dosage.DoseAndRate.class, jsonObject);
        }
        Dosage.DoseAndRate.Builder builder = Dosage.DoseAndRate.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.dose(this.parseChoiceElement("dose", jsonObject, Range.class, SimpleQuantity.class));
        builder.rate(this.parseChoiceElement("rate", jsonObject, Ratio.class, Range.class, SimpleQuantity.class));
        this.stackPop();
        return builder.build();
    }

    private void parseElement(Element.Builder builder, JsonObject jsonObject) {
        builder.setValidating(this.validating);
        builder.id(this.parseJavaString("id", JsonSupport.getJsonValue(jsonObject, "id", JsonString.class), -1));
        JsonArray extensionArray = JsonSupport.getJsonArray(jsonObject, "extension");
        if (extensionArray != null) {
            for (int i = 0; i < extensionArray.size(); ++i) {
                if (((JsonValue)extensionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)extensionArray.get(i)).getValueType() + " for element: extension");
                }
                builder.extension(this.parseExtension("extension", extensionArray.getJsonObject(i), i));
            }
        }
    }

    private ElementDefinition parseElementDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray constraintArray;
        int i;
        int i2;
        int i3;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.class, jsonObject);
        }
        ElementDefinition.Builder builder = ElementDefinition.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        JsonArray representationArray = JsonSupport.getJsonArray(jsonObject, "representation", true);
        if (representationArray != null) {
            JsonArray _representationArray = jsonObject.getJsonArray("_representation");
            for (i3 = 0; i3 < representationArray.size(); ++i3) {
                builder.representation((PropertyRepresentation)this.parseString(PropertyRepresentation.builder(), "representation", (JsonValue)representationArray.get(i3), JsonSupport.getJsonValue(_representationArray, i3), i3));
            }
        }
        builder.sliceName(this.parseString("sliceName", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sliceName", JsonString.class), (JsonValue)jsonObject.get((Object)"_sliceName"), -1));
        builder.sliceIsConstraining(this.parseBoolean("sliceIsConstraining", JsonSupport.getJsonValue(jsonObject, "sliceIsConstraining", JsonValue.class), (JsonValue)jsonObject.get((Object)"_sliceIsConstraining"), -1));
        builder.label(this.parseString("label", (JsonValue)JsonSupport.getJsonValue(jsonObject, "label", JsonString.class), (JsonValue)jsonObject.get((Object)"_label"), -1));
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (i3 = 0; i3 < codeArray.size(); ++i3) {
                if (((JsonValue)codeArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)codeArray.get(i3)).getValueType() + " for element: code");
                }
                builder.code(this.parseCoding("code", codeArray.getJsonObject(i3), i3));
            }
        }
        builder.slicing(this.parseElementDefinitionSlicing("slicing", JsonSupport.getJsonValue(jsonObject, "slicing", JsonObject.class), -1));
        builder._short(this.parseString("short", (JsonValue)JsonSupport.getJsonValue(jsonObject, "short", JsonString.class), (JsonValue)jsonObject.get((Object)"_short"), -1));
        builder.definition((Markdown)this.parseString(Markdown.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        builder.comment((Markdown)this.parseString(Markdown.builder(), "comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        builder.requirements((Markdown)this.parseString(Markdown.builder(), "requirements", (JsonValue)JsonSupport.getJsonValue(jsonObject, "requirements", JsonString.class), (JsonValue)jsonObject.get((Object)"_requirements"), -1));
        JsonArray aliasArray = JsonSupport.getJsonArray(jsonObject, "alias", true);
        if (aliasArray != null) {
            JsonArray _aliasArray = jsonObject.getJsonArray("_alias");
            for (i2 = 0; i2 < aliasArray.size(); ++i2) {
                builder.alias(this.parseString("alias", (JsonValue)aliasArray.get(i2), JsonSupport.getJsonValue(_aliasArray, i2), i2));
            }
        }
        builder.min((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "min", (JsonValue)JsonSupport.getJsonValue(jsonObject, "min", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_min"), -1));
        builder.max(this.parseString("max", (JsonValue)JsonSupport.getJsonValue(jsonObject, "max", JsonString.class), (JsonValue)jsonObject.get((Object)"_max"), -1));
        builder.base(this.parseElementDefinitionBase("base", JsonSupport.getJsonValue(jsonObject, "base", JsonObject.class), -1));
        builder.contentReference(this.parseUri("contentReference", (JsonValue)JsonSupport.getJsonValue(jsonObject, "contentReference", JsonString.class), (JsonValue)jsonObject.get((Object)"_contentReference"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (i2 = 0; i2 < typeArray.size(); ++i2) {
                if (((JsonValue)typeArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i2)).getValueType() + " for element: type");
                }
                builder.type(this.parseElementDefinitionType("type", typeArray.getJsonObject(i2), i2));
            }
        }
        builder.defaultValue(this.parseChoiceElement("defaultValue", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, org.linuxforhealth.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class));
        builder.meaningWhenMissing((Markdown)this.parseString(Markdown.builder(), "meaningWhenMissing", (JsonValue)JsonSupport.getJsonValue(jsonObject, "meaningWhenMissing", JsonString.class), (JsonValue)jsonObject.get((Object)"_meaningWhenMissing"), -1));
        builder.orderMeaning(this.parseString("orderMeaning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "orderMeaning", JsonString.class), (JsonValue)jsonObject.get((Object)"_orderMeaning"), -1));
        builder.fixed(this.parseChoiceElement("fixed", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, org.linuxforhealth.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class));
        builder.pattern(this.parseChoiceElement("pattern", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, org.linuxforhealth.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class));
        JsonArray exampleArray = JsonSupport.getJsonArray(jsonObject, "example");
        if (exampleArray != null) {
            for (int i4 = 0; i4 < exampleArray.size(); ++i4) {
                if (((JsonValue)exampleArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)exampleArray.get(i4)).getValueType() + " for element: example");
                }
                builder.example(this.parseElementDefinitionExample("example", exampleArray.getJsonObject(i4), i4));
            }
        }
        builder.minValue(this.parseChoiceElement("minValue", jsonObject, Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class));
        builder.maxValue(this.parseChoiceElement("maxValue", jsonObject, Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class));
        builder.maxLength(this.parseInteger("maxLength", (JsonValue)JsonSupport.getJsonValue(jsonObject, "maxLength", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_maxLength"), -1));
        JsonArray conditionArray = JsonSupport.getJsonArray(jsonObject, "condition", true);
        if (conditionArray != null) {
            JsonArray _conditionArray = jsonObject.getJsonArray("_condition");
            for (i = 0; i < conditionArray.size(); ++i) {
                builder.condition((Id)this.parseString(Id.builder(), "condition", (JsonValue)conditionArray.get(i), JsonSupport.getJsonValue(_conditionArray, i), i));
            }
        }
        if ((constraintArray = JsonSupport.getJsonArray(jsonObject, "constraint")) != null) {
            for (i = 0; i < constraintArray.size(); ++i) {
                if (((JsonValue)constraintArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)constraintArray.get(i)).getValueType() + " for element: constraint");
                }
                builder.constraint(this.parseElementDefinitionConstraint("constraint", constraintArray.getJsonObject(i), i));
            }
        }
        builder.mustSupport(this.parseBoolean("mustSupport", JsonSupport.getJsonValue(jsonObject, "mustSupport", JsonValue.class), (JsonValue)jsonObject.get((Object)"_mustSupport"), -1));
        builder.isModifier(this.parseBoolean("isModifier", JsonSupport.getJsonValue(jsonObject, "isModifier", JsonValue.class), (JsonValue)jsonObject.get((Object)"_isModifier"), -1));
        builder.isModifierReason(this.parseString("isModifierReason", (JsonValue)JsonSupport.getJsonValue(jsonObject, "isModifierReason", JsonString.class), (JsonValue)jsonObject.get((Object)"_isModifierReason"), -1));
        builder.isSummary(this.parseBoolean("isSummary", JsonSupport.getJsonValue(jsonObject, "isSummary", JsonValue.class), (JsonValue)jsonObject.get((Object)"_isSummary"), -1));
        builder.binding(this.parseElementDefinitionBinding("binding", JsonSupport.getJsonValue(jsonObject, "binding", JsonObject.class), -1));
        JsonArray mappingArray = JsonSupport.getJsonArray(jsonObject, "mapping");
        if (mappingArray != null) {
            for (int i5 = 0; i5 < mappingArray.size(); ++i5) {
                if (((JsonValue)mappingArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)mappingArray.get(i5)).getValueType() + " for element: mapping");
                }
                builder.mapping(this.parseElementDefinitionMapping("mapping", mappingArray.getJsonObject(i5), i5));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Base parseElementDefinitionBase(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Base.class, jsonObject);
        }
        ElementDefinition.Base.Builder builder = ElementDefinition.Base.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.min((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "min", (JsonValue)JsonSupport.getJsonValue(jsonObject, "min", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_min"), -1));
        builder.max(this.parseString("max", (JsonValue)JsonSupport.getJsonValue(jsonObject, "max", JsonString.class), (JsonValue)jsonObject.get((Object)"_max"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Binding parseElementDefinitionBinding(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Binding.class, jsonObject);
        }
        ElementDefinition.Binding.Builder builder = ElementDefinition.Binding.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.strength((BindingStrength)this.parseString(BindingStrength.builder(), "strength", (JsonValue)JsonSupport.getJsonValue(jsonObject, "strength", JsonString.class), (JsonValue)jsonObject.get((Object)"_strength"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", (JsonValue)JsonSupport.getJsonValue(jsonObject, "valueSet", JsonString.class), (JsonValue)jsonObject.get((Object)"_valueSet"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Constraint parseElementDefinitionConstraint(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Constraint.class, jsonObject);
        }
        ElementDefinition.Constraint.Builder builder = ElementDefinition.Constraint.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.key((Id)this.parseString(Id.builder(), "key", (JsonValue)JsonSupport.getJsonValue(jsonObject, "key", JsonString.class), (JsonValue)jsonObject.get((Object)"_key"), -1));
        builder.requirements(this.parseString("requirements", (JsonValue)JsonSupport.getJsonValue(jsonObject, "requirements", JsonString.class), (JsonValue)jsonObject.get((Object)"_requirements"), -1));
        builder.severity((ConstraintSeverity)this.parseString(ConstraintSeverity.builder(), "severity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "severity", JsonString.class), (JsonValue)jsonObject.get((Object)"_severity"), -1));
        builder.human(this.parseString("human", (JsonValue)JsonSupport.getJsonValue(jsonObject, "human", JsonString.class), (JsonValue)jsonObject.get((Object)"_human"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        builder.xpath(this.parseString("xpath", (JsonValue)JsonSupport.getJsonValue(jsonObject, "xpath", JsonString.class), (JsonValue)jsonObject.get((Object)"_xpath"), -1));
        builder.source((Canonical)this.parseUri(Canonical.builder(), "source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Example parseElementDefinitionExample(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Example.class, jsonObject);
        }
        ElementDefinition.Example.Builder builder = ElementDefinition.Example.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.label(this.parseString("label", (JsonValue)JsonSupport.getJsonValue(jsonObject, "label", JsonString.class), (JsonValue)jsonObject.get((Object)"_label"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, org.linuxforhealth.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Mapping parseElementDefinitionMapping(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Mapping.class, jsonObject);
        }
        ElementDefinition.Mapping.Builder builder = ElementDefinition.Mapping.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.identity((Id)this.parseString(Id.builder(), "identity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "identity", JsonString.class), (JsonValue)jsonObject.get((Object)"_identity"), -1));
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.map(this.parseString("map", (JsonValue)JsonSupport.getJsonValue(jsonObject, "map", JsonString.class), (JsonValue)jsonObject.get((Object)"_map"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Slicing parseElementDefinitionSlicing(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Slicing.class, jsonObject);
        }
        ElementDefinition.Slicing.Builder builder = ElementDefinition.Slicing.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray discriminatorArray = JsonSupport.getJsonArray(jsonObject, "discriminator");
        if (discriminatorArray != null) {
            for (int i = 0; i < discriminatorArray.size(); ++i) {
                if (((JsonValue)discriminatorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)discriminatorArray.get(i)).getValueType() + " for element: discriminator");
                }
                builder.discriminator(this.parseElementDefinitionSlicingDiscriminator("discriminator", discriminatorArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.ordered(this.parseBoolean("ordered", JsonSupport.getJsonValue(jsonObject, "ordered", JsonValue.class), (JsonValue)jsonObject.get((Object)"_ordered"), -1));
        builder.rules((SlicingRules)this.parseString(SlicingRules.builder(), "rules", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rules", JsonString.class), (JsonValue)jsonObject.get((Object)"_rules"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Slicing.Discriminator parseElementDefinitionSlicingDiscriminator(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Slicing.Discriminator.class, jsonObject);
        }
        ElementDefinition.Slicing.Discriminator.Builder builder = ElementDefinition.Slicing.Discriminator.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type((DiscriminatorType)this.parseString(DiscriminatorType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Type parseElementDefinitionType(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray aggregationArray;
        JsonArray targetProfileArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Type.class, jsonObject);
        }
        ElementDefinition.Type.Builder builder = ElementDefinition.Type.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseUri("code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        JsonArray profileArray = JsonSupport.getJsonArray(jsonObject, "profile", true);
        if (profileArray != null) {
            JsonArray _profileArray = jsonObject.getJsonArray("_profile");
            for (int i = 0; i < profileArray.size(); ++i) {
                builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)profileArray.get(i), JsonSupport.getJsonValue(_profileArray, i), i));
            }
        }
        if ((targetProfileArray = JsonSupport.getJsonArray(jsonObject, "targetProfile", true)) != null) {
            JsonArray _targetProfileArray = jsonObject.getJsonArray("_targetProfile");
            for (int i = 0; i < targetProfileArray.size(); ++i) {
                builder.targetProfile((Canonical)this.parseUri(Canonical.builder(), "targetProfile", (JsonValue)targetProfileArray.get(i), JsonSupport.getJsonValue(_targetProfileArray, i), i));
            }
        }
        if ((aggregationArray = JsonSupport.getJsonArray(jsonObject, "aggregation", true)) != null) {
            JsonArray _aggregationArray = jsonObject.getJsonArray("_aggregation");
            for (int i = 0; i < aggregationArray.size(); ++i) {
                builder.aggregation((AggregationMode)this.parseString(AggregationMode.builder(), "aggregation", (JsonValue)aggregationArray.get(i), JsonSupport.getJsonValue(_aggregationArray, i), i));
            }
        }
        builder.versioning((ReferenceVersionRules)this.parseString(ReferenceVersionRules.builder(), "versioning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versioning", JsonString.class), (JsonValue)jsonObject.get((Object)"_versioning"), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter parseEncounter(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray accountArray;
        JsonArray diagnosisArray;
        JsonArray reasonReferenceArray;
        JsonArray appointmentArray;
        JsonArray participantArray;
        JsonArray basedOnArray;
        JsonArray typeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Encounter.class, jsonObject);
        }
        Encounter.Builder builder = Encounter.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EncounterStatus)this.parseString(EncounterStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusHistoryArray = JsonSupport.getJsonArray(jsonObject, "statusHistory");
        if (statusHistoryArray != null) {
            for (int i = 0; i < statusHistoryArray.size(); ++i) {
                if (((JsonValue)statusHistoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)statusHistoryArray.get(i)).getValueType() + " for element: statusHistory");
                }
                builder.statusHistory(this.parseEncounterStatusHistory("statusHistory", statusHistoryArray.getJsonObject(i), i));
            }
        }
        builder.clazz(this.parseCoding("class", JsonSupport.getJsonValue(jsonObject, "class", JsonObject.class), -1));
        JsonArray classHistoryArray = JsonSupport.getJsonArray(jsonObject, "classHistory");
        if (classHistoryArray != null) {
            for (int i = 0; i < classHistoryArray.size(); ++i) {
                if (((JsonValue)classHistoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)classHistoryArray.get(i)).getValueType() + " for element: classHistory");
                }
                builder.classHistory(this.parseEncounterClassHistory("classHistory", classHistoryArray.getJsonObject(i), i));
            }
        }
        if ((typeArray = JsonSupport.getJsonArray(jsonObject, "type")) != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.serviceType(this.parseCodeableConcept("serviceType", JsonSupport.getJsonValue(jsonObject, "serviceType", JsonObject.class), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        JsonArray episodeOfCareArray = JsonSupport.getJsonArray(jsonObject, "episodeOfCare");
        if (episodeOfCareArray != null) {
            for (int i = 0; i < episodeOfCareArray.size(); ++i) {
                if (((JsonValue)episodeOfCareArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)episodeOfCareArray.get(i)).getValueType() + " for element: episodeOfCare");
                }
                builder.episodeOfCare(this.parseReference("episodeOfCare", episodeOfCareArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                if (((JsonValue)basedOnArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)basedOnArray.get(i)).getValueType() + " for element: basedOn");
                }
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((participantArray = JsonSupport.getJsonArray(jsonObject, "participant")) != null) {
            for (int i = 0; i < participantArray.size(); ++i) {
                if (((JsonValue)participantArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)participantArray.get(i)).getValueType() + " for element: participant");
                }
                builder.participant(this.parseEncounterParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        if ((appointmentArray = JsonSupport.getJsonArray(jsonObject, "appointment")) != null) {
            for (int i = 0; i < appointmentArray.size(); ++i) {
                if (((JsonValue)appointmentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)appointmentArray.get(i)).getValueType() + " for element: appointment");
                }
                builder.appointment(this.parseReference("appointment", appointmentArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.length((Duration)this.parseQuantity(Duration.builder(), "length", JsonSupport.getJsonValue(jsonObject, "length", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                if (((JsonValue)reasonCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                if (((JsonValue)reasonReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i = 0; i < diagnosisArray.size(); ++i) {
                if (((JsonValue)diagnosisArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)diagnosisArray.get(i)).getValueType() + " for element: diagnosis");
                }
                builder.diagnosis(this.parseEncounterDiagnosis("diagnosis", diagnosisArray.getJsonObject(i), i));
            }
        }
        if ((accountArray = JsonSupport.getJsonArray(jsonObject, "account")) != null) {
            for (int i = 0; i < accountArray.size(); ++i) {
                if (((JsonValue)accountArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)accountArray.get(i)).getValueType() + " for element: account");
                }
                builder.account(this.parseReference("account", accountArray.getJsonObject(i), i));
            }
        }
        builder.hospitalization(this.parseEncounterHospitalization("hospitalization", JsonSupport.getJsonValue(jsonObject, "hospitalization", JsonObject.class), -1));
        JsonArray locationArray = JsonSupport.getJsonArray(jsonObject, "location");
        if (locationArray != null) {
            for (int i = 0; i < locationArray.size(); ++i) {
                if (((JsonValue)locationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)locationArray.get(i)).getValueType() + " for element: location");
                }
                builder.location(this.parseEncounterLocation("location", locationArray.getJsonObject(i), i));
            }
        }
        builder.serviceProvider(this.parseReference("serviceProvider", JsonSupport.getJsonValue(jsonObject, "serviceProvider", JsonObject.class), -1));
        builder.partOf(this.parseReference("partOf", JsonSupport.getJsonValue(jsonObject, "partOf", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.ClassHistory parseEncounterClassHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Encounter.ClassHistory.class, jsonObject);
        }
        Encounter.ClassHistory.Builder builder = Encounter.ClassHistory.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.clazz(this.parseCoding("class", JsonSupport.getJsonValue(jsonObject, "class", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Diagnosis parseEncounterDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Diagnosis.class, jsonObject);
        }
        Encounter.Diagnosis.Builder builder = Encounter.Diagnosis.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.condition(this.parseReference("condition", JsonSupport.getJsonValue(jsonObject, "condition", JsonObject.class), -1));
        builder.use(this.parseCodeableConcept("use", JsonSupport.getJsonValue(jsonObject, "use", JsonObject.class), -1));
        builder.rank((PositiveInt)this.parseInteger(PositiveInt.builder(), "rank", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rank", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_rank"), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Hospitalization parseEncounterHospitalization(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray specialArrangementArray;
        JsonArray specialCourtesyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Hospitalization.class, jsonObject);
        }
        Encounter.Hospitalization.Builder builder = Encounter.Hospitalization.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.preAdmissionIdentifier(this.parseIdentifier("preAdmissionIdentifier", JsonSupport.getJsonValue(jsonObject, "preAdmissionIdentifier", JsonObject.class), -1));
        builder.origin(this.parseReference("origin", JsonSupport.getJsonValue(jsonObject, "origin", JsonObject.class), -1));
        builder.admitSource(this.parseCodeableConcept("admitSource", JsonSupport.getJsonValue(jsonObject, "admitSource", JsonObject.class), -1));
        builder.reAdmission(this.parseCodeableConcept("reAdmission", JsonSupport.getJsonValue(jsonObject, "reAdmission", JsonObject.class), -1));
        JsonArray dietPreferenceArray = JsonSupport.getJsonArray(jsonObject, "dietPreference");
        if (dietPreferenceArray != null) {
            for (int i = 0; i < dietPreferenceArray.size(); ++i) {
                if (((JsonValue)dietPreferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)dietPreferenceArray.get(i)).getValueType() + " for element: dietPreference");
                }
                builder.dietPreference(this.parseCodeableConcept("dietPreference", dietPreferenceArray.getJsonObject(i), i));
            }
        }
        if ((specialCourtesyArray = JsonSupport.getJsonArray(jsonObject, "specialCourtesy")) != null) {
            for (int i = 0; i < specialCourtesyArray.size(); ++i) {
                if (((JsonValue)specialCourtesyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)specialCourtesyArray.get(i)).getValueType() + " for element: specialCourtesy");
                }
                builder.specialCourtesy(this.parseCodeableConcept("specialCourtesy", specialCourtesyArray.getJsonObject(i), i));
            }
        }
        if ((specialArrangementArray = JsonSupport.getJsonArray(jsonObject, "specialArrangement")) != null) {
            for (int i = 0; i < specialArrangementArray.size(); ++i) {
                if (((JsonValue)specialArrangementArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)specialArrangementArray.get(i)).getValueType() + " for element: specialArrangement");
                }
                builder.specialArrangement(this.parseCodeableConcept("specialArrangement", specialArrangementArray.getJsonObject(i), i));
            }
        }
        builder.destination(this.parseReference("destination", JsonSupport.getJsonValue(jsonObject, "destination", JsonObject.class), -1));
        builder.dischargeDisposition(this.parseCodeableConcept("dischargeDisposition", JsonSupport.getJsonValue(jsonObject, "dischargeDisposition", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Location parseEncounterLocation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Location.class, jsonObject);
        }
        Encounter.Location.Builder builder = Encounter.Location.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        builder.status((EncounterLocationStatus)this.parseString(EncounterLocationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.physicalType(this.parseCodeableConcept("physicalType", JsonSupport.getJsonValue(jsonObject, "physicalType", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Participant parseEncounterParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Participant.class, jsonObject);
        }
        Encounter.Participant.Builder builder = Encounter.Participant.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.individual(this.parseReference("individual", JsonSupport.getJsonValue(jsonObject, "individual", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.StatusHistory parseEncounterStatusHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Encounter.StatusHistory.class, jsonObject);
        }
        Encounter.StatusHistory.Builder builder = Encounter.StatusHistory.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.status((EncounterStatus)this.parseString(EncounterStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Endpoint parseEndpoint(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray payloadMimeTypeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Endpoint.class, jsonObject);
        }
        Endpoint.Builder builder = Endpoint.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EndpointStatus)this.parseString(EndpointStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.connectionType(this.parseCoding("connectionType", JsonSupport.getJsonValue(jsonObject, "connectionType", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.managingOrganization(this.parseReference("managingOrganization", JsonSupport.getJsonValue(jsonObject, "managingOrganization", JsonObject.class), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactPoint("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray payloadTypeArray = JsonSupport.getJsonArray(jsonObject, "payloadType");
        if (payloadTypeArray != null) {
            for (int i = 0; i < payloadTypeArray.size(); ++i) {
                if (((JsonValue)payloadTypeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)payloadTypeArray.get(i)).getValueType() + " for element: payloadType");
                }
                builder.payloadType(this.parseCodeableConcept("payloadType", payloadTypeArray.getJsonObject(i), i));
            }
        }
        if ((payloadMimeTypeArray = JsonSupport.getJsonArray(jsonObject, "payloadMimeType", true)) != null) {
            JsonArray _payloadMimeTypeArray = jsonObject.getJsonArray("_payloadMimeType");
            for (int i = 0; i < payloadMimeTypeArray.size(); ++i) {
                builder.payloadMimeType((Code)this.parseString(Code.builder(), "payloadMimeType", (JsonValue)payloadMimeTypeArray.get(i), JsonSupport.getJsonValue(_payloadMimeTypeArray, i), i));
            }
        }
        builder.address((Url)this.parseUri(Url.builder(), "address", (JsonValue)JsonSupport.getJsonValue(jsonObject, "address", JsonString.class), (JsonValue)jsonObject.get((Object)"_address"), -1));
        JsonArray headerArray = JsonSupport.getJsonArray(jsonObject, "header", true);
        if (headerArray != null) {
            JsonArray _headerArray = jsonObject.getJsonArray("_header");
            for (int i = 0; i < headerArray.size(); ++i) {
                builder.header(this.parseString("header", (JsonValue)headerArray.get(i), JsonSupport.getJsonValue(_headerArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EnrollmentRequest parseEnrollmentRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EnrollmentRequest.class, jsonObject);
        }
        EnrollmentRequest.Builder builder = EnrollmentRequest.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EnrollmentRequestStatus)this.parseString(EnrollmentRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.candidate(this.parseReference("candidate", JsonSupport.getJsonValue(jsonObject, "candidate", JsonObject.class), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EnrollmentResponse parseEnrollmentResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EnrollmentResponse.class, jsonObject);
        }
        EnrollmentResponse.Builder builder = EnrollmentResponse.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EnrollmentResponseStatus)this.parseString(EnrollmentResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.request(this.parseReference("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.organization(this.parseReference("organization", JsonSupport.getJsonValue(jsonObject, "organization", JsonObject.class), -1));
        builder.requestProvider(this.parseReference("requestProvider", JsonSupport.getJsonValue(jsonObject, "requestProvider", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EpisodeOfCare parseEpisodeOfCare(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray accountArray;
        JsonArray diagnosisArray;
        JsonArray typeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EpisodeOfCare.class, jsonObject);
        }
        EpisodeOfCare.Builder builder = EpisodeOfCare.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EpisodeOfCareStatus)this.parseString(EpisodeOfCareStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusHistoryArray = JsonSupport.getJsonArray(jsonObject, "statusHistory");
        if (statusHistoryArray != null) {
            for (int i = 0; i < statusHistoryArray.size(); ++i) {
                if (((JsonValue)statusHistoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)statusHistoryArray.get(i)).getValueType() + " for element: statusHistory");
                }
                builder.statusHistory(this.parseEpisodeOfCareStatusHistory("statusHistory", statusHistoryArray.getJsonObject(i), i));
            }
        }
        if ((typeArray = JsonSupport.getJsonArray(jsonObject, "type")) != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i = 0; i < diagnosisArray.size(); ++i) {
                if (((JsonValue)diagnosisArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)diagnosisArray.get(i)).getValueType() + " for element: diagnosis");
                }
                builder.diagnosis(this.parseEpisodeOfCareDiagnosis("diagnosis", diagnosisArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.managingOrganization(this.parseReference("managingOrganization", JsonSupport.getJsonValue(jsonObject, "managingOrganization", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray referralRequestArray = JsonSupport.getJsonArray(jsonObject, "referralRequest");
        if (referralRequestArray != null) {
            for (int i = 0; i < referralRequestArray.size(); ++i) {
                if (((JsonValue)referralRequestArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)referralRequestArray.get(i)).getValueType() + " for element: referralRequest");
                }
                builder.referralRequest(this.parseReference("referralRequest", referralRequestArray.getJsonObject(i), i));
            }
        }
        builder.careManager(this.parseReference("careManager", JsonSupport.getJsonValue(jsonObject, "careManager", JsonObject.class), -1));
        JsonArray teamArray = JsonSupport.getJsonArray(jsonObject, "team");
        if (teamArray != null) {
            for (int i = 0; i < teamArray.size(); ++i) {
                if (((JsonValue)teamArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)teamArray.get(i)).getValueType() + " for element: team");
                }
                builder.team(this.parseReference("team", teamArray.getJsonObject(i), i));
            }
        }
        if ((accountArray = JsonSupport.getJsonArray(jsonObject, "account")) != null) {
            for (int i = 0; i < accountArray.size(); ++i) {
                if (((JsonValue)accountArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)accountArray.get(i)).getValueType() + " for element: account");
                }
                builder.account(this.parseReference("account", accountArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EpisodeOfCare.Diagnosis parseEpisodeOfCareDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EpisodeOfCare.Diagnosis.class, jsonObject);
        }
        EpisodeOfCare.Diagnosis.Builder builder = EpisodeOfCare.Diagnosis.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.condition(this.parseReference("condition", JsonSupport.getJsonValue(jsonObject, "condition", JsonObject.class), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.rank((PositiveInt)this.parseInteger(PositiveInt.builder(), "rank", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rank", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_rank"), -1));
        this.stackPop();
        return builder.build();
    }

    private EpisodeOfCare.StatusHistory parseEpisodeOfCareStatusHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EpisodeOfCare.StatusHistory.class, jsonObject);
        }
        EpisodeOfCare.StatusHistory.Builder builder = EpisodeOfCare.StatusHistory.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.status((EpisodeOfCareStatus)this.parseString(EpisodeOfCareStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EventDefinition parseEventDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray triggerArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EventDefinition.class, jsonObject);
        }
        EventDefinition.Builder builder = EventDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                if (((JsonValue)jurisdictionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.usage(this.parseString("usage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "usage", JsonString.class), (JsonValue)jsonObject.get((Object)"_usage"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i = 0; i < topicArray.size(); ++i) {
                if (((JsonValue)topicArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)topicArray.get(i)).getValueType() + " for element: topic");
                }
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                if (((JsonValue)editorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)editorArray.get(i)).getValueType() + " for element: editor");
                }
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                if (((JsonValue)reviewerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reviewerArray.get(i)).getValueType() + " for element: reviewer");
                }
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                if (((JsonValue)endorserArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)endorserArray.get(i)).getValueType() + " for element: endorser");
                }
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                if (((JsonValue)relatedArtifactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArtifactArray.get(i)).getValueType() + " for element: relatedArtifact");
                }
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        if ((triggerArray = JsonSupport.getJsonArray(jsonObject, "trigger")) != null) {
            for (int i = 0; i < triggerArray.size(); ++i) {
                if (((JsonValue)triggerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)triggerArray.get(i)).getValueType() + " for element: trigger");
                }
                builder.trigger(this.parseTriggerDefinition("trigger", triggerArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence parseEvidence(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray certaintyArray;
        JsonArray variableDefinitionArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.class, jsonObject);
        }
        Evidence.Builder builder = Evidence.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.citeAs(this.parseChoiceElement("citeAs", jsonObject, Reference.class, Markdown.class));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                if (((JsonValue)editorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)editorArray.get(i)).getValueType() + " for element: editor");
                }
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                if (((JsonValue)reviewerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reviewerArray.get(i)).getValueType() + " for element: reviewer");
                }
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                if (((JsonValue)endorserArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)endorserArray.get(i)).getValueType() + " for element: endorser");
                }
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                if (((JsonValue)relatedArtifactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArtifactArray.get(i)).getValueType() + " for element: relatedArtifact");
                }
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.assertion((Markdown)this.parseString(Markdown.builder(), "assertion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "assertion", JsonString.class), (JsonValue)jsonObject.get((Object)"_assertion"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((variableDefinitionArray = JsonSupport.getJsonArray(jsonObject, "variableDefinition")) != null) {
            for (int i = 0; i < variableDefinitionArray.size(); ++i) {
                if (((JsonValue)variableDefinitionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)variableDefinitionArray.get(i)).getValueType() + " for element: variableDefinition");
                }
                builder.variableDefinition(this.parseEvidenceVariableDefinition("variableDefinition", variableDefinitionArray.getJsonObject(i), i));
            }
        }
        builder.synthesisType(this.parseCodeableConcept("synthesisType", JsonSupport.getJsonValue(jsonObject, "synthesisType", JsonObject.class), -1));
        builder.studyType(this.parseCodeableConcept("studyType", JsonSupport.getJsonValue(jsonObject, "studyType", JsonObject.class), -1));
        JsonArray statisticArray = JsonSupport.getJsonArray(jsonObject, "statistic");
        if (statisticArray != null) {
            for (int i = 0; i < statisticArray.size(); ++i) {
                if (((JsonValue)statisticArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)statisticArray.get(i)).getValueType() + " for element: statistic");
                }
                builder.statistic(this.parseEvidenceStatistic("statistic", statisticArray.getJsonObject(i), i));
            }
        }
        if ((certaintyArray = JsonSupport.getJsonArray(jsonObject, "certainty")) != null) {
            for (int i = 0; i < certaintyArray.size(); ++i) {
                if (((JsonValue)certaintyArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)certaintyArray.get(i)).getValueType() + " for element: certainty");
                }
                builder.certainty(this.parseEvidenceCertainty("certainty", certaintyArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence.Certainty parseEvidenceCertainty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.Certainty.class, jsonObject);
        }
        Evidence.Certainty.Builder builder = Evidence.Certainty.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.rating(this.parseCodeableConcept("rating", JsonSupport.getJsonValue(jsonObject, "rating", JsonObject.class), -1));
        builder.rater(this.parseString("rater", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rater", JsonString.class), (JsonValue)jsonObject.get((Object)"_rater"), -1));
        JsonArray subcomponentArray = JsonSupport.getJsonArray(jsonObject, "subcomponent");
        if (subcomponentArray != null) {
            for (int i = 0; i < subcomponentArray.size(); ++i) {
                if (((JsonValue)subcomponentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subcomponentArray.get(i)).getValueType() + " for element: subcomponent");
                }
                builder.subcomponent(this.parseEvidenceCertainty("subcomponent", subcomponentArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence.Statistic parseEvidenceStatistic(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray modelCharacteristicArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.Statistic.class, jsonObject);
        }
        Evidence.Statistic.Builder builder = Evidence.Statistic.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        builder.statisticType(this.parseCodeableConcept("statisticType", JsonSupport.getJsonValue(jsonObject, "statisticType", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.quantity(this.parseQuantity("quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.numberOfEvents((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberOfEvents", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfEvents", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfEvents"), -1));
        builder.numberAffected((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberAffected", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberAffected", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberAffected"), -1));
        builder.sampleSize(this.parseEvidenceStatisticSampleSize("sampleSize", JsonSupport.getJsonValue(jsonObject, "sampleSize", JsonObject.class), -1));
        JsonArray attributeEstimateArray = JsonSupport.getJsonArray(jsonObject, "attributeEstimate");
        if (attributeEstimateArray != null) {
            for (int i = 0; i < attributeEstimateArray.size(); ++i) {
                if (((JsonValue)attributeEstimateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)attributeEstimateArray.get(i)).getValueType() + " for element: attributeEstimate");
                }
                builder.attributeEstimate(this.parseEvidenceStatisticAttributeEstimate("attributeEstimate", attributeEstimateArray.getJsonObject(i), i));
            }
        }
        if ((modelCharacteristicArray = JsonSupport.getJsonArray(jsonObject, "modelCharacteristic")) != null) {
            for (int i = 0; i < modelCharacteristicArray.size(); ++i) {
                if (((JsonValue)modelCharacteristicArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modelCharacteristicArray.get(i)).getValueType() + " for element: modelCharacteristic");
                }
                builder.modelCharacteristic(this.parseEvidenceStatisticModelCharacteristic("modelCharacteristic", modelCharacteristicArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence.Statistic.AttributeEstimate parseEvidenceStatisticAttributeEstimate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.Statistic.AttributeEstimate.class, jsonObject);
        }
        Evidence.Statistic.AttributeEstimate.Builder builder = Evidence.Statistic.AttributeEstimate.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.quantity(this.parseQuantity("quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.level(this.parseDecimal("level", (JsonValue)JsonSupport.getJsonValue(jsonObject, "level", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_level"), -1));
        builder.range(this.parseRange("range", JsonSupport.getJsonValue(jsonObject, "range", JsonObject.class), -1));
        JsonArray attributeEstimateArray = JsonSupport.getJsonArray(jsonObject, "attributeEstimate");
        if (attributeEstimateArray != null) {
            for (int i = 0; i < attributeEstimateArray.size(); ++i) {
                if (((JsonValue)attributeEstimateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)attributeEstimateArray.get(i)).getValueType() + " for element: attributeEstimate");
                }
                builder.attributeEstimate(this.parseEvidenceStatisticAttributeEstimate("attributeEstimate", attributeEstimateArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence.Statistic.ModelCharacteristic parseEvidenceStatisticModelCharacteristic(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray attributeEstimateArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.Statistic.ModelCharacteristic.class, jsonObject);
        }
        Evidence.Statistic.ModelCharacteristic.Builder builder = Evidence.Statistic.ModelCharacteristic.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "value", JsonSupport.getJsonValue(jsonObject, "value", JsonObject.class), -1));
        JsonArray variableArray = JsonSupport.getJsonArray(jsonObject, "variable");
        if (variableArray != null) {
            for (int i = 0; i < variableArray.size(); ++i) {
                if (((JsonValue)variableArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)variableArray.get(i)).getValueType() + " for element: variable");
                }
                builder.variable(this.parseEvidenceStatisticModelCharacteristicVariable("variable", variableArray.getJsonObject(i), i));
            }
        }
        if ((attributeEstimateArray = JsonSupport.getJsonArray(jsonObject, "attributeEstimate")) != null) {
            for (int i = 0; i < attributeEstimateArray.size(); ++i) {
                if (((JsonValue)attributeEstimateArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)attributeEstimateArray.get(i)).getValueType() + " for element: attributeEstimate");
                }
                builder.attributeEstimate(this.parseEvidenceStatisticAttributeEstimate("attributeEstimate", attributeEstimateArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence.Statistic.ModelCharacteristic.Variable parseEvidenceStatisticModelCharacteristicVariable(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray valueRangeArray;
        JsonArray valueQuantityArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.Statistic.ModelCharacteristic.Variable.class, jsonObject);
        }
        Evidence.Statistic.ModelCharacteristic.Variable.Builder builder = Evidence.Statistic.ModelCharacteristic.Variable.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.variableDefinition(this.parseReference("variableDefinition", JsonSupport.getJsonValue(jsonObject, "variableDefinition", JsonObject.class), -1));
        builder.handling((EvidenceVariableHandling)this.parseString(EvidenceVariableHandling.builder(), "handling", (JsonValue)JsonSupport.getJsonValue(jsonObject, "handling", JsonString.class), (JsonValue)jsonObject.get((Object)"_handling"), -1));
        JsonArray valueCategoryArray = JsonSupport.getJsonArray(jsonObject, "valueCategory");
        if (valueCategoryArray != null) {
            for (int i = 0; i < valueCategoryArray.size(); ++i) {
                if (((JsonValue)valueCategoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valueCategoryArray.get(i)).getValueType() + " for element: valueCategory");
                }
                builder.valueCategory(this.parseCodeableConcept("valueCategory", valueCategoryArray.getJsonObject(i), i));
            }
        }
        if ((valueQuantityArray = JsonSupport.getJsonArray(jsonObject, "valueQuantity")) != null) {
            for (int i = 0; i < valueQuantityArray.size(); ++i) {
                if (((JsonValue)valueQuantityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valueQuantityArray.get(i)).getValueType() + " for element: valueQuantity");
                }
                builder.valueQuantity(this.parseQuantity("valueQuantity", valueQuantityArray.getJsonObject(i), i));
            }
        }
        if ((valueRangeArray = JsonSupport.getJsonArray(jsonObject, "valueRange")) != null) {
            for (int i = 0; i < valueRangeArray.size(); ++i) {
                if (((JsonValue)valueRangeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)valueRangeArray.get(i)).getValueType() + " for element: valueRange");
                }
                builder.valueRange(this.parseRange("valueRange", valueRangeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence.Statistic.SampleSize parseEvidenceStatisticSampleSize(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.Statistic.SampleSize.class, jsonObject);
        }
        Evidence.Statistic.SampleSize.Builder builder = Evidence.Statistic.SampleSize.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        builder.numberOfStudies((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberOfStudies", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfStudies", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfStudies"), -1));
        builder.numberOfParticipants((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberOfParticipants", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfParticipants", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfParticipants"), -1));
        builder.knownDataCount((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "knownDataCount", (JsonValue)JsonSupport.getJsonValue(jsonObject, "knownDataCount", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_knownDataCount"), -1));
        this.stackPop();
        return builder.build();
    }

    private Evidence.VariableDefinition parseEvidenceVariableDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Evidence.VariableDefinition.class, jsonObject);
        }
        Evidence.VariableDefinition.Builder builder = Evidence.VariableDefinition.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        builder.variableRole(this.parseCodeableConcept("variableRole", JsonSupport.getJsonValue(jsonObject, "variableRole", JsonObject.class), -1));
        builder.observed(this.parseReference("observed", JsonSupport.getJsonValue(jsonObject, "observed", JsonObject.class), -1));
        builder.intended(this.parseReference("intended", JsonSupport.getJsonValue(jsonObject, "intended", JsonObject.class), -1));
        builder.directnessMatch(this.parseCodeableConcept("directnessMatch", JsonSupport.getJsonValue(jsonObject, "directnessMatch", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EvidenceReport parseEvidenceReport(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray sectionArray;
        JsonArray relatesToArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray relatedArtifactArray;
        JsonArray relatedIdentifierArray;
        JsonArray identifierArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceReport.class, jsonObject);
        }
        EvidenceReport.Builder builder = EvidenceReport.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier")) != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((relatedIdentifierArray = JsonSupport.getJsonArray(jsonObject, "relatedIdentifier")) != null) {
            for (int i = 0; i < relatedIdentifierArray.size(); ++i) {
                if (((JsonValue)relatedIdentifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedIdentifierArray.get(i)).getValueType() + " for element: relatedIdentifier");
                }
                builder.relatedIdentifier(this.parseIdentifier("relatedIdentifier", relatedIdentifierArray.getJsonObject(i), i));
            }
        }
        builder.citeAs(this.parseChoiceElement("citeAs", jsonObject, Reference.class, Markdown.class));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                if (((JsonValue)relatedArtifactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArtifactArray.get(i)).getValueType() + " for element: relatedArtifact");
                }
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseEvidenceReportSubject("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                if (((JsonValue)editorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)editorArray.get(i)).getValueType() + " for element: editor");
                }
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                if (((JsonValue)reviewerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reviewerArray.get(i)).getValueType() + " for element: reviewer");
                }
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                if (((JsonValue)endorserArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)endorserArray.get(i)).getValueType() + " for element: endorser");
                }
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatesToArray = JsonSupport.getJsonArray(jsonObject, "relatesTo")) != null) {
            for (int i = 0; i < relatesToArray.size(); ++i) {
                if (((JsonValue)relatesToArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatesToArray.get(i)).getValueType() + " for element: relatesTo");
                }
                builder.relatesTo(this.parseEvidenceReportRelatesTo("relatesTo", relatesToArray.getJsonObject(i), i));
            }
        }
        if ((sectionArray = JsonSupport.getJsonArray(jsonObject, "section")) != null) {
            for (int i = 0; i < sectionArray.size(); ++i) {
                if (((JsonValue)sectionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)sectionArray.get(i)).getValueType() + " for element: section");
                }
                builder.section(this.parseEvidenceReportSection("section", sectionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EvidenceReport.RelatesTo parseEvidenceReportRelatesTo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceReport.RelatesTo.class, jsonObject);
        }
        EvidenceReport.RelatesTo.Builder builder = EvidenceReport.RelatesTo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code((ReportRelationshipType)this.parseString(ReportRelationshipType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.target(this.parseChoiceElement("target", jsonObject, Identifier.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private EvidenceReport.Section parseEvidenceReportSection(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray entryQuantityArray;
        JsonArray entryReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceReport.Section.class, jsonObject);
        }
        EvidenceReport.Section.Builder builder = EvidenceReport.Section.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.focus(this.parseCodeableConcept("focus", JsonSupport.getJsonValue(jsonObject, "focus", JsonObject.class), -1));
        builder.focusReference(this.parseReference("focusReference", JsonSupport.getJsonValue(jsonObject, "focusReference", JsonObject.class), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        builder.text(this.parseNarrative("text", JsonSupport.getJsonValue(jsonObject, "text", JsonObject.class), -1));
        builder.mode((SectionMode)this.parseString(SectionMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.orderedBy(this.parseCodeableConcept("orderedBy", JsonSupport.getJsonValue(jsonObject, "orderedBy", JsonObject.class), -1));
        JsonArray entryClassifierArray = JsonSupport.getJsonArray(jsonObject, "entryClassifier");
        if (entryClassifierArray != null) {
            for (int i = 0; i < entryClassifierArray.size(); ++i) {
                if (((JsonValue)entryClassifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)entryClassifierArray.get(i)).getValueType() + " for element: entryClassifier");
                }
                builder.entryClassifier(this.parseCodeableConcept("entryClassifier", entryClassifierArray.getJsonObject(i), i));
            }
        }
        if ((entryReferenceArray = JsonSupport.getJsonArray(jsonObject, "entryReference")) != null) {
            for (int i = 0; i < entryReferenceArray.size(); ++i) {
                if (((JsonValue)entryReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)entryReferenceArray.get(i)).getValueType() + " for element: entryReference");
                }
                builder.entryReference(this.parseReference("entryReference", entryReferenceArray.getJsonObject(i), i));
            }
        }
        if ((entryQuantityArray = JsonSupport.getJsonArray(jsonObject, "entryQuantity")) != null) {
            for (int i = 0; i < entryQuantityArray.size(); ++i) {
                if (((JsonValue)entryQuantityArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)entryQuantityArray.get(i)).getValueType() + " for element: entryQuantity");
                }
                builder.entryQuantity(this.parseQuantity("entryQuantity", entryQuantityArray.getJsonObject(i), i));
            }
        }
        builder.emptyReason(this.parseCodeableConcept("emptyReason", JsonSupport.getJsonValue(jsonObject, "emptyReason", JsonObject.class), -1));
        JsonArray sectionArray = JsonSupport.getJsonArray(jsonObject, "section");
        if (sectionArray != null) {
            for (int i = 0; i < sectionArray.size(); ++i) {
                if (((JsonValue)sectionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)sectionArray.get(i)).getValueType() + " for element: section");
                }
                builder.section(this.parseEvidenceReportSection("section", sectionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EvidenceReport.Subject parseEvidenceReportSubject(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceReport.Subject.class, jsonObject);
        }
        EvidenceReport.Subject.Builder builder = EvidenceReport.Subject.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray characteristicArray = JsonSupport.getJsonArray(jsonObject, "characteristic");
        if (characteristicArray != null) {
            for (int i = 0; i < characteristicArray.size(); ++i) {
                if (((JsonValue)characteristicArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)characteristicArray.get(i)).getValueType() + " for element: characteristic");
                }
                builder.characteristic(this.parseEvidenceReportSubjectCharacteristic("characteristic", characteristicArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EvidenceReport.Subject.Characteristic parseEvidenceReportSubjectCharacteristic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceReport.Subject.Characteristic.class, jsonObject);
        }
        EvidenceReport.Subject.Characteristic.Builder builder = EvidenceReport.Subject.Characteristic.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, Reference.class, CodeableConcept.class, Boolean.class, Quantity.class, Range.class));
        builder.exclude(this.parseBoolean("exclude", JsonSupport.getJsonValue(jsonObject, "exclude", JsonValue.class), (JsonValue)jsonObject.get((Object)"_exclude"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EvidenceVariable parseEvidenceVariable(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray useContextArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceVariable.class, jsonObject);
        }
        EvidenceVariable.Builder builder = EvidenceVariable.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.shortTitle(this.parseString("shortTitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "shortTitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_shortTitle"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext")) != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                if (((JsonValue)authorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)authorArray.get(i)).getValueType() + " for element: author");
                }
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                if (((JsonValue)editorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)editorArray.get(i)).getValueType() + " for element: editor");
                }
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                if (((JsonValue)reviewerArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reviewerArray.get(i)).getValueType() + " for element: reviewer");
                }
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                if (((JsonValue)endorserArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)endorserArray.get(i)).getValueType() + " for element: endorser");
                }
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                if (((JsonValue)relatedArtifactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArtifactArray.get(i)).getValueType() + " for element: relatedArtifact");
                }
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        builder.actual(this.parseBoolean("actual", JsonSupport.getJsonValue(jsonObject, "actual", JsonValue.class), (JsonValue)jsonObject.get((Object)"_actual"), -1));
        builder.characteristicCombination((CharacteristicCombination)this.parseString(CharacteristicCombination.builder(), "characteristicCombination", (JsonValue)JsonSupport.getJsonValue(jsonObject, "characteristicCombination", JsonString.class), (JsonValue)jsonObject.get((Object)"_characteristicCombination"), -1));
        JsonArray characteristicArray = JsonSupport.getJsonArray(jsonObject, "characteristic");
        if (characteristicArray != null) {
            for (int i = 0; i < characteristicArray.size(); ++i) {
                if (((JsonValue)characteristicArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)characteristicArray.get(i)).getValueType() + " for element: characteristic");
                }
                builder.characteristic(this.parseEvidenceVariableCharacteristic("characteristic", characteristicArray.getJsonObject(i), i));
            }
        }
        builder.handling((EvidenceVariableHandling)this.parseString(EvidenceVariableHandling.builder(), "handling", (JsonValue)JsonSupport.getJsonValue(jsonObject, "handling", JsonString.class), (JsonValue)jsonObject.get((Object)"_handling"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseEvidenceVariableCategory("category", categoryArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EvidenceVariable.Category parseEvidenceVariableCategory(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceVariable.Category.class, jsonObject);
        }
        EvidenceVariable.Category.Builder builder = EvidenceVariable.Category.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, CodeableConcept.class, Quantity.class, Range.class));
        this.stackPop();
        return builder.build();
    }

    private EvidenceVariable.Characteristic parseEvidenceVariableCharacteristic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceVariable.Characteristic.class, jsonObject);
        }
        EvidenceVariable.Characteristic.Builder builder = EvidenceVariable.Characteristic.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.definition(this.parseChoiceElement("definition", jsonObject, Reference.class, Canonical.class, CodeableConcept.class, Expression.class));
        builder.method(this.parseCodeableConcept("method", JsonSupport.getJsonValue(jsonObject, "method", JsonObject.class), -1));
        builder.device(this.parseReference("device", JsonSupport.getJsonValue(jsonObject, "device", JsonObject.class), -1));
        builder.exclude(this.parseBoolean("exclude", JsonSupport.getJsonValue(jsonObject, "exclude", JsonValue.class), (JsonValue)jsonObject.get((Object)"_exclude"), -1));
        builder.timeFromStart(this.parseEvidenceVariableCharacteristicTimeFromStart("timeFromStart", JsonSupport.getJsonValue(jsonObject, "timeFromStart", JsonObject.class), -1));
        builder.groupMeasure((GroupMeasure)this.parseString(GroupMeasure.builder(), "groupMeasure", (JsonValue)JsonSupport.getJsonValue(jsonObject, "groupMeasure", JsonString.class), (JsonValue)jsonObject.get((Object)"_groupMeasure"), -1));
        this.stackPop();
        return builder.build();
    }

    private EvidenceVariable.Characteristic.TimeFromStart parseEvidenceVariableCharacteristicTimeFromStart(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(EvidenceVariable.Characteristic.TimeFromStart.class, jsonObject);
        }
        EvidenceVariable.Characteristic.TimeFromStart.Builder builder = EvidenceVariable.Characteristic.TimeFromStart.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.quantity(this.parseQuantity("quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.range(this.parseRange("range", JsonSupport.getJsonValue(jsonObject, "range", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario parseExampleScenario(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray workflowArray;
        JsonArray processArray;
        JsonArray instanceArray;
        JsonArray jurisdictionArray;
        JsonArray useContextArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.class, jsonObject);
        }
        ExampleScenario.Builder builder = ExampleScenario.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        if ((useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext")) != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                if (((JsonValue)jurisdictionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        JsonArray actorArray = JsonSupport.getJsonArray(jsonObject, "actor");
        if (actorArray != null) {
            for (int i = 0; i < actorArray.size(); ++i) {
                if (((JsonValue)actorArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)actorArray.get(i)).getValueType() + " for element: actor");
                }
                builder.actor(this.parseExampleScenarioActor("actor", actorArray.getJsonObject(i), i));
            }
        }
        if ((instanceArray = JsonSupport.getJsonArray(jsonObject, "instance")) != null) {
            for (int i = 0; i < instanceArray.size(); ++i) {
                if (((JsonValue)instanceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)instanceArray.get(i)).getValueType() + " for element: instance");
                }
                builder.instance(this.parseExampleScenarioInstance("instance", instanceArray.getJsonObject(i), i));
            }
        }
        if ((processArray = JsonSupport.getJsonArray(jsonObject, "process")) != null) {
            for (int i = 0; i < processArray.size(); ++i) {
                if (((JsonValue)processArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)processArray.get(i)).getValueType() + " for element: process");
                }
                builder.process(this.parseExampleScenarioProcess("process", processArray.getJsonObject(i), i));
            }
        }
        if ((workflowArray = JsonSupport.getJsonArray(jsonObject, "workflow", true)) != null) {
            JsonArray _workflowArray = jsonObject.getJsonArray("_workflow");
            for (int i = 0; i < workflowArray.size(); ++i) {
                builder.workflow((Canonical)this.parseUri(Canonical.builder(), "workflow", (JsonValue)workflowArray.get(i), JsonSupport.getJsonValue(_workflowArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Actor parseExampleScenarioActor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Actor.class, jsonObject);
        }
        ExampleScenario.Actor.Builder builder = ExampleScenario.Actor.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.actorId(this.parseString("actorId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "actorId", JsonString.class), (JsonValue)jsonObject.get((Object)"_actorId"), -1));
        builder.type((ExampleScenarioActorType)this.parseString(ExampleScenarioActorType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Instance parseExampleScenarioInstance(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray containedInstanceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Instance.class, jsonObject);
        }
        ExampleScenario.Instance.Builder builder = ExampleScenario.Instance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.resourceId(this.parseString("resourceId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "resourceId", JsonString.class), (JsonValue)jsonObject.get((Object)"_resourceId"), -1));
        builder.resourceType((ResourceTypeCode)this.parseString(ResourceTypeCode.builder(), "resourceType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "resourceType", JsonString.class), (JsonValue)jsonObject.get((Object)"_resourceType"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray versionArray = JsonSupport.getJsonArray(jsonObject, "version");
        if (versionArray != null) {
            for (int i = 0; i < versionArray.size(); ++i) {
                if (((JsonValue)versionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)versionArray.get(i)).getValueType() + " for element: version");
                }
                builder.version(this.parseExampleScenarioInstanceVersion("version", versionArray.getJsonObject(i), i));
            }
        }
        if ((containedInstanceArray = JsonSupport.getJsonArray(jsonObject, "containedInstance")) != null) {
            for (int i = 0; i < containedInstanceArray.size(); ++i) {
                if (((JsonValue)containedInstanceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)containedInstanceArray.get(i)).getValueType() + " for element: containedInstance");
                }
                builder.containedInstance(this.parseExampleScenarioInstanceContainedInstance("containedInstance", containedInstanceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Instance.ContainedInstance parseExampleScenarioInstanceContainedInstance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Instance.ContainedInstance.class, jsonObject);
        }
        ExampleScenario.Instance.ContainedInstance.Builder builder = ExampleScenario.Instance.ContainedInstance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.resourceId(this.parseString("resourceId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "resourceId", JsonString.class), (JsonValue)jsonObject.get((Object)"_resourceId"), -1));
        builder.versionId(this.parseString("versionId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versionId", JsonString.class), (JsonValue)jsonObject.get((Object)"_versionId"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Instance.Version parseExampleScenarioInstanceVersion(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Instance.Version.class, jsonObject);
        }
        ExampleScenario.Instance.Version.Builder builder = ExampleScenario.Instance.Version.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.versionId(this.parseString("versionId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versionId", JsonString.class), (JsonValue)jsonObject.get((Object)"_versionId"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process parseExampleScenarioProcess(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.class, jsonObject);
        }
        ExampleScenario.Process.Builder builder = ExampleScenario.Process.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.preConditions((Markdown)this.parseString(Markdown.builder(), "preConditions", (JsonValue)JsonSupport.getJsonValue(jsonObject, "preConditions", JsonString.class), (JsonValue)jsonObject.get((Object)"_preConditions"), -1));
        builder.postConditions((Markdown)this.parseString(Markdown.builder(), "postConditions", (JsonValue)JsonSupport.getJsonValue(jsonObject, "postConditions", JsonString.class), (JsonValue)jsonObject.get((Object)"_postConditions"), -1));
        JsonArray stepArray = JsonSupport.getJsonArray(jsonObject, "step");
        if (stepArray != null) {
            for (int i = 0; i < stepArray.size(); ++i) {
                if (((JsonValue)stepArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)stepArray.get(i)).getValueType() + " for element: step");
                }
                builder.step(this.parseExampleScenarioProcessStep("step", stepArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process.Step parseExampleScenarioProcessStep(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.Step.class, jsonObject);
        }
        ExampleScenario.Process.Step.Builder builder = ExampleScenario.Process.Step.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray processArray = JsonSupport.getJsonArray(jsonObject, "process");
        if (processArray != null) {
            for (int i = 0; i < processArray.size(); ++i) {
                if (((JsonValue)processArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)processArray.get(i)).getValueType() + " for element: process");
                }
                builder.process(this.parseExampleScenarioProcess("process", processArray.getJsonObject(i), i));
            }
        }
        builder.pause(this.parseBoolean("pause", JsonSupport.getJsonValue(jsonObject, "pause", JsonValue.class), (JsonValue)jsonObject.get((Object)"_pause"), -1));
        builder.operation(this.parseExampleScenarioProcessStepOperation("operation", JsonSupport.getJsonValue(jsonObject, "operation", JsonObject.class), -1));
        JsonArray alternativeArray = JsonSupport.getJsonArray(jsonObject, "alternative");
        if (alternativeArray != null) {
            for (int i = 0; i < alternativeArray.size(); ++i) {
                if (((JsonValue)alternativeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)alternativeArray.get(i)).getValueType() + " for element: alternative");
                }
                builder.alternative(this.parseExampleScenarioProcessStepAlternative("alternative", alternativeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process.Step.Alternative parseExampleScenarioProcessStepAlternative(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.Step.Alternative.class, jsonObject);
        }
        ExampleScenario.Process.Step.Alternative.Builder builder = ExampleScenario.Process.Step.Alternative.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray stepArray = JsonSupport.getJsonArray(jsonObject, "step");
        if (stepArray != null) {
            for (int i = 0; i < stepArray.size(); ++i) {
                if (((JsonValue)stepArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)stepArray.get(i)).getValueType() + " for element: step");
                }
                builder.step(this.parseExampleScenarioProcessStep("step", stepArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process.Step.Operation parseExampleScenarioProcessStepOperation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.Step.Operation.class, jsonObject);
        }
        ExampleScenario.Process.Step.Operation.Builder builder = ExampleScenario.Process.Step.Operation.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.number(this.parseString("number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonString.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.type(this.parseString("type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.initiator(this.parseString("initiator", (JsonValue)JsonSupport.getJsonValue(jsonObject, "initiator", JsonString.class), (JsonValue)jsonObject.get((Object)"_initiator"), -1));
        builder.receiver(this.parseString("receiver", (JsonValue)JsonSupport.getJsonValue(jsonObject, "receiver", JsonString.class), (JsonValue)jsonObject.get((Object)"_receiver"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.initiatorActive(this.parseBoolean("initiatorActive", JsonSupport.getJsonValue(jsonObject, "initiatorActive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_initiatorActive"), -1));
        builder.receiverActive(this.parseBoolean("receiverActive", JsonSupport.getJsonValue(jsonObject, "receiverActive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_receiverActive"), -1));
        builder.request(this.parseExampleScenarioInstanceContainedInstance("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.response(this.parseExampleScenarioInstanceContainedInstance("response", JsonSupport.getJsonValue(jsonObject, "response", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit parseExplanationOfBenefit(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray totalArray;
        JsonArray adjudicationArray;
        JsonArray addItemArray;
        JsonArray procedureArray;
        JsonArray diagnosisArray;
        JsonArray supportingInfoArray;
        JsonArray careTeamArray;
        JsonArray preAuthRefPeriodArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.class, jsonObject);
        }
        ExplanationOfBenefit.Builder builder = ExplanationOfBenefit.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((ExplanationOfBenefitStatus)this.parseString(ExplanationOfBenefitStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.use((Use)this.parseString(Use.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.billablePeriod(this.parsePeriod("billablePeriod", JsonSupport.getJsonValue(jsonObject, "billablePeriod", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.fundsReserveRequested(this.parseCodeableConcept("fundsReserveRequested", JsonSupport.getJsonValue(jsonObject, "fundsReserveRequested", JsonObject.class), -1));
        builder.fundsReserve(this.parseCodeableConcept("fundsReserve", JsonSupport.getJsonValue(jsonObject, "fundsReserve", JsonObject.class), -1));
        JsonArray relatedArray = JsonSupport.getJsonArray(jsonObject, "related");
        if (relatedArray != null) {
            for (int i3 = 0; i3 < relatedArray.size(); ++i3) {
                if (((JsonValue)relatedArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)relatedArray.get(i3)).getValueType() + " for element: related");
                }
                builder.related(this.parseExplanationOfBenefitRelated("related", relatedArray.getJsonObject(i3), i3));
            }
        }
        builder.prescription(this.parseReference("prescription", JsonSupport.getJsonValue(jsonObject, "prescription", JsonObject.class), -1));
        builder.originalPrescription(this.parseReference("originalPrescription", JsonSupport.getJsonValue(jsonObject, "originalPrescription", JsonObject.class), -1));
        builder.payee(this.parseExplanationOfBenefitPayee("payee", JsonSupport.getJsonValue(jsonObject, "payee", JsonObject.class), -1));
        builder.referral(this.parseReference("referral", JsonSupport.getJsonValue(jsonObject, "referral", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        builder.claim(this.parseReference("claim", JsonSupport.getJsonValue(jsonObject, "claim", JsonObject.class), -1));
        builder.claimResponse(this.parseReference("claimResponse", JsonSupport.getJsonValue(jsonObject, "claimResponse", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        JsonArray preAuthRefArray = JsonSupport.getJsonArray(jsonObject, "preAuthRef", true);
        if (preAuthRefArray != null) {
            JsonArray _preAuthRefArray = jsonObject.getJsonArray("_preAuthRef");
            for (i = 0; i < preAuthRefArray.size(); ++i) {
                builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)preAuthRefArray.get(i), JsonSupport.getJsonValue(_preAuthRefArray, i), i));
            }
        }
        if ((preAuthRefPeriodArray = JsonSupport.getJsonArray(jsonObject, "preAuthRefPeriod")) != null) {
            for (i = 0; i < preAuthRefPeriodArray.size(); ++i) {
                if (((JsonValue)preAuthRefPeriodArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)preAuthRefPeriodArray.get(i)).getValueType() + " for element: preAuthRefPeriod");
                }
                builder.preAuthRefPeriod(this.parsePeriod("preAuthRefPeriod", preAuthRefPeriodArray.getJsonObject(i), i));
            }
        }
        if ((careTeamArray = JsonSupport.getJsonArray(jsonObject, "careTeam")) != null) {
            for (int i4 = 0; i4 < careTeamArray.size(); ++i4) {
                if (((JsonValue)careTeamArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)careTeamArray.get(i4)).getValueType() + " for element: careTeam");
                }
                builder.careTeam(this.parseExplanationOfBenefitCareTeam("careTeam", careTeamArray.getJsonObject(i4), i4));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i5 = 0; i5 < supportingInfoArray.size(); ++i5) {
                if (((JsonValue)supportingInfoArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)supportingInfoArray.get(i5)).getValueType() + " for element: supportingInfo");
                }
                builder.supportingInfo(this.parseExplanationOfBenefitSupportingInfo("supportingInfo", supportingInfoArray.getJsonObject(i5), i5));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i6 = 0; i6 < diagnosisArray.size(); ++i6) {
                if (((JsonValue)diagnosisArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)diagnosisArray.get(i6)).getValueType() + " for element: diagnosis");
                }
                builder.diagnosis(this.parseExplanationOfBenefitDiagnosis("diagnosis", diagnosisArray.getJsonObject(i6), i6));
            }
        }
        if ((procedureArray = JsonSupport.getJsonArray(jsonObject, "procedure")) != null) {
            for (int i7 = 0; i7 < procedureArray.size(); ++i7) {
                if (((JsonValue)procedureArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)procedureArray.get(i7)).getValueType() + " for element: procedure");
                }
                builder.procedure(this.parseExplanationOfBenefitProcedure("procedure", procedureArray.getJsonObject(i7), i7));
            }
        }
        builder.precedence((PositiveInt)this.parseInteger(PositiveInt.builder(), "precedence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "precedence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_precedence"), -1));
        JsonArray insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance");
        if (insuranceArray != null) {
            for (int i8 = 0; i8 < insuranceArray.size(); ++i8) {
                if (((JsonValue)insuranceArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)insuranceArray.get(i8)).getValueType() + " for element: insurance");
                }
                builder.insurance(this.parseExplanationOfBenefitInsurance("insurance", insuranceArray.getJsonObject(i8), i8));
            }
        }
        builder.accident(this.parseExplanationOfBenefitAccident("accident", JsonSupport.getJsonValue(jsonObject, "accident", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i9 = 0; i9 < itemArray.size(); ++i9) {
                if (((JsonValue)itemArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)itemArray.get(i9)).getValueType() + " for element: item");
                }
                builder.item(this.parseExplanationOfBenefitItem("item", itemArray.getJsonObject(i9), i9));
            }
        }
        if ((addItemArray = JsonSupport.getJsonArray(jsonObject, "addItem")) != null) {
            for (int i10 = 0; i10 < addItemArray.size(); ++i10) {
                if (((JsonValue)addItemArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)addItemArray.get(i10)).getValueType() + " for element: addItem");
                }
                builder.addItem(this.parseExplanationOfBenefitAddItem("addItem", addItemArray.getJsonObject(i10), i10));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (int i11 = 0; i11 < adjudicationArray.size(); ++i11) {
                if (((JsonValue)adjudicationArray.get(i11)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i11)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i11), i11));
            }
        }
        if ((totalArray = JsonSupport.getJsonArray(jsonObject, "total")) != null) {
            for (int i12 = 0; i12 < totalArray.size(); ++i12) {
                if (((JsonValue)totalArray.get(i12)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)totalArray.get(i12)).getValueType() + " for element: total");
                }
                builder.total(this.parseExplanationOfBenefitTotal("total", totalArray.getJsonObject(i12), i12));
            }
        }
        builder.payment(this.parseExplanationOfBenefitPayment("payment", JsonSupport.getJsonValue(jsonObject, "payment", JsonObject.class), -1));
        builder.formCode(this.parseCodeableConcept("formCode", JsonSupport.getJsonValue(jsonObject, "formCode", JsonObject.class), -1));
        builder.form(this.parseAttachment("form", JsonSupport.getJsonValue(jsonObject, "form", JsonObject.class), -1));
        JsonArray processNoteArray = JsonSupport.getJsonArray(jsonObject, "processNote");
        if (processNoteArray != null) {
            for (int i13 = 0; i13 < processNoteArray.size(); ++i13) {
                if (((JsonValue)processNoteArray.get(i13)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)processNoteArray.get(i13)).getValueType() + " for element: processNote");
                }
                builder.processNote(this.parseExplanationOfBenefitProcessNote("processNote", processNoteArray.getJsonObject(i13), i13));
            }
        }
        builder.benefitPeriod(this.parsePeriod("benefitPeriod", JsonSupport.getJsonValue(jsonObject, "benefitPeriod", JsonObject.class), -1));
        JsonArray benefitBalanceArray = JsonSupport.getJsonArray(jsonObject, "benefitBalance");
        if (benefitBalanceArray != null) {
            for (int i14 = 0; i14 < benefitBalanceArray.size(); ++i14) {
                if (((JsonValue)benefitBalanceArray.get(i14)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)benefitBalanceArray.get(i14)).getValueType() + " for element: benefitBalance");
                }
                builder.benefitBalance(this.parseExplanationOfBenefitBenefitBalance("benefitBalance", benefitBalanceArray.getJsonObject(i14), i14));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Accident parseExplanationOfBenefitAccident(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Accident.class, jsonObject);
        }
        ExplanationOfBenefit.Accident.Builder builder = ExplanationOfBenefit.Accident.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.location(this.parseChoiceElement("location", jsonObject, Address.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.AddItem parseExplanationOfBenefitAddItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        JsonArray providerArray;
        int i2;
        JsonArray subDetailSequenceArray;
        JsonArray detailSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.AddItem.class, jsonObject);
        }
        ExplanationOfBenefit.AddItem.Builder builder = ExplanationOfBenefit.AddItem.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        JsonArray itemSequenceArray = JsonSupport.getJsonArray(jsonObject, "itemSequence", true);
        if (itemSequenceArray != null) {
            JsonArray _itemSequenceArray = jsonObject.getJsonArray("_itemSequence");
            for (int i3 = 0; i3 < itemSequenceArray.size(); ++i3) {
                builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)itemSequenceArray.get(i3), JsonSupport.getJsonValue(_itemSequenceArray, i3), i3));
            }
        }
        if ((detailSequenceArray = JsonSupport.getJsonArray(jsonObject, "detailSequence", true)) != null) {
            JsonArray _detailSequenceArray = jsonObject.getJsonArray("_detailSequence");
            for (int i4 = 0; i4 < detailSequenceArray.size(); ++i4) {
                builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)detailSequenceArray.get(i4), JsonSupport.getJsonValue(_detailSequenceArray, i4), i4));
            }
        }
        if ((subDetailSequenceArray = JsonSupport.getJsonArray(jsonObject, "subDetailSequence", true)) != null) {
            JsonArray _subDetailSequenceArray = jsonObject.getJsonArray("_subDetailSequence");
            for (i2 = 0; i2 < subDetailSequenceArray.size(); ++i2) {
                builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", (JsonValue)subDetailSequenceArray.get(i2), JsonSupport.getJsonValue(_subDetailSequenceArray, i2), i2));
            }
        }
        if ((providerArray = JsonSupport.getJsonArray(jsonObject, "provider")) != null) {
            for (i2 = 0; i2 < providerArray.size(); ++i2) {
                if (((JsonValue)providerArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)providerArray.get(i2)).getValueType() + " for element: provider");
                }
                builder.provider(this.parseReference("provider", providerArray.getJsonObject(i2), i2));
            }
        }
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i5 = 0; i5 < modifierArray.size(); ++i5) {
                if (((JsonValue)modifierArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i5)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i5), i5));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i6 = 0; i6 < programCodeArray.size(); ++i6) {
                if (((JsonValue)programCodeArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i6)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i6), i6));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i7 = 0; i7 < subSiteArray.size(); ++i7) {
                if (((JsonValue)subSiteArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subSiteArray.get(i7)).getValueType() + " for element: subSite");
                }
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i7), i7));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i8 = 0; i8 < detailArray.size(); ++i8) {
                if (((JsonValue)detailArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i8)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseExplanationOfBenefitAddItemDetail("detail", detailArray.getJsonObject(i8), i8));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.AddItem.Detail parseExplanationOfBenefitAddItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.AddItem.Detail.class, jsonObject);
        }
        ExplanationOfBenefit.AddItem.Detail.Builder builder = ExplanationOfBenefit.AddItem.Detail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                if (((JsonValue)modifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i2)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i3 = 0; i3 < subDetailArray.size(); ++i3) {
                if (((JsonValue)subDetailArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subDetailArray.get(i3)).getValueType() + " for element: subDetail");
                }
                builder.subDetail(this.parseExplanationOfBenefitAddItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.AddItem.Detail.SubDetail parseExplanationOfBenefitAddItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.AddItem.Detail.SubDetail.class, jsonObject);
        }
        ExplanationOfBenefit.AddItem.Detail.SubDetail.Builder builder = ExplanationOfBenefit.AddItem.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                if (((JsonValue)modifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i2)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.BenefitBalance parseExplanationOfBenefitBenefitBalance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.BenefitBalance.class, jsonObject);
        }
        ExplanationOfBenefit.BenefitBalance.Builder builder = ExplanationOfBenefit.BenefitBalance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.excluded(this.parseBoolean("excluded", JsonSupport.getJsonValue(jsonObject, "excluded", JsonValue.class), (JsonValue)jsonObject.get((Object)"_excluded"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.network(this.parseCodeableConcept("network", JsonSupport.getJsonValue(jsonObject, "network", JsonObject.class), -1));
        builder.unit(this.parseCodeableConcept("unit", JsonSupport.getJsonValue(jsonObject, "unit", JsonObject.class), -1));
        builder.term(this.parseCodeableConcept("term", JsonSupport.getJsonValue(jsonObject, "term", JsonObject.class), -1));
        JsonArray financialArray = JsonSupport.getJsonArray(jsonObject, "financial");
        if (financialArray != null) {
            for (int i = 0; i < financialArray.size(); ++i) {
                if (((JsonValue)financialArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)financialArray.get(i)).getValueType() + " for element: financial");
                }
                builder.financial(this.parseExplanationOfBenefitBenefitBalanceFinancial("financial", financialArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.BenefitBalance.Financial parseExplanationOfBenefitBenefitBalanceFinancial(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.BenefitBalance.Financial.class, jsonObject);
        }
        ExplanationOfBenefit.BenefitBalance.Financial.Builder builder = ExplanationOfBenefit.BenefitBalance.Financial.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.allowed(this.parseChoiceElement("allowed", jsonObject, UnsignedInt.class, org.linuxforhealth.fhir.model.type.String.class, Money.class));
        builder.used(this.parseChoiceElement("used", jsonObject, UnsignedInt.class, Money.class));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.CareTeam parseExplanationOfBenefitCareTeam(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.CareTeam.class, jsonObject);
        }
        ExplanationOfBenefit.CareTeam.Builder builder = ExplanationOfBenefit.CareTeam.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.responsible(this.parseBoolean("responsible", JsonSupport.getJsonValue(jsonObject, "responsible", JsonValue.class), (JsonValue)jsonObject.get((Object)"_responsible"), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.qualification(this.parseCodeableConcept("qualification", JsonSupport.getJsonValue(jsonObject, "qualification", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Diagnosis parseExplanationOfBenefitDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Diagnosis.class, jsonObject);
        }
        ExplanationOfBenefit.Diagnosis.Builder builder = ExplanationOfBenefit.Diagnosis.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.diagnosis(this.parseChoiceElement("diagnosis", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.onAdmission(this.parseCodeableConcept("onAdmission", JsonSupport.getJsonValue(jsonObject, "onAdmission", JsonObject.class), -1));
        builder.packageCode(this.parseCodeableConcept("packageCode", JsonSupport.getJsonValue(jsonObject, "packageCode", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Insurance parseExplanationOfBenefitInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Insurance.class, jsonObject);
        }
        ExplanationOfBenefit.Insurance.Builder builder = ExplanationOfBenefit.Insurance.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        JsonArray preAuthRefArray = JsonSupport.getJsonArray(jsonObject, "preAuthRef", true);
        if (preAuthRefArray != null) {
            JsonArray _preAuthRefArray = jsonObject.getJsonArray("_preAuthRef");
            for (int i = 0; i < preAuthRefArray.size(); ++i) {
                builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)preAuthRefArray.get(i), JsonSupport.getJsonValue(_preAuthRefArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item parseExplanationOfBenefitItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray encounterArray;
        JsonArray programCodeArray;
        int i2;
        JsonArray informationSequenceArray;
        JsonArray procedureSequenceArray;
        JsonArray diagnosisSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Builder builder = ExplanationOfBenefit.Item.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray careTeamSequenceArray = JsonSupport.getJsonArray(jsonObject, "careTeamSequence", true);
        if (careTeamSequenceArray != null) {
            JsonArray _careTeamSequenceArray = jsonObject.getJsonArray("_careTeamSequence");
            for (int i3 = 0; i3 < careTeamSequenceArray.size(); ++i3) {
                builder.careTeamSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "careTeamSequence", (JsonValue)careTeamSequenceArray.get(i3), JsonSupport.getJsonValue(_careTeamSequenceArray, i3), i3));
            }
        }
        if ((diagnosisSequenceArray = JsonSupport.getJsonArray(jsonObject, "diagnosisSequence", true)) != null) {
            JsonArray _diagnosisSequenceArray = jsonObject.getJsonArray("_diagnosisSequence");
            for (int i4 = 0; i4 < diagnosisSequenceArray.size(); ++i4) {
                builder.diagnosisSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "diagnosisSequence", (JsonValue)diagnosisSequenceArray.get(i4), JsonSupport.getJsonValue(_diagnosisSequenceArray, i4), i4));
            }
        }
        if ((procedureSequenceArray = JsonSupport.getJsonArray(jsonObject, "procedureSequence", true)) != null) {
            JsonArray _procedureSequenceArray = jsonObject.getJsonArray("_procedureSequence");
            for (int i5 = 0; i5 < procedureSequenceArray.size(); ++i5) {
                builder.procedureSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "procedureSequence", (JsonValue)procedureSequenceArray.get(i5), JsonSupport.getJsonValue(_procedureSequenceArray, i5), i5));
            }
        }
        if ((informationSequenceArray = JsonSupport.getJsonArray(jsonObject, "informationSequence", true)) != null) {
            JsonArray _informationSequenceArray = jsonObject.getJsonArray("_informationSequence");
            for (i2 = 0; i2 < informationSequenceArray.size(); ++i2) {
                builder.informationSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "informationSequence", (JsonValue)informationSequenceArray.get(i2), JsonSupport.getJsonValue(_informationSequenceArray, i2), i2));
            }
        }
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (i2 = 0; i2 < modifierArray.size(); ++i2) {
                if (((JsonValue)modifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i2)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i6 = 0; i6 < programCodeArray.size(); ++i6) {
                if (((JsonValue)programCodeArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i6)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i6), i6));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i7 = 0; i7 < udiArray.size(); ++i7) {
                if (((JsonValue)udiArray.get(i7)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i7)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i7), i7));
            }
        }
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i8 = 0; i8 < subSiteArray.size(); ++i8) {
                if (((JsonValue)subSiteArray.get(i8)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subSiteArray.get(i8)).getValueType() + " for element: subSite");
                }
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i8), i8));
            }
        }
        if ((encounterArray = JsonSupport.getJsonArray(jsonObject, "encounter")) != null) {
            for (int i9 = 0; i9 < encounterArray.size(); ++i9) {
                if (((JsonValue)encounterArray.get(i9)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)encounterArray.get(i9)).getValueType() + " for element: encounter");
                }
                builder.encounter(this.parseReference("encounter", encounterArray.getJsonObject(i9), i9));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i10 = 0; i10 < detailArray.size(); ++i10) {
                if (((JsonValue)detailArray.get(i10)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)detailArray.get(i10)).getValueType() + " for element: detail");
                }
                builder.detail(this.parseExplanationOfBenefitItemDetail("detail", detailArray.getJsonObject(i10), i10));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item.Adjudication parseExplanationOfBenefitItemAdjudication(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.Adjudication.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Adjudication.Builder builder = ExplanationOfBenefit.Item.Adjudication.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.reason(this.parseCodeableConcept("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.value(this.parseDecimal("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item.Detail parseExplanationOfBenefitItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.Detail.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Detail.Builder builder = ExplanationOfBenefit.Item.Detail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                if (((JsonValue)modifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i2)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i3 = 0; i3 < programCodeArray.size(); ++i3) {
                if (((JsonValue)programCodeArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i3)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i3), i3));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i4 = 0; i4 < udiArray.size(); ++i4) {
                if (((JsonValue)udiArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i4)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i4), i4));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i5 = 0; i5 < subDetailArray.size(); ++i5) {
                if (((JsonValue)subDetailArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)subDetailArray.get(i5)).getValueType() + " for element: subDetail");
                }
                builder.subDetail(this.parseExplanationOfBenefitItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i5), i5));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item.Detail.SubDetail parseExplanationOfBenefitItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.Detail.SubDetail.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Detail.SubDetail.Builder builder = ExplanationOfBenefit.Item.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                if (((JsonValue)modifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)modifierArray.get(i2)).getValueType() + " for element: modifier");
                }
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i3 = 0; i3 < programCodeArray.size(); ++i3) {
                if (((JsonValue)programCodeArray.get(i3)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)programCodeArray.get(i3)).getValueType() + " for element: programCode");
                }
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i3), i3));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i4 = 0; i4 < udiArray.size(); ++i4) {
                if (((JsonValue)udiArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i4)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i4), i4));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                if (((JsonValue)adjudicationArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)adjudicationArray.get(i)).getValueType() + " for element: adjudication");
                }
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Payee parseExplanationOfBenefitPayee(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Payee.class, jsonObject);
        }
        ExplanationOfBenefit.Payee.Builder builder = ExplanationOfBenefit.Payee.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Payment parseExplanationOfBenefitPayment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Payment.class, jsonObject);
        }
        ExplanationOfBenefit.Payment.Builder builder = ExplanationOfBenefit.Payment.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.adjustment(this.parseMoney("adjustment", JsonSupport.getJsonValue(jsonObject, "adjustment", JsonObject.class), -1));
        builder.adjustmentReason(this.parseCodeableConcept("adjustmentReason", JsonSupport.getJsonValue(jsonObject, "adjustmentReason", JsonObject.class), -1));
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Procedure parseExplanationOfBenefitProcedure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Procedure.class, jsonObject);
        }
        ExplanationOfBenefit.Procedure.Builder builder = ExplanationOfBenefit.Procedure.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                if (((JsonValue)typeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)typeArray.get(i)).getValueType() + " for element: type");
                }
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.procedure(this.parseChoiceElement("procedure", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                if (((JsonValue)udiArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)udiArray.get(i)).getValueType() + " for element: udi");
                }
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.ProcessNote parseExplanationOfBenefitProcessNote(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.ProcessNote.class, jsonObject);
        }
        ExplanationOfBenefit.ProcessNote.Builder builder = ExplanationOfBenefit.ProcessNote.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.number((PositiveInt)this.parseInteger(PositiveInt.builder(), "number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.type((NoteType)this.parseString(NoteType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        builder.language(this.parseCodeableConcept("language", JsonSupport.getJsonValue(jsonObject, "language", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Related parseExplanationOfBenefitRelated(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Related.class, jsonObject);
        }
        ExplanationOfBenefit.Related.Builder builder = ExplanationOfBenefit.Related.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.claim(this.parseReference("claim", JsonSupport.getJsonValue(jsonObject, "claim", JsonObject.class), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.reference(this.parseIdentifier("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.SupportingInfo parseExplanationOfBenefitSupportingInfo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.SupportingInfo.class, jsonObject);
        }
        ExplanationOfBenefit.SupportingInfo.Builder builder = ExplanationOfBenefit.SupportingInfo.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.timing(this.parseChoiceElement("timing", jsonObject, Date.class, Period.class));
        builder.value(this.parseChoiceElement("value", jsonObject, Boolean.class, org.linuxforhealth.fhir.model.type.String.class, Quantity.class, Attachment.class, Reference.class));
        builder.reason(this.parseCoding("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Total parseExplanationOfBenefitTotal(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Total.class, jsonObject);
        }
        ExplanationOfBenefit.Total.Builder builder = ExplanationOfBenefit.Total.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Expression parseExpression(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Expression.class, jsonObject);
        }
        Expression.Builder builder = Expression.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.name((Id)this.parseString(Id.builder(), "name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        builder.reference(this.parseUri("reference", (JsonValue)JsonSupport.getJsonValue(jsonObject, "reference", JsonString.class), (JsonValue)jsonObject.get((Object)"_reference"), -1));
        this.stackPop();
        return builder.build();
    }

    private Extension parseExtension(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Extension.class, jsonObject);
        }
        Extension.Builder builder = Extension.builder();
        builder.setValidating(this.validating);
        this.parseElement(builder, jsonObject);
        builder.url(this.parseJavaString("url", JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, org.linuxforhealth.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class));
        this.stackPop();
        return builder.build();
    }

    private FamilyMemberHistory parseFamilyMemberHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray conditionArray;
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(FamilyMemberHistory.class, jsonObject);
        }
        FamilyMemberHistory.Builder builder = FamilyMemberHistory.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                if (((JsonValue)identifierArray.get(i2)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i2)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        builder.status((FamilyHistoryStatus)this.parseString(FamilyHistoryStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.dataAbsentReason(this.parseCodeableConcept("dataAbsentReason", JsonSupport.getJsonValue(jsonObject, "dataAbsentReason", JsonObject.class), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.sex(this.parseCodeableConcept("sex", JsonSupport.getJsonValue(jsonObject, "sex", JsonObject.class), -1));
        builder.born(this.parseChoiceElement("born", jsonObject, Period.class, Date.class, org.linuxforhealth.fhir.model.type.String.class));
        builder.age(this.parseChoiceElement("age", jsonObject, Age.class, Range.class, org.linuxforhealth.fhir.model.type.String.class));
        builder.estimatedAge(this.parseBoolean("estimatedAge", JsonSupport.getJsonValue(jsonObject, "estimatedAge", JsonValue.class), (JsonValue)jsonObject.get((Object)"_estimatedAge"), -1));
        builder.deceased(this.parseChoiceElement("deceased", jsonObject, Boolean.class, Age.class, Range.class, Date.class, org.linuxforhealth.fhir.model.type.String.class));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (i = 0; i < reasonCodeArray.size(); ++i) {
                if (((JsonValue)reasonCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonCodeArray.get(i)).getValueType() + " for element: reasonCode");
                }
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i4 = 0; i4 < reasonReferenceArray.size(); ++i4) {
                if (((JsonValue)reasonReferenceArray.get(i4)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)reasonReferenceArray.get(i4)).getValueType() + " for element: reasonReference");
                }
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i4), i4));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i5 = 0; i5 < noteArray.size(); ++i5) {
                if (((JsonValue)noteArray.get(i5)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i5)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i5), i5));
            }
        }
        if ((conditionArray = JsonSupport.getJsonArray(jsonObject, "condition")) != null) {
            for (int i6 = 0; i6 < conditionArray.size(); ++i6) {
                if (((JsonValue)conditionArray.get(i6)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)conditionArray.get(i6)).getValueType() + " for element: condition");
                }
                builder.condition(this.parseFamilyMemberHistoryCondition("condition", conditionArray.getJsonObject(i6), i6));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private FamilyMemberHistory.Condition parseFamilyMemberHistoryCondition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(FamilyMemberHistory.Condition.class, jsonObject);
        }
        FamilyMemberHistory.Condition.Builder builder = FamilyMemberHistory.Condition.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.outcome(this.parseCodeableConcept("outcome", JsonSupport.getJsonValue(jsonObject, "outcome", JsonObject.class), -1));
        builder.contributedToDeath(this.parseBoolean("contributedToDeath", JsonSupport.getJsonValue(jsonObject, "contributedToDeath", JsonValue.class), (JsonValue)jsonObject.get((Object)"_contributedToDeath"), -1));
        builder.onset(this.parseChoiceElement("onset", jsonObject, Age.class, Range.class, Period.class, org.linuxforhealth.fhir.model.type.String.class));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Flag parseFlag(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Flag.class, jsonObject);
        }
        Flag.Builder builder = Flag.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((FlagStatus)this.parseString(FlagStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Goal parseGoal(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray outcomeReferenceArray;
        JsonArray outcomeCodeArray;
        JsonArray noteArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Goal.class, jsonObject);
        }
        Goal.Builder builder = Goal.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.lifecycleStatus((GoalLifecycleStatus)this.parseString(GoalLifecycleStatus.builder(), "lifecycleStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lifecycleStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_lifecycleStatus"), -1));
        builder.achievementStatus(this.parseCodeableConcept("achievementStatus", JsonSupport.getJsonValue(jsonObject, "achievementStatus", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                if (((JsonValue)categoryArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)categoryArray.get(i)).getValueType() + " for element: category");
                }
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.description(this.parseCodeableConcept("description", JsonSupport.getJsonValue(jsonObject, "description", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.start(this.parseChoiceElement("start", jsonObject, Date.class, CodeableConcept.class));
        JsonArray targetArray = JsonSupport.getJsonArray(jsonObject, "target");
        if (targetArray != null) {
            for (int i = 0; i < targetArray.size(); ++i) {
                if (((JsonValue)targetArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)targetArray.get(i)).getValueType() + " for element: target");
                }
                builder.target(this.parseGoalTarget("target", targetArray.getJsonObject(i), i));
            }
        }
        builder.statusDate(this.parseDate("statusDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "statusDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_statusDate"), -1));
        builder.statusReason(this.parseString("statusReason", (JsonValue)JsonSupport.getJsonValue(jsonObject, "statusReason", JsonString.class), (JsonValue)jsonObject.get((Object)"_statusReason"), -1));
        builder.expressedBy(this.parseReference("expressedBy", JsonSupport.getJsonValue(jsonObject, "expressedBy", JsonObject.class), -1));
        JsonArray addressesArray = JsonSupport.getJsonArray(jsonObject, "addresses");
        if (addressesArray != null) {
            for (int i = 0; i < addressesArray.size(); ++i) {
                if (((JsonValue)addressesArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)addressesArray.get(i)).getValueType() + " for element: addresses");
                }
                builder.addresses(this.parseReference("addresses", addressesArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                if (((JsonValue)noteArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)noteArray.get(i)).getValueType() + " for element: note");
                }
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((outcomeCodeArray = JsonSupport.getJsonArray(jsonObject, "outcomeCode")) != null) {
            for (int i = 0; i < outcomeCodeArray.size(); ++i) {
                if (((JsonValue)outcomeCodeArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)outcomeCodeArray.get(i)).getValueType() + " for element: outcomeCode");
                }
                builder.outcomeCode(this.parseCodeableConcept("outcomeCode", outcomeCodeArray.getJsonObject(i), i));
            }
        }
        if ((outcomeReferenceArray = JsonSupport.getJsonArray(jsonObject, "outcomeReference")) != null) {
            for (int i = 0; i < outcomeReferenceArray.size(); ++i) {
                if (((JsonValue)outcomeReferenceArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)outcomeReferenceArray.get(i)).getValueType() + " for element: outcomeReference");
                }
                builder.outcomeReference(this.parseReference("outcomeReference", outcomeReferenceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Goal.Target parseGoalTarget(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Goal.Target.class, jsonObject);
        }
        Goal.Target.Builder builder = Goal.Target.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.measure(this.parseCodeableConcept("measure", JsonSupport.getJsonValue(jsonObject, "measure", JsonObject.class), -1));
        builder.detail(this.parseChoiceElement("detail", jsonObject, Quantity.class, Range.class, CodeableConcept.class, org.linuxforhealth.fhir.model.type.String.class, Boolean.class, Integer.class, Ratio.class));
        builder.due(this.parseChoiceElement("due", jsonObject, Date.class, Duration.class));
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition parseGraphDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.class, jsonObject);
        }
        GraphDefinition.Builder builder = GraphDefinition.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                if (((JsonValue)contactArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)contactArray.get(i)).getValueType() + " for element: contact");
                }
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                if (((JsonValue)useContextArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)useContextArray.get(i)).getValueType() + " for element: useContext");
                }
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                if (((JsonValue)jurisdictionArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)jurisdictionArray.get(i)).getValueType() + " for element: jurisdiction");
                }
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.start((ResourceTypeCode)this.parseString(ResourceTypeCode.builder(), "start", (JsonValue)JsonSupport.getJsonValue(jsonObject, "start", JsonString.class), (JsonValue)jsonObject.get((Object)"_start"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        JsonArray linkArray = JsonSupport.getJsonArray(jsonObject, "link");
        if (linkArray != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                if (((JsonValue)linkArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)linkArray.get(i)).getValueType() + " for element: link");
                }
                builder.link(this.parseGraphDefinitionLink("link", linkArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition.Link parseGraphDefinitionLink(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.Link.class, jsonObject);
        }
        GraphDefinition.Link.Builder builder = GraphDefinition.Link.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.sliceName(this.parseString("sliceName", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sliceName", JsonString.class), (JsonValue)jsonObject.get((Object)"_sliceName"), -1));
        builder.min(this.parseInteger("min", (JsonValue)JsonSupport.getJsonValue(jsonObject, "min", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_min"), -1));
        builder.max(this.parseString("max", (JsonValue)JsonSupport.getJsonValue(jsonObject, "max", JsonString.class), (JsonValue)jsonObject.get((Object)"_max"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray targetArray = JsonSupport.getJsonArray(jsonObject, "target");
        if (targetArray != null) {
            for (int i = 0; i < targetArray.size(); ++i) {
                if (((JsonValue)targetArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)targetArray.get(i)).getValueType() + " for element: target");
                }
                builder.target(this.parseGraphDefinitionLinkTarget("target", targetArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition.Link.Target parseGraphDefinitionLinkTarget(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray linkArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.Link.Target.class, jsonObject);
        }
        GraphDefinition.Link.Target.Builder builder = GraphDefinition.Link.Target.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ResourceTypeCode)this.parseString(ResourceTypeCode.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.params(this.parseString("params", (JsonValue)JsonSupport.getJsonValue(jsonObject, "params", JsonString.class), (JsonValue)jsonObject.get((Object)"_params"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        JsonArray compartmentArray = JsonSupport.getJsonArray(jsonObject, "compartment");
        if (compartmentArray != null) {
            for (int i = 0; i < compartmentArray.size(); ++i) {
                if (((JsonValue)compartmentArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)compartmentArray.get(i)).getValueType() + " for element: compartment");
                }
                builder.compartment(this.parseGraphDefinitionLinkTargetCompartment("compartment", compartmentArray.getJsonObject(i), i));
            }
        }
        if ((linkArray = JsonSupport.getJsonArray(jsonObject, "link")) != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                if (((JsonValue)linkArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)linkArray.get(i)).getValueType() + " for element: link");
                }
                builder.link(this.parseGraphDefinitionLink("link", linkArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition.Link.Target.Compartment parseGraphDefinitionLinkTargetCompartment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.Link.Target.Compartment.class, jsonObject);
        }
        GraphDefinition.Link.Target.Compartment.Builder builder = GraphDefinition.Link.Target.Compartment.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.use((GraphCompartmentUse)this.parseString(GraphCompartmentUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.code((CompartmentCode)this.parseString(CompartmentCode.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.rule((GraphCompartmentRule)this.parseString(GraphCompartmentRule.builder(), "rule", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rule", JsonString.class), (JsonValue)jsonObject.get((Object)"_rule"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private Group parseGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray memberArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Group.class, jsonObject);
        }
        Group.Builder builder = Group.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.active(this.parseBoolean("active", JsonSupport.getJsonValue(jsonObject, "active", JsonValue.class), (JsonValue)jsonObject.get((Object)"_active"), -1));
        builder.type((GroupType)this.parseString(GroupType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.actual(this.parseBoolean("actual", JsonSupport.getJsonValue(jsonObject, "actual", JsonValue.class), (JsonValue)jsonObject.get((Object)"_actual"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.quantity((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "quantity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "quantity", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_quantity"), -1));
        builder.managingEntity(this.parseReference("managingEntity", JsonSupport.getJsonValue(jsonObject, "managingEntity", JsonObject.class), -1));
        JsonArray characteristicArray = JsonSupport.getJsonArray(jsonObject, "characteristic");
        if (characteristicArray != null) {
            for (int i = 0; i < characteristicArray.size(); ++i) {
                if (((JsonValue)characteristicArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)characteristicArray.get(i)).getValueType() + " for element: characteristic");
                }
                builder.characteristic(this.parseGroupCharacteristic("characteristic", characteristicArray.getJsonObject(i), i));
            }
        }
        if ((memberArray = JsonSupport.getJsonArray(jsonObject, "member")) != null) {
            for (int i = 0; i < memberArray.size(); ++i) {
                if (((JsonValue)memberArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)memberArray.get(i)).getValueType() + " for element: member");
                }
                builder.member(this.parseGroupMember("member", memberArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Group.Characteristic parseGroupCharacteristic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Group.Characteristic.class, jsonObject);
        }
        Group.Characteristic.Builder builder = Group.Characteristic.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, CodeableConcept.class, Boolean.class, Quantity.class, Range.class, Reference.class));
        builder.exclude(this.parseBoolean("exclude", JsonSupport.getJsonValue(jsonObject, "exclude", JsonValue.class), (JsonValue)jsonObject.get((Object)"_exclude"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Group.Member parseGroupMember(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(Group.Member.class, jsonObject);
        }
        Group.Member.Builder builder = Group.Member.builder();
        builder.setValidating(this.validating);
        this.parseBackboneElement(builder, jsonObject);
        builder.entity(this.parseReference("entity", JsonSupport.getJsonValue(jsonObject, "entity", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.inactive(this.parseBoolean("inactive", JsonSupport.getJsonValue(jsonObject, "inactive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_inactive"), -1));
        this.stackPop();
        return builder.build();
    }

    private GuidanceResponse parseGuidanceResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray evaluationMessageArray;
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.ignoringUnrecognizedElements) {
            JsonSupport.checkForUnrecognizedElements(GuidanceResponse.class, jsonObject);
        }
        GuidanceResponse.Builder builder = GuidanceResponse.builder();
        builder.setValidating(this.validating);
        this.parseDomainResource(builder, jsonObject);
        builder.requestIdentifier(this.parseIdentifier("requestIdentifier", JsonSupport.getJsonValue(jsonObject, "requestIdentifier", JsonObject.class), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                if (((JsonValue)identifierArray.get(i)).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("Expected: OBJECT but found: " + ((JsonValue)identifierArray.get(i)).getValueType() + " for element: identifier");
                }
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.module(this.parseChoiceElement("module", jsonObject, Uri.class, Canonical.class, CodeableConcept.class));
        builder.status((GuidanceResponseStatus)this.parseString(GuidanceResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(js