/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.parser;

import java.io.InputStream;
import java.io.Reader;
import org.linuxforhealth.fhir.model.format.Format;
import org.linuxforhealth.fhir.model.parser.FHIRJsonParser;
import org.linuxforhealth.fhir.model.parser.FHIRXMLParser;
import org.linuxforhealth.fhir.model.parser.exception.FHIRParserException;
import org.linuxforhealth.fhir.model.resource.Resource;

public interface FHIRParser {
    public <T extends Resource> T parse(InputStream var1) throws FHIRParserException;

    public <T extends Resource> T parse(Reader var1) throws FHIRParserException;

    public void setValidating(boolean var1);

    public boolean isValidating();

    public void setIgnoringUnrecognizedElements(boolean var1);

    public boolean isIgnoringUnrecognizedElements();

    public void setProperty(String var1, Object var2);

    public Object getProperty(String var1);

    public Object getPropertyOrDefault(String var1, Object var2);

    public <T> T getProperty(String var1, Class<T> var2);

    public <T> T getPropertyOrDefault(String var1, T var2, Class<T> var3);

    public boolean isPropertySupported(String var1);

    public <T extends FHIRParser> T as(Class<T> var1);

    public static FHIRParser parser(Format format) {
        switch (format) {
            case JSON: {
                return new FHIRJsonParser();
            }
            case XML: {
                return new FHIRXMLParser();
            }
        }
        throw new IllegalArgumentException("Unsupported format: " + format);
    }
}

