/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Ratio;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="apd-1", level="Rule", location="(base)", description="RouteOfAdministration cannot be used when the 'formOf' product already uses MedicinalProductDefinition.route (and vice versa)", expression="(AdministrableProductDefinition.routeOfAdministration.code.count() + AdministrableProductDefinition.formOf.resolve().route.count())  < 2", source="http://hl7.org/fhir/StructureDefinition/AdministrableProductDefinition")
public class AdministrableProductDefinition
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    @ReferenceTarget(value={"MedicinalProductDefinition"})
    private final List<Reference> formOf;
    @Summary
    @Binding(bindingName="AdministrableDoseForm", strength=BindingStrength.Value.EXAMPLE, description="Dose form for a medication, in the form suitable for administering to the patient, after mixing, where necessary.", valueSet="http://hl7.org/fhir/ValueSet/administrable-dose-form")
    private final CodeableConcept administrableDoseForm;
    @Summary
    @Binding(bindingName="UnitOfPresentation", strength=BindingStrength.Value.EXAMPLE, description="The presentation type in which an administrable medicinal product is given to a patient.", valueSet="http://hl7.org/fhir/ValueSet/unit-of-presentation")
    private final CodeableConcept unitOfPresentation;
    @Summary
    @ReferenceTarget(value={"ManufacturedItemDefinition"})
    private final List<Reference> producedFrom;
    @Summary
    @Binding(bindingName="SNOMEDCTSubstanceCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all substance codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
    private final List<CodeableConcept> ingredient;
    @Summary
    @ReferenceTarget(value={"DeviceDefinition"})
    private final Reference device;
    @Summary
    private final List<Property> property;
    @Summary
    @Required
    private final List<RouteOfAdministration> routeOfAdministration;

    private AdministrableProductDefinition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.formOf = Collections.unmodifiableList(builder.formOf);
        this.administrableDoseForm = builder.administrableDoseForm;
        this.unitOfPresentation = builder.unitOfPresentation;
        this.producedFrom = Collections.unmodifiableList(builder.producedFrom);
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
        this.device = builder.device;
        this.property = Collections.unmodifiableList(builder.property);
        this.routeOfAdministration = Collections.unmodifiableList(builder.routeOfAdministration);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public List<Reference> getFormOf() {
        return this.formOf;
    }

    public CodeableConcept getAdministrableDoseForm() {
        return this.administrableDoseForm;
    }

    public CodeableConcept getUnitOfPresentation() {
        return this.unitOfPresentation;
    }

    public List<Reference> getProducedFrom() {
        return this.producedFrom;
    }

    public List<CodeableConcept> getIngredient() {
        return this.ingredient;
    }

    public Reference getDevice() {
        return this.device;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    public List<RouteOfAdministration> getRouteOfAdministration() {
        return this.routeOfAdministration;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.formOf.isEmpty() || this.administrableDoseForm != null || this.unitOfPresentation != null || !this.producedFrom.isEmpty() || !this.ingredient.isEmpty() || this.device != null || !this.property.isEmpty() || !this.routeOfAdministration.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.formOf, "formOf", visitor, Reference.class);
                this.accept(this.administrableDoseForm, "administrableDoseForm", visitor);
                this.accept(this.unitOfPresentation, "unitOfPresentation", visitor);
                this.accept(this.producedFrom, "producedFrom", visitor, Reference.class);
                this.accept(this.ingredient, "ingredient", visitor, CodeableConcept.class);
                this.accept(this.device, "device", visitor);
                this.accept(this.property, "property", visitor, Property.class);
                this.accept(this.routeOfAdministration, "routeOfAdministration", visitor, RouteOfAdministration.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdministrableProductDefinition other = (AdministrableProductDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.formOf, other.formOf) && Objects.equals(this.administrableDoseForm, other.administrableDoseForm) && Objects.equals(this.unitOfPresentation, other.unitOfPresentation) && Objects.equals(this.producedFrom, other.producedFrom) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.device, other.device) && Objects.equals(this.property, other.property) && Objects.equals(this.routeOfAdministration, other.routeOfAdministration);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.formOf, this.administrableDoseForm, this.unitOfPresentation, this.producedFrom, this.ingredient, this.device, this.property, this.routeOfAdministration);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class RouteOfAdministration
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SNOMEDCTRouteCodes", strength=BindingStrength.Value.EXAMPLE, description="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient's body.", valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        @Required
        private final CodeableConcept code;
        @Summary
        private final Quantity firstDose;
        @Summary
        private final Quantity maxSingleDose;
        @Summary
        private final Quantity maxDosePerDay;
        @Summary
        private final Ratio maxDosePerTreatmentPeriod;
        @Summary
        private final Duration maxTreatmentPeriod;
        @Summary
        private final List<TargetSpecies> targetSpecies;

        private RouteOfAdministration(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.firstDose = builder.firstDose;
            this.maxSingleDose = builder.maxSingleDose;
            this.maxDosePerDay = builder.maxDosePerDay;
            this.maxDosePerTreatmentPeriod = builder.maxDosePerTreatmentPeriod;
            this.maxTreatmentPeriod = builder.maxTreatmentPeriod;
            this.targetSpecies = Collections.unmodifiableList(builder.targetSpecies);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Quantity getFirstDose() {
            return this.firstDose;
        }

        public Quantity getMaxSingleDose() {
            return this.maxSingleDose;
        }

        public Quantity getMaxDosePerDay() {
            return this.maxDosePerDay;
        }

        public Ratio getMaxDosePerTreatmentPeriod() {
            return this.maxDosePerTreatmentPeriod;
        }

        public Duration getMaxTreatmentPeriod() {
            return this.maxTreatmentPeriod;
        }

        public List<TargetSpecies> getTargetSpecies() {
            return this.targetSpecies;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.firstDose != null || this.maxSingleDose != null || this.maxDosePerDay != null || this.maxDosePerTreatmentPeriod != null || this.maxTreatmentPeriod != null || !this.targetSpecies.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.firstDose, "firstDose", visitor);
                    this.accept(this.maxSingleDose, "maxSingleDose", visitor);
                    this.accept(this.maxDosePerDay, "maxDosePerDay", visitor);
                    this.accept(this.maxDosePerTreatmentPeriod, "maxDosePerTreatmentPeriod", visitor);
                    this.accept(this.maxTreatmentPeriod, "maxTreatmentPeriod", visitor);
                    this.accept(this.targetSpecies, "targetSpecies", visitor, TargetSpecies.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RouteOfAdministration other = (RouteOfAdministration)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.firstDose, other.firstDose) && Objects.equals(this.maxSingleDose, other.maxSingleDose) && Objects.equals(this.maxDosePerDay, other.maxDosePerDay) && Objects.equals(this.maxDosePerTreatmentPeriod, other.maxDosePerTreatmentPeriod) && Objects.equals(this.maxTreatmentPeriod, other.maxTreatmentPeriod) && Objects.equals(this.targetSpecies, other.targetSpecies);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.firstDose, this.maxSingleDose, this.maxDosePerDay, this.maxDosePerTreatmentPeriod, this.maxTreatmentPeriod, this.targetSpecies);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class TargetSpecies
        extends BackboneElement {
            @Summary
            @Binding(bindingName="TargetSpecies", strength=BindingStrength.Value.EXAMPLE, description="A tissue type of an animal.", valueSet="http://hl7.org/fhir/ValueSet/target-species")
            @Required
            private final CodeableConcept code;
            @Summary
            private final List<WithdrawalPeriod> withdrawalPeriod;

            private TargetSpecies(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.withdrawalPeriod = Collections.unmodifiableList(builder.withdrawalPeriod);
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public List<WithdrawalPeriod> getWithdrawalPeriod() {
                return this.withdrawalPeriod;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || !this.withdrawalPeriod.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.withdrawalPeriod, "withdrawalPeriod", visitor, WithdrawalPeriod.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TargetSpecies other = (TargetSpecies)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.withdrawalPeriod, other.withdrawalPeriod);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.withdrawalPeriod);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class WithdrawalPeriod
            extends BackboneElement {
                @Summary
                @Binding(bindingName="AnimalTissueType", strength=BindingStrength.Value.EXAMPLE, description="A tissue type of an animal.", valueSet="http://hl7.org/fhir/ValueSet/animal-tissue-type")
                @Required
                private final CodeableConcept tissue;
                @Summary
                @Required
                private final Quantity value;
                @Summary
                private final org.linuxforhealth.fhir.model.type.String supportingInformation;

                private WithdrawalPeriod(Builder builder) {
                    super(builder);
                    this.tissue = builder.tissue;
                    this.value = builder.value;
                    this.supportingInformation = builder.supportingInformation;
                }

                public CodeableConcept getTissue() {
                    return this.tissue;
                }

                public Quantity getValue() {
                    return this.value;
                }

                public org.linuxforhealth.fhir.model.type.String getSupportingInformation() {
                    return this.supportingInformation;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.tissue != null || this.value != null || this.supportingInformation != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.tissue, "tissue", visitor);
                            this.accept(this.value, "value", visitor);
                            this.accept(this.supportingInformation, "supportingInformation", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    WithdrawalPeriod other = (WithdrawalPeriod)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.tissue, other.tissue) && Objects.equals(this.value, other.value) && Objects.equals(this.supportingInformation, other.supportingInformation);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.tissue, this.value, this.supportingInformation);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept tissue;
                    private Quantity value;
                    private org.linuxforhealth.fhir.model.type.String supportingInformation;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder tissue(CodeableConcept tissue) {
                        this.tissue = tissue;
                        return this;
                    }

                    public Builder value(Quantity value) {
                        this.value = value;
                        return this;
                    }

                    public Builder supportingInformation(String supportingInformation) {
                        this.supportingInformation = supportingInformation == null ? null : org.linuxforhealth.fhir.model.type.String.of(supportingInformation);
                        return this;
                    }

                    public Builder supportingInformation(org.linuxforhealth.fhir.model.type.String supportingInformation) {
                        this.supportingInformation = supportingInformation;
                        return this;
                    }

                    @Override
                    public WithdrawalPeriod build() {
                        WithdrawalPeriod withdrawalPeriod = new WithdrawalPeriod(this);
                        if (this.validating) {
                            this.validate(withdrawalPeriod);
                        }
                        return withdrawalPeriod;
                    }

                    protected void validate(WithdrawalPeriod withdrawalPeriod) {
                        super.validate(withdrawalPeriod);
                        ValidationSupport.requireNonNull(withdrawalPeriod.tissue, "tissue");
                        ValidationSupport.requireNonNull(withdrawalPeriod.value, "value");
                        ValidationSupport.requireValueOrChildren(withdrawalPeriod);
                    }

                    protected Builder from(WithdrawalPeriod withdrawalPeriod) {
                        super.from(withdrawalPeriod);
                        this.tissue = withdrawalPeriod.tissue;
                        this.value = withdrawalPeriod.value;
                        this.supportingInformation = withdrawalPeriod.supportingInformation;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private List<WithdrawalPeriod> withdrawalPeriod = new ArrayList<WithdrawalPeriod>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder withdrawalPeriod(WithdrawalPeriod ... withdrawalPeriod) {
                    for (WithdrawalPeriod value : withdrawalPeriod) {
                        this.withdrawalPeriod.add(value);
                    }
                    return this;
                }

                public Builder withdrawalPeriod(Collection<WithdrawalPeriod> withdrawalPeriod) {
                    this.withdrawalPeriod = new ArrayList<WithdrawalPeriod>(withdrawalPeriod);
                    return this;
                }

                @Override
                public TargetSpecies build() {
                    TargetSpecies targetSpecies = new TargetSpecies(this);
                    if (this.validating) {
                        this.validate(targetSpecies);
                    }
                    return targetSpecies;
                }

                protected void validate(TargetSpecies targetSpecies) {
                    super.validate(targetSpecies);
                    ValidationSupport.requireNonNull(targetSpecies.code, "code");
                    ValidationSupport.checkList(targetSpecies.withdrawalPeriod, "withdrawalPeriod", WithdrawalPeriod.class);
                    ValidationSupport.requireValueOrChildren(targetSpecies);
                }

                protected Builder from(TargetSpecies targetSpecies) {
                    super.from(targetSpecies);
                    this.code = targetSpecies.code;
                    this.withdrawalPeriod.addAll(targetSpecies.withdrawalPeriod);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private Quantity firstDose;
            private Quantity maxSingleDose;
            private Quantity maxDosePerDay;
            private Ratio maxDosePerTreatmentPeriod;
            private Duration maxTreatmentPeriod;
            private List<TargetSpecies> targetSpecies = new ArrayList<TargetSpecies>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder firstDose(Quantity firstDose) {
                this.firstDose = firstDose;
                return this;
            }

            public Builder maxSingleDose(Quantity maxSingleDose) {
                this.maxSingleDose = maxSingleDose;
                return this;
            }

            public Builder maxDosePerDay(Quantity maxDosePerDay) {
                this.maxDosePerDay = maxDosePerDay;
                return this;
            }

            public Builder maxDosePerTreatmentPeriod(Ratio maxDosePerTreatmentPeriod) {
                this.maxDosePerTreatmentPeriod = maxDosePerTreatmentPeriod;
                return this;
            }

            public Builder maxTreatmentPeriod(Duration maxTreatmentPeriod) {
                this.maxTreatmentPeriod = maxTreatmentPeriod;
                return this;
            }

            public Builder targetSpecies(TargetSpecies ... targetSpecies) {
                for (TargetSpecies value : targetSpecies) {
                    this.targetSpecies.add(value);
                }
                return this;
            }

            public Builder targetSpecies(Collection<TargetSpecies> targetSpecies) {
                this.targetSpecies = new ArrayList<TargetSpecies>(targetSpecies);
                return this;
            }

            @Override
            public RouteOfAdministration build() {
                RouteOfAdministration routeOfAdministration = new RouteOfAdministration(this);
                if (this.validating) {
                    this.validate(routeOfAdministration);
                }
                return routeOfAdministration;
            }

            protected void validate(RouteOfAdministration routeOfAdministration) {
                super.validate(routeOfAdministration);
                ValidationSupport.requireNonNull(routeOfAdministration.code, "code");
                ValidationSupport.checkList(routeOfAdministration.targetSpecies, "targetSpecies", TargetSpecies.class);
                ValidationSupport.requireValueOrChildren(routeOfAdministration);
            }

            protected Builder from(RouteOfAdministration routeOfAdministration) {
                super.from(routeOfAdministration);
                this.code = routeOfAdministration.code;
                this.firstDose = routeOfAdministration.firstDose;
                this.maxSingleDose = routeOfAdministration.maxSingleDose;
                this.maxDosePerDay = routeOfAdministration.maxDosePerDay;
                this.maxDosePerTreatmentPeriod = routeOfAdministration.maxDosePerTreatmentPeriod;
                this.maxTreatmentPeriod = routeOfAdministration.maxTreatmentPeriod;
                this.targetSpecies.addAll(routeOfAdministration.targetSpecies);
                return this;
            }
        }
    }

    public static class Property
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SNOMEDCTCharacteristicCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all observable entity codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/product-characteristic-codes")
        @Required
        private final CodeableConcept type;
        @Summary
        @Choice(value={CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class})
        private final Element value;
        @Summary
        @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
        private final CodeableConcept status;

        private Property(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
            this.status = builder.status;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null || this.status != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.status, "status", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.status, other.status);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value, this.status);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;
            private CodeableConcept status;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(LocalDate value) {
                this.value = value == null ? null : Date.of(value);
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            @Override
            public Property build() {
                Property property = new Property(this);
                if (this.validating) {
                    this.validate(property);
                }
                return property;
            }

            protected void validate(Property property) {
                super.validate(property);
                ValidationSupport.requireNonNull(property.type, "type");
                ValidationSupport.choiceElement(property.value, "value", CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class);
                ValidationSupport.checkValueSetBinding(property.status, "status", "http://hl7.org/fhir/ValueSet/publication-status", "http://hl7.org/fhir/publication-status", "draft", "active", "retired", "unknown");
                ValidationSupport.requireValueOrChildren(property);
            }

            protected Builder from(Property property) {
                super.from(property);
                this.type = property.type;
                this.value = property.value;
                this.status = property.status;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private PublicationStatus status;
        private List<Reference> formOf = new ArrayList<Reference>();
        private CodeableConcept administrableDoseForm;
        private CodeableConcept unitOfPresentation;
        private List<Reference> producedFrom = new ArrayList<Reference>();
        private List<CodeableConcept> ingredient = new ArrayList<CodeableConcept>();
        private Reference device;
        private List<Property> property = new ArrayList<Property>();
        private List<RouteOfAdministration> routeOfAdministration = new ArrayList<RouteOfAdministration>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder formOf(Reference ... formOf) {
            for (Reference value : formOf) {
                this.formOf.add(value);
            }
            return this;
        }

        public Builder formOf(Collection<Reference> formOf) {
            this.formOf = new ArrayList<Reference>(formOf);
            return this;
        }

        public Builder administrableDoseForm(CodeableConcept administrableDoseForm) {
            this.administrableDoseForm = administrableDoseForm;
            return this;
        }

        public Builder unitOfPresentation(CodeableConcept unitOfPresentation) {
            this.unitOfPresentation = unitOfPresentation;
            return this;
        }

        public Builder producedFrom(Reference ... producedFrom) {
            for (Reference value : producedFrom) {
                this.producedFrom.add(value);
            }
            return this;
        }

        public Builder producedFrom(Collection<Reference> producedFrom) {
            this.producedFrom = new ArrayList<Reference>(producedFrom);
            return this;
        }

        public Builder ingredient(CodeableConcept ... ingredient) {
            for (CodeableConcept value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<CodeableConcept> ingredient) {
            this.ingredient = new ArrayList<CodeableConcept>(ingredient);
            return this;
        }

        public Builder device(Reference device) {
            this.device = device;
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        public Builder routeOfAdministration(RouteOfAdministration ... routeOfAdministration) {
            for (RouteOfAdministration value : routeOfAdministration) {
                this.routeOfAdministration.add(value);
            }
            return this;
        }

        public Builder routeOfAdministration(Collection<RouteOfAdministration> routeOfAdministration) {
            this.routeOfAdministration = new ArrayList<RouteOfAdministration>(routeOfAdministration);
            return this;
        }

        @Override
        public AdministrableProductDefinition build() {
            AdministrableProductDefinition administrableProductDefinition = new AdministrableProductDefinition(this);
            if (this.validating) {
                this.validate(administrableProductDefinition);
            }
            return administrableProductDefinition;
        }

        protected void validate(AdministrableProductDefinition administrableProductDefinition) {
            super.validate(administrableProductDefinition);
            ValidationSupport.checkList(administrableProductDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(administrableProductDefinition.status, "status");
            ValidationSupport.checkList(administrableProductDefinition.formOf, "formOf", Reference.class);
            ValidationSupport.checkList(administrableProductDefinition.producedFrom, "producedFrom", Reference.class);
            ValidationSupport.checkList(administrableProductDefinition.ingredient, "ingredient", CodeableConcept.class);
            ValidationSupport.checkList(administrableProductDefinition.property, "property", Property.class);
            ValidationSupport.checkNonEmptyList(administrableProductDefinition.routeOfAdministration, "routeOfAdministration", RouteOfAdministration.class);
            ValidationSupport.checkReferenceType(administrableProductDefinition.formOf, "formOf", "MedicinalProductDefinition");
            ValidationSupport.checkReferenceType(administrableProductDefinition.producedFrom, "producedFrom", "ManufacturedItemDefinition");
            ValidationSupport.checkReferenceType(administrableProductDefinition.device, "device", "DeviceDefinition");
        }

        protected Builder from(AdministrableProductDefinition administrableProductDefinition) {
            super.from(administrableProductDefinition);
            this.identifier.addAll(administrableProductDefinition.identifier);
            this.status = administrableProductDefinition.status;
            this.formOf.addAll(administrableProductDefinition.formOf);
            this.administrableDoseForm = administrableProductDefinition.administrableDoseForm;
            this.unitOfPresentation = administrableProductDefinition.unitOfPresentation;
            this.producedFrom.addAll(administrableProductDefinition.producedFrom);
            this.ingredient.addAll(administrableProductDefinition.ingredient);
            this.device = administrableProductDefinition.device;
            this.property.addAll(administrableProductDefinition.property);
            this.routeOfAdministration.addAll(administrableProductDefinition.routeOfAdministration);
            return this;
        }
    }
}

