/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.ParticipantStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="apr-1", level="Rule", location="(base)", description="Either the participantType or actor must be specified", expression="participantType.exists() or actor.exists()", source="http://hl7.org/fhir/StructureDefinition/AppointmentResponse"), @Constraint(id="appointmentResponse-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/encounter-participant-type", expression="participantType.exists() implies (participantType.all(memberOf('http://hl7.org/fhir/ValueSet/encounter-participant-type', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/AppointmentResponse", generated=true)})
public class AppointmentResponse
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"Appointment"})
    @Required
    private final Reference appointment;
    private final Instant start;
    private final Instant end;
    @Summary
    @Binding(bindingName="ParticipantType", strength=BindingStrength.Value.EXTENSIBLE, description="Role of participant in encounter.", valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
    private final List<CodeableConcept> participantType;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device", "HealthcareService", "Location"})
    private final Reference actor;
    @Summary
    @Binding(bindingName="ParticipantStatus", strength=BindingStrength.Value.REQUIRED, description="The Participation status of an appointment.", valueSet="http://hl7.org/fhir/ValueSet/participationstatus|4.3.0")
    @Required
    private final ParticipantStatus participantStatus;
    private final String comment;

    private AppointmentResponse(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.appointment = builder.appointment;
        this.start = builder.start;
        this.end = builder.end;
        this.participantType = Collections.unmodifiableList(builder.participantType);
        this.actor = builder.actor;
        this.participantStatus = builder.participantStatus;
        this.comment = builder.comment;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Reference getAppointment() {
        return this.appointment;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public List<CodeableConcept> getParticipantType() {
        return this.participantType;
    }

    public Reference getActor() {
        return this.actor;
    }

    public ParticipantStatus getParticipantStatus() {
        return this.participantStatus;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.appointment != null || this.start != null || this.end != null || !this.participantType.isEmpty() || this.actor != null || this.participantStatus != null || this.comment != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.appointment, "appointment", visitor);
                this.accept(this.start, "start", visitor);
                this.accept(this.end, "end", visitor);
                this.accept(this.participantType, "participantType", visitor, CodeableConcept.class);
                this.accept(this.actor, "actor", visitor);
                this.accept(this.participantStatus, "participantStatus", visitor);
                this.accept(this.comment, "comment", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppointmentResponse other = (AppointmentResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.appointment, other.appointment) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.participantType, other.participantType) && Objects.equals(this.actor, other.actor) && Objects.equals(this.participantStatus, other.participantStatus) && Objects.equals(this.comment, other.comment);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.appointment, this.start, this.end, this.participantType, this.actor, this.participantStatus, this.comment);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Reference appointment;
        private Instant start;
        private Instant end;
        private List<CodeableConcept> participantType = new ArrayList<CodeableConcept>();
        private Reference actor;
        private ParticipantStatus participantStatus;
        private String comment;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder appointment(Reference appointment) {
            this.appointment = appointment;
            return this;
        }

        public Builder start(ZonedDateTime start) {
            this.start = start == null ? null : Instant.of(start);
            return this;
        }

        public Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public Builder end(ZonedDateTime end) {
            this.end = end == null ? null : Instant.of(end);
            return this;
        }

        public Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public Builder participantType(CodeableConcept ... participantType) {
            for (CodeableConcept value : participantType) {
                this.participantType.add(value);
            }
            return this;
        }

        public Builder participantType(Collection<CodeableConcept> participantType) {
            this.participantType = new ArrayList<CodeableConcept>(participantType);
            return this;
        }

        public Builder actor(Reference actor) {
            this.actor = actor;
            return this;
        }

        public Builder participantStatus(ParticipantStatus participantStatus) {
            this.participantStatus = participantStatus;
            return this;
        }

        public Builder comment(java.lang.String comment) {
            this.comment = comment == null ? null : String.of(comment);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public AppointmentResponse build() {
            AppointmentResponse appointmentResponse = new AppointmentResponse(this);
            if (this.validating) {
                this.validate(appointmentResponse);
            }
            return appointmentResponse;
        }

        protected void validate(AppointmentResponse appointmentResponse) {
            super.validate(appointmentResponse);
            ValidationSupport.checkList(appointmentResponse.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(appointmentResponse.appointment, "appointment");
            ValidationSupport.checkList(appointmentResponse.participantType, "participantType", CodeableConcept.class);
            ValidationSupport.requireNonNull(appointmentResponse.participantStatus, "participantStatus");
            ValidationSupport.checkReferenceType(appointmentResponse.appointment, "appointment", "Appointment");
            ValidationSupport.checkReferenceType(appointmentResponse.actor, "actor", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device", "HealthcareService", "Location");
        }

        protected Builder from(AppointmentResponse appointmentResponse) {
            super.from(appointmentResponse);
            this.identifier.addAll(appointmentResponse.identifier);
            this.appointment = appointmentResponse.appointment;
            this.start = appointmentResponse.start;
            this.end = appointmentResponse.end;
            this.participantType.addAll(appointmentResponse.participantType);
            this.actor = appointmentResponse.actor;
            this.participantStatus = appointmentResponse.participantStatus;
            this.comment = appointmentResponse.comment;
            return this;
        }
    }
}

