/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.AuditEventAction;
import org.linuxforhealth.fhir.model.type.code.AuditEventAgentNetworkType;
import org.linuxforhealth.fhir.model.type.code.AuditEventOutcome;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="sev-1", level="Rule", location="AuditEvent.entity", description="Either a name or a query (NOT both)", expression="name.empty() or query.empty()", source="http://hl7.org/fhir/StructureDefinition/AuditEvent"), @Constraint(id="auditEvent-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/audit-event-type", expression="type.exists() and type.memberOf('http://hl7.org/fhir/ValueSet/audit-event-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/audit-event-sub-type", expression="subtype.exists() implies (subtype.all(memberOf('http://hl7.org/fhir/ValueSet/audit-event-sub-type', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-4", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-PurposeOfUse", expression="purposeOfEvent.exists() implies (purposeOfEvent.all(memberOf('http://terminology.hl7.org/ValueSet/v3-PurposeOfUse', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-5", level="Warning", location="agent.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/participation-role-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/participation-role-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-6", level="Warning", location="agent.media", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/dicm-405-mediatype", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/dicm-405-mediatype', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-7", level="Warning", location="agent.purposeOfUse", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-PurposeOfUse", expression="$this.memberOf('http://terminology.hl7.org/ValueSet/v3-PurposeOfUse', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-8", level="Warning", location="source.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/audit-source-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/audit-source-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-9", level="Warning", location="entity.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/audit-entity-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/audit-entity-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-10", level="Warning", location="entity.role", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/object-role", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/object-role', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-11", level="Warning", location="entity.lifecycle", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/object-lifecycle-events", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/object-lifecycle-events', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true), @Constraint(id="auditEvent-12", level="Warning", location="entity.securityLabel", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/security-labels", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/security-labels', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/AuditEvent", generated=true)})
public class AuditEvent
extends DomainResource {
    @Summary
    @Binding(bindingName="AuditEventType", strength=BindingStrength.Value.EXTENSIBLE, description="Type of event.", valueSet="http://hl7.org/fhir/ValueSet/audit-event-type")
    @Required
    private final Coding type;
    @Summary
    @Binding(bindingName="AuditEventSubType", strength=BindingStrength.Value.EXTENSIBLE, description="Sub-type of event.", valueSet="http://hl7.org/fhir/ValueSet/audit-event-sub-type")
    private final List<Coding> subtype;
    @Summary
    @Binding(bindingName="AuditEventAction", strength=BindingStrength.Value.REQUIRED, description="DICOM Audit Event Action", valueSet="http://hl7.org/fhir/ValueSet/audit-event-action|4.3.0")
    private final AuditEventAction action;
    private final Period period;
    @Summary
    @Required
    private final Instant recorded;
    @Summary
    @Binding(bindingName="AuditEventOutcome", strength=BindingStrength.Value.REQUIRED, description="DICOM Audit Event Outcome", valueSet="http://hl7.org/fhir/ValueSet/audit-event-outcome|4.3.0")
    private final AuditEventOutcome outcome;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String outcomeDesc;
    @Summary
    @Binding(bindingName="AuditPurposeOfUse", strength=BindingStrength.Value.EXTENSIBLE, description="The reason the activity took place.", valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
    private final List<CodeableConcept> purposeOfEvent;
    @Required
    private final List<Agent> agent;
    @Required
    private final Source source;
    private final List<Entity> entity;

    private AuditEvent(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.subtype = Collections.unmodifiableList(builder.subtype);
        this.action = builder.action;
        this.period = builder.period;
        this.recorded = builder.recorded;
        this.outcome = builder.outcome;
        this.outcomeDesc = builder.outcomeDesc;
        this.purposeOfEvent = Collections.unmodifiableList(builder.purposeOfEvent);
        this.agent = Collections.unmodifiableList(builder.agent);
        this.source = builder.source;
        this.entity = Collections.unmodifiableList(builder.entity);
    }

    public Coding getType() {
        return this.type;
    }

    public List<Coding> getSubtype() {
        return this.subtype;
    }

    public AuditEventAction getAction() {
        return this.action;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Instant getRecorded() {
        return this.recorded;
    }

    public AuditEventOutcome getOutcome() {
        return this.outcome;
    }

    public org.linuxforhealth.fhir.model.type.String getOutcomeDesc() {
        return this.outcomeDesc;
    }

    public List<CodeableConcept> getPurposeOfEvent() {
        return this.purposeOfEvent;
    }

    public List<Agent> getAgent() {
        return this.agent;
    }

    public Source getSource() {
        return this.source;
    }

    public List<Entity> getEntity() {
        return this.entity;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.type != null || !this.subtype.isEmpty() || this.action != null || this.period != null || this.recorded != null || this.outcome != null || this.outcomeDesc != null || !this.purposeOfEvent.isEmpty() || !this.agent.isEmpty() || this.source != null || !this.entity.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.subtype, "subtype", visitor, Coding.class);
                this.accept(this.action, "action", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.recorded, "recorded", visitor);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.outcomeDesc, "outcomeDesc", visitor);
                this.accept(this.purposeOfEvent, "purposeOfEvent", visitor, CodeableConcept.class);
                this.accept(this.agent, "agent", visitor, Agent.class);
                this.accept(this.source, "source", visitor);
                this.accept(this.entity, "entity", visitor, Entity.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditEvent other = (AuditEvent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.subtype, other.subtype) && Objects.equals(this.action, other.action) && Objects.equals(this.period, other.period) && Objects.equals(this.recorded, other.recorded) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.outcomeDesc, other.outcomeDesc) && Objects.equals(this.purposeOfEvent, other.purposeOfEvent) && Objects.equals(this.agent, other.agent) && Objects.equals(this.source, other.source) && Objects.equals(this.entity, other.entity);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.type, this.subtype, this.action, this.period, this.recorded, this.outcome, this.outcomeDesc, this.purposeOfEvent, this.agent, this.source, this.entity);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Entity
    extends BackboneElement {
        @Summary
        private final Reference what;
        @Binding(bindingName="AuditEventEntityType", strength=BindingStrength.Value.EXTENSIBLE, description="DICOM Audit Event Entity Type", valueSet="http://hl7.org/fhir/ValueSet/audit-entity-type")
        private final Coding type;
        @Binding(bindingName="AuditEventEntityRole", strength=BindingStrength.Value.EXTENSIBLE, description="DICOM Audit Event Entity Role", valueSet="http://hl7.org/fhir/ValueSet/object-role")
        private final Coding role;
        @Binding(bindingName="AuditEventEntityLifecycle", strength=BindingStrength.Value.EXTENSIBLE, description="Identifier for the data life-cycle stage for the entity.", valueSet="http://hl7.org/fhir/ValueSet/object-lifecycle-events")
        private final Coding lifecycle;
        @Binding(bindingName="SecurityLabels", strength=BindingStrength.Value.EXTENSIBLE, description="Security Labels from the Healthcare Privacy and Security Classification System.", valueSet="http://hl7.org/fhir/ValueSet/security-labels")
        private final List<Coding> securityLabel;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String name;
        private final org.linuxforhealth.fhir.model.type.String description;
        @Summary
        private final Base64Binary query;
        private final List<Detail> detail;

        private Entity(Builder builder) {
            super(builder);
            this.what = builder.what;
            this.type = builder.type;
            this.role = builder.role;
            this.lifecycle = builder.lifecycle;
            this.securityLabel = Collections.unmodifiableList(builder.securityLabel);
            this.name = builder.name;
            this.description = builder.description;
            this.query = builder.query;
            this.detail = Collections.unmodifiableList(builder.detail);
        }

        public Reference getWhat() {
            return this.what;
        }

        public Coding getType() {
            return this.type;
        }

        public Coding getRole() {
            return this.role;
        }

        public Coding getLifecycle() {
            return this.lifecycle;
        }

        public List<Coding> getSecurityLabel() {
            return this.securityLabel;
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public Base64Binary getQuery() {
            return this.query;
        }

        public List<Detail> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.what != null || this.type != null || this.role != null || this.lifecycle != null || !this.securityLabel.isEmpty() || this.name != null || this.description != null || this.query != null || !this.detail.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.what, "what", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.lifecycle, "lifecycle", visitor);
                    this.accept(this.securityLabel, "securityLabel", visitor, Coding.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.query, "query", visitor);
                    this.accept(this.detail, "detail", visitor, Detail.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entity other = (Entity)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.what, other.what) && Objects.equals(this.type, other.type) && Objects.equals(this.role, other.role) && Objects.equals(this.lifecycle, other.lifecycle) && Objects.equals(this.securityLabel, other.securityLabel) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.query, other.query) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.what, this.type, this.role, this.lifecycle, this.securityLabel, this.name, this.description, this.query, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Detail
        extends BackboneElement {
            @Required
            private final org.linuxforhealth.fhir.model.type.String type;
            @Choice(value={org.linuxforhealth.fhir.model.type.String.class, Base64Binary.class})
            @Required
            private final Element value;

            private Detail(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.value = builder.value;
            }

            public org.linuxforhealth.fhir.model.type.String getType() {
                return this.type;
            }

            public Element getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.value != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Detail other = (Detail)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String type;
                private Element value;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(String type) {
                    this.type = type == null ? null : org.linuxforhealth.fhir.model.type.String.of(type);
                    return this;
                }

                public Builder type(org.linuxforhealth.fhir.model.type.String type) {
                    this.type = type;
                    return this;
                }

                public Builder value(String value) {
                    this.value = value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value);
                    return this;
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Detail build() {
                    Detail detail = new Detail(this);
                    if (this.validating) {
                        this.validate(detail);
                    }
                    return detail;
                }

                protected void validate(Detail detail) {
                    super.validate(detail);
                    ValidationSupport.requireNonNull(detail.type, "type");
                    ValidationSupport.requireChoiceElement(detail.value, "value", org.linuxforhealth.fhir.model.type.String.class, Base64Binary.class);
                    ValidationSupport.requireValueOrChildren(detail);
                }

                protected Builder from(Detail detail) {
                    super.from(detail);
                    this.type = detail.type;
                    this.value = detail.value;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference what;
            private Coding type;
            private Coding role;
            private Coding lifecycle;
            private List<Coding> securityLabel = new ArrayList<Coding>();
            private org.linuxforhealth.fhir.model.type.String name;
            private org.linuxforhealth.fhir.model.type.String description;
            private Base64Binary query;
            private List<Detail> detail = new ArrayList<Detail>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder what(Reference what) {
                this.what = what;
                return this;
            }

            public Builder type(Coding type) {
                this.type = type;
                return this;
            }

            public Builder role(Coding role) {
                this.role = role;
                return this;
            }

            public Builder lifecycle(Coding lifecycle) {
                this.lifecycle = lifecycle;
                return this;
            }

            public Builder securityLabel(Coding ... securityLabel) {
                for (Coding value : securityLabel) {
                    this.securityLabel.add(value);
                }
                return this;
            }

            public Builder securityLabel(Collection<Coding> securityLabel) {
                this.securityLabel = new ArrayList<Coding>(securityLabel);
                return this;
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder query(Base64Binary query) {
                this.query = query;
                return this;
            }

            public Builder detail(Detail ... detail) {
                for (Detail value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Detail> detail) {
                this.detail = new ArrayList<Detail>(detail);
                return this;
            }

            @Override
            public Entity build() {
                Entity entity = new Entity(this);
                if (this.validating) {
                    this.validate(entity);
                }
                return entity;
            }

            protected void validate(Entity entity) {
                super.validate(entity);
                ValidationSupport.checkList(entity.securityLabel, "securityLabel", Coding.class);
                ValidationSupport.checkList(entity.detail, "detail", Detail.class);
                ValidationSupport.requireValueOrChildren(entity);
            }

            protected Builder from(Entity entity) {
                super.from(entity);
                this.what = entity.what;
                this.type = entity.type;
                this.role = entity.role;
                this.lifecycle = entity.lifecycle;
                this.securityLabel.addAll(entity.securityLabel);
                this.name = entity.name;
                this.description = entity.description;
                this.query = entity.query;
                this.detail.addAll(entity.detail);
                return this;
            }
        }
    }

    public static class Source
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String site;
        @Summary
        @ReferenceTarget(value={"PractitionerRole", "Practitioner", "Organization", "Device", "Patient", "RelatedPerson"})
        @Required
        private final Reference observer;
        @Binding(bindingName="AuditEventSourceType", strength=BindingStrength.Value.EXTENSIBLE, description="Code specifying the type of system that detected and recorded the event.", valueSet="http://hl7.org/fhir/ValueSet/audit-source-type")
        private final List<Coding> type;

        private Source(Builder builder) {
            super(builder);
            this.site = builder.site;
            this.observer = builder.observer;
            this.type = Collections.unmodifiableList(builder.type);
        }

        public org.linuxforhealth.fhir.model.type.String getSite() {
            return this.site;
        }

        public Reference getObserver() {
            return this.observer;
        }

        public List<Coding> getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.site != null || this.observer != null || !this.type.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.site, "site", visitor);
                    this.accept(this.observer, "observer", visitor);
                    this.accept(this.type, "type", visitor, Coding.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Source other = (Source)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.site, other.site) && Objects.equals(this.observer, other.observer) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.site, this.observer, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String site;
            private Reference observer;
            private List<Coding> type = new ArrayList<Coding>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder site(String site) {
                this.site = site == null ? null : org.linuxforhealth.fhir.model.type.String.of(site);
                return this;
            }

            public Builder site(org.linuxforhealth.fhir.model.type.String site) {
                this.site = site;
                return this;
            }

            public Builder observer(Reference observer) {
                this.observer = observer;
                return this;
            }

            public Builder type(Coding ... type) {
                for (Coding value : type) {
                    this.type.add(value);
                }
                return this;
            }

            public Builder type(Collection<Coding> type) {
                this.type = new ArrayList<Coding>(type);
                return this;
            }

            @Override
            public Source build() {
                Source source = new Source(this);
                if (this.validating) {
                    this.validate(source);
                }
                return source;
            }

            protected void validate(Source source) {
                super.validate(source);
                ValidationSupport.requireNonNull(source.observer, "observer");
                ValidationSupport.checkList(source.type, "type", Coding.class);
                ValidationSupport.checkReferenceType(source.observer, "observer", "PractitionerRole", "Practitioner", "Organization", "Device", "Patient", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(source);
            }

            protected Builder from(Source source) {
                super.from(source);
                this.site = source.site;
                this.observer = source.observer;
                this.type.addAll(source.type);
                return this;
            }
        }
    }

    public static class Agent
    extends BackboneElement {
        @Binding(bindingName="AuditAgentType", strength=BindingStrength.Value.EXTENSIBLE, description="The Participation type of the agent to the event.", valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        private final CodeableConcept type;
        @Binding(bindingName="AuditAgentRole", strength=BindingStrength.Value.EXAMPLE, description="What security role enabled the agent to participate in the event.", valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        private final List<CodeableConcept> role;
        @Summary
        @ReferenceTarget(value={"PractitionerRole", "Practitioner", "Organization", "Device", "Patient", "RelatedPerson"})
        private final Reference who;
        private final org.linuxforhealth.fhir.model.type.String altId;
        private final org.linuxforhealth.fhir.model.type.String name;
        @Summary
        @Required
        private final Boolean requestor;
        @ReferenceTarget(value={"Location"})
        private final Reference location;
        private final List<Uri> policy;
        @Binding(bindingName="DICOMMediaType", strength=BindingStrength.Value.EXTENSIBLE, description="Used when the event is about exporting/importing onto media.", valueSet="http://hl7.org/fhir/ValueSet/dicm-405-mediatype")
        private final Coding media;
        private final Network network;
        @Binding(bindingName="AuditPurposeOfUse", strength=BindingStrength.Value.EXTENSIBLE, description="The reason the activity took place.", valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        private final List<CodeableConcept> purposeOfUse;

        private Agent(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.role = Collections.unmodifiableList(builder.role);
            this.who = builder.who;
            this.altId = builder.altId;
            this.name = builder.name;
            this.requestor = builder.requestor;
            this.location = builder.location;
            this.policy = Collections.unmodifiableList(builder.policy);
            this.media = builder.media;
            this.network = builder.network;
            this.purposeOfUse = Collections.unmodifiableList(builder.purposeOfUse);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<CodeableConcept> getRole() {
            return this.role;
        }

        public Reference getWho() {
            return this.who;
        }

        public org.linuxforhealth.fhir.model.type.String getAltId() {
            return this.altId;
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public Boolean getRequestor() {
            return this.requestor;
        }

        public Reference getLocation() {
            return this.location;
        }

        public List<Uri> getPolicy() {
            return this.policy;
        }

        public Coding getMedia() {
            return this.media;
        }

        public Network getNetwork() {
            return this.network;
        }

        public List<CodeableConcept> getPurposeOfUse() {
            return this.purposeOfUse;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.role.isEmpty() || this.who != null || this.altId != null || this.name != null || this.requestor != null || this.location != null || !this.policy.isEmpty() || this.media != null || this.network != null || !this.purposeOfUse.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.role, "role", visitor, CodeableConcept.class);
                    this.accept(this.who, "who", visitor);
                    this.accept(this.altId, "altId", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.requestor, "requestor", visitor);
                    this.accept(this.location, "location", visitor);
                    this.accept(this.policy, "policy", visitor, Uri.class);
                    this.accept(this.media, "media", visitor);
                    this.accept(this.network, "network", visitor);
                    this.accept(this.purposeOfUse, "purposeOfUse", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Agent other = (Agent)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.role, other.role) && Objects.equals(this.who, other.who) && Objects.equals(this.altId, other.altId) && Objects.equals(this.name, other.name) && Objects.equals(this.requestor, other.requestor) && Objects.equals(this.location, other.location) && Objects.equals(this.policy, other.policy) && Objects.equals(this.media, other.media) && Objects.equals(this.network, other.network) && Objects.equals(this.purposeOfUse, other.purposeOfUse);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.role, this.who, this.altId, this.name, this.requestor, this.location, this.policy, this.media, this.network, this.purposeOfUse);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Network
        extends BackboneElement {
            private final org.linuxforhealth.fhir.model.type.String address;
            @Binding(bindingName="AuditEventAgentNetworkType", strength=BindingStrength.Value.REQUIRED, description="DICOM Audit Event Network Type", valueSet="http://hl7.org/fhir/ValueSet/network-type|4.3.0")
            private final AuditEventAgentNetworkType type;

            private Network(Builder builder) {
                super(builder);
                this.address = builder.address;
                this.type = builder.type;
            }

            public org.linuxforhealth.fhir.model.type.String getAddress() {
                return this.address;
            }

            public AuditEventAgentNetworkType getType() {
                return this.type;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.address != null || this.type != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.address, "address", visitor);
                        this.accept(this.type, "type", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Network other = (Network)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.address, other.address) && Objects.equals(this.type, other.type);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.address, this.type);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String address;
                private AuditEventAgentNetworkType type;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder address(String address) {
                    this.address = address == null ? null : org.linuxforhealth.fhir.model.type.String.of(address);
                    return this;
                }

                public Builder address(org.linuxforhealth.fhir.model.type.String address) {
                    this.address = address;
                    return this;
                }

                public Builder type(AuditEventAgentNetworkType type) {
                    this.type = type;
                    return this;
                }

                @Override
                public Network build() {
                    Network network = new Network(this);
                    if (this.validating) {
                        this.validate(network);
                    }
                    return network;
                }

                protected void validate(Network network) {
                    super.validate(network);
                    ValidationSupport.requireValueOrChildren(network);
                }

                protected Builder from(Network network) {
                    super.from(network);
                    this.address = network.address;
                    this.type = network.type;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<CodeableConcept> role = new ArrayList<CodeableConcept>();
            private Reference who;
            private org.linuxforhealth.fhir.model.type.String altId;
            private org.linuxforhealth.fhir.model.type.String name;
            private Boolean requestor;
            private Reference location;
            private List<Uri> policy = new ArrayList<Uri>();
            private Coding media;
            private Network network;
            private List<CodeableConcept> purposeOfUse = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder role(CodeableConcept ... role) {
                for (CodeableConcept value : role) {
                    this.role.add(value);
                }
                return this;
            }

            public Builder role(Collection<CodeableConcept> role) {
                this.role = new ArrayList<CodeableConcept>(role);
                return this;
            }

            public Builder who(Reference who) {
                this.who = who;
                return this;
            }

            public Builder altId(String altId) {
                this.altId = altId == null ? null : org.linuxforhealth.fhir.model.type.String.of(altId);
                return this;
            }

            public Builder altId(org.linuxforhealth.fhir.model.type.String altId) {
                this.altId = altId;
                return this;
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder requestor(java.lang.Boolean requestor) {
                this.requestor = requestor == null ? null : Boolean.of(requestor);
                return this;
            }

            public Builder requestor(Boolean requestor) {
                this.requestor = requestor;
                return this;
            }

            public Builder location(Reference location) {
                this.location = location;
                return this;
            }

            public Builder policy(Uri ... policy) {
                for (Uri value : policy) {
                    this.policy.add(value);
                }
                return this;
            }

            public Builder policy(Collection<Uri> policy) {
                this.policy = new ArrayList<Uri>(policy);
                return this;
            }

            public Builder media(Coding media) {
                this.media = media;
                return this;
            }

            public Builder network(Network network) {
                this.network = network;
                return this;
            }

            public Builder purposeOfUse(CodeableConcept ... purposeOfUse) {
                for (CodeableConcept value : purposeOfUse) {
                    this.purposeOfUse.add(value);
                }
                return this;
            }

            public Builder purposeOfUse(Collection<CodeableConcept> purposeOfUse) {
                this.purposeOfUse = new ArrayList<CodeableConcept>(purposeOfUse);
                return this;
            }

            @Override
            public Agent build() {
                Agent agent = new Agent(this);
                if (this.validating) {
                    this.validate(agent);
                }
                return agent;
            }

            protected void validate(Agent agent) {
                super.validate(agent);
                ValidationSupport.checkList(agent.role, "role", CodeableConcept.class);
                ValidationSupport.requireNonNull(agent.requestor, "requestor");
                ValidationSupport.checkList(agent.policy, "policy", Uri.class);
                ValidationSupport.checkList(agent.purposeOfUse, "purposeOfUse", CodeableConcept.class);
                ValidationSupport.checkReferenceType(agent.who, "who", "PractitionerRole", "Practitioner", "Organization", "Device", "Patient", "RelatedPerson");
                ValidationSupport.checkReferenceType(agent.location, "location", "Location");
                ValidationSupport.requireValueOrChildren(agent);
            }

            protected Builder from(Agent agent) {
                super.from(agent);
                this.type = agent.type;
                this.role.addAll(agent.role);
                this.who = agent.who;
                this.altId = agent.altId;
                this.name = agent.name;
                this.requestor = agent.requestor;
                this.location = agent.location;
                this.policy.addAll(agent.policy);
                this.media = agent.media;
                this.network = agent.network;
                this.purposeOfUse.addAll(agent.purposeOfUse);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Coding type;
        private List<Coding> subtype = new ArrayList<Coding>();
        private AuditEventAction action;
        private Period period;
        private Instant recorded;
        private AuditEventOutcome outcome;
        private org.linuxforhealth.fhir.model.type.String outcomeDesc;
        private List<CodeableConcept> purposeOfEvent = new ArrayList<CodeableConcept>();
        private List<Agent> agent = new ArrayList<Agent>();
        private Source source;
        private List<Entity> entity = new ArrayList<Entity>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder type(Coding type) {
            this.type = type;
            return this;
        }

        public Builder subtype(Coding ... subtype) {
            for (Coding value : subtype) {
                this.subtype.add(value);
            }
            return this;
        }

        public Builder subtype(Collection<Coding> subtype) {
            this.subtype = new ArrayList<Coding>(subtype);
            return this;
        }

        public Builder action(AuditEventAction action) {
            this.action = action;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder recorded(ZonedDateTime recorded) {
            this.recorded = recorded == null ? null : Instant.of(recorded);
            return this;
        }

        public Builder recorded(Instant recorded) {
            this.recorded = recorded;
            return this;
        }

        public Builder outcome(AuditEventOutcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder outcomeDesc(String outcomeDesc) {
            this.outcomeDesc = outcomeDesc == null ? null : org.linuxforhealth.fhir.model.type.String.of(outcomeDesc);
            return this;
        }

        public Builder outcomeDesc(org.linuxforhealth.fhir.model.type.String outcomeDesc) {
            this.outcomeDesc = outcomeDesc;
            return this;
        }

        public Builder purposeOfEvent(CodeableConcept ... purposeOfEvent) {
            for (CodeableConcept value : purposeOfEvent) {
                this.purposeOfEvent.add(value);
            }
            return this;
        }

        public Builder purposeOfEvent(Collection<CodeableConcept> purposeOfEvent) {
            this.purposeOfEvent = new ArrayList<CodeableConcept>(purposeOfEvent);
            return this;
        }

        public Builder agent(Agent ... agent) {
            for (Agent value : agent) {
                this.agent.add(value);
            }
            return this;
        }

        public Builder agent(Collection<Agent> agent) {
            this.agent = new ArrayList<Agent>(agent);
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder entity(Entity ... entity) {
            for (Entity value : entity) {
                this.entity.add(value);
            }
            return this;
        }

        public Builder entity(Collection<Entity> entity) {
            this.entity = new ArrayList<Entity>(entity);
            return this;
        }

        @Override
        public AuditEvent build() {
            AuditEvent auditEvent = new AuditEvent(this);
            if (this.validating) {
                this.validate(auditEvent);
            }
            return auditEvent;
        }

        protected void validate(AuditEvent auditEvent) {
            super.validate(auditEvent);
            ValidationSupport.requireNonNull(auditEvent.type, "type");
            ValidationSupport.checkList(auditEvent.subtype, "subtype", Coding.class);
            ValidationSupport.requireNonNull(auditEvent.recorded, "recorded");
            ValidationSupport.checkList(auditEvent.purposeOfEvent, "purposeOfEvent", CodeableConcept.class);
            ValidationSupport.checkNonEmptyList(auditEvent.agent, "agent", Agent.class);
            ValidationSupport.requireNonNull(auditEvent.source, "source");
            ValidationSupport.checkList(auditEvent.entity, "entity", Entity.class);
        }

        protected Builder from(AuditEvent auditEvent) {
            super.from(auditEvent);
            this.type = auditEvent.type;
            this.subtype.addAll(auditEvent.subtype);
            this.action = auditEvent.action;
            this.period = auditEvent.period;
            this.recorded = auditEvent.recorded;
            this.outcome = auditEvent.outcome;
            this.outcomeDesc = auditEvent.outcomeDesc;
            this.purposeOfEvent.addAll(auditEvent.purposeOfEvent);
            this.agent.addAll(auditEvent.agent);
            this.source = auditEvent.source;
            this.entity.addAll(auditEvent.entity);
            return this;
        }
    }
}

