/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
public class Binary
extends Resource {
    @Summary
    @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="BCP 13 (RFCs 2045, 2046, 2047, 4288, 4289 and 2049)", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.3.0")
    @Required
    private final Code contentType;
    @Summary
    private final Reference securityContext;
    private final Base64Binary data;

    private Binary(Builder builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.securityContext = builder.securityContext;
        this.data = builder.data;
    }

    public Code getContentType() {
        return this.contentType;
    }

    public Reference getSecurityContext() {
        return this.securityContext;
    }

    public Base64Binary getData() {
        return this.data;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.contentType != null || this.securityContext != null || this.data != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.contentType, "contentType", visitor);
                this.accept(this.securityContext, "securityContext", visitor);
                this.accept(this.data, "data", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Binary other = (Binary)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.securityContext, other.securityContext) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.contentType, this.securityContext, this.data);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Resource.Builder {
        private Code contentType;
        private Reference securityContext;
        private Base64Binary data;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        public Builder contentType(Code contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder securityContext(Reference securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public Builder data(Base64Binary data) {
            this.data = data;
            return this;
        }

        @Override
        public Binary build() {
            Binary binary = new Binary(this);
            if (this.validating) {
                this.validate(binary);
            }
            return binary;
        }

        protected void validate(Binary binary) {
            super.validate(binary);
            ValidationSupport.requireNonNull(binary.contentType, "contentType");
        }

        protected Builder from(Binary binary) {
            super.from(binary);
            this.contentType = binary.contentType;
            this.securityContext = binary.securityContext;
            this.data = binary.data;
            return this;
        }
    }
}

