/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
public class BodyStructure
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    @Binding(bindingName="BodyStructureCode", strength=BindingStrength.Value.EXAMPLE, description="Codes describing anatomic morphology.", valueSet="http://hl7.org/fhir/ValueSet/bodystructure-code")
    private final CodeableConcept morphology;
    @Summary
    @Binding(bindingName="BodySite", strength=BindingStrength.Value.EXAMPLE, description="SNOMED CT Body site concepts", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final CodeableConcept location;
    @Binding(bindingName="BodyStructureQualifier", strength=BindingStrength.Value.EXAMPLE, description="Concepts modifying the anatomic location.", valueSet="http://hl7.org/fhir/ValueSet/bodystructure-relative-location")
    private final List<CodeableConcept> locationQualifier;
    @Summary
    private final String description;
    private final List<Attachment> image;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;

    private BodyStructure(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.active = builder.active;
        this.morphology = builder.morphology;
        this.location = builder.location;
        this.locationQualifier = Collections.unmodifiableList(builder.locationQualifier);
        this.description = builder.description;
        this.image = Collections.unmodifiableList(builder.image);
        this.patient = builder.patient;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public CodeableConcept getMorphology() {
        return this.morphology;
    }

    public CodeableConcept getLocation() {
        return this.location;
    }

    public List<CodeableConcept> getLocationQualifier() {
        return this.locationQualifier;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Attachment> getImage() {
        return this.image;
    }

    public Reference getPatient() {
        return this.patient;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || this.morphology != null || this.location != null || !this.locationQualifier.isEmpty() || this.description != null || !this.image.isEmpty() || this.patient != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.morphology, "morphology", visitor);
                this.accept(this.location, "location", visitor);
                this.accept(this.locationQualifier, "locationQualifier", visitor, CodeableConcept.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.image, "image", visitor, Attachment.class);
                this.accept(this.patient, "patient", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BodyStructure other = (BodyStructure)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.morphology, other.morphology) && Objects.equals(this.location, other.location) && Objects.equals(this.locationQualifier, other.locationQualifier) && Objects.equals(this.description, other.description) && Objects.equals(this.image, other.image) && Objects.equals(this.patient, other.patient);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.morphology, this.location, this.locationQualifier, this.description, this.image, this.patient);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private CodeableConcept morphology;
        private CodeableConcept location;
        private List<CodeableConcept> locationQualifier = new ArrayList<CodeableConcept>();
        private String description;
        private List<Attachment> image = new ArrayList<Attachment>();
        private Reference patient;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder morphology(CodeableConcept morphology) {
            this.morphology = morphology;
            return this;
        }

        public Builder location(CodeableConcept location) {
            this.location = location;
            return this;
        }

        public Builder locationQualifier(CodeableConcept ... locationQualifier) {
            for (CodeableConcept value : locationQualifier) {
                this.locationQualifier.add(value);
            }
            return this;
        }

        public Builder locationQualifier(Collection<CodeableConcept> locationQualifier) {
            this.locationQualifier = new ArrayList<CodeableConcept>(locationQualifier);
            return this;
        }

        public Builder description(java.lang.String description) {
            this.description = description == null ? null : String.of(description);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder image(Attachment ... image) {
            for (Attachment value : image) {
                this.image.add(value);
            }
            return this;
        }

        public Builder image(Collection<Attachment> image) {
            this.image = new ArrayList<Attachment>(image);
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        @Override
        public BodyStructure build() {
            BodyStructure bodyStructure = new BodyStructure(this);
            if (this.validating) {
                this.validate(bodyStructure);
            }
            return bodyStructure;
        }

        protected void validate(BodyStructure bodyStructure) {
            super.validate(bodyStructure);
            ValidationSupport.checkList(bodyStructure.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(bodyStructure.locationQualifier, "locationQualifier", CodeableConcept.class);
            ValidationSupport.checkList(bodyStructure.image, "image", Attachment.class);
            ValidationSupport.requireNonNull(bodyStructure.patient, "patient");
            ValidationSupport.checkReferenceType(bodyStructure.patient, "patient", "Patient");
        }

        protected Builder from(BodyStructure bodyStructure) {
            super.from(bodyStructure);
            this.identifier.addAll(bodyStructure.identifier);
            this.active = bodyStructure.active;
            this.morphology = bodyStructure.morphology;
            this.location = bodyStructure.location;
            this.locationQualifier.addAll(bodyStructure.locationQualifier);
            this.description = bodyStructure.description;
            this.image.addAll(bodyStructure.image);
            this.patient = bodyStructure.patient;
            return this;
        }
    }
}

