/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.CareTeamStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="ctm-1", level="Rule", location="CareTeam.participant", description="CareTeam.participant.onBehalfOf can only be populated when CareTeam.participant.member is a Practitioner", expression="onBehalfOf.exists() implies (member.resolve().iif(empty(), true, ofType(Practitioner).exists()))", source="http://hl7.org/fhir/StructureDefinition/CareTeam")
public class CareTeam
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="CareTeamStatus", strength=BindingStrength.Value.REQUIRED, description="Indicates the status of the care team.", valueSet="http://hl7.org/fhir/ValueSet/care-team-status|4.3.0")
    private final CareTeamStatus status;
    @Summary
    @Binding(bindingName="CareTeamCategory", strength=BindingStrength.Value.EXAMPLE, description="Indicates the type of care team.", valueSet="http://hl7.org/fhir/ValueSet/care-team-category")
    private final List<CodeableConcept> category;
    @Summary
    private final String name;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    private final Period period;
    private final List<Participant> participant;
    @Binding(bindingName="CareTeamReason", strength=BindingStrength.Value.EXAMPLE, description="Indicates the reason for the care team.", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition"})
    private final List<Reference> reasonReference;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> managingOrganization;
    private final List<ContactPoint> telecom;
    private final List<Annotation> note;

    private CareTeam(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.category = Collections.unmodifiableList(builder.category);
        this.name = builder.name;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.period = builder.period;
        this.participant = Collections.unmodifiableList(builder.participant);
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.managingOrganization = Collections.unmodifiableList(builder.managingOrganization);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CareTeamStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Period getPeriod() {
        return this.period;
    }

    public List<Participant> getParticipant() {
        return this.participant;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Reference> getManagingOrganization() {
        return this.managingOrganization;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.category.isEmpty() || this.name != null || this.subject != null || this.encounter != null || this.period != null || !this.participant.isEmpty() || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.managingOrganization.isEmpty() || !this.telecom.isEmpty() || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.participant, "participant", visitor, Participant.class);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.managingOrganization, "managingOrganization", visitor, Reference.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CareTeam other = (CareTeam)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.category, other.category) && Objects.equals(this.name, other.name) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.period, other.period) && Objects.equals(this.participant, other.participant) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.managingOrganization, other.managingOrganization) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.category, this.name, this.subject, this.encounter, this.period, this.participant, this.reasonCode, this.reasonReference, this.managingOrganization, this.telecom, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Participant
    extends BackboneElement {
        @Summary
        @Binding(bindingName="CareTeamParticipantRole", strength=BindingStrength.Value.EXAMPLE, description="Indicates specific responsibility of an individual within the care team, such as \"Primary physician\", \"Team coordinator\", \"Caregiver\", etc.", valueSet="http://hl7.org/fhir/ValueSet/careteam-participant-role")
        private final List<CodeableConcept> role;
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Organization", "CareTeam"})
        private final Reference member;
        @Summary
        @ReferenceTarget(value={"Organization"})
        private final Reference onBehalfOf;
        private final Period period;

        private Participant(Builder builder) {
            super(builder);
            this.role = Collections.unmodifiableList(builder.role);
            this.member = builder.member;
            this.onBehalfOf = builder.onBehalfOf;
            this.period = builder.period;
        }

        public List<CodeableConcept> getRole() {
            return this.role;
        }

        public Reference getMember() {
            return this.member;
        }

        public Reference getOnBehalfOf() {
            return this.onBehalfOf;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.role.isEmpty() || this.member != null || this.onBehalfOf != null || this.period != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.role, "role", visitor, CodeableConcept.class);
                    this.accept(this.member, "member", visitor);
                    this.accept(this.onBehalfOf, "onBehalfOf", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Participant other = (Participant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.role, other.role) && Objects.equals(this.member, other.member) && Objects.equals(this.onBehalfOf, other.onBehalfOf) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.role, this.member, this.onBehalfOf, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> role = new ArrayList<CodeableConcept>();
            private Reference member;
            private Reference onBehalfOf;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder role(CodeableConcept ... role) {
                for (CodeableConcept value : role) {
                    this.role.add(value);
                }
                return this;
            }

            public Builder role(Collection<CodeableConcept> role) {
                this.role = new ArrayList<CodeableConcept>(role);
                return this;
            }

            public Builder member(Reference member) {
                this.member = member;
                return this;
            }

            public Builder onBehalfOf(Reference onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public Participant build() {
                Participant participant = new Participant(this);
                if (this.validating) {
                    this.validate(participant);
                }
                return participant;
            }

            protected void validate(Participant participant) {
                super.validate(participant);
                ValidationSupport.checkList(participant.role, "role", CodeableConcept.class);
                ValidationSupport.checkReferenceType(participant.member, "member", "Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Organization", "CareTeam");
                ValidationSupport.checkReferenceType(participant.onBehalfOf, "onBehalfOf", "Organization");
                ValidationSupport.requireValueOrChildren(participant);
            }

            protected Builder from(Participant participant) {
                super.from(participant);
                this.role.addAll(participant.role);
                this.member = participant.member;
                this.onBehalfOf = participant.onBehalfOf;
                this.period = participant.period;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CareTeamStatus status;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private String name;
        private Reference subject;
        private Reference encounter;
        private Period period;
        private List<Participant> participant = new ArrayList<Participant>();
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Reference> managingOrganization = new ArrayList<Reference>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(CareTeamStatus status) {
            this.status = status;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder participant(Participant ... participant) {
            for (Participant value : participant) {
                this.participant.add(value);
            }
            return this;
        }

        public Builder participant(Collection<Participant> participant) {
            this.participant = new ArrayList<Participant>(participant);
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder managingOrganization(Reference ... managingOrganization) {
            for (Reference value : managingOrganization) {
                this.managingOrganization.add(value);
            }
            return this;
        }

        public Builder managingOrganization(Collection<Reference> managingOrganization) {
            this.managingOrganization = new ArrayList<Reference>(managingOrganization);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public CareTeam build() {
            CareTeam careTeam = new CareTeam(this);
            if (this.validating) {
                this.validate(careTeam);
            }
            return careTeam;
        }

        protected void validate(CareTeam careTeam) {
            super.validate(careTeam);
            ValidationSupport.checkList(careTeam.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(careTeam.category, "category", CodeableConcept.class);
            ValidationSupport.checkList(careTeam.participant, "participant", Participant.class);
            ValidationSupport.checkList(careTeam.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(careTeam.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(careTeam.managingOrganization, "managingOrganization", Reference.class);
            ValidationSupport.checkList(careTeam.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(careTeam.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(careTeam.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(careTeam.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(careTeam.reasonReference, "reasonReference", "Condition");
            ValidationSupport.checkReferenceType(careTeam.managingOrganization, "managingOrganization", "Organization");
        }

        protected Builder from(CareTeam careTeam) {
            super.from(careTeam);
            this.identifier.addAll(careTeam.identifier);
            this.status = careTeam.status;
            this.category.addAll(careTeam.category);
            this.name = careTeam.name;
            this.subject = careTeam.subject;
            this.encounter = careTeam.encounter;
            this.period = careTeam.period;
            this.participant.addAll(careTeam.participant);
            this.reasonCode.addAll(careTeam.reasonCode);
            this.reasonReference.addAll(careTeam.reasonReference);
            this.managingOrganization.addAll(careTeam.managingOrganization);
            this.telecom.addAll(careTeam.telecom);
            this.note.addAll(careTeam.note);
            return this;
        }
    }
}

