/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Address;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.HumanName;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.PositiveInt;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cnl-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/Citation"), @Constraint(id="citation-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-2", level="Warning", location="summary.style", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/citation-summary-style", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/citation-summary-style', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-3", level="Warning", location="classification.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/citation-classification-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/citation-classification-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-4", level="Warning", location="relatesTo.relationshipType", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/artifact-relationship-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/artifact-relationship-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-5", level="Warning", location="citedArtifact.currentState", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/cited-artifact-status-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/cited-artifact-status-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-6", level="Warning", location="citedArtifact.statusDate.activity", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/cited-artifact-status-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/cited-artifact-status-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-7", level="Warning", location="citedArtifact.title.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/title-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/title-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-8", level="Warning", location="citedArtifact.title.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-9", level="Warning", location="citedArtifact.abstract.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/cited-artifact-abstract-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/cited-artifact-abstract-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-10", level="Warning", location="citedArtifact.abstract.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-11", level="Warning", location="citedArtifact.part.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/cited-artifact-part-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/cited-artifact-part-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-12", level="Warning", location="citedArtifact.relatesTo.relationshipType", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/artifact-relationship-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/artifact-relationship-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-13", level="Warning", location="citedArtifact.publicationForm.publishedIn.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/published-in-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/published-in-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-14", level="Warning", location="citedArtifact.publicationForm.periodicRelease.citedMedium", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/cited-medium", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/cited-medium', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-15", level="Warning", location="citedArtifact.publicationForm.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-16", level="Warning", location="citedArtifact.webLocation.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/article-url-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/article-url-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-17", level="Warning", location="citedArtifact.classification.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/cited-artifact-classification-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/cited-artifact-classification-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-18", level="Warning", location="citedArtifact.contributorship.entry.contributionType", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/artifact-contribution-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/artifact-contribution-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-19", level="Warning", location="citedArtifact.contributorship.entry.role", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/contributor-role", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/contributor-role', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-20", level="Warning", location="citedArtifact.contributorship.entry.contributionInstance.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/artifact-contribution-instance-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/artifact-contribution-instance-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-21", level="Warning", location="citedArtifact.contributorship.summary.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/contributor-summary-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/contributor-summary-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-22", level="Warning", location="citedArtifact.contributorship.summary.style", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/contributor-summary-style", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/contributor-summary-style', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true), @Constraint(id="citation-23", level="Warning", location="citedArtifact.contributorship.summary.source", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/contributor-summary-source", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/contributor-summary-source', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Citation", generated=true)})
public class Citation
extends DomainResource {
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final Uri url;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final List<Identifier> identifier;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final String version;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final String name;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final String title;
    @org.linuxforhealth.fhir.model.annotation.Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final Boolean experimental;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final DateTime date;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final String publisher;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final List<UsageContext> useContext;
    @org.linuxforhealth.fhir.model.annotation.Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @org.linuxforhealth.fhir.model.annotation.Summary
    private final Period effectivePeriod;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<Summary> summary;
    private final List<Classification> classification;
    private final List<Annotation> note;
    @Binding(bindingName="CitationStatusType", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/citation-status-type")
    private final List<CodeableConcept> currentState;
    private final List<StatusDate> statusDate;
    private final List<RelatesTo> relatesTo;
    private final CitedArtifact citedArtifact;

    private Citation(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.summary = Collections.unmodifiableList(builder.summary);
        this.classification = Collections.unmodifiableList(builder.classification);
        this.note = Collections.unmodifiableList(builder.note);
        this.currentState = Collections.unmodifiableList(builder.currentState);
        this.statusDate = Collections.unmodifiableList(builder.statusDate);
        this.relatesTo = Collections.unmodifiableList(builder.relatesTo);
        this.citedArtifact = builder.citedArtifact;
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<Summary> getSummary() {
        return this.summary;
    }

    public List<Classification> getClassification() {
        return this.classification;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<CodeableConcept> getCurrentState() {
        return this.currentState;
    }

    public List<StatusDate> getStatusDate() {
        return this.statusDate;
    }

    public List<RelatesTo> getRelatesTo() {
        return this.relatesTo;
    }

    public CitedArtifact getCitedArtifact() {
        return this.citedArtifact;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.summary.isEmpty() || !this.classification.isEmpty() || !this.note.isEmpty() || !this.currentState.isEmpty() || !this.statusDate.isEmpty() || !this.relatesTo.isEmpty() || this.citedArtifact != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.summary, "summary", visitor, Summary.class);
                this.accept(this.classification, "classification", visitor, Classification.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.currentState, "currentState", visitor, CodeableConcept.class);
                this.accept(this.statusDate, "statusDate", visitor, StatusDate.class);
                this.accept(this.relatesTo, "relatesTo", visitor, RelatesTo.class);
                this.accept(this.citedArtifact, "citedArtifact", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Citation other = (Citation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.summary, other.summary) && Objects.equals(this.classification, other.classification) && Objects.equals(this.note, other.note) && Objects.equals(this.currentState, other.currentState) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.relatesTo, other.relatesTo) && Objects.equals(this.citedArtifact, other.citedArtifact);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.author, this.editor, this.reviewer, this.endorser, this.summary, this.classification, this.note, this.currentState, this.statusDate, this.relatesTo, this.citedArtifact);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class CitedArtifact
    extends BackboneElement {
        @org.linuxforhealth.fhir.model.annotation.Summary
        private final List<Identifier> identifier;
        @org.linuxforhealth.fhir.model.annotation.Summary
        private final List<Identifier> relatedIdentifier;
        @org.linuxforhealth.fhir.model.annotation.Summary
        private final DateTime dateAccessed;
        private final Version version;
        @Binding(bindingName="CitedArtifactStatusType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-status-type")
        private final List<CodeableConcept> currentState;
        private final List<StatusDate> statusDate;
        private final List<Title> title;
        private final List<Abstract> _abstract;
        private final Part part;
        private final List<RelatesTo> relatesTo;
        private final List<PublicationForm> publicationForm;
        private final List<WebLocation> webLocation;
        private final List<Classification> classification;
        private final Contributorship contributorship;
        private final List<Annotation> note;

        private CitedArtifact(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.relatedIdentifier = Collections.unmodifiableList(builder.relatedIdentifier);
            this.dateAccessed = builder.dateAccessed;
            this.version = builder.version;
            this.currentState = Collections.unmodifiableList(builder.currentState);
            this.statusDate = Collections.unmodifiableList(builder.statusDate);
            this.title = Collections.unmodifiableList(builder.title);
            this._abstract = Collections.unmodifiableList(builder._abstract);
            this.part = builder.part;
            this.relatesTo = Collections.unmodifiableList(builder.relatesTo);
            this.publicationForm = Collections.unmodifiableList(builder.publicationForm);
            this.webLocation = Collections.unmodifiableList(builder.webLocation);
            this.classification = Collections.unmodifiableList(builder.classification);
            this.contributorship = builder.contributorship;
            this.note = Collections.unmodifiableList(builder.note);
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public List<Identifier> getRelatedIdentifier() {
            return this.relatedIdentifier;
        }

        public DateTime getDateAccessed() {
            return this.dateAccessed;
        }

        public Version getVersion() {
            return this.version;
        }

        public List<CodeableConcept> getCurrentState() {
            return this.currentState;
        }

        public List<StatusDate> getStatusDate() {
            return this.statusDate;
        }

        public List<Title> getTitle() {
            return this.title;
        }

        public List<Abstract> getAbstract() {
            return this._abstract;
        }

        public Part getPart() {
            return this.part;
        }

        public List<RelatesTo> getRelatesTo() {
            return this.relatesTo;
        }

        public List<PublicationForm> getPublicationForm() {
            return this.publicationForm;
        }

        public List<WebLocation> getWebLocation() {
            return this.webLocation;
        }

        public List<Classification> getClassification() {
            return this.classification;
        }

        public Contributorship getContributorship() {
            return this.contributorship;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || !this.relatedIdentifier.isEmpty() || this.dateAccessed != null || this.version != null || !this.currentState.isEmpty() || !this.statusDate.isEmpty() || !this.title.isEmpty() || !this._abstract.isEmpty() || this.part != null || !this.relatesTo.isEmpty() || !this.publicationForm.isEmpty() || !this.webLocation.isEmpty() || !this.classification.isEmpty() || this.contributorship != null || !this.note.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.relatedIdentifier, "relatedIdentifier", visitor, Identifier.class);
                    this.accept(this.dateAccessed, "dateAccessed", visitor);
                    this.accept(this.version, "version", visitor);
                    this.accept(this.currentState, "currentState", visitor, CodeableConcept.class);
                    this.accept(this.statusDate, "statusDate", visitor, StatusDate.class);
                    this.accept(this.title, "title", visitor, Title.class);
                    this.accept(this._abstract, "abstract", visitor, Abstract.class);
                    this.accept(this.part, "part", visitor);
                    this.accept(this.relatesTo, "relatesTo", visitor, RelatesTo.class);
                    this.accept(this.publicationForm, "publicationForm", visitor, PublicationForm.class);
                    this.accept(this.webLocation, "webLocation", visitor, WebLocation.class);
                    this.accept(this.classification, "classification", visitor, Classification.class);
                    this.accept(this.contributorship, "contributorship", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CitedArtifact other = (CitedArtifact)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.relatedIdentifier, other.relatedIdentifier) && Objects.equals(this.dateAccessed, other.dateAccessed) && Objects.equals(this.version, other.version) && Objects.equals(this.currentState, other.currentState) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.title, other.title) && Objects.equals(this._abstract, other._abstract) && Objects.equals(this.part, other.part) && Objects.equals(this.relatesTo, other.relatesTo) && Objects.equals(this.publicationForm, other.publicationForm) && Objects.equals(this.webLocation, other.webLocation) && Objects.equals(this.classification, other.classification) && Objects.equals(this.contributorship, other.contributorship) && Objects.equals(this.note, other.note);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.relatedIdentifier, this.dateAccessed, this.version, this.currentState, this.statusDate, this.title, this._abstract, this.part, this.relatesTo, this.publicationForm, this.webLocation, this.classification, this.contributorship, this.note);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Contributorship
        extends BackboneElement {
            private final Boolean complete;
            private final List<Entry> entry;
            private final List<Summary> summary;

            private Contributorship(Builder builder) {
                super(builder);
                this.complete = builder.complete;
                this.entry = Collections.unmodifiableList(builder.entry);
                this.summary = Collections.unmodifiableList(builder.summary);
            }

            public Boolean getComplete() {
                return this.complete;
            }

            public List<Entry> getEntry() {
                return this.entry;
            }

            public List<Summary> getSummary() {
                return this.summary;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.complete != null || !this.entry.isEmpty() || !this.summary.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.complete, "complete", visitor);
                        this.accept(this.entry, "entry", visitor, Entry.class);
                        this.accept(this.summary, "summary", visitor, Summary.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Contributorship other = (Contributorship)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.complete, other.complete) && Objects.equals(this.entry, other.entry) && Objects.equals(this.summary, other.summary);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.complete, this.entry, this.summary);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Summary
            extends BackboneElement {
                @Binding(bindingName="ContributorSummaryType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-type")
                private final CodeableConcept type;
                @Binding(bindingName="ContributorSummaryStyle", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-style")
                private final CodeableConcept style;
                @Binding(bindingName="ContributorSummarySource", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-source")
                private final CodeableConcept source;
                @Required
                private final Markdown value;

                private Summary(Builder builder) {
                    super(builder);
                    this.type = builder.type;
                    this.style = builder.style;
                    this.source = builder.source;
                    this.value = builder.value;
                }

                public CodeableConcept getType() {
                    return this.type;
                }

                public CodeableConcept getStyle() {
                    return this.style;
                }

                public CodeableConcept getSource() {
                    return this.source;
                }

                public Markdown getValue() {
                    return this.value;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.type != null || this.style != null || this.source != null || this.value != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.style, "style", visitor);
                            this.accept(this.source, "source", visitor);
                            this.accept(this.value, "value", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Summary other = (Summary)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.style, other.style) && Objects.equals(this.source, other.source) && Objects.equals(this.value, other.value);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.style, this.source, this.value);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept type;
                    private CodeableConcept style;
                    private CodeableConcept source;
                    private Markdown value;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder type(CodeableConcept type) {
                        this.type = type;
                        return this;
                    }

                    public Builder style(CodeableConcept style) {
                        this.style = style;
                        return this;
                    }

                    public Builder source(CodeableConcept source) {
                        this.source = source;
                        return this;
                    }

                    public Builder value(Markdown value) {
                        this.value = value;
                        return this;
                    }

                    @Override
                    public Summary build() {
                        Summary summary = new Summary(this);
                        if (this.validating) {
                            this.validate(summary);
                        }
                        return summary;
                    }

                    protected void validate(Summary summary) {
                        super.validate(summary);
                        ValidationSupport.requireNonNull(summary.value, "value");
                        ValidationSupport.requireValueOrChildren(summary);
                    }

                    protected Builder from(Summary summary) {
                        super.from(summary);
                        this.type = summary.type;
                        this.style = summary.style;
                        this.source = summary.source;
                        this.value = summary.value;
                        return this;
                    }
                }
            }

            public static class Entry
            extends BackboneElement {
                private final HumanName name;
                private final String initials;
                private final String collectiveName;
                private final List<Identifier> identifier;
                private final List<AffiliationInfo> affiliationInfo;
                private final List<Address> address;
                private final List<ContactPoint> telecom;
                @Binding(bindingName="ArtifactContributionType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/artifact-contribution-type")
                private final List<CodeableConcept> contributionType;
                @Binding(bindingName="ContributorRole", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/contributor-role")
                private final CodeableConcept role;
                private final List<ContributionInstance> contributionInstance;
                private final Boolean correspondingContact;
                private final PositiveInt listOrder;

                private Entry(Builder builder) {
                    super(builder);
                    this.name = builder.name;
                    this.initials = builder.initials;
                    this.collectiveName = builder.collectiveName;
                    this.identifier = Collections.unmodifiableList(builder.identifier);
                    this.affiliationInfo = Collections.unmodifiableList(builder.affiliationInfo);
                    this.address = Collections.unmodifiableList(builder.address);
                    this.telecom = Collections.unmodifiableList(builder.telecom);
                    this.contributionType = Collections.unmodifiableList(builder.contributionType);
                    this.role = builder.role;
                    this.contributionInstance = Collections.unmodifiableList(builder.contributionInstance);
                    this.correspondingContact = builder.correspondingContact;
                    this.listOrder = builder.listOrder;
                }

                public HumanName getName() {
                    return this.name;
                }

                public String getInitials() {
                    return this.initials;
                }

                public String getCollectiveName() {
                    return this.collectiveName;
                }

                public List<Identifier> getIdentifier() {
                    return this.identifier;
                }

                public List<AffiliationInfo> getAffiliationInfo() {
                    return this.affiliationInfo;
                }

                public List<Address> getAddress() {
                    return this.address;
                }

                public List<ContactPoint> getTelecom() {
                    return this.telecom;
                }

                public List<CodeableConcept> getContributionType() {
                    return this.contributionType;
                }

                public CodeableConcept getRole() {
                    return this.role;
                }

                public List<ContributionInstance> getContributionInstance() {
                    return this.contributionInstance;
                }

                public Boolean getCorrespondingContact() {
                    return this.correspondingContact;
                }

                public PositiveInt getListOrder() {
                    return this.listOrder;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.name != null || this.initials != null || this.collectiveName != null || !this.identifier.isEmpty() || !this.affiliationInfo.isEmpty() || !this.address.isEmpty() || !this.telecom.isEmpty() || !this.contributionType.isEmpty() || this.role != null || !this.contributionInstance.isEmpty() || this.correspondingContact != null || this.listOrder != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.name, "name", visitor);
                            this.accept(this.initials, "initials", visitor);
                            this.accept(this.collectiveName, "collectiveName", visitor);
                            this.accept(this.identifier, "identifier", visitor, Identifier.class);
                            this.accept(this.affiliationInfo, "affiliationInfo", visitor, AffiliationInfo.class);
                            this.accept(this.address, "address", visitor, Address.class);
                            this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                            this.accept(this.contributionType, "contributionType", visitor, CodeableConcept.class);
                            this.accept(this.role, "role", visitor);
                            this.accept(this.contributionInstance, "contributionInstance", visitor, ContributionInstance.class);
                            this.accept(this.correspondingContact, "correspondingContact", visitor);
                            this.accept(this.listOrder, "listOrder", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Entry other = (Entry)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.initials, other.initials) && Objects.equals(this.collectiveName, other.collectiveName) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.affiliationInfo, other.affiliationInfo) && Objects.equals(this.address, other.address) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.contributionType, other.contributionType) && Objects.equals(this.role, other.role) && Objects.equals(this.contributionInstance, other.contributionInstance) && Objects.equals(this.correspondingContact, other.correspondingContact) && Objects.equals(this.listOrder, other.listOrder);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.initials, this.collectiveName, this.identifier, this.affiliationInfo, this.address, this.telecom, this.contributionType, this.role, this.contributionInstance, this.correspondingContact, this.listOrder);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class ContributionInstance
                extends BackboneElement {
                    @Binding(bindingName="ArtifactContributionInstanceType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/artifact-contribution-instance-type")
                    @Required
                    private final CodeableConcept type;
                    private final DateTime time;

                    private ContributionInstance(Builder builder) {
                        super(builder);
                        this.type = builder.type;
                        this.time = builder.time;
                    }

                    public CodeableConcept getType() {
                        return this.type;
                    }

                    public DateTime getTime() {
                        return this.time;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.type != null || this.time != null;
                    }

                    @Override
                    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.type, "type", visitor);
                                this.accept(this.time, "time", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        ContributionInstance other = (ContributionInstance)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.time, other.time);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.time);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private CodeableConcept type;
                        private DateTime time;

                        private Builder() {
                        }

                        @Override
                        public Builder id(java.lang.String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder type(CodeableConcept type) {
                            this.type = type;
                            return this;
                        }

                        public Builder time(DateTime time) {
                            this.time = time;
                            return this;
                        }

                        @Override
                        public ContributionInstance build() {
                            ContributionInstance contributionInstance = new ContributionInstance(this);
                            if (this.validating) {
                                this.validate(contributionInstance);
                            }
                            return contributionInstance;
                        }

                        protected void validate(ContributionInstance contributionInstance) {
                            super.validate(contributionInstance);
                            ValidationSupport.requireNonNull(contributionInstance.type, "type");
                            ValidationSupport.requireValueOrChildren(contributionInstance);
                        }

                        protected Builder from(ContributionInstance contributionInstance) {
                            super.from(contributionInstance);
                            this.type = contributionInstance.type;
                            this.time = contributionInstance.time;
                            return this;
                        }
                    }
                }

                public static class AffiliationInfo
                extends BackboneElement {
                    private final String affiliation;
                    private final String role;
                    private final List<Identifier> identifier;

                    private AffiliationInfo(Builder builder) {
                        super(builder);
                        this.affiliation = builder.affiliation;
                        this.role = builder.role;
                        this.identifier = Collections.unmodifiableList(builder.identifier);
                    }

                    public String getAffiliation() {
                        return this.affiliation;
                    }

                    public String getRole() {
                        return this.role;
                    }

                    public List<Identifier> getIdentifier() {
                        return this.identifier;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.affiliation != null || this.role != null || !this.identifier.isEmpty();
                    }

                    @Override
                    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.affiliation, "affiliation", visitor);
                                this.accept(this.role, "role", visitor);
                                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        AffiliationInfo other = (AffiliationInfo)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.affiliation, other.affiliation) && Objects.equals(this.role, other.role) && Objects.equals(this.identifier, other.identifier);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.affiliation, this.role, this.identifier);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private String affiliation;
                        private String role;
                        private List<Identifier> identifier = new ArrayList<Identifier>();

                        private Builder() {
                        }

                        @Override
                        public Builder id(java.lang.String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder affiliation(java.lang.String affiliation) {
                            this.affiliation = affiliation == null ? null : String.of(affiliation);
                            return this;
                        }

                        public Builder affiliation(String affiliation) {
                            this.affiliation = affiliation;
                            return this;
                        }

                        public Builder role(java.lang.String role) {
                            this.role = role == null ? null : String.of(role);
                            return this;
                        }

                        public Builder role(String role) {
                            this.role = role;
                            return this;
                        }

                        public Builder identifier(Identifier ... identifier) {
                            for (Identifier value : identifier) {
                                this.identifier.add(value);
                            }
                            return this;
                        }

                        public Builder identifier(Collection<Identifier> identifier) {
                            this.identifier = new ArrayList<Identifier>(identifier);
                            return this;
                        }

                        @Override
                        public AffiliationInfo build() {
                            AffiliationInfo affiliationInfo = new AffiliationInfo(this);
                            if (this.validating) {
                                this.validate(affiliationInfo);
                            }
                            return affiliationInfo;
                        }

                        protected void validate(AffiliationInfo affiliationInfo) {
                            super.validate(affiliationInfo);
                            ValidationSupport.checkList(affiliationInfo.identifier, "identifier", Identifier.class);
                            ValidationSupport.requireValueOrChildren(affiliationInfo);
                        }

                        protected Builder from(AffiliationInfo affiliationInfo) {
                            super.from(affiliationInfo);
                            this.affiliation = affiliationInfo.affiliation;
                            this.role = affiliationInfo.role;
                            this.identifier.addAll(affiliationInfo.identifier);
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private HumanName name;
                    private String initials;
                    private String collectiveName;
                    private List<Identifier> identifier = new ArrayList<Identifier>();
                    private List<AffiliationInfo> affiliationInfo = new ArrayList<AffiliationInfo>();
                    private List<Address> address = new ArrayList<Address>();
                    private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
                    private List<CodeableConcept> contributionType = new ArrayList<CodeableConcept>();
                    private CodeableConcept role;
                    private List<ContributionInstance> contributionInstance = new ArrayList<ContributionInstance>();
                    private Boolean correspondingContact;
                    private PositiveInt listOrder;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder name(HumanName name) {
                        this.name = name;
                        return this;
                    }

                    public Builder initials(java.lang.String initials) {
                        this.initials = initials == null ? null : String.of(initials);
                        return this;
                    }

                    public Builder initials(String initials) {
                        this.initials = initials;
                        return this;
                    }

                    public Builder collectiveName(java.lang.String collectiveName) {
                        this.collectiveName = collectiveName == null ? null : String.of(collectiveName);
                        return this;
                    }

                    public Builder collectiveName(String collectiveName) {
                        this.collectiveName = collectiveName;
                        return this;
                    }

                    public Builder identifier(Identifier ... identifier) {
                        for (Identifier value : identifier) {
                            this.identifier.add(value);
                        }
                        return this;
                    }

                    public Builder identifier(Collection<Identifier> identifier) {
                        this.identifier = new ArrayList<Identifier>(identifier);
                        return this;
                    }

                    public Builder affiliationInfo(AffiliationInfo ... affiliationInfo) {
                        for (AffiliationInfo value : affiliationInfo) {
                            this.affiliationInfo.add(value);
                        }
                        return this;
                    }

                    public Builder affiliationInfo(Collection<AffiliationInfo> affiliationInfo) {
                        this.affiliationInfo = new ArrayList<AffiliationInfo>(affiliationInfo);
                        return this;
                    }

                    public Builder address(Address ... address) {
                        for (Address value : address) {
                            this.address.add(value);
                        }
                        return this;
                    }

                    public Builder address(Collection<Address> address) {
                        this.address = new ArrayList<Address>(address);
                        return this;
                    }

                    public Builder telecom(ContactPoint ... telecom) {
                        for (ContactPoint value : telecom) {
                            this.telecom.add(value);
                        }
                        return this;
                    }

                    public Builder telecom(Collection<ContactPoint> telecom) {
                        this.telecom = new ArrayList<ContactPoint>(telecom);
                        return this;
                    }

                    public Builder contributionType(CodeableConcept ... contributionType) {
                        for (CodeableConcept value : contributionType) {
                            this.contributionType.add(value);
                        }
                        return this;
                    }

                    public Builder contributionType(Collection<CodeableConcept> contributionType) {
                        this.contributionType = new ArrayList<CodeableConcept>(contributionType);
                        return this;
                    }

                    public Builder role(CodeableConcept role) {
                        this.role = role;
                        return this;
                    }

                    public Builder contributionInstance(ContributionInstance ... contributionInstance) {
                        for (ContributionInstance value : contributionInstance) {
                            this.contributionInstance.add(value);
                        }
                        return this;
                    }

                    public Builder contributionInstance(Collection<ContributionInstance> contributionInstance) {
                        this.contributionInstance = new ArrayList<ContributionInstance>(contributionInstance);
                        return this;
                    }

                    public Builder correspondingContact(java.lang.Boolean correspondingContact) {
                        this.correspondingContact = correspondingContact == null ? null : Boolean.of(correspondingContact);
                        return this;
                    }

                    public Builder correspondingContact(Boolean correspondingContact) {
                        this.correspondingContact = correspondingContact;
                        return this;
                    }

                    public Builder listOrder(PositiveInt listOrder) {
                        this.listOrder = listOrder;
                        return this;
                    }

                    @Override
                    public Entry build() {
                        Entry entry = new Entry(this);
                        if (this.validating) {
                            this.validate(entry);
                        }
                        return entry;
                    }

                    protected void validate(Entry entry) {
                        super.validate(entry);
                        ValidationSupport.checkList(entry.identifier, "identifier", Identifier.class);
                        ValidationSupport.checkList(entry.affiliationInfo, "affiliationInfo", AffiliationInfo.class);
                        ValidationSupport.checkList(entry.address, "address", Address.class);
                        ValidationSupport.checkList(entry.telecom, "telecom", ContactPoint.class);
                        ValidationSupport.checkList(entry.contributionType, "contributionType", CodeableConcept.class);
                        ValidationSupport.checkList(entry.contributionInstance, "contributionInstance", ContributionInstance.class);
                        ValidationSupport.requireValueOrChildren(entry);
                    }

                    protected Builder from(Entry entry) {
                        super.from(entry);
                        this.name = entry.name;
                        this.initials = entry.initials;
                        this.collectiveName = entry.collectiveName;
                        this.identifier.addAll(entry.identifier);
                        this.affiliationInfo.addAll(entry.affiliationInfo);
                        this.address.addAll(entry.address);
                        this.telecom.addAll(entry.telecom);
                        this.contributionType.addAll(entry.contributionType);
                        this.role = entry.role;
                        this.contributionInstance.addAll(entry.contributionInstance);
                        this.correspondingContact = entry.correspondingContact;
                        this.listOrder = entry.listOrder;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Boolean complete;
                private List<Entry> entry = new ArrayList<Entry>();
                private List<Summary> summary = new ArrayList<Summary>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder complete(java.lang.Boolean complete) {
                    this.complete = complete == null ? null : Boolean.of(complete);
                    return this;
                }

                public Builder complete(Boolean complete) {
                    this.complete = complete;
                    return this;
                }

                public Builder entry(Entry ... entry) {
                    for (Entry value : entry) {
                        this.entry.add(value);
                    }
                    return this;
                }

                public Builder entry(Collection<Entry> entry) {
                    this.entry = new ArrayList<Entry>(entry);
                    return this;
                }

                public Builder summary(Summary ... summary) {
                    for (Summary value : summary) {
                        this.summary.add(value);
                    }
                    return this;
                }

                public Builder summary(Collection<Summary> summary) {
                    this.summary = new ArrayList<Summary>(summary);
                    return this;
                }

                @Override
                public Contributorship build() {
                    Contributorship contributorship = new Contributorship(this);
                    if (this.validating) {
                        this.validate(contributorship);
                    }
                    return contributorship;
                }

                protected void validate(Contributorship contributorship) {
                    super.validate(contributorship);
                    ValidationSupport.checkList(contributorship.entry, "entry", Entry.class);
                    ValidationSupport.checkList(contributorship.summary, "summary", Summary.class);
                    ValidationSupport.requireValueOrChildren(contributorship);
                }

                protected Builder from(Contributorship contributorship) {
                    super.from(contributorship);
                    this.complete = contributorship.complete;
                    this.entry.addAll(contributorship.entry);
                    this.summary.addAll(contributorship.summary);
                    return this;
                }
            }
        }

        public static class Classification
        extends BackboneElement {
            @Binding(bindingName="CitedArtifactClassificationType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-classification-type")
            private final CodeableConcept type;
            @Binding(bindingName="CitationArtifactClassifier", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
            private final List<CodeableConcept> classifier;
            private final WhoClassified whoClassified;

            private Classification(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.classifier = Collections.unmodifiableList(builder.classifier);
                this.whoClassified = builder.whoClassified;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public List<CodeableConcept> getClassifier() {
                return this.classifier;
            }

            public WhoClassified getWhoClassified() {
                return this.whoClassified;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || !this.classifier.isEmpty() || this.whoClassified != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.classifier, "classifier", visitor, CodeableConcept.class);
                        this.accept(this.whoClassified, "whoClassified", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Classification other = (Classification)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.whoClassified, other.whoClassified);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.classifier, this.whoClassified);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class WhoClassified
            extends BackboneElement {
                @ReferenceTarget(value={"Person", "Practitioner"})
                private final Reference person;
                @ReferenceTarget(value={"Organization"})
                private final Reference organization;
                @ReferenceTarget(value={"Organization"})
                private final Reference publisher;
                private final String classifierCopyright;
                private final Boolean freeToShare;

                private WhoClassified(Builder builder) {
                    super(builder);
                    this.person = builder.person;
                    this.organization = builder.organization;
                    this.publisher = builder.publisher;
                    this.classifierCopyright = builder.classifierCopyright;
                    this.freeToShare = builder.freeToShare;
                }

                public Reference getPerson() {
                    return this.person;
                }

                public Reference getOrganization() {
                    return this.organization;
                }

                public Reference getPublisher() {
                    return this.publisher;
                }

                public String getClassifierCopyright() {
                    return this.classifierCopyright;
                }

                public Boolean getFreeToShare() {
                    return this.freeToShare;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.person != null || this.organization != null || this.publisher != null || this.classifierCopyright != null || this.freeToShare != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.person, "person", visitor);
                            this.accept(this.organization, "organization", visitor);
                            this.accept(this.publisher, "publisher", visitor);
                            this.accept(this.classifierCopyright, "classifierCopyright", visitor);
                            this.accept(this.freeToShare, "freeToShare", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    WhoClassified other = (WhoClassified)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.person, other.person) && Objects.equals(this.organization, other.organization) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.classifierCopyright, other.classifierCopyright) && Objects.equals(this.freeToShare, other.freeToShare);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.person, this.organization, this.publisher, this.classifierCopyright, this.freeToShare);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Reference person;
                    private Reference organization;
                    private Reference publisher;
                    private String classifierCopyright;
                    private Boolean freeToShare;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder person(Reference person) {
                        this.person = person;
                        return this;
                    }

                    public Builder organization(Reference organization) {
                        this.organization = organization;
                        return this;
                    }

                    public Builder publisher(Reference publisher) {
                        this.publisher = publisher;
                        return this;
                    }

                    public Builder classifierCopyright(java.lang.String classifierCopyright) {
                        this.classifierCopyright = classifierCopyright == null ? null : String.of(classifierCopyright);
                        return this;
                    }

                    public Builder classifierCopyright(String classifierCopyright) {
                        this.classifierCopyright = classifierCopyright;
                        return this;
                    }

                    public Builder freeToShare(java.lang.Boolean freeToShare) {
                        this.freeToShare = freeToShare == null ? null : Boolean.of(freeToShare);
                        return this;
                    }

                    public Builder freeToShare(Boolean freeToShare) {
                        this.freeToShare = freeToShare;
                        return this;
                    }

                    @Override
                    public WhoClassified build() {
                        WhoClassified whoClassified = new WhoClassified(this);
                        if (this.validating) {
                            this.validate(whoClassified);
                        }
                        return whoClassified;
                    }

                    protected void validate(WhoClassified whoClassified) {
                        super.validate(whoClassified);
                        ValidationSupport.checkReferenceType(whoClassified.person, "person", "Person", "Practitioner");
                        ValidationSupport.checkReferenceType(whoClassified.organization, "organization", "Organization");
                        ValidationSupport.checkReferenceType(whoClassified.publisher, "publisher", "Organization");
                        ValidationSupport.requireValueOrChildren(whoClassified);
                    }

                    protected Builder from(WhoClassified whoClassified) {
                        super.from(whoClassified);
                        this.person = whoClassified.person;
                        this.organization = whoClassified.organization;
                        this.publisher = whoClassified.publisher;
                        this.classifierCopyright = whoClassified.classifierCopyright;
                        this.freeToShare = whoClassified.freeToShare;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private List<CodeableConcept> classifier = new ArrayList<CodeableConcept>();
                private WhoClassified whoClassified;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder classifier(CodeableConcept ... classifier) {
                    for (CodeableConcept value : classifier) {
                        this.classifier.add(value);
                    }
                    return this;
                }

                public Builder classifier(Collection<CodeableConcept> classifier) {
                    this.classifier = new ArrayList<CodeableConcept>(classifier);
                    return this;
                }

                public Builder whoClassified(WhoClassified whoClassified) {
                    this.whoClassified = whoClassified;
                    return this;
                }

                @Override
                public Classification build() {
                    Classification classification = new Classification(this);
                    if (this.validating) {
                        this.validate(classification);
                    }
                    return classification;
                }

                protected void validate(Classification classification) {
                    super.validate(classification);
                    ValidationSupport.checkList(classification.classifier, "classifier", CodeableConcept.class);
                    ValidationSupport.requireValueOrChildren(classification);
                }

                protected Builder from(Classification classification) {
                    super.from(classification);
                    this.type = classification.type;
                    this.classifier.addAll(classification.classifier);
                    this.whoClassified = classification.whoClassified;
                    return this;
                }
            }
        }

        public static class WebLocation
        extends BackboneElement {
            @Binding(bindingName="ArticleUrlType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/article-url-type")
            private final CodeableConcept type;
            private final Uri url;

            private WebLocation(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.url = builder.url;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Uri getUrl() {
                return this.url;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.url != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.url, "url", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                WebLocation other = (WebLocation)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.url, other.url);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.url);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private Uri url;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder url(Uri url) {
                    this.url = url;
                    return this;
                }

                @Override
                public WebLocation build() {
                    WebLocation webLocation = new WebLocation(this);
                    if (this.validating) {
                        this.validate(webLocation);
                    }
                    return webLocation;
                }

                protected void validate(WebLocation webLocation) {
                    super.validate(webLocation);
                    ValidationSupport.requireValueOrChildren(webLocation);
                }

                protected Builder from(WebLocation webLocation) {
                    super.from(webLocation);
                    this.type = webLocation.type;
                    this.url = webLocation.url;
                    return this;
                }
            }
        }

        public static class PublicationForm
        extends BackboneElement {
            private final PublishedIn publishedIn;
            private final PeriodicRelease periodicRelease;
            private final DateTime articleDate;
            private final DateTime lastRevisionDate;
            @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, valueSet="http://hl7.org/fhir/ValueSet/languages")
            private final List<CodeableConcept> language;
            private final String accessionNumber;
            private final String pageString;
            private final String firstPage;
            private final String lastPage;
            private final String pageCount;
            private final Markdown copyright;

            private PublicationForm(Builder builder) {
                super(builder);
                this.publishedIn = builder.publishedIn;
                this.periodicRelease = builder.periodicRelease;
                this.articleDate = builder.articleDate;
                this.lastRevisionDate = builder.lastRevisionDate;
                this.language = Collections.unmodifiableList(builder.language);
                this.accessionNumber = builder.accessionNumber;
                this.pageString = builder.pageString;
                this.firstPage = builder.firstPage;
                this.lastPage = builder.lastPage;
                this.pageCount = builder.pageCount;
                this.copyright = builder.copyright;
            }

            public PublishedIn getPublishedIn() {
                return this.publishedIn;
            }

            public PeriodicRelease getPeriodicRelease() {
                return this.periodicRelease;
            }

            public DateTime getArticleDate() {
                return this.articleDate;
            }

            public DateTime getLastRevisionDate() {
                return this.lastRevisionDate;
            }

            public List<CodeableConcept> getLanguage() {
                return this.language;
            }

            public String getAccessionNumber() {
                return this.accessionNumber;
            }

            public String getPageString() {
                return this.pageString;
            }

            public String getFirstPage() {
                return this.firstPage;
            }

            public String getLastPage() {
                return this.lastPage;
            }

            public String getPageCount() {
                return this.pageCount;
            }

            public Markdown getCopyright() {
                return this.copyright;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.publishedIn != null || this.periodicRelease != null || this.articleDate != null || this.lastRevisionDate != null || !this.language.isEmpty() || this.accessionNumber != null || this.pageString != null || this.firstPage != null || this.lastPage != null || this.pageCount != null || this.copyright != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.publishedIn, "publishedIn", visitor);
                        this.accept(this.periodicRelease, "periodicRelease", visitor);
                        this.accept(this.articleDate, "articleDate", visitor);
                        this.accept(this.lastRevisionDate, "lastRevisionDate", visitor);
                        this.accept(this.language, "language", visitor, CodeableConcept.class);
                        this.accept(this.accessionNumber, "accessionNumber", visitor);
                        this.accept(this.pageString, "pageString", visitor);
                        this.accept(this.firstPage, "firstPage", visitor);
                        this.accept(this.lastPage, "lastPage", visitor);
                        this.accept(this.pageCount, "pageCount", visitor);
                        this.accept(this.copyright, "copyright", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PublicationForm other = (PublicationForm)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.publishedIn, other.publishedIn) && Objects.equals(this.periodicRelease, other.periodicRelease) && Objects.equals(this.articleDate, other.articleDate) && Objects.equals(this.lastRevisionDate, other.lastRevisionDate) && Objects.equals(this.language, other.language) && Objects.equals(this.accessionNumber, other.accessionNumber) && Objects.equals(this.pageString, other.pageString) && Objects.equals(this.firstPage, other.firstPage) && Objects.equals(this.lastPage, other.lastPage) && Objects.equals(this.pageCount, other.pageCount) && Objects.equals(this.copyright, other.copyright);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.publishedIn, this.periodicRelease, this.articleDate, this.lastRevisionDate, this.language, this.accessionNumber, this.pageString, this.firstPage, this.lastPage, this.pageCount, this.copyright);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class PeriodicRelease
            extends BackboneElement {
                @Binding(bindingName="CitedMedium", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/cited-medium")
                private final CodeableConcept citedMedium;
                private final String volume;
                private final String issue;
                private final DateOfPublication dateOfPublication;

                private PeriodicRelease(Builder builder) {
                    super(builder);
                    this.citedMedium = builder.citedMedium;
                    this.volume = builder.volume;
                    this.issue = builder.issue;
                    this.dateOfPublication = builder.dateOfPublication;
                }

                public CodeableConcept getCitedMedium() {
                    return this.citedMedium;
                }

                public String getVolume() {
                    return this.volume;
                }

                public String getIssue() {
                    return this.issue;
                }

                public DateOfPublication getDateOfPublication() {
                    return this.dateOfPublication;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.citedMedium != null || this.volume != null || this.issue != null || this.dateOfPublication != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.citedMedium, "citedMedium", visitor);
                            this.accept(this.volume, "volume", visitor);
                            this.accept(this.issue, "issue", visitor);
                            this.accept(this.dateOfPublication, "dateOfPublication", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    PeriodicRelease other = (PeriodicRelease)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.citedMedium, other.citedMedium) && Objects.equals(this.volume, other.volume) && Objects.equals(this.issue, other.issue) && Objects.equals(this.dateOfPublication, other.dateOfPublication);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.citedMedium, this.volume, this.issue, this.dateOfPublication);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class DateOfPublication
                extends BackboneElement {
                    private final Date date;
                    private final String year;
                    private final String month;
                    private final String day;
                    private final String season;
                    private final String text;

                    private DateOfPublication(Builder builder) {
                        super(builder);
                        this.date = builder.date;
                        this.year = builder.year;
                        this.month = builder.month;
                        this.day = builder.day;
                        this.season = builder.season;
                        this.text = builder.text;
                    }

                    public Date getDate() {
                        return this.date;
                    }

                    public String getYear() {
                        return this.year;
                    }

                    public String getMonth() {
                        return this.month;
                    }

                    public String getDay() {
                        return this.day;
                    }

                    public String getSeason() {
                        return this.season;
                    }

                    public String getText() {
                        return this.text;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.date != null || this.year != null || this.month != null || this.day != null || this.season != null || this.text != null;
                    }

                    @Override
                    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.date, "date", visitor);
                                this.accept(this.year, "year", visitor);
                                this.accept(this.month, "month", visitor);
                                this.accept(this.day, "day", visitor);
                                this.accept(this.season, "season", visitor);
                                this.accept(this.text, "text", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        DateOfPublication other = (DateOfPublication)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.date, other.date) && Objects.equals(this.year, other.year) && Objects.equals(this.month, other.month) && Objects.equals(this.day, other.day) && Objects.equals(this.season, other.season) && Objects.equals(this.text, other.text);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.date, this.year, this.month, this.day, this.season, this.text);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private Date date;
                        private String year;
                        private String month;
                        private String day;
                        private String season;
                        private String text;

                        private Builder() {
                        }

                        @Override
                        public Builder id(java.lang.String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder date(LocalDate date) {
                            this.date = date == null ? null : Date.of(date);
                            return this;
                        }

                        public Builder date(Date date) {
                            this.date = date;
                            return this;
                        }

                        public Builder year(java.lang.String year) {
                            this.year = year == null ? null : String.of(year);
                            return this;
                        }

                        public Builder year(String year) {
                            this.year = year;
                            return this;
                        }

                        public Builder month(java.lang.String month) {
                            this.month = month == null ? null : String.of(month);
                            return this;
                        }

                        public Builder month(String month) {
                            this.month = month;
                            return this;
                        }

                        public Builder day(java.lang.String day) {
                            this.day = day == null ? null : String.of(day);
                            return this;
                        }

                        public Builder day(String day) {
                            this.day = day;
                            return this;
                        }

                        public Builder season(java.lang.String season) {
                            this.season = season == null ? null : String.of(season);
                            return this;
                        }

                        public Builder season(String season) {
                            this.season = season;
                            return this;
                        }

                        public Builder text(java.lang.String text) {
                            this.text = text == null ? null : String.of(text);
                            return this;
                        }

                        public Builder text(String text) {
                            this.text = text;
                            return this;
                        }

                        @Override
                        public DateOfPublication build() {
                            DateOfPublication dateOfPublication = new DateOfPublication(this);
                            if (this.validating) {
                                this.validate(dateOfPublication);
                            }
                            return dateOfPublication;
                        }

                        protected void validate(DateOfPublication dateOfPublication) {
                            super.validate(dateOfPublication);
                            ValidationSupport.requireValueOrChildren(dateOfPublication);
                        }

                        protected Builder from(DateOfPublication dateOfPublication) {
                            super.from(dateOfPublication);
                            this.date = dateOfPublication.date;
                            this.year = dateOfPublication.year;
                            this.month = dateOfPublication.month;
                            this.day = dateOfPublication.day;
                            this.season = dateOfPublication.season;
                            this.text = dateOfPublication.text;
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept citedMedium;
                    private String volume;
                    private String issue;
                    private DateOfPublication dateOfPublication;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder citedMedium(CodeableConcept citedMedium) {
                        this.citedMedium = citedMedium;
                        return this;
                    }

                    public Builder volume(java.lang.String volume) {
                        this.volume = volume == null ? null : String.of(volume);
                        return this;
                    }

                    public Builder volume(String volume) {
                        this.volume = volume;
                        return this;
                    }

                    public Builder issue(java.lang.String issue) {
                        this.issue = issue == null ? null : String.of(issue);
                        return this;
                    }

                    public Builder issue(String issue) {
                        this.issue = issue;
                        return this;
                    }

                    public Builder dateOfPublication(DateOfPublication dateOfPublication) {
                        this.dateOfPublication = dateOfPublication;
                        return this;
                    }

                    @Override
                    public PeriodicRelease build() {
                        PeriodicRelease periodicRelease = new PeriodicRelease(this);
                        if (this.validating) {
                            this.validate(periodicRelease);
                        }
                        return periodicRelease;
                    }

                    protected void validate(PeriodicRelease periodicRelease) {
                        super.validate(periodicRelease);
                        ValidationSupport.requireValueOrChildren(periodicRelease);
                    }

                    protected Builder from(PeriodicRelease periodicRelease) {
                        super.from(periodicRelease);
                        this.citedMedium = periodicRelease.citedMedium;
                        this.volume = periodicRelease.volume;
                        this.issue = periodicRelease.issue;
                        this.dateOfPublication = periodicRelease.dateOfPublication;
                        return this;
                    }
                }
            }

            public static class PublishedIn
            extends BackboneElement {
                @Binding(bindingName="PublishedInType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/published-in-type")
                private final CodeableConcept type;
                private final List<Identifier> identifier;
                private final String title;
                @ReferenceTarget(value={"Organization"})
                private final Reference publisher;
                private final String publisherLocation;

                private PublishedIn(Builder builder) {
                    super(builder);
                    this.type = builder.type;
                    this.identifier = Collections.unmodifiableList(builder.identifier);
                    this.title = builder.title;
                    this.publisher = builder.publisher;
                    this.publisherLocation = builder.publisherLocation;
                }

                public CodeableConcept getType() {
                    return this.type;
                }

                public List<Identifier> getIdentifier() {
                    return this.identifier;
                }

                public String getTitle() {
                    return this.title;
                }

                public Reference getPublisher() {
                    return this.publisher;
                }

                public String getPublisherLocation() {
                    return this.publisherLocation;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.type != null || !this.identifier.isEmpty() || this.title != null || this.publisher != null || this.publisherLocation != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.identifier, "identifier", visitor, Identifier.class);
                            this.accept(this.title, "title", visitor);
                            this.accept(this.publisher, "publisher", visitor);
                            this.accept(this.publisherLocation, "publisherLocation", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    PublishedIn other = (PublishedIn)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.title, other.title) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.publisherLocation, other.publisherLocation);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.identifier, this.title, this.publisher, this.publisherLocation);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept type;
                    private List<Identifier> identifier = new ArrayList<Identifier>();
                    private String title;
                    private Reference publisher;
                    private String publisherLocation;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder type(CodeableConcept type) {
                        this.type = type;
                        return this;
                    }

                    public Builder identifier(Identifier ... identifier) {
                        for (Identifier value : identifier) {
                            this.identifier.add(value);
                        }
                        return this;
                    }

                    public Builder identifier(Collection<Identifier> identifier) {
                        this.identifier = new ArrayList<Identifier>(identifier);
                        return this;
                    }

                    public Builder title(java.lang.String title) {
                        this.title = title == null ? null : String.of(title);
                        return this;
                    }

                    public Builder title(String title) {
                        this.title = title;
                        return this;
                    }

                    public Builder publisher(Reference publisher) {
                        this.publisher = publisher;
                        return this;
                    }

                    public Builder publisherLocation(java.lang.String publisherLocation) {
                        this.publisherLocation = publisherLocation == null ? null : String.of(publisherLocation);
                        return this;
                    }

                    public Builder publisherLocation(String publisherLocation) {
                        this.publisherLocation = publisherLocation;
                        return this;
                    }

                    @Override
                    public PublishedIn build() {
                        PublishedIn publishedIn = new PublishedIn(this);
                        if (this.validating) {
                            this.validate(publishedIn);
                        }
                        return publishedIn;
                    }

                    protected void validate(PublishedIn publishedIn) {
                        super.validate(publishedIn);
                        ValidationSupport.checkList(publishedIn.identifier, "identifier", Identifier.class);
                        ValidationSupport.checkReferenceType(publishedIn.publisher, "publisher", "Organization");
                        ValidationSupport.requireValueOrChildren(publishedIn);
                    }

                    protected Builder from(PublishedIn publishedIn) {
                        super.from(publishedIn);
                        this.type = publishedIn.type;
                        this.identifier.addAll(publishedIn.identifier);
                        this.title = publishedIn.title;
                        this.publisher = publishedIn.publisher;
                        this.publisherLocation = publishedIn.publisherLocation;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private PublishedIn publishedIn;
                private PeriodicRelease periodicRelease;
                private DateTime articleDate;
                private DateTime lastRevisionDate;
                private List<CodeableConcept> language = new ArrayList<CodeableConcept>();
                private String accessionNumber;
                private String pageString;
                private String firstPage;
                private String lastPage;
                private String pageCount;
                private Markdown copyright;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder publishedIn(PublishedIn publishedIn) {
                    this.publishedIn = publishedIn;
                    return this;
                }

                public Builder periodicRelease(PeriodicRelease periodicRelease) {
                    this.periodicRelease = periodicRelease;
                    return this;
                }

                public Builder articleDate(DateTime articleDate) {
                    this.articleDate = articleDate;
                    return this;
                }

                public Builder lastRevisionDate(DateTime lastRevisionDate) {
                    this.lastRevisionDate = lastRevisionDate;
                    return this;
                }

                public Builder language(CodeableConcept ... language) {
                    for (CodeableConcept value : language) {
                        this.language.add(value);
                    }
                    return this;
                }

                public Builder language(Collection<CodeableConcept> language) {
                    this.language = new ArrayList<CodeableConcept>(language);
                    return this;
                }

                public Builder accessionNumber(java.lang.String accessionNumber) {
                    this.accessionNumber = accessionNumber == null ? null : String.of(accessionNumber);
                    return this;
                }

                public Builder accessionNumber(String accessionNumber) {
                    this.accessionNumber = accessionNumber;
                    return this;
                }

                public Builder pageString(java.lang.String pageString) {
                    this.pageString = pageString == null ? null : String.of(pageString);
                    return this;
                }

                public Builder pageString(String pageString) {
                    this.pageString = pageString;
                    return this;
                }

                public Builder firstPage(java.lang.String firstPage) {
                    this.firstPage = firstPage == null ? null : String.of(firstPage);
                    return this;
                }

                public Builder firstPage(String firstPage) {
                    this.firstPage = firstPage;
                    return this;
                }

                public Builder lastPage(java.lang.String lastPage) {
                    this.lastPage = lastPage == null ? null : String.of(lastPage);
                    return this;
                }

                public Builder lastPage(String lastPage) {
                    this.lastPage = lastPage;
                    return this;
                }

                public Builder pageCount(java.lang.String pageCount) {
                    this.pageCount = pageCount == null ? null : String.of(pageCount);
                    return this;
                }

                public Builder pageCount(String pageCount) {
                    this.pageCount = pageCount;
                    return this;
                }

                public Builder copyright(Markdown copyright) {
                    this.copyright = copyright;
                    return this;
                }

                @Override
                public PublicationForm build() {
                    PublicationForm publicationForm = new PublicationForm(this);
                    if (this.validating) {
                        this.validate(publicationForm);
                    }
                    return publicationForm;
                }

                protected void validate(PublicationForm publicationForm) {
                    super.validate(publicationForm);
                    ValidationSupport.checkList(publicationForm.language, "language", CodeableConcept.class);
                    ValidationSupport.requireValueOrChildren(publicationForm);
                }

                protected Builder from(PublicationForm publicationForm) {
                    super.from(publicationForm);
                    this.publishedIn = publicationForm.publishedIn;
                    this.periodicRelease = publicationForm.periodicRelease;
                    this.articleDate = publicationForm.articleDate;
                    this.lastRevisionDate = publicationForm.lastRevisionDate;
                    this.language.addAll(publicationForm.language);
                    this.accessionNumber = publicationForm.accessionNumber;
                    this.pageString = publicationForm.pageString;
                    this.firstPage = publicationForm.firstPage;
                    this.lastPage = publicationForm.lastPage;
                    this.pageCount = publicationForm.pageCount;
                    this.copyright = publicationForm.copyright;
                    return this;
                }
            }
        }

        public static class RelatesTo
        extends BackboneElement {
            @Binding(bindingName="ArtifactRelationshipType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/artifact-relationship-type")
            @Required
            private final CodeableConcept relationshipType;
            @Binding(bindingName="CitationArtifactClassifier", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
            private final List<CodeableConcept> targetClassifier;
            @Choice(value={Uri.class, Identifier.class, Reference.class, Attachment.class})
            @Required
            private final Element target;

            private RelatesTo(Builder builder) {
                super(builder);
                this.relationshipType = builder.relationshipType;
                this.targetClassifier = Collections.unmodifiableList(builder.targetClassifier);
                this.target = builder.target;
            }

            public CodeableConcept getRelationshipType() {
                return this.relationshipType;
            }

            public List<CodeableConcept> getTargetClassifier() {
                return this.targetClassifier;
            }

            public Element getTarget() {
                return this.target;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.relationshipType != null || !this.targetClassifier.isEmpty() || this.target != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.relationshipType, "relationshipType", visitor);
                        this.accept(this.targetClassifier, "targetClassifier", visitor, CodeableConcept.class);
                        this.accept(this.target, "target", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                RelatesTo other = (RelatesTo)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.relationshipType, other.relationshipType) && Objects.equals(this.targetClassifier, other.targetClassifier) && Objects.equals(this.target, other.target);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.relationshipType, this.targetClassifier, this.target);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept relationshipType;
                private List<CodeableConcept> targetClassifier = new ArrayList<CodeableConcept>();
                private Element target;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder relationshipType(CodeableConcept relationshipType) {
                    this.relationshipType = relationshipType;
                    return this;
                }

                public Builder targetClassifier(CodeableConcept ... targetClassifier) {
                    for (CodeableConcept value : targetClassifier) {
                        this.targetClassifier.add(value);
                    }
                    return this;
                }

                public Builder targetClassifier(Collection<CodeableConcept> targetClassifier) {
                    this.targetClassifier = new ArrayList<CodeableConcept>(targetClassifier);
                    return this;
                }

                public Builder target(Element target) {
                    this.target = target;
                    return this;
                }

                @Override
                public RelatesTo build() {
                    RelatesTo relatesTo = new RelatesTo(this);
                    if (this.validating) {
                        this.validate(relatesTo);
                    }
                    return relatesTo;
                }

                protected void validate(RelatesTo relatesTo) {
                    super.validate(relatesTo);
                    ValidationSupport.requireNonNull(relatesTo.relationshipType, "relationshipType");
                    ValidationSupport.checkList(relatesTo.targetClassifier, "targetClassifier", CodeableConcept.class);
                    ValidationSupport.requireChoiceElement(relatesTo.target, "target", Uri.class, Identifier.class, Reference.class, Attachment.class);
                    ValidationSupport.requireValueOrChildren(relatesTo);
                }

                protected Builder from(RelatesTo relatesTo) {
                    super.from(relatesTo);
                    this.relationshipType = relatesTo.relationshipType;
                    this.targetClassifier.addAll(relatesTo.targetClassifier);
                    this.target = relatesTo.target;
                    return this;
                }
            }
        }

        public static class Part
        extends BackboneElement {
            @Binding(bindingName="CitedArtifactPartType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-part-type")
            private final CodeableConcept type;
            private final String value;
            @ReferenceTarget(value={"Citation"})
            private final Reference baseCitation;

            private Part(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.value = builder.value;
                this.baseCitation = builder.baseCitation;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public String getValue() {
                return this.value;
            }

            public Reference getBaseCitation() {
                return this.baseCitation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.value != null || this.baseCitation != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.value, "value", visitor);
                        this.accept(this.baseCitation, "baseCitation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Part other = (Part)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.baseCitation, other.baseCitation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value, this.baseCitation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private String value;
                private Reference baseCitation;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder value(java.lang.String value) {
                    this.value = value == null ? null : String.of(value);
                    return this;
                }

                public Builder value(String value) {
                    this.value = value;
                    return this;
                }

                public Builder baseCitation(Reference baseCitation) {
                    this.baseCitation = baseCitation;
                    return this;
                }

                @Override
                public Part build() {
                    Part part = new Part(this);
                    if (this.validating) {
                        this.validate(part);
                    }
                    return part;
                }

                protected void validate(Part part) {
                    super.validate(part);
                    ValidationSupport.checkReferenceType(part.baseCitation, "baseCitation", "Citation");
                    ValidationSupport.requireValueOrChildren(part);
                }

                protected Builder from(Part part) {
                    super.from(part);
                    this.type = part.type;
                    this.value = part.value;
                    this.baseCitation = part.baseCitation;
                    return this;
                }
            }
        }

        public static class Abstract
        extends BackboneElement {
            @Binding(bindingName="CitedArtifactAbstractType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-abstract-type")
            private final CodeableConcept type;
            @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, valueSet="http://hl7.org/fhir/ValueSet/languages")
            private final CodeableConcept language;
            @Required
            private final Markdown text;
            private final Markdown copyright;

            private Abstract(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.language = builder.language;
                this.text = builder.text;
                this.copyright = builder.copyright;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public CodeableConcept getLanguage() {
                return this.language;
            }

            public Markdown getText() {
                return this.text;
            }

            public Markdown getCopyright() {
                return this.copyright;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.language != null || this.text != null || this.copyright != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.language, "language", visitor);
                        this.accept(this.text, "text", visitor);
                        this.accept(this.copyright, "copyright", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Abstract other = (Abstract)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.copyright, other.copyright);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.language, this.text, this.copyright);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private CodeableConcept language;
                private Markdown text;
                private Markdown copyright;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder language(CodeableConcept language) {
                    this.language = language;
                    return this;
                }

                public Builder text(Markdown text) {
                    this.text = text;
                    return this;
                }

                public Builder copyright(Markdown copyright) {
                    this.copyright = copyright;
                    return this;
                }

                @Override
                public Abstract build() {
                    Abstract _abstract = new Abstract(this);
                    if (this.validating) {
                        this.validate(_abstract);
                    }
                    return _abstract;
                }

                protected void validate(Abstract _abstract) {
                    super.validate(_abstract);
                    ValidationSupport.requireNonNull(_abstract.text, "text");
                    ValidationSupport.requireValueOrChildren(_abstract);
                }

                protected Builder from(Abstract _abstract) {
                    super.from(_abstract);
                    this.type = _abstract.type;
                    this.language = _abstract.language;
                    this.text = _abstract.text;
                    this.copyright = _abstract.copyright;
                    return this;
                }
            }
        }

        public static class Title
        extends BackboneElement {
            @Binding(bindingName="TitleType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/title-type")
            private final List<CodeableConcept> type;
            @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, valueSet="http://hl7.org/fhir/ValueSet/languages")
            private final CodeableConcept language;
            @Required
            private final Markdown text;

            private Title(Builder builder) {
                super(builder);
                this.type = Collections.unmodifiableList(builder.type);
                this.language = builder.language;
                this.text = builder.text;
            }

            public List<CodeableConcept> getType() {
                return this.type;
            }

            public CodeableConcept getLanguage() {
                return this.language;
            }

            public Markdown getText() {
                return this.text;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || !this.type.isEmpty() || this.language != null || this.text != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor, CodeableConcept.class);
                        this.accept(this.language, "language", visitor);
                        this.accept(this.text, "text", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Title other = (Title)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.language, this.text);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
                private CodeableConcept language;
                private Markdown text;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept ... type) {
                    for (CodeableConcept value : type) {
                        this.type.add(value);
                    }
                    return this;
                }

                public Builder type(Collection<CodeableConcept> type) {
                    this.type = new ArrayList<CodeableConcept>(type);
                    return this;
                }

                public Builder language(CodeableConcept language) {
                    this.language = language;
                    return this;
                }

                public Builder text(Markdown text) {
                    this.text = text;
                    return this;
                }

                @Override
                public Title build() {
                    Title title = new Title(this);
                    if (this.validating) {
                        this.validate(title);
                    }
                    return title;
                }

                protected void validate(Title title) {
                    super.validate(title);
                    ValidationSupport.checkList(title.type, "type", CodeableConcept.class);
                    ValidationSupport.requireNonNull(title.text, "text");
                    ValidationSupport.requireValueOrChildren(title);
                }

                protected Builder from(Title title) {
                    super.from(title);
                    this.type.addAll(title.type);
                    this.language = title.language;
                    this.text = title.text;
                    return this;
                }
            }
        }

        public static class StatusDate
        extends BackboneElement {
            @Binding(bindingName="CitedArtifactStatusType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-status-type")
            @Required
            private final CodeableConcept activity;
            private final Boolean actual;
            @Required
            private final Period period;

            private StatusDate(Builder builder) {
                super(builder);
                this.activity = builder.activity;
                this.actual = builder.actual;
                this.period = builder.period;
            }

            public CodeableConcept getActivity() {
                return this.activity;
            }

            public Boolean getActual() {
                return this.actual;
            }

            public Period getPeriod() {
                return this.period;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.activity != null || this.actual != null || this.period != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.activity, "activity", visitor);
                        this.accept(this.actual, "actual", visitor);
                        this.accept(this.period, "period", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StatusDate other = (StatusDate)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.activity, other.activity) && Objects.equals(this.actual, other.actual) && Objects.equals(this.period, other.period);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.activity, this.actual, this.period);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept activity;
                private Boolean actual;
                private Period period;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder activity(CodeableConcept activity) {
                    this.activity = activity;
                    return this;
                }

                public Builder actual(java.lang.Boolean actual) {
                    this.actual = actual == null ? null : Boolean.of(actual);
                    return this;
                }

                public Builder actual(Boolean actual) {
                    this.actual = actual;
                    return this;
                }

                public Builder period(Period period) {
                    this.period = period;
                    return this;
                }

                @Override
                public StatusDate build() {
                    StatusDate statusDate = new StatusDate(this);
                    if (this.validating) {
                        this.validate(statusDate);
                    }
                    return statusDate;
                }

                protected void validate(StatusDate statusDate) {
                    super.validate(statusDate);
                    ValidationSupport.requireNonNull(statusDate.activity, "activity");
                    ValidationSupport.requireNonNull(statusDate.period, "period");
                    ValidationSupport.requireValueOrChildren(statusDate);
                }

                protected Builder from(StatusDate statusDate) {
                    super.from(statusDate);
                    this.activity = statusDate.activity;
                    this.actual = statusDate.actual;
                    this.period = statusDate.period;
                    return this;
                }
            }
        }

        public static class Version
        extends BackboneElement {
            @Required
            private final String value;
            @ReferenceTarget(value={"Citation"})
            private final Reference baseCitation;

            private Version(Builder builder) {
                super(builder);
                this.value = builder.value;
                this.baseCitation = builder.baseCitation;
            }

            public String getValue() {
                return this.value;
            }

            public Reference getBaseCitation() {
                return this.baseCitation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.value != null || this.baseCitation != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.value, "value", visitor);
                        this.accept(this.baseCitation, "baseCitation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Version other = (Version)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value) && Objects.equals(this.baseCitation, other.baseCitation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value, this.baseCitation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String value;
                private Reference baseCitation;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder value(java.lang.String value) {
                    this.value = value == null ? null : String.of(value);
                    return this;
                }

                public Builder value(String value) {
                    this.value = value;
                    return this;
                }

                public Builder baseCitation(Reference baseCitation) {
                    this.baseCitation = baseCitation;
                    return this;
                }

                @Override
                public Version build() {
                    Version version = new Version(this);
                    if (this.validating) {
                        this.validate(version);
                    }
                    return version;
                }

                protected void validate(Version version) {
                    super.validate(version);
                    ValidationSupport.requireNonNull(version.value, "value");
                    ValidationSupport.checkReferenceType(version.baseCitation, "baseCitation", "Citation");
                    ValidationSupport.requireValueOrChildren(version);
                }

                protected Builder from(Version version) {
                    super.from(version);
                    this.value = version.value;
                    this.baseCitation = version.baseCitation;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private List<Identifier> relatedIdentifier = new ArrayList<Identifier>();
            private DateTime dateAccessed;
            private Version version;
            private List<CodeableConcept> currentState = new ArrayList<CodeableConcept>();
            private List<StatusDate> statusDate = new ArrayList<StatusDate>();
            private List<Title> title = new ArrayList<Title>();
            private List<Abstract> _abstract = new ArrayList<Abstract>();
            private Part part;
            private List<RelatesTo> relatesTo = new ArrayList<RelatesTo>();
            private List<PublicationForm> publicationForm = new ArrayList<PublicationForm>();
            private List<WebLocation> webLocation = new ArrayList<WebLocation>();
            private List<Classification> classification = new ArrayList<Classification>();
            private Contributorship contributorship;
            private List<Annotation> note = new ArrayList<Annotation>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder relatedIdentifier(Identifier ... relatedIdentifier) {
                for (Identifier value : relatedIdentifier) {
                    this.relatedIdentifier.add(value);
                }
                return this;
            }

            public Builder relatedIdentifier(Collection<Identifier> relatedIdentifier) {
                this.relatedIdentifier = new ArrayList<Identifier>(relatedIdentifier);
                return this;
            }

            public Builder dateAccessed(DateTime dateAccessed) {
                this.dateAccessed = dateAccessed;
                return this;
            }

            public Builder version(Version version) {
                this.version = version;
                return this;
            }

            public Builder currentState(CodeableConcept ... currentState) {
                for (CodeableConcept value : currentState) {
                    this.currentState.add(value);
                }
                return this;
            }

            public Builder currentState(Collection<CodeableConcept> currentState) {
                this.currentState = new ArrayList<CodeableConcept>(currentState);
                return this;
            }

            public Builder statusDate(StatusDate ... statusDate) {
                for (StatusDate value : statusDate) {
                    this.statusDate.add(value);
                }
                return this;
            }

            public Builder statusDate(Collection<StatusDate> statusDate) {
                this.statusDate = new ArrayList<StatusDate>(statusDate);
                return this;
            }

            public Builder title(Title ... title) {
                for (Title value : title) {
                    this.title.add(value);
                }
                return this;
            }

            public Builder title(Collection<Title> title) {
                this.title = new ArrayList<Title>(title);
                return this;
            }

            public Builder _abstract(Abstract ... _abstract) {
                for (Abstract value : _abstract) {
                    this._abstract.add(value);
                }
                return this;
            }

            public Builder _abstract(Collection<Abstract> _abstract) {
                this._abstract = new ArrayList<Abstract>(_abstract);
                return this;
            }

            public Builder part(Part part) {
                this.part = part;
                return this;
            }

            public Builder relatesTo(RelatesTo ... relatesTo) {
                for (RelatesTo value : relatesTo) {
                    this.relatesTo.add(value);
                }
                return this;
            }

            public Builder relatesTo(Collection<RelatesTo> relatesTo) {
                this.relatesTo = new ArrayList<RelatesTo>(relatesTo);
                return this;
            }

            public Builder publicationForm(PublicationForm ... publicationForm) {
                for (PublicationForm value : publicationForm) {
                    this.publicationForm.add(value);
                }
                return this;
            }

            public Builder publicationForm(Collection<PublicationForm> publicationForm) {
                this.publicationForm = new ArrayList<PublicationForm>(publicationForm);
                return this;
            }

            public Builder webLocation(WebLocation ... webLocation) {
                for (WebLocation value : webLocation) {
                    this.webLocation.add(value);
                }
                return this;
            }

            public Builder webLocation(Collection<WebLocation> webLocation) {
                this.webLocation = new ArrayList<WebLocation>(webLocation);
                return this;
            }

            public Builder classification(Classification ... classification) {
                for (Classification value : classification) {
                    this.classification.add(value);
                }
                return this;
            }

            public Builder classification(Collection<Classification> classification) {
                this.classification = new ArrayList<Classification>(classification);
                return this;
            }

            public Builder contributorship(Contributorship contributorship) {
                this.contributorship = contributorship;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            @Override
            public CitedArtifact build() {
                CitedArtifact citedArtifact = new CitedArtifact(this);
                if (this.validating) {
                    this.validate(citedArtifact);
                }
                return citedArtifact;
            }

            protected void validate(CitedArtifact citedArtifact) {
                super.validate(citedArtifact);
                ValidationSupport.checkList(citedArtifact.identifier, "identifier", Identifier.class);
                ValidationSupport.checkList(citedArtifact.relatedIdentifier, "relatedIdentifier", Identifier.class);
                ValidationSupport.checkList(citedArtifact.currentState, "currentState", CodeableConcept.class);
                ValidationSupport.checkList(citedArtifact.statusDate, "statusDate", StatusDate.class);
                ValidationSupport.checkList(citedArtifact.title, "title", Title.class);
                ValidationSupport.checkList(citedArtifact._abstract, "abstract", Abstract.class);
                ValidationSupport.checkList(citedArtifact.relatesTo, "relatesTo", RelatesTo.class);
                ValidationSupport.checkList(citedArtifact.publicationForm, "publicationForm", PublicationForm.class);
                ValidationSupport.checkList(citedArtifact.webLocation, "webLocation", WebLocation.class);
                ValidationSupport.checkList(citedArtifact.classification, "classification", Classification.class);
                ValidationSupport.checkList(citedArtifact.note, "note", Annotation.class);
                ValidationSupport.requireValueOrChildren(citedArtifact);
            }

            protected Builder from(CitedArtifact citedArtifact) {
                super.from(citedArtifact);
                this.identifier.addAll(citedArtifact.identifier);
                this.relatedIdentifier.addAll(citedArtifact.relatedIdentifier);
                this.dateAccessed = citedArtifact.dateAccessed;
                this.version = citedArtifact.version;
                this.currentState.addAll(citedArtifact.currentState);
                this.statusDate.addAll(citedArtifact.statusDate);
                this.title.addAll(citedArtifact.title);
                this._abstract.addAll(citedArtifact._abstract);
                this.part = citedArtifact.part;
                this.relatesTo.addAll(citedArtifact.relatesTo);
                this.publicationForm.addAll(citedArtifact.publicationForm);
                this.webLocation.addAll(citedArtifact.webLocation);
                this.classification.addAll(citedArtifact.classification);
                this.contributorship = citedArtifact.contributorship;
                this.note.addAll(citedArtifact.note);
                return this;
            }
        }
    }

    public static class RelatesTo
    extends BackboneElement {
        @Binding(bindingName="ArtifactRelationshipType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/artifact-relationship-type")
        @Required
        private final CodeableConcept relationshipType;
        @Binding(bindingName="CitationArtifactClassifier", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        private final List<CodeableConcept> targetClassifier;
        @Choice(value={Uri.class, Identifier.class, Reference.class, Attachment.class})
        @Required
        private final Element target;

        private RelatesTo(Builder builder) {
            super(builder);
            this.relationshipType = builder.relationshipType;
            this.targetClassifier = Collections.unmodifiableList(builder.targetClassifier);
            this.target = builder.target;
        }

        public CodeableConcept getRelationshipType() {
            return this.relationshipType;
        }

        public List<CodeableConcept> getTargetClassifier() {
            return this.targetClassifier;
        }

        public Element getTarget() {
            return this.target;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.relationshipType != null || !this.targetClassifier.isEmpty() || this.target != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.relationshipType, "relationshipType", visitor);
                    this.accept(this.targetClassifier, "targetClassifier", visitor, CodeableConcept.class);
                    this.accept(this.target, "target", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelatesTo other = (RelatesTo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.relationshipType, other.relationshipType) && Objects.equals(this.targetClassifier, other.targetClassifier) && Objects.equals(this.target, other.target);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.relationshipType, this.targetClassifier, this.target);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept relationshipType;
            private List<CodeableConcept> targetClassifier = new ArrayList<CodeableConcept>();
            private Element target;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder relationshipType(CodeableConcept relationshipType) {
                this.relationshipType = relationshipType;
                return this;
            }

            public Builder targetClassifier(CodeableConcept ... targetClassifier) {
                for (CodeableConcept value : targetClassifier) {
                    this.targetClassifier.add(value);
                }
                return this;
            }

            public Builder targetClassifier(Collection<CodeableConcept> targetClassifier) {
                this.targetClassifier = new ArrayList<CodeableConcept>(targetClassifier);
                return this;
            }

            public Builder target(Element target) {
                this.target = target;
                return this;
            }

            @Override
            public RelatesTo build() {
                RelatesTo relatesTo = new RelatesTo(this);
                if (this.validating) {
                    this.validate(relatesTo);
                }
                return relatesTo;
            }

            protected void validate(RelatesTo relatesTo) {
                super.validate(relatesTo);
                ValidationSupport.requireNonNull(relatesTo.relationshipType, "relationshipType");
                ValidationSupport.checkList(relatesTo.targetClassifier, "targetClassifier", CodeableConcept.class);
                ValidationSupport.requireChoiceElement(relatesTo.target, "target", Uri.class, Identifier.class, Reference.class, Attachment.class);
                ValidationSupport.requireValueOrChildren(relatesTo);
            }

            protected Builder from(RelatesTo relatesTo) {
                super.from(relatesTo);
                this.relationshipType = relatesTo.relationshipType;
                this.targetClassifier.addAll(relatesTo.targetClassifier);
                this.target = relatesTo.target;
                return this;
            }
        }
    }

    public static class StatusDate
    extends BackboneElement {
        @Binding(bindingName="CitationStatusType", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/citation-status-type")
        @Required
        private final CodeableConcept activity;
        private final Boolean actual;
        @Required
        private final Period period;

        private StatusDate(Builder builder) {
            super(builder);
            this.activity = builder.activity;
            this.actual = builder.actual;
            this.period = builder.period;
        }

        public CodeableConcept getActivity() {
            return this.activity;
        }

        public Boolean getActual() {
            return this.actual;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.activity != null || this.actual != null || this.period != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.activity, "activity", visitor);
                    this.accept(this.actual, "actual", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatusDate other = (StatusDate)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.activity, other.activity) && Objects.equals(this.actual, other.actual) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.activity, this.actual, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept activity;
            private Boolean actual;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder activity(CodeableConcept activity) {
                this.activity = activity;
                return this;
            }

            public Builder actual(java.lang.Boolean actual) {
                this.actual = actual == null ? null : Boolean.of(actual);
                return this;
            }

            public Builder actual(Boolean actual) {
                this.actual = actual;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public StatusDate build() {
                StatusDate statusDate = new StatusDate(this);
                if (this.validating) {
                    this.validate(statusDate);
                }
                return statusDate;
            }

            protected void validate(StatusDate statusDate) {
                super.validate(statusDate);
                ValidationSupport.requireNonNull(statusDate.activity, "activity");
                ValidationSupport.requireNonNull(statusDate.period, "period");
                ValidationSupport.requireValueOrChildren(statusDate);
            }

            protected Builder from(StatusDate statusDate) {
                super.from(statusDate);
                this.activity = statusDate.activity;
                this.actual = statusDate.actual;
                this.period = statusDate.period;
                return this;
            }
        }
    }

    public static class Classification
    extends BackboneElement {
        @Binding(bindingName="CitationClassificationType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/citation-classification-type")
        private final CodeableConcept type;
        @Binding(bindingName="CitationArtifactClassifier", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        private final List<CodeableConcept> classifier;

        private Classification(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.classifier = Collections.unmodifiableList(builder.classifier);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<CodeableConcept> getClassifier() {
            return this.classifier;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.classifier.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.classifier, "classifier", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Classification other = (Classification)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.classifier, other.classifier);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.classifier);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<CodeableConcept> classifier = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder classifier(CodeableConcept ... classifier) {
                for (CodeableConcept value : classifier) {
                    this.classifier.add(value);
                }
                return this;
            }

            public Builder classifier(Collection<CodeableConcept> classifier) {
                this.classifier = new ArrayList<CodeableConcept>(classifier);
                return this;
            }

            @Override
            public Classification build() {
                Classification classification = new Classification(this);
                if (this.validating) {
                    this.validate(classification);
                }
                return classification;
            }

            protected void validate(Classification classification) {
                super.validate(classification);
                ValidationSupport.checkList(classification.classifier, "classifier", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(classification);
            }

            protected Builder from(Classification classification) {
                super.from(classification);
                this.type = classification.type;
                this.classifier.addAll(classification.classifier);
                return this;
            }
        }
    }

    public static class Summary
    extends BackboneElement {
        @Binding(bindingName="CitationSummaryStyle", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/citation-summary-style")
        private final CodeableConcept style;
        @org.linuxforhealth.fhir.model.annotation.Summary
        @Required
        private final Markdown text;

        private Summary(Builder builder) {
            super(builder);
            this.style = builder.style;
            this.text = builder.text;
        }

        public CodeableConcept getStyle() {
            return this.style;
        }

        public Markdown getText() {
            return this.text;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.style != null || this.text != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.style, "style", visitor);
                    this.accept(this.text, "text", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Summary other = (Summary)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.style, other.style) && Objects.equals(this.text, other.text);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.style, this.text);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept style;
            private Markdown text;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder style(CodeableConcept style) {
                this.style = style;
                return this;
            }

            public Builder text(Markdown text) {
                this.text = text;
                return this;
            }

            @Override
            public Summary build() {
                Summary summary = new Summary(this);
                if (this.validating) {
                    this.validate(summary);
                }
                return summary;
            }

            protected void validate(Summary summary) {
                super.validate(summary);
                ValidationSupport.requireNonNull(summary.text, "text");
                ValidationSupport.requireValueOrChildren(summary);
            }

            protected Builder from(Summary summary) {
                super.from(summary);
                this.style = summary.style;
                this.text = summary.text;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<Summary> summary = new ArrayList<Summary>();
        private List<Classification> classification = new ArrayList<Classification>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<CodeableConcept> currentState = new ArrayList<CodeableConcept>();
        private List<StatusDate> statusDate = new ArrayList<StatusDate>();
        private List<RelatesTo> relatesTo = new ArrayList<RelatesTo>();
        private CitedArtifact citedArtifact;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(LocalDate approvalDate) {
            this.approvalDate = approvalDate == null ? null : Date.of(approvalDate);
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(LocalDate lastReviewDate) {
            this.lastReviewDate = lastReviewDate == null ? null : Date.of(lastReviewDate);
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder summary(Summary ... summary) {
            for (Summary value : summary) {
                this.summary.add(value);
            }
            return this;
        }

        public Builder summary(Collection<Summary> summary) {
            this.summary = new ArrayList<Summary>(summary);
            return this;
        }

        public Builder classification(Classification ... classification) {
            for (Classification value : classification) {
                this.classification.add(value);
            }
            return this;
        }

        public Builder classification(Collection<Classification> classification) {
            this.classification = new ArrayList<Classification>(classification);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder currentState(CodeableConcept ... currentState) {
            for (CodeableConcept value : currentState) {
                this.currentState.add(value);
            }
            return this;
        }

        public Builder currentState(Collection<CodeableConcept> currentState) {
            this.currentState = new ArrayList<CodeableConcept>(currentState);
            return this;
        }

        public Builder statusDate(StatusDate ... statusDate) {
            for (StatusDate value : statusDate) {
                this.statusDate.add(value);
            }
            return this;
        }

        public Builder statusDate(Collection<StatusDate> statusDate) {
            this.statusDate = new ArrayList<StatusDate>(statusDate);
            return this;
        }

        public Builder relatesTo(RelatesTo ... relatesTo) {
            for (RelatesTo value : relatesTo) {
                this.relatesTo.add(value);
            }
            return this;
        }

        public Builder relatesTo(Collection<RelatesTo> relatesTo) {
            this.relatesTo = new ArrayList<RelatesTo>(relatesTo);
            return this;
        }

        public Builder citedArtifact(CitedArtifact citedArtifact) {
            this.citedArtifact = citedArtifact;
            return this;
        }

        @Override
        public Citation build() {
            Citation citation = new Citation(this);
            if (this.validating) {
                this.validate(citation);
            }
            return citation;
        }

        protected void validate(Citation citation) {
            super.validate(citation);
            ValidationSupport.checkList(citation.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(citation.status, "status");
            ValidationSupport.checkList(citation.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(citation.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(citation.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(citation.author, "author", ContactDetail.class);
            ValidationSupport.checkList(citation.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(citation.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(citation.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(citation.summary, "summary", Summary.class);
            ValidationSupport.checkList(citation.classification, "classification", Classification.class);
            ValidationSupport.checkList(citation.note, "note", Annotation.class);
            ValidationSupport.checkList(citation.currentState, "currentState", CodeableConcept.class);
            ValidationSupport.checkList(citation.statusDate, "statusDate", StatusDate.class);
            ValidationSupport.checkList(citation.relatesTo, "relatesTo", RelatesTo.class);
        }

        protected Builder from(Citation citation) {
            super.from(citation);
            this.url = citation.url;
            this.identifier.addAll(citation.identifier);
            this.version = citation.version;
            this.name = citation.name;
            this.title = citation.title;
            this.status = citation.status;
            this.experimental = citation.experimental;
            this.date = citation.date;
            this.publisher = citation.publisher;
            this.contact.addAll(citation.contact);
            this.description = citation.description;
            this.useContext.addAll(citation.useContext);
            this.jurisdiction.addAll(citation.jurisdiction);
            this.purpose = citation.purpose;
            this.copyright = citation.copyright;
            this.approvalDate = citation.approvalDate;
            this.lastReviewDate = citation.lastReviewDate;
            this.effectivePeriod = citation.effectivePeriod;
            this.author.addAll(citation.author);
            this.editor.addAll(citation.editor);
            this.reviewer.addAll(citation.reviewer);
            this.endorser.addAll(citation.endorser);
            this.summary.addAll(citation.summary);
            this.classification.addAll(citation.classification);
            this.note.addAll(citation.note);
            this.currentState.addAll(citation.currentState);
            this.statusDate.addAll(citation.statusDate);
            this.relatesTo.addAll(citation.relatesTo);
            this.citedArtifact = citation.citedArtifact;
            return this;
        }
    }
}

