/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.ClinicalUseDefinitionType;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cud-1", level="Rule", location="(base)", description="Indication, Contraindication, Interaction, UndesirableEffect and Warning cannot be used in the same instance", expression="(ClinicalUseDefinition.indication.count() + ClinicalUseDefinition.contraindication.count() + ClinicalUseDefinition.interaction.count() + ClinicalUseDefinition.undesirableEffect.count() + ClinicalUseDefinition.warning.count())  < 2", source="http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition"), @Constraint(id="clinicalUseDefinition-2", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/clinical-use-definition-category", expression="category.exists() implies (category.all(memberOf('http://hl7.org/fhir/ValueSet/clinical-use-definition-category', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition", generated=true), @Constraint(id="clinicalUseDefinition-3", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="status.exists() implies (status.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition", generated=true), @Constraint(id="clinicalUseDefinition-4", level="Warning", location="contraindication.otherTherapy.relationshipType", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/therapy-relationship-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/therapy-relationship-type', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition", generated=true), @Constraint(id="clinicalUseDefinition-5", level="Warning", location="indication.intendedEffect", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/product-intended-use", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/product-intended-use', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition", generated=true)})
public class ClinicalUseDefinition
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ClinicalUseDefinitionType", strength=BindingStrength.Value.REQUIRED, description="Overall defining type of this clinical use definition.", valueSet="http://hl7.org/fhir/ValueSet/clinical-use-definition-type|4.3.0")
    @Required
    private final ClinicalUseDefinitionType type;
    @Summary
    @Binding(bindingName="ClinicalUseDefinitionCategory", strength=BindingStrength.Value.PREFERRED, description="A categorisation for a clinical use information item.", valueSet="http://hl7.org/fhir/ValueSet/clinical-use-definition-category")
    private final List<CodeableConcept> category;
    @Summary
    @ReferenceTarget(value={"MedicinalProductDefinition", "Medication", "ActivityDefinition", "PlanDefinition", "Device", "DeviceDefinition", "Substance"})
    private final List<Reference> subject;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    private final CodeableConcept status;
    @Summary
    private final Contraindication contraindication;
    @Summary
    private final Indication indication;
    @Summary
    private final Interaction interaction;
    @Summary
    @ReferenceTarget(value={"Group"})
    private final List<Reference> population;
    @Summary
    private final UndesirableEffect undesirableEffect;
    @Summary
    private final Warning warning;

    private ClinicalUseDefinition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.type = builder.type;
        this.category = Collections.unmodifiableList(builder.category);
        this.subject = Collections.unmodifiableList(builder.subject);
        this.status = builder.status;
        this.contraindication = builder.contraindication;
        this.indication = builder.indication;
        this.interaction = builder.interaction;
        this.population = Collections.unmodifiableList(builder.population);
        this.undesirableEffect = builder.undesirableEffect;
        this.warning = builder.warning;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ClinicalUseDefinitionType getType() {
        return this.type;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public Contraindication getContraindication() {
        return this.contraindication;
    }

    public Indication getIndication() {
        return this.indication;
    }

    public Interaction getInteraction() {
        return this.interaction;
    }

    public List<Reference> getPopulation() {
        return this.population;
    }

    public UndesirableEffect getUndesirableEffect() {
        return this.undesirableEffect;
    }

    public Warning getWarning() {
        return this.warning;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || !this.category.isEmpty() || !this.subject.isEmpty() || this.status != null || this.contraindication != null || this.indication != null || this.interaction != null || !this.population.isEmpty() || this.undesirableEffect != null || this.warning != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.contraindication, "contraindication", visitor);
                this.accept(this.indication, "indication", visitor);
                this.accept(this.interaction, "interaction", visitor);
                this.accept(this.population, "population", visitor, Reference.class);
                this.accept(this.undesirableEffect, "undesirableEffect", visitor);
                this.accept(this.warning, "warning", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClinicalUseDefinition other = (ClinicalUseDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.category, other.category) && Objects.equals(this.subject, other.subject) && Objects.equals(this.status, other.status) && Objects.equals(this.contraindication, other.contraindication) && Objects.equals(this.indication, other.indication) && Objects.equals(this.interaction, other.interaction) && Objects.equals(this.population, other.population) && Objects.equals(this.undesirableEffect, other.undesirableEffect) && Objects.equals(this.warning, other.warning);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.type, this.category, this.subject, this.status, this.contraindication, this.indication, this.interaction, this.population, this.undesirableEffect, this.warning);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Warning
    extends BackboneElement {
        @Summary
        private final Markdown description;
        @Summary
        @Binding(bindingName="WarningType", strength=BindingStrength.Value.EXAMPLE, description="Classification of warning type.", valueSet="http://hl7.org/fhir/ValueSet/warning-type")
        private final CodeableConcept code;

        private Warning(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.code = builder.code;
        }

        public Markdown getDescription() {
            return this.description;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.code != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.code, "code", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Warning other = (Warning)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.code, other.code);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.code);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Markdown description;
            private CodeableConcept code;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            @Override
            public Warning build() {
                Warning warning = new Warning(this);
                if (this.validating) {
                    this.validate(warning);
                }
                return warning;
            }

            protected void validate(Warning warning) {
                super.validate(warning);
                ValidationSupport.requireValueOrChildren(warning);
            }

            protected Builder from(Warning warning) {
                super.from(warning);
                this.description = warning.description;
                this.code = warning.code;
                return this;
            }
        }
    }

    public static class UndesirableEffect
    extends BackboneElement {
        @Summary
        @Binding(bindingName="UndesirableEffectSymptom", strength=BindingStrength.Value.EXAMPLE, description="An undesirable effect of clinical use.", valueSet="http://hl7.org/fhir/ValueSet/undesirable-effect-symptom")
        private final CodeableReference symptomConditionEffect;
        @Summary
        @Binding(bindingName="UndesirableEffectClassification", strength=BindingStrength.Value.EXAMPLE, description="A categorisation for an undesirable effect.", valueSet="http://hl7.org/fhir/ValueSet/undesirable-effect-classification")
        private final CodeableConcept classification;
        @Summary
        @Binding(bindingName="UndesirablEffectFrequency", strength=BindingStrength.Value.EXAMPLE, description="A categorisation for a frequency of occurence of an undesirable effect.", valueSet="http://hl7.org/fhir/ValueSet/undesirable-effect-frequency")
        private final CodeableConcept frequencyOfOccurrence;

        private UndesirableEffect(Builder builder) {
            super(builder);
            this.symptomConditionEffect = builder.symptomConditionEffect;
            this.classification = builder.classification;
            this.frequencyOfOccurrence = builder.frequencyOfOccurrence;
        }

        public CodeableReference getSymptomConditionEffect() {
            return this.symptomConditionEffect;
        }

        public CodeableConcept getClassification() {
            return this.classification;
        }

        public CodeableConcept getFrequencyOfOccurrence() {
            return this.frequencyOfOccurrence;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.symptomConditionEffect != null || this.classification != null || this.frequencyOfOccurrence != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.symptomConditionEffect, "symptomConditionEffect", visitor);
                    this.accept(this.classification, "classification", visitor);
                    this.accept(this.frequencyOfOccurrence, "frequencyOfOccurrence", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UndesirableEffect other = (UndesirableEffect)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.symptomConditionEffect, other.symptomConditionEffect) && Objects.equals(this.classification, other.classification) && Objects.equals(this.frequencyOfOccurrence, other.frequencyOfOccurrence);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.symptomConditionEffect, this.classification, this.frequencyOfOccurrence);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference symptomConditionEffect;
            private CodeableConcept classification;
            private CodeableConcept frequencyOfOccurrence;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder symptomConditionEffect(CodeableReference symptomConditionEffect) {
                this.symptomConditionEffect = symptomConditionEffect;
                return this;
            }

            public Builder classification(CodeableConcept classification) {
                this.classification = classification;
                return this;
            }

            public Builder frequencyOfOccurrence(CodeableConcept frequencyOfOccurrence) {
                this.frequencyOfOccurrence = frequencyOfOccurrence;
                return this;
            }

            @Override
            public UndesirableEffect build() {
                UndesirableEffect undesirableEffect = new UndesirableEffect(this);
                if (this.validating) {
                    this.validate(undesirableEffect);
                }
                return undesirableEffect;
            }

            protected void validate(UndesirableEffect undesirableEffect) {
                super.validate(undesirableEffect);
                ValidationSupport.requireValueOrChildren(undesirableEffect);
            }

            protected Builder from(UndesirableEffect undesirableEffect) {
                super.from(undesirableEffect);
                this.symptomConditionEffect = undesirableEffect.symptomConditionEffect;
                this.classification = undesirableEffect.classification;
                this.frequencyOfOccurrence = undesirableEffect.frequencyOfOccurrence;
                return this;
            }
        }
    }

    public static class Interaction
    extends BackboneElement {
        @Summary
        private final List<Interactant> interactant;
        @Summary
        @Binding(bindingName="InteractionType", strength=BindingStrength.Value.EXAMPLE, description="A categorisation for an interaction between two substances.", valueSet="http://hl7.org/fhir/ValueSet/interaction-type")
        private final CodeableConcept type;
        @Summary
        @Binding(bindingName="InteractionEffect", strength=BindingStrength.Value.EXAMPLE, description="A interaction effect of clinical use of a medication or other substance.", valueSet="http://hl7.org/fhir/ValueSet/interaction-effect")
        private final CodeableReference effect;
        @Summary
        @Binding(bindingName="UndesirableEffectSymptom", strength=BindingStrength.Value.EXAMPLE, description="A categorisation for incidence of occurence of an interaction.", valueSet="http://hl7.org/fhir/ValueSet/interaction-incidence")
        private final CodeableConcept incidence;
        @Summary
        @Binding(bindingName="InteractionManagement", strength=BindingStrength.Value.EXAMPLE, description="A type of management for an interaction of a medication or other substance.", valueSet="http://hl7.org/fhir/ValueSet/interaction-management")
        private final List<CodeableConcept> management;

        private Interaction(Builder builder) {
            super(builder);
            this.interactant = Collections.unmodifiableList(builder.interactant);
            this.type = builder.type;
            this.effect = builder.effect;
            this.incidence = builder.incidence;
            this.management = Collections.unmodifiableList(builder.management);
        }

        public List<Interactant> getInteractant() {
            return this.interactant;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableReference getEffect() {
            return this.effect;
        }

        public CodeableConcept getIncidence() {
            return this.incidence;
        }

        public List<CodeableConcept> getManagement() {
            return this.management;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.interactant.isEmpty() || this.type != null || this.effect != null || this.incidence != null || !this.management.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.interactant, "interactant", visitor, Interactant.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.effect, "effect", visitor);
                    this.accept(this.incidence, "incidence", visitor);
                    this.accept(this.management, "management", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interaction other = (Interaction)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.interactant, other.interactant) && Objects.equals(this.type, other.type) && Objects.equals(this.effect, other.effect) && Objects.equals(this.incidence, other.incidence) && Objects.equals(this.management, other.management);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.interactant, this.type, this.effect, this.incidence, this.management);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Interactant
        extends BackboneElement {
            @Summary
            @ReferenceTarget(value={"MedicinalProductDefinition", "Medication", "Substance", "ObservationDefinition"})
            @Choice(value={Reference.class, CodeableConcept.class})
            @Binding(bindingName="Interactant", strength=BindingStrength.Value.EXAMPLE, description="An interactant - a substance that may have an clinically significant effect on another.", valueSet="http://hl7.org/fhir/ValueSet/interactant")
            @Required
            private final Element item;

            private Interactant(Builder builder) {
                super(builder);
                this.item = builder.item;
            }

            public Element getItem() {
                return this.item;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.item != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.item, "item", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Interactant other = (Interactant)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.item, other.item);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.item);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element item;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder item(Element item) {
                    this.item = item;
                    return this;
                }

                @Override
                public Interactant build() {
                    Interactant interactant = new Interactant(this);
                    if (this.validating) {
                        this.validate(interactant);
                    }
                    return interactant;
                }

                protected void validate(Interactant interactant) {
                    super.validate(interactant);
                    ValidationSupport.requireChoiceElement(interactant.item, "item", Reference.class, CodeableConcept.class);
                    ValidationSupport.checkReferenceType(interactant.item, "item", "MedicinalProductDefinition", "Medication", "Substance", "ObservationDefinition");
                    ValidationSupport.requireValueOrChildren(interactant);
                }

                protected Builder from(Interactant interactant) {
                    super.from(interactant);
                    this.item = interactant.item;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Interactant> interactant = new ArrayList<Interactant>();
            private CodeableConcept type;
            private CodeableReference effect;
            private CodeableConcept incidence;
            private List<CodeableConcept> management = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder interactant(Interactant ... interactant) {
                for (Interactant value : interactant) {
                    this.interactant.add(value);
                }
                return this;
            }

            public Builder interactant(Collection<Interactant> interactant) {
                this.interactant = new ArrayList<Interactant>(interactant);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder effect(CodeableReference effect) {
                this.effect = effect;
                return this;
            }

            public Builder incidence(CodeableConcept incidence) {
                this.incidence = incidence;
                return this;
            }

            public Builder management(CodeableConcept ... management) {
                for (CodeableConcept value : management) {
                    this.management.add(value);
                }
                return this;
            }

            public Builder management(Collection<CodeableConcept> management) {
                this.management = new ArrayList<CodeableConcept>(management);
                return this;
            }

            @Override
            public Interaction build() {
                Interaction interaction = new Interaction(this);
                if (this.validating) {
                    this.validate(interaction);
                }
                return interaction;
            }

            protected void validate(Interaction interaction) {
                super.validate(interaction);
                ValidationSupport.checkList(interaction.interactant, "interactant", Interactant.class);
                ValidationSupport.checkList(interaction.management, "management", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(interaction);
            }

            protected Builder from(Interaction interaction) {
                super.from(interaction);
                this.interactant.addAll(interaction.interactant);
                this.type = interaction.type;
                this.effect = interaction.effect;
                this.incidence = interaction.incidence;
                this.management.addAll(interaction.management);
                return this;
            }
        }
    }

    public static class Indication
    extends BackboneElement {
        @Summary
        @Binding(bindingName="DiseaseSymptomProcedure", strength=BindingStrength.Value.EXAMPLE, description="A symptom, disease or procedure.", valueSet="http://hl7.org/fhir/ValueSet/disease-symptom-procedure")
        private final CodeableReference diseaseSymptomProcedure;
        @Summary
        @Binding(bindingName="DiseaseStatus", strength=BindingStrength.Value.EXAMPLE, description="The status of a disease or symptom.", valueSet="http://hl7.org/fhir/ValueSet/disease-status")
        private final CodeableReference diseaseStatus;
        @Summary
        @Binding(bindingName="DiseaseSymptomProcedure", strength=BindingStrength.Value.EXAMPLE, description="A symptom, disease or procedure.", valueSet="http://hl7.org/fhir/ValueSet/disease-symptom-procedure")
        private final List<CodeableReference> comorbidity;
        @Summary
        @Binding(bindingName="ProductIntendedUse", strength=BindingStrength.Value.PREFERRED, description="The overall intended use of a product.", valueSet="http://hl7.org/fhir/ValueSet/product-intended-use")
        private final CodeableReference intendedEffect;
        @Summary
        @Choice(value={Range.class, org.linuxforhealth.fhir.model.type.String.class})
        private final Element duration;
        @Summary
        @ReferenceTarget(value={"ClinicalUseDefinition"})
        private final List<Reference> undesirableEffect;
        @Summary
        private final List<Contraindication.OtherTherapy> otherTherapy;

        private Indication(Builder builder) {
            super(builder);
            this.diseaseSymptomProcedure = builder.diseaseSymptomProcedure;
            this.diseaseStatus = builder.diseaseStatus;
            this.comorbidity = Collections.unmodifiableList(builder.comorbidity);
            this.intendedEffect = builder.intendedEffect;
            this.duration = builder.duration;
            this.undesirableEffect = Collections.unmodifiableList(builder.undesirableEffect);
            this.otherTherapy = Collections.unmodifiableList(builder.otherTherapy);
        }

        public CodeableReference getDiseaseSymptomProcedure() {
            return this.diseaseSymptomProcedure;
        }

        public CodeableReference getDiseaseStatus() {
            return this.diseaseStatus;
        }

        public List<CodeableReference> getComorbidity() {
            return this.comorbidity;
        }

        public CodeableReference getIntendedEffect() {
            return this.intendedEffect;
        }

        public Element getDuration() {
            return this.duration;
        }

        public List<Reference> getUndesirableEffect() {
            return this.undesirableEffect;
        }

        public List<Contraindication.OtherTherapy> getOtherTherapy() {
            return this.otherTherapy;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.diseaseSymptomProcedure != null || this.diseaseStatus != null || !this.comorbidity.isEmpty() || this.intendedEffect != null || this.duration != null || !this.undesirableEffect.isEmpty() || !this.otherTherapy.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.diseaseSymptomProcedure, "diseaseSymptomProcedure", visitor);
                    this.accept(this.diseaseStatus, "diseaseStatus", visitor);
                    this.accept(this.comorbidity, "comorbidity", visitor, CodeableReference.class);
                    this.accept(this.intendedEffect, "intendedEffect", visitor);
                    this.accept(this.duration, "duration", visitor);
                    this.accept(this.undesirableEffect, "undesirableEffect", visitor, Reference.class);
                    this.accept(this.otherTherapy, "otherTherapy", visitor, Contraindication.OtherTherapy.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Indication other = (Indication)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.diseaseSymptomProcedure, other.diseaseSymptomProcedure) && Objects.equals(this.diseaseStatus, other.diseaseStatus) && Objects.equals(this.comorbidity, other.comorbidity) && Objects.equals(this.intendedEffect, other.intendedEffect) && Objects.equals(this.duration, other.duration) && Objects.equals(this.undesirableEffect, other.undesirableEffect) && Objects.equals(this.otherTherapy, other.otherTherapy);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.diseaseSymptomProcedure, this.diseaseStatus, this.comorbidity, this.intendedEffect, this.duration, this.undesirableEffect, this.otherTherapy);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference diseaseSymptomProcedure;
            private CodeableReference diseaseStatus;
            private List<CodeableReference> comorbidity = new ArrayList<CodeableReference>();
            private CodeableReference intendedEffect;
            private Element duration;
            private List<Reference> undesirableEffect = new ArrayList<Reference>();
            private List<Contraindication.OtherTherapy> otherTherapy = new ArrayList<Contraindication.OtherTherapy>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder diseaseSymptomProcedure(CodeableReference diseaseSymptomProcedure) {
                this.diseaseSymptomProcedure = diseaseSymptomProcedure;
                return this;
            }

            public Builder diseaseStatus(CodeableReference diseaseStatus) {
                this.diseaseStatus = diseaseStatus;
                return this;
            }

            public Builder comorbidity(CodeableReference ... comorbidity) {
                for (CodeableReference value : comorbidity) {
                    this.comorbidity.add(value);
                }
                return this;
            }

            public Builder comorbidity(Collection<CodeableReference> comorbidity) {
                this.comorbidity = new ArrayList<CodeableReference>(comorbidity);
                return this;
            }

            public Builder intendedEffect(CodeableReference intendedEffect) {
                this.intendedEffect = intendedEffect;
                return this;
            }

            public Builder duration(String duration) {
                this.duration = duration == null ? null : org.linuxforhealth.fhir.model.type.String.of(duration);
                return this;
            }

            public Builder duration(Element duration) {
                this.duration = duration;
                return this;
            }

            public Builder undesirableEffect(Reference ... undesirableEffect) {
                for (Reference value : undesirableEffect) {
                    this.undesirableEffect.add(value);
                }
                return this;
            }

            public Builder undesirableEffect(Collection<Reference> undesirableEffect) {
                this.undesirableEffect = new ArrayList<Reference>(undesirableEffect);
                return this;
            }

            public Builder otherTherapy(Contraindication.OtherTherapy ... otherTherapy) {
                for (Contraindication.OtherTherapy value : otherTherapy) {
                    this.otherTherapy.add(value);
                }
                return this;
            }

            public Builder otherTherapy(Collection<Contraindication.OtherTherapy> otherTherapy) {
                this.otherTherapy = new ArrayList<Contraindication.OtherTherapy>(otherTherapy);
                return this;
            }

            @Override
            public Indication build() {
                Indication indication = new Indication(this);
                if (this.validating) {
                    this.validate(indication);
                }
                return indication;
            }

            protected void validate(Indication indication) {
                super.validate(indication);
                ValidationSupport.checkList(indication.comorbidity, "comorbidity", CodeableReference.class);
                ValidationSupport.choiceElement(indication.duration, "duration", Range.class, org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.checkList(indication.undesirableEffect, "undesirableEffect", Reference.class);
                ValidationSupport.checkList(indication.otherTherapy, "otherTherapy", Contraindication.OtherTherapy.class);
                ValidationSupport.checkReferenceType(indication.undesirableEffect, "undesirableEffect", "ClinicalUseDefinition");
                ValidationSupport.requireValueOrChildren(indication);
            }

            protected Builder from(Indication indication) {
                super.from(indication);
                this.diseaseSymptomProcedure = indication.diseaseSymptomProcedure;
                this.diseaseStatus = indication.diseaseStatus;
                this.comorbidity.addAll(indication.comorbidity);
                this.intendedEffect = indication.intendedEffect;
                this.duration = indication.duration;
                this.undesirableEffect.addAll(indication.undesirableEffect);
                this.otherTherapy.addAll(indication.otherTherapy);
                return this;
            }
        }
    }

    public static class Contraindication
    extends BackboneElement {
        @Summary
        @Binding(bindingName="DiseaseSymptomProcedure", strength=BindingStrength.Value.EXAMPLE, description="A symptom, disease or procedure.", valueSet="http://hl7.org/fhir/ValueSet/disease-symptom-procedure")
        private final CodeableReference diseaseSymptomProcedure;
        @Summary
        @Binding(bindingName="DiseaseStatus", strength=BindingStrength.Value.EXAMPLE, description="The status of a disease or symptom.", valueSet="http://hl7.org/fhir/ValueSet/disease-status")
        private final CodeableReference diseaseStatus;
        @Summary
        @Binding(bindingName="DiseaseSymptomProcedure", strength=BindingStrength.Value.EXAMPLE, description="A symptom, disease or procedure.", valueSet="http://hl7.org/fhir/ValueSet/disease-symptom-procedure")
        private final List<CodeableReference> comorbidity;
        @Summary
        @ReferenceTarget(value={"ClinicalUseDefinition"})
        private final List<Reference> indication;
        @Summary
        private final List<OtherTherapy> otherTherapy;

        private Contraindication(Builder builder) {
            super(builder);
            this.diseaseSymptomProcedure = builder.diseaseSymptomProcedure;
            this.diseaseStatus = builder.diseaseStatus;
            this.comorbidity = Collections.unmodifiableList(builder.comorbidity);
            this.indication = Collections.unmodifiableList(builder.indication);
            this.otherTherapy = Collections.unmodifiableList(builder.otherTherapy);
        }

        public CodeableReference getDiseaseSymptomProcedure() {
            return this.diseaseSymptomProcedure;
        }

        public CodeableReference getDiseaseStatus() {
            return this.diseaseStatus;
        }

        public List<CodeableReference> getComorbidity() {
            return this.comorbidity;
        }

        public List<Reference> getIndication() {
            return this.indication;
        }

        public List<OtherTherapy> getOtherTherapy() {
            return this.otherTherapy;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.diseaseSymptomProcedure != null || this.diseaseStatus != null || !this.comorbidity.isEmpty() || !this.indication.isEmpty() || !this.otherTherapy.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.diseaseSymptomProcedure, "diseaseSymptomProcedure", visitor);
                    this.accept(this.diseaseStatus, "diseaseStatus", visitor);
                    this.accept(this.comorbidity, "comorbidity", visitor, CodeableReference.class);
                    this.accept(this.indication, "indication", visitor, Reference.class);
                    this.accept(this.otherTherapy, "otherTherapy", visitor, OtherTherapy.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Contraindication other = (Contraindication)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.diseaseSymptomProcedure, other.diseaseSymptomProcedure) && Objects.equals(this.diseaseStatus, other.diseaseStatus) && Objects.equals(this.comorbidity, other.comorbidity) && Objects.equals(this.indication, other.indication) && Objects.equals(this.otherTherapy, other.otherTherapy);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.diseaseSymptomProcedure, this.diseaseStatus, this.comorbidity, this.indication, this.otherTherapy);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class OtherTherapy
        extends BackboneElement {
            @Summary
            @Binding(bindingName="TherapyRelationshipType", strength=BindingStrength.Value.PREFERRED, description="Classification of relationship between a therapy and a contraindication or an indication.", valueSet="http://hl7.org/fhir/ValueSet/therapy-relationship-type")
            @Required
            private final CodeableConcept relationshipType;
            @Summary
            @Binding(bindingName="Therapy", strength=BindingStrength.Value.EXAMPLE, description="A therapy.", valueSet="http://hl7.org/fhir/ValueSet/therapy")
            @Required
            private final CodeableReference therapy;

            private OtherTherapy(Builder builder) {
                super(builder);
                this.relationshipType = builder.relationshipType;
                this.therapy = builder.therapy;
            }

            public CodeableConcept getRelationshipType() {
                return this.relationshipType;
            }

            public CodeableReference getTherapy() {
                return this.therapy;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.relationshipType != null || this.therapy != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.relationshipType, "relationshipType", visitor);
                        this.accept(this.therapy, "therapy", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                OtherTherapy other = (OtherTherapy)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.relationshipType, other.relationshipType) && Objects.equals(this.therapy, other.therapy);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.relationshipType, this.therapy);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept relationshipType;
                private CodeableReference therapy;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder relationshipType(CodeableConcept relationshipType) {
                    this.relationshipType = relationshipType;
                    return this;
                }

                public Builder therapy(CodeableReference therapy) {
                    this.therapy = therapy;
                    return this;
                }

                @Override
                public OtherTherapy build() {
                    OtherTherapy otherTherapy = new OtherTherapy(this);
                    if (this.validating) {
                        this.validate(otherTherapy);
                    }
                    return otherTherapy;
                }

                protected void validate(OtherTherapy otherTherapy) {
                    super.validate(otherTherapy);
                    ValidationSupport.requireNonNull(otherTherapy.relationshipType, "relationshipType");
                    ValidationSupport.requireNonNull(otherTherapy.therapy, "therapy");
                    ValidationSupport.requireValueOrChildren(otherTherapy);
                }

                protected Builder from(OtherTherapy otherTherapy) {
                    super.from(otherTherapy);
                    this.relationshipType = otherTherapy.relationshipType;
                    this.therapy = otherTherapy.therapy;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference diseaseSymptomProcedure;
            private CodeableReference diseaseStatus;
            private List<CodeableReference> comorbidity = new ArrayList<CodeableReference>();
            private List<Reference> indication = new ArrayList<Reference>();
            private List<OtherTherapy> otherTherapy = new ArrayList<OtherTherapy>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder diseaseSymptomProcedure(CodeableReference diseaseSymptomProcedure) {
                this.diseaseSymptomProcedure = diseaseSymptomProcedure;
                return this;
            }

            public Builder diseaseStatus(CodeableReference diseaseStatus) {
                this.diseaseStatus = diseaseStatus;
                return this;
            }

            public Builder comorbidity(CodeableReference ... comorbidity) {
                for (CodeableReference value : comorbidity) {
                    this.comorbidity.add(value);
                }
                return this;
            }

            public Builder comorbidity(Collection<CodeableReference> comorbidity) {
                this.comorbidity = new ArrayList<CodeableReference>(comorbidity);
                return this;
            }

            public Builder indication(Reference ... indication) {
                for (Reference value : indication) {
                    this.indication.add(value);
                }
                return this;
            }

            public Builder indication(Collection<Reference> indication) {
                this.indication = new ArrayList<Reference>(indication);
                return this;
            }

            public Builder otherTherapy(OtherTherapy ... otherTherapy) {
                for (OtherTherapy value : otherTherapy) {
                    this.otherTherapy.add(value);
                }
                return this;
            }

            public Builder otherTherapy(Collection<OtherTherapy> otherTherapy) {
                this.otherTherapy = new ArrayList<OtherTherapy>(otherTherapy);
                return this;
            }

            @Override
            public Contraindication build() {
                Contraindication contraindication = new Contraindication(this);
                if (this.validating) {
                    this.validate(contraindication);
                }
                return contraindication;
            }

            protected void validate(Contraindication contraindication) {
                super.validate(contraindication);
                ValidationSupport.checkList(contraindication.comorbidity, "comorbidity", CodeableReference.class);
                ValidationSupport.checkList(contraindication.indication, "indication", Reference.class);
                ValidationSupport.checkList(contraindication.otherTherapy, "otherTherapy", OtherTherapy.class);
                ValidationSupport.checkReferenceType(contraindication.indication, "indication", "ClinicalUseDefinition");
                ValidationSupport.requireValueOrChildren(contraindication);
            }

            protected Builder from(Contraindication contraindication) {
                super.from(contraindication);
                this.diseaseSymptomProcedure = contraindication.diseaseSymptomProcedure;
                this.diseaseStatus = contraindication.diseaseStatus;
                this.comorbidity.addAll(contraindication.comorbidity);
                this.indication.addAll(contraindication.indication);
                this.otherTherapy.addAll(contraindication.otherTherapy);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ClinicalUseDefinitionType type;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private List<Reference> subject = new ArrayList<Reference>();
        private CodeableConcept status;
        private Contraindication contraindication;
        private Indication indication;
        private Interaction interaction;
        private List<Reference> population = new ArrayList<Reference>();
        private UndesirableEffect undesirableEffect;
        private Warning warning;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder type(ClinicalUseDefinitionType type) {
            this.type = type;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder contraindication(Contraindication contraindication) {
            this.contraindication = contraindication;
            return this;
        }

        public Builder indication(Indication indication) {
            this.indication = indication;
            return this;
        }

        public Builder interaction(Interaction interaction) {
            this.interaction = interaction;
            return this;
        }

        public Builder population(Reference ... population) {
            for (Reference value : population) {
                this.population.add(value);
            }
            return this;
        }

        public Builder population(Collection<Reference> population) {
            this.population = new ArrayList<Reference>(population);
            return this;
        }

        public Builder undesirableEffect(UndesirableEffect undesirableEffect) {
            this.undesirableEffect = undesirableEffect;
            return this;
        }

        public Builder warning(Warning warning) {
            this.warning = warning;
            return this;
        }

        @Override
        public ClinicalUseDefinition build() {
            ClinicalUseDefinition clinicalUseDefinition = new ClinicalUseDefinition(this);
            if (this.validating) {
                this.validate(clinicalUseDefinition);
            }
            return clinicalUseDefinition;
        }

        protected void validate(ClinicalUseDefinition clinicalUseDefinition) {
            super.validate(clinicalUseDefinition);
            ValidationSupport.checkList(clinicalUseDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(clinicalUseDefinition.type, "type");
            ValidationSupport.checkList(clinicalUseDefinition.category, "category", CodeableConcept.class);
            ValidationSupport.checkList(clinicalUseDefinition.subject, "subject", Reference.class);
            ValidationSupport.checkList(clinicalUseDefinition.population, "population", Reference.class);
            ValidationSupport.checkReferenceType(clinicalUseDefinition.subject, "subject", "MedicinalProductDefinition", "Medication", "ActivityDefinition", "PlanDefinition", "Device", "DeviceDefinition", "Substance");
            ValidationSupport.checkReferenceType(clinicalUseDefinition.population, "population", "Group");
        }

        protected Builder from(ClinicalUseDefinition clinicalUseDefinition) {
            super.from(clinicalUseDefinition);
            this.identifier.addAll(clinicalUseDefinition.identifier);
            this.type = clinicalUseDefinition.type;
            this.category.addAll(clinicalUseDefinition.category);
            this.subject.addAll(clinicalUseDefinition.subject);
            this.status = clinicalUseDefinition.status;
            this.contraindication = clinicalUseDefinition.contraindication;
            this.indication = clinicalUseDefinition.indication;
            this.interaction = clinicalUseDefinition.interaction;
            this.population.addAll(clinicalUseDefinition.population);
            this.undesirableEffect = clinicalUseDefinition.undesirableEffect;
            this.warning = clinicalUseDefinition.warning;
            return this;
        }
    }
}

