/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.UnsignedInt;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.CodeSystemContentMode;
import org.linuxforhealth.fhir.model.type.code.CodeSystemHierarchyMeaning;
import org.linuxforhealth.fhir.model.type.code.FilterOperator;
import org.linuxforhealth.fhir.model.type.code.PropertyType;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="csd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/CodeSystem"), @Constraint(id="csd-1", level="Rule", location="(base)", description="Within a code system definition, all the codes SHALL be unique", expression="concept.code.combine($this.descendants().concept.code).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/CodeSystem"), @Constraint(id="codeSystem-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/CodeSystem", generated=true), @Constraint(id="codeSystem-3", level="Warning", location="concept.designation.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/CodeSystem", generated=true), @Constraint(id="codeSystem-4", level="Warning", location="concept.designation.use", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/designation-use", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/designation-use', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/CodeSystem", generated=true)})
public class CodeSystem
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    @Summary
    private final Boolean caseSensitive;
    @Summary
    private final Canonical valueSet;
    @Summary
    @Binding(bindingName="CodeSystemHierarchyMeaning", strength=BindingStrength.Value.REQUIRED, description="The meaning of the hierarchy of concepts in a code system.", valueSet="http://hl7.org/fhir/ValueSet/codesystem-hierarchy-meaning|4.3.0")
    private final CodeSystemHierarchyMeaning hierarchyMeaning;
    @Summary
    private final Boolean compositional;
    @Summary
    private final Boolean versionNeeded;
    @Summary
    @Binding(bindingName="CodeSystemContentMode", strength=BindingStrength.Value.REQUIRED, description="The extent of the content of the code system (the concepts and codes it defines) are represented in a code system resource.", valueSet="http://hl7.org/fhir/ValueSet/codesystem-content-mode|4.3.0")
    @Required
    private final CodeSystemContentMode content;
    @Summary
    private final Canonical supplements;
    @Summary
    private final UnsignedInt count;
    @Summary
    private final List<Filter> filter;
    @Summary
    private final List<Property> property;
    private final List<Concept> concept;

    private CodeSystem(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.caseSensitive = builder.caseSensitive;
        this.valueSet = builder.valueSet;
        this.hierarchyMeaning = builder.hierarchyMeaning;
        this.compositional = builder.compositional;
        this.versionNeeded = builder.versionNeeded;
        this.content = builder.content;
        this.supplements = builder.supplements;
        this.count = builder.count;
        this.filter = Collections.unmodifiableList(builder.filter);
        this.property = Collections.unmodifiableList(builder.property);
        this.concept = Collections.unmodifiableList(builder.concept);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public org.linuxforhealth.fhir.model.type.String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public Canonical getValueSet() {
        return this.valueSet;
    }

    public CodeSystemHierarchyMeaning getHierarchyMeaning() {
        return this.hierarchyMeaning;
    }

    public Boolean getCompositional() {
        return this.compositional;
    }

    public Boolean getVersionNeeded() {
        return this.versionNeeded;
    }

    public CodeSystemContentMode getContent() {
        return this.content;
    }

    public Canonical getSupplements() {
        return this.supplements;
    }

    public UnsignedInt getCount() {
        return this.count;
    }

    public List<Filter> getFilter() {
        return this.filter;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    public List<Concept> getConcept() {
        return this.concept;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.caseSensitive != null || this.valueSet != null || this.hierarchyMeaning != null || this.compositional != null || this.versionNeeded != null || this.content != null || this.supplements != null || this.count != null || !this.filter.isEmpty() || !this.property.isEmpty() || !this.concept.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.caseSensitive, "caseSensitive", visitor);
                this.accept(this.valueSet, "valueSet", visitor);
                this.accept(this.hierarchyMeaning, "hierarchyMeaning", visitor);
                this.accept(this.compositional, "compositional", visitor);
                this.accept(this.versionNeeded, "versionNeeded", visitor);
                this.accept(this.content, "content", visitor);
                this.accept(this.supplements, "supplements", visitor);
                this.accept(this.count, "count", visitor);
                this.accept(this.filter, "filter", visitor, Filter.class);
                this.accept(this.property, "property", visitor, Property.class);
                this.accept(this.concept, "concept", visitor, Concept.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeSystem other = (CodeSystem)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.caseSensitive, other.caseSensitive) && Objects.equals(this.valueSet, other.valueSet) && Objects.equals(this.hierarchyMeaning, other.hierarchyMeaning) && Objects.equals(this.compositional, other.compositional) && Objects.equals(this.versionNeeded, other.versionNeeded) && Objects.equals(this.content, other.content) && Objects.equals(this.supplements, other.supplements) && Objects.equals(this.count, other.count) && Objects.equals(this.filter, other.filter) && Objects.equals(this.property, other.property) && Objects.equals(this.concept, other.concept);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.caseSensitive, this.valueSet, this.hierarchyMeaning, this.compositional, this.versionNeeded, this.content, this.supplements, this.count, this.filter, this.property, this.concept);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Concept
    extends BackboneElement {
        @Required
        private final Code code;
        private final org.linuxforhealth.fhir.model.type.String display;
        private final org.linuxforhealth.fhir.model.type.String definition;
        private final List<Designation> designation;
        private final List<Property> property;
        private final List<Concept> concept;

        private Concept(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.display = builder.display;
            this.definition = builder.definition;
            this.designation = Collections.unmodifiableList(builder.designation);
            this.property = Collections.unmodifiableList(builder.property);
            this.concept = Collections.unmodifiableList(builder.concept);
        }

        public Code getCode() {
            return this.code;
        }

        public org.linuxforhealth.fhir.model.type.String getDisplay() {
            return this.display;
        }

        public org.linuxforhealth.fhir.model.type.String getDefinition() {
            return this.definition;
        }

        public List<Designation> getDesignation() {
            return this.designation;
        }

        public List<Property> getProperty() {
            return this.property;
        }

        public List<Concept> getConcept() {
            return this.concept;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.display != null || this.definition != null || !this.designation.isEmpty() || !this.property.isEmpty() || !this.concept.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.display, "display", visitor);
                    this.accept(this.definition, "definition", visitor);
                    this.accept(this.designation, "designation", visitor, Designation.class);
                    this.accept(this.property, "property", visitor, Property.class);
                    this.accept(this.concept, "concept", visitor, Concept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Concept other = (Concept)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.display, other.display) && Objects.equals(this.definition, other.definition) && Objects.equals(this.designation, other.designation) && Objects.equals(this.property, other.property) && Objects.equals(this.concept, other.concept);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.display, this.definition, this.designation, this.property, this.concept);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Property
        extends BackboneElement {
            @Required
            private final Code code;
            @Choice(value={Code.class, Coding.class, org.linuxforhealth.fhir.model.type.String.class, Integer.class, Boolean.class, DateTime.class, Decimal.class})
            @Required
            private final Element value;

            private Property(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.value = builder.value;
            }

            public Code getCode() {
                return this.code;
            }

            public Element getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.value != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Property other = (Property)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Code code;
                private Element value;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(Code code) {
                    this.code = code;
                    return this;
                }

                public Builder value(String value) {
                    this.value = value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value);
                    return this;
                }

                public Builder value(java.lang.Integer value) {
                    this.value = value == null ? null : Integer.of(value);
                    return this;
                }

                public Builder value(java.lang.Boolean value) {
                    this.value = value == null ? null : Boolean.of(value);
                    return this;
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Property build() {
                    Property property = new Property(this);
                    if (this.validating) {
                        this.validate(property);
                    }
                    return property;
                }

                protected void validate(Property property) {
                    super.validate(property);
                    ValidationSupport.requireNonNull(property.code, "code");
                    ValidationSupport.requireChoiceElement(property.value, "value", Code.class, Coding.class, org.linuxforhealth.fhir.model.type.String.class, Integer.class, Boolean.class, DateTime.class, Decimal.class);
                    ValidationSupport.requireValueOrChildren(property);
                }

                protected Builder from(Property property) {
                    super.from(property);
                    this.code = property.code;
                    this.value = property.value;
                    return this;
                }
            }
        }

        public static class Designation
        extends BackboneElement {
            @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="IETF language tag", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
            private final Code language;
            @Binding(bindingName="ConceptDesignationUse", strength=BindingStrength.Value.EXTENSIBLE, description="Details of how a designation would be used.", valueSet="http://hl7.org/fhir/ValueSet/designation-use")
            private final Coding use;
            @Required
            private final org.linuxforhealth.fhir.model.type.String value;

            private Designation(Builder builder) {
                super(builder);
                this.language = builder.language;
                this.use = builder.use;
                this.value = builder.value;
            }

            public Code getLanguage() {
                return this.language;
            }

            public Coding getUse() {
                return this.use;
            }

            public org.linuxforhealth.fhir.model.type.String getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.language != null || this.use != null || this.value != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.language, "language", visitor);
                        this.accept(this.use, "use", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Designation other = (Designation)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.language, other.language) && Objects.equals(this.use, other.use) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.language, this.use, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Code language;
                private Coding use;
                private org.linuxforhealth.fhir.model.type.String value;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder language(Code language) {
                    this.language = language;
                    return this;
                }

                public Builder use(Coding use) {
                    this.use = use;
                    return this;
                }

                public Builder value(String value) {
                    this.value = value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value);
                    return this;
                }

                public Builder value(org.linuxforhealth.fhir.model.type.String value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Designation build() {
                    Designation designation = new Designation(this);
                    if (this.validating) {
                        this.validate(designation);
                    }
                    return designation;
                }

                protected void validate(Designation designation) {
                    super.validate(designation);
                    ValidationSupport.requireNonNull(designation.value, "value");
                    ValidationSupport.checkValueSetBinding(designation.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
                    ValidationSupport.requireValueOrChildren(designation);
                }

                protected Builder from(Designation designation) {
                    super.from(designation);
                    this.language = designation.language;
                    this.use = designation.use;
                    this.value = designation.value;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Code code;
            private org.linuxforhealth.fhir.model.type.String display;
            private org.linuxforhealth.fhir.model.type.String definition;
            private List<Designation> designation = new ArrayList<Designation>();
            private List<Property> property = new ArrayList<Property>();
            private List<Concept> concept = new ArrayList<Concept>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(Code code) {
                this.code = code;
                return this;
            }

            public Builder display(String display) {
                this.display = display == null ? null : org.linuxforhealth.fhir.model.type.String.of(display);
                return this;
            }

            public Builder display(org.linuxforhealth.fhir.model.type.String display) {
                this.display = display;
                return this;
            }

            public Builder definition(String definition) {
                this.definition = definition == null ? null : org.linuxforhealth.fhir.model.type.String.of(definition);
                return this;
            }

            public Builder definition(org.linuxforhealth.fhir.model.type.String definition) {
                this.definition = definition;
                return this;
            }

            public Builder designation(Designation ... designation) {
                for (Designation value : designation) {
                    this.designation.add(value);
                }
                return this;
            }

            public Builder designation(Collection<Designation> designation) {
                this.designation = new ArrayList<Designation>(designation);
                return this;
            }

            public Builder property(Property ... property) {
                for (Property value : property) {
                    this.property.add(value);
                }
                return this;
            }

            public Builder property(Collection<Property> property) {
                this.property = new ArrayList<Property>(property);
                return this;
            }

            public Builder concept(Concept ... concept) {
                for (Concept value : concept) {
                    this.concept.add(value);
                }
                return this;
            }

            public Builder concept(Collection<Concept> concept) {
                this.concept = new ArrayList<Concept>(concept);
                return this;
            }

            @Override
            public Concept build() {
                Concept concept = new Concept(this);
                if (this.validating) {
                    this.validate(concept);
                }
                return concept;
            }

            protected void validate(Concept concept) {
                super.validate(concept);
                ValidationSupport.requireNonNull(concept.code, "code");
                ValidationSupport.checkList(concept.designation, "designation", Designation.class);
                ValidationSupport.checkList(concept.property, "property", Property.class);
                ValidationSupport.checkList(concept.concept, "concept", Concept.class);
                ValidationSupport.requireValueOrChildren(concept);
            }

            protected Builder from(Concept concept) {
                super.from(concept);
                this.code = concept.code;
                this.display = concept.display;
                this.definition = concept.definition;
                this.designation.addAll(concept.designation);
                this.property.addAll(concept.property);
                this.concept.addAll(concept.concept);
                return this;
            }
        }
    }

    public static class Property
    extends BackboneElement {
        @Summary
        @Required
        private final Code code;
        @Summary
        private final Uri uri;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String description;
        @Summary
        @Binding(bindingName="PropertyType", strength=BindingStrength.Value.REQUIRED, description="The type of a property value.", valueSet="http://hl7.org/fhir/ValueSet/concept-property-type|4.3.0")
        @Required
        private final PropertyType type;

        private Property(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.uri = builder.uri;
            this.description = builder.description;
            this.type = builder.type;
        }

        public Code getCode() {
            return this.code;
        }

        public Uri getUri() {
            return this.uri;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public PropertyType getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.uri != null || this.description != null || this.type != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.uri, "uri", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.type, "type", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.uri, other.uri) && Objects.equals(this.description, other.description) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.uri, this.description, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Code code;
            private Uri uri;
            private org.linuxforhealth.fhir.model.type.String description;
            private PropertyType type;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(Code code) {
                this.code = code;
                return this;
            }

            public Builder uri(Uri uri) {
                this.uri = uri;
                return this;
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder type(PropertyType type) {
                this.type = type;
                return this;
            }

            @Override
            public Property build() {
                Property property = new Property(this);
                if (this.validating) {
                    this.validate(property);
                }
                return property;
            }

            protected void validate(Property property) {
                super.validate(property);
                ValidationSupport.requireNonNull(property.code, "code");
                ValidationSupport.requireNonNull(property.type, "type");
                ValidationSupport.requireValueOrChildren(property);
            }

            protected Builder from(Property property) {
                super.from(property);
                this.code = property.code;
                this.uri = property.uri;
                this.description = property.description;
                this.type = property.type;
                return this;
            }
        }
    }

    public static class Filter
    extends BackboneElement {
        @Summary
        @Required
        private final Code code;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String description;
        @Summary
        @Binding(bindingName="FilterOperator", strength=BindingStrength.Value.REQUIRED, description="The kind of operation to perform as a part of a property based filter.", valueSet="http://hl7.org/fhir/ValueSet/filter-operator|4.3.0")
        @Required
        private final List<FilterOperator> operator;
        @Summary
        @Required
        private final org.linuxforhealth.fhir.model.type.String value;

        private Filter(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.description = builder.description;
            this.operator = Collections.unmodifiableList(builder.operator);
            this.value = builder.value;
        }

        public Code getCode() {
            return this.code;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public List<FilterOperator> getOperator() {
            return this.operator;
        }

        public org.linuxforhealth.fhir.model.type.String getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.description != null || !this.operator.isEmpty() || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.operator, "operator", visitor, FilterOperator.class);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Filter other = (Filter)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.operator, other.operator) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.description, this.operator, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Code code;
            private org.linuxforhealth.fhir.model.type.String description;
            private List<FilterOperator> operator = new ArrayList<FilterOperator>();
            private org.linuxforhealth.fhir.model.type.String value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(Code code) {
                this.code = code;
                return this;
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder operator(FilterOperator ... operator) {
                for (FilterOperator value : operator) {
                    this.operator.add(value);
                }
                return this;
            }

            public Builder operator(Collection<FilterOperator> operator) {
                this.operator = new ArrayList<FilterOperator>(operator);
                return this;
            }

            public Builder value(String value) {
                this.value = value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value);
                return this;
            }

            public Builder value(org.linuxforhealth.fhir.model.type.String value) {
                this.value = value;
                return this;
            }

            @Override
            public Filter build() {
                Filter filter = new Filter(this);
                if (this.validating) {
                    this.validate(filter);
                }
                return filter;
            }

            protected void validate(Filter filter) {
                super.validate(filter);
                ValidationSupport.requireNonNull(filter.code, "code");
                ValidationSupport.checkNonEmptyList(filter.operator, "operator", FilterOperator.class);
                ValidationSupport.requireNonNull(filter.value, "value");
                ValidationSupport.requireValueOrChildren(filter);
            }

            protected Builder from(Filter filter) {
                super.from(filter);
                this.code = filter.code;
                this.description = filter.description;
                this.operator.addAll(filter.operator);
                this.value = filter.value;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String version;
        private org.linuxforhealth.fhir.model.type.String name;
        private org.linuxforhealth.fhir.model.type.String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private Boolean caseSensitive;
        private Canonical valueSet;
        private CodeSystemHierarchyMeaning hierarchyMeaning;
        private Boolean compositional;
        private Boolean versionNeeded;
        private CodeSystemContentMode content;
        private Canonical supplements;
        private UnsignedInt count;
        private List<Filter> filter = new ArrayList<Filter>();
        private List<Property> property = new ArrayList<Property>();
        private List<Concept> concept = new ArrayList<Concept>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
            return this;
        }

        public Builder title(org.linuxforhealth.fhir.model.type.String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder caseSensitive(java.lang.Boolean caseSensitive) {
            this.caseSensitive = caseSensitive == null ? null : Boolean.of(caseSensitive);
            return this;
        }

        public Builder caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public Builder valueSet(Canonical valueSet) {
            this.valueSet = valueSet;
            return this;
        }

        public Builder hierarchyMeaning(CodeSystemHierarchyMeaning hierarchyMeaning) {
            this.hierarchyMeaning = hierarchyMeaning;
            return this;
        }

        public Builder compositional(java.lang.Boolean compositional) {
            this.compositional = compositional == null ? null : Boolean.of(compositional);
            return this;
        }

        public Builder compositional(Boolean compositional) {
            this.compositional = compositional;
            return this;
        }

        public Builder versionNeeded(java.lang.Boolean versionNeeded) {
            this.versionNeeded = versionNeeded == null ? null : Boolean.of(versionNeeded);
            return this;
        }

        public Builder versionNeeded(Boolean versionNeeded) {
            this.versionNeeded = versionNeeded;
            return this;
        }

        public Builder content(CodeSystemContentMode content) {
            this.content = content;
            return this;
        }

        public Builder supplements(Canonical supplements) {
            this.supplements = supplements;
            return this;
        }

        public Builder count(UnsignedInt count) {
            this.count = count;
            return this;
        }

        public Builder filter(Filter ... filter) {
            for (Filter value : filter) {
                this.filter.add(value);
            }
            return this;
        }

        public Builder filter(Collection<Filter> filter) {
            this.filter = new ArrayList<Filter>(filter);
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        public Builder concept(Concept ... concept) {
            for (Concept value : concept) {
                this.concept.add(value);
            }
            return this;
        }

        public Builder concept(Collection<Concept> concept) {
            this.concept = new ArrayList<Concept>(concept);
            return this;
        }

        @Override
        public CodeSystem build() {
            CodeSystem codeSystem = new CodeSystem(this);
            if (this.validating) {
                this.validate(codeSystem);
            }
            return codeSystem;
        }

        protected void validate(CodeSystem codeSystem) {
            super.validate(codeSystem);
            ValidationSupport.checkList(codeSystem.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(codeSystem.status, "status");
            ValidationSupport.checkList(codeSystem.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(codeSystem.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(codeSystem.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.requireNonNull(codeSystem.content, "content");
            ValidationSupport.checkList(codeSystem.filter, "filter", Filter.class);
            ValidationSupport.checkList(codeSystem.property, "property", Property.class);
            ValidationSupport.checkList(codeSystem.concept, "concept", Concept.class);
        }

        protected Builder from(CodeSystem codeSystem) {
            super.from(codeSystem);
            this.url = codeSystem.url;
            this.identifier.addAll(codeSystem.identifier);
            this.version = codeSystem.version;
            this.name = codeSystem.name;
            this.title = codeSystem.title;
            this.status = codeSystem.status;
            this.experimental = codeSystem.experimental;
            this.date = codeSystem.date;
            this.publisher = codeSystem.publisher;
            this.contact.addAll(codeSystem.contact);
            this.description = codeSystem.description;
            this.useContext.addAll(codeSystem.useContext);
            this.jurisdiction.addAll(codeSystem.jurisdiction);
            this.purpose = codeSystem.purpose;
            this.copyright = codeSystem.copyright;
            this.caseSensitive = codeSystem.caseSensitive;
            this.valueSet = codeSystem.valueSet;
            this.hierarchyMeaning = codeSystem.hierarchyMeaning;
            this.compositional = codeSystem.compositional;
            this.versionNeeded = codeSystem.versionNeeded;
            this.content = codeSystem.content;
            this.supplements = codeSystem.supplements;
            this.count = codeSystem.count;
            this.filter.addAll(codeSystem.filter);
            this.property.addAll(codeSystem.property);
            this.concept.addAll(codeSystem.concept);
            return this;
        }
    }
}

