/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.DeviceNameType;
import org.linuxforhealth.fhir.model.type.code.FHIRDeviceStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.type.code.UDIEntryType;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="device-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/device-status-reason", expression="statusReason.exists() implies (statusReason.all(memberOf('http://hl7.org/fhir/ValueSet/device-status-reason', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Device", generated=true)
public class Device
extends DomainResource {
    private final List<Identifier> identifier;
    @ReferenceTarget(value={"DeviceDefinition"})
    private final Reference definition;
    @Summary
    private final List<UdiCarrier> udiCarrier;
    @Summary
    @Binding(bindingName="FHIRDeviceStatus", strength=BindingStrength.Value.REQUIRED, description="The availability status of the device.", valueSet="http://hl7.org/fhir/ValueSet/device-status|4.3.0")
    private final FHIRDeviceStatus status;
    @Binding(bindingName="FHIRDeviceStatusReason", strength=BindingStrength.Value.EXTENSIBLE, description="The availability status reason of the device.", valueSet="http://hl7.org/fhir/ValueSet/device-status-reason")
    private final List<CodeableConcept> statusReason;
    private final org.linuxforhealth.fhir.model.type.String distinctIdentifier;
    private final org.linuxforhealth.fhir.model.type.String manufacturer;
    private final DateTime manufactureDate;
    private final DateTime expirationDate;
    private final org.linuxforhealth.fhir.model.type.String lotNumber;
    private final org.linuxforhealth.fhir.model.type.String serialNumber;
    private final List<DeviceName> deviceName;
    private final org.linuxforhealth.fhir.model.type.String modelNumber;
    private final org.linuxforhealth.fhir.model.type.String partNumber;
    @Binding(bindingName="DeviceType", strength=BindingStrength.Value.EXAMPLE, description="Codes to identify medical devices.", valueSet="http://hl7.org/fhir/ValueSet/device-type")
    private final CodeableConcept type;
    private final List<Specialization> specialization;
    private final List<Version> version;
    private final List<Property> property;
    @ReferenceTarget(value={"Patient"})
    private final Reference patient;
    @ReferenceTarget(value={"Organization"})
    private final Reference owner;
    private final List<ContactPoint> contact;
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    private final Uri url;
    private final List<Annotation> note;
    @Summary
    private final List<CodeableConcept> safety;
    @ReferenceTarget(value={"Device"})
    private final Reference parent;

    private Device(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.definition = builder.definition;
        this.udiCarrier = Collections.unmodifiableList(builder.udiCarrier);
        this.status = builder.status;
        this.statusReason = Collections.unmodifiableList(builder.statusReason);
        this.distinctIdentifier = builder.distinctIdentifier;
        this.manufacturer = builder.manufacturer;
        this.manufactureDate = builder.manufactureDate;
        this.expirationDate = builder.expirationDate;
        this.lotNumber = builder.lotNumber;
        this.serialNumber = builder.serialNumber;
        this.deviceName = Collections.unmodifiableList(builder.deviceName);
        this.modelNumber = builder.modelNumber;
        this.partNumber = builder.partNumber;
        this.type = builder.type;
        this.specialization = Collections.unmodifiableList(builder.specialization);
        this.version = Collections.unmodifiableList(builder.version);
        this.property = Collections.unmodifiableList(builder.property);
        this.patient = builder.patient;
        this.owner = builder.owner;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.location = builder.location;
        this.url = builder.url;
        this.note = Collections.unmodifiableList(builder.note);
        this.safety = Collections.unmodifiableList(builder.safety);
        this.parent = builder.parent;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Reference getDefinition() {
        return this.definition;
    }

    public List<UdiCarrier> getUdiCarrier() {
        return this.udiCarrier;
    }

    public FHIRDeviceStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getStatusReason() {
        return this.statusReason;
    }

    public org.linuxforhealth.fhir.model.type.String getDistinctIdentifier() {
        return this.distinctIdentifier;
    }

    public org.linuxforhealth.fhir.model.type.String getManufacturer() {
        return this.manufacturer;
    }

    public DateTime getManufactureDate() {
        return this.manufactureDate;
    }

    public DateTime getExpirationDate() {
        return this.expirationDate;
    }

    public org.linuxforhealth.fhir.model.type.String getLotNumber() {
        return this.lotNumber;
    }

    public org.linuxforhealth.fhir.model.type.String getSerialNumber() {
        return this.serialNumber;
    }

    public List<DeviceName> getDeviceName() {
        return this.deviceName;
    }

    public org.linuxforhealth.fhir.model.type.String getModelNumber() {
        return this.modelNumber;
    }

    public org.linuxforhealth.fhir.model.type.String getPartNumber() {
        return this.partNumber;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public List<Specialization> getSpecialization() {
        return this.specialization;
    }

    public List<Version> getVersion() {
        return this.version;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public List<ContactPoint> getContact() {
        return this.contact;
    }

    public Reference getLocation() {
        return this.location;
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<CodeableConcept> getSafety() {
        return this.safety;
    }

    public Reference getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.definition != null || !this.udiCarrier.isEmpty() || this.status != null || !this.statusReason.isEmpty() || this.distinctIdentifier != null || this.manufacturer != null || this.manufactureDate != null || this.expirationDate != null || this.lotNumber != null || this.serialNumber != null || !this.deviceName.isEmpty() || this.modelNumber != null || this.partNumber != null || this.type != null || !this.specialization.isEmpty() || !this.version.isEmpty() || !this.property.isEmpty() || this.patient != null || this.owner != null || !this.contact.isEmpty() || this.location != null || this.url != null || !this.note.isEmpty() || !this.safety.isEmpty() || this.parent != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.definition, "definition", visitor);
                this.accept(this.udiCarrier, "udiCarrier", visitor, UdiCarrier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor, CodeableConcept.class);
                this.accept(this.distinctIdentifier, "distinctIdentifier", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor);
                this.accept(this.manufactureDate, "manufactureDate", visitor);
                this.accept(this.expirationDate, "expirationDate", visitor);
                this.accept(this.lotNumber, "lotNumber", visitor);
                this.accept(this.serialNumber, "serialNumber", visitor);
                this.accept(this.deviceName, "deviceName", visitor, DeviceName.class);
                this.accept(this.modelNumber, "modelNumber", visitor);
                this.accept(this.partNumber, "partNumber", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.specialization, "specialization", visitor, Specialization.class);
                this.accept(this.version, "version", visitor, Version.class);
                this.accept(this.property, "property", visitor, Property.class);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.owner, "owner", visitor);
                this.accept(this.contact, "contact", visitor, ContactPoint.class);
                this.accept(this.location, "location", visitor);
                this.accept(this.url, "url", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.safety, "safety", visitor, CodeableConcept.class);
                this.accept(this.parent, "parent", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.definition, other.definition) && Objects.equals(this.udiCarrier, other.udiCarrier) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.distinctIdentifier, other.distinctIdentifier) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.manufactureDate, other.manufactureDate) && Objects.equals(this.expirationDate, other.expirationDate) && Objects.equals(this.lotNumber, other.lotNumber) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.deviceName, other.deviceName) && Objects.equals(this.modelNumber, other.modelNumber) && Objects.equals(this.partNumber, other.partNumber) && Objects.equals(this.type, other.type) && Objects.equals(this.specialization, other.specialization) && Objects.equals(this.version, other.version) && Objects.equals(this.property, other.property) && Objects.equals(this.patient, other.patient) && Objects.equals(this.owner, other.owner) && Objects.equals(this.contact, other.contact) && Objects.equals(this.location, other.location) && Objects.equals(this.url, other.url) && Objects.equals(this.note, other.note) && Objects.equals(this.safety, other.safety) && Objects.equals(this.parent, other.parent);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.definition, this.udiCarrier, this.status, this.statusReason, this.distinctIdentifier, this.manufacturer, this.manufactureDate, this.expirationDate, this.lotNumber, this.serialNumber, this.deviceName, this.modelNumber, this.partNumber, this.type, this.specialization, this.version, this.property, this.patient, this.owner, this.contact, this.location, this.url, this.note, this.safety, this.parent);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Property
    extends BackboneElement {
        @Required
        private final CodeableConcept type;
        private final List<Quantity> valueQuantity;
        private final List<CodeableConcept> valueCode;

        private Property(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.valueQuantity = Collections.unmodifiableList(builder.valueQuantity);
            this.valueCode = Collections.unmodifiableList(builder.valueCode);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<Quantity> getValueQuantity() {
            return this.valueQuantity;
        }

        public List<CodeableConcept> getValueCode() {
            return this.valueCode;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.valueQuantity.isEmpty() || !this.valueCode.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.valueQuantity, "valueQuantity", visitor, Quantity.class);
                    this.accept(this.valueCode, "valueCode", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.valueQuantity, other.valueQuantity) && Objects.equals(this.valueCode, other.valueCode);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.valueQuantity, this.valueCode);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<Quantity> valueQuantity = new ArrayList<Quantity>();
            private List<CodeableConcept> valueCode = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder valueQuantity(Quantity ... valueQuantity) {
                for (Quantity value : valueQuantity) {
                    this.valueQuantity.add(value);
                }
                return this;
            }

            public Builder valueQuantity(Collection<Quantity> valueQuantity) {
                this.valueQuantity = new ArrayList<Quantity>(valueQuantity);
                return this;
            }

            public Builder valueCode(CodeableConcept ... valueCode) {
                for (CodeableConcept value : valueCode) {
                    this.valueCode.add(value);
                }
                return this;
            }

            public Builder valueCode(Collection<CodeableConcept> valueCode) {
                this.valueCode = new ArrayList<CodeableConcept>(valueCode);
                return this;
            }

            @Override
            public Property build() {
                Property property = new Property(this);
                if (this.validating) {
                    this.validate(property);
                }
                return property;
            }

            protected void validate(Property property) {
                super.validate(property);
                ValidationSupport.requireNonNull(property.type, "type");
                ValidationSupport.checkList(property.valueQuantity, "valueQuantity", Quantity.class);
                ValidationSupport.checkList(property.valueCode, "valueCode", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(property);
            }

            protected Builder from(Property property) {
                super.from(property);
                this.type = property.type;
                this.valueQuantity.addAll(property.valueQuantity);
                this.valueCode.addAll(property.valueCode);
                return this;
            }
        }
    }

    public static class Version
    extends BackboneElement {
        private final CodeableConcept type;
        private final Identifier component;
        @Required
        private final org.linuxforhealth.fhir.model.type.String value;

        private Version(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.component = builder.component;
            this.value = builder.value;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Identifier getComponent() {
            return this.component;
        }

        public org.linuxforhealth.fhir.model.type.String getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.component != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.component, "component", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.component, other.component) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.component, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Identifier component;
            private org.linuxforhealth.fhir.model.type.String value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder component(Identifier component) {
                this.component = component;
                return this;
            }

            public Builder value(String value) {
                this.value = value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value);
                return this;
            }

            public Builder value(org.linuxforhealth.fhir.model.type.String value) {
                this.value = value;
                return this;
            }

            @Override
            public Version build() {
                Version version = new Version(this);
                if (this.validating) {
                    this.validate(version);
                }
                return version;
            }

            protected void validate(Version version) {
                super.validate(version);
                ValidationSupport.requireNonNull(version.value, "value");
                ValidationSupport.requireValueOrChildren(version);
            }

            protected Builder from(Version version) {
                super.from(version);
                this.type = version.type;
                this.component = version.component;
                this.value = version.value;
                return this;
            }
        }
    }

    public static class Specialization
    extends BackboneElement {
        @Required
        private final CodeableConcept systemType;
        private final org.linuxforhealth.fhir.model.type.String version;

        private Specialization(Builder builder) {
            super(builder);
            this.systemType = builder.systemType;
            this.version = builder.version;
        }

        public CodeableConcept getSystemType() {
            return this.systemType;
        }

        public org.linuxforhealth.fhir.model.type.String getVersion() {
            return this.version;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.systemType != null || this.version != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.systemType, "systemType", visitor);
                    this.accept(this.version, "version", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Specialization other = (Specialization)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.systemType, other.systemType) && Objects.equals(this.version, other.version);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.systemType, this.version);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept systemType;
            private org.linuxforhealth.fhir.model.type.String version;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder systemType(CodeableConcept systemType) {
                this.systemType = systemType;
                return this;
            }

            public Builder version(String version) {
                this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
                return this;
            }

            public Builder version(org.linuxforhealth.fhir.model.type.String version) {
                this.version = version;
                return this;
            }

            @Override
            public Specialization build() {
                Specialization specialization = new Specialization(this);
                if (this.validating) {
                    this.validate(specialization);
                }
                return specialization;
            }

            protected void validate(Specialization specialization) {
                super.validate(specialization);
                ValidationSupport.requireNonNull(specialization.systemType, "systemType");
                ValidationSupport.requireValueOrChildren(specialization);
            }

            protected Builder from(Specialization specialization) {
                super.from(specialization);
                this.systemType = specialization.systemType;
                this.version = specialization.version;
                return this;
            }
        }
    }

    public static class DeviceName
    extends BackboneElement {
        @Required
        private final org.linuxforhealth.fhir.model.type.String name;
        @Binding(bindingName="DeviceNameType", strength=BindingStrength.Value.REQUIRED, description="The type of name the device is referred by.", valueSet="http://hl7.org/fhir/ValueSet/device-nametype|4.3.0")
        @Required
        private final DeviceNameType type;

        private DeviceName(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.type = builder.type;
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public DeviceNameType getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.type != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.type, "type", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviceName other = (DeviceName)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String name;
            private DeviceNameType type;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder type(DeviceNameType type) {
                this.type = type;
                return this;
            }

            @Override
            public DeviceName build() {
                DeviceName deviceName = new DeviceName(this);
                if (this.validating) {
                    this.validate(deviceName);
                }
                return deviceName;
            }

            protected void validate(DeviceName deviceName) {
                super.validate(deviceName);
                ValidationSupport.requireNonNull(deviceName.name, "name");
                ValidationSupport.requireNonNull(deviceName.type, "type");
                ValidationSupport.requireValueOrChildren(deviceName);
            }

            protected Builder from(DeviceName deviceName) {
                super.from(deviceName);
                this.name = deviceName.name;
                this.type = deviceName.type;
                return this;
            }
        }
    }

    public static class UdiCarrier
    extends BackboneElement {
        @Summary
        private final org.linuxforhealth.fhir.model.type.String deviceIdentifier;
        private final Uri issuer;
        private final Uri jurisdiction;
        @Summary
        private final Base64Binary carrierAIDC;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String carrierHRF;
        @Binding(bindingName="UDIEntryType", strength=BindingStrength.Value.REQUIRED, description="Codes to identify how UDI data was entered.", valueSet="http://hl7.org/fhir/ValueSet/udi-entry-type|4.3.0")
        private final UDIEntryType entryType;

        private UdiCarrier(Builder builder) {
            super(builder);
            this.deviceIdentifier = builder.deviceIdentifier;
            this.issuer = builder.issuer;
            this.jurisdiction = builder.jurisdiction;
            this.carrierAIDC = builder.carrierAIDC;
            this.carrierHRF = builder.carrierHRF;
            this.entryType = builder.entryType;
        }

        public org.linuxforhealth.fhir.model.type.String getDeviceIdentifier() {
            return this.deviceIdentifier;
        }

        public Uri getIssuer() {
            return this.issuer;
        }

        public Uri getJurisdiction() {
            return this.jurisdiction;
        }

        public Base64Binary getCarrierAIDC() {
            return this.carrierAIDC;
        }

        public org.linuxforhealth.fhir.model.type.String getCarrierHRF() {
            return this.carrierHRF;
        }

        public UDIEntryType getEntryType() {
            return this.entryType;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.deviceIdentifier != null || this.issuer != null || this.jurisdiction != null || this.carrierAIDC != null || this.carrierHRF != null || this.entryType != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.deviceIdentifier, "deviceIdentifier", visitor);
                    this.accept(this.issuer, "issuer", visitor);
                    this.accept(this.jurisdiction, "jurisdiction", visitor);
                    this.accept(this.carrierAIDC, "carrierAIDC", visitor);
                    this.accept(this.carrierHRF, "carrierHRF", visitor);
                    this.accept(this.entryType, "entryType", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UdiCarrier other = (UdiCarrier)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.deviceIdentifier, other.deviceIdentifier) && Objects.equals(this.issuer, other.issuer) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.carrierAIDC, other.carrierAIDC) && Objects.equals(this.carrierHRF, other.carrierHRF) && Objects.equals(this.entryType, other.entryType);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.deviceIdentifier, this.issuer, this.jurisdiction, this.carrierAIDC, this.carrierHRF, this.entryType);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String deviceIdentifier;
            private Uri issuer;
            private Uri jurisdiction;
            private Base64Binary carrierAIDC;
            private org.linuxforhealth.fhir.model.type.String carrierHRF;
            private UDIEntryType entryType;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder deviceIdentifier(String deviceIdentifier) {
                this.deviceIdentifier = deviceIdentifier == null ? null : org.linuxforhealth.fhir.model.type.String.of(deviceIdentifier);
                return this;
            }

            public Builder deviceIdentifier(org.linuxforhealth.fhir.model.type.String deviceIdentifier) {
                this.deviceIdentifier = deviceIdentifier;
                return this;
            }

            public Builder issuer(Uri issuer) {
                this.issuer = issuer;
                return this;
            }

            public Builder jurisdiction(Uri jurisdiction) {
                this.jurisdiction = jurisdiction;
                return this;
            }

            public Builder carrierAIDC(Base64Binary carrierAIDC) {
                this.carrierAIDC = carrierAIDC;
                return this;
            }

            public Builder carrierHRF(String carrierHRF) {
                this.carrierHRF = carrierHRF == null ? null : org.linuxforhealth.fhir.model.type.String.of(carrierHRF);
                return this;
            }

            public Builder carrierHRF(org.linuxforhealth.fhir.model.type.String carrierHRF) {
                this.carrierHRF = carrierHRF;
                return this;
            }

            public Builder entryType(UDIEntryType entryType) {
                this.entryType = entryType;
                return this;
            }

            @Override
            public UdiCarrier build() {
                UdiCarrier udiCarrier = new UdiCarrier(this);
                if (this.validating) {
                    this.validate(udiCarrier);
                }
                return udiCarrier;
            }

            protected void validate(UdiCarrier udiCarrier) {
                super.validate(udiCarrier);
                ValidationSupport.requireValueOrChildren(udiCarrier);
            }

            protected Builder from(UdiCarrier udiCarrier) {
                super.from(udiCarrier);
                this.deviceIdentifier = udiCarrier.deviceIdentifier;
                this.issuer = udiCarrier.issuer;
                this.jurisdiction = udiCarrier.jurisdiction;
                this.carrierAIDC = udiCarrier.carrierAIDC;
                this.carrierHRF = udiCarrier.carrierHRF;
                this.entryType = udiCarrier.entryType;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Reference definition;
        private List<UdiCarrier> udiCarrier = new ArrayList<UdiCarrier>();
        private FHIRDeviceStatus status;
        private List<CodeableConcept> statusReason = new ArrayList<CodeableConcept>();
        private org.linuxforhealth.fhir.model.type.String distinctIdentifier;
        private org.linuxforhealth.fhir.model.type.String manufacturer;
        private DateTime manufactureDate;
        private DateTime expirationDate;
        private org.linuxforhealth.fhir.model.type.String lotNumber;
        private org.linuxforhealth.fhir.model.type.String serialNumber;
        private List<DeviceName> deviceName = new ArrayList<DeviceName>();
        private org.linuxforhealth.fhir.model.type.String modelNumber;
        private org.linuxforhealth.fhir.model.type.String partNumber;
        private CodeableConcept type;
        private List<Specialization> specialization = new ArrayList<Specialization>();
        private List<Version> version = new ArrayList<Version>();
        private List<Property> property = new ArrayList<Property>();
        private Reference patient;
        private Reference owner;
        private List<ContactPoint> contact = new ArrayList<ContactPoint>();
        private Reference location;
        private Uri url;
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<CodeableConcept> safety = new ArrayList<CodeableConcept>();
        private Reference parent;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder definition(Reference definition) {
            this.definition = definition;
            return this;
        }

        public Builder udiCarrier(UdiCarrier ... udiCarrier) {
            for (UdiCarrier value : udiCarrier) {
                this.udiCarrier.add(value);
            }
            return this;
        }

        public Builder udiCarrier(Collection<UdiCarrier> udiCarrier) {
            this.udiCarrier = new ArrayList<UdiCarrier>(udiCarrier);
            return this;
        }

        public Builder status(FHIRDeviceStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept ... statusReason) {
            for (CodeableConcept value : statusReason) {
                this.statusReason.add(value);
            }
            return this;
        }

        public Builder statusReason(Collection<CodeableConcept> statusReason) {
            this.statusReason = new ArrayList<CodeableConcept>(statusReason);
            return this;
        }

        public Builder distinctIdentifier(String distinctIdentifier) {
            this.distinctIdentifier = distinctIdentifier == null ? null : org.linuxforhealth.fhir.model.type.String.of(distinctIdentifier);
            return this;
        }

        public Builder distinctIdentifier(org.linuxforhealth.fhir.model.type.String distinctIdentifier) {
            this.distinctIdentifier = distinctIdentifier;
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer == null ? null : org.linuxforhealth.fhir.model.type.String.of(manufacturer);
            return this;
        }

        public Builder manufacturer(org.linuxforhealth.fhir.model.type.String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder manufactureDate(DateTime manufactureDate) {
            this.manufactureDate = manufactureDate;
            return this;
        }

        public Builder expirationDate(DateTime expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder lotNumber(String lotNumber) {
            this.lotNumber = lotNumber == null ? null : org.linuxforhealth.fhir.model.type.String.of(lotNumber);
            return this;
        }

        public Builder lotNumber(org.linuxforhealth.fhir.model.type.String lotNumber) {
            this.lotNumber = lotNumber;
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber == null ? null : org.linuxforhealth.fhir.model.type.String.of(serialNumber);
            return this;
        }

        public Builder serialNumber(org.linuxforhealth.fhir.model.type.String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder deviceName(DeviceName ... deviceName) {
            for (DeviceName value : deviceName) {
                this.deviceName.add(value);
            }
            return this;
        }

        public Builder deviceName(Collection<DeviceName> deviceName) {
            this.deviceName = new ArrayList<DeviceName>(deviceName);
            return this;
        }

        public Builder modelNumber(String modelNumber) {
            this.modelNumber = modelNumber == null ? null : org.linuxforhealth.fhir.model.type.String.of(modelNumber);
            return this;
        }

        public Builder modelNumber(org.linuxforhealth.fhir.model.type.String modelNumber) {
            this.modelNumber = modelNumber;
            return this;
        }

        public Builder partNumber(String partNumber) {
            this.partNumber = partNumber == null ? null : org.linuxforhealth.fhir.model.type.String.of(partNumber);
            return this;
        }

        public Builder partNumber(org.linuxforhealth.fhir.model.type.String partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder specialization(Specialization ... specialization) {
            for (Specialization value : specialization) {
                this.specialization.add(value);
            }
            return this;
        }

        public Builder specialization(Collection<Specialization> specialization) {
            this.specialization = new ArrayList<Specialization>(specialization);
            return this;
        }

        public Builder version(Version ... version) {
            for (Version value : version) {
                this.version.add(value);
            }
            return this;
        }

        public Builder version(Collection<Version> version) {
            this.version = new ArrayList<Version>(version);
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder owner(Reference owner) {
            this.owner = owner;
            return this;
        }

        public Builder contact(ContactPoint ... contact) {
            for (ContactPoint value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactPoint> contact) {
            this.contact = new ArrayList<ContactPoint>(contact);
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder safety(CodeableConcept ... safety) {
            for (CodeableConcept value : safety) {
                this.safety.add(value);
            }
            return this;
        }

        public Builder safety(Collection<CodeableConcept> safety) {
            this.safety = new ArrayList<CodeableConcept>(safety);
            return this;
        }

        public Builder parent(Reference parent) {
            this.parent = parent;
            return this;
        }

        @Override
        public Device build() {
            Device device = new Device(this);
            if (this.validating) {
                this.validate(device);
            }
            return device;
        }

        protected void validate(Device device) {
            super.validate(device);
            ValidationSupport.checkList(device.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(device.udiCarrier, "udiCarrier", UdiCarrier.class);
            ValidationSupport.checkList(device.statusReason, "statusReason", CodeableConcept.class);
            ValidationSupport.checkList(device.deviceName, "deviceName", DeviceName.class);
            ValidationSupport.checkList(device.specialization, "specialization", Specialization.class);
            ValidationSupport.checkList(device.version, "version", Version.class);
            ValidationSupport.checkList(device.property, "property", Property.class);
            ValidationSupport.checkList(device.contact, "contact", ContactPoint.class);
            ValidationSupport.checkList(device.note, "note", Annotation.class);
            ValidationSupport.checkList(device.safety, "safety", CodeableConcept.class);
            ValidationSupport.checkReferenceType(device.definition, "definition", "DeviceDefinition");
            ValidationSupport.checkReferenceType(device.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(device.owner, "owner", "Organization");
            ValidationSupport.checkReferenceType(device.location, "location", "Location");
            ValidationSupport.checkReferenceType(device.parent, "parent", "Device");
        }

        protected Builder from(Device device) {
            super.from(device);
            this.identifier.addAll(device.identifier);
            this.definition = device.definition;
            this.udiCarrier.addAll(device.udiCarrier);
            this.status = device.status;
            this.statusReason.addAll(device.statusReason);
            this.distinctIdentifier = device.distinctIdentifier;
            this.manufacturer = device.manufacturer;
            this.manufactureDate = device.manufactureDate;
            this.expirationDate = device.expirationDate;
            this.lotNumber = device.lotNumber;
            this.serialNumber = device.serialNumber;
            this.deviceName.addAll(device.deviceName);
            this.modelNumber = device.modelNumber;
            this.partNumber = device.partNumber;
            this.type = device.type;
            this.specialization.addAll(device.specialization);
            this.version.addAll(device.version);
            this.property.addAll(device.property);
            this.patient = device.patient;
            this.owner = device.owner;
            this.contact.addAll(device.contact);
            this.location = device.location;
            this.url = device.url;
            this.note.addAll(device.note);
            this.safety.addAll(device.safety);
            this.parent = device.parent;
            return this;
        }
    }
}

