/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.DiagnosticReportStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="diagnosticReport-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/report-codes", expression="code.exists() and code.memberOf('http://hl7.org/fhir/ValueSet/report-codes', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/DiagnosticReport", generated=true)
public class DiagnosticReport
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @ReferenceTarget(value={"CarePlan", "ImmunizationRecommendation", "MedicationRequest", "NutritionOrder", "ServiceRequest"})
    private final List<Reference> basedOn;
    @Summary
    @Binding(bindingName="DiagnosticReportStatus", strength=BindingStrength.Value.REQUIRED, description="The status of the diagnostic report.", valueSet="http://hl7.org/fhir/ValueSet/diagnostic-report-status|4.3.0")
    @Required
    private final DiagnosticReportStatus status;
    @Summary
    @Binding(bindingName="DiagnosticServiceSection", strength=BindingStrength.Value.EXAMPLE, description="HL7 V2 table 0074", valueSet="http://hl7.org/fhir/ValueSet/diagnostic-service-sections")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="DiagnosticReportCodes", strength=BindingStrength.Value.PREFERRED, description="LOINC Codes for Diagnostic Reports", valueSet="http://hl7.org/fhir/ValueSet/report-codes")
    @Required
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Device", "Location", "Organization", "Procedure", "Practitioner", "Medication", "Substance"})
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    private final Element effective;
    @Summary
    private final Instant issued;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam"})
    private final List<Reference> performer;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam"})
    private final List<Reference> resultsInterpreter;
    @ReferenceTarget(value={"Specimen"})
    private final List<Reference> specimen;
    @ReferenceTarget(value={"Observation"})
    private final List<Reference> result;
    @ReferenceTarget(value={"ImagingStudy"})
    private final List<Reference> imagingStudy;
    @Summary
    private final List<Media> media;
    private final String conclusion;
    @Binding(bindingName="AdjunctDiagnosis", strength=BindingStrength.Value.EXAMPLE, description="SNOMED CT Clinical Findings", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    private final List<CodeableConcept> conclusionCode;
    private final List<Attachment> presentedForm;

    private DiagnosticReport(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.basedOn = Collections.unmodifiableList(builder.basedOn);
        this.status = builder.status;
        this.category = Collections.unmodifiableList(builder.category);
        this.code = builder.code;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.effective = builder.effective;
        this.issued = builder.issued;
        this.performer = Collections.unmodifiableList(builder.performer);
        this.resultsInterpreter = Collections.unmodifiableList(builder.resultsInterpreter);
        this.specimen = Collections.unmodifiableList(builder.specimen);
        this.result = Collections.unmodifiableList(builder.result);
        this.imagingStudy = Collections.unmodifiableList(builder.imagingStudy);
        this.media = Collections.unmodifiableList(builder.media);
        this.conclusion = builder.conclusion;
        this.conclusionCode = Collections.unmodifiableList(builder.conclusionCode);
        this.presentedForm = Collections.unmodifiableList(builder.presentedForm);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public DiagnosticReportStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getEffective() {
        return this.effective;
    }

    public Instant getIssued() {
        return this.issued;
    }

    public List<Reference> getPerformer() {
        return this.performer;
    }

    public List<Reference> getResultsInterpreter() {
        return this.resultsInterpreter;
    }

    public List<Reference> getSpecimen() {
        return this.specimen;
    }

    public List<Reference> getResult() {
        return this.result;
    }

    public List<Reference> getImagingStudy() {
        return this.imagingStudy;
    }

    public List<Media> getMedia() {
        return this.media;
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public List<CodeableConcept> getConclusionCode() {
        return this.conclusionCode;
    }

    public List<Attachment> getPresentedForm() {
        return this.presentedForm;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.basedOn.isEmpty() || this.status != null || !this.category.isEmpty() || this.code != null || this.subject != null || this.encounter != null || this.effective != null || this.issued != null || !this.performer.isEmpty() || !this.resultsInterpreter.isEmpty() || !this.specimen.isEmpty() || !this.result.isEmpty() || !this.imagingStudy.isEmpty() || !this.media.isEmpty() || this.conclusion != null || !this.conclusionCode.isEmpty() || !this.presentedForm.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.effective, "effective", visitor);
                this.accept(this.issued, "issued", visitor);
                this.accept(this.performer, "performer", visitor, Reference.class);
                this.accept(this.resultsInterpreter, "resultsInterpreter", visitor, Reference.class);
                this.accept(this.specimen, "specimen", visitor, Reference.class);
                this.accept(this.result, "result", visitor, Reference.class);
                this.accept(this.imagingStudy, "imagingStudy", visitor, Reference.class);
                this.accept(this.media, "media", visitor, Media.class);
                this.accept(this.conclusion, "conclusion", visitor);
                this.accept(this.conclusionCode, "conclusionCode", visitor, CodeableConcept.class);
                this.accept(this.presentedForm, "presentedForm", visitor, Attachment.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagnosticReport other = (DiagnosticReport)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.status, other.status) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.effective, other.effective) && Objects.equals(this.issued, other.issued) && Objects.equals(this.performer, other.performer) && Objects.equals(this.resultsInterpreter, other.resultsInterpreter) && Objects.equals(this.specimen, other.specimen) && Objects.equals(this.result, other.result) && Objects.equals(this.imagingStudy, other.imagingStudy) && Objects.equals(this.media, other.media) && Objects.equals(this.conclusion, other.conclusion) && Objects.equals(this.conclusionCode, other.conclusionCode) && Objects.equals(this.presentedForm, other.presentedForm);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.status, this.category, this.code, this.subject, this.encounter, this.effective, this.issued, this.performer, this.resultsInterpreter, this.specimen, this.result, this.imagingStudy, this.media, this.conclusion, this.conclusionCode, this.presentedForm);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Media
    extends BackboneElement {
        private final String comment;
        @Summary
        @ReferenceTarget(value={"Media"})
        @Required
        private final Reference link;

        private Media(Builder builder) {
            super(builder);
            this.comment = builder.comment;
            this.link = builder.link;
        }

        public String getComment() {
            return this.comment;
        }

        public Reference getLink() {
            return this.link;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.comment != null || this.link != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.comment, "comment", visitor);
                    this.accept(this.link, "link", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Media other = (Media)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.comment, other.comment) && Objects.equals(this.link, other.link);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.comment, this.link);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String comment;
            private Reference link;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder comment(java.lang.String comment) {
                this.comment = comment == null ? null : String.of(comment);
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder link(Reference link) {
                this.link = link;
                return this;
            }

            @Override
            public Media build() {
                Media media = new Media(this);
                if (this.validating) {
                    this.validate(media);
                }
                return media;
            }

            protected void validate(Media media) {
                super.validate(media);
                ValidationSupport.requireNonNull(media.link, "link");
                ValidationSupport.checkReferenceType(media.link, "link", "Media");
                ValidationSupport.requireValueOrChildren(media);
            }

            protected Builder from(Media media) {
                super.from(media);
                this.comment = media.comment;
                this.link = media.link;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private DiagnosticReportStatus status;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept code;
        private Reference subject;
        private Reference encounter;
        private Element effective;
        private Instant issued;
        private List<Reference> performer = new ArrayList<Reference>();
        private List<Reference> resultsInterpreter = new ArrayList<Reference>();
        private List<Reference> specimen = new ArrayList<Reference>();
        private List<Reference> result = new ArrayList<Reference>();
        private List<Reference> imagingStudy = new ArrayList<Reference>();
        private List<Media> media = new ArrayList<Media>();
        private String conclusion;
        private List<CodeableConcept> conclusionCode = new ArrayList<CodeableConcept>();
        private List<Attachment> presentedForm = new ArrayList<Attachment>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder status(DiagnosticReportStatus status) {
            this.status = status;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder effective(Element effective) {
            this.effective = effective;
            return this;
        }

        public Builder issued(ZonedDateTime issued) {
            this.issued = issued == null ? null : Instant.of(issued);
            return this;
        }

        public Builder issued(Instant issued) {
            this.issued = issued;
            return this;
        }

        public Builder performer(Reference ... performer) {
            for (Reference value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Reference> performer) {
            this.performer = new ArrayList<Reference>(performer);
            return this;
        }

        public Builder resultsInterpreter(Reference ... resultsInterpreter) {
            for (Reference value : resultsInterpreter) {
                this.resultsInterpreter.add(value);
            }
            return this;
        }

        public Builder resultsInterpreter(Collection<Reference> resultsInterpreter) {
            this.resultsInterpreter = new ArrayList<Reference>(resultsInterpreter);
            return this;
        }

        public Builder specimen(Reference ... specimen) {
            for (Reference value : specimen) {
                this.specimen.add(value);
            }
            return this;
        }

        public Builder specimen(Collection<Reference> specimen) {
            this.specimen = new ArrayList<Reference>(specimen);
            return this;
        }

        public Builder result(Reference ... result) {
            for (Reference value : result) {
                this.result.add(value);
            }
            return this;
        }

        public Builder result(Collection<Reference> result) {
            this.result = new ArrayList<Reference>(result);
            return this;
        }

        public Builder imagingStudy(Reference ... imagingStudy) {
            for (Reference value : imagingStudy) {
                this.imagingStudy.add(value);
            }
            return this;
        }

        public Builder imagingStudy(Collection<Reference> imagingStudy) {
            this.imagingStudy = new ArrayList<Reference>(imagingStudy);
            return this;
        }

        public Builder media(Media ... media) {
            for (Media value : media) {
                this.media.add(value);
            }
            return this;
        }

        public Builder media(Collection<Media> media) {
            this.media = new ArrayList<Media>(media);
            return this;
        }

        public Builder conclusion(java.lang.String conclusion) {
            this.conclusion = conclusion == null ? null : String.of(conclusion);
            return this;
        }

        public Builder conclusion(String conclusion) {
            this.conclusion = conclusion;
            return this;
        }

        public Builder conclusionCode(CodeableConcept ... conclusionCode) {
            for (CodeableConcept value : conclusionCode) {
                this.conclusionCode.add(value);
            }
            return this;
        }

        public Builder conclusionCode(Collection<CodeableConcept> conclusionCode) {
            this.conclusionCode = new ArrayList<CodeableConcept>(conclusionCode);
            return this;
        }

        public Builder presentedForm(Attachment ... presentedForm) {
            for (Attachment value : presentedForm) {
                this.presentedForm.add(value);
            }
            return this;
        }

        public Builder presentedForm(Collection<Attachment> presentedForm) {
            this.presentedForm = new ArrayList<Attachment>(presentedForm);
            return this;
        }

        @Override
        public DiagnosticReport build() {
            DiagnosticReport diagnosticReport = new DiagnosticReport(this);
            if (this.validating) {
                this.validate(diagnosticReport);
            }
            return diagnosticReport;
        }

        protected void validate(DiagnosticReport diagnosticReport) {
            super.validate(diagnosticReport);
            ValidationSupport.checkList(diagnosticReport.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(diagnosticReport.basedOn, "basedOn", Reference.class);
            ValidationSupport.requireNonNull(diagnosticReport.status, "status");
            ValidationSupport.checkList(diagnosticReport.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(diagnosticReport.code, "code");
            ValidationSupport.choiceElement(diagnosticReport.effective, "effective", DateTime.class, Period.class);
            ValidationSupport.checkList(diagnosticReport.performer, "performer", Reference.class);
            ValidationSupport.checkList(diagnosticReport.resultsInterpreter, "resultsInterpreter", Reference.class);
            ValidationSupport.checkList(diagnosticReport.specimen, "specimen", Reference.class);
            ValidationSupport.checkList(diagnosticReport.result, "result", Reference.class);
            ValidationSupport.checkList(diagnosticReport.imagingStudy, "imagingStudy", Reference.class);
            ValidationSupport.checkList(diagnosticReport.media, "media", Media.class);
            ValidationSupport.checkList(diagnosticReport.conclusionCode, "conclusionCode", CodeableConcept.class);
            ValidationSupport.checkList(diagnosticReport.presentedForm, "presentedForm", Attachment.class);
            ValidationSupport.checkReferenceType(diagnosticReport.basedOn, "basedOn", "CarePlan", "ImmunizationRecommendation", "MedicationRequest", "NutritionOrder", "ServiceRequest");
            ValidationSupport.checkReferenceType(diagnosticReport.subject, "subject", "Patient", "Group", "Device", "Location", "Organization", "Procedure", "Practitioner", "Medication", "Substance");
            ValidationSupport.checkReferenceType(diagnosticReport.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(diagnosticReport.performer, "performer", "Practitioner", "PractitionerRole", "Organization", "CareTeam");
            ValidationSupport.checkReferenceType(diagnosticReport.resultsInterpreter, "resultsInterpreter", "Practitioner", "PractitionerRole", "Organization", "CareTeam");
            ValidationSupport.checkReferenceType(diagnosticReport.specimen, "specimen", "Specimen");
            ValidationSupport.checkReferenceType(diagnosticReport.result, "result", "Observation");
            ValidationSupport.checkReferenceType(diagnosticReport.imagingStudy, "imagingStudy", "ImagingStudy");
        }

        protected Builder from(DiagnosticReport diagnosticReport) {
            super.from(diagnosticReport);
            this.identifier.addAll(diagnosticReport.identifier);
            this.basedOn.addAll(diagnosticReport.basedOn);
            this.status = diagnosticReport.status;
            this.category.addAll(diagnosticReport.category);
            this.code = diagnosticReport.code;
            this.subject = diagnosticReport.subject;
            this.encounter = diagnosticReport.encounter;
            this.effective = diagnosticReport.effective;
            this.issued = diagnosticReport.issued;
            this.performer.addAll(diagnosticReport.performer);
            this.resultsInterpreter.addAll(diagnosticReport.resultsInterpreter);
            this.specimen.addAll(diagnosticReport.specimen);
            this.result.addAll(diagnosticReport.result);
            this.imagingStudy.addAll(diagnosticReport.imagingStudy);
            this.media.addAll(diagnosticReport.media);
            this.conclusion = diagnosticReport.conclusion;
            this.conclusionCode.addAll(diagnosticReport.conclusionCode);
            this.presentedForm.addAll(diagnosticReport.presentedForm);
            return this;
        }
    }
}

