/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.DocumentReferenceStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
public class DocumentManifest
extends DomainResource {
    @Summary
    private final Identifier masterIdentifier;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="DocumentReferenceStatus", strength=BindingStrength.Value.REQUIRED, description="The status of the document reference.", valueSet="http://hl7.org/fhir/ValueSet/document-reference-status|4.3.0")
    @Required
    private final DocumentReferenceStatus status;
    @Summary
    @Binding(bindingName="v3Act", strength=BindingStrength.Value.EXAMPLE, description="The activity that caused the DocumentManifest to be created.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActCode")
    private final CodeableConcept type;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "Group", "Device"})
    private final Reference subject;
    private final DateTime created;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Device", "Patient", "RelatedPerson"})
    private final List<Reference> author;
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Organization"})
    private final List<Reference> recipient;
    private final Uri source;
    @Summary
    private final String description;
    @Summary
    @Required
    private final List<Reference> content;
    private final List<Related> related;

    private DocumentManifest(Builder builder) {
        super(builder);
        this.masterIdentifier = builder.masterIdentifier;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.type = builder.type;
        this.subject = builder.subject;
        this.created = builder.created;
        this.author = Collections.unmodifiableList(builder.author);
        this.recipient = Collections.unmodifiableList(builder.recipient);
        this.source = builder.source;
        this.description = builder.description;
        this.content = Collections.unmodifiableList(builder.content);
        this.related = Collections.unmodifiableList(builder.related);
    }

    public Identifier getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public DocumentReferenceStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public List<Reference> getAuthor() {
        return this.author;
    }

    public List<Reference> getRecipient() {
        return this.recipient;
    }

    public Uri getSource() {
        return this.source;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Reference> getContent() {
        return this.content;
    }

    public List<Related> getRelated() {
        return this.related;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.masterIdentifier != null || !this.identifier.isEmpty() || this.status != null || this.type != null || this.subject != null || this.created != null || !this.author.isEmpty() || !this.recipient.isEmpty() || this.source != null || this.description != null || !this.content.isEmpty() || !this.related.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.masterIdentifier, "masterIdentifier", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.author, "author", visitor, Reference.class);
                this.accept(this.recipient, "recipient", visitor, Reference.class);
                this.accept(this.source, "source", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.content, "content", visitor, Reference.class);
                this.accept(this.related, "related", visitor, Related.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentManifest other = (DocumentManifest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.masterIdentifier, other.masterIdentifier) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.subject, other.subject) && Objects.equals(this.created, other.created) && Objects.equals(this.author, other.author) && Objects.equals(this.recipient, other.recipient) && Objects.equals(this.source, other.source) && Objects.equals(this.description, other.description) && Objects.equals(this.content, other.content) && Objects.equals(this.related, other.related);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.masterIdentifier, this.identifier, this.status, this.type, this.subject, this.created, this.author, this.recipient, this.source, this.description, this.content, this.related);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Related
    extends BackboneElement {
        private final Identifier identifier;
        private final Reference ref;

        private Related(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.ref = builder.ref;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public Reference getRef() {
            return this.ref;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.ref != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.ref, "ref", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Related other = (Related)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.ref, other.ref);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.ref);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier identifier;
            private Reference ref;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder ref(Reference ref) {
                this.ref = ref;
                return this;
            }

            @Override
            public Related build() {
                Related related = new Related(this);
                if (this.validating) {
                    this.validate(related);
                }
                return related;
            }

            protected void validate(Related related) {
                super.validate(related);
                ValidationSupport.requireValueOrChildren(related);
            }

            protected Builder from(Related related) {
                super.from(related);
                this.identifier = related.identifier;
                this.ref = related.ref;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier masterIdentifier;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private DocumentReferenceStatus status;
        private CodeableConcept type;
        private Reference subject;
        private DateTime created;
        private List<Reference> author = new ArrayList<Reference>();
        private List<Reference> recipient = new ArrayList<Reference>();
        private Uri source;
        private String description;
        private List<Reference> content = new ArrayList<Reference>();
        private List<Related> related = new ArrayList<Related>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder masterIdentifier(Identifier masterIdentifier) {
            this.masterIdentifier = masterIdentifier;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(DocumentReferenceStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder author(Reference ... author) {
            for (Reference value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<Reference> author) {
            this.author = new ArrayList<Reference>(author);
            return this;
        }

        public Builder recipient(Reference ... recipient) {
            for (Reference value : recipient) {
                this.recipient.add(value);
            }
            return this;
        }

        public Builder recipient(Collection<Reference> recipient) {
            this.recipient = new ArrayList<Reference>(recipient);
            return this;
        }

        public Builder source(Uri source) {
            this.source = source;
            return this;
        }

        public Builder description(java.lang.String description) {
            this.description = description == null ? null : String.of(description);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder content(Reference ... content) {
            for (Reference value : content) {
                this.content.add(value);
            }
            return this;
        }

        public Builder content(Collection<Reference> content) {
            this.content = new ArrayList<Reference>(content);
            return this;
        }

        public Builder related(Related ... related) {
            for (Related value : related) {
                this.related.add(value);
            }
            return this;
        }

        public Builder related(Collection<Related> related) {
            this.related = new ArrayList<Related>(related);
            return this;
        }

        @Override
        public DocumentManifest build() {
            DocumentManifest documentManifest = new DocumentManifest(this);
            if (this.validating) {
                this.validate(documentManifest);
            }
            return documentManifest;
        }

        protected void validate(DocumentManifest documentManifest) {
            super.validate(documentManifest);
            ValidationSupport.checkList(documentManifest.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(documentManifest.status, "status");
            ValidationSupport.checkList(documentManifest.author, "author", Reference.class);
            ValidationSupport.checkList(documentManifest.recipient, "recipient", Reference.class);
            ValidationSupport.checkNonEmptyList(documentManifest.content, "content", Reference.class);
            ValidationSupport.checkList(documentManifest.related, "related", Related.class);
            ValidationSupport.checkReferenceType(documentManifest.subject, "subject", "Patient", "Practitioner", "Group", "Device");
            ValidationSupport.checkReferenceType(documentManifest.author, "author", "Practitioner", "PractitionerRole", "Organization", "Device", "Patient", "RelatedPerson");
            ValidationSupport.checkReferenceType(documentManifest.recipient, "recipient", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Organization");
        }

        protected Builder from(DocumentManifest documentManifest) {
            super.from(documentManifest);
            this.masterIdentifier = documentManifest.masterIdentifier;
            this.identifier.addAll(documentManifest.identifier);
            this.status = documentManifest.status;
            this.type = documentManifest.type;
            this.subject = documentManifest.subject;
            this.created = documentManifest.created;
            this.author.addAll(documentManifest.author);
            this.recipient.addAll(documentManifest.recipient);
            this.source = documentManifest.source;
            this.description = documentManifest.description;
            this.content.addAll(documentManifest.content);
            this.related.addAll(documentManifest.related);
            return this;
        }
    }
}

