/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="dom-2", level="Rule", location="(base)", description="If the resource is contained in another resource, it SHALL NOT contain nested Resources", expression="contained.contained.empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-3", level="Rule", location="(base)", description="If the resource is contained in another resource, it SHALL be referred to from elsewhere in the resource or SHALL refer to the containing resource", expression="contained.where(((id.exists() and ('#'+id in (%resource.descendants().reference | %resource.descendants().as(canonical) | %resource.descendants().as(uri) | %resource.descendants().as(url)))) or descendants().where(reference = '#').exists() or descendants().where(as(canonical) = '#').exists() or descendants().where(as(uri) = '#').exists()).not()).trace('unmatched', id).empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-4", level="Rule", location="(base)", description="If a resource is contained in another resource, it SHALL NOT have a meta.versionId or a meta.lastUpdated", expression="contained.meta.versionId.empty() and contained.meta.lastUpdated.empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-5", level="Rule", location="(base)", description="If a resource is contained in another resource, it SHALL NOT have a security label", expression="contained.meta.security.empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-6", level="Warning", location="(base)", description="A resource should have narrative for robust management", expression="text.`div`.exists()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-r4b", level="Warning", location="DomainResource.contained", description="Containing new R4B resources within R4 resources may cause interoperability issues if instances are shared with R4 systems", expression="($this is Citation or $this is Evidence or $this is EvidenceReport or $this is EvidenceVariable or $this is MedicinalProductDefinition or $this is PackagedProductDefinition or $this is AdministrableProductDefinition or $this is Ingredient or $this is ClinicalUseDefinition or $this is RegulatedAuthorization or $this is SubstanceDefinition or $this is SubscriptionStatus or $this is SubscriptionTopic) implies (%resource is Citation or %resource is Evidence or %resource is EvidenceReport or %resource is EvidenceVariable or %resource is MedicinalProductDefinition or %resource is PackagedProductDefinition or %resource is AdministrableProductDefinition or %resource is Ingredient or %resource is ClinicalUseDefinition or %resource is RegulatedAuthorization or %resource is SubstanceDefinition or %resource is SubscriptionStatus or %resource is SubscriptionTopic)", source="http://hl7.org/fhir/StructureDefinition/DomainResource")})
public abstract class DomainResource
extends Resource {
    protected final Narrative text;
    protected final List<Resource> contained;
    protected final List<Extension> extension;
    protected final List<Extension> modifierExtension;

    protected DomainResource(Builder builder) {
        super(builder);
        this.text = builder.text;
        this.contained = Collections.unmodifiableList(builder.contained);
        this.extension = Collections.unmodifiableList(builder.extension);
        this.modifierExtension = Collections.unmodifiableList(builder.modifierExtension);
    }

    public Narrative getText() {
        return this.text;
    }

    public List<Resource> getContained() {
        return this.contained;
    }

    public List<Extension> getExtension() {
        return this.extension;
    }

    public List<Extension> getModifierExtension() {
        return this.modifierExtension;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.text != null || !this.contained.isEmpty() || !this.extension.isEmpty() || !this.modifierExtension.isEmpty();
    }

    @Override
    public abstract Builder toBuilder();

    public static abstract class Builder
    extends Resource.Builder {
        protected Narrative text;
        protected List<Resource> contained = new ArrayList<Resource>();
        protected List<Extension> extension = new ArrayList<Extension>();
        protected List<Extension> modifierExtension = new ArrayList<Extension>();

        protected Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        public Builder text(Narrative text) {
            this.text = text;
            return this;
        }

        public Builder contained(Resource ... contained) {
            for (Resource value : contained) {
                this.contained.add(value);
            }
            return this;
        }

        public Builder contained(Collection<Resource> contained) {
            this.contained = new ArrayList<Resource>(contained);
            return this;
        }

        public Builder extension(Extension ... extension) {
            for (Extension value : extension) {
                this.extension.add(value);
            }
            return this;
        }

        public Builder extension(Collection<Extension> extension) {
            this.extension = new ArrayList<Extension>(extension);
            return this;
        }

        public Builder modifierExtension(Extension ... modifierExtension) {
            for (Extension value : modifierExtension) {
                this.modifierExtension.add(value);
            }
            return this;
        }

        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            this.modifierExtension = new ArrayList<Extension>(modifierExtension);
            return this;
        }

        @Override
        public abstract DomainResource build();

        protected void validate(DomainResource domainResource) {
            super.validate(domainResource);
            ValidationSupport.checkList(domainResource.contained, "contained", Resource.class);
            ValidationSupport.checkList(domainResource.extension, "extension", Extension.class);
            ValidationSupport.checkList(domainResource.modifierExtension, "modifierExtension", Extension.class);
        }

        protected Builder from(DomainResource domainResource) {
            super.from(domainResource);
            this.text = domainResource.text;
            this.contained.addAll(domainResource.contained);
            this.extension.addAll(domainResource.extension);
            this.modifierExtension.addAll(domainResource.modifierExtension);
            return this;
        }
    }
}

