/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.RelatedArtifact;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.type.UnsignedInt;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.EvidenceVariableHandling;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cnl-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/Evidence"), @Constraint(id="evidence-1", level="Warning", location="variableDefinition.variableRole", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/variable-role", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/variable-role', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-2", level="Warning", location="variableDefinition.directnessMatch", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/directness", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/directness', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/synthesis-type", expression="synthesisType.exists() implies (synthesisType.memberOf('http://hl7.org/fhir/ValueSet/synthesis-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-4", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/study-type", expression="studyType.exists() implies (studyType.memberOf('http://hl7.org/fhir/ValueSet/study-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-5", level="Warning", location="statistic.statisticType", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/statistic-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/statistic-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-6", level="Warning", location="statistic.attributeEstimate.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/attribute-estimate-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/attribute-estimate-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-7", level="Warning", location="statistic.modelCharacteristic.code", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/statistic-model-code", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/statistic-model-code', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-8", level="Warning", location="certainty.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/certainty-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/certainty-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true), @Constraint(id="evidence-9", level="Warning", location="certainty.rating", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/certainty-rating", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/certainty-rating', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Evidence", generated=true)})
public class Evidence
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String title;
    @ReferenceTarget(value={"Citation"})
    @Choice(value={Reference.class, Markdown.class})
    private final Element citeAs;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final DateTime date;
    @Summary
    private final List<UsageContext> useContext;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    @Summary
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final Markdown description;
    private final Markdown assertion;
    private final List<Annotation> note;
    @Required
    private final List<VariableDefinition> variableDefinition;
    @Binding(bindingName="SynthesisType", strength=BindingStrength.Value.EXTENSIBLE, description="Types of combining results from a body of evidence (eg. summary data meta-analysis).", valueSet="http://hl7.org/fhir/ValueSet/synthesis-type")
    private final CodeableConcept synthesisType;
    @Binding(bindingName="StudyType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of study the evidence was derived from.", valueSet="http://hl7.org/fhir/ValueSet/study-type")
    private final CodeableConcept studyType;
    private final List<Statistic> statistic;
    private final List<Certainty> certainty;

    private Evidence(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.title = builder.title;
        this.citeAs = builder.citeAs;
        this.status = builder.status;
        this.date = builder.date;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.description = builder.description;
        this.assertion = builder.assertion;
        this.note = Collections.unmodifiableList(builder.note);
        this.variableDefinition = Collections.unmodifiableList(builder.variableDefinition);
        this.synthesisType = builder.synthesisType;
        this.studyType = builder.studyType;
        this.statistic = Collections.unmodifiableList(builder.statistic);
        this.certainty = Collections.unmodifiableList(builder.certainty);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public org.linuxforhealth.fhir.model.type.String getTitle() {
        return this.title;
    }

    public Element getCiteAs() {
        return this.citeAs;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public DateTime getDate() {
        return this.date;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public Markdown getAssertion() {
        return this.assertion;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<VariableDefinition> getVariableDefinition() {
        return this.variableDefinition;
    }

    public CodeableConcept getSynthesisType() {
        return this.synthesisType;
    }

    public CodeableConcept getStudyType() {
        return this.studyType;
    }

    public List<Statistic> getStatistic() {
        return this.statistic;
    }

    public List<Certainty> getCertainty() {
        return this.certainty;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.title != null || this.citeAs != null || this.status != null || this.date != null || !this.useContext.isEmpty() || this.approvalDate != null || this.lastReviewDate != null || this.publisher != null || !this.contact.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || this.description != null || this.assertion != null || !this.note.isEmpty() || !this.variableDefinition.isEmpty() || this.synthesisType != null || this.studyType != null || !this.statistic.isEmpty() || !this.certainty.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.citeAs, "citeAs", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.assertion, "assertion", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.variableDefinition, "variableDefinition", visitor, VariableDefinition.class);
                this.accept(this.synthesisType, "synthesisType", visitor);
                this.accept(this.studyType, "studyType", visitor);
                this.accept(this.statistic, "statistic", visitor, Statistic.class);
                this.accept(this.certainty, "certainty", visitor, Certainty.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Evidence other = (Evidence)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.title, other.title) && Objects.equals(this.citeAs, other.citeAs) && Objects.equals(this.status, other.status) && Objects.equals(this.date, other.date) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.description, other.description) && Objects.equals(this.assertion, other.assertion) && Objects.equals(this.note, other.note) && Objects.equals(this.variableDefinition, other.variableDefinition) && Objects.equals(this.synthesisType, other.synthesisType) && Objects.equals(this.studyType, other.studyType) && Objects.equals(this.statistic, other.statistic) && Objects.equals(this.certainty, other.certainty);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.title, this.citeAs, this.status, this.date, this.useContext, this.approvalDate, this.lastReviewDate, this.publisher, this.contact, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.description, this.assertion, this.note, this.variableDefinition, this.synthesisType, this.studyType, this.statistic, this.certainty);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Certainty
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String description;
        private final List<Annotation> note;
        @Binding(bindingName="EvidenceCertaintyType", strength=BindingStrength.Value.EXTENSIBLE, description="The aspect of quality, confidence, or certainty.", valueSet="http://hl7.org/fhir/ValueSet/certainty-type")
        private final CodeableConcept type;
        @Binding(bindingName="EvidenceCertaintyRating", strength=BindingStrength.Value.EXTENSIBLE, description="The assessment of quality, confidence, or certainty.", valueSet="http://hl7.org/fhir/ValueSet/certainty-rating")
        private final CodeableConcept rating;
        private final org.linuxforhealth.fhir.model.type.String rater;
        private final List<Certainty> subcomponent;

        private Certainty(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.note = Collections.unmodifiableList(builder.note);
            this.type = builder.type;
            this.rating = builder.rating;
            this.rater = builder.rater;
            this.subcomponent = Collections.unmodifiableList(builder.subcomponent);
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getRating() {
            return this.rating;
        }

        public org.linuxforhealth.fhir.model.type.String getRater() {
            return this.rater;
        }

        public List<Certainty> getSubcomponent() {
            return this.subcomponent;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || !this.note.isEmpty() || this.type != null || this.rating != null || this.rater != null || !this.subcomponent.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.rating, "rating", visitor);
                    this.accept(this.rater, "rater", visitor);
                    this.accept(this.subcomponent, "subcomponent", visitor, Certainty.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Certainty other = (Certainty)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.note, other.note) && Objects.equals(this.type, other.type) && Objects.equals(this.rating, other.rating) && Objects.equals(this.rater, other.rater) && Objects.equals(this.subcomponent, other.subcomponent);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.note, this.type, this.rating, this.rater, this.subcomponent);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String description;
            private List<Annotation> note = new ArrayList<Annotation>();
            private CodeableConcept type;
            private CodeableConcept rating;
            private org.linuxforhealth.fhir.model.type.String rater;
            private List<Certainty> subcomponent = new ArrayList<Certainty>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder rating(CodeableConcept rating) {
                this.rating = rating;
                return this;
            }

            public Builder rater(String rater) {
                this.rater = rater == null ? null : org.linuxforhealth.fhir.model.type.String.of(rater);
                return this;
            }

            public Builder rater(org.linuxforhealth.fhir.model.type.String rater) {
                this.rater = rater;
                return this;
            }

            public Builder subcomponent(Certainty ... subcomponent) {
                for (Certainty value : subcomponent) {
                    this.subcomponent.add(value);
                }
                return this;
            }

            public Builder subcomponent(Collection<Certainty> subcomponent) {
                this.subcomponent = new ArrayList<Certainty>(subcomponent);
                return this;
            }

            @Override
            public Certainty build() {
                Certainty certainty = new Certainty(this);
                if (this.validating) {
                    this.validate(certainty);
                }
                return certainty;
            }

            protected void validate(Certainty certainty) {
                super.validate(certainty);
                ValidationSupport.checkList(certainty.note, "note", Annotation.class);
                ValidationSupport.checkList(certainty.subcomponent, "subcomponent", Certainty.class);
                ValidationSupport.requireValueOrChildren(certainty);
            }

            protected Builder from(Certainty certainty) {
                super.from(certainty);
                this.description = certainty.description;
                this.note.addAll(certainty.note);
                this.type = certainty.type;
                this.rating = certainty.rating;
                this.rater = certainty.rater;
                this.subcomponent.addAll(certainty.subcomponent);
                return this;
            }
        }
    }

    public static class Statistic
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String description;
        private final List<Annotation> note;
        @Binding(bindingName="StatisticType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/statistic-type")
        private final CodeableConcept statisticType;
        private final CodeableConcept category;
        private final Quantity quantity;
        private final UnsignedInt numberOfEvents;
        private final UnsignedInt numberAffected;
        private final SampleSize sampleSize;
        private final List<AttributeEstimate> attributeEstimate;
        private final List<ModelCharacteristic> modelCharacteristic;

        private Statistic(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.note = Collections.unmodifiableList(builder.note);
            this.statisticType = builder.statisticType;
            this.category = builder.category;
            this.quantity = builder.quantity;
            this.numberOfEvents = builder.numberOfEvents;
            this.numberAffected = builder.numberAffected;
            this.sampleSize = builder.sampleSize;
            this.attributeEstimate = Collections.unmodifiableList(builder.attributeEstimate);
            this.modelCharacteristic = Collections.unmodifiableList(builder.modelCharacteristic);
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        public CodeableConcept getStatisticType() {
            return this.statisticType;
        }

        public CodeableConcept getCategory() {
            return this.category;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public UnsignedInt getNumberOfEvents() {
            return this.numberOfEvents;
        }

        public UnsignedInt getNumberAffected() {
            return this.numberAffected;
        }

        public SampleSize getSampleSize() {
            return this.sampleSize;
        }

        public List<AttributeEstimate> getAttributeEstimate() {
            return this.attributeEstimate;
        }

        public List<ModelCharacteristic> getModelCharacteristic() {
            return this.modelCharacteristic;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || !this.note.isEmpty() || this.statisticType != null || this.category != null || this.quantity != null || this.numberOfEvents != null || this.numberAffected != null || this.sampleSize != null || !this.attributeEstimate.isEmpty() || !this.modelCharacteristic.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                    this.accept(this.statisticType, "statisticType", visitor);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.numberOfEvents, "numberOfEvents", visitor);
                    this.accept(this.numberAffected, "numberAffected", visitor);
                    this.accept(this.sampleSize, "sampleSize", visitor);
                    this.accept(this.attributeEstimate, "attributeEstimate", visitor, AttributeEstimate.class);
                    this.accept(this.modelCharacteristic, "modelCharacteristic", visitor, ModelCharacteristic.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Statistic other = (Statistic)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.note, other.note) && Objects.equals(this.statisticType, other.statisticType) && Objects.equals(this.category, other.category) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.numberOfEvents, other.numberOfEvents) && Objects.equals(this.numberAffected, other.numberAffected) && Objects.equals(this.sampleSize, other.sampleSize) && Objects.equals(this.attributeEstimate, other.attributeEstimate) && Objects.equals(this.modelCharacteristic, other.modelCharacteristic);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.note, this.statisticType, this.category, this.quantity, this.numberOfEvents, this.numberAffected, this.sampleSize, this.attributeEstimate, this.modelCharacteristic);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class ModelCharacteristic
        extends BackboneElement {
            @Binding(bindingName="StatisticModelCode", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/statistic-model-code")
            @Required
            private final CodeableConcept code;
            private final SimpleQuantity value;
            private final List<Variable> variable;
            private final List<AttributeEstimate> attributeEstimate;

            private ModelCharacteristic(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.value = builder.value;
                this.variable = Collections.unmodifiableList(builder.variable);
                this.attributeEstimate = Collections.unmodifiableList(builder.attributeEstimate);
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public SimpleQuantity getValue() {
                return this.value;
            }

            public List<Variable> getVariable() {
                return this.variable;
            }

            public List<AttributeEstimate> getAttributeEstimate() {
                return this.attributeEstimate;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.value != null || !this.variable.isEmpty() || !this.attributeEstimate.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.value, "value", visitor);
                        this.accept(this.variable, "variable", visitor, Variable.class);
                        this.accept(this.attributeEstimate, "attributeEstimate", visitor, AttributeEstimate.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ModelCharacteristic other = (ModelCharacteristic)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value) && Objects.equals(this.variable, other.variable) && Objects.equals(this.attributeEstimate, other.attributeEstimate);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value, this.variable, this.attributeEstimate);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Variable
            extends BackboneElement {
                @ReferenceTarget(value={"Group", "EvidenceVariable"})
                @Required
                private final Reference variableDefinition;
                @Binding(bindingName="EvidenceVariableHandling", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/variable-handling|4.3.0")
                private final EvidenceVariableHandling handling;
                private final List<CodeableConcept> valueCategory;
                private final List<Quantity> valueQuantity;
                private final List<Range> valueRange;

                private Variable(Builder builder) {
                    super(builder);
                    this.variableDefinition = builder.variableDefinition;
                    this.handling = builder.handling;
                    this.valueCategory = Collections.unmodifiableList(builder.valueCategory);
                    this.valueQuantity = Collections.unmodifiableList(builder.valueQuantity);
                    this.valueRange = Collections.unmodifiableList(builder.valueRange);
                }

                public Reference getVariableDefinition() {
                    return this.variableDefinition;
                }

                public EvidenceVariableHandling getHandling() {
                    return this.handling;
                }

                public List<CodeableConcept> getValueCategory() {
                    return this.valueCategory;
                }

                public List<Quantity> getValueQuantity() {
                    return this.valueQuantity;
                }

                public List<Range> getValueRange() {
                    return this.valueRange;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.variableDefinition != null || this.handling != null || !this.valueCategory.isEmpty() || !this.valueQuantity.isEmpty() || !this.valueRange.isEmpty();
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.variableDefinition, "variableDefinition", visitor);
                            this.accept(this.handling, "handling", visitor);
                            this.accept(this.valueCategory, "valueCategory", visitor, CodeableConcept.class);
                            this.accept(this.valueQuantity, "valueQuantity", visitor, Quantity.class);
                            this.accept(this.valueRange, "valueRange", visitor, Range.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Variable other = (Variable)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.variableDefinition, other.variableDefinition) && Objects.equals(this.handling, other.handling) && Objects.equals(this.valueCategory, other.valueCategory) && Objects.equals(this.valueQuantity, other.valueQuantity) && Objects.equals(this.valueRange, other.valueRange);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.variableDefinition, this.handling, this.valueCategory, this.valueQuantity, this.valueRange);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Reference variableDefinition;
                    private EvidenceVariableHandling handling;
                    private List<CodeableConcept> valueCategory = new ArrayList<CodeableConcept>();
                    private List<Quantity> valueQuantity = new ArrayList<Quantity>();
                    private List<Range> valueRange = new ArrayList<Range>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder variableDefinition(Reference variableDefinition) {
                        this.variableDefinition = variableDefinition;
                        return this;
                    }

                    public Builder handling(EvidenceVariableHandling handling) {
                        this.handling = handling;
                        return this;
                    }

                    public Builder valueCategory(CodeableConcept ... valueCategory) {
                        for (CodeableConcept value : valueCategory) {
                            this.valueCategory.add(value);
                        }
                        return this;
                    }

                    public Builder valueCategory(Collection<CodeableConcept> valueCategory) {
                        this.valueCategory = new ArrayList<CodeableConcept>(valueCategory);
                        return this;
                    }

                    public Builder valueQuantity(Quantity ... valueQuantity) {
                        for (Quantity value : valueQuantity) {
                            this.valueQuantity.add(value);
                        }
                        return this;
                    }

                    public Builder valueQuantity(Collection<Quantity> valueQuantity) {
                        this.valueQuantity = new ArrayList<Quantity>(valueQuantity);
                        return this;
                    }

                    public Builder valueRange(Range ... valueRange) {
                        for (Range value : valueRange) {
                            this.valueRange.add(value);
                        }
                        return this;
                    }

                    public Builder valueRange(Collection<Range> valueRange) {
                        this.valueRange = new ArrayList<Range>(valueRange);
                        return this;
                    }

                    @Override
                    public Variable build() {
                        Variable variable = new Variable(this);
                        if (this.validating) {
                            this.validate(variable);
                        }
                        return variable;
                    }

                    protected void validate(Variable variable) {
                        super.validate(variable);
                        ValidationSupport.requireNonNull(variable.variableDefinition, "variableDefinition");
                        ValidationSupport.checkList(variable.valueCategory, "valueCategory", CodeableConcept.class);
                        ValidationSupport.checkList(variable.valueQuantity, "valueQuantity", Quantity.class);
                        ValidationSupport.checkList(variable.valueRange, "valueRange", Range.class);
                        ValidationSupport.checkReferenceType(variable.variableDefinition, "variableDefinition", "Group", "EvidenceVariable");
                        ValidationSupport.requireValueOrChildren(variable);
                    }

                    protected Builder from(Variable variable) {
                        super.from(variable);
                        this.variableDefinition = variable.variableDefinition;
                        this.handling = variable.handling;
                        this.valueCategory.addAll(variable.valueCategory);
                        this.valueQuantity.addAll(variable.valueQuantity);
                        this.valueRange.addAll(variable.valueRange);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private SimpleQuantity value;
                private List<Variable> variable = new ArrayList<Variable>();
                private List<AttributeEstimate> attributeEstimate = new ArrayList<AttributeEstimate>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder value(SimpleQuantity value) {
                    this.value = value;
                    return this;
                }

                public Builder variable(Variable ... variable) {
                    for (Variable value : variable) {
                        this.variable.add(value);
                    }
                    return this;
                }

                public Builder variable(Collection<Variable> variable) {
                    this.variable = new ArrayList<Variable>(variable);
                    return this;
                }

                public Builder attributeEstimate(AttributeEstimate ... attributeEstimate) {
                    for (AttributeEstimate value : attributeEstimate) {
                        this.attributeEstimate.add(value);
                    }
                    return this;
                }

                public Builder attributeEstimate(Collection<AttributeEstimate> attributeEstimate) {
                    this.attributeEstimate = new ArrayList<AttributeEstimate>(attributeEstimate);
                    return this;
                }

                @Override
                public ModelCharacteristic build() {
                    ModelCharacteristic modelCharacteristic = new ModelCharacteristic(this);
                    if (this.validating) {
                        this.validate(modelCharacteristic);
                    }
                    return modelCharacteristic;
                }

                protected void validate(ModelCharacteristic modelCharacteristic) {
                    super.validate(modelCharacteristic);
                    ValidationSupport.requireNonNull(modelCharacteristic.code, "code");
                    ValidationSupport.checkList(modelCharacteristic.variable, "variable", Variable.class);
                    ValidationSupport.checkList(modelCharacteristic.attributeEstimate, "attributeEstimate", AttributeEstimate.class);
                    ValidationSupport.requireValueOrChildren(modelCharacteristic);
                }

                protected Builder from(ModelCharacteristic modelCharacteristic) {
                    super.from(modelCharacteristic);
                    this.code = modelCharacteristic.code;
                    this.value = modelCharacteristic.value;
                    this.variable.addAll(modelCharacteristic.variable);
                    this.attributeEstimate.addAll(modelCharacteristic.attributeEstimate);
                    return this;
                }
            }
        }

        public static class AttributeEstimate
        extends BackboneElement {
            private final org.linuxforhealth.fhir.model.type.String description;
            private final List<Annotation> note;
            @Binding(bindingName="AttributeEstimateType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/attribute-estimate-type")
            private final CodeableConcept type;
            private final Quantity quantity;
            private final Decimal level;
            private final Range range;
            private final List<AttributeEstimate> attributeEstimate;

            private AttributeEstimate(Builder builder) {
                super(builder);
                this.description = builder.description;
                this.note = Collections.unmodifiableList(builder.note);
                this.type = builder.type;
                this.quantity = builder.quantity;
                this.level = builder.level;
                this.range = builder.range;
                this.attributeEstimate = Collections.unmodifiableList(builder.attributeEstimate);
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            public List<Annotation> getNote() {
                return this.note;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Quantity getQuantity() {
                return this.quantity;
            }

            public Decimal getLevel() {
                return this.level;
            }

            public Range getRange() {
                return this.range;
            }

            public List<AttributeEstimate> getAttributeEstimate() {
                return this.attributeEstimate;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.description != null || !this.note.isEmpty() || this.type != null || this.quantity != null || this.level != null || this.range != null || !this.attributeEstimate.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.note, "note", visitor, Annotation.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.level, "level", visitor);
                        this.accept(this.range, "range", visitor);
                        this.accept(this.attributeEstimate, "attributeEstimate", visitor, AttributeEstimate.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AttributeEstimate other = (AttributeEstimate)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.note, other.note) && Objects.equals(this.type, other.type) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.level, other.level) && Objects.equals(this.range, other.range) && Objects.equals(this.attributeEstimate, other.attributeEstimate);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.note, this.type, this.quantity, this.level, this.range, this.attributeEstimate);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String description;
                private List<Annotation> note = new ArrayList<Annotation>();
                private CodeableConcept type;
                private Quantity quantity;
                private Decimal level;
                private Range range;
                private List<AttributeEstimate> attributeEstimate = new ArrayList<AttributeEstimate>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                public Builder note(Annotation ... note) {
                    for (Annotation value : note) {
                        this.note.add(value);
                    }
                    return this;
                }

                public Builder note(Collection<Annotation> note) {
                    this.note = new ArrayList<Annotation>(note);
                    return this;
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder quantity(Quantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder level(Decimal level) {
                    this.level = level;
                    return this;
                }

                public Builder range(Range range) {
                    this.range = range;
                    return this;
                }

                public Builder attributeEstimate(AttributeEstimate ... attributeEstimate) {
                    for (AttributeEstimate value : attributeEstimate) {
                        this.attributeEstimate.add(value);
                    }
                    return this;
                }

                public Builder attributeEstimate(Collection<AttributeEstimate> attributeEstimate) {
                    this.attributeEstimate = new ArrayList<AttributeEstimate>(attributeEstimate);
                    return this;
                }

                @Override
                public AttributeEstimate build() {
                    AttributeEstimate attributeEstimate = new AttributeEstimate(this);
                    if (this.validating) {
                        this.validate(attributeEstimate);
                    }
                    return attributeEstimate;
                }

                protected void validate(AttributeEstimate attributeEstimate) {
                    super.validate(attributeEstimate);
                    ValidationSupport.checkList(attributeEstimate.note, "note", Annotation.class);
                    ValidationSupport.checkList(attributeEstimate.attributeEstimate, "attributeEstimate", AttributeEstimate.class);
                    ValidationSupport.requireValueOrChildren(attributeEstimate);
                }

                protected Builder from(AttributeEstimate attributeEstimate) {
                    super.from(attributeEstimate);
                    this.description = attributeEstimate.description;
                    this.note.addAll(attributeEstimate.note);
                    this.type = attributeEstimate.type;
                    this.quantity = attributeEstimate.quantity;
                    this.level = attributeEstimate.level;
                    this.range = attributeEstimate.range;
                    this.attributeEstimate.addAll(attributeEstimate.attributeEstimate);
                    return this;
                }
            }
        }

        public static class SampleSize
        extends BackboneElement {
            private final org.linuxforhealth.fhir.model.type.String description;
            private final List<Annotation> note;
            private final UnsignedInt numberOfStudies;
            private final UnsignedInt numberOfParticipants;
            private final UnsignedInt knownDataCount;

            private SampleSize(Builder builder) {
                super(builder);
                this.description = builder.description;
                this.note = Collections.unmodifiableList(builder.note);
                this.numberOfStudies = builder.numberOfStudies;
                this.numberOfParticipants = builder.numberOfParticipants;
                this.knownDataCount = builder.knownDataCount;
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            public List<Annotation> getNote() {
                return this.note;
            }

            public UnsignedInt getNumberOfStudies() {
                return this.numberOfStudies;
            }

            public UnsignedInt getNumberOfParticipants() {
                return this.numberOfParticipants;
            }

            public UnsignedInt getKnownDataCount() {
                return this.knownDataCount;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.description != null || !this.note.isEmpty() || this.numberOfStudies != null || this.numberOfParticipants != null || this.knownDataCount != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.note, "note", visitor, Annotation.class);
                        this.accept(this.numberOfStudies, "numberOfStudies", visitor);
                        this.accept(this.numberOfParticipants, "numberOfParticipants", visitor);
                        this.accept(this.knownDataCount, "knownDataCount", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SampleSize other = (SampleSize)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.note, other.note) && Objects.equals(this.numberOfStudies, other.numberOfStudies) && Objects.equals(this.numberOfParticipants, other.numberOfParticipants) && Objects.equals(this.knownDataCount, other.knownDataCount);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.note, this.numberOfStudies, this.numberOfParticipants, this.knownDataCount);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String description;
                private List<Annotation> note = new ArrayList<Annotation>();
                private UnsignedInt numberOfStudies;
                private UnsignedInt numberOfParticipants;
                private UnsignedInt knownDataCount;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                public Builder note(Annotation ... note) {
                    for (Annotation value : note) {
                        this.note.add(value);
                    }
                    return this;
                }

                public Builder note(Collection<Annotation> note) {
                    this.note = new ArrayList<Annotation>(note);
                    return this;
                }

                public Builder numberOfStudies(UnsignedInt numberOfStudies) {
                    this.numberOfStudies = numberOfStudies;
                    return this;
                }

                public Builder numberOfParticipants(UnsignedInt numberOfParticipants) {
                    this.numberOfParticipants = numberOfParticipants;
                    return this;
                }

                public Builder knownDataCount(UnsignedInt knownDataCount) {
                    this.knownDataCount = knownDataCount;
                    return this;
                }

                @Override
                public SampleSize build() {
                    SampleSize sampleSize = new SampleSize(this);
                    if (this.validating) {
                        this.validate(sampleSize);
                    }
                    return sampleSize;
                }

                protected void validate(SampleSize sampleSize) {
                    super.validate(sampleSize);
                    ValidationSupport.checkList(sampleSize.note, "note", Annotation.class);
                    ValidationSupport.requireValueOrChildren(sampleSize);
                }

                protected Builder from(SampleSize sampleSize) {
                    super.from(sampleSize);
                    this.description = sampleSize.description;
                    this.note.addAll(sampleSize.note);
                    this.numberOfStudies = sampleSize.numberOfStudies;
                    this.numberOfParticipants = sampleSize.numberOfParticipants;
                    this.knownDataCount = sampleSize.knownDataCount;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String description;
            private List<Annotation> note = new ArrayList<Annotation>();
            private CodeableConcept statisticType;
            private CodeableConcept category;
            private Quantity quantity;
            private UnsignedInt numberOfEvents;
            private UnsignedInt numberAffected;
            private SampleSize sampleSize;
            private List<AttributeEstimate> attributeEstimate = new ArrayList<AttributeEstimate>();
            private List<ModelCharacteristic> modelCharacteristic = new ArrayList<ModelCharacteristic>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            public Builder statisticType(CodeableConcept statisticType) {
                this.statisticType = statisticType;
                return this;
            }

            public Builder category(CodeableConcept category) {
                this.category = category;
                return this;
            }

            public Builder quantity(Quantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder numberOfEvents(UnsignedInt numberOfEvents) {
                this.numberOfEvents = numberOfEvents;
                return this;
            }

            public Builder numberAffected(UnsignedInt numberAffected) {
                this.numberAffected = numberAffected;
                return this;
            }

            public Builder sampleSize(SampleSize sampleSize) {
                this.sampleSize = sampleSize;
                return this;
            }

            public Builder attributeEstimate(AttributeEstimate ... attributeEstimate) {
                for (AttributeEstimate value : attributeEstimate) {
                    this.attributeEstimate.add(value);
                }
                return this;
            }

            public Builder attributeEstimate(Collection<AttributeEstimate> attributeEstimate) {
                this.attributeEstimate = new ArrayList<AttributeEstimate>(attributeEstimate);
                return this;
            }

            public Builder modelCharacteristic(ModelCharacteristic ... modelCharacteristic) {
                for (ModelCharacteristic value : modelCharacteristic) {
                    this.modelCharacteristic.add(value);
                }
                return this;
            }

            public Builder modelCharacteristic(Collection<ModelCharacteristic> modelCharacteristic) {
                this.modelCharacteristic = new ArrayList<ModelCharacteristic>(modelCharacteristic);
                return this;
            }

            @Override
            public Statistic build() {
                Statistic statistic = new Statistic(this);
                if (this.validating) {
                    this.validate(statistic);
                }
                return statistic;
            }

            protected void validate(Statistic statistic) {
                super.validate(statistic);
                ValidationSupport.checkList(statistic.note, "note", Annotation.class);
                ValidationSupport.checkList(statistic.attributeEstimate, "attributeEstimate", AttributeEstimate.class);
                ValidationSupport.checkList(statistic.modelCharacteristic, "modelCharacteristic", ModelCharacteristic.class);
                ValidationSupport.requireValueOrChildren(statistic);
            }

            protected Builder from(Statistic statistic) {
                super.from(statistic);
                this.description = statistic.description;
                this.note.addAll(statistic.note);
                this.statisticType = statistic.statisticType;
                this.category = statistic.category;
                this.quantity = statistic.quantity;
                this.numberOfEvents = statistic.numberOfEvents;
                this.numberAffected = statistic.numberAffected;
                this.sampleSize = statistic.sampleSize;
                this.attributeEstimate.addAll(statistic.attributeEstimate);
                this.modelCharacteristic.addAll(statistic.modelCharacteristic);
                return this;
            }
        }
    }

    public static class VariableDefinition
    extends BackboneElement {
        private final Markdown description;
        private final List<Annotation> note;
        @Summary
        @Binding(bindingName="EvidenceVariableRole", strength=BindingStrength.Value.EXTENSIBLE, description="The role that the assertion variable plays.", valueSet="http://hl7.org/fhir/ValueSet/variable-role")
        @Required
        private final CodeableConcept variableRole;
        @Summary
        @ReferenceTarget(value={"Group", "EvidenceVariable"})
        private final Reference observed;
        @ReferenceTarget(value={"Group", "EvidenceVariable"})
        private final Reference intended;
        @Binding(bindingName="EvidenceDirectness", strength=BindingStrength.Value.EXTENSIBLE, description="The quality of how direct the match is.", valueSet="http://hl7.org/fhir/ValueSet/directness")
        private final CodeableConcept directnessMatch;

        private VariableDefinition(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.note = Collections.unmodifiableList(builder.note);
            this.variableRole = builder.variableRole;
            this.observed = builder.observed;
            this.intended = builder.intended;
            this.directnessMatch = builder.directnessMatch;
        }

        public Markdown getDescription() {
            return this.description;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        public CodeableConcept getVariableRole() {
            return this.variableRole;
        }

        public Reference getObserved() {
            return this.observed;
        }

        public Reference getIntended() {
            return this.intended;
        }

        public CodeableConcept getDirectnessMatch() {
            return this.directnessMatch;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || !this.note.isEmpty() || this.variableRole != null || this.observed != null || this.intended != null || this.directnessMatch != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                    this.accept(this.variableRole, "variableRole", visitor);
                    this.accept(this.observed, "observed", visitor);
                    this.accept(this.intended, "intended", visitor);
                    this.accept(this.directnessMatch, "directnessMatch", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableDefinition other = (VariableDefinition)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.note, other.note) && Objects.equals(this.variableRole, other.variableRole) && Objects.equals(this.observed, other.observed) && Objects.equals(this.intended, other.intended) && Objects.equals(this.directnessMatch, other.directnessMatch);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.note, this.variableRole, this.observed, this.intended, this.directnessMatch);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Markdown description;
            private List<Annotation> note = new ArrayList<Annotation>();
            private CodeableConcept variableRole;
            private Reference observed;
            private Reference intended;
            private CodeableConcept directnessMatch;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            public Builder variableRole(CodeableConcept variableRole) {
                this.variableRole = variableRole;
                return this;
            }

            public Builder observed(Reference observed) {
                this.observed = observed;
                return this;
            }

            public Builder intended(Reference intended) {
                this.intended = intended;
                return this;
            }

            public Builder directnessMatch(CodeableConcept directnessMatch) {
                this.directnessMatch = directnessMatch;
                return this;
            }

            @Override
            public VariableDefinition build() {
                VariableDefinition variableDefinition = new VariableDefinition(this);
                if (this.validating) {
                    this.validate(variableDefinition);
                }
                return variableDefinition;
            }

            protected void validate(VariableDefinition variableDefinition) {
                super.validate(variableDefinition);
                ValidationSupport.checkList(variableDefinition.note, "note", Annotation.class);
                ValidationSupport.requireNonNull(variableDefinition.variableRole, "variableRole");
                ValidationSupport.checkReferenceType(variableDefinition.observed, "observed", "Group", "EvidenceVariable");
                ValidationSupport.checkReferenceType(variableDefinition.intended, "intended", "Group", "EvidenceVariable");
                ValidationSupport.requireValueOrChildren(variableDefinition);
            }

            protected Builder from(VariableDefinition variableDefinition) {
                super.from(variableDefinition);
                this.description = variableDefinition.description;
                this.note.addAll(variableDefinition.note);
                this.variableRole = variableDefinition.variableRole;
                this.observed = variableDefinition.observed;
                this.intended = variableDefinition.intended;
                this.directnessMatch = variableDefinition.directnessMatch;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String version;
        private org.linuxforhealth.fhir.model.type.String title;
        private Element citeAs;
        private PublicationStatus status;
        private DateTime date;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private Date approvalDate;
        private Date lastReviewDate;
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private Markdown description;
        private Markdown assertion;
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<VariableDefinition> variableDefinition = new ArrayList<VariableDefinition>();
        private CodeableConcept synthesisType;
        private CodeableConcept studyType;
        private List<Statistic> statistic = new ArrayList<Statistic>();
        private List<Certainty> certainty = new ArrayList<Certainty>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder title(String title) {
            this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
            return this;
        }

        public Builder title(org.linuxforhealth.fhir.model.type.String title) {
            this.title = title;
            return this;
        }

        public Builder citeAs(Element citeAs) {
            this.citeAs = citeAs;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder approvalDate(LocalDate approvalDate) {
            this.approvalDate = approvalDate == null ? null : Date.of(approvalDate);
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(LocalDate lastReviewDate) {
            this.lastReviewDate = lastReviewDate == null ? null : Date.of(lastReviewDate);
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder assertion(Markdown assertion) {
            this.assertion = assertion;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder variableDefinition(VariableDefinition ... variableDefinition) {
            for (VariableDefinition value : variableDefinition) {
                this.variableDefinition.add(value);
            }
            return this;
        }

        public Builder variableDefinition(Collection<VariableDefinition> variableDefinition) {
            this.variableDefinition = new ArrayList<VariableDefinition>(variableDefinition);
            return this;
        }

        public Builder synthesisType(CodeableConcept synthesisType) {
            this.synthesisType = synthesisType;
            return this;
        }

        public Builder studyType(CodeableConcept studyType) {
            this.studyType = studyType;
            return this;
        }

        public Builder statistic(Statistic ... statistic) {
            for (Statistic value : statistic) {
                this.statistic.add(value);
            }
            return this;
        }

        public Builder statistic(Collection<Statistic> statistic) {
            this.statistic = new ArrayList<Statistic>(statistic);
            return this;
        }

        public Builder certainty(Certainty ... certainty) {
            for (Certainty value : certainty) {
                this.certainty.add(value);
            }
            return this;
        }

        public Builder certainty(Collection<Certainty> certainty) {
            this.certainty = new ArrayList<Certainty>(certainty);
            return this;
        }

        @Override
        public Evidence build() {
            Evidence evidence = new Evidence(this);
            if (this.validating) {
                this.validate(evidence);
            }
            return evidence;
        }

        protected void validate(Evidence evidence) {
            super.validate(evidence);
            ValidationSupport.checkList(evidence.identifier, "identifier", Identifier.class);
            ValidationSupport.choiceElement(evidence.citeAs, "citeAs", Reference.class, Markdown.class);
            ValidationSupport.requireNonNull(evidence.status, "status");
            ValidationSupport.checkList(evidence.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(evidence.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(evidence.author, "author", ContactDetail.class);
            ValidationSupport.checkList(evidence.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(evidence.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(evidence.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(evidence.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.checkList(evidence.note, "note", Annotation.class);
            ValidationSupport.checkNonEmptyList(evidence.variableDefinition, "variableDefinition", VariableDefinition.class);
            ValidationSupport.checkList(evidence.statistic, "statistic", Statistic.class);
            ValidationSupport.checkList(evidence.certainty, "certainty", Certainty.class);
            ValidationSupport.checkReferenceType(evidence.citeAs, "citeAs", "Citation");
        }

        protected Builder from(Evidence evidence) {
            super.from(evidence);
            this.url = evidence.url;
            this.identifier.addAll(evidence.identifier);
            this.version = evidence.version;
            this.title = evidence.title;
            this.citeAs = evidence.citeAs;
            this.status = evidence.status;
            this.date = evidence.date;
            this.useContext.addAll(evidence.useContext);
            this.approvalDate = evidence.approvalDate;
            this.lastReviewDate = evidence.lastReviewDate;
            this.publisher = evidence.publisher;
            this.contact.addAll(evidence.contact);
            this.author.addAll(evidence.author);
            this.editor.addAll(evidence.editor);
            this.reviewer.addAll(evidence.reviewer);
            this.endorser.addAll(evidence.endorser);
            this.relatedArtifact.addAll(evidence.relatedArtifact);
            this.description = evidence.description;
            this.assertion = evidence.assertion;
            this.note.addAll(evidence.note);
            this.variableDefinition.addAll(evidence.variableDefinition);
            this.synthesisType = evidence.synthesisType;
            this.studyType = evidence.studyType;
            this.statistic.addAll(evidence.statistic);
            this.certainty.addAll(evidence.certainty);
            return this;
        }
    }
}

