/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.RelatedArtifact;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.ReportRelationshipType;
import org.linuxforhealth.fhir.model.type.code.SectionMode;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cnl-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/EvidenceReport"), @Constraint(id="evidenceReport-1", level="Warning", location="subject.characteristic.code", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/focus-characteristic-code", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/focus-characteristic-code', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/EvidenceReport", generated=true), @Constraint(id="evidenceReport-2", level="Warning", location="section.focus", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/evidence-report-section", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/evidence-report-section', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/EvidenceReport", generated=true), @Constraint(id="evidenceReport-3", level="Warning", location="section.orderedBy", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/list-order", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/list-order', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/EvidenceReport", generated=true), @Constraint(id="evidenceReport-4", level="Warning", location="section.entryClassifier", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/evidence-classifier-code", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/evidence-classifier-code', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/EvidenceReport", generated=true), @Constraint(id="evidenceReport-5", level="Warning", location="section.emptyReason", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/list-empty-reason", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/list-empty-reason', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/EvidenceReport", generated=true)})
public class EvidenceReport
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Identifier> relatedIdentifier;
    @ReferenceTarget(value={"Citation"})
    @Choice(value={Reference.class, Markdown.class})
    private final Element citeAs;
    @Binding(bindingName="EvidenceReportType", strength=BindingStrength.Value.EXAMPLE, description="The kind of report, such as grouping of classifiers, search results, or human-compiled expression.", valueSet="http://hl7.org/fhir/ValueSet/evidence-report-type")
    private final CodeableConcept type;
    private final List<Annotation> note;
    private final List<RelatedArtifact> relatedArtifact;
    @Summary
    @Required
    private final Subject subject;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    @Summary
    private final List<ContactDetail> endorser;
    private final List<RelatesTo> relatesTo;
    private final List<Section> section;

    private EvidenceReport(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.status = builder.status;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.relatedIdentifier = Collections.unmodifiableList(builder.relatedIdentifier);
        this.citeAs = builder.citeAs;
        this.type = builder.type;
        this.note = Collections.unmodifiableList(builder.note);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.subject = builder.subject;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatesTo = Collections.unmodifiableList(builder.relatesTo);
        this.section = Collections.unmodifiableList(builder.section);
    }

    public Uri getUrl() {
        return this.url;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Identifier> getRelatedIdentifier() {
        return this.relatedIdentifier;
    }

    public Element getCiteAs() {
        return this.citeAs;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatesTo> getRelatesTo() {
        return this.relatesTo;
    }

    public List<Section> getSection() {
        return this.section;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.status != null || !this.useContext.isEmpty() || !this.identifier.isEmpty() || !this.relatedIdentifier.isEmpty() || this.citeAs != null || this.type != null || !this.note.isEmpty() || !this.relatedArtifact.isEmpty() || this.subject != null || this.publisher != null || !this.contact.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatesTo.isEmpty() || !this.section.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.relatedIdentifier, "relatedIdentifier", visitor, Identifier.class);
                this.accept(this.citeAs, "citeAs", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatesTo, "relatesTo", visitor, RelatesTo.class);
                this.accept(this.section, "section", visitor, Section.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvidenceReport other = (EvidenceReport)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.status, other.status) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.relatedIdentifier, other.relatedIdentifier) && Objects.equals(this.citeAs, other.citeAs) && Objects.equals(this.type, other.type) && Objects.equals(this.note, other.note) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.subject, other.subject) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatesTo, other.relatesTo) && Objects.equals(this.section, other.section);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.status, this.useContext, this.identifier, this.relatedIdentifier, this.citeAs, this.type, this.note, this.relatedArtifact, this.subject, this.publisher, this.contact, this.author, this.editor, this.reviewer, this.endorser, this.relatesTo, this.section);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Section
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String title;
        @Binding(bindingName="ReportSectionType", strength=BindingStrength.Value.EXTENSIBLE, description="Evidence Report Section Type.", valueSet="http://hl7.org/fhir/ValueSet/evidence-report-section")
        private final CodeableConcept focus;
        private final Reference focusReference;
        @ReferenceTarget(value={"Person", "Device", "Group", "Organization"})
        private final List<Reference> author;
        private final Narrative text;
        @Binding(bindingName="SectionMode", strength=BindingStrength.Value.REQUIRED, description="The processing mode that applies to this section.", valueSet="http://hl7.org/fhir/ValueSet/list-mode|4.3.0")
        private final SectionMode mode;
        @Binding(bindingName="SectionEntryOrder", strength=BindingStrength.Value.PREFERRED, description="What order applies to the items in the entry.", valueSet="http://hl7.org/fhir/ValueSet/list-order")
        private final CodeableConcept orderedBy;
        @Binding(bindingName="EvidenceClassifier", strength=BindingStrength.Value.EXTENSIBLE, description="Commonly used classifiers for evidence sets.", valueSet="http://hl7.org/fhir/ValueSet/evidence-classifier-code")
        private final List<CodeableConcept> entryClassifier;
        private final List<Reference> entryReference;
        private final List<Quantity> entryQuantity;
        @Binding(bindingName="SectionEmptyReason", strength=BindingStrength.Value.PREFERRED, description="If a section is empty, why it is empty.", valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
        private final CodeableConcept emptyReason;
        private final List<Section> section;

        private Section(Builder builder) {
            super(builder);
            this.title = builder.title;
            this.focus = builder.focus;
            this.focusReference = builder.focusReference;
            this.author = Collections.unmodifiableList(builder.author);
            this.text = builder.text;
            this.mode = builder.mode;
            this.orderedBy = builder.orderedBy;
            this.entryClassifier = Collections.unmodifiableList(builder.entryClassifier);
            this.entryReference = Collections.unmodifiableList(builder.entryReference);
            this.entryQuantity = Collections.unmodifiableList(builder.entryQuantity);
            this.emptyReason = builder.emptyReason;
            this.section = Collections.unmodifiableList(builder.section);
        }

        public org.linuxforhealth.fhir.model.type.String getTitle() {
            return this.title;
        }

        public CodeableConcept getFocus() {
            return this.focus;
        }

        public Reference getFocusReference() {
            return this.focusReference;
        }

        public List<Reference> getAuthor() {
            return this.author;
        }

        public Narrative getText() {
            return this.text;
        }

        public SectionMode getMode() {
            return this.mode;
        }

        public CodeableConcept getOrderedBy() {
            return this.orderedBy;
        }

        public List<CodeableConcept> getEntryClassifier() {
            return this.entryClassifier;
        }

        public List<Reference> getEntryReference() {
            return this.entryReference;
        }

        public List<Quantity> getEntryQuantity() {
            return this.entryQuantity;
        }

        public CodeableConcept getEmptyReason() {
            return this.emptyReason;
        }

        public List<Section> getSection() {
            return this.section;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.title != null || this.focus != null || this.focusReference != null || !this.author.isEmpty() || this.text != null || this.mode != null || this.orderedBy != null || !this.entryClassifier.isEmpty() || !this.entryReference.isEmpty() || !this.entryQuantity.isEmpty() || this.emptyReason != null || !this.section.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.title, "title", visitor);
                    this.accept(this.focus, "focus", visitor);
                    this.accept(this.focusReference, "focusReference", visitor);
                    this.accept(this.author, "author", visitor, Reference.class);
                    this.accept(this.text, "text", visitor);
                    this.accept(this.mode, "mode", visitor);
                    this.accept(this.orderedBy, "orderedBy", visitor);
                    this.accept(this.entryClassifier, "entryClassifier", visitor, CodeableConcept.class);
                    this.accept(this.entryReference, "entryReference", visitor, Reference.class);
                    this.accept(this.entryQuantity, "entryQuantity", visitor, Quantity.class);
                    this.accept(this.emptyReason, "emptyReason", visitor);
                    this.accept(this.section, "section", visitor, Section.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Section other = (Section)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.title, other.title) && Objects.equals(this.focus, other.focus) && Objects.equals(this.focusReference, other.focusReference) && Objects.equals(this.author, other.author) && Objects.equals(this.text, other.text) && Objects.equals(this.mode, other.mode) && Objects.equals(this.orderedBy, other.orderedBy) && Objects.equals(this.entryClassifier, other.entryClassifier) && Objects.equals(this.entryReference, other.entryReference) && Objects.equals(this.entryQuantity, other.entryQuantity) && Objects.equals(this.emptyReason, other.emptyReason) && Objects.equals(this.section, other.section);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.title, this.focus, this.focusReference, this.author, this.text, this.mode, this.orderedBy, this.entryClassifier, this.entryReference, this.entryQuantity, this.emptyReason, this.section);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String title;
            private CodeableConcept focus;
            private Reference focusReference;
            private List<Reference> author = new ArrayList<Reference>();
            private Narrative text;
            private SectionMode mode;
            private CodeableConcept orderedBy;
            private List<CodeableConcept> entryClassifier = new ArrayList<CodeableConcept>();
            private List<Reference> entryReference = new ArrayList<Reference>();
            private List<Quantity> entryQuantity = new ArrayList<Quantity>();
            private CodeableConcept emptyReason;
            private List<Section> section = new ArrayList<Section>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder title(String title) {
                this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
                return this;
            }

            public Builder title(org.linuxforhealth.fhir.model.type.String title) {
                this.title = title;
                return this;
            }

            public Builder focus(CodeableConcept focus) {
                this.focus = focus;
                return this;
            }

            public Builder focusReference(Reference focusReference) {
                this.focusReference = focusReference;
                return this;
            }

            public Builder author(Reference ... author) {
                for (Reference value : author) {
                    this.author.add(value);
                }
                return this;
            }

            public Builder author(Collection<Reference> author) {
                this.author = new ArrayList<Reference>(author);
                return this;
            }

            public Builder text(Narrative text) {
                this.text = text;
                return this;
            }

            public Builder mode(SectionMode mode) {
                this.mode = mode;
                return this;
            }

            public Builder orderedBy(CodeableConcept orderedBy) {
                this.orderedBy = orderedBy;
                return this;
            }

            public Builder entryClassifier(CodeableConcept ... entryClassifier) {
                for (CodeableConcept value : entryClassifier) {
                    this.entryClassifier.add(value);
                }
                return this;
            }

            public Builder entryClassifier(Collection<CodeableConcept> entryClassifier) {
                this.entryClassifier = new ArrayList<CodeableConcept>(entryClassifier);
                return this;
            }

            public Builder entryReference(Reference ... entryReference) {
                for (Reference value : entryReference) {
                    this.entryReference.add(value);
                }
                return this;
            }

            public Builder entryReference(Collection<Reference> entryReference) {
                this.entryReference = new ArrayList<Reference>(entryReference);
                return this;
            }

            public Builder entryQuantity(Quantity ... entryQuantity) {
                for (Quantity value : entryQuantity) {
                    this.entryQuantity.add(value);
                }
                return this;
            }

            public Builder entryQuantity(Collection<Quantity> entryQuantity) {
                this.entryQuantity = new ArrayList<Quantity>(entryQuantity);
                return this;
            }

            public Builder emptyReason(CodeableConcept emptyReason) {
                this.emptyReason = emptyReason;
                return this;
            }

            public Builder section(Section ... section) {
                for (Section value : section) {
                    this.section.add(value);
                }
                return this;
            }

            public Builder section(Collection<Section> section) {
                this.section = new ArrayList<Section>(section);
                return this;
            }

            @Override
            public Section build() {
                Section section = new Section(this);
                if (this.validating) {
                    this.validate(section);
                }
                return section;
            }

            protected void validate(Section section) {
                super.validate(section);
                ValidationSupport.checkList(section.author, "author", Reference.class);
                ValidationSupport.checkList(section.entryClassifier, "entryClassifier", CodeableConcept.class);
                ValidationSupport.checkList(section.entryReference, "entryReference", Reference.class);
                ValidationSupport.checkList(section.entryQuantity, "entryQuantity", Quantity.class);
                ValidationSupport.checkList(section.section, "section", Section.class);
                ValidationSupport.checkReferenceType(section.author, "author", "Person", "Device", "Group", "Organization");
                ValidationSupport.requireValueOrChildren(section);
            }

            protected Builder from(Section section) {
                super.from(section);
                this.title = section.title;
                this.focus = section.focus;
                this.focusReference = section.focusReference;
                this.author.addAll(section.author);
                this.text = section.text;
                this.mode = section.mode;
                this.orderedBy = section.orderedBy;
                this.entryClassifier.addAll(section.entryClassifier);
                this.entryReference.addAll(section.entryReference);
                this.entryQuantity.addAll(section.entryQuantity);
                this.emptyReason = section.emptyReason;
                this.section.addAll(section.section);
                return this;
            }
        }
    }

    public static class RelatesTo
    extends BackboneElement {
        @Binding(bindingName="ReportRelationshipType", strength=BindingStrength.Value.REQUIRED, description="The type of relationship between reports.", valueSet="http://hl7.org/fhir/ValueSet/report-relation-type|4.3.0")
        @Required
        private final ReportRelationshipType code;
        @ReferenceTarget(value={"EvidenceReport"})
        @Choice(value={Identifier.class, Reference.class})
        @Required
        private final Element target;

        private RelatesTo(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.target = builder.target;
        }

        public ReportRelationshipType getCode() {
            return this.code;
        }

        public Element getTarget() {
            return this.target;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.target != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.target, "target", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelatesTo other = (RelatesTo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.target, other.target);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.target);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ReportRelationshipType code;
            private Element target;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(ReportRelationshipType code) {
                this.code = code;
                return this;
            }

            public Builder target(Element target) {
                this.target = target;
                return this;
            }

            @Override
            public RelatesTo build() {
                RelatesTo relatesTo = new RelatesTo(this);
                if (this.validating) {
                    this.validate(relatesTo);
                }
                return relatesTo;
            }

            protected void validate(RelatesTo relatesTo) {
                super.validate(relatesTo);
                ValidationSupport.requireNonNull(relatesTo.code, "code");
                ValidationSupport.requireChoiceElement(relatesTo.target, "target", Identifier.class, Reference.class);
                ValidationSupport.checkReferenceType(relatesTo.target, "target", "EvidenceReport");
                ValidationSupport.requireValueOrChildren(relatesTo);
            }

            protected Builder from(RelatesTo relatesTo) {
                super.from(relatesTo);
                this.code = relatesTo.code;
                this.target = relatesTo.target;
                return this;
            }
        }
    }

    public static class Subject
    extends BackboneElement {
        private final List<Characteristic> characteristic;
        private final List<Annotation> note;

        private Subject(Builder builder) {
            super(builder);
            this.characteristic = Collections.unmodifiableList(builder.characteristic);
            this.note = Collections.unmodifiableList(builder.note);
        }

        public List<Characteristic> getCharacteristic() {
            return this.characteristic;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.characteristic.isEmpty() || !this.note.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.characteristic, "characteristic", visitor, Characteristic.class);
                    this.accept(this.note, "note", visitor, Annotation.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subject other = (Subject)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.characteristic, other.characteristic) && Objects.equals(this.note, other.note);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.characteristic, this.note);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Characteristic
        extends BackboneElement {
            @Binding(bindingName="FocusCharacteristicCode", strength=BindingStrength.Value.EXTENSIBLE, description="Evidence focus characteristic code.", valueSet="http://hl7.org/fhir/ValueSet/focus-characteristic-code")
            @Required
            private final CodeableConcept code;
            @Choice(value={Reference.class, CodeableConcept.class, Boolean.class, Quantity.class, Range.class})
            @Required
            private final Element value;
            private final Boolean exclude;
            private final Period period;

            private Characteristic(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.value = builder.value;
                this.exclude = builder.exclude;
                this.period = builder.period;
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public Element getValue() {
                return this.value;
            }

            public Boolean getExclude() {
                return this.exclude;
            }

            public Period getPeriod() {
                return this.period;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.value != null || this.exclude != null || this.period != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.value, "value", visitor);
                        this.accept(this.exclude, "exclude", visitor);
                        this.accept(this.period, "period", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Characteristic other = (Characteristic)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.period, other.period);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value, this.exclude, this.period);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private Element value;
                private Boolean exclude;
                private Period period;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder value(java.lang.Boolean value) {
                    this.value = value == null ? null : Boolean.of(value);
                    return this;
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                public Builder exclude(java.lang.Boolean exclude) {
                    this.exclude = exclude == null ? null : Boolean.of(exclude);
                    return this;
                }

                public Builder exclude(Boolean exclude) {
                    this.exclude = exclude;
                    return this;
                }

                public Builder period(Period period) {
                    this.period = period;
                    return this;
                }

                @Override
                public Characteristic build() {
                    Characteristic characteristic = new Characteristic(this);
                    if (this.validating) {
                        this.validate(characteristic);
                    }
                    return characteristic;
                }

                protected void validate(Characteristic characteristic) {
                    super.validate(characteristic);
                    ValidationSupport.requireNonNull(characteristic.code, "code");
                    ValidationSupport.requireChoiceElement(characteristic.value, "value", Reference.class, CodeableConcept.class, Boolean.class, Quantity.class, Range.class);
                    ValidationSupport.requireValueOrChildren(characteristic);
                }

                protected Builder from(Characteristic characteristic) {
                    super.from(characteristic);
                    this.code = characteristic.code;
                    this.value = characteristic.value;
                    this.exclude = characteristic.exclude;
                    this.period = characteristic.period;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Characteristic> characteristic = new ArrayList<Characteristic>();
            private List<Annotation> note = new ArrayList<Annotation>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder characteristic(Characteristic ... characteristic) {
                for (Characteristic value : characteristic) {
                    this.characteristic.add(value);
                }
                return this;
            }

            public Builder characteristic(Collection<Characteristic> characteristic) {
                this.characteristic = new ArrayList<Characteristic>(characteristic);
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            @Override
            public Subject build() {
                Subject subject = new Subject(this);
                if (this.validating) {
                    this.validate(subject);
                }
                return subject;
            }

            protected void validate(Subject subject) {
                super.validate(subject);
                ValidationSupport.checkList(subject.characteristic, "characteristic", Characteristic.class);
                ValidationSupport.checkList(subject.note, "note", Annotation.class);
                ValidationSupport.requireValueOrChildren(subject);
            }

            protected Builder from(Subject subject) {
                super.from(subject);
                this.characteristic.addAll(subject.characteristic);
                this.note.addAll(subject.note);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private PublicationStatus status;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Identifier> relatedIdentifier = new ArrayList<Identifier>();
        private Element citeAs;
        private CodeableConcept type;
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private Subject subject;
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatesTo> relatesTo = new ArrayList<RelatesTo>();
        private List<Section> section = new ArrayList<Section>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder relatedIdentifier(Identifier ... relatedIdentifier) {
            for (Identifier value : relatedIdentifier) {
                this.relatedIdentifier.add(value);
            }
            return this;
        }

        public Builder relatedIdentifier(Collection<Identifier> relatedIdentifier) {
            this.relatedIdentifier = new ArrayList<Identifier>(relatedIdentifier);
            return this;
        }

        public Builder citeAs(Element citeAs) {
            this.citeAs = citeAs;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder subject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatesTo(RelatesTo ... relatesTo) {
            for (RelatesTo value : relatesTo) {
                this.relatesTo.add(value);
            }
            return this;
        }

        public Builder relatesTo(Collection<RelatesTo> relatesTo) {
            this.relatesTo = new ArrayList<RelatesTo>(relatesTo);
            return this;
        }

        public Builder section(Section ... section) {
            for (Section value : section) {
                this.section.add(value);
            }
            return this;
        }

        public Builder section(Collection<Section> section) {
            this.section = new ArrayList<Section>(section);
            return this;
        }

        @Override
        public EvidenceReport build() {
            EvidenceReport evidenceReport = new EvidenceReport(this);
            if (this.validating) {
                this.validate(evidenceReport);
            }
            return evidenceReport;
        }

        protected void validate(EvidenceReport evidenceReport) {
            super.validate(evidenceReport);
            ValidationSupport.requireNonNull(evidenceReport.status, "status");
            ValidationSupport.checkList(evidenceReport.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(evidenceReport.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(evidenceReport.relatedIdentifier, "relatedIdentifier", Identifier.class);
            ValidationSupport.choiceElement(evidenceReport.citeAs, "citeAs", Reference.class, Markdown.class);
            ValidationSupport.checkList(evidenceReport.note, "note", Annotation.class);
            ValidationSupport.checkList(evidenceReport.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.requireNonNull(evidenceReport.subject, "subject");
            ValidationSupport.checkList(evidenceReport.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(evidenceReport.author, "author", ContactDetail.class);
            ValidationSupport.checkList(evidenceReport.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(evidenceReport.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(evidenceReport.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(evidenceReport.relatesTo, "relatesTo", RelatesTo.class);
            ValidationSupport.checkList(evidenceReport.section, "section", Section.class);
            ValidationSupport.checkReferenceType(evidenceReport.citeAs, "citeAs", "Citation");
        }

        protected Builder from(EvidenceReport evidenceReport) {
            super.from(evidenceReport);
            this.url = evidenceReport.url;
            this.status = evidenceReport.status;
            this.useContext.addAll(evidenceReport.useContext);
            this.identifier.addAll(evidenceReport.identifier);
            this.relatedIdentifier.addAll(evidenceReport.relatedIdentifier);
            this.citeAs = evidenceReport.citeAs;
            this.type = evidenceReport.type;
            this.note.addAll(evidenceReport.note);
            this.relatedArtifact.addAll(evidenceReport.relatedArtifact);
            this.subject = evidenceReport.subject;
            this.publisher = evidenceReport.publisher;
            this.contact.addAll(evidenceReport.contact);
            this.author.addAll(evidenceReport.author);
            this.editor.addAll(evidenceReport.editor);
            this.reviewer.addAll(evidenceReport.reviewer);
            this.endorser.addAll(evidenceReport.endorser);
            this.relatesTo.addAll(evidenceReport.relatesTo);
            this.section.addAll(evidenceReport.section);
            return this;
        }
    }
}

