/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Expression;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.RelatedArtifact;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.CharacteristicCombination;
import org.linuxforhealth.fhir.model.type.code.EvidenceVariableHandling;
import org.linuxforhealth.fhir.model.type.code.GroupMeasure;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="cnl-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/EvidenceVariable")
public class EvidenceVariable
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String title;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String shortTitle;
    private final org.linuxforhealth.fhir.model.type.String subtitle;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final DateTime date;
    @Summary
    private final Markdown description;
    private final List<Annotation> note;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final Boolean actual;
    @Binding(bindingName="CharacteristicCombination", strength=BindingStrength.Value.REQUIRED, description="Logical grouping of characteristics.", valueSet="http://hl7.org/fhir/ValueSet/characteristic-combination|4.3.0")
    private final CharacteristicCombination characteristicCombination;
    @Summary
    private final List<Characteristic> characteristic;
    @Summary
    @Binding(bindingName="EvidenceVariableHandling", strength=BindingStrength.Value.REQUIRED, description="The handling of the variable in statistical analysis for exposures or outcomes (E.g. Dichotomous, Continuous, Descriptive).", valueSet="http://hl7.org/fhir/ValueSet/variable-handling|4.3.0")
    private final EvidenceVariableHandling handling;
    private final List<Category> category;

    private EvidenceVariable(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.shortTitle = builder.shortTitle;
        this.subtitle = builder.subtitle;
        this.status = builder.status;
        this.date = builder.date;
        this.description = builder.description;
        this.note = Collections.unmodifiableList(builder.note);
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.actual = builder.actual;
        this.characteristicCombination = builder.characteristicCombination;
        this.characteristic = Collections.unmodifiableList(builder.characteristic);
        this.handling = builder.handling;
        this.category = Collections.unmodifiableList(builder.category);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public org.linuxforhealth.fhir.model.type.String getTitle() {
        return this.title;
    }

    public org.linuxforhealth.fhir.model.type.String getShortTitle() {
        return this.shortTitle;
    }

    public org.linuxforhealth.fhir.model.type.String getSubtitle() {
        return this.subtitle;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public Boolean getActual() {
        return this.actual;
    }

    public CharacteristicCombination getCharacteristicCombination() {
        return this.characteristicCombination;
    }

    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public EvidenceVariableHandling getHandling() {
        return this.handling;
    }

    public List<Category> getCategory() {
        return this.category;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.shortTitle != null || this.subtitle != null || this.status != null || this.date != null || this.description != null || !this.note.isEmpty() || !this.useContext.isEmpty() || this.publisher != null || !this.contact.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || this.actual != null || this.characteristicCombination != null || !this.characteristic.isEmpty() || this.handling != null || !this.category.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.shortTitle, "shortTitle", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.actual, "actual", visitor);
                this.accept(this.characteristicCombination, "characteristicCombination", visitor);
                this.accept(this.characteristic, "characteristic", visitor, Characteristic.class);
                this.accept(this.handling, "handling", visitor);
                this.accept(this.category, "category", visitor, Category.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvidenceVariable other = (EvidenceVariable)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.shortTitle, other.shortTitle) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.status, other.status) && Objects.equals(this.date, other.date) && Objects.equals(this.description, other.description) && Objects.equals(this.note, other.note) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.actual, other.actual) && Objects.equals(this.characteristicCombination, other.characteristicCombination) && Objects.equals(this.characteristic, other.characteristic) && Objects.equals(this.handling, other.handling) && Objects.equals(this.category, other.category);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.shortTitle, this.subtitle, this.status, this.date, this.description, this.note, this.useContext, this.publisher, this.contact, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.actual, this.characteristicCombination, this.characteristic, this.handling, this.category);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Category
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String name;
        @Choice(value={CodeableConcept.class, Quantity.class, Range.class})
        private final Element value;

        private Category(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.value = builder.value;
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Category other = (Category)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String name;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Category build() {
                Category category = new Category(this);
                if (this.validating) {
                    this.validate(category);
                }
                return category;
            }

            protected void validate(Category category) {
                super.validate(category);
                ValidationSupport.choiceElement(category.value, "value", CodeableConcept.class, Quantity.class, Range.class);
                ValidationSupport.requireValueOrChildren(category);
            }

            protected Builder from(Category category) {
                super.from(category);
                this.name = category.name;
                this.value = category.value;
                return this;
            }
        }
    }

    public static class Characteristic
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String description;
        @Summary
        @ReferenceTarget(value={"Group", "EvidenceVariable"})
        @Choice(value={Reference.class, Canonical.class, CodeableConcept.class, Expression.class})
        @Required
        private final Element definition;
        @Binding(bindingName="CharacteristicMethod", strength=BindingStrength.Value.EXAMPLE, description="The method used to determine the characteristic(s) of the variable.", valueSet="http://hl7.org/fhir/ValueSet/characteristic-method")
        private final CodeableConcept method;
        @ReferenceTarget(value={"Device", "DeviceMetric"})
        private final Reference device;
        private final Boolean exclude;
        private final TimeFromStart timeFromStart;
        @Binding(bindingName="GroupMeasure", strength=BindingStrength.Value.REQUIRED, description="Possible group measure aggregates (E.g. Mean, Median).", valueSet="http://hl7.org/fhir/ValueSet/group-measure|4.3.0")
        private final GroupMeasure groupMeasure;

        private Characteristic(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.definition = builder.definition;
            this.method = builder.method;
            this.device = builder.device;
            this.exclude = builder.exclude;
            this.timeFromStart = builder.timeFromStart;
            this.groupMeasure = builder.groupMeasure;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public Element getDefinition() {
            return this.definition;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public Reference getDevice() {
            return this.device;
        }

        public Boolean getExclude() {
            return this.exclude;
        }

        public TimeFromStart getTimeFromStart() {
            return this.timeFromStart;
        }

        public GroupMeasure getGroupMeasure() {
            return this.groupMeasure;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.definition != null || this.method != null || this.device != null || this.exclude != null || this.timeFromStart != null || this.groupMeasure != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.definition, "definition", visitor);
                    this.accept(this.method, "method", visitor);
                    this.accept(this.device, "device", visitor);
                    this.accept(this.exclude, "exclude", visitor);
                    this.accept(this.timeFromStart, "timeFromStart", visitor);
                    this.accept(this.groupMeasure, "groupMeasure", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Characteristic other = (Characteristic)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.definition, other.definition) && Objects.equals(this.method, other.method) && Objects.equals(this.device, other.device) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.timeFromStart, other.timeFromStart) && Objects.equals(this.groupMeasure, other.groupMeasure);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.definition, this.method, this.device, this.exclude, this.timeFromStart, this.groupMeasure);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class TimeFromStart
        extends BackboneElement {
            private final org.linuxforhealth.fhir.model.type.String description;
            private final Quantity quantity;
            private final Range range;
            private final List<Annotation> note;

            private TimeFromStart(Builder builder) {
                super(builder);
                this.description = builder.description;
                this.quantity = builder.quantity;
                this.range = builder.range;
                this.note = Collections.unmodifiableList(builder.note);
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            public Quantity getQuantity() {
                return this.quantity;
            }

            public Range getRange() {
                return this.range;
            }

            public List<Annotation> getNote() {
                return this.note;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.description != null || this.quantity != null || this.range != null || !this.note.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.range, "range", visitor);
                        this.accept(this.note, "note", visitor, Annotation.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TimeFromStart other = (TimeFromStart)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.range, other.range) && Objects.equals(this.note, other.note);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.quantity, this.range, this.note);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String description;
                private Quantity quantity;
                private Range range;
                private List<Annotation> note = new ArrayList<Annotation>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                public Builder quantity(Quantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder range(Range range) {
                    this.range = range;
                    return this;
                }

                public Builder note(Annotation ... note) {
                    for (Annotation value : note) {
                        this.note.add(value);
                    }
                    return this;
                }

                public Builder note(Collection<Annotation> note) {
                    this.note = new ArrayList<Annotation>(note);
                    return this;
                }

                @Override
                public TimeFromStart build() {
                    TimeFromStart timeFromStart = new TimeFromStart(this);
                    if (this.validating) {
                        this.validate(timeFromStart);
                    }
                    return timeFromStart;
                }

                protected void validate(TimeFromStart timeFromStart) {
                    super.validate(timeFromStart);
                    ValidationSupport.checkList(timeFromStart.note, "note", Annotation.class);
                    ValidationSupport.requireValueOrChildren(timeFromStart);
                }

                protected Builder from(TimeFromStart timeFromStart) {
                    super.from(timeFromStart);
                    this.description = timeFromStart.description;
                    this.quantity = timeFromStart.quantity;
                    this.range = timeFromStart.range;
                    this.note.addAll(timeFromStart.note);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String description;
            private Element definition;
            private CodeableConcept method;
            private Reference device;
            private Boolean exclude;
            private TimeFromStart timeFromStart;
            private GroupMeasure groupMeasure;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder definition(Element definition) {
                this.definition = definition;
                return this;
            }

            public Builder method(CodeableConcept method) {
                this.method = method;
                return this;
            }

            public Builder device(Reference device) {
                this.device = device;
                return this;
            }

            public Builder exclude(java.lang.Boolean exclude) {
                this.exclude = exclude == null ? null : Boolean.of(exclude);
                return this;
            }

            public Builder exclude(Boolean exclude) {
                this.exclude = exclude;
                return this;
            }

            public Builder timeFromStart(TimeFromStart timeFromStart) {
                this.timeFromStart = timeFromStart;
                return this;
            }

            public Builder groupMeasure(GroupMeasure groupMeasure) {
                this.groupMeasure = groupMeasure;
                return this;
            }

            @Override
            public Characteristic build() {
                Characteristic characteristic = new Characteristic(this);
                if (this.validating) {
                    this.validate(characteristic);
                }
                return characteristic;
            }

            protected void validate(Characteristic characteristic) {
                super.validate(characteristic);
                ValidationSupport.requireChoiceElement(characteristic.definition, "definition", Reference.class, Canonical.class, CodeableConcept.class, Expression.class);
                ValidationSupport.checkReferenceType(characteristic.definition, "definition", "Group", "EvidenceVariable");
                ValidationSupport.checkReferenceType(characteristic.device, "device", "Device", "DeviceMetric");
                ValidationSupport.requireValueOrChildren(characteristic);
            }

            protected Builder from(Characteristic characteristic) {
                super.from(characteristic);
                this.description = characteristic.description;
                this.definition = characteristic.definition;
                this.method = characteristic.method;
                this.device = characteristic.device;
                this.exclude = characteristic.exclude;
                this.timeFromStart = characteristic.timeFromStart;
                this.groupMeasure = characteristic.groupMeasure;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String version;
        private org.linuxforhealth.fhir.model.type.String name;
        private org.linuxforhealth.fhir.model.type.String title;
        private org.linuxforhealth.fhir.model.type.String shortTitle;
        private org.linuxforhealth.fhir.model.type.String subtitle;
        private PublicationStatus status;
        private DateTime date;
        private Markdown description;
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private Boolean actual;
        private CharacteristicCombination characteristicCombination;
        private List<Characteristic> characteristic = new ArrayList<Characteristic>();
        private EvidenceVariableHandling handling;
        private List<Category> category = new ArrayList<Category>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
            return this;
        }

        public Builder title(org.linuxforhealth.fhir.model.type.String title) {
            this.title = title;
            return this;
        }

        public Builder shortTitle(String shortTitle) {
            this.shortTitle = shortTitle == null ? null : org.linuxforhealth.fhir.model.type.String.of(shortTitle);
            return this;
        }

        public Builder shortTitle(org.linuxforhealth.fhir.model.type.String shortTitle) {
            this.shortTitle = shortTitle;
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle == null ? null : org.linuxforhealth.fhir.model.type.String.of(subtitle);
            return this;
        }

        public Builder subtitle(org.linuxforhealth.fhir.model.type.String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder actual(java.lang.Boolean actual) {
            this.actual = actual == null ? null : Boolean.of(actual);
            return this;
        }

        public Builder actual(Boolean actual) {
            this.actual = actual;
            return this;
        }

        public Builder characteristicCombination(CharacteristicCombination characteristicCombination) {
            this.characteristicCombination = characteristicCombination;
            return this;
        }

        public Builder characteristic(Characteristic ... characteristic) {
            for (Characteristic value : characteristic) {
                this.characteristic.add(value);
            }
            return this;
        }

        public Builder characteristic(Collection<Characteristic> characteristic) {
            this.characteristic = new ArrayList<Characteristic>(characteristic);
            return this;
        }

        public Builder handling(EvidenceVariableHandling handling) {
            this.handling = handling;
            return this;
        }

        public Builder category(Category ... category) {
            for (Category value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<Category> category) {
            this.category = new ArrayList<Category>(category);
            return this;
        }

        @Override
        public EvidenceVariable build() {
            EvidenceVariable evidenceVariable = new EvidenceVariable(this);
            if (this.validating) {
                this.validate(evidenceVariable);
            }
            return evidenceVariable;
        }

        protected void validate(EvidenceVariable evidenceVariable) {
            super.validate(evidenceVariable);
            ValidationSupport.checkList(evidenceVariable.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(evidenceVariable.status, "status");
            ValidationSupport.checkList(evidenceVariable.note, "note", Annotation.class);
            ValidationSupport.checkList(evidenceVariable.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(evidenceVariable.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(evidenceVariable.author, "author", ContactDetail.class);
            ValidationSupport.checkList(evidenceVariable.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(evidenceVariable.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(evidenceVariable.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(evidenceVariable.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.checkList(evidenceVariable.characteristic, "characteristic", Characteristic.class);
            ValidationSupport.checkList(evidenceVariable.category, "category", Category.class);
        }

        protected Builder from(EvidenceVariable evidenceVariable) {
            super.from(evidenceVariable);
            this.url = evidenceVariable.url;
            this.identifier.addAll(evidenceVariable.identifier);
            this.version = evidenceVariable.version;
            this.name = evidenceVariable.name;
            this.title = evidenceVariable.title;
            this.shortTitle = evidenceVariable.shortTitle;
            this.subtitle = evidenceVariable.subtitle;
            this.status = evidenceVariable.status;
            this.date = evidenceVariable.date;
            this.description = evidenceVariable.description;
            this.note.addAll(evidenceVariable.note);
            this.useContext.addAll(evidenceVariable.useContext);
            this.publisher = evidenceVariable.publisher;
            this.contact.addAll(evidenceVariable.contact);
            this.author.addAll(evidenceVariable.author);
            this.editor.addAll(evidenceVariable.editor);
            this.reviewer.addAll(evidenceVariable.reviewer);
            this.endorser.addAll(evidenceVariable.endorser);
            this.relatedArtifact.addAll(evidenceVariable.relatedArtifact);
            this.actual = evidenceVariable.actual;
            this.characteristicCombination = evidenceVariable.characteristicCombination;
            this.characteristic.addAll(evidenceVariable.characteristic);
            this.handling = evidenceVariable.handling;
            this.category.addAll(evidenceVariable.category);
            return this;
        }
    }
}

