/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.ExampleScenarioActorType;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.ResourceTypeCode;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="esc-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/ExampleScenario"), @Constraint(id="exampleScenario-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/ExampleScenario", generated=true)})
public class ExampleScenario
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown copyright;
    private final Markdown purpose;
    private final List<Actor> actor;
    private final List<Instance> instance;
    private final List<Process> process;
    private final List<Canonical> workflow;

    private ExampleScenario(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.copyright = builder.copyright;
        this.purpose = builder.purpose;
        this.actor = Collections.unmodifiableList(builder.actor);
        this.instance = Collections.unmodifiableList(builder.instance);
        this.process = Collections.unmodifiableList(builder.process);
        this.workflow = Collections.unmodifiableList(builder.workflow);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public List<Actor> getActor() {
        return this.actor;
    }

    public List<Instance> getInstance() {
        return this.instance;
    }

    public List<Process> getProcess() {
        return this.process;
    }

    public List<Canonical> getWorkflow() {
        return this.workflow;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.copyright != null || this.purpose != null || !this.actor.isEmpty() || !this.instance.isEmpty() || !this.process.isEmpty() || !this.workflow.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.actor, "actor", visitor, Actor.class);
                this.accept(this.instance, "instance", visitor, Instance.class);
                this.accept(this.process, "process", visitor, Process.class);
                this.accept(this.workflow, "workflow", visitor, Canonical.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExampleScenario other = (ExampleScenario)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.actor, other.actor) && Objects.equals(this.instance, other.instance) && Objects.equals(this.process, other.process) && Objects.equals(this.workflow, other.workflow);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.status, this.experimental, this.date, this.publisher, this.contact, this.useContext, this.jurisdiction, this.copyright, this.purpose, this.actor, this.instance, this.process, this.workflow);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Process
    extends BackboneElement {
        @Summary
        @Required
        private final org.linuxforhealth.fhir.model.type.String title;
        private final Markdown description;
        private final Markdown preConditions;
        private final Markdown postConditions;
        private final List<Step> step;

        private Process(Builder builder) {
            super(builder);
            this.title = builder.title;
            this.description = builder.description;
            this.preConditions = builder.preConditions;
            this.postConditions = builder.postConditions;
            this.step = Collections.unmodifiableList(builder.step);
        }

        public org.linuxforhealth.fhir.model.type.String getTitle() {
            return this.title;
        }

        public Markdown getDescription() {
            return this.description;
        }

        public Markdown getPreConditions() {
            return this.preConditions;
        }

        public Markdown getPostConditions() {
            return this.postConditions;
        }

        public List<Step> getStep() {
            return this.step;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.title != null || this.description != null || this.preConditions != null || this.postConditions != null || !this.step.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.title, "title", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.preConditions, "preConditions", visitor);
                    this.accept(this.postConditions, "postConditions", visitor);
                    this.accept(this.step, "step", visitor, Step.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Process other = (Process)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.preConditions, other.preConditions) && Objects.equals(this.postConditions, other.postConditions) && Objects.equals(this.step, other.step);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.title, this.description, this.preConditions, this.postConditions, this.step);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Step
        extends BackboneElement {
            private final List<Process> process;
            private final Boolean pause;
            private final Operation operation;
            private final List<Alternative> alternative;

            private Step(Builder builder) {
                super(builder);
                this.process = Collections.unmodifiableList(builder.process);
                this.pause = builder.pause;
                this.operation = builder.operation;
                this.alternative = Collections.unmodifiableList(builder.alternative);
            }

            public List<Process> getProcess() {
                return this.process;
            }

            public Boolean getPause() {
                return this.pause;
            }

            public Operation getOperation() {
                return this.operation;
            }

            public List<Alternative> getAlternative() {
                return this.alternative;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || !this.process.isEmpty() || this.pause != null || this.operation != null || !this.alternative.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.process, "process", visitor, Process.class);
                        this.accept(this.pause, "pause", visitor);
                        this.accept(this.operation, "operation", visitor);
                        this.accept(this.alternative, "alternative", visitor, Alternative.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Step other = (Step)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.process, other.process) && Objects.equals(this.pause, other.pause) && Objects.equals(this.operation, other.operation) && Objects.equals(this.alternative, other.alternative);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.process, this.pause, this.operation, this.alternative);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Alternative
            extends BackboneElement {
                @Required
                private final org.linuxforhealth.fhir.model.type.String title;
                private final Markdown description;
                private final List<Step> step;

                private Alternative(Builder builder) {
                    super(builder);
                    this.title = builder.title;
                    this.description = builder.description;
                    this.step = Collections.unmodifiableList(builder.step);
                }

                public org.linuxforhealth.fhir.model.type.String getTitle() {
                    return this.title;
                }

                public Markdown getDescription() {
                    return this.description;
                }

                public List<Step> getStep() {
                    return this.step;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.title != null || this.description != null || !this.step.isEmpty();
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.title, "title", visitor);
                            this.accept(this.description, "description", visitor);
                            this.accept(this.step, "step", visitor, Step.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Alternative other = (Alternative)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.step, other.step);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.title, this.description, this.step);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private org.linuxforhealth.fhir.model.type.String title;
                    private Markdown description;
                    private List<Step> step = new ArrayList<Step>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder title(String title) {
                        this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
                        return this;
                    }

                    public Builder title(org.linuxforhealth.fhir.model.type.String title) {
                        this.title = title;
                        return this;
                    }

                    public Builder description(Markdown description) {
                        this.description = description;
                        return this;
                    }

                    public Builder step(Step ... step) {
                        for (Step value : step) {
                            this.step.add(value);
                        }
                        return this;
                    }

                    public Builder step(Collection<Step> step) {
                        this.step = new ArrayList<Step>(step);
                        return this;
                    }

                    @Override
                    public Alternative build() {
                        Alternative alternative = new Alternative(this);
                        if (this.validating) {
                            this.validate(alternative);
                        }
                        return alternative;
                    }

                    protected void validate(Alternative alternative) {
                        super.validate(alternative);
                        ValidationSupport.requireNonNull(alternative.title, "title");
                        ValidationSupport.checkList(alternative.step, "step", Step.class);
                        ValidationSupport.requireValueOrChildren(alternative);
                    }

                    protected Builder from(Alternative alternative) {
                        super.from(alternative);
                        this.title = alternative.title;
                        this.description = alternative.description;
                        this.step.addAll(alternative.step);
                        return this;
                    }
                }
            }

            public static class Operation
            extends BackboneElement {
                @Required
                private final org.linuxforhealth.fhir.model.type.String number;
                private final org.linuxforhealth.fhir.model.type.String type;
                private final org.linuxforhealth.fhir.model.type.String name;
                private final org.linuxforhealth.fhir.model.type.String initiator;
                private final org.linuxforhealth.fhir.model.type.String receiver;
                private final Markdown description;
                private final Boolean initiatorActive;
                private final Boolean receiverActive;
                private final Instance.ContainedInstance request;
                private final Instance.ContainedInstance response;

                private Operation(Builder builder) {
                    super(builder);
                    this.number = builder.number;
                    this.type = builder.type;
                    this.name = builder.name;
                    this.initiator = builder.initiator;
                    this.receiver = builder.receiver;
                    this.description = builder.description;
                    this.initiatorActive = builder.initiatorActive;
                    this.receiverActive = builder.receiverActive;
                    this.request = builder.request;
                    this.response = builder.response;
                }

                public org.linuxforhealth.fhir.model.type.String getNumber() {
                    return this.number;
                }

                public org.linuxforhealth.fhir.model.type.String getType() {
                    return this.type;
                }

                public org.linuxforhealth.fhir.model.type.String getName() {
                    return this.name;
                }

                public org.linuxforhealth.fhir.model.type.String getInitiator() {
                    return this.initiator;
                }

                public org.linuxforhealth.fhir.model.type.String getReceiver() {
                    return this.receiver;
                }

                public Markdown getDescription() {
                    return this.description;
                }

                public Boolean getInitiatorActive() {
                    return this.initiatorActive;
                }

                public Boolean getReceiverActive() {
                    return this.receiverActive;
                }

                public Instance.ContainedInstance getRequest() {
                    return this.request;
                }

                public Instance.ContainedInstance getResponse() {
                    return this.response;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.number != null || this.type != null || this.name != null || this.initiator != null || this.receiver != null || this.description != null || this.initiatorActive != null || this.receiverActive != null || this.request != null || this.response != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.number, "number", visitor);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.name, "name", visitor);
                            this.accept(this.initiator, "initiator", visitor);
                            this.accept(this.receiver, "receiver", visitor);
                            this.accept(this.description, "description", visitor);
                            this.accept(this.initiatorActive, "initiatorActive", visitor);
                            this.accept(this.receiverActive, "receiverActive", visitor);
                            this.accept(this.request, "request", visitor);
                            this.accept(this.response, "response", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Operation other = (Operation)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.number, other.number) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.initiator, other.initiator) && Objects.equals(this.receiver, other.receiver) && Objects.equals(this.description, other.description) && Objects.equals(this.initiatorActive, other.initiatorActive) && Objects.equals(this.receiverActive, other.receiverActive) && Objects.equals(this.request, other.request) && Objects.equals(this.response, other.response);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.number, this.type, this.name, this.initiator, this.receiver, this.description, this.initiatorActive, this.receiverActive, this.request, this.response);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private org.linuxforhealth.fhir.model.type.String number;
                    private org.linuxforhealth.fhir.model.type.String type;
                    private org.linuxforhealth.fhir.model.type.String name;
                    private org.linuxforhealth.fhir.model.type.String initiator;
                    private org.linuxforhealth.fhir.model.type.String receiver;
                    private Markdown description;
                    private Boolean initiatorActive;
                    private Boolean receiverActive;
                    private Instance.ContainedInstance request;
                    private Instance.ContainedInstance response;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder number(String number) {
                        this.number = number == null ? null : org.linuxforhealth.fhir.model.type.String.of(number);
                        return this;
                    }

                    public Builder number(org.linuxforhealth.fhir.model.type.String number) {
                        this.number = number;
                        return this;
                    }

                    public Builder type(String type) {
                        this.type = type == null ? null : org.linuxforhealth.fhir.model.type.String.of(type);
                        return this;
                    }

                    public Builder type(org.linuxforhealth.fhir.model.type.String type) {
                        this.type = type;
                        return this;
                    }

                    public Builder name(String name) {
                        this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                        return this;
                    }

                    public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder initiator(String initiator) {
                        this.initiator = initiator == null ? null : org.linuxforhealth.fhir.model.type.String.of(initiator);
                        return this;
                    }

                    public Builder initiator(org.linuxforhealth.fhir.model.type.String initiator) {
                        this.initiator = initiator;
                        return this;
                    }

                    public Builder receiver(String receiver) {
                        this.receiver = receiver == null ? null : org.linuxforhealth.fhir.model.type.String.of(receiver);
                        return this;
                    }

                    public Builder receiver(org.linuxforhealth.fhir.model.type.String receiver) {
                        this.receiver = receiver;
                        return this;
                    }

                    public Builder description(Markdown description) {
                        this.description = description;
                        return this;
                    }

                    public Builder initiatorActive(java.lang.Boolean initiatorActive) {
                        this.initiatorActive = initiatorActive == null ? null : Boolean.of(initiatorActive);
                        return this;
                    }

                    public Builder initiatorActive(Boolean initiatorActive) {
                        this.initiatorActive = initiatorActive;
                        return this;
                    }

                    public Builder receiverActive(java.lang.Boolean receiverActive) {
                        this.receiverActive = receiverActive == null ? null : Boolean.of(receiverActive);
                        return this;
                    }

                    public Builder receiverActive(Boolean receiverActive) {
                        this.receiverActive = receiverActive;
                        return this;
                    }

                    public Builder request(Instance.ContainedInstance request) {
                        this.request = request;
                        return this;
                    }

                    public Builder response(Instance.ContainedInstance response) {
                        this.response = response;
                        return this;
                    }

                    @Override
                    public Operation build() {
                        Operation operation = new Operation(this);
                        if (this.validating) {
                            this.validate(operation);
                        }
                        return operation;
                    }

                    protected void validate(Operation operation) {
                        super.validate(operation);
                        ValidationSupport.requireNonNull(operation.number, "number");
                        ValidationSupport.requireValueOrChildren(operation);
                    }

                    protected Builder from(Operation operation) {
                        super.from(operation);
                        this.number = operation.number;
                        this.type = operation.type;
                        this.name = operation.name;
                        this.initiator = operation.initiator;
                        this.receiver = operation.receiver;
                        this.description = operation.description;
                        this.initiatorActive = operation.initiatorActive;
                        this.receiverActive = operation.receiverActive;
                        this.request = operation.request;
                        this.response = operation.response;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private List<Process> process = new ArrayList<Process>();
                private Boolean pause;
                private Operation operation;
                private List<Alternative> alternative = new ArrayList<Alternative>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder process(Process ... process) {
                    for (Process value : process) {
                        this.process.add(value);
                    }
                    return this;
                }

                public Builder process(Collection<Process> process) {
                    this.process = new ArrayList<Process>(process);
                    return this;
                }

                public Builder pause(java.lang.Boolean pause) {
                    this.pause = pause == null ? null : Boolean.of(pause);
                    return this;
                }

                public Builder pause(Boolean pause) {
                    this.pause = pause;
                    return this;
                }

                public Builder operation(Operation operation) {
                    this.operation = operation;
                    return this;
                }

                public Builder alternative(Alternative ... alternative) {
                    for (Alternative value : alternative) {
                        this.alternative.add(value);
                    }
                    return this;
                }

                public Builder alternative(Collection<Alternative> alternative) {
                    this.alternative = new ArrayList<Alternative>(alternative);
                    return this;
                }

                @Override
                public Step build() {
                    Step step = new Step(this);
                    if (this.validating) {
                        this.validate(step);
                    }
                    return step;
                }

                protected void validate(Step step) {
                    super.validate(step);
                    ValidationSupport.checkList(step.process, "process", Process.class);
                    ValidationSupport.checkList(step.alternative, "alternative", Alternative.class);
                    ValidationSupport.requireValueOrChildren(step);
                }

                protected Builder from(Step step) {
                    super.from(step);
                    this.process.addAll(step.process);
                    this.pause = step.pause;
                    this.operation = step.operation;
                    this.alternative.addAll(step.alternative);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String title;
            private Markdown description;
            private Markdown preConditions;
            private Markdown postConditions;
            private List<Step> step = new ArrayList<Step>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder title(String title) {
                this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
                return this;
            }

            public Builder title(org.linuxforhealth.fhir.model.type.String title) {
                this.title = title;
                return this;
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            public Builder preConditions(Markdown preConditions) {
                this.preConditions = preConditions;
                return this;
            }

            public Builder postConditions(Markdown postConditions) {
                this.postConditions = postConditions;
                return this;
            }

            public Builder step(Step ... step) {
                for (Step value : step) {
                    this.step.add(value);
                }
                return this;
            }

            public Builder step(Collection<Step> step) {
                this.step = new ArrayList<Step>(step);
                return this;
            }

            @Override
            public Process build() {
                Process process = new Process(this);
                if (this.validating) {
                    this.validate(process);
                }
                return process;
            }

            protected void validate(Process process) {
                super.validate(process);
                ValidationSupport.requireNonNull(process.title, "title");
                ValidationSupport.checkList(process.step, "step", Step.class);
                ValidationSupport.requireValueOrChildren(process);
            }

            protected Builder from(Process process) {
                super.from(process);
                this.title = process.title;
                this.description = process.description;
                this.preConditions = process.preConditions;
                this.postConditions = process.postConditions;
                this.step.addAll(process.step);
                return this;
            }
        }
    }

    public static class Instance
    extends BackboneElement {
        @Required
        private final org.linuxforhealth.fhir.model.type.String resourceId;
        @Binding(bindingName="FHIRResourceType", strength=BindingStrength.Value.REQUIRED, description="The type of resource.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.3.0")
        @Required
        private final ResourceTypeCode resourceType;
        private final org.linuxforhealth.fhir.model.type.String name;
        private final Markdown description;
        private final List<Version> version;
        private final List<ContainedInstance> containedInstance;

        private Instance(Builder builder) {
            super(builder);
            this.resourceId = builder.resourceId;
            this.resourceType = builder.resourceType;
            this.name = builder.name;
            this.description = builder.description;
            this.version = Collections.unmodifiableList(builder.version);
            this.containedInstance = Collections.unmodifiableList(builder.containedInstance);
        }

        public org.linuxforhealth.fhir.model.type.String getResourceId() {
            return this.resourceId;
        }

        public ResourceTypeCode getResourceType() {
            return this.resourceType;
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public Markdown getDescription() {
            return this.description;
        }

        public List<Version> getVersion() {
            return this.version;
        }

        public List<ContainedInstance> getContainedInstance() {
            return this.containedInstance;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.resourceId != null || this.resourceType != null || this.name != null || this.description != null || !this.version.isEmpty() || !this.containedInstance.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.resourceId, "resourceId", visitor);
                    this.accept(this.resourceType, "resourceType", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.version, "version", visitor, Version.class);
                    this.accept(this.containedInstance, "containedInstance", visitor, ContainedInstance.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Instance other = (Instance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.version, other.version) && Objects.equals(this.containedInstance, other.containedInstance);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.resourceId, this.resourceType, this.name, this.description, this.version, this.containedInstance);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class ContainedInstance
        extends BackboneElement {
            @Required
            private final org.linuxforhealth.fhir.model.type.String resourceId;
            private final org.linuxforhealth.fhir.model.type.String versionId;

            private ContainedInstance(Builder builder) {
                super(builder);
                this.resourceId = builder.resourceId;
                this.versionId = builder.versionId;
            }

            public org.linuxforhealth.fhir.model.type.String getResourceId() {
                return this.resourceId;
            }

            public org.linuxforhealth.fhir.model.type.String getVersionId() {
                return this.versionId;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.resourceId != null || this.versionId != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.resourceId, "resourceId", visitor);
                        this.accept(this.versionId, "versionId", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ContainedInstance other = (ContainedInstance)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.versionId, other.versionId);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.resourceId, this.versionId);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String resourceId;
                private org.linuxforhealth.fhir.model.type.String versionId;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder resourceId(String resourceId) {
                    this.resourceId = resourceId == null ? null : org.linuxforhealth.fhir.model.type.String.of(resourceId);
                    return this;
                }

                public Builder resourceId(org.linuxforhealth.fhir.model.type.String resourceId) {
                    this.resourceId = resourceId;
                    return this;
                }

                public Builder versionId(String versionId) {
                    this.versionId = versionId == null ? null : org.linuxforhealth.fhir.model.type.String.of(versionId);
                    return this;
                }

                public Builder versionId(org.linuxforhealth.fhir.model.type.String versionId) {
                    this.versionId = versionId;
                    return this;
                }

                @Override
                public ContainedInstance build() {
                    ContainedInstance containedInstance = new ContainedInstance(this);
                    if (this.validating) {
                        this.validate(containedInstance);
                    }
                    return containedInstance;
                }

                protected void validate(ContainedInstance containedInstance) {
                    super.validate(containedInstance);
                    ValidationSupport.requireNonNull(containedInstance.resourceId, "resourceId");
                    ValidationSupport.requireValueOrChildren(containedInstance);
                }

                protected Builder from(ContainedInstance containedInstance) {
                    super.from(containedInstance);
                    this.resourceId = containedInstance.resourceId;
                    this.versionId = containedInstance.versionId;
                    return this;
                }
            }
        }

        public static class Version
        extends BackboneElement {
            @Required
            private final org.linuxforhealth.fhir.model.type.String versionId;
            @Required
            private final Markdown description;

            private Version(Builder builder) {
                super(builder);
                this.versionId = builder.versionId;
                this.description = builder.description;
            }

            public org.linuxforhealth.fhir.model.type.String getVersionId() {
                return this.versionId;
            }

            public Markdown getDescription() {
                return this.description;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.versionId != null || this.description != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.versionId, "versionId", visitor);
                        this.accept(this.description, "description", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Version other = (Version)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.versionId, other.versionId) && Objects.equals(this.description, other.description);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.versionId, this.description);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String versionId;
                private Markdown description;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder versionId(String versionId) {
                    this.versionId = versionId == null ? null : org.linuxforhealth.fhir.model.type.String.of(versionId);
                    return this;
                }

                public Builder versionId(org.linuxforhealth.fhir.model.type.String versionId) {
                    this.versionId = versionId;
                    return this;
                }

                public Builder description(Markdown description) {
                    this.description = description;
                    return this;
                }

                @Override
                public Version build() {
                    Version version = new Version(this);
                    if (this.validating) {
                        this.validate(version);
                    }
                    return version;
                }

                protected void validate(Version version) {
                    super.validate(version);
                    ValidationSupport.requireNonNull(version.versionId, "versionId");
                    ValidationSupport.requireNonNull(version.description, "description");
                    ValidationSupport.requireValueOrChildren(version);
                }

                protected Builder from(Version version) {
                    super.from(version);
                    this.versionId = version.versionId;
                    this.description = version.description;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String resourceId;
            private ResourceTypeCode resourceType;
            private org.linuxforhealth.fhir.model.type.String name;
            private Markdown description;
            private List<Version> version = new ArrayList<Version>();
            private List<ContainedInstance> containedInstance = new ArrayList<ContainedInstance>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder resourceId(String resourceId) {
                this.resourceId = resourceId == null ? null : org.linuxforhealth.fhir.model.type.String.of(resourceId);
                return this;
            }

            public Builder resourceId(org.linuxforhealth.fhir.model.type.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder resourceType(ResourceTypeCode resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            public Builder version(Version ... version) {
                for (Version value : version) {
                    this.version.add(value);
                }
                return this;
            }

            public Builder version(Collection<Version> version) {
                this.version = new ArrayList<Version>(version);
                return this;
            }

            public Builder containedInstance(ContainedInstance ... containedInstance) {
                for (ContainedInstance value : containedInstance) {
                    this.containedInstance.add(value);
                }
                return this;
            }

            public Builder containedInstance(Collection<ContainedInstance> containedInstance) {
                this.containedInstance = new ArrayList<ContainedInstance>(containedInstance);
                return this;
            }

            @Override
            public Instance build() {
                Instance instance = new Instance(this);
                if (this.validating) {
                    this.validate(instance);
                }
                return instance;
            }

            protected void validate(Instance instance) {
                super.validate(instance);
                ValidationSupport.requireNonNull(instance.resourceId, "resourceId");
                ValidationSupport.requireNonNull(instance.resourceType, "resourceType");
                ValidationSupport.checkList(instance.version, "version", Version.class);
                ValidationSupport.checkList(instance.containedInstance, "containedInstance", ContainedInstance.class);
                ValidationSupport.requireValueOrChildren(instance);
            }

            protected Builder from(Instance instance) {
                super.from(instance);
                this.resourceId = instance.resourceId;
                this.resourceType = instance.resourceType;
                this.name = instance.name;
                this.description = instance.description;
                this.version.addAll(instance.version);
                this.containedInstance.addAll(instance.containedInstance);
                return this;
            }
        }
    }

    public static class Actor
    extends BackboneElement {
        @Required
        private final org.linuxforhealth.fhir.model.type.String actorId;
        @Binding(bindingName="ExampleScenarioActorType", strength=BindingStrength.Value.REQUIRED, description="The type of actor - system or human.", valueSet="http://hl7.org/fhir/ValueSet/examplescenario-actor-type|4.3.0")
        @Required
        private final ExampleScenarioActorType type;
        private final org.linuxforhealth.fhir.model.type.String name;
        private final Markdown description;

        private Actor(Builder builder) {
            super(builder);
            this.actorId = builder.actorId;
            this.type = builder.type;
            this.name = builder.name;
            this.description = builder.description;
        }

        public org.linuxforhealth.fhir.model.type.String getActorId() {
            return this.actorId;
        }

        public ExampleScenarioActorType getType() {
            return this.type;
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public Markdown getDescription() {
            return this.description;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.actorId != null || this.type != null || this.name != null || this.description != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.actorId, "actorId", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.description, "description", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Actor other = (Actor)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.actorId, other.actorId) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.actorId, this.type, this.name, this.description);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String actorId;
            private ExampleScenarioActorType type;
            private org.linuxforhealth.fhir.model.type.String name;
            private Markdown description;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder actorId(String actorId) {
                this.actorId = actorId == null ? null : org.linuxforhealth.fhir.model.type.String.of(actorId);
                return this;
            }

            public Builder actorId(org.linuxforhealth.fhir.model.type.String actorId) {
                this.actorId = actorId;
                return this;
            }

            public Builder type(ExampleScenarioActorType type) {
                this.type = type;
                return this;
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            @Override
            public Actor build() {
                Actor actor = new Actor(this);
                if (this.validating) {
                    this.validate(actor);
                }
                return actor;
            }

            protected void validate(Actor actor) {
                super.validate(actor);
                ValidationSupport.requireNonNull(actor.actorId, "actorId");
                ValidationSupport.requireNonNull(actor.type, "type");
                ValidationSupport.requireValueOrChildren(actor);
            }

            protected Builder from(Actor actor) {
                super.from(actor);
                this.actorId = actor.actorId;
                this.type = actor.type;
                this.name = actor.name;
                this.description = actor.description;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String version;
        private org.linuxforhealth.fhir.model.type.String name;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown copyright;
        private Markdown purpose;
        private List<Actor> actor = new ArrayList<Actor>();
        private List<Instance> instance = new ArrayList<Instance>();
        private List<Process> process = new ArrayList<Process>();
        private List<Canonical> workflow = new ArrayList<Canonical>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder actor(Actor ... actor) {
            for (Actor value : actor) {
                this.actor.add(value);
            }
            return this;
        }

        public Builder actor(Collection<Actor> actor) {
            this.actor = new ArrayList<Actor>(actor);
            return this;
        }

        public Builder instance(Instance ... instance) {
            for (Instance value : instance) {
                this.instance.add(value);
            }
            return this;
        }

        public Builder instance(Collection<Instance> instance) {
            this.instance = new ArrayList<Instance>(instance);
            return this;
        }

        public Builder process(Process ... process) {
            for (Process value : process) {
                this.process.add(value);
            }
            return this;
        }

        public Builder process(Collection<Process> process) {
            this.process = new ArrayList<Process>(process);
            return this;
        }

        public Builder workflow(Canonical ... workflow) {
            for (Canonical value : workflow) {
                this.workflow.add(value);
            }
            return this;
        }

        public Builder workflow(Collection<Canonical> workflow) {
            this.workflow = new ArrayList<Canonical>(workflow);
            return this;
        }

        @Override
        public ExampleScenario build() {
            ExampleScenario exampleScenario = new ExampleScenario(this);
            if (this.validating) {
                this.validate(exampleScenario);
            }
            return exampleScenario;
        }

        protected void validate(ExampleScenario exampleScenario) {
            super.validate(exampleScenario);
            ValidationSupport.checkList(exampleScenario.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(exampleScenario.status, "status");
            ValidationSupport.checkList(exampleScenario.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(exampleScenario.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(exampleScenario.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(exampleScenario.actor, "actor", Actor.class);
            ValidationSupport.checkList(exampleScenario.instance, "instance", Instance.class);
            ValidationSupport.checkList(exampleScenario.process, "process", Process.class);
            ValidationSupport.checkList(exampleScenario.workflow, "workflow", Canonical.class);
        }

        protected Builder from(ExampleScenario exampleScenario) {
            super.from(exampleScenario);
            this.url = exampleScenario.url;
            this.identifier.addAll(exampleScenario.identifier);
            this.version = exampleScenario.version;
            this.name = exampleScenario.name;
            this.status = exampleScenario.status;
            this.experimental = exampleScenario.experimental;
            this.date = exampleScenario.date;
            this.publisher = exampleScenario.publisher;
            this.contact.addAll(exampleScenario.contact);
            this.useContext.addAll(exampleScenario.useContext);
            this.jurisdiction.addAll(exampleScenario.jurisdiction);
            this.copyright = exampleScenario.copyright;
            this.purpose = exampleScenario.purpose;
            this.actor.addAll(exampleScenario.actor);
            this.instance.addAll(exampleScenario.instance);
            this.process.addAll(exampleScenario.process);
            this.workflow.addAll(exampleScenario.workflow);
            return this;
        }
    }
}

