/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Age;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.FamilyHistoryStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="fhs-1", level="Rule", location="(base)", description="Can have age[x] or born[x], but not both", expression="age.empty() or born.empty()", source="http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory"), @Constraint(id="fhs-2", level="Rule", location="(base)", description="Can only have estimatedAge if age[x] is present", expression="age.exists() or estimatedAge.empty()", source="http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory"), @Constraint(id="familyMemberHistory-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/administrative-gender", expression="sex.exists() implies (sex.memberOf('http://hl7.org/fhir/ValueSet/administrative-gender', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory", generated=true)})
public class FamilyMemberHistory
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    @Summary
    @Binding(bindingName="FamilyHistoryStatus", strength=BindingStrength.Value.REQUIRED, description="A code that identifies the status of the family history record.", valueSet="http://hl7.org/fhir/ValueSet/history-status|4.3.0")
    @Required
    private final FamilyHistoryStatus status;
    @Summary
    @Binding(bindingName="FamilyHistoryAbsentReason", strength=BindingStrength.Value.EXAMPLE, description="Codes describing the reason why a family member's history is not available.", valueSet="http://hl7.org/fhir/ValueSet/history-absent-reason")
    private final CodeableConcept dataAbsentReason;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Summary
    private final DateTime date;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    @Binding(bindingName="FamilialRelationship", strength=BindingStrength.Value.EXAMPLE, description="The nature of the relationship between the patient and the related person being described in the family member history.", valueSet="http://terminology.hl7.org/ValueSet/v3-FamilyMember")
    @Required
    private final CodeableConcept relationship;
    @Summary
    @Binding(bindingName="Sex", strength=BindingStrength.Value.EXTENSIBLE, description="Codes describing the sex assigned at birth as documented on the birth registration.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    private final CodeableConcept sex;
    @Choice(value={Period.class, Date.class, org.linuxforhealth.fhir.model.type.String.class})
    private final Element born;
    @Summary
    @Choice(value={Age.class, Range.class, org.linuxforhealth.fhir.model.type.String.class})
    private final Element age;
    @Summary
    private final Boolean estimatedAge;
    @Summary
    @Choice(value={Boolean.class, Age.class, Range.class, Date.class, org.linuxforhealth.fhir.model.type.String.class})
    private final Element deceased;
    @Summary
    @Binding(bindingName="FamilyHistoryReason", strength=BindingStrength.Value.EXAMPLE, description="Codes indicating why the family member history was done.", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "AllergyIntolerance", "QuestionnaireResponse", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    private final List<Annotation> note;
    private final List<Condition> condition;

    private FamilyMemberHistory(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.instantiatesCanonical = Collections.unmodifiableList(builder.instantiatesCanonical);
        this.instantiatesUri = Collections.unmodifiableList(builder.instantiatesUri);
        this.status = builder.status;
        this.dataAbsentReason = builder.dataAbsentReason;
        this.patient = builder.patient;
        this.date = builder.date;
        this.name = builder.name;
        this.relationship = builder.relationship;
        this.sex = builder.sex;
        this.born = builder.born;
        this.age = builder.age;
        this.estimatedAge = builder.estimatedAge;
        this.deceased = builder.deceased;
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.note = Collections.unmodifiableList(builder.note);
        this.condition = Collections.unmodifiableList(builder.condition);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public FamilyHistoryStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getDataAbsentReason() {
        return this.dataAbsentReason;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public DateTime getDate() {
        return this.date;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public CodeableConcept getRelationship() {
        return this.relationship;
    }

    public CodeableConcept getSex() {
        return this.sex;
    }

    public Element getBorn() {
        return this.born;
    }

    public Element getAge() {
        return this.age;
    }

    public Boolean getEstimatedAge() {
        return this.estimatedAge;
    }

    public Element getDeceased() {
        return this.deceased;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Condition> getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || this.status != null || this.dataAbsentReason != null || this.patient != null || this.date != null || this.name != null || this.relationship != null || this.sex != null || this.born != null || this.age != null || this.estimatedAge != null || this.deceased != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.note.isEmpty() || !this.condition.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.dataAbsentReason, "dataAbsentReason", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.relationship, "relationship", visitor);
                this.accept(this.sex, "sex", visitor);
                this.accept(this.born, "born", visitor);
                this.accept(this.age, "age", visitor);
                this.accept(this.estimatedAge, "estimatedAge", visitor);
                this.accept(this.deceased, "deceased", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.condition, "condition", visitor, Condition.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FamilyMemberHistory other = (FamilyMemberHistory)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.status, other.status) && Objects.equals(this.dataAbsentReason, other.dataAbsentReason) && Objects.equals(this.patient, other.patient) && Objects.equals(this.date, other.date) && Objects.equals(this.name, other.name) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.sex, other.sex) && Objects.equals(this.born, other.born) && Objects.equals(this.age, other.age) && Objects.equals(this.estimatedAge, other.estimatedAge) && Objects.equals(this.deceased, other.deceased) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.note, other.note) && Objects.equals(this.condition, other.condition);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.status, this.dataAbsentReason, this.patient, this.date, this.name, this.relationship, this.sex, this.born, this.age, this.estimatedAge, this.deceased, this.reasonCode, this.reasonReference, this.note, this.condition);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Condition
    extends BackboneElement {
        @Binding(bindingName="ConditionCode", strength=BindingStrength.Value.EXAMPLE, description="Identification of the Condition or diagnosis.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        @Required
        private final CodeableConcept code;
        @Binding(bindingName="ConditionOutcome", strength=BindingStrength.Value.EXAMPLE, description="The result of the condition for the patient; e.g. death, permanent disability, temporary disability, etc.", valueSet="http://hl7.org/fhir/ValueSet/condition-outcome")
        private final CodeableConcept outcome;
        private final Boolean contributedToDeath;
        @Choice(value={Age.class, Range.class, Period.class, org.linuxforhealth.fhir.model.type.String.class})
        private final Element onset;
        private final List<Annotation> note;

        private Condition(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.outcome = builder.outcome;
            this.contributedToDeath = builder.contributedToDeath;
            this.onset = builder.onset;
            this.note = Collections.unmodifiableList(builder.note);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public CodeableConcept getOutcome() {
            return this.outcome;
        }

        public Boolean getContributedToDeath() {
            return this.contributedToDeath;
        }

        public Element getOnset() {
            return this.onset;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.outcome != null || this.contributedToDeath != null || this.onset != null || !this.note.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.outcome, "outcome", visitor);
                    this.accept(this.contributedToDeath, "contributedToDeath", visitor);
                    this.accept(this.onset, "onset", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Condition other = (Condition)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.contributedToDeath, other.contributedToDeath) && Objects.equals(this.onset, other.onset) && Objects.equals(this.note, other.note);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.outcome, this.contributedToDeath, this.onset, this.note);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private CodeableConcept outcome;
            private Boolean contributedToDeath;
            private Element onset;
            private List<Annotation> note = new ArrayList<Annotation>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder outcome(CodeableConcept outcome) {
                this.outcome = outcome;
                return this;
            }

            public Builder contributedToDeath(java.lang.Boolean contributedToDeath) {
                this.contributedToDeath = contributedToDeath == null ? null : Boolean.of(contributedToDeath);
                return this;
            }

            public Builder contributedToDeath(Boolean contributedToDeath) {
                this.contributedToDeath = contributedToDeath;
                return this;
            }

            public Builder onset(String onset) {
                this.onset = onset == null ? null : org.linuxforhealth.fhir.model.type.String.of(onset);
                return this;
            }

            public Builder onset(Element onset) {
                this.onset = onset;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            @Override
            public Condition build() {
                Condition condition = new Condition(this);
                if (this.validating) {
                    this.validate(condition);
                }
                return condition;
            }

            protected void validate(Condition condition) {
                super.validate(condition);
                ValidationSupport.requireNonNull(condition.code, "code");
                ValidationSupport.choiceElement(condition.onset, "onset", Age.class, Range.class, Period.class, org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.checkList(condition.note, "note", Annotation.class);
                ValidationSupport.requireValueOrChildren(condition);
            }

            protected Builder from(Condition condition) {
                super.from(condition);
                this.code = condition.code;
                this.outcome = condition.outcome;
                this.contributedToDeath = condition.contributedToDeath;
                this.onset = condition.onset;
                this.note.addAll(condition.note);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private FamilyHistoryStatus status;
        private CodeableConcept dataAbsentReason;
        private Reference patient;
        private DateTime date;
        private org.linuxforhealth.fhir.model.type.String name;
        private CodeableConcept relationship;
        private CodeableConcept sex;
        private Element born;
        private Element age;
        private Boolean estimatedAge;
        private Element deceased;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Condition> condition = new ArrayList<Condition>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder status(FamilyHistoryStatus status) {
            this.status = status;
            return this;
        }

        public Builder dataAbsentReason(CodeableConcept dataAbsentReason) {
            this.dataAbsentReason = dataAbsentReason;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder relationship(CodeableConcept relationship) {
            this.relationship = relationship;
            return this;
        }

        public Builder sex(CodeableConcept sex) {
            this.sex = sex;
            return this;
        }

        public Builder born(LocalDate born) {
            this.born = born == null ? null : Date.of(born);
            return this;
        }

        public Builder born(String born) {
            this.born = born == null ? null : org.linuxforhealth.fhir.model.type.String.of(born);
            return this;
        }

        public Builder born(Element born) {
            this.born = born;
            return this;
        }

        public Builder age(String age) {
            this.age = age == null ? null : org.linuxforhealth.fhir.model.type.String.of(age);
            return this;
        }

        public Builder age(Element age) {
            this.age = age;
            return this;
        }

        public Builder estimatedAge(java.lang.Boolean estimatedAge) {
            this.estimatedAge = estimatedAge == null ? null : Boolean.of(estimatedAge);
            return this;
        }

        public Builder estimatedAge(Boolean estimatedAge) {
            this.estimatedAge = estimatedAge;
            return this;
        }

        public Builder deceased(java.lang.Boolean deceased) {
            this.deceased = deceased == null ? null : Boolean.of(deceased);
            return this;
        }

        public Builder deceased(LocalDate deceased) {
            this.deceased = deceased == null ? null : Date.of(deceased);
            return this;
        }

        public Builder deceased(String deceased) {
            this.deceased = deceased == null ? null : org.linuxforhealth.fhir.model.type.String.of(deceased);
            return this;
        }

        public Builder deceased(Element deceased) {
            this.deceased = deceased;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder condition(Condition ... condition) {
            for (Condition value : condition) {
                this.condition.add(value);
            }
            return this;
        }

        public Builder condition(Collection<Condition> condition) {
            this.condition = new ArrayList<Condition>(condition);
            return this;
        }

        @Override
        public FamilyMemberHistory build() {
            FamilyMemberHistory familyMemberHistory = new FamilyMemberHistory(this);
            if (this.validating) {
                this.validate(familyMemberHistory);
            }
            return familyMemberHistory;
        }

        protected void validate(FamilyMemberHistory familyMemberHistory) {
            super.validate(familyMemberHistory);
            ValidationSupport.checkList(familyMemberHistory.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(familyMemberHistory.instantiatesCanonical, "instantiatesCanonical", Canonical.class);
            ValidationSupport.checkList(familyMemberHistory.instantiatesUri, "instantiatesUri", Uri.class);
            ValidationSupport.requireNonNull(familyMemberHistory.status, "status");
            ValidationSupport.requireNonNull(familyMemberHistory.patient, "patient");
            ValidationSupport.requireNonNull(familyMemberHistory.relationship, "relationship");
            ValidationSupport.choiceElement(familyMemberHistory.born, "born", Period.class, Date.class, org.linuxforhealth.fhir.model.type.String.class);
            ValidationSupport.choiceElement(familyMemberHistory.age, "age", Age.class, Range.class, org.linuxforhealth.fhir.model.type.String.class);
            ValidationSupport.choiceElement(familyMemberHistory.deceased, "deceased", Boolean.class, Age.class, Range.class, Date.class, org.linuxforhealth.fhir.model.type.String.class);
            ValidationSupport.checkList(familyMemberHistory.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(familyMemberHistory.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(familyMemberHistory.note, "note", Annotation.class);
            ValidationSupport.checkList(familyMemberHistory.condition, "condition", Condition.class);
            ValidationSupport.checkReferenceType(familyMemberHistory.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(familyMemberHistory.reasonReference, "reasonReference", "Condition", "Observation", "AllergyIntolerance", "QuestionnaireResponse", "DiagnosticReport", "DocumentReference");
        }

        protected Builder from(FamilyMemberHistory familyMemberHistory) {
            super.from(familyMemberHistory);
            this.identifier.addAll(familyMemberHistory.identifier);
            this.instantiatesCanonical.addAll(familyMemberHistory.instantiatesCanonical);
            this.instantiatesUri.addAll(familyMemberHistory.instantiatesUri);
            this.status = familyMemberHistory.status;
            this.dataAbsentReason = familyMemberHistory.dataAbsentReason;
            this.patient = familyMemberHistory.patient;
            this.date = familyMemberHistory.date;
            this.name = familyMemberHistory.name;
            this.relationship = familyMemberHistory.relationship;
            this.sex = familyMemberHistory.sex;
            this.born = familyMemberHistory.born;
            this.age = familyMemberHistory.age;
            this.estimatedAge = familyMemberHistory.estimatedAge;
            this.deceased = familyMemberHistory.deceased;
            this.reasonCode.addAll(familyMemberHistory.reasonCode);
            this.reasonReference.addAll(familyMemberHistory.reasonReference);
            this.note.addAll(familyMemberHistory.note);
            this.condition.addAll(familyMemberHistory.condition);
            return this;
        }
    }
}

