/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.FlagStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
public class Flag
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="FlagStatus", strength=BindingStrength.Value.REQUIRED, description="Indicates whether this flag is active and needs to be displayed to a user, or whether it is no longer needed or was entered in error.", valueSet="http://hl7.org/fhir/ValueSet/flag-status|4.3.0")
    @Required
    private final FlagStatus status;
    @Summary
    @Binding(bindingName="FlagCategory", strength=BindingStrength.Value.EXAMPLE, description="A general category for flags for filtering/display purposes.", valueSet="http://hl7.org/fhir/ValueSet/flag-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="FlagCode", strength=BindingStrength.Value.EXAMPLE, description="Detail codes identifying specific flagged issues.", valueSet="http://hl7.org/fhir/ValueSet/flag-code")
    @Required
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient", "Location", "Group", "Organization", "Practitioner", "PlanDefinition", "Medication", "Procedure"})
    @Required
    private final Reference subject;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @ReferenceTarget(value={"Device", "Organization", "Patient", "Practitioner", "PractitionerRole"})
    private final Reference author;

    private Flag(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.category = Collections.unmodifiableList(builder.category);
        this.code = builder.code;
        this.subject = builder.subject;
        this.period = builder.period;
        this.encounter = builder.encounter;
        this.author = builder.author;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public FlagStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Reference getAuthor() {
        return this.author;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.category.isEmpty() || this.code != null || this.subject != null || this.period != null || this.encounter != null || this.author != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.author, "author", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Flag other = (Flag)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.period, other.period) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.author, other.author);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.category, this.code, this.subject, this.period, this.encounter, this.author);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private FlagStatus status;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept code;
        private Reference subject;
        private Period period;
        private Reference encounter;
        private Reference author;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(FlagStatus status) {
            this.status = status;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        @Override
        public Flag build() {
            Flag flag = new Flag(this);
            if (this.validating) {
                this.validate(flag);
            }
            return flag;
        }

        protected void validate(Flag flag) {
            super.validate(flag);
            ValidationSupport.checkList(flag.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(flag.status, "status");
            ValidationSupport.checkList(flag.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(flag.code, "code");
            ValidationSupport.requireNonNull(flag.subject, "subject");
            ValidationSupport.checkReferenceType(flag.subject, "subject", "Patient", "Location", "Group", "Organization", "Practitioner", "PlanDefinition", "Medication", "Procedure");
            ValidationSupport.checkReferenceType(flag.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(flag.author, "author", "Device", "Organization", "Patient", "Practitioner", "PractitionerRole");
        }

        protected Builder from(Flag flag) {
            super.from(flag);
            this.identifier.addAll(flag.identifier);
            this.status = flag.status;
            this.category.addAll(flag.category);
            this.code = flag.code;
            this.subject = flag.subject;
            this.period = flag.period;
            this.encounter = flag.encounter;
            this.author = flag.author;
            return this;
        }
    }
}

