/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DataRequirement;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.GuidanceResponseStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
public class GuidanceResponse
extends DomainResource {
    @Summary
    private final Identifier requestIdentifier;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Choice(value={Uri.class, Canonical.class, CodeableConcept.class})
    @Required
    private final Element module;
    @Summary
    @Binding(bindingName="GuidanceResponseStatus", strength=BindingStrength.Value.REQUIRED, description="The status of a guidance response.", valueSet="http://hl7.org/fhir/ValueSet/guidance-response-status|4.3.0")
    @Required
    private final GuidanceResponseStatus status;
    @ReferenceTarget(value={"Patient", "Group"})
    private final Reference subject;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    private final DateTime occurrenceDateTime;
    @ReferenceTarget(value={"Device"})
    private final Reference performer;
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    private final List<Annotation> note;
    @ReferenceTarget(value={"OperationOutcome"})
    private final List<Reference> evaluationMessage;
    @ReferenceTarget(value={"Parameters"})
    private final Reference outputParameters;
    @ReferenceTarget(value={"CarePlan", "RequestGroup"})
    private final Reference result;
    private final List<DataRequirement> dataRequirement;

    private GuidanceResponse(Builder builder) {
        super(builder);
        this.requestIdentifier = builder.requestIdentifier;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.module = builder.module;
        this.status = builder.status;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.occurrenceDateTime = builder.occurrenceDateTime;
        this.performer = builder.performer;
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.note = Collections.unmodifiableList(builder.note);
        this.evaluationMessage = Collections.unmodifiableList(builder.evaluationMessage);
        this.outputParameters = builder.outputParameters;
        this.result = builder.result;
        this.dataRequirement = Collections.unmodifiableList(builder.dataRequirement);
    }

    public Identifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Element getModule() {
        return this.module;
    }

    public GuidanceResponseStatus getStatus() {
        return this.status;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getOccurrenceDateTime() {
        return this.occurrenceDateTime;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Reference> getEvaluationMessage() {
        return this.evaluationMessage;
    }

    public Reference getOutputParameters() {
        return this.outputParameters;
    }

    public Reference getResult() {
        return this.result;
    }

    public List<DataRequirement> getDataRequirement() {
        return this.dataRequirement;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.requestIdentifier != null || !this.identifier.isEmpty() || this.module != null || this.status != null || this.subject != null || this.encounter != null || this.occurrenceDateTime != null || this.performer != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.note.isEmpty() || !this.evaluationMessage.isEmpty() || this.outputParameters != null || this.result != null || !this.dataRequirement.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.requestIdentifier, "requestIdentifier", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.module, "module", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.occurrenceDateTime, "occurrenceDateTime", visitor);
                this.accept(this.performer, "performer", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.evaluationMessage, "evaluationMessage", visitor, Reference.class);
                this.accept(this.outputParameters, "outputParameters", visitor);
                this.accept(this.result, "result", visitor);
                this.accept(this.dataRequirement, "dataRequirement", visitor, DataRequirement.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuidanceResponse other = (GuidanceResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.requestIdentifier, other.requestIdentifier) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.module, other.module) && Objects.equals(this.status, other.status) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.occurrenceDateTime, other.occurrenceDateTime) && Objects.equals(this.performer, other.performer) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.note, other.note) && Objects.equals(this.evaluationMessage, other.evaluationMessage) && Objects.equals(this.outputParameters, other.outputParameters) && Objects.equals(this.result, other.result) && Objects.equals(this.dataRequirement, other.dataRequirement);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.requestIdentifier, this.identifier, this.module, this.status, this.subject, this.encounter, this.occurrenceDateTime, this.performer, this.reasonCode, this.reasonReference, this.note, this.evaluationMessage, this.outputParameters, this.result, this.dataRequirement);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier requestIdentifier;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Element module;
        private GuidanceResponseStatus status;
        private Reference subject;
        private Reference encounter;
        private DateTime occurrenceDateTime;
        private Reference performer;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Reference> evaluationMessage = new ArrayList<Reference>();
        private Reference outputParameters;
        private Reference result;
        private List<DataRequirement> dataRequirement = new ArrayList<DataRequirement>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder requestIdentifier(Identifier requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder module(Element module) {
            this.module = module;
            return this;
        }

        public Builder status(GuidanceResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder occurrenceDateTime(DateTime occurrenceDateTime) {
            this.occurrenceDateTime = occurrenceDateTime;
            return this;
        }

        public Builder performer(Reference performer) {
            this.performer = performer;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder evaluationMessage(Reference ... evaluationMessage) {
            for (Reference value : evaluationMessage) {
                this.evaluationMessage.add(value);
            }
            return this;
        }

        public Builder evaluationMessage(Collection<Reference> evaluationMessage) {
            this.evaluationMessage = new ArrayList<Reference>(evaluationMessage);
            return this;
        }

        public Builder outputParameters(Reference outputParameters) {
            this.outputParameters = outputParameters;
            return this;
        }

        public Builder result(Reference result) {
            this.result = result;
            return this;
        }

        public Builder dataRequirement(DataRequirement ... dataRequirement) {
            for (DataRequirement value : dataRequirement) {
                this.dataRequirement.add(value);
            }
            return this;
        }

        public Builder dataRequirement(Collection<DataRequirement> dataRequirement) {
            this.dataRequirement = new ArrayList<DataRequirement>(dataRequirement);
            return this;
        }

        @Override
        public GuidanceResponse build() {
            GuidanceResponse guidanceResponse = new GuidanceResponse(this);
            if (this.validating) {
                this.validate(guidanceResponse);
            }
            return guidanceResponse;
        }

        protected void validate(GuidanceResponse guidanceResponse) {
            super.validate(guidanceResponse);
            ValidationSupport.checkList(guidanceResponse.identifier, "identifier", Identifier.class);
            ValidationSupport.requireChoiceElement(guidanceResponse.module, "module", Uri.class, Canonical.class, CodeableConcept.class);
            ValidationSupport.requireNonNull(guidanceResponse.status, "status");
            ValidationSupport.checkList(guidanceResponse.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(guidanceResponse.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(guidanceResponse.note, "note", Annotation.class);
            ValidationSupport.checkList(guidanceResponse.evaluationMessage, "evaluationMessage", Reference.class);
            ValidationSupport.checkList(guidanceResponse.dataRequirement, "dataRequirement", DataRequirement.class);
            ValidationSupport.checkReferenceType(guidanceResponse.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(guidanceResponse.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(guidanceResponse.performer, "performer", "Device");
            ValidationSupport.checkReferenceType(guidanceResponse.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
            ValidationSupport.checkReferenceType(guidanceResponse.evaluationMessage, "evaluationMessage", "OperationOutcome");
            ValidationSupport.checkReferenceType(guidanceResponse.outputParameters, "outputParameters", "Parameters");
            ValidationSupport.checkReferenceType(guidanceResponse.result, "result", "CarePlan", "RequestGroup");
        }

        protected Builder from(GuidanceResponse guidanceResponse) {
            super.from(guidanceResponse);
            this.requestIdentifier = guidanceResponse.requestIdentifier;
            this.identifier.addAll(guidanceResponse.identifier);
            this.module = guidanceResponse.module;
            this.status = guidanceResponse.status;
            this.subject = guidanceResponse.subject;
            this.encounter = guidanceResponse.encounter;
            this.occurrenceDateTime = guidanceResponse.occurrenceDateTime;
            this.performer = guidanceResponse.performer;
            this.reasonCode.addAll(guidanceResponse.reasonCode);
            this.reasonReference.addAll(guidanceResponse.reasonReference);
            this.note.addAll(guidanceResponse.note);
            this.evaluationMessage.addAll(guidanceResponse.evaluationMessage);
            this.outputParameters = guidanceResponse.outputParameters;
            this.result = guidanceResponse.result;
            this.dataRequirement.addAll(guidanceResponse.dataRequirement);
            return this;
        }
    }
}

