/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Id;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.Url;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.FHIRVersion;
import org.linuxforhealth.fhir.model.type.code.GuidePageGeneration;
import org.linuxforhealth.fhir.model.type.code.GuideParameterCode;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.ResourceTypeCode;
import org.linuxforhealth.fhir.model.type.code.SPDXLicense;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="ig-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/ImplementationGuide"), @Constraint(id="ig-1", level="Rule", location="ImplementationGuide.definition", description="If a resource has a groupingId, it must refer to a grouping defined in the Implementation Guide", expression="resource.groupingId.all(%context.grouping.id contains $this)", source="http://hl7.org/fhir/StructureDefinition/ImplementationGuide"), @Constraint(id="ig-2", level="Rule", location="(base)", description="If a resource has a fhirVersion, it must be oe of the versions defined for the Implementation Guide", expression="definition.resource.fhirVersion.all(%context.fhirVersion contains $this)", source="http://hl7.org/fhir/StructureDefinition/ImplementationGuide"), @Constraint(id="implementationGuide-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/ImplementationGuide", generated=true)})
public class ImplementationGuide
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    @Required
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown copyright;
    @Summary
    @Required
    private final Id packageId;
    @Summary
    @Binding(bindingName="SPDXLicense", strength=BindingStrength.Value.REQUIRED, description="The license that applies to an Implementation Guide (using an SPDX license Identifiers, or 'not-open-source'). The binding is required but new SPDX license Identifiers are allowed to be used (https://spdx.org/licenses/).", valueSet="http://hl7.org/fhir/ValueSet/spdx-license|4.3.0")
    private final SPDXLicense license;
    @Summary
    @Binding(bindingName="FHIRVersion", strength=BindingStrength.Value.REQUIRED, description="All published FHIR Versions.", valueSet="http://hl7.org/fhir/ValueSet/FHIR-version|4.3.0")
    @Required
    private final List<FHIRVersion> fhirVersion;
    @Summary
    private final List<DependsOn> dependsOn;
    @Summary
    private final List<Global> global;
    private final Definition definition;
    private final Manifest manifest;

    private ImplementationGuide(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.copyright = builder.copyright;
        this.packageId = builder.packageId;
        this.license = builder.license;
        this.fhirVersion = Collections.unmodifiableList(builder.fhirVersion);
        this.dependsOn = Collections.unmodifiableList(builder.dependsOn);
        this.global = Collections.unmodifiableList(builder.global);
        this.definition = builder.definition;
        this.manifest = builder.manifest;
    }

    public Uri getUrl() {
        return this.url;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public org.linuxforhealth.fhir.model.type.String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Id getPackageId() {
        return this.packageId;
    }

    public SPDXLicense getLicense() {
        return this.license;
    }

    public List<FHIRVersion> getFhirVersion() {
        return this.fhirVersion;
    }

    public List<DependsOn> getDependsOn() {
        return this.dependsOn;
    }

    public List<Global> getGlobal() {
        return this.global;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.copyright != null || this.packageId != null || this.license != null || !this.fhirVersion.isEmpty() || !this.dependsOn.isEmpty() || !this.global.isEmpty() || this.definition != null || this.manifest != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.packageId, "packageId", visitor);
                this.accept(this.license, "license", visitor);
                this.accept(this.fhirVersion, "fhirVersion", visitor, FHIRVersion.class);
                this.accept(this.dependsOn, "dependsOn", visitor, DependsOn.class);
                this.accept(this.global, "global", visitor, Global.class);
                this.accept(this.definition, "definition", visitor);
                this.accept(this.manifest, "manifest", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImplementationGuide other = (ImplementationGuide)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.packageId, other.packageId) && Objects.equals(this.license, other.license) && Objects.equals(this.fhirVersion, other.fhirVersion) && Objects.equals(this.dependsOn, other.dependsOn) && Objects.equals(this.global, other.global) && Objects.equals(this.definition, other.definition) && Objects.equals(this.manifest, other.manifest);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.copyright, this.packageId, this.license, this.fhirVersion, this.dependsOn, this.global, this.definition, this.manifest);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Manifest
    extends BackboneElement {
        @Summary
        private final Url rendering;
        @Summary
        @Required
        private final List<Resource> resource;
        private final List<Page> page;
        private final List<org.linuxforhealth.fhir.model.type.String> image;
        private final List<org.linuxforhealth.fhir.model.type.String> other;

        private Manifest(Builder builder) {
            super(builder);
            this.rendering = builder.rendering;
            this.resource = Collections.unmodifiableList(builder.resource);
            this.page = Collections.unmodifiableList(builder.page);
            this.image = Collections.unmodifiableList(builder.image);
            this.other = Collections.unmodifiableList(builder.other);
        }

        public Url getRendering() {
            return this.rendering;
        }

        public List<Resource> getResource() {
            return this.resource;
        }

        public List<Page> getPage() {
            return this.page;
        }

        public List<org.linuxforhealth.fhir.model.type.String> getImage() {
            return this.image;
        }

        public List<org.linuxforhealth.fhir.model.type.String> getOther() {
            return this.other;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.rendering != null || !this.resource.isEmpty() || !this.page.isEmpty() || !this.image.isEmpty() || !this.other.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.rendering, "rendering", visitor);
                    this.accept(this.resource, "resource", visitor, Resource.class);
                    this.accept(this.page, "page", visitor, Page.class);
                    this.accept(this.image, "image", visitor, org.linuxforhealth.fhir.model.type.String.class);
                    this.accept(this.other, "other", visitor, org.linuxforhealth.fhir.model.type.String.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Manifest other = (Manifest)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.rendering, other.rendering) && Objects.equals(this.resource, other.resource) && Objects.equals(this.page, other.page) && Objects.equals(this.image, other.image) && Objects.equals(this.other, other.other);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.rendering, this.resource, this.page, this.image, this.other);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Page
        extends BackboneElement {
            @Required
            private final org.linuxforhealth.fhir.model.type.String name;
            private final org.linuxforhealth.fhir.model.type.String title;
            private final List<org.linuxforhealth.fhir.model.type.String> anchor;

            private Page(Builder builder) {
                super(builder);
                this.name = builder.name;
                this.title = builder.title;
                this.anchor = Collections.unmodifiableList(builder.anchor);
            }

            public org.linuxforhealth.fhir.model.type.String getName() {
                return this.name;
            }

            public org.linuxforhealth.fhir.model.type.String getTitle() {
                return this.title;
            }

            public List<org.linuxforhealth.fhir.model.type.String> getAnchor() {
                return this.anchor;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.title != null || !this.anchor.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.title, "title", visitor);
                        this.accept(this.anchor, "anchor", visitor, org.linuxforhealth.fhir.model.type.String.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Page other = (Page)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.anchor, other.anchor);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.title, this.anchor);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String name;
                private org.linuxforhealth.fhir.model.type.String title;
                private List<org.linuxforhealth.fhir.model.type.String> anchor = new ArrayList<org.linuxforhealth.fhir.model.type.String>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(String name) {
                    this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                    return this;
                }

                public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                    this.name = name;
                    return this;
                }

                public Builder title(String title) {
                    this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
                    return this;
                }

                public Builder title(org.linuxforhealth.fhir.model.type.String title) {
                    this.title = title;
                    return this;
                }

                public Builder anchor(String ... anchor) {
                    for (String value : anchor) {
                        this.anchor.add(value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value));
                    }
                    return this;
                }

                public Builder anchor(org.linuxforhealth.fhir.model.type.String ... anchor) {
                    for (org.linuxforhealth.fhir.model.type.String value : anchor) {
                        this.anchor.add(value);
                    }
                    return this;
                }

                public Builder anchor(Collection<org.linuxforhealth.fhir.model.type.String> anchor) {
                    this.anchor = new ArrayList<org.linuxforhealth.fhir.model.type.String>(anchor);
                    return this;
                }

                @Override
                public Page build() {
                    Page page = new Page(this);
                    if (this.validating) {
                        this.validate(page);
                    }
                    return page;
                }

                protected void validate(Page page) {
                    super.validate(page);
                    ValidationSupport.requireNonNull(page.name, "name");
                    ValidationSupport.checkList(page.anchor, "anchor", org.linuxforhealth.fhir.model.type.String.class);
                    ValidationSupport.requireValueOrChildren(page);
                }

                protected Builder from(Page page) {
                    super.from(page);
                    this.name = page.name;
                    this.title = page.title;
                    this.anchor.addAll(page.anchor);
                    return this;
                }
            }
        }

        public static class Resource
        extends BackboneElement {
            @Summary
            @Required
            private final Reference reference;
            @Choice(value={Boolean.class, Canonical.class})
            private final Element example;
            private final Url relativePath;

            private Resource(Builder builder) {
                super(builder);
                this.reference = builder.reference;
                this.example = builder.example;
                this.relativePath = builder.relativePath;
            }

            public Reference getReference() {
                return this.reference;
            }

            public Element getExample() {
                return this.example;
            }

            public Url getRelativePath() {
                return this.relativePath;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.reference != null || this.example != null || this.relativePath != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.reference, "reference", visitor);
                        this.accept(this.example, "example", visitor);
                        this.accept(this.relativePath, "relativePath", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Resource other = (Resource)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.example, other.example) && Objects.equals(this.relativePath, other.relativePath);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.reference, this.example, this.relativePath);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Reference reference;
                private Element example;
                private Url relativePath;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder reference(Reference reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder example(java.lang.Boolean example) {
                    this.example = example == null ? null : Boolean.of(example);
                    return this;
                }

                public Builder example(Element example) {
                    this.example = example;
                    return this;
                }

                public Builder relativePath(Url relativePath) {
                    this.relativePath = relativePath;
                    return this;
                }

                @Override
                public Resource build() {
                    Resource resource = new Resource(this);
                    if (this.validating) {
                        this.validate(resource);
                    }
                    return resource;
                }

                protected void validate(Resource resource) {
                    super.validate(resource);
                    ValidationSupport.requireNonNull(resource.reference, "reference");
                    ValidationSupport.choiceElement(resource.example, "example", Boolean.class, Canonical.class);
                    ValidationSupport.requireValueOrChildren(resource);
                }

                protected Builder from(Resource resource) {
                    super.from(resource);
                    this.reference = resource.reference;
                    this.example = resource.example;
                    this.relativePath = resource.relativePath;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Url rendering;
            private List<Resource> resource = new ArrayList<Resource>();
            private List<Page> page = new ArrayList<Page>();
            private List<org.linuxforhealth.fhir.model.type.String> image = new ArrayList<org.linuxforhealth.fhir.model.type.String>();
            private List<org.linuxforhealth.fhir.model.type.String> other = new ArrayList<org.linuxforhealth.fhir.model.type.String>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder rendering(Url rendering) {
                this.rendering = rendering;
                return this;
            }

            public Builder resource(Resource ... resource) {
                for (Resource value : resource) {
                    this.resource.add(value);
                }
                return this;
            }

            public Builder resource(Collection<Resource> resource) {
                this.resource = new ArrayList<Resource>(resource);
                return this;
            }

            public Builder page(Page ... page) {
                for (Page value : page) {
                    this.page.add(value);
                }
                return this;
            }

            public Builder page(Collection<Page> page) {
                this.page = new ArrayList<Page>(page);
                return this;
            }

            public Builder image(String ... image) {
                for (String value : image) {
                    this.image.add(value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value));
                }
                return this;
            }

            public Builder image(org.linuxforhealth.fhir.model.type.String ... image) {
                for (org.linuxforhealth.fhir.model.type.String value : image) {
                    this.image.add(value);
                }
                return this;
            }

            public Builder image(Collection<org.linuxforhealth.fhir.model.type.String> image) {
                this.image = new ArrayList<org.linuxforhealth.fhir.model.type.String>(image);
                return this;
            }

            public Builder other(String ... other) {
                for (String value : other) {
                    this.other.add(value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value));
                }
                return this;
            }

            public Builder other(org.linuxforhealth.fhir.model.type.String ... other) {
                for (org.linuxforhealth.fhir.model.type.String value : other) {
                    this.other.add(value);
                }
                return this;
            }

            public Builder other(Collection<org.linuxforhealth.fhir.model.type.String> other) {
                this.other = new ArrayList<org.linuxforhealth.fhir.model.type.String>(other);
                return this;
            }

            @Override
            public Manifest build() {
                Manifest manifest = new Manifest(this);
                if (this.validating) {
                    this.validate(manifest);
                }
                return manifest;
            }

            protected void validate(Manifest manifest) {
                super.validate(manifest);
                ValidationSupport.checkNonEmptyList(manifest.resource, "resource", Resource.class);
                ValidationSupport.checkList(manifest.page, "page", Page.class);
                ValidationSupport.checkList(manifest.image, "image", org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.checkList(manifest.other, "other", org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.requireValueOrChildren(manifest);
            }

            protected Builder from(Manifest manifest) {
                super.from(manifest);
                this.rendering = manifest.rendering;
                this.resource.addAll(manifest.resource);
                this.page.addAll(manifest.page);
                this.image.addAll(manifest.image);
                this.other.addAll(manifest.other);
                return this;
            }
        }
    }

    public static class Definition
    extends BackboneElement {
        private final List<Grouping> grouping;
        @Required
        private final List<Resource> resource;
        private final Page page;
        private final List<Parameter> parameter;
        private final List<Template> template;

        private Definition(Builder builder) {
            super(builder);
            this.grouping = Collections.unmodifiableList(builder.grouping);
            this.resource = Collections.unmodifiableList(builder.resource);
            this.page = builder.page;
            this.parameter = Collections.unmodifiableList(builder.parameter);
            this.template = Collections.unmodifiableList(builder.template);
        }

        public List<Grouping> getGrouping() {
            return this.grouping;
        }

        public List<Resource> getResource() {
            return this.resource;
        }

        public Page getPage() {
            return this.page;
        }

        public List<Parameter> getParameter() {
            return this.parameter;
        }

        public List<Template> getTemplate() {
            return this.template;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.grouping.isEmpty() || !this.resource.isEmpty() || this.page != null || !this.parameter.isEmpty() || !this.template.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.grouping, "grouping", visitor, Grouping.class);
                    this.accept(this.resource, "resource", visitor, Resource.class);
                    this.accept(this.page, "page", visitor);
                    this.accept(this.parameter, "parameter", visitor, Parameter.class);
                    this.accept(this.template, "template", visitor, Template.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Definition other = (Definition)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.grouping, other.grouping) && Objects.equals(this.resource, other.resource) && Objects.equals(this.page, other.page) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.template, other.template);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.grouping, this.resource, this.page, this.parameter, this.template);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Template
        extends BackboneElement {
            @Required
            private final Code code;
            @Required
            private final org.linuxforhealth.fhir.model.type.String source;
            private final org.linuxforhealth.fhir.model.type.String scope;

            private Template(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.source = builder.source;
                this.scope = builder.scope;
            }

            public Code getCode() {
                return this.code;
            }

            public org.linuxforhealth.fhir.model.type.String getSource() {
                return this.source;
            }

            public org.linuxforhealth.fhir.model.type.String getScope() {
                return this.scope;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.source != null || this.scope != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.source, "source", visitor);
                        this.accept(this.scope, "scope", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Template other = (Template)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.source, other.source) && Objects.equals(this.scope, other.scope);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.source, this.scope);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Code code;
                private org.linuxforhealth.fhir.model.type.String source;
                private org.linuxforhealth.fhir.model.type.String scope;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(Code code) {
                    this.code = code;
                    return this;
                }

                public Builder source(String source) {
                    this.source = source == null ? null : org.linuxforhealth.fhir.model.type.String.of(source);
                    return this;
                }

                public Builder source(org.linuxforhealth.fhir.model.type.String source) {
                    this.source = source;
                    return this;
                }

                public Builder scope(String scope) {
                    this.scope = scope == null ? null : org.linuxforhealth.fhir.model.type.String.of(scope);
                    return this;
                }

                public Builder scope(org.linuxforhealth.fhir.model.type.String scope) {
                    this.scope = scope;
                    return this;
                }

                @Override
                public Template build() {
                    Template template = new Template(this);
                    if (this.validating) {
                        this.validate(template);
                    }
                    return template;
                }

                protected void validate(Template template) {
                    super.validate(template);
                    ValidationSupport.requireNonNull(template.code, "code");
                    ValidationSupport.requireNonNull(template.source, "source");
                    ValidationSupport.requireValueOrChildren(template);
                }

                protected Builder from(Template template) {
                    super.from(template);
                    this.code = template.code;
                    this.source = template.source;
                    this.scope = template.scope;
                    return this;
                }
            }
        }

        public static class Parameter
        extends BackboneElement {
            @Binding(bindingName="GuideParameterCode", strength=BindingStrength.Value.REQUIRED, description="Code of parameter that is input to the guide.", valueSet="http://hl7.org/fhir/ValueSet/guide-parameter-code|4.3.0")
            @Required
            private final GuideParameterCode code;
            @Required
            private final org.linuxforhealth.fhir.model.type.String value;

            private Parameter(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.value = builder.value;
            }

            public GuideParameterCode getCode() {
                return this.code;
            }

            public org.linuxforhealth.fhir.model.type.String getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.value != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Parameter other = (Parameter)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private GuideParameterCode code;
                private org.linuxforhealth.fhir.model.type.String value;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(GuideParameterCode code) {
                    this.code = code;
                    return this;
                }

                public Builder value(String value) {
                    this.value = value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value);
                    return this;
                }

                public Builder value(org.linuxforhealth.fhir.model.type.String value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Parameter build() {
                    Parameter parameter = new Parameter(this);
                    if (this.validating) {
                        this.validate(parameter);
                    }
                    return parameter;
                }

                protected void validate(Parameter parameter) {
                    super.validate(parameter);
                    ValidationSupport.requireNonNull(parameter.code, "code");
                    ValidationSupport.requireNonNull(parameter.value, "value");
                    ValidationSupport.requireValueOrChildren(parameter);
                }

                protected Builder from(Parameter parameter) {
                    super.from(parameter);
                    this.code = parameter.code;
                    this.value = parameter.value;
                    return this;
                }
            }
        }

        public static class Page
        extends BackboneElement {
            @ReferenceTarget(value={"Binary"})
            @Choice(value={Url.class, Reference.class})
            @Required
            private final Element name;
            @Required
            private final org.linuxforhealth.fhir.model.type.String title;
            @Binding(bindingName="GuidePageGeneration", strength=BindingStrength.Value.REQUIRED, description="A code that indicates how the page is generated.", valueSet="http://hl7.org/fhir/ValueSet/guide-page-generation|4.3.0")
            @Required
            private final GuidePageGeneration generation;
            private final List<Page> page;

            private Page(Builder builder) {
                super(builder);
                this.name = builder.name;
                this.title = builder.title;
                this.generation = builder.generation;
                this.page = Collections.unmodifiableList(builder.page);
            }

            public Element getName() {
                return this.name;
            }

            public org.linuxforhealth.fhir.model.type.String getTitle() {
                return this.title;
            }

            public GuidePageGeneration getGeneration() {
                return this.generation;
            }

            public List<Page> getPage() {
                return this.page;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.title != null || this.generation != null || !this.page.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.title, "title", visitor);
                        this.accept(this.generation, "generation", visitor);
                        this.accept(this.page, "page", visitor, Page.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Page other = (Page)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.generation, other.generation) && Objects.equals(this.page, other.page);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.title, this.generation, this.page);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element name;
                private org.linuxforhealth.fhir.model.type.String title;
                private GuidePageGeneration generation;
                private List<Page> page = new ArrayList<Page>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(Element name) {
                    this.name = name;
                    return this;
                }

                public Builder title(String title) {
                    this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
                    return this;
                }

                public Builder title(org.linuxforhealth.fhir.model.type.String title) {
                    this.title = title;
                    return this;
                }

                public Builder generation(GuidePageGeneration generation) {
                    this.generation = generation;
                    return this;
                }

                public Builder page(Page ... page) {
                    for (Page value : page) {
                        this.page.add(value);
                    }
                    return this;
                }

                public Builder page(Collection<Page> page) {
                    this.page = new ArrayList<Page>(page);
                    return this;
                }

                @Override
                public Page build() {
                    Page page = new Page(this);
                    if (this.validating) {
                        this.validate(page);
                    }
                    return page;
                }

                protected void validate(Page page) {
                    super.validate(page);
                    ValidationSupport.requireChoiceElement(page.name, "name", Url.class, Reference.class);
                    ValidationSupport.requireNonNull(page.title, "title");
                    ValidationSupport.requireNonNull(page.generation, "generation");
                    ValidationSupport.checkList(page.page, "page", Page.class);
                    ValidationSupport.checkReferenceType(page.name, "name", "Binary");
                    ValidationSupport.requireValueOrChildren(page);
                }

                protected Builder from(Page page) {
                    super.from(page);
                    this.name = page.name;
                    this.title = page.title;
                    this.generation = page.generation;
                    this.page.addAll(page.page);
                    return this;
                }
            }
        }

        public static class Resource
        extends BackboneElement {
            @Required
            private final Reference reference;
            @Binding(bindingName="FHIRVersion", strength=BindingStrength.Value.REQUIRED, description="All published FHIR Versions.", valueSet="http://hl7.org/fhir/ValueSet/FHIR-version|4.3.0")
            private final List<FHIRVersion> fhirVersion;
            private final org.linuxforhealth.fhir.model.type.String name;
            private final org.linuxforhealth.fhir.model.type.String description;
            @Choice(value={Boolean.class, Canonical.class})
            private final Element example;
            private final Id groupingId;

            private Resource(Builder builder) {
                super(builder);
                this.reference = builder.reference;
                this.fhirVersion = Collections.unmodifiableList(builder.fhirVersion);
                this.name = builder.name;
                this.description = builder.description;
                this.example = builder.example;
                this.groupingId = builder.groupingId;
            }

            public Reference getReference() {
                return this.reference;
            }

            public List<FHIRVersion> getFhirVersion() {
                return this.fhirVersion;
            }

            public org.linuxforhealth.fhir.model.type.String getName() {
                return this.name;
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            public Element getExample() {
                return this.example;
            }

            public Id getGroupingId() {
                return this.groupingId;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.reference != null || !this.fhirVersion.isEmpty() || this.name != null || this.description != null || this.example != null || this.groupingId != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.reference, "reference", visitor);
                        this.accept(this.fhirVersion, "fhirVersion", visitor, FHIRVersion.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.example, "example", visitor);
                        this.accept(this.groupingId, "groupingId", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Resource other = (Resource)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.fhirVersion, other.fhirVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.example, other.example) && Objects.equals(this.groupingId, other.groupingId);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.reference, this.fhirVersion, this.name, this.description, this.example, this.groupingId);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Reference reference;
                private List<FHIRVersion> fhirVersion = new ArrayList<FHIRVersion>();
                private org.linuxforhealth.fhir.model.type.String name;
                private org.linuxforhealth.fhir.model.type.String description;
                private Element example;
                private Id groupingId;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder reference(Reference reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder fhirVersion(FHIRVersion ... fhirVersion) {
                    for (FHIRVersion value : fhirVersion) {
                        this.fhirVersion.add(value);
                    }
                    return this;
                }

                public Builder fhirVersion(Collection<FHIRVersion> fhirVersion) {
                    this.fhirVersion = new ArrayList<FHIRVersion>(fhirVersion);
                    return this;
                }

                public Builder name(String name) {
                    this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                    return this;
                }

                public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                    this.name = name;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                public Builder example(java.lang.Boolean example) {
                    this.example = example == null ? null : Boolean.of(example);
                    return this;
                }

                public Builder example(Element example) {
                    this.example = example;
                    return this;
                }

                public Builder groupingId(Id groupingId) {
                    this.groupingId = groupingId;
                    return this;
                }

                @Override
                public Resource build() {
                    Resource resource = new Resource(this);
                    if (this.validating) {
                        this.validate(resource);
                    }
                    return resource;
                }

                protected void validate(Resource resource) {
                    super.validate(resource);
                    ValidationSupport.requireNonNull(resource.reference, "reference");
                    ValidationSupport.checkList(resource.fhirVersion, "fhirVersion", FHIRVersion.class);
                    ValidationSupport.choiceElement(resource.example, "example", Boolean.class, Canonical.class);
                    ValidationSupport.requireValueOrChildren(resource);
                }

                protected Builder from(Resource resource) {
                    super.from(resource);
                    this.reference = resource.reference;
                    this.fhirVersion.addAll(resource.fhirVersion);
                    this.name = resource.name;
                    this.description = resource.description;
                    this.example = resource.example;
                    this.groupingId = resource.groupingId;
                    return this;
                }
            }
        }

        public static class Grouping
        extends BackboneElement {
            @Required
            private final org.linuxforhealth.fhir.model.type.String name;
            private final org.linuxforhealth.fhir.model.type.String description;

            private Grouping(Builder builder) {
                super(builder);
                this.name = builder.name;
                this.description = builder.description;
            }

            public org.linuxforhealth.fhir.model.type.String getName() {
                return this.name;
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.description != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.description, "description", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Grouping other = (Grouping)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.description);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String name;
                private org.linuxforhealth.fhir.model.type.String description;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(String name) {
                    this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                    return this;
                }

                public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                    this.name = name;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                @Override
                public Grouping build() {
                    Grouping grouping = new Grouping(this);
                    if (this.validating) {
                        this.validate(grouping);
                    }
                    return grouping;
                }

                protected void validate(Grouping grouping) {
                    super.validate(grouping);
                    ValidationSupport.requireNonNull(grouping.name, "name");
                    ValidationSupport.requireValueOrChildren(grouping);
                }

                protected Builder from(Grouping grouping) {
                    super.from(grouping);
                    this.name = grouping.name;
                    this.description = grouping.description;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Grouping> grouping = new ArrayList<Grouping>();
            private List<Resource> resource = new ArrayList<Resource>();
            private Page page;
            private List<Parameter> parameter = new ArrayList<Parameter>();
            private List<Template> template = new ArrayList<Template>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder grouping(Grouping ... grouping) {
                for (Grouping value : grouping) {
                    this.grouping.add(value);
                }
                return this;
            }

            public Builder grouping(Collection<Grouping> grouping) {
                this.grouping = new ArrayList<Grouping>(grouping);
                return this;
            }

            public Builder resource(Resource ... resource) {
                for (Resource value : resource) {
                    this.resource.add(value);
                }
                return this;
            }

            public Builder resource(Collection<Resource> resource) {
                this.resource = new ArrayList<Resource>(resource);
                return this;
            }

            public Builder page(Page page) {
                this.page = page;
                return this;
            }

            public Builder parameter(Parameter ... parameter) {
                for (Parameter value : parameter) {
                    this.parameter.add(value);
                }
                return this;
            }

            public Builder parameter(Collection<Parameter> parameter) {
                this.parameter = new ArrayList<Parameter>(parameter);
                return this;
            }

            public Builder template(Template ... template) {
                for (Template value : template) {
                    this.template.add(value);
                }
                return this;
            }

            public Builder template(Collection<Template> template) {
                this.template = new ArrayList<Template>(template);
                return this;
            }

            @Override
            public Definition build() {
                Definition definition = new Definition(this);
                if (this.validating) {
                    this.validate(definition);
                }
                return definition;
            }

            protected void validate(Definition definition) {
                super.validate(definition);
                ValidationSupport.checkList(definition.grouping, "grouping", Grouping.class);
                ValidationSupport.checkNonEmptyList(definition.resource, "resource", Resource.class);
                ValidationSupport.checkList(definition.parameter, "parameter", Parameter.class);
                ValidationSupport.checkList(definition.template, "template", Template.class);
                ValidationSupport.requireValueOrChildren(definition);
            }

            protected Builder from(Definition definition) {
                super.from(definition);
                this.grouping.addAll(definition.grouping);
                this.resource.addAll(definition.resource);
                this.page = definition.page;
                this.parameter.addAll(definition.parameter);
                this.template.addAll(definition.template);
                return this;
            }
        }
    }

    public static class Global
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ResourceType", strength=BindingStrength.Value.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.3.0")
        @Required
        private final ResourceTypeCode type;
        @Summary
        @Required
        private final Canonical profile;

        private Global(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.profile = builder.profile;
        }

        public ResourceTypeCode getType() {
            return this.type;
        }

        public Canonical getProfile() {
            return this.profile;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.profile != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.profile, "profile", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.profile, other.profile);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.profile);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ResourceTypeCode type;
            private Canonical profile;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(ResourceTypeCode type) {
                this.type = type;
                return this;
            }

            public Builder profile(Canonical profile) {
                this.profile = profile;
                return this;
            }

            @Override
            public Global build() {
                Global global = new Global(this);
                if (this.validating) {
                    this.validate(global);
                }
                return global;
            }

            protected void validate(Global global) {
                super.validate(global);
                ValidationSupport.requireNonNull(global.type, "type");
                ValidationSupport.requireNonNull(global.profile, "profile");
                ValidationSupport.requireValueOrChildren(global);
            }

            protected Builder from(Global global) {
                super.from(global);
                this.type = global.type;
                this.profile = global.profile;
                return this;
            }
        }
    }

    public static class DependsOn
    extends BackboneElement {
        @Summary
        @Required
        private final Canonical uri;
        @Summary
        private final Id packageId;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String version;

        private DependsOn(Builder builder) {
            super(builder);
            this.uri = builder.uri;
            this.packageId = builder.packageId;
            this.version = builder.version;
        }

        public Canonical getUri() {
            return this.uri;
        }

        public Id getPackageId() {
            return this.packageId;
        }

        public org.linuxforhealth.fhir.model.type.String getVersion() {
            return this.version;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.uri != null || this.packageId != null || this.version != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.uri, "uri", visitor);
                    this.accept(this.packageId, "packageId", visitor);
                    this.accept(this.version, "version", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependsOn other = (DependsOn)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.uri, other.uri) && Objects.equals(this.packageId, other.packageId) && Objects.equals(this.version, other.version);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.uri, this.packageId, this.version);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Canonical uri;
            private Id packageId;
            private org.linuxforhealth.fhir.model.type.String version;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder uri(Canonical uri) {
                this.uri = uri;
                return this;
            }

            public Builder packageId(Id packageId) {
                this.packageId = packageId;
                return this;
            }

            public Builder version(String version) {
                this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
                return this;
            }

            public Builder version(org.linuxforhealth.fhir.model.type.String version) {
                this.version = version;
                return this;
            }

            @Override
            public DependsOn build() {
                DependsOn dependsOn = new DependsOn(this);
                if (this.validating) {
                    this.validate(dependsOn);
                }
                return dependsOn;
            }

            protected void validate(DependsOn dependsOn) {
                super.validate(dependsOn);
                ValidationSupport.requireNonNull(dependsOn.uri, "uri");
                ValidationSupport.requireValueOrChildren(dependsOn);
            }

            protected Builder from(DependsOn dependsOn) {
                super.from(dependsOn);
                this.uri = dependsOn.uri;
                this.packageId = dependsOn.packageId;
                this.version = dependsOn.version;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private org.linuxforhealth.fhir.model.type.String version;
        private org.linuxforhealth.fhir.model.type.String name;
        private org.linuxforhealth.fhir.model.type.String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown copyright;
        private Id packageId;
        private SPDXLicense license;
        private List<FHIRVersion> fhirVersion = new ArrayList<FHIRVersion>();
        private List<DependsOn> dependsOn = new ArrayList<DependsOn>();
        private List<Global> global = new ArrayList<Global>();
        private Definition definition;
        private Manifest manifest;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
            return this;
        }

        public Builder title(org.linuxforhealth.fhir.model.type.String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder packageId(Id packageId) {
            this.packageId = packageId;
            return this;
        }

        public Builder license(SPDXLicense license) {
            this.license = license;
            return this;
        }

        public Builder fhirVersion(FHIRVersion ... fhirVersion) {
            for (FHIRVersion value : fhirVersion) {
                this.fhirVersion.add(value);
            }
            return this;
        }

        public Builder fhirVersion(Collection<FHIRVersion> fhirVersion) {
            this.fhirVersion = new ArrayList<FHIRVersion>(fhirVersion);
            return this;
        }

        public Builder dependsOn(DependsOn ... dependsOn) {
            for (DependsOn value : dependsOn) {
                this.dependsOn.add(value);
            }
            return this;
        }

        public Builder dependsOn(Collection<DependsOn> dependsOn) {
            this.dependsOn = new ArrayList<DependsOn>(dependsOn);
            return this;
        }

        public Builder global(Global ... global) {
            for (Global value : global) {
                this.global.add(value);
            }
            return this;
        }

        public Builder global(Collection<Global> global) {
            this.global = new ArrayList<Global>(global);
            return this;
        }

        public Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public Builder manifest(Manifest manifest) {
            this.manifest = manifest;
            return this;
        }

        @Override
        public ImplementationGuide build() {
            ImplementationGuide implementationGuide = new ImplementationGuide(this);
            if (this.validating) {
                this.validate(implementationGuide);
            }
            return implementationGuide;
        }

        protected void validate(ImplementationGuide implementationGuide) {
            super.validate(implementationGuide);
            ValidationSupport.requireNonNull(implementationGuide.url, "url");
            ValidationSupport.requireNonNull(implementationGuide.name, "name");
            ValidationSupport.requireNonNull(implementationGuide.status, "status");
            ValidationSupport.checkList(implementationGuide.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(implementationGuide.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(implementationGuide.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.requireNonNull(implementationGuide.packageId, "packageId");
            ValidationSupport.checkNonEmptyList(implementationGuide.fhirVersion, "fhirVersion", FHIRVersion.class);
            ValidationSupport.checkList(implementationGuide.dependsOn, "dependsOn", DependsOn.class);
            ValidationSupport.checkList(implementationGuide.global, "global", Global.class);
        }

        protected Builder from(ImplementationGuide implementationGuide) {
            super.from(implementationGuide);
            this.url = implementationGuide.url;
            this.version = implementationGuide.version;
            this.name = implementationGuide.name;
            this.title = implementationGuide.title;
            this.status = implementationGuide.status;
            this.experimental = implementationGuide.experimental;
            this.date = implementationGuide.date;
            this.publisher = implementationGuide.publisher;
            this.contact.addAll(implementationGuide.contact);
            this.description = implementationGuide.description;
            this.useContext.addAll(implementationGuide.useContext);
            this.jurisdiction.addAll(implementationGuide.jurisdiction);
            this.copyright = implementationGuide.copyright;
            this.packageId = implementationGuide.packageId;
            this.license = implementationGuide.license;
            this.fhirVersion.addAll(implementationGuide.fhirVersion);
            this.dependsOn.addAll(implementationGuide.dependsOn);
            this.global.addAll(implementationGuide.global);
            this.definition = implementationGuide.definition;
            this.manifest = implementationGuide.manifest;
            return this;
        }
    }
}

