/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Ratio;
import org.linuxforhealth.fhir.model.type.RatioRange;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.IngredientManufacturerRole;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="ing-1", level="Rule", location="(base)", description="If an ingredient is noted as an allergen (allergenicIndicator) then its substance should be a code. If the substance is a SubstanceDefinition, then the allegen information should be documented in that resource", expression="(Ingredient.allergenicIndicator.where(value='true').count() + Ingredient.substance.code.reference.count())  < 2", source="http://hl7.org/fhir/StructureDefinition/Ingredient")
public class Ingredient
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    @ReferenceTarget(value={"MedicinalProductDefinition", "AdministrableProductDefinition", "ManufacturedItemDefinition"})
    private final List<Reference> _for;
    @Summary
    @Binding(bindingName="IngredientRole", strength=BindingStrength.Value.EXAMPLE, description="A classification of the ingredient identifying its purpose within the product, e.g. active, inactive.", valueSet="http://hl7.org/fhir/ValueSet/ingredient-role")
    @Required
    private final CodeableConcept role;
    @Summary
    @Binding(bindingName="IngredientFunction", strength=BindingStrength.Value.EXAMPLE, description="A classification of the ingredient identifying its precise purpose(s) in the drug product (beyond e.g. active/inactive).", valueSet="http://hl7.org/fhir/ValueSet/ingredient-function")
    private final List<CodeableConcept> function;
    @Summary
    private final Boolean allergenicIndicator;
    @Summary
    private final List<Manufacturer> manufacturer;
    @Summary
    @Required
    private final Substance substance;

    private Ingredient(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.status = builder.status;
        this._for = Collections.unmodifiableList(builder._for);
        this.role = builder.role;
        this.function = Collections.unmodifiableList(builder.function);
        this.allergenicIndicator = builder.allergenicIndicator;
        this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        this.substance = builder.substance;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public List<Reference> getFor() {
        return this._for;
    }

    public CodeableConcept getRole() {
        return this.role;
    }

    public List<CodeableConcept> getFunction() {
        return this.function;
    }

    public Boolean getAllergenicIndicator() {
        return this.allergenicIndicator;
    }

    public List<Manufacturer> getManufacturer() {
        return this.manufacturer;
    }

    public Substance getSubstance() {
        return this.substance;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.status != null || !this._for.isEmpty() || this.role != null || !this.function.isEmpty() || this.allergenicIndicator != null || !this.manufacturer.isEmpty() || this.substance != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this._for, "for", visitor, Reference.class);
                this.accept(this.role, "role", visitor);
                this.accept(this.function, "function", visitor, CodeableConcept.class);
                this.accept(this.allergenicIndicator, "allergenicIndicator", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor, Manufacturer.class);
                this.accept(this.substance, "substance", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ingredient other = (Ingredient)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this._for, other._for) && Objects.equals(this.role, other.role) && Objects.equals(this.function, other.function) && Objects.equals(this.allergenicIndicator, other.allergenicIndicator) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.substance, other.substance);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this._for, this.role, this.function, this.allergenicIndicator, this.manufacturer, this.substance);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Substance
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SNOMEDCTSubstanceCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all substance codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
        @Required
        private final CodeableReference code;
        @Summary
        private final List<Strength> strength;

        private Substance(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.strength = Collections.unmodifiableList(builder.strength);
        }

        public CodeableReference getCode() {
            return this.code;
        }

        public List<Strength> getStrength() {
            return this.strength;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || !this.strength.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.strength, "strength", visitor, Strength.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Substance other = (Substance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.strength, other.strength);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.strength);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Strength
        extends BackboneElement {
            @Summary
            @Choice(value={Ratio.class, RatioRange.class})
            private final Element presentation;
            @Summary
            private final org.linuxforhealth.fhir.model.type.String textPresentation;
            @Summary
            @Choice(value={Ratio.class, RatioRange.class})
            private final Element concentration;
            @Summary
            private final org.linuxforhealth.fhir.model.type.String textConcentration;
            @Summary
            private final org.linuxforhealth.fhir.model.type.String measurementPoint;
            @Summary
            @Binding(bindingName="Country", strength=BindingStrength.Value.EXAMPLE, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/country")
            private final List<CodeableConcept> country;
            @Summary
            private final List<ReferenceStrength> referenceStrength;

            private Strength(Builder builder) {
                super(builder);
                this.presentation = builder.presentation;
                this.textPresentation = builder.textPresentation;
                this.concentration = builder.concentration;
                this.textConcentration = builder.textConcentration;
                this.measurementPoint = builder.measurementPoint;
                this.country = Collections.unmodifiableList(builder.country);
                this.referenceStrength = Collections.unmodifiableList(builder.referenceStrength);
            }

            public Element getPresentation() {
                return this.presentation;
            }

            public org.linuxforhealth.fhir.model.type.String getTextPresentation() {
                return this.textPresentation;
            }

            public Element getConcentration() {
                return this.concentration;
            }

            public org.linuxforhealth.fhir.model.type.String getTextConcentration() {
                return this.textConcentration;
            }

            public org.linuxforhealth.fhir.model.type.String getMeasurementPoint() {
                return this.measurementPoint;
            }

            public List<CodeableConcept> getCountry() {
                return this.country;
            }

            public List<ReferenceStrength> getReferenceStrength() {
                return this.referenceStrength;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.presentation != null || this.textPresentation != null || this.concentration != null || this.textConcentration != null || this.measurementPoint != null || !this.country.isEmpty() || !this.referenceStrength.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.presentation, "presentation", visitor);
                        this.accept(this.textPresentation, "textPresentation", visitor);
                        this.accept(this.concentration, "concentration", visitor);
                        this.accept(this.textConcentration, "textConcentration", visitor);
                        this.accept(this.measurementPoint, "measurementPoint", visitor);
                        this.accept(this.country, "country", visitor, CodeableConcept.class);
                        this.accept(this.referenceStrength, "referenceStrength", visitor, ReferenceStrength.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Strength other = (Strength)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.presentation, other.presentation) && Objects.equals(this.textPresentation, other.textPresentation) && Objects.equals(this.concentration, other.concentration) && Objects.equals(this.textConcentration, other.textConcentration) && Objects.equals(this.measurementPoint, other.measurementPoint) && Objects.equals(this.country, other.country) && Objects.equals(this.referenceStrength, other.referenceStrength);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.presentation, this.textPresentation, this.concentration, this.textConcentration, this.measurementPoint, this.country, this.referenceStrength);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class ReferenceStrength
            extends BackboneElement {
                @Summary
                @Binding(bindingName="SNOMEDCTSubstanceCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all substance codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
                private final CodeableReference substance;
                @Summary
                @Choice(value={Ratio.class, RatioRange.class})
                @Required
                private final Element strength;
                @Summary
                private final org.linuxforhealth.fhir.model.type.String measurementPoint;
                @Summary
                @Binding(bindingName="Country", strength=BindingStrength.Value.EXAMPLE, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/country")
                private final List<CodeableConcept> country;

                private ReferenceStrength(Builder builder) {
                    super(builder);
                    this.substance = builder.substance;
                    this.strength = builder.strength;
                    this.measurementPoint = builder.measurementPoint;
                    this.country = Collections.unmodifiableList(builder.country);
                }

                public CodeableReference getSubstance() {
                    return this.substance;
                }

                public Element getStrength() {
                    return this.strength;
                }

                public org.linuxforhealth.fhir.model.type.String getMeasurementPoint() {
                    return this.measurementPoint;
                }

                public List<CodeableConcept> getCountry() {
                    return this.country;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.substance != null || this.strength != null || this.measurementPoint != null || !this.country.isEmpty();
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.substance, "substance", visitor);
                            this.accept(this.strength, "strength", visitor);
                            this.accept(this.measurementPoint, "measurementPoint", visitor);
                            this.accept(this.country, "country", visitor, CodeableConcept.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    ReferenceStrength other = (ReferenceStrength)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.substance, other.substance) && Objects.equals(this.strength, other.strength) && Objects.equals(this.measurementPoint, other.measurementPoint) && Objects.equals(this.country, other.country);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.substance, this.strength, this.measurementPoint, this.country);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableReference substance;
                    private Element strength;
                    private org.linuxforhealth.fhir.model.type.String measurementPoint;
                    private List<CodeableConcept> country = new ArrayList<CodeableConcept>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder substance(CodeableReference substance) {
                        this.substance = substance;
                        return this;
                    }

                    public Builder strength(Element strength) {
                        this.strength = strength;
                        return this;
                    }

                    public Builder measurementPoint(String measurementPoint) {
                        this.measurementPoint = measurementPoint == null ? null : org.linuxforhealth.fhir.model.type.String.of(measurementPoint);
                        return this;
                    }

                    public Builder measurementPoint(org.linuxforhealth.fhir.model.type.String measurementPoint) {
                        this.measurementPoint = measurementPoint;
                        return this;
                    }

                    public Builder country(CodeableConcept ... country) {
                        for (CodeableConcept value : country) {
                            this.country.add(value);
                        }
                        return this;
                    }

                    public Builder country(Collection<CodeableConcept> country) {
                        this.country = new ArrayList<CodeableConcept>(country);
                        return this;
                    }

                    @Override
                    public ReferenceStrength build() {
                        ReferenceStrength referenceStrength = new ReferenceStrength(this);
                        if (this.validating) {
                            this.validate(referenceStrength);
                        }
                        return referenceStrength;
                    }

                    protected void validate(ReferenceStrength referenceStrength) {
                        super.validate(referenceStrength);
                        ValidationSupport.requireChoiceElement(referenceStrength.strength, "strength", Ratio.class, RatioRange.class);
                        ValidationSupport.checkList(referenceStrength.country, "country", CodeableConcept.class);
                        ValidationSupport.requireValueOrChildren(referenceStrength);
                    }

                    protected Builder from(ReferenceStrength referenceStrength) {
                        super.from(referenceStrength);
                        this.substance = referenceStrength.substance;
                        this.strength = referenceStrength.strength;
                        this.measurementPoint = referenceStrength.measurementPoint;
                        this.country.addAll(referenceStrength.country);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element presentation;
                private org.linuxforhealth.fhir.model.type.String textPresentation;
                private Element concentration;
                private org.linuxforhealth.fhir.model.type.String textConcentration;
                private org.linuxforhealth.fhir.model.type.String measurementPoint;
                private List<CodeableConcept> country = new ArrayList<CodeableConcept>();
                private List<ReferenceStrength> referenceStrength = new ArrayList<ReferenceStrength>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder presentation(Element presentation) {
                    this.presentation = presentation;
                    return this;
                }

                public Builder textPresentation(String textPresentation) {
                    this.textPresentation = textPresentation == null ? null : org.linuxforhealth.fhir.model.type.String.of(textPresentation);
                    return this;
                }

                public Builder textPresentation(org.linuxforhealth.fhir.model.type.String textPresentation) {
                    this.textPresentation = textPresentation;
                    return this;
                }

                public Builder concentration(Element concentration) {
                    this.concentration = concentration;
                    return this;
                }

                public Builder textConcentration(String textConcentration) {
                    this.textConcentration = textConcentration == null ? null : org.linuxforhealth.fhir.model.type.String.of(textConcentration);
                    return this;
                }

                public Builder textConcentration(org.linuxforhealth.fhir.model.type.String textConcentration) {
                    this.textConcentration = textConcentration;
                    return this;
                }

                public Builder measurementPoint(String measurementPoint) {
                    this.measurementPoint = measurementPoint == null ? null : org.linuxforhealth.fhir.model.type.String.of(measurementPoint);
                    return this;
                }

                public Builder measurementPoint(org.linuxforhealth.fhir.model.type.String measurementPoint) {
                    this.measurementPoint = measurementPoint;
                    return this;
                }

                public Builder country(CodeableConcept ... country) {
                    for (CodeableConcept value : country) {
                        this.country.add(value);
                    }
                    return this;
                }

                public Builder country(Collection<CodeableConcept> country) {
                    this.country = new ArrayList<CodeableConcept>(country);
                    return this;
                }

                public Builder referenceStrength(ReferenceStrength ... referenceStrength) {
                    for (ReferenceStrength value : referenceStrength) {
                        this.referenceStrength.add(value);
                    }
                    return this;
                }

                public Builder referenceStrength(Collection<ReferenceStrength> referenceStrength) {
                    this.referenceStrength = new ArrayList<ReferenceStrength>(referenceStrength);
                    return this;
                }

                @Override
                public Strength build() {
                    Strength strength = new Strength(this);
                    if (this.validating) {
                        this.validate(strength);
                    }
                    return strength;
                }

                protected void validate(Strength strength) {
                    super.validate(strength);
                    ValidationSupport.choiceElement(strength.presentation, "presentation", Ratio.class, RatioRange.class);
                    ValidationSupport.choiceElement(strength.concentration, "concentration", Ratio.class, RatioRange.class);
                    ValidationSupport.checkList(strength.country, "country", CodeableConcept.class);
                    ValidationSupport.checkList(strength.referenceStrength, "referenceStrength", ReferenceStrength.class);
                    ValidationSupport.requireValueOrChildren(strength);
                }

                protected Builder from(Strength strength) {
                    super.from(strength);
                    this.presentation = strength.presentation;
                    this.textPresentation = strength.textPresentation;
                    this.concentration = strength.concentration;
                    this.textConcentration = strength.textConcentration;
                    this.measurementPoint = strength.measurementPoint;
                    this.country.addAll(strength.country);
                    this.referenceStrength.addAll(strength.referenceStrength);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference code;
            private List<Strength> strength = new ArrayList<Strength>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableReference code) {
                this.code = code;
                return this;
            }

            public Builder strength(Strength ... strength) {
                for (Strength value : strength) {
                    this.strength.add(value);
                }
                return this;
            }

            public Builder strength(Collection<Strength> strength) {
                this.strength = new ArrayList<Strength>(strength);
                return this;
            }

            @Override
            public Substance build() {
                Substance substance = new Substance(this);
                if (this.validating) {
                    this.validate(substance);
                }
                return substance;
            }

            protected void validate(Substance substance) {
                super.validate(substance);
                ValidationSupport.requireNonNull(substance.code, "code");
                ValidationSupport.checkList(substance.strength, "strength", Strength.class);
                ValidationSupport.requireValueOrChildren(substance);
            }

            protected Builder from(Substance substance) {
                super.from(substance);
                this.code = substance.code;
                this.strength.addAll(substance.strength);
                return this;
            }
        }
    }

    public static class Manufacturer
    extends BackboneElement {
        @Summary
        @Binding(bindingName="IngredientManufacturerRole", strength=BindingStrength.Value.REQUIRED, description="The way in which this manufacturer is associated with the ingredient.", valueSet="http://hl7.org/fhir/ValueSet/ingredient-manufacturer-role|4.3.0")
        private final IngredientManufacturerRole role;
        @Summary
        @ReferenceTarget(value={"Organization"})
        @Required
        private final Reference manufacturer;

        private Manufacturer(Builder builder) {
            super(builder);
            this.role = builder.role;
            this.manufacturer = builder.manufacturer;
        }

        public IngredientManufacturerRole getRole() {
            return this.role;
        }

        public Reference getManufacturer() {
            return this.manufacturer;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.role != null || this.manufacturer != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.manufacturer, "manufacturer", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Manufacturer other = (Manufacturer)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.role, other.role) && Objects.equals(this.manufacturer, other.manufacturer);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.role, this.manufacturer);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private IngredientManufacturerRole role;
            private Reference manufacturer;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder role(IngredientManufacturerRole role) {
                this.role = role;
                return this;
            }

            public Builder manufacturer(Reference manufacturer) {
                this.manufacturer = manufacturer;
                return this;
            }

            @Override
            public Manufacturer build() {
                Manufacturer manufacturer = new Manufacturer(this);
                if (this.validating) {
                    this.validate(manufacturer);
                }
                return manufacturer;
            }

            protected void validate(Manufacturer manufacturer) {
                super.validate(manufacturer);
                ValidationSupport.requireNonNull(manufacturer.manufacturer, "manufacturer");
                ValidationSupport.checkReferenceType(manufacturer.manufacturer, "manufacturer", "Organization");
                ValidationSupport.requireValueOrChildren(manufacturer);
            }

            protected Builder from(Manufacturer manufacturer) {
                super.from(manufacturer);
                this.role = manufacturer.role;
                this.manufacturer = manufacturer.manufacturer;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private PublicationStatus status;
        private List<Reference> _for = new ArrayList<Reference>();
        private CodeableConcept role;
        private List<CodeableConcept> function = new ArrayList<CodeableConcept>();
        private Boolean allergenicIndicator;
        private List<Manufacturer> manufacturer = new ArrayList<Manufacturer>();
        private Substance substance;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder _for(Reference ... _for) {
            for (Reference value : _for) {
                this._for.add(value);
            }
            return this;
        }

        public Builder _for(Collection<Reference> _for) {
            this._for = new ArrayList<Reference>(_for);
            return this;
        }

        public Builder role(CodeableConcept role) {
            this.role = role;
            return this;
        }

        public Builder function(CodeableConcept ... function) {
            for (CodeableConcept value : function) {
                this.function.add(value);
            }
            return this;
        }

        public Builder function(Collection<CodeableConcept> function) {
            this.function = new ArrayList<CodeableConcept>(function);
            return this;
        }

        public Builder allergenicIndicator(java.lang.Boolean allergenicIndicator) {
            this.allergenicIndicator = allergenicIndicator == null ? null : Boolean.of(allergenicIndicator);
            return this;
        }

        public Builder allergenicIndicator(Boolean allergenicIndicator) {
            this.allergenicIndicator = allergenicIndicator;
            return this;
        }

        public Builder manufacturer(Manufacturer ... manufacturer) {
            for (Manufacturer value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Manufacturer> manufacturer) {
            this.manufacturer = new ArrayList<Manufacturer>(manufacturer);
            return this;
        }

        public Builder substance(Substance substance) {
            this.substance = substance;
            return this;
        }

        @Override
        public Ingredient build() {
            Ingredient ingredient = new Ingredient(this);
            if (this.validating) {
                this.validate(ingredient);
            }
            return ingredient;
        }

        protected void validate(Ingredient ingredient) {
            super.validate(ingredient);
            ValidationSupport.requireNonNull(ingredient.status, "status");
            ValidationSupport.checkList(ingredient._for, "for", Reference.class);
            ValidationSupport.requireNonNull(ingredient.role, "role");
            ValidationSupport.checkList(ingredient.function, "function", CodeableConcept.class);
            ValidationSupport.checkList(ingredient.manufacturer, "manufacturer", Manufacturer.class);
            ValidationSupport.requireNonNull(ingredient.substance, "substance");
            ValidationSupport.checkReferenceType(ingredient._for, "for", "MedicinalProductDefinition", "AdministrableProductDefinition", "ManufacturedItemDefinition");
        }

        protected Builder from(Ingredient ingredient) {
            super.from(ingredient);
            this.identifier = ingredient.identifier;
            this.status = ingredient.status;
            this._for.addAll(ingredient._for);
            this.role = ingredient.role;
            this.function.addAll(ingredient.function);
            this.allergenicIndicator = ingredient.allergenicIndicator;
            this.manufacturer.addAll(ingredient.manufacturer);
            this.substance = ingredient.substance;
            return this;
        }
    }
}

