/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Address;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.HumanName;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Money;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.PositiveInt;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="ipn-1", level="Rule", location="(base)", description="The organization SHALL at least have a name or an identifier, and possibly more than one", expression="(identifier.count() + name.count()) > 0", source="http://hl7.org/fhir/StructureDefinition/InsurancePlan"), @Constraint(id="insurancePlan-2", level="Warning", location="contact.purpose", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/contactentity-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/contactentity-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/InsurancePlan", generated=true)})
public class InsurancePlan
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    private final PublicationStatus status;
    @Summary
    @Binding(bindingName="InsurancePlanType", strength=BindingStrength.Value.EXAMPLE, description="Used to categorize the product/plan.", valueSet="http://hl7.org/fhir/ValueSet/insuranceplan-type")
    private final List<CodeableConcept> type;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    private final List<org.linuxforhealth.fhir.model.type.String> alias;
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference ownedBy;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference administeredBy;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final List<Reference> coverageArea;
    private final List<Contact> contact;
    @ReferenceTarget(value={"Endpoint"})
    private final List<Reference> endpoint;
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> network;
    private final List<Coverage> coverage;
    private final List<Plan> plan;

    private InsurancePlan(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.type = Collections.unmodifiableList(builder.type);
        this.name = builder.name;
        this.alias = Collections.unmodifiableList(builder.alias);
        this.period = builder.period;
        this.ownedBy = builder.ownedBy;
        this.administeredBy = builder.administeredBy;
        this.coverageArea = Collections.unmodifiableList(builder.coverageArea);
        this.contact = Collections.unmodifiableList(builder.contact);
        this.endpoint = Collections.unmodifiableList(builder.endpoint);
        this.network = Collections.unmodifiableList(builder.network);
        this.coverage = Collections.unmodifiableList(builder.coverage);
        this.plan = Collections.unmodifiableList(builder.plan);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public List<org.linuxforhealth.fhir.model.type.String> getAlias() {
        return this.alias;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getOwnedBy() {
        return this.ownedBy;
    }

    public Reference getAdministeredBy() {
        return this.administeredBy;
    }

    public List<Reference> getCoverageArea() {
        return this.coverageArea;
    }

    public List<Contact> getContact() {
        return this.contact;
    }

    public List<Reference> getEndpoint() {
        return this.endpoint;
    }

    public List<Reference> getNetwork() {
        return this.network;
    }

    public List<Coverage> getCoverage() {
        return this.coverage;
    }

    public List<Plan> getPlan() {
        return this.plan;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.type.isEmpty() || this.name != null || !this.alias.isEmpty() || this.period != null || this.ownedBy != null || this.administeredBy != null || !this.coverageArea.isEmpty() || !this.contact.isEmpty() || !this.endpoint.isEmpty() || !this.network.isEmpty() || !this.coverage.isEmpty() || !this.plan.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor, CodeableConcept.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.alias, "alias", visitor, org.linuxforhealth.fhir.model.type.String.class);
                this.accept(this.period, "period", visitor);
                this.accept(this.ownedBy, "ownedBy", visitor);
                this.accept(this.administeredBy, "administeredBy", visitor);
                this.accept(this.coverageArea, "coverageArea", visitor, Reference.class);
                this.accept(this.contact, "contact", visitor, Contact.class);
                this.accept(this.endpoint, "endpoint", visitor, Reference.class);
                this.accept(this.network, "network", visitor, Reference.class);
                this.accept(this.coverage, "coverage", visitor, Coverage.class);
                this.accept(this.plan, "plan", visitor, Plan.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InsurancePlan other = (InsurancePlan)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.alias, other.alias) && Objects.equals(this.period, other.period) && Objects.equals(this.ownedBy, other.ownedBy) && Objects.equals(this.administeredBy, other.administeredBy) && Objects.equals(this.coverageArea, other.coverageArea) && Objects.equals(this.contact, other.contact) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.network, other.network) && Objects.equals(this.coverage, other.coverage) && Objects.equals(this.plan, other.plan);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.type, this.name, this.alias, this.period, this.ownedBy, this.administeredBy, this.coverageArea, this.contact, this.endpoint, this.network, this.coverage, this.plan);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Plan
    extends BackboneElement {
        @Summary
        private final List<Identifier> identifier;
        private final CodeableConcept type;
        @Summary
        @ReferenceTarget(value={"Location"})
        private final List<Reference> coverageArea;
        @ReferenceTarget(value={"Organization"})
        private final List<Reference> network;
        private final List<GeneralCost> generalCost;
        private final List<SpecificCost> specificCost;

        private Plan(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.type = builder.type;
            this.coverageArea = Collections.unmodifiableList(builder.coverageArea);
            this.network = Collections.unmodifiableList(builder.network);
            this.generalCost = Collections.unmodifiableList(builder.generalCost);
            this.specificCost = Collections.unmodifiableList(builder.specificCost);
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<Reference> getCoverageArea() {
            return this.coverageArea;
        }

        public List<Reference> getNetwork() {
            return this.network;
        }

        public List<GeneralCost> getGeneralCost() {
            return this.generalCost;
        }

        public List<SpecificCost> getSpecificCost() {
            return this.specificCost;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || !this.coverageArea.isEmpty() || !this.network.isEmpty() || !this.generalCost.isEmpty() || !this.specificCost.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.coverageArea, "coverageArea", visitor, Reference.class);
                    this.accept(this.network, "network", visitor, Reference.class);
                    this.accept(this.generalCost, "generalCost", visitor, GeneralCost.class);
                    this.accept(this.specificCost, "specificCost", visitor, SpecificCost.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Plan other = (Plan)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.coverageArea, other.coverageArea) && Objects.equals(this.network, other.network) && Objects.equals(this.generalCost, other.generalCost) && Objects.equals(this.specificCost, other.specificCost);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.type, this.coverageArea, this.network, this.generalCost, this.specificCost);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class SpecificCost
        extends BackboneElement {
            @Required
            private final CodeableConcept category;
            private final List<Benefit> benefit;

            private SpecificCost(Builder builder) {
                super(builder);
                this.category = builder.category;
                this.benefit = Collections.unmodifiableList(builder.benefit);
            }

            public CodeableConcept getCategory() {
                return this.category;
            }

            public List<Benefit> getBenefit() {
                return this.benefit;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.category != null || !this.benefit.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.category, "category", visitor);
                        this.accept(this.benefit, "benefit", visitor, Benefit.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SpecificCost other = (SpecificCost)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.benefit, other.benefit);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.category, this.benefit);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Benefit
            extends BackboneElement {
                @Required
                private final CodeableConcept type;
                private final List<Cost> cost;

                private Benefit(Builder builder) {
                    super(builder);
                    this.type = builder.type;
                    this.cost = Collections.unmodifiableList(builder.cost);
                }

                public CodeableConcept getType() {
                    return this.type;
                }

                public List<Cost> getCost() {
                    return this.cost;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.type != null || !this.cost.isEmpty();
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.cost, "cost", visitor, Cost.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Benefit other = (Benefit)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.cost, other.cost);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.cost);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Cost
                extends BackboneElement {
                    @Required
                    private final CodeableConcept type;
                    @Binding(bindingName="BenefitCostApplicability", strength=BindingStrength.Value.REQUIRED, description="Whether the cost applies to in-network or out-of-network providers.", valueSet="http://hl7.org/fhir/ValueSet/insuranceplan-applicability|4.3.0")
                    private final CodeableConcept applicability;
                    private final List<CodeableConcept> qualifiers;
                    private final Quantity value;

                    private Cost(Builder builder) {
                        super(builder);
                        this.type = builder.type;
                        this.applicability = builder.applicability;
                        this.qualifiers = Collections.unmodifiableList(builder.qualifiers);
                        this.value = builder.value;
                    }

                    public CodeableConcept getType() {
                        return this.type;
                    }

                    public CodeableConcept getApplicability() {
                        return this.applicability;
                    }

                    public List<CodeableConcept> getQualifiers() {
                        return this.qualifiers;
                    }

                    public Quantity getValue() {
                        return this.value;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.type != null || this.applicability != null || !this.qualifiers.isEmpty() || this.value != null;
                    }

                    @Override
                    public void accept(String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.type, "type", visitor);
                                this.accept(this.applicability, "applicability", visitor);
                                this.accept(this.qualifiers, "qualifiers", visitor, CodeableConcept.class);
                                this.accept(this.value, "value", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Cost other = (Cost)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.applicability, other.applicability) && Objects.equals(this.qualifiers, other.qualifiers) && Objects.equals(this.value, other.value);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.applicability, this.qualifiers, this.value);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private CodeableConcept type;
                        private CodeableConcept applicability;
                        private List<CodeableConcept> qualifiers = new ArrayList<CodeableConcept>();
                        private Quantity value;

                        private Builder() {
                        }

                        @Override
                        public Builder id(String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder type(CodeableConcept type) {
                            this.type = type;
                            return this;
                        }

                        public Builder applicability(CodeableConcept applicability) {
                            this.applicability = applicability;
                            return this;
                        }

                        public Builder qualifiers(CodeableConcept ... qualifiers) {
                            for (CodeableConcept value : qualifiers) {
                                this.qualifiers.add(value);
                            }
                            return this;
                        }

                        public Builder qualifiers(Collection<CodeableConcept> qualifiers) {
                            this.qualifiers = new ArrayList<CodeableConcept>(qualifiers);
                            return this;
                        }

                        public Builder value(Quantity value) {
                            this.value = value;
                            return this;
                        }

                        @Override
                        public Cost build() {
                            Cost cost = new Cost(this);
                            if (this.validating) {
                                this.validate(cost);
                            }
                            return cost;
                        }

                        protected void validate(Cost cost) {
                            super.validate(cost);
                            ValidationSupport.requireNonNull(cost.type, "type");
                            ValidationSupport.checkList(cost.qualifiers, "qualifiers", CodeableConcept.class);
                            ValidationSupport.requireValueOrChildren(cost);
                        }

                        protected Builder from(Cost cost) {
                            super.from(cost);
                            this.type = cost.type;
                            this.applicability = cost.applicability;
                            this.qualifiers.addAll(cost.qualifiers);
                            this.value = cost.value;
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept type;
                    private List<Cost> cost = new ArrayList<Cost>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder type(CodeableConcept type) {
                        this.type = type;
                        return this;
                    }

                    public Builder cost(Cost ... cost) {
                        for (Cost value : cost) {
                            this.cost.add(value);
                        }
                        return this;
                    }

                    public Builder cost(Collection<Cost> cost) {
                        this.cost = new ArrayList<Cost>(cost);
                        return this;
                    }

                    @Override
                    public Benefit build() {
                        Benefit benefit = new Benefit(this);
                        if (this.validating) {
                            this.validate(benefit);
                        }
                        return benefit;
                    }

                    protected void validate(Benefit benefit) {
                        super.validate(benefit);
                        ValidationSupport.requireNonNull(benefit.type, "type");
                        ValidationSupport.checkList(benefit.cost, "cost", Cost.class);
                        ValidationSupport.requireValueOrChildren(benefit);
                    }

                    protected Builder from(Benefit benefit) {
                        super.from(benefit);
                        this.type = benefit.type;
                        this.cost.addAll(benefit.cost);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept category;
                private List<Benefit> benefit = new ArrayList<Benefit>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder category(CodeableConcept category) {
                    this.category = category;
                    return this;
                }

                public Builder benefit(Benefit ... benefit) {
                    for (Benefit value : benefit) {
                        this.benefit.add(value);
                    }
                    return this;
                }

                public Builder benefit(Collection<Benefit> benefit) {
                    this.benefit = new ArrayList<Benefit>(benefit);
                    return this;
                }

                @Override
                public SpecificCost build() {
                    SpecificCost specificCost = new SpecificCost(this);
                    if (this.validating) {
                        this.validate(specificCost);
                    }
                    return specificCost;
                }

                protected void validate(SpecificCost specificCost) {
                    super.validate(specificCost);
                    ValidationSupport.requireNonNull(specificCost.category, "category");
                    ValidationSupport.checkList(specificCost.benefit, "benefit", Benefit.class);
                    ValidationSupport.requireValueOrChildren(specificCost);
                }

                protected Builder from(SpecificCost specificCost) {
                    super.from(specificCost);
                    this.category = specificCost.category;
                    this.benefit.addAll(specificCost.benefit);
                    return this;
                }
            }
        }

        public static class GeneralCost
        extends BackboneElement {
            private final CodeableConcept type;
            private final PositiveInt groupSize;
            private final Money cost;
            private final org.linuxforhealth.fhir.model.type.String comment;

            private GeneralCost(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.groupSize = builder.groupSize;
                this.cost = builder.cost;
                this.comment = builder.comment;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public PositiveInt getGroupSize() {
                return this.groupSize;
            }

            public Money getCost() {
                return this.cost;
            }

            public org.linuxforhealth.fhir.model.type.String getComment() {
                return this.comment;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.groupSize != null || this.cost != null || this.comment != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.groupSize, "groupSize", visitor);
                        this.accept(this.cost, "cost", visitor);
                        this.accept(this.comment, "comment", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                GeneralCost other = (GeneralCost)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.groupSize, other.groupSize) && Objects.equals(this.cost, other.cost) && Objects.equals(this.comment, other.comment);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.groupSize, this.cost, this.comment);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private PositiveInt groupSize;
                private Money cost;
                private org.linuxforhealth.fhir.model.type.String comment;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder groupSize(PositiveInt groupSize) {
                    this.groupSize = groupSize;
                    return this;
                }

                public Builder cost(Money cost) {
                    this.cost = cost;
                    return this;
                }

                public Builder comment(String comment) {
                    this.comment = comment == null ? null : org.linuxforhealth.fhir.model.type.String.of(comment);
                    return this;
                }

                public Builder comment(org.linuxforhealth.fhir.model.type.String comment) {
                    this.comment = comment;
                    return this;
                }

                @Override
                public GeneralCost build() {
                    GeneralCost generalCost = new GeneralCost(this);
                    if (this.validating) {
                        this.validate(generalCost);
                    }
                    return generalCost;
                }

                protected void validate(GeneralCost generalCost) {
                    super.validate(generalCost);
                    ValidationSupport.requireValueOrChildren(generalCost);
                }

                protected Builder from(GeneralCost generalCost) {
                    super.from(generalCost);
                    this.type = generalCost.type;
                    this.groupSize = generalCost.groupSize;
                    this.cost = generalCost.cost;
                    this.comment = generalCost.comment;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private CodeableConcept type;
            private List<Reference> coverageArea = new ArrayList<Reference>();
            private List<Reference> network = new ArrayList<Reference>();
            private List<GeneralCost> generalCost = new ArrayList<GeneralCost>();
            private List<SpecificCost> specificCost = new ArrayList<SpecificCost>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder coverageArea(Reference ... coverageArea) {
                for (Reference value : coverageArea) {
                    this.coverageArea.add(value);
                }
                return this;
            }

            public Builder coverageArea(Collection<Reference> coverageArea) {
                this.coverageArea = new ArrayList<Reference>(coverageArea);
                return this;
            }

            public Builder network(Reference ... network) {
                for (Reference value : network) {
                    this.network.add(value);
                }
                return this;
            }

            public Builder network(Collection<Reference> network) {
                this.network = new ArrayList<Reference>(network);
                return this;
            }

            public Builder generalCost(GeneralCost ... generalCost) {
                for (GeneralCost value : generalCost) {
                    this.generalCost.add(value);
                }
                return this;
            }

            public Builder generalCost(Collection<GeneralCost> generalCost) {
                this.generalCost = new ArrayList<GeneralCost>(generalCost);
                return this;
            }

            public Builder specificCost(SpecificCost ... specificCost) {
                for (SpecificCost value : specificCost) {
                    this.specificCost.add(value);
                }
                return this;
            }

            public Builder specificCost(Collection<SpecificCost> specificCost) {
                this.specificCost = new ArrayList<SpecificCost>(specificCost);
                return this;
            }

            @Override
            public Plan build() {
                Plan plan = new Plan(this);
                if (this.validating) {
                    this.validate(plan);
                }
                return plan;
            }

            protected void validate(Plan plan) {
                super.validate(plan);
                ValidationSupport.checkList(plan.identifier, "identifier", Identifier.class);
                ValidationSupport.checkList(plan.coverageArea, "coverageArea", Reference.class);
                ValidationSupport.checkList(plan.network, "network", Reference.class);
                ValidationSupport.checkList(plan.generalCost, "generalCost", GeneralCost.class);
                ValidationSupport.checkList(plan.specificCost, "specificCost", SpecificCost.class);
                ValidationSupport.checkReferenceType(plan.coverageArea, "coverageArea", "Location");
                ValidationSupport.checkReferenceType(plan.network, "network", "Organization");
                ValidationSupport.requireValueOrChildren(plan);
            }

            protected Builder from(Plan plan) {
                super.from(plan);
                this.identifier.addAll(plan.identifier);
                this.type = plan.type;
                this.coverageArea.addAll(plan.coverageArea);
                this.network.addAll(plan.network);
                this.generalCost.addAll(plan.generalCost);
                this.specificCost.addAll(plan.specificCost);
                return this;
            }
        }
    }

    public static class Coverage
    extends BackboneElement {
        @Required
        private final CodeableConcept type;
        @ReferenceTarget(value={"Organization"})
        private final List<Reference> network;
        @Required
        private final List<Benefit> benefit;

        private Coverage(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.network = Collections.unmodifiableList(builder.network);
            this.benefit = Collections.unmodifiableList(builder.benefit);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<Reference> getNetwork() {
            return this.network;
        }

        public List<Benefit> getBenefit() {
            return this.benefit;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.network.isEmpty() || !this.benefit.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.network, "network", visitor, Reference.class);
                    this.accept(this.benefit, "benefit", visitor, Benefit.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Coverage other = (Coverage)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.network, other.network) && Objects.equals(this.benefit, other.benefit);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.network, this.benefit);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Benefit
        extends BackboneElement {
            @Required
            private final CodeableConcept type;
            private final org.linuxforhealth.fhir.model.type.String requirement;
            private final List<Limit> limit;

            private Benefit(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.requirement = builder.requirement;
                this.limit = Collections.unmodifiableList(builder.limit);
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public org.linuxforhealth.fhir.model.type.String getRequirement() {
                return this.requirement;
            }

            public List<Limit> getLimit() {
                return this.limit;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.requirement != null || !this.limit.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.requirement, "requirement", visitor);
                        this.accept(this.limit, "limit", visitor, Limit.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Benefit other = (Benefit)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.requirement, other.requirement) && Objects.equals(this.limit, other.limit);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.requirement, this.limit);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Limit
            extends BackboneElement {
                private final Quantity value;
                private final CodeableConcept code;

                private Limit(Builder builder) {
                    super(builder);
                    this.value = builder.value;
                    this.code = builder.code;
                }

                public Quantity getValue() {
                    return this.value;
                }

                public CodeableConcept getCode() {
                    return this.code;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.value != null || this.code != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.value, "value", visitor);
                            this.accept(this.code, "code", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Limit other = (Limit)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value) && Objects.equals(this.code, other.code);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value, this.code);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Quantity value;
                    private CodeableConcept code;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder value(Quantity value) {
                        this.value = value;
                        return this;
                    }

                    public Builder code(CodeableConcept code) {
                        this.code = code;
                        return this;
                    }

                    @Override
                    public Limit build() {
                        Limit limit = new Limit(this);
                        if (this.validating) {
                            this.validate(limit);
                        }
                        return limit;
                    }

                    protected void validate(Limit limit) {
                        super.validate(limit);
                        ValidationSupport.requireValueOrChildren(limit);
                    }

                    protected Builder from(Limit limit) {
                        super.from(limit);
                        this.value = limit.value;
                        this.code = limit.code;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private org.linuxforhealth.fhir.model.type.String requirement;
                private List<Limit> limit = new ArrayList<Limit>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder requirement(String requirement) {
                    this.requirement = requirement == null ? null : org.linuxforhealth.fhir.model.type.String.of(requirement);
                    return this;
                }

                public Builder requirement(org.linuxforhealth.fhir.model.type.String requirement) {
                    this.requirement = requirement;
                    return this;
                }

                public Builder limit(Limit ... limit) {
                    for (Limit value : limit) {
                        this.limit.add(value);
                    }
                    return this;
                }

                public Builder limit(Collection<Limit> limit) {
                    this.limit = new ArrayList<Limit>(limit);
                    return this;
                }

                @Override
                public Benefit build() {
                    Benefit benefit = new Benefit(this);
                    if (this.validating) {
                        this.validate(benefit);
                    }
                    return benefit;
                }

                protected void validate(Benefit benefit) {
                    super.validate(benefit);
                    ValidationSupport.requireNonNull(benefit.type, "type");
                    ValidationSupport.checkList(benefit.limit, "limit", Limit.class);
                    ValidationSupport.requireValueOrChildren(benefit);
                }

                protected Builder from(Benefit benefit) {
                    super.from(benefit);
                    this.type = benefit.type;
                    this.requirement = benefit.requirement;
                    this.limit.addAll(benefit.limit);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<Reference> network = new ArrayList<Reference>();
            private List<Benefit> benefit = new ArrayList<Benefit>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder network(Reference ... network) {
                for (Reference value : network) {
                    this.network.add(value);
                }
                return this;
            }

            public Builder network(Collection<Reference> network) {
                this.network = new ArrayList<Reference>(network);
                return this;
            }

            public Builder benefit(Benefit ... benefit) {
                for (Benefit value : benefit) {
                    this.benefit.add(value);
                }
                return this;
            }

            public Builder benefit(Collection<Benefit> benefit) {
                this.benefit = new ArrayList<Benefit>(benefit);
                return this;
            }

            @Override
            public Coverage build() {
                Coverage coverage = new Coverage(this);
                if (this.validating) {
                    this.validate(coverage);
                }
                return coverage;
            }

            protected void validate(Coverage coverage) {
                super.validate(coverage);
                ValidationSupport.requireNonNull(coverage.type, "type");
                ValidationSupport.checkList(coverage.network, "network", Reference.class);
                ValidationSupport.checkNonEmptyList(coverage.benefit, "benefit", Benefit.class);
                ValidationSupport.checkReferenceType(coverage.network, "network", "Organization");
                ValidationSupport.requireValueOrChildren(coverage);
            }

            protected Builder from(Coverage coverage) {
                super.from(coverage);
                this.type = coverage.type;
                this.network.addAll(coverage.network);
                this.benefit.addAll(coverage.benefit);
                return this;
            }
        }
    }

    public static class Contact
    extends BackboneElement {
        @Binding(bindingName="ContactPartyType", strength=BindingStrength.Value.EXTENSIBLE, description="The purpose for which you would contact a contact party.", valueSet="http://hl7.org/fhir/ValueSet/contactentity-type")
        private final CodeableConcept purpose;
        private final HumanName name;
        private final List<ContactPoint> telecom;
        private final Address address;

        private Contact(Builder builder) {
            super(builder);
            this.purpose = builder.purpose;
            this.name = builder.name;
            this.telecom = Collections.unmodifiableList(builder.telecom);
            this.address = builder.address;
        }

        public CodeableConcept getPurpose() {
            return this.purpose;
        }

        public HumanName getName() {
            return this.name;
        }

        public List<ContactPoint> getTelecom() {
            return this.telecom;
        }

        public Address getAddress() {
            return this.address;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.purpose != null || this.name != null || !this.telecom.isEmpty() || this.address != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.purpose, "purpose", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                    this.accept(this.address, "address", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Contact other = (Contact)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.address, other.address);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.purpose, this.name, this.telecom, this.address);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept purpose;
            private HumanName name;
            private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
            private Address address;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder purpose(CodeableConcept purpose) {
                this.purpose = purpose;
                return this;
            }

            public Builder name(HumanName name) {
                this.name = name;
                return this;
            }

            public Builder telecom(ContactPoint ... telecom) {
                for (ContactPoint value : telecom) {
                    this.telecom.add(value);
                }
                return this;
            }

            public Builder telecom(Collection<ContactPoint> telecom) {
                this.telecom = new ArrayList<ContactPoint>(telecom);
                return this;
            }

            public Builder address(Address address) {
                this.address = address;
                return this;
            }

            @Override
            public Contact build() {
                Contact contact = new Contact(this);
                if (this.validating) {
                    this.validate(contact);
                }
                return contact;
            }

            protected void validate(Contact contact) {
                super.validate(contact);
                ValidationSupport.checkList(contact.telecom, "telecom", ContactPoint.class);
                ValidationSupport.requireValueOrChildren(contact);
            }

            protected Builder from(Contact contact) {
                super.from(contact);
                this.purpose = contact.purpose;
                this.name = contact.name;
                this.telecom.addAll(contact.telecom);
                this.address = contact.address;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private PublicationStatus status;
        private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        private org.linuxforhealth.fhir.model.type.String name;
        private List<org.linuxforhealth.fhir.model.type.String> alias = new ArrayList<org.linuxforhealth.fhir.model.type.String>();
        private Period period;
        private Reference ownedBy;
        private Reference administeredBy;
        private List<Reference> coverageArea = new ArrayList<Reference>();
        private List<Contact> contact = new ArrayList<Contact>();
        private List<Reference> endpoint = new ArrayList<Reference>();
        private List<Reference> network = new ArrayList<Reference>();
        private List<Coverage> coverage = new ArrayList<Coverage>();
        private List<Plan> plan = new ArrayList<Plan>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept ... type) {
            for (CodeableConcept value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<CodeableConcept> type) {
            this.type = new ArrayList<CodeableConcept>(type);
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder alias(String ... alias) {
            for (String value : alias) {
                this.alias.add(value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value));
            }
            return this;
        }

        public Builder alias(org.linuxforhealth.fhir.model.type.String ... alias) {
            for (org.linuxforhealth.fhir.model.type.String value : alias) {
                this.alias.add(value);
            }
            return this;
        }

        public Builder alias(Collection<org.linuxforhealth.fhir.model.type.String> alias) {
            this.alias = new ArrayList<org.linuxforhealth.fhir.model.type.String>(alias);
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder ownedBy(Reference ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public Builder administeredBy(Reference administeredBy) {
            this.administeredBy = administeredBy;
            return this;
        }

        public Builder coverageArea(Reference ... coverageArea) {
            for (Reference value : coverageArea) {
                this.coverageArea.add(value);
            }
            return this;
        }

        public Builder coverageArea(Collection<Reference> coverageArea) {
            this.coverageArea = new ArrayList<Reference>(coverageArea);
            return this;
        }

        public Builder contact(Contact ... contact) {
            for (Contact value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<Contact> contact) {
            this.contact = new ArrayList<Contact>(contact);
            return this;
        }

        public Builder endpoint(Reference ... endpoint) {
            for (Reference value : endpoint) {
                this.endpoint.add(value);
            }
            return this;
        }

        public Builder endpoint(Collection<Reference> endpoint) {
            this.endpoint = new ArrayList<Reference>(endpoint);
            return this;
        }

        public Builder network(Reference ... network) {
            for (Reference value : network) {
                this.network.add(value);
            }
            return this;
        }

        public Builder network(Collection<Reference> network) {
            this.network = new ArrayList<Reference>(network);
            return this;
        }

        public Builder coverage(Coverage ... coverage) {
            for (Coverage value : coverage) {
                this.coverage.add(value);
            }
            return this;
        }

        public Builder coverage(Collection<Coverage> coverage) {
            this.coverage = new ArrayList<Coverage>(coverage);
            return this;
        }

        public Builder plan(Plan ... plan) {
            for (Plan value : plan) {
                this.plan.add(value);
            }
            return this;
        }

        public Builder plan(Collection<Plan> plan) {
            this.plan = new ArrayList<Plan>(plan);
            return this;
        }

        @Override
        public InsurancePlan build() {
            InsurancePlan insurancePlan = new InsurancePlan(this);
            if (this.validating) {
                this.validate(insurancePlan);
            }
            return insurancePlan;
        }

        protected void validate(InsurancePlan insurancePlan) {
            super.validate(insurancePlan);
            ValidationSupport.checkList(insurancePlan.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(insurancePlan.type, "type", CodeableConcept.class);
            ValidationSupport.checkList(insurancePlan.alias, "alias", org.linuxforhealth.fhir.model.type.String.class);
            ValidationSupport.checkList(insurancePlan.coverageArea, "coverageArea", Reference.class);
            ValidationSupport.checkList(insurancePlan.contact, "contact", Contact.class);
            ValidationSupport.checkList(insurancePlan.endpoint, "endpoint", Reference.class);
            ValidationSupport.checkList(insurancePlan.network, "network", Reference.class);
            ValidationSupport.checkList(insurancePlan.coverage, "coverage", Coverage.class);
            ValidationSupport.checkList(insurancePlan.plan, "plan", Plan.class);
            ValidationSupport.checkReferenceType(insurancePlan.ownedBy, "ownedBy", "Organization");
            ValidationSupport.checkReferenceType(insurancePlan.administeredBy, "administeredBy", "Organization");
            ValidationSupport.checkReferenceType(insurancePlan.coverageArea, "coverageArea", "Location");
            ValidationSupport.checkReferenceType(insurancePlan.endpoint, "endpoint", "Endpoint");
            ValidationSupport.checkReferenceType(insurancePlan.network, "network", "Organization");
        }

        protected Builder from(InsurancePlan insurancePlan) {
            super.from(insurancePlan);
            this.identifier.addAll(insurancePlan.identifier);
            this.status = insurancePlan.status;
            this.type.addAll(insurancePlan.type);
            this.name = insurancePlan.name;
            this.alias.addAll(insurancePlan.alias);
            this.period = insurancePlan.period;
            this.ownedBy = insurancePlan.ownedBy;
            this.administeredBy = insurancePlan.administeredBy;
            this.coverageArea.addAll(insurancePlan.coverageArea);
            this.contact.addAll(insurancePlan.contact);
            this.endpoint.addAll(insurancePlan.endpoint);
            this.network.addAll(insurancePlan.network);
            this.coverage.addAll(insurancePlan.coverage);
            this.plan.addAll(insurancePlan.plan);
            return this;
        }
    }
}

