/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Money;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.PositiveInt;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.InvoicePriceComponentType;
import org.linuxforhealth.fhir.model.type.code.InvoiceStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class Invoice
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="InvoiceStatus", strength=BindingStrength.Value.REQUIRED, description="Codes identifying the lifecycle stage of an Invoice.", valueSet="http://hl7.org/fhir/ValueSet/invoice-status|4.3.0")
    @Required
    private final InvoiceStatus status;
    private final org.linuxforhealth.fhir.model.type.String cancelledReason;
    @Summary
    private final CodeableConcept type;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Organization", "Patient", "RelatedPerson"})
    private final Reference recipient;
    @Summary
    private final DateTime date;
    private final List<Participant> participant;
    @ReferenceTarget(value={"Organization"})
    private final Reference issuer;
    @ReferenceTarget(value={"Account"})
    private final Reference account;
    private final List<LineItem> lineItem;
    private final List<LineItem.PriceComponent> totalPriceComponent;
    @Summary
    private final Money totalNet;
    @Summary
    private final Money totalGross;
    private final Markdown paymentTerms;
    private final List<Annotation> note;

    private Invoice(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.cancelledReason = builder.cancelledReason;
        this.type = builder.type;
        this.subject = builder.subject;
        this.recipient = builder.recipient;
        this.date = builder.date;
        this.participant = Collections.unmodifiableList(builder.participant);
        this.issuer = builder.issuer;
        this.account = builder.account;
        this.lineItem = Collections.unmodifiableList(builder.lineItem);
        this.totalPriceComponent = Collections.unmodifiableList(builder.totalPriceComponent);
        this.totalNet = builder.totalNet;
        this.totalGross = builder.totalGross;
        this.paymentTerms = builder.paymentTerms;
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public InvoiceStatus getStatus() {
        return this.status;
    }

    public org.linuxforhealth.fhir.model.type.String getCancelledReason() {
        return this.cancelledReason;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getRecipient() {
        return this.recipient;
    }

    public DateTime getDate() {
        return this.date;
    }

    public List<Participant> getParticipant() {
        return this.participant;
    }

    public Reference getIssuer() {
        return this.issuer;
    }

    public Reference getAccount() {
        return this.account;
    }

    public List<LineItem> getLineItem() {
        return this.lineItem;
    }

    public List<LineItem.PriceComponent> getTotalPriceComponent() {
        return this.totalPriceComponent;
    }

    public Money getTotalNet() {
        return this.totalNet;
    }

    public Money getTotalGross() {
        return this.totalGross;
    }

    public Markdown getPaymentTerms() {
        return this.paymentTerms;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.cancelledReason != null || this.type != null || this.subject != null || this.recipient != null || this.date != null || !this.participant.isEmpty() || this.issuer != null || this.account != null || !this.lineItem.isEmpty() || !this.totalPriceComponent.isEmpty() || this.totalNet != null || this.totalGross != null || this.paymentTerms != null || !this.note.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.cancelledReason, "cancelledReason", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.recipient, "recipient", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.participant, "participant", visitor, Participant.class);
                this.accept(this.issuer, "issuer", visitor);
                this.accept(this.account, "account", visitor);
                this.accept(this.lineItem, "lineItem", visitor, LineItem.class);
                this.accept(this.totalPriceComponent, "totalPriceComponent", visitor, LineItem.PriceComponent.class);
                this.accept(this.totalNet, "totalNet", visitor);
                this.accept(this.totalGross, "totalGross", visitor);
                this.accept(this.paymentTerms, "paymentTerms", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Invoice other = (Invoice)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.cancelledReason, other.cancelledReason) && Objects.equals(this.type, other.type) && Objects.equals(this.subject, other.subject) && Objects.equals(this.recipient, other.recipient) && Objects.equals(this.date, other.date) && Objects.equals(this.participant, other.participant) && Objects.equals(this.issuer, other.issuer) && Objects.equals(this.account, other.account) && Objects.equals(this.lineItem, other.lineItem) && Objects.equals(this.totalPriceComponent, other.totalPriceComponent) && Objects.equals(this.totalNet, other.totalNet) && Objects.equals(this.totalGross, other.totalGross) && Objects.equals(this.paymentTerms, other.paymentTerms) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.cancelledReason, this.type, this.subject, this.recipient, this.date, this.participant, this.issuer, this.account, this.lineItem, this.totalPriceComponent, this.totalNet, this.totalGross, this.paymentTerms, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class LineItem
    extends BackboneElement {
        private final PositiveInt sequence;
        @ReferenceTarget(value={"ChargeItem"})
        @Choice(value={Reference.class, CodeableConcept.class})
        @Required
        private final Element chargeItem;
        private final List<PriceComponent> priceComponent;

        private LineItem(Builder builder) {
            super(builder);
            this.sequence = builder.sequence;
            this.chargeItem = builder.chargeItem;
            this.priceComponent = Collections.unmodifiableList(builder.priceComponent);
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public Element getChargeItem() {
            return this.chargeItem;
        }

        public List<PriceComponent> getPriceComponent() {
            return this.priceComponent;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || this.chargeItem != null || !this.priceComponent.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.chargeItem, "chargeItem", visitor);
                    this.accept(this.priceComponent, "priceComponent", visitor, PriceComponent.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineItem other = (LineItem)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.chargeItem, other.chargeItem) && Objects.equals(this.priceComponent, other.priceComponent);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.chargeItem, this.priceComponent);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class PriceComponent
        extends BackboneElement {
            @Binding(bindingName="InvoicePriceComponentType", strength=BindingStrength.Value.REQUIRED, description="Codes indicating the kind of the price component.", valueSet="http://hl7.org/fhir/ValueSet/invoice-priceComponentType|4.3.0")
            @Required
            private final InvoicePriceComponentType type;
            private final CodeableConcept code;
            private final Decimal factor;
            private final Money amount;

            private PriceComponent(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.code = builder.code;
                this.factor = builder.factor;
                this.amount = builder.amount;
            }

            public InvoicePriceComponentType getType() {
                return this.type;
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public Decimal getFactor() {
                return this.factor;
            }

            public Money getAmount() {
                return this.amount;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.code != null || this.factor != null || this.amount != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.factor, "factor", visitor);
                        this.accept(this.amount, "amount", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PriceComponent other = (PriceComponent)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.code, other.code) && Objects.equals(this.factor, other.factor) && Objects.equals(this.amount, other.amount);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.code, this.factor, this.amount);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private InvoicePriceComponentType type;
                private CodeableConcept code;
                private Decimal factor;
                private Money amount;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(InvoicePriceComponentType type) {
                    this.type = type;
                    return this;
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder factor(Decimal factor) {
                    this.factor = factor;
                    return this;
                }

                public Builder amount(Money amount) {
                    this.amount = amount;
                    return this;
                }

                @Override
                public PriceComponent build() {
                    PriceComponent priceComponent = new PriceComponent(this);
                    if (this.validating) {
                        this.validate(priceComponent);
                    }
                    return priceComponent;
                }

                protected void validate(PriceComponent priceComponent) {
                    super.validate(priceComponent);
                    ValidationSupport.requireNonNull(priceComponent.type, "type");
                    ValidationSupport.requireValueOrChildren(priceComponent);
                }

                protected Builder from(PriceComponent priceComponent) {
                    super.from(priceComponent);
                    this.type = priceComponent.type;
                    this.code = priceComponent.code;
                    this.factor = priceComponent.factor;
                    this.amount = priceComponent.amount;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private Element chargeItem;
            private List<PriceComponent> priceComponent = new ArrayList<PriceComponent>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder chargeItem(Element chargeItem) {
                this.chargeItem = chargeItem;
                return this;
            }

            public Builder priceComponent(PriceComponent ... priceComponent) {
                for (PriceComponent value : priceComponent) {
                    this.priceComponent.add(value);
                }
                return this;
            }

            public Builder priceComponent(Collection<PriceComponent> priceComponent) {
                this.priceComponent = new ArrayList<PriceComponent>(priceComponent);
                return this;
            }

            @Override
            public LineItem build() {
                LineItem lineItem = new LineItem(this);
                if (this.validating) {
                    this.validate(lineItem);
                }
                return lineItem;
            }

            protected void validate(LineItem lineItem) {
                super.validate(lineItem);
                ValidationSupport.requireChoiceElement(lineItem.chargeItem, "chargeItem", Reference.class, CodeableConcept.class);
                ValidationSupport.checkList(lineItem.priceComponent, "priceComponent", PriceComponent.class);
                ValidationSupport.checkReferenceType(lineItem.chargeItem, "chargeItem", "ChargeItem");
                ValidationSupport.requireValueOrChildren(lineItem);
            }

            protected Builder from(LineItem lineItem) {
                super.from(lineItem);
                this.sequence = lineItem.sequence;
                this.chargeItem = lineItem.chargeItem;
                this.priceComponent.addAll(lineItem.priceComponent);
                return this;
            }
        }
    }

    public static class Participant
    extends BackboneElement {
        private final CodeableConcept role;
        @ReferenceTarget(value={"Practitioner", "Organization", "Patient", "PractitionerRole", "Device", "RelatedPerson"})
        @Required
        private final Reference actor;

        private Participant(Builder builder) {
            super(builder);
            this.role = builder.role;
            this.actor = builder.actor;
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        public Reference getActor() {
            return this.actor;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.role != null || this.actor != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.actor, "actor", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Participant other = (Participant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.role, other.role) && Objects.equals(this.actor, other.actor);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.role, this.actor);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept role;
            private Reference actor;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder role(CodeableConcept role) {
                this.role = role;
                return this;
            }

            public Builder actor(Reference actor) {
                this.actor = actor;
                return this;
            }

            @Override
            public Participant build() {
                Participant participant = new Participant(this);
                if (this.validating) {
                    this.validate(participant);
                }
                return participant;
            }

            protected void validate(Participant participant) {
                super.validate(participant);
                ValidationSupport.requireNonNull(participant.actor, "actor");
                ValidationSupport.checkReferenceType(participant.actor, "actor", "Practitioner", "Organization", "Patient", "PractitionerRole", "Device", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(participant);
            }

            protected Builder from(Participant participant) {
                super.from(participant);
                this.role = participant.role;
                this.actor = participant.actor;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private InvoiceStatus status;
        private org.linuxforhealth.fhir.model.type.String cancelledReason;
        private CodeableConcept type;
        private Reference subject;
        private Reference recipient;
        private DateTime date;
        private List<Participant> participant = new ArrayList<Participant>();
        private Reference issuer;
        private Reference account;
        private List<LineItem> lineItem = new ArrayList<LineItem>();
        private List<LineItem.PriceComponent> totalPriceComponent = new ArrayList<LineItem.PriceComponent>();
        private Money totalNet;
        private Money totalGross;
        private Markdown paymentTerms;
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(InvoiceStatus status) {
            this.status = status;
            return this;
        }

        public Builder cancelledReason(String cancelledReason) {
            this.cancelledReason = cancelledReason == null ? null : org.linuxforhealth.fhir.model.type.String.of(cancelledReason);
            return this;
        }

        public Builder cancelledReason(org.linuxforhealth.fhir.model.type.String cancelledReason) {
            this.cancelledReason = cancelledReason;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder recipient(Reference recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder participant(Participant ... participant) {
            for (Participant value : participant) {
                this.participant.add(value);
            }
            return this;
        }

        public Builder participant(Collection<Participant> participant) {
            this.participant = new ArrayList<Participant>(participant);
            return this;
        }

        public Builder issuer(Reference issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder account(Reference account) {
            this.account = account;
            return this;
        }

        public Builder lineItem(LineItem ... lineItem) {
            for (LineItem value : lineItem) {
                this.lineItem.add(value);
            }
            return this;
        }

        public Builder lineItem(Collection<LineItem> lineItem) {
            this.lineItem = new ArrayList<LineItem>(lineItem);
            return this;
        }

        public Builder totalPriceComponent(LineItem.PriceComponent ... totalPriceComponent) {
            for (LineItem.PriceComponent value : totalPriceComponent) {
                this.totalPriceComponent.add(value);
            }
            return this;
        }

        public Builder totalPriceComponent(Collection<LineItem.PriceComponent> totalPriceComponent) {
            this.totalPriceComponent = new ArrayList<LineItem.PriceComponent>(totalPriceComponent);
            return this;
        }

        public Builder totalNet(Money totalNet) {
            this.totalNet = totalNet;
            return this;
        }

        public Builder totalGross(Money totalGross) {
            this.totalGross = totalGross;
            return this;
        }

        public Builder paymentTerms(Markdown paymentTerms) {
            this.paymentTerms = paymentTerms;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public Invoice build() {
            Invoice invoice = new Invoice(this);
            if (this.validating) {
                this.validate(invoice);
            }
            return invoice;
        }

        protected void validate(Invoice invoice) {
            super.validate(invoice);
            ValidationSupport.checkList(invoice.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(invoice.status, "status");
            ValidationSupport.checkList(invoice.participant, "participant", Participant.class);
            ValidationSupport.checkList(invoice.lineItem, "lineItem", LineItem.class);
            ValidationSupport.checkList(invoice.totalPriceComponent, "totalPriceComponent", LineItem.PriceComponent.class);
            ValidationSupport.checkList(invoice.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(invoice.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(invoice.recipient, "recipient", "Organization", "Patient", "RelatedPerson");
            ValidationSupport.checkReferenceType(invoice.issuer, "issuer", "Organization");
            ValidationSupport.checkReferenceType(invoice.account, "account", "Account");
        }

        protected Builder from(Invoice invoice) {
            super.from(invoice);
            this.identifier.addAll(invoice.identifier);
            this.status = invoice.status;
            this.cancelledReason = invoice.cancelledReason;
            this.type = invoice.type;
            this.subject = invoice.subject;
            this.recipient = invoice.recipient;
            this.date = invoice.date;
            this.participant.addAll(invoice.participant);
            this.issuer = invoice.issuer;
            this.account = invoice.account;
            this.lineItem.addAll(invoice.lineItem);
            this.totalPriceComponent.addAll(invoice.totalPriceComponent);
            this.totalNet = invoice.totalNet;
            this.totalGross = invoice.totalGross;
            this.paymentTerms = invoice.paymentTerms;
            this.note.addAll(invoice.note);
            return this;
        }
    }
}

