/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.LinkageType;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="lnk-1", level="Rule", location="(base)", description="Must have at least two items", expression="item.count()>1", source="http://hl7.org/fhir/StructureDefinition/Linkage")
public class Linkage
extends DomainResource {
    @Summary
    private final Boolean active;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference author;
    @Summary
    @Required
    private final List<Item> item;

    private Linkage(Builder builder) {
        super(builder);
        this.active = builder.active;
        this.author = builder.author;
        this.item = Collections.unmodifiableList(builder.item);
    }

    public Boolean getActive() {
        return this.active;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public List<Item> getItem() {
        return this.item;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.active != null || this.author != null || !this.item.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.author, "author", visitor);
                this.accept(this.item, "item", visitor, Item.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Linkage other = (Linkage)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.active, other.active) && Objects.equals(this.author, other.author) && Objects.equals(this.item, other.item);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.active, this.author, this.item);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Item
    extends BackboneElement {
        @Summary
        @Binding(bindingName="LinkageType", strength=BindingStrength.Value.REQUIRED, description="Used to distinguish different roles a resource can play within a set of linked resources.", valueSet="http://hl7.org/fhir/ValueSet/linkage-type|4.3.0")
        @Required
        private final LinkageType type;
        @Summary
        @Required
        private final Reference resource;

        private Item(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.resource = builder.resource;
        }

        public LinkageType getType() {
            return this.type;
        }

        public Reference getResource() {
            return this.resource;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.resource != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.resource, "resource", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.resource, other.resource);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.resource);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private LinkageType type;
            private Reference resource;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(LinkageType type) {
                this.type = type;
                return this;
            }

            public Builder resource(Reference resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public Item build() {
                Item item = new Item(this);
                if (this.validating) {
                    this.validate(item);
                }
                return item;
            }

            protected void validate(Item item) {
                super.validate(item);
                ValidationSupport.requireNonNull(item.type, "type");
                ValidationSupport.requireNonNull(item.resource, "resource");
                ValidationSupport.requireValueOrChildren(item);
            }

            protected Builder from(Item item) {
                super.from(item);
                this.type = item.type;
                this.resource = item.resource;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Boolean active;
        private Reference author;
        private List<Item> item = new ArrayList<Item>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        public Builder item(Item ... item) {
            for (Item value : item) {
                this.item.add(value);
            }
            return this;
        }

        public Builder item(Collection<Item> item) {
            this.item = new ArrayList<Item>(item);
            return this;
        }

        @Override
        public Linkage build() {
            Linkage linkage = new Linkage(this);
            if (this.validating) {
                this.validate(linkage);
            }
            return linkage;
        }

        protected void validate(Linkage linkage) {
            super.validate(linkage);
            ValidationSupport.checkNonEmptyList(linkage.item, "item", Item.class);
            ValidationSupport.checkReferenceType(linkage.author, "author", "Practitioner", "PractitionerRole", "Organization");
        }

        protected Builder from(Linkage linkage) {
            super.from(linkage);
            this.active = linkage.active;
            this.author = linkage.author;
            this.item.addAll(linkage.item);
            return this;
        }
    }
}

