/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Address;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Time;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.DaysOfWeek;
import org.linuxforhealth.fhir.model.type.code.LocationMode;
import org.linuxforhealth.fhir.model.type.code.LocationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="location-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://terminology.hl7.org/ValueSet/v2-0116", expression="operationalStatus.exists() implies (operationalStatus.memberOf('http://terminology.hl7.org/ValueSet/v2-0116', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Location", generated=true), @Constraint(id="location-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType", expression="type.exists() implies (type.all(memberOf('http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Location", generated=true)})
public class Location
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="LocationStatus", strength=BindingStrength.Value.REQUIRED, description="Indicates whether the location is still in use.", valueSet="http://hl7.org/fhir/ValueSet/location-status|4.3.0")
    private final LocationStatus status;
    @Summary
    @Binding(bindingName="OperationalStatus", strength=BindingStrength.Value.PREFERRED, description="The operational status if the location (where typically a bed/room).", valueSet="http://terminology.hl7.org/ValueSet/v2-0116")
    private final Coding operationalStatus;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    private final List<org.linuxforhealth.fhir.model.type.String> alias;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String description;
    @Summary
    @Binding(bindingName="LocationMode", strength=BindingStrength.Value.REQUIRED, description="Indicates whether a resource instance represents a specific location or a class of locations.", valueSet="http://hl7.org/fhir/ValueSet/location-mode|4.3.0")
    private final LocationMode mode;
    @Summary
    @Binding(bindingName="LocationType", strength=BindingStrength.Value.EXTENSIBLE, description="Indicates the type of function performed at the location.", valueSet="http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType")
    private final List<CodeableConcept> type;
    private final List<ContactPoint> telecom;
    private final Address address;
    @Summary
    @Binding(bindingName="PhysicalType", strength=BindingStrength.Value.EXAMPLE, description="Physical form of the location.", valueSet="http://hl7.org/fhir/ValueSet/location-physical-type")
    private final CodeableConcept physicalType;
    private final Position position;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference managingOrganization;
    @ReferenceTarget(value={"Location"})
    private final Reference partOf;
    private final List<HoursOfOperation> hoursOfOperation;
    private final org.linuxforhealth.fhir.model.type.String availabilityExceptions;
    @ReferenceTarget(value={"Endpoint"})
    private final List<Reference> endpoint;

    private Location(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.operationalStatus = builder.operationalStatus;
        this.name = builder.name;
        this.alias = Collections.unmodifiableList(builder.alias);
        this.description = builder.description;
        this.mode = builder.mode;
        this.type = Collections.unmodifiableList(builder.type);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.address = builder.address;
        this.physicalType = builder.physicalType;
        this.position = builder.position;
        this.managingOrganization = builder.managingOrganization;
        this.partOf = builder.partOf;
        this.hoursOfOperation = Collections.unmodifiableList(builder.hoursOfOperation);
        this.availabilityExceptions = builder.availabilityExceptions;
        this.endpoint = Collections.unmodifiableList(builder.endpoint);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public LocationStatus getStatus() {
        return this.status;
    }

    public Coding getOperationalStatus() {
        return this.operationalStatus;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public List<org.linuxforhealth.fhir.model.type.String> getAlias() {
        return this.alias;
    }

    public org.linuxforhealth.fhir.model.type.String getDescription() {
        return this.description;
    }

    public LocationMode getMode() {
        return this.mode;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public Address getAddress() {
        return this.address;
    }

    public CodeableConcept getPhysicalType() {
        return this.physicalType;
    }

    public Position getPosition() {
        return this.position;
    }

    public Reference getManagingOrganization() {
        return this.managingOrganization;
    }

    public Reference getPartOf() {
        return this.partOf;
    }

    public List<HoursOfOperation> getHoursOfOperation() {
        return this.hoursOfOperation;
    }

    public org.linuxforhealth.fhir.model.type.String getAvailabilityExceptions() {
        return this.availabilityExceptions;
    }

    public List<Reference> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.operationalStatus != null || this.name != null || !this.alias.isEmpty() || this.description != null || this.mode != null || !this.type.isEmpty() || !this.telecom.isEmpty() || this.address != null || this.physicalType != null || this.position != null || this.managingOrganization != null || this.partOf != null || !this.hoursOfOperation.isEmpty() || this.availabilityExceptions != null || !this.endpoint.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.operationalStatus, "operationalStatus", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.alias, "alias", visitor, org.linuxforhealth.fhir.model.type.String.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.mode, "mode", visitor);
                this.accept(this.type, "type", visitor, CodeableConcept.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.address, "address", visitor);
                this.accept(this.physicalType, "physicalType", visitor);
                this.accept(this.position, "position", visitor);
                this.accept(this.managingOrganization, "managingOrganization", visitor);
                this.accept(this.partOf, "partOf", visitor);
                this.accept(this.hoursOfOperation, "hoursOfOperation", visitor, HoursOfOperation.class);
                this.accept(this.availabilityExceptions, "availabilityExceptions", visitor);
                this.accept(this.endpoint, "endpoint", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.operationalStatus, other.operationalStatus) && Objects.equals(this.name, other.name) && Objects.equals(this.alias, other.alias) && Objects.equals(this.description, other.description) && Objects.equals(this.mode, other.mode) && Objects.equals(this.type, other.type) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.address, other.address) && Objects.equals(this.physicalType, other.physicalType) && Objects.equals(this.position, other.position) && Objects.equals(this.managingOrganization, other.managingOrganization) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.hoursOfOperation, other.hoursOfOperation) && Objects.equals(this.availabilityExceptions, other.availabilityExceptions) && Objects.equals(this.endpoint, other.endpoint);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.operationalStatus, this.name, this.alias, this.description, this.mode, this.type, this.telecom, this.address, this.physicalType, this.position, this.managingOrganization, this.partOf, this.hoursOfOperation, this.availabilityExceptions, this.endpoint);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class HoursOfOperation
    extends BackboneElement {
        @Binding(bindingName="DaysOfWeek", strength=BindingStrength.Value.REQUIRED, description="The days of the week.", valueSet="http://hl7.org/fhir/ValueSet/days-of-week|4.3.0")
        private final List<DaysOfWeek> daysOfWeek;
        private final Boolean allDay;
        private final Time openingTime;
        private final Time closingTime;

        private HoursOfOperation(Builder builder) {
            super(builder);
            this.daysOfWeek = Collections.unmodifiableList(builder.daysOfWeek);
            this.allDay = builder.allDay;
            this.openingTime = builder.openingTime;
            this.closingTime = builder.closingTime;
        }

        public List<DaysOfWeek> getDaysOfWeek() {
            return this.daysOfWeek;
        }

        public Boolean getAllDay() {
            return this.allDay;
        }

        public Time getOpeningTime() {
            return this.openingTime;
        }

        public Time getClosingTime() {
            return this.closingTime;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.daysOfWeek.isEmpty() || this.allDay != null || this.openingTime != null || this.closingTime != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.daysOfWeek, "daysOfWeek", visitor, DaysOfWeek.class);
                    this.accept(this.allDay, "allDay", visitor);
                    this.accept(this.openingTime, "openingTime", visitor);
                    this.accept(this.closingTime, "closingTime", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HoursOfOperation other = (HoursOfOperation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.daysOfWeek, other.daysOfWeek) && Objects.equals(this.allDay, other.allDay) && Objects.equals(this.openingTime, other.openingTime) && Objects.equals(this.closingTime, other.closingTime);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.daysOfWeek, this.allDay, this.openingTime, this.closingTime);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<DaysOfWeek> daysOfWeek = new ArrayList<DaysOfWeek>();
            private Boolean allDay;
            private Time openingTime;
            private Time closingTime;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder daysOfWeek(DaysOfWeek ... daysOfWeek) {
                for (DaysOfWeek value : daysOfWeek) {
                    this.daysOfWeek.add(value);
                }
                return this;
            }

            public Builder daysOfWeek(Collection<DaysOfWeek> daysOfWeek) {
                this.daysOfWeek = new ArrayList<DaysOfWeek>(daysOfWeek);
                return this;
            }

            public Builder allDay(java.lang.Boolean allDay) {
                this.allDay = allDay == null ? null : Boolean.of(allDay);
                return this;
            }

            public Builder allDay(Boolean allDay) {
                this.allDay = allDay;
                return this;
            }

            public Builder openingTime(LocalTime openingTime) {
                this.openingTime = openingTime == null ? null : Time.of(openingTime);
                return this;
            }

            public Builder openingTime(Time openingTime) {
                this.openingTime = openingTime;
                return this;
            }

            public Builder closingTime(LocalTime closingTime) {
                this.closingTime = closingTime == null ? null : Time.of(closingTime);
                return this;
            }

            public Builder closingTime(Time closingTime) {
                this.closingTime = closingTime;
                return this;
            }

            @Override
            public HoursOfOperation build() {
                HoursOfOperation hoursOfOperation = new HoursOfOperation(this);
                if (this.validating) {
                    this.validate(hoursOfOperation);
                }
                return hoursOfOperation;
            }

            protected void validate(HoursOfOperation hoursOfOperation) {
                super.validate(hoursOfOperation);
                ValidationSupport.checkList(hoursOfOperation.daysOfWeek, "daysOfWeek", DaysOfWeek.class);
                ValidationSupport.requireValueOrChildren(hoursOfOperation);
            }

            protected Builder from(HoursOfOperation hoursOfOperation) {
                super.from(hoursOfOperation);
                this.daysOfWeek.addAll(hoursOfOperation.daysOfWeek);
                this.allDay = hoursOfOperation.allDay;
                this.openingTime = hoursOfOperation.openingTime;
                this.closingTime = hoursOfOperation.closingTime;
                return this;
            }
        }
    }

    public static class Position
    extends BackboneElement {
        @Required
        private final Decimal longitude;
        @Required
        private final Decimal latitude;
        private final Decimal altitude;

        private Position(Builder builder) {
            super(builder);
            this.longitude = builder.longitude;
            this.latitude = builder.latitude;
            this.altitude = builder.altitude;
        }

        public Decimal getLongitude() {
            return this.longitude;
        }

        public Decimal getLatitude() {
            return this.latitude;
        }

        public Decimal getAltitude() {
            return this.altitude;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.longitude != null || this.latitude != null || this.altitude != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.longitude, "longitude", visitor);
                    this.accept(this.latitude, "latitude", visitor);
                    this.accept(this.altitude, "altitude", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Position other = (Position)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.longitude, other.longitude) && Objects.equals(this.latitude, other.latitude) && Objects.equals(this.altitude, other.altitude);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.longitude, this.latitude, this.altitude);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Decimal longitude;
            private Decimal latitude;
            private Decimal altitude;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder longitude(Decimal longitude) {
                this.longitude = longitude;
                return this;
            }

            public Builder latitude(Decimal latitude) {
                this.latitude = latitude;
                return this;
            }

            public Builder altitude(Decimal altitude) {
                this.altitude = altitude;
                return this;
            }

            @Override
            public Position build() {
                Position position = new Position(this);
                if (this.validating) {
                    this.validate(position);
                }
                return position;
            }

            protected void validate(Position position) {
                super.validate(position);
                ValidationSupport.requireNonNull(position.longitude, "longitude");
                ValidationSupport.requireNonNull(position.latitude, "latitude");
                ValidationSupport.requireValueOrChildren(position);
            }

            protected Builder from(Position position) {
                super.from(position);
                this.longitude = position.longitude;
                this.latitude = position.latitude;
                this.altitude = position.altitude;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private LocationStatus status;
        private Coding operationalStatus;
        private org.linuxforhealth.fhir.model.type.String name;
        private List<org.linuxforhealth.fhir.model.type.String> alias = new ArrayList<org.linuxforhealth.fhir.model.type.String>();
        private org.linuxforhealth.fhir.model.type.String description;
        private LocationMode mode;
        private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private Address address;
        private CodeableConcept physicalType;
        private Position position;
        private Reference managingOrganization;
        private Reference partOf;
        private List<HoursOfOperation> hoursOfOperation = new ArrayList<HoursOfOperation>();
        private org.linuxforhealth.fhir.model.type.String availabilityExceptions;
        private List<Reference> endpoint = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(LocationStatus status) {
            this.status = status;
            return this;
        }

        public Builder operationalStatus(Coding operationalStatus) {
            this.operationalStatus = operationalStatus;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder alias(String ... alias) {
            for (String value : alias) {
                this.alias.add(value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value));
            }
            return this;
        }

        public Builder alias(org.linuxforhealth.fhir.model.type.String ... alias) {
            for (org.linuxforhealth.fhir.model.type.String value : alias) {
                this.alias.add(value);
            }
            return this;
        }

        public Builder alias(Collection<org.linuxforhealth.fhir.model.type.String> alias) {
            this.alias = new ArrayList<org.linuxforhealth.fhir.model.type.String>(alias);
            return this;
        }

        public Builder description(String description) {
            this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
            return this;
        }

        public Builder description(org.linuxforhealth.fhir.model.type.String description) {
            this.description = description;
            return this;
        }

        public Builder mode(LocationMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder type(CodeableConcept ... type) {
            for (CodeableConcept value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<CodeableConcept> type) {
            this.type = new ArrayList<CodeableConcept>(type);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder physicalType(CodeableConcept physicalType) {
            this.physicalType = physicalType;
            return this;
        }

        public Builder position(Position position) {
            this.position = position;
            return this;
        }

        public Builder managingOrganization(Reference managingOrganization) {
            this.managingOrganization = managingOrganization;
            return this;
        }

        public Builder partOf(Reference partOf) {
            this.partOf = partOf;
            return this;
        }

        public Builder hoursOfOperation(HoursOfOperation ... hoursOfOperation) {
            for (HoursOfOperation value : hoursOfOperation) {
                this.hoursOfOperation.add(value);
            }
            return this;
        }

        public Builder hoursOfOperation(Collection<HoursOfOperation> hoursOfOperation) {
            this.hoursOfOperation = new ArrayList<HoursOfOperation>(hoursOfOperation);
            return this;
        }

        public Builder availabilityExceptions(String availabilityExceptions) {
            this.availabilityExceptions = availabilityExceptions == null ? null : org.linuxforhealth.fhir.model.type.String.of(availabilityExceptions);
            return this;
        }

        public Builder availabilityExceptions(org.linuxforhealth.fhir.model.type.String availabilityExceptions) {
            this.availabilityExceptions = availabilityExceptions;
            return this;
        }

        public Builder endpoint(Reference ... endpoint) {
            for (Reference value : endpoint) {
                this.endpoint.add(value);
            }
            return this;
        }

        public Builder endpoint(Collection<Reference> endpoint) {
            this.endpoint = new ArrayList<Reference>(endpoint);
            return this;
        }

        @Override
        public Location build() {
            Location location = new Location(this);
            if (this.validating) {
                this.validate(location);
            }
            return location;
        }

        protected void validate(Location location) {
            super.validate(location);
            ValidationSupport.checkList(location.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(location.alias, "alias", org.linuxforhealth.fhir.model.type.String.class);
            ValidationSupport.checkList(location.type, "type", CodeableConcept.class);
            ValidationSupport.checkList(location.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(location.hoursOfOperation, "hoursOfOperation", HoursOfOperation.class);
            ValidationSupport.checkList(location.endpoint, "endpoint", Reference.class);
            ValidationSupport.checkReferenceType(location.managingOrganization, "managingOrganization", "Organization");
            ValidationSupport.checkReferenceType(location.partOf, "partOf", "Location");
            ValidationSupport.checkReferenceType(location.endpoint, "endpoint", "Endpoint");
        }

        protected Builder from(Location location) {
            super.from(location);
            this.identifier.addAll(location.identifier);
            this.status = location.status;
            this.operationalStatus = location.operationalStatus;
            this.name = location.name;
            this.alias.addAll(location.alias);
            this.description = location.description;
            this.mode = location.mode;
            this.type.addAll(location.type);
            this.telecom.addAll(location.telecom);
            this.address = location.address;
            this.physicalType = location.physicalType;
            this.position = location.position;
            this.managingOrganization = location.managingOrganization;
            this.partOf = location.partOf;
            this.hoursOfOperation.addAll(location.hoursOfOperation);
            this.availabilityExceptions = location.availabilityExceptions;
            this.endpoint.addAll(location.endpoint);
            return this;
        }
    }
}

