/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
public class ManufacturedItemDefinition
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    @Binding(bindingName="ManufacturedDoseForm", strength=BindingStrength.Value.EXAMPLE, description="Dose form for a medication, in the form suitable for administering to the patient, after mixing, where necessary.", valueSet="http://hl7.org/fhir/ValueSet/manufactured-dose-form")
    @Required
    private final CodeableConcept manufacturedDoseForm;
    @Summary
    @Binding(bindingName="UnitOfPresentation", strength=BindingStrength.Value.EXAMPLE, description="The presentation type in which an administrable medicinal product is given to a patient.", valueSet="http://hl7.org/fhir/ValueSet/unit-of-presentation")
    private final CodeableConcept unitOfPresentation;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> manufacturer;
    @Summary
    @Binding(bindingName="SNOMEDCTSubstanceCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all substance codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
    private final List<CodeableConcept> ingredient;
    @Summary
    private final List<Property> property;

    private ManufacturedItemDefinition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.manufacturedDoseForm = builder.manufacturedDoseForm;
        this.unitOfPresentation = builder.unitOfPresentation;
        this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
        this.property = Collections.unmodifiableList(builder.property);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getManufacturedDoseForm() {
        return this.manufacturedDoseForm;
    }

    public CodeableConcept getUnitOfPresentation() {
        return this.unitOfPresentation;
    }

    public List<Reference> getManufacturer() {
        return this.manufacturer;
    }

    public List<CodeableConcept> getIngredient() {
        return this.ingredient;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.manufacturedDoseForm != null || this.unitOfPresentation != null || !this.manufacturer.isEmpty() || !this.ingredient.isEmpty() || !this.property.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.manufacturedDoseForm, "manufacturedDoseForm", visitor);
                this.accept(this.unitOfPresentation, "unitOfPresentation", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                this.accept(this.ingredient, "ingredient", visitor, CodeableConcept.class);
                this.accept(this.property, "property", visitor, Property.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManufacturedItemDefinition other = (ManufacturedItemDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.manufacturedDoseForm, other.manufacturedDoseForm) && Objects.equals(this.unitOfPresentation, other.unitOfPresentation) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.property, other.property);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.manufacturedDoseForm, this.unitOfPresentation, this.manufacturer, this.ingredient, this.property);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Property
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SNOMEDCTCharacteristicCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all observable entity codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/product-characteristic-codes")
        @Required
        private final CodeableConcept type;
        @Summary
        @Choice(value={CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class})
        private final Element value;

        private Property(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(LocalDate value) {
                this.value = value == null ? null : Date.of(value);
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Property build() {
                Property property = new Property(this);
                if (this.validating) {
                    this.validate(property);
                }
                return property;
            }

            protected void validate(Property property) {
                super.validate(property);
                ValidationSupport.requireNonNull(property.type, "type");
                ValidationSupport.choiceElement(property.value, "value", CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class);
                ValidationSupport.requireValueOrChildren(property);
            }

            protected Builder from(Property property) {
                super.from(property);
                this.type = property.type;
                this.value = property.value;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private PublicationStatus status;
        private CodeableConcept manufacturedDoseForm;
        private CodeableConcept unitOfPresentation;
        private List<Reference> manufacturer = new ArrayList<Reference>();
        private List<CodeableConcept> ingredient = new ArrayList<CodeableConcept>();
        private List<Property> property = new ArrayList<Property>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder manufacturedDoseForm(CodeableConcept manufacturedDoseForm) {
            this.manufacturedDoseForm = manufacturedDoseForm;
            return this;
        }

        public Builder unitOfPresentation(CodeableConcept unitOfPresentation) {
            this.unitOfPresentation = unitOfPresentation;
            return this;
        }

        public Builder manufacturer(Reference ... manufacturer) {
            for (Reference value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Reference> manufacturer) {
            this.manufacturer = new ArrayList<Reference>(manufacturer);
            return this;
        }

        public Builder ingredient(CodeableConcept ... ingredient) {
            for (CodeableConcept value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<CodeableConcept> ingredient) {
            this.ingredient = new ArrayList<CodeableConcept>(ingredient);
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        @Override
        public ManufacturedItemDefinition build() {
            ManufacturedItemDefinition manufacturedItemDefinition = new ManufacturedItemDefinition(this);
            if (this.validating) {
                this.validate(manufacturedItemDefinition);
            }
            return manufacturedItemDefinition;
        }

        protected void validate(ManufacturedItemDefinition manufacturedItemDefinition) {
            super.validate(manufacturedItemDefinition);
            ValidationSupport.checkList(manufacturedItemDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(manufacturedItemDefinition.status, "status");
            ValidationSupport.requireNonNull(manufacturedItemDefinition.manufacturedDoseForm, "manufacturedDoseForm");
            ValidationSupport.checkList(manufacturedItemDefinition.manufacturer, "manufacturer", Reference.class);
            ValidationSupport.checkList(manufacturedItemDefinition.ingredient, "ingredient", CodeableConcept.class);
            ValidationSupport.checkList(manufacturedItemDefinition.property, "property", Property.class);
            ValidationSupport.checkReferenceType(manufacturedItemDefinition.manufacturer, "manufacturer", "Organization");
        }

        protected Builder from(ManufacturedItemDefinition manufacturedItemDefinition) {
            super.from(manufacturedItemDefinition);
            this.identifier.addAll(manufacturedItemDefinition.identifier);
            this.status = manufacturedItemDefinition.status;
            this.manufacturedDoseForm = manufacturedItemDefinition.manufacturedDoseForm;
            this.unitOfPresentation = manufacturedItemDefinition.unitOfPresentation;
            this.manufacturer.addAll(manufacturedItemDefinition.manufacturer);
            this.ingredient.addAll(manufacturedItemDefinition.ingredient);
            this.property.addAll(manufacturedItemDefinition.property);
            return this;
        }
    }
}

