/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Expression;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.RelatedArtifact;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cnl-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/Measure"), @Constraint(id="mea-1", level="Rule", location="(base)", description="Stratifier SHALL be either a single criteria or a set of criteria components", expression="group.stratifier.all((code | description | criteria).exists() xor component.exists())", source="http://hl7.org/fhir/StructureDefinition/Measure"), @Constraint(id="measure-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="subject.as(CodeableConcept).exists() implies (subject.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Measure", generated=true), @Constraint(id="measure-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Measure", generated=true), @Constraint(id="measure-4", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/measure-scoring", expression="scoring.exists() implies (scoring.memberOf('http://hl7.org/fhir/ValueSet/measure-scoring', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Measure", generated=true), @Constraint(id="measure-5", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/composite-measure-scoring", expression="compositeScoring.exists() implies (compositeScoring.memberOf('http://hl7.org/fhir/ValueSet/composite-measure-scoring', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Measure", generated=true), @Constraint(id="measure-6", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/measure-type", expression="type.exists() implies (type.all(memberOf('http://hl7.org/fhir/ValueSet/measure-type', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Measure", generated=true), @Constraint(id="measure-7", level="Warning", location="group.population.code", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/measure-population", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/measure-population', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Measure", generated=true), @Constraint(id="measure-8", level="Warning", location="supplementalData.usage", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/measure-data-usage", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/measure-data-usage', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Measure", generated=true)})
public class Measure
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String title;
    private final org.linuxforhealth.fhir.model.type.String subtitle;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @ReferenceTarget(value={"Group"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SubjectType", strength=BindingStrength.Value.EXTENSIBLE, description="The possible types of subjects for a measure (E.g. Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    private final Element subject;
    @Summary
    private final DateTime date;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final org.linuxforhealth.fhir.model.type.String usage;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Binding(bindingName="DefinitionTopic", strength=BindingStrength.Value.EXAMPLE, description="High-level categorization of the definition, used for searching, sorting, and filtering.", valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    private final List<CodeableConcept> topic;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final List<Canonical> library;
    @Summary
    private final Markdown disclaimer;
    @Summary
    @Binding(bindingName="MeasureScoring", strength=BindingStrength.Value.EXTENSIBLE, description="The scoring type of the measure.", valueSet="http://hl7.org/fhir/ValueSet/measure-scoring")
    private final CodeableConcept scoring;
    @Summary
    @Binding(bindingName="CompositeMeasureScoring", strength=BindingStrength.Value.EXTENSIBLE, description="The composite scoring method of the measure.", valueSet="http://hl7.org/fhir/ValueSet/composite-measure-scoring")
    private final CodeableConcept compositeScoring;
    @Summary
    @Binding(bindingName="MeasureType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of measure (includes codes from 2.16.840.1.113883.1.11.20368).", valueSet="http://hl7.org/fhir/ValueSet/measure-type")
    private final List<CodeableConcept> type;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String riskAdjustment;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String rateAggregation;
    @Summary
    private final Markdown rationale;
    @Summary
    private final Markdown clinicalRecommendationStatement;
    @Summary
    @Binding(bindingName="MeasureImprovementNotation", strength=BindingStrength.Value.REQUIRED, description="Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue.", valueSet="http://hl7.org/fhir/ValueSet/measure-improvement-notation|4.3.0")
    private final CodeableConcept improvementNotation;
    @Summary
    private final List<Markdown> definition;
    @Summary
    private final Markdown guidance;
    private final List<Group> group;
    private final List<SupplementalData> supplementalData;

    private Measure(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.subject = builder.subject;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.usage = builder.usage;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.topic = Collections.unmodifiableList(builder.topic);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.library = Collections.unmodifiableList(builder.library);
        this.disclaimer = builder.disclaimer;
        this.scoring = builder.scoring;
        this.compositeScoring = builder.compositeScoring;
        this.type = Collections.unmodifiableList(builder.type);
        this.riskAdjustment = builder.riskAdjustment;
        this.rateAggregation = builder.rateAggregation;
        this.rationale = builder.rationale;
        this.clinicalRecommendationStatement = builder.clinicalRecommendationStatement;
        this.improvementNotation = builder.improvementNotation;
        this.definition = Collections.unmodifiableList(builder.definition);
        this.guidance = builder.guidance;
        this.group = Collections.unmodifiableList(builder.group);
        this.supplementalData = Collections.unmodifiableList(builder.supplementalData);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public org.linuxforhealth.fhir.model.type.String getTitle() {
        return this.title;
    }

    public org.linuxforhealth.fhir.model.type.String getSubtitle() {
        return this.subtitle;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public Element getSubject() {
        return this.subject;
    }

    public DateTime getDate() {
        return this.date;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public org.linuxforhealth.fhir.model.type.String getUsage() {
        return this.usage;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<CodeableConcept> getTopic() {
        return this.topic;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public List<Canonical> getLibrary() {
        return this.library;
    }

    public Markdown getDisclaimer() {
        return this.disclaimer;
    }

    public CodeableConcept getScoring() {
        return this.scoring;
    }

    public CodeableConcept getCompositeScoring() {
        return this.compositeScoring;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public org.linuxforhealth.fhir.model.type.String getRiskAdjustment() {
        return this.riskAdjustment;
    }

    public org.linuxforhealth.fhir.model.type.String getRateAggregation() {
        return this.rateAggregation;
    }

    public Markdown getRationale() {
        return this.rationale;
    }

    public Markdown getClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement;
    }

    public CodeableConcept getImprovementNotation() {
        return this.improvementNotation;
    }

    public List<Markdown> getDefinition() {
        return this.definition;
    }

    public Markdown getGuidance() {
        return this.guidance;
    }

    public List<Group> getGroup() {
        return this.group;
    }

    public List<SupplementalData> getSupplementalData() {
        return this.supplementalData;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.subtitle != null || this.status != null || this.experimental != null || this.subject != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.usage != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.topic.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || !this.library.isEmpty() || this.disclaimer != null || this.scoring != null || this.compositeScoring != null || !this.type.isEmpty() || this.riskAdjustment != null || this.rateAggregation != null || this.rationale != null || this.clinicalRecommendationStatement != null || this.improvementNotation != null || !this.definition.isEmpty() || this.guidance != null || !this.group.isEmpty() || !this.supplementalData.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.usage, "usage", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.topic, "topic", visitor, CodeableConcept.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.library, "library", visitor, Canonical.class);
                this.accept(this.disclaimer, "disclaimer", visitor);
                this.accept(this.scoring, "scoring", visitor);
                this.accept(this.compositeScoring, "compositeScoring", visitor);
                this.accept(this.type, "type", visitor, CodeableConcept.class);
                this.accept(this.riskAdjustment, "riskAdjustment", visitor);
                this.accept(this.rateAggregation, "rateAggregation", visitor);
                this.accept(this.rationale, "rationale", visitor);
                this.accept(this.clinicalRecommendationStatement, "clinicalRecommendationStatement", visitor);
                this.accept(this.improvementNotation, "improvementNotation", visitor);
                this.accept(this.definition, "definition", visitor, Markdown.class);
                this.accept(this.guidance, "guidance", visitor);
                this.accept(this.group, "group", visitor, Group.class);
                this.accept(this.supplementalData, "supplementalData", visitor, SupplementalData.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Measure other = (Measure)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.usage, other.usage) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.topic, other.topic) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.library, other.library) && Objects.equals(this.disclaimer, other.disclaimer) && Objects.equals(this.scoring, other.scoring) && Objects.equals(this.compositeScoring, other.compositeScoring) && Objects.equals(this.type, other.type) && Objects.equals(this.riskAdjustment, other.riskAdjustment) && Objects.equals(this.rateAggregation, other.rateAggregation) && Objects.equals(this.rationale, other.rationale) && Objects.equals(this.clinicalRecommendationStatement, other.clinicalRecommendationStatement) && Objects.equals(this.improvementNotation, other.improvementNotation) && Objects.equals(this.definition, other.definition) && Objects.equals(this.guidance, other.guidance) && Objects.equals(this.group, other.group) && Objects.equals(this.supplementalData, other.supplementalData);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.subtitle, this.status, this.experimental, this.subject, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.disclaimer, this.scoring, this.compositeScoring, this.type, this.riskAdjustment, this.rateAggregation, this.rationale, this.clinicalRecommendationStatement, this.improvementNotation, this.definition, this.guidance, this.group, this.supplementalData);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SupplementalData
    extends BackboneElement {
        @Binding(bindingName="MeasureSupplementalDataExample", strength=BindingStrength.Value.EXAMPLE, description="Meaning of the supplemental data.", valueSet="http://hl7.org/fhir/ValueSet/measure-supplemental-data-example")
        private final CodeableConcept code;
        @Binding(bindingName="MeasureDataUsage", strength=BindingStrength.Value.EXTENSIBLE, description="The intended usage for supplemental data elements in the measure.", valueSet="http://hl7.org/fhir/ValueSet/measure-data-usage")
        private final List<CodeableConcept> usage;
        private final org.linuxforhealth.fhir.model.type.String description;
        @Required
        private final Expression criteria;

        private SupplementalData(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.usage = Collections.unmodifiableList(builder.usage);
            this.description = builder.description;
            this.criteria = builder.criteria;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public List<CodeableConcept> getUsage() {
            return this.usage;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public Expression getCriteria() {
            return this.criteria;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || !this.usage.isEmpty() || this.description != null || this.criteria != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.usage, "usage", visitor, CodeableConcept.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.criteria, "criteria", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SupplementalData other = (SupplementalData)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.usage, other.usage) && Objects.equals(this.description, other.description) && Objects.equals(this.criteria, other.criteria);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.usage, this.description, this.criteria);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private List<CodeableConcept> usage = new ArrayList<CodeableConcept>();
            private org.linuxforhealth.fhir.model.type.String description;
            private Expression criteria;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder usage(CodeableConcept ... usage) {
                for (CodeableConcept value : usage) {
                    this.usage.add(value);
                }
                return this;
            }

            public Builder usage(Collection<CodeableConcept> usage) {
                this.usage = new ArrayList<CodeableConcept>(usage);
                return this;
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder criteria(Expression criteria) {
                this.criteria = criteria;
                return this;
            }

            @Override
            public SupplementalData build() {
                SupplementalData supplementalData = new SupplementalData(this);
                if (this.validating) {
                    this.validate(supplementalData);
                }
                return supplementalData;
            }

            protected void validate(SupplementalData supplementalData) {
                super.validate(supplementalData);
                ValidationSupport.checkList(supplementalData.usage, "usage", CodeableConcept.class);
                ValidationSupport.requireNonNull(supplementalData.criteria, "criteria");
                ValidationSupport.requireValueOrChildren(supplementalData);
            }

            protected Builder from(SupplementalData supplementalData) {
                super.from(supplementalData);
                this.code = supplementalData.code;
                this.usage.addAll(supplementalData.usage);
                this.description = supplementalData.description;
                this.criteria = supplementalData.criteria;
                return this;
            }
        }
    }

    public static class Group
    extends BackboneElement {
        @Binding(bindingName="MeasureGroupExample", strength=BindingStrength.Value.EXAMPLE, description="Example of measure groups.", valueSet="http://hl7.org/fhir/ValueSet/measure-group-example")
        private final CodeableConcept code;
        private final org.linuxforhealth.fhir.model.type.String description;
        private final List<Population> population;
        private final List<Stratifier> stratifier;

        private Group(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.description = builder.description;
            this.population = Collections.unmodifiableList(builder.population);
            this.stratifier = Collections.unmodifiableList(builder.stratifier);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public List<Population> getPopulation() {
            return this.population;
        }

        public List<Stratifier> getStratifier() {
            return this.stratifier;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.description != null || !this.population.isEmpty() || !this.stratifier.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.population, "population", visitor, Population.class);
                    this.accept(this.stratifier, "stratifier", visitor, Stratifier.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.population, other.population) && Objects.equals(this.stratifier, other.stratifier);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.description, this.population, this.stratifier);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Stratifier
        extends BackboneElement {
            @Binding(bindingName="MeasureStratifierExample", strength=BindingStrength.Value.EXAMPLE, description="Meaning of the stratifier.", valueSet="http://hl7.org/fhir/ValueSet/measure-stratifier-example")
            private final CodeableConcept code;
            private final org.linuxforhealth.fhir.model.type.String description;
            private final Expression criteria;
            private final List<Component> component;

            private Stratifier(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.description = builder.description;
                this.criteria = builder.criteria;
                this.component = Collections.unmodifiableList(builder.component);
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            public Expression getCriteria() {
                return this.criteria;
            }

            public List<Component> getComponent() {
                return this.component;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.description != null || this.criteria != null || !this.component.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.criteria, "criteria", visitor);
                        this.accept(this.component, "component", visitor, Component.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Stratifier other = (Stratifier)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.criteria, other.criteria) && Objects.equals(this.component, other.component);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.description, this.criteria, this.component);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Component
            extends BackboneElement {
                @Binding(bindingName="MeasureStratifierExample", strength=BindingStrength.Value.EXAMPLE, description="Meaning of the stratifier.", valueSet="http://hl7.org/fhir/ValueSet/measure-stratifier-example")
                private final CodeableConcept code;
                private final org.linuxforhealth.fhir.model.type.String description;
                @Required
                private final Expression criteria;

                private Component(Builder builder) {
                    super(builder);
                    this.code = builder.code;
                    this.description = builder.description;
                    this.criteria = builder.criteria;
                }

                public CodeableConcept getCode() {
                    return this.code;
                }

                public org.linuxforhealth.fhir.model.type.String getDescription() {
                    return this.description;
                }

                public Expression getCriteria() {
                    return this.criteria;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.code != null || this.description != null || this.criteria != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.code, "code", visitor);
                            this.accept(this.description, "description", visitor);
                            this.accept(this.criteria, "criteria", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Component other = (Component)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.criteria, other.criteria);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.description, this.criteria);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept code;
                    private org.linuxforhealth.fhir.model.type.String description;
                    private Expression criteria;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder code(CodeableConcept code) {
                        this.code = code;
                        return this;
                    }

                    public Builder description(String description) {
                        this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                        return this;
                    }

                    public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                        this.description = description;
                        return this;
                    }

                    public Builder criteria(Expression criteria) {
                        this.criteria = criteria;
                        return this;
                    }

                    @Override
                    public Component build() {
                        Component component = new Component(this);
                        if (this.validating) {
                            this.validate(component);
                        }
                        return component;
                    }

                    protected void validate(Component component) {
                        super.validate(component);
                        ValidationSupport.requireNonNull(component.criteria, "criteria");
                        ValidationSupport.requireValueOrChildren(component);
                    }

                    protected Builder from(Component component) {
                        super.from(component);
                        this.code = component.code;
                        this.description = component.description;
                        this.criteria = component.criteria;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private org.linuxforhealth.fhir.model.type.String description;
                private Expression criteria;
                private List<Component> component = new ArrayList<Component>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                public Builder criteria(Expression criteria) {
                    this.criteria = criteria;
                    return this;
                }

                public Builder component(Component ... component) {
                    for (Component value : component) {
                        this.component.add(value);
                    }
                    return this;
                }

                public Builder component(Collection<Component> component) {
                    this.component = new ArrayList<Component>(component);
                    return this;
                }

                @Override
                public Stratifier build() {
                    Stratifier stratifier = new Stratifier(this);
                    if (this.validating) {
                        this.validate(stratifier);
                    }
                    return stratifier;
                }

                protected void validate(Stratifier stratifier) {
                    super.validate(stratifier);
                    ValidationSupport.checkList(stratifier.component, "component", Component.class);
                    ValidationSupport.requireValueOrChildren(stratifier);
                }

                protected Builder from(Stratifier stratifier) {
                    super.from(stratifier);
                    this.code = stratifier.code;
                    this.description = stratifier.description;
                    this.criteria = stratifier.criteria;
                    this.component.addAll(stratifier.component);
                    return this;
                }
            }
        }

        public static class Population
        extends BackboneElement {
            @Binding(bindingName="MeasurePopulationType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of population.", valueSet="http://hl7.org/fhir/ValueSet/measure-population")
            private final CodeableConcept code;
            private final org.linuxforhealth.fhir.model.type.String description;
            @Required
            private final Expression criteria;

            private Population(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.description = builder.description;
                this.criteria = builder.criteria;
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            public Expression getCriteria() {
                return this.criteria;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.description != null || this.criteria != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.criteria, "criteria", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Population other = (Population)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.criteria, other.criteria);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.description, this.criteria);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private org.linuxforhealth.fhir.model.type.String description;
                private Expression criteria;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                public Builder criteria(Expression criteria) {
                    this.criteria = criteria;
                    return this;
                }

                @Override
                public Population build() {
                    Population population = new Population(this);
                    if (this.validating) {
                        this.validate(population);
                    }
                    return population;
                }

                protected void validate(Population population) {
                    super.validate(population);
                    ValidationSupport.requireNonNull(population.criteria, "criteria");
                    ValidationSupport.requireValueOrChildren(population);
                }

                protected Builder from(Population population) {
                    super.from(population);
                    this.code = population.code;
                    this.description = population.description;
                    this.criteria = population.criteria;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private org.linuxforhealth.fhir.model.type.String description;
            private List<Population> population = new ArrayList<Population>();
            private List<Stratifier> stratifier = new ArrayList<Stratifier>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder population(Population ... population) {
                for (Population value : population) {
                    this.population.add(value);
                }
                return this;
            }

            public Builder population(Collection<Population> population) {
                this.population = new ArrayList<Population>(population);
                return this;
            }

            public Builder stratifier(Stratifier ... stratifier) {
                for (Stratifier value : stratifier) {
                    this.stratifier.add(value);
                }
                return this;
            }

            public Builder stratifier(Collection<Stratifier> stratifier) {
                this.stratifier = new ArrayList<Stratifier>(stratifier);
                return this;
            }

            @Override
            public Group build() {
                Group group = new Group(this);
                if (this.validating) {
                    this.validate(group);
                }
                return group;
            }

            protected void validate(Group group) {
                super.validate(group);
                ValidationSupport.checkList(group.population, "population", Population.class);
                ValidationSupport.checkList(group.stratifier, "stratifier", Stratifier.class);
                ValidationSupport.requireValueOrChildren(group);
            }

            protected Builder from(Group group) {
                super.from(group);
                this.code = group.code;
                this.description = group.description;
                this.population.addAll(group.population);
                this.stratifier.addAll(group.stratifier);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String version;
        private org.linuxforhealth.fhir.model.type.String name;
        private org.linuxforhealth.fhir.model.type.String title;
        private org.linuxforhealth.fhir.model.type.String subtitle;
        private PublicationStatus status;
        private Boolean experimental;
        private Element subject;
        private DateTime date;
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private org.linuxforhealth.fhir.model.type.String usage;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<CodeableConcept> topic = new ArrayList<CodeableConcept>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private List<Canonical> library = new ArrayList<Canonical>();
        private Markdown disclaimer;
        private CodeableConcept scoring;
        private CodeableConcept compositeScoring;
        private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        private org.linuxforhealth.fhir.model.type.String riskAdjustment;
        private org.linuxforhealth.fhir.model.type.String rateAggregation;
        private Markdown rationale;
        private Markdown clinicalRecommendationStatement;
        private CodeableConcept improvementNotation;
        private List<Markdown> definition = new ArrayList<Markdown>();
        private Markdown guidance;
        private List<Group> group = new ArrayList<Group>();
        private List<SupplementalData> supplementalData = new ArrayList<SupplementalData>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
            return this;
        }

        public Builder title(org.linuxforhealth.fhir.model.type.String title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle == null ? null : org.linuxforhealth.fhir.model.type.String.of(subtitle);
            return this;
        }

        public Builder subtitle(org.linuxforhealth.fhir.model.type.String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder subject(Element subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage == null ? null : org.linuxforhealth.fhir.model.type.String.of(usage);
            return this;
        }

        public Builder usage(org.linuxforhealth.fhir.model.type.String usage) {
            this.usage = usage;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(LocalDate approvalDate) {
            this.approvalDate = approvalDate == null ? null : Date.of(approvalDate);
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(LocalDate lastReviewDate) {
            this.lastReviewDate = lastReviewDate == null ? null : Date.of(lastReviewDate);
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder topic(CodeableConcept ... topic) {
            for (CodeableConcept value : topic) {
                this.topic.add(value);
            }
            return this;
        }

        public Builder topic(Collection<CodeableConcept> topic) {
            this.topic = new ArrayList<CodeableConcept>(topic);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder library(Canonical ... library) {
            for (Canonical value : library) {
                this.library.add(value);
            }
            return this;
        }

        public Builder library(Collection<Canonical> library) {
            this.library = new ArrayList<Canonical>(library);
            return this;
        }

        public Builder disclaimer(Markdown disclaimer) {
            this.disclaimer = disclaimer;
            return this;
        }

        public Builder scoring(CodeableConcept scoring) {
            this.scoring = scoring;
            return this;
        }

        public Builder compositeScoring(CodeableConcept compositeScoring) {
            this.compositeScoring = compositeScoring;
            return this;
        }

        public Builder type(CodeableConcept ... type) {
            for (CodeableConcept value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<CodeableConcept> type) {
            this.type = new ArrayList<CodeableConcept>(type);
            return this;
        }

        public Builder riskAdjustment(String riskAdjustment) {
            this.riskAdjustment = riskAdjustment == null ? null : org.linuxforhealth.fhir.model.type.String.of(riskAdjustment);
            return this;
        }

        public Builder riskAdjustment(org.linuxforhealth.fhir.model.type.String riskAdjustment) {
            this.riskAdjustment = riskAdjustment;
            return this;
        }

        public Builder rateAggregation(String rateAggregation) {
            this.rateAggregation = rateAggregation == null ? null : org.linuxforhealth.fhir.model.type.String.of(rateAggregation);
            return this;
        }

        public Builder rateAggregation(org.linuxforhealth.fhir.model.type.String rateAggregation) {
            this.rateAggregation = rateAggregation;
            return this;
        }

        public Builder rationale(Markdown rationale) {
            this.rationale = rationale;
            return this;
        }

        public Builder clinicalRecommendationStatement(Markdown clinicalRecommendationStatement) {
            this.clinicalRecommendationStatement = clinicalRecommendationStatement;
            return this;
        }

        public Builder improvementNotation(CodeableConcept improvementNotation) {
            this.improvementNotation = improvementNotation;
            return this;
        }

        public Builder definition(Markdown ... definition) {
            for (Markdown value : definition) {
                this.definition.add(value);
            }
            return this;
        }

        public Builder definition(Collection<Markdown> definition) {
            this.definition = new ArrayList<Markdown>(definition);
            return this;
        }

        public Builder guidance(Markdown guidance) {
            this.guidance = guidance;
            return this;
        }

        public Builder group(Group ... group) {
            for (Group value : group) {
                this.group.add(value);
            }
            return this;
        }

        public Builder group(Collection<Group> group) {
            this.group = new ArrayList<Group>(group);
            return this;
        }

        public Builder supplementalData(SupplementalData ... supplementalData) {
            for (SupplementalData value : supplementalData) {
                this.supplementalData.add(value);
            }
            return this;
        }

        public Builder supplementalData(Collection<SupplementalData> supplementalData) {
            this.supplementalData = new ArrayList<SupplementalData>(supplementalData);
            return this;
        }

        @Override
        public Measure build() {
            Measure measure = new Measure(this);
            if (this.validating) {
                this.validate(measure);
            }
            return measure;
        }

        protected void validate(Measure measure) {
            super.validate(measure);
            ValidationSupport.checkList(measure.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(measure.status, "status");
            ValidationSupport.choiceElement(measure.subject, "subject", CodeableConcept.class, Reference.class);
            ValidationSupport.checkList(measure.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(measure.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(measure.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(measure.topic, "topic", CodeableConcept.class);
            ValidationSupport.checkList(measure.author, "author", ContactDetail.class);
            ValidationSupport.checkList(measure.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(measure.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(measure.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(measure.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.checkList(measure.library, "library", Canonical.class);
            ValidationSupport.checkList(measure.type, "type", CodeableConcept.class);
            ValidationSupport.checkList(measure.definition, "definition", Markdown.class);
            ValidationSupport.checkList(measure.group, "group", Group.class);
            ValidationSupport.checkList(measure.supplementalData, "supplementalData", SupplementalData.class);
            ValidationSupport.checkValueSetBinding(measure.improvementNotation, "improvementNotation", "http://hl7.org/fhir/ValueSet/measure-improvement-notation", "http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase", "decrease");
            ValidationSupport.checkReferenceType(measure.subject, "subject", "Group");
        }

        protected Builder from(Measure measure) {
            super.from(measure);
            this.url = measure.url;
            this.identifier.addAll(measure.identifier);
            this.version = measure.version;
            this.name = measure.name;
            this.title = measure.title;
            this.subtitle = measure.subtitle;
            this.status = measure.status;
            this.experimental = measure.experimental;
            this.subject = measure.subject;
            this.date = measure.date;
            this.publisher = measure.publisher;
            this.contact.addAll(measure.contact);
            this.description = measure.description;
            this.useContext.addAll(measure.useContext);
            this.jurisdiction.addAll(measure.jurisdiction);
            this.purpose = measure.purpose;
            this.usage = measure.usage;
            this.copyright = measure.copyright;
            this.approvalDate = measure.approvalDate;
            this.lastReviewDate = measure.lastReviewDate;
            this.effectivePeriod = measure.effectivePeriod;
            this.topic.addAll(measure.topic);
            this.author.addAll(measure.author);
            this.editor.addAll(measure.editor);
            this.reviewer.addAll(measure.reviewer);
            this.endorser.addAll(measure.endorser);
            this.relatedArtifact.addAll(measure.relatedArtifact);
            this.library.addAll(measure.library);
            this.disclaimer = measure.disclaimer;
            this.scoring = measure.scoring;
            this.compositeScoring = measure.compositeScoring;
            this.type.addAll(measure.type);
            this.riskAdjustment = measure.riskAdjustment;
            this.rateAggregation = measure.rateAggregation;
            this.rationale = measure.rationale;
            this.clinicalRecommendationStatement = measure.clinicalRecommendationStatement;
            this.improvementNotation = measure.improvementNotation;
            this.definition.addAll(measure.definition);
            this.guidance = measure.guidance;
            this.group.addAll(measure.group);
            this.supplementalData.addAll(measure.supplementalData);
            return this;
        }
    }
}

