/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.MarketingStatus;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="medicinalProductDefinition-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="status.exists() implies (status.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/MedicinalProductDefinition", generated=true), @Constraint(id="medicinalProductDefinition-1", level="Warning", location="name.countryLanguage.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/MedicinalProductDefinition", generated=true)})
public class MedicinalProductDefinition
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="MedicinalProductType", strength=BindingStrength.Value.EXAMPLE, description="Overall defining type of this medicinal product.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-type")
    private final CodeableConcept type;
    @Summary
    @Binding(bindingName="MedicinalProductType", strength=BindingStrength.Value.EXAMPLE, description="Applicable domain for this product (e.g. human, veterinary).", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-domain")
    private final CodeableConcept domain;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    private final CodeableConcept status;
    @Summary
    private final DateTime statusDate;
    @Summary
    private final Markdown description;
    @Summary
    @Binding(bindingName="CombinedDoseForm", strength=BindingStrength.Value.EXAMPLE, description="Dose forms for a product as a whole, considering all individual parts, but before any mixing", valueSet="http://hl7.org/fhir/ValueSet/combined-dose-form")
    private final CodeableConcept combinedPharmaceuticalDoseForm;
    @Summary
    @Binding(bindingName="SNOMEDCTRouteCodes", strength=BindingStrength.Value.EXAMPLE, description="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient's body.", valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    private final List<CodeableConcept> route;
    @Summary
    private final Markdown indication;
    @Summary
    @Binding(bindingName="LegalStatusOfSupply", strength=BindingStrength.Value.EXAMPLE, description="The prescription supply types appropriate to a medicinal product", valueSet="http://hl7.org/fhir/ValueSet/legal-status-of-supply")
    private final CodeableConcept legalStatusOfSupply;
    @Summary
    @Binding(bindingName="AdditionalMonitoring", strength=BindingStrength.Value.EXAMPLE, description="Extra measures defined for a Medicinal Product, such as heightened reporting requirements (e.g. Black Triangle Monitoring).", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-additional-monitoring")
    private final CodeableConcept additionalMonitoringIndicator;
    @Summary
    @Binding(bindingName="SpecialMeasures", strength=BindingStrength.Value.EXAMPLE, description="Extra measures defined for a Medicinal Product, such as a requirement to conduct post-authorisation studies.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-special-measures")
    private final List<CodeableConcept> specialMeasures;
    @Summary
    @Binding(bindingName="PediatricUse", strength=BindingStrength.Value.EXAMPLE, description="Suitability for age groups, in particular children.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-pediatric-use")
    private final CodeableConcept pediatricUseIndicator;
    @Summary
    @Binding(bindingName="ProductClassification", strength=BindingStrength.Value.EXAMPLE, description="This value set includes codes from the Anatomical Therapeutic Chemical Classification System - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/product-classification-codes")
    private final List<CodeableConcept> classification;
    @Summary
    private final List<MarketingStatus> marketingStatus;
    @Summary
    @Binding(bindingName="MedicinalProductPackageType", strength=BindingStrength.Value.EXAMPLE, description="Types of medicinal product packs", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-package-type")
    private final List<CodeableConcept> packagedMedicinalProduct;
    @Summary
    @Binding(bindingName="SNOMEDCTSubstanceCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all substance codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
    private final List<CodeableConcept> ingredient;
    @Summary
    @Binding(bindingName="SNOMEDCTSubstanceCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all substance codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
    private final List<CodeableReference> impurity;
    @Summary
    @ReferenceTarget(value={"DocumentReference"})
    private final List<Reference> attachedDocument;
    @Summary
    @ReferenceTarget(value={"DocumentReference"})
    private final List<Reference> masterFile;
    @Summary
    private final List<Contact> contact;
    @Summary
    @ReferenceTarget(value={"ResearchStudy"})
    private final List<Reference> clinicalTrial;
    @Summary
    @Binding(bindingName="MedicationFormalRepresentation", strength=BindingStrength.Value.EXAMPLE, description="A coded concept that defines the type of a medication.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    private final List<Coding> code;
    @Summary
    @Required
    private final List<Name> name;
    @Summary
    private final List<CrossReference> crossReference;
    @Summary
    private final List<Operation> operation;
    @Summary
    private final List<Characteristic> characteristic;

    private MedicinalProductDefinition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.type = builder.type;
        this.domain = builder.domain;
        this.version = builder.version;
        this.status = builder.status;
        this.statusDate = builder.statusDate;
        this.description = builder.description;
        this.combinedPharmaceuticalDoseForm = builder.combinedPharmaceuticalDoseForm;
        this.route = Collections.unmodifiableList(builder.route);
        this.indication = builder.indication;
        this.legalStatusOfSupply = builder.legalStatusOfSupply;
        this.additionalMonitoringIndicator = builder.additionalMonitoringIndicator;
        this.specialMeasures = Collections.unmodifiableList(builder.specialMeasures);
        this.pediatricUseIndicator = builder.pediatricUseIndicator;
        this.classification = Collections.unmodifiableList(builder.classification);
        this.marketingStatus = Collections.unmodifiableList(builder.marketingStatus);
        this.packagedMedicinalProduct = Collections.unmodifiableList(builder.packagedMedicinalProduct);
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
        this.impurity = Collections.unmodifiableList(builder.impurity);
        this.attachedDocument = Collections.unmodifiableList(builder.attachedDocument);
        this.masterFile = Collections.unmodifiableList(builder.masterFile);
        this.contact = Collections.unmodifiableList(builder.contact);
        this.clinicalTrial = Collections.unmodifiableList(builder.clinicalTrial);
        this.code = Collections.unmodifiableList(builder.code);
        this.name = Collections.unmodifiableList(builder.name);
        this.crossReference = Collections.unmodifiableList(builder.crossReference);
        this.operation = Collections.unmodifiableList(builder.operation);
        this.characteristic = Collections.unmodifiableList(builder.characteristic);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public CodeableConcept getDomain() {
        return this.domain;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public DateTime getStatusDate() {
        return this.statusDate;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public CodeableConcept getCombinedPharmaceuticalDoseForm() {
        return this.combinedPharmaceuticalDoseForm;
    }

    public List<CodeableConcept> getRoute() {
        return this.route;
    }

    public Markdown getIndication() {
        return this.indication;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        return this.legalStatusOfSupply;
    }

    public CodeableConcept getAdditionalMonitoringIndicator() {
        return this.additionalMonitoringIndicator;
    }

    public List<CodeableConcept> getSpecialMeasures() {
        return this.specialMeasures;
    }

    public CodeableConcept getPediatricUseIndicator() {
        return this.pediatricUseIndicator;
    }

    public List<CodeableConcept> getClassification() {
        return this.classification;
    }

    public List<MarketingStatus> getMarketingStatus() {
        return this.marketingStatus;
    }

    public List<CodeableConcept> getPackagedMedicinalProduct() {
        return this.packagedMedicinalProduct;
    }

    public List<CodeableConcept> getIngredient() {
        return this.ingredient;
    }

    public List<CodeableReference> getImpurity() {
        return this.impurity;
    }

    public List<Reference> getAttachedDocument() {
        return this.attachedDocument;
    }

    public List<Reference> getMasterFile() {
        return this.masterFile;
    }

    public List<Contact> getContact() {
        return this.contact;
    }

    public List<Reference> getClinicalTrial() {
        return this.clinicalTrial;
    }

    public List<Coding> getCode() {
        return this.code;
    }

    public List<Name> getName() {
        return this.name;
    }

    public List<CrossReference> getCrossReference() {
        return this.crossReference;
    }

    public List<Operation> getOperation() {
        return this.operation;
    }

    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.domain != null || this.version != null || this.status != null || this.statusDate != null || this.description != null || this.combinedPharmaceuticalDoseForm != null || !this.route.isEmpty() || this.indication != null || this.legalStatusOfSupply != null || this.additionalMonitoringIndicator != null || !this.specialMeasures.isEmpty() || this.pediatricUseIndicator != null || !this.classification.isEmpty() || !this.marketingStatus.isEmpty() || !this.packagedMedicinalProduct.isEmpty() || !this.ingredient.isEmpty() || !this.impurity.isEmpty() || !this.attachedDocument.isEmpty() || !this.masterFile.isEmpty() || !this.contact.isEmpty() || !this.clinicalTrial.isEmpty() || !this.code.isEmpty() || !this.name.isEmpty() || !this.crossReference.isEmpty() || !this.operation.isEmpty() || !this.characteristic.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.domain, "domain", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusDate, "statusDate", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.combinedPharmaceuticalDoseForm, "combinedPharmaceuticalDoseForm", visitor);
                this.accept(this.route, "route", visitor, CodeableConcept.class);
                this.accept(this.indication, "indication", visitor);
                this.accept(this.legalStatusOfSupply, "legalStatusOfSupply", visitor);
                this.accept(this.additionalMonitoringIndicator, "additionalMonitoringIndicator", visitor);
                this.accept(this.specialMeasures, "specialMeasures", visitor, CodeableConcept.class);
                this.accept(this.pediatricUseIndicator, "pediatricUseIndicator", visitor);
                this.accept(this.classification, "classification", visitor, CodeableConcept.class);
                this.accept(this.marketingStatus, "marketingStatus", visitor, MarketingStatus.class);
                this.accept(this.packagedMedicinalProduct, "packagedMedicinalProduct", visitor, CodeableConcept.class);
                this.accept(this.ingredient, "ingredient", visitor, CodeableConcept.class);
                this.accept(this.impurity, "impurity", visitor, CodeableReference.class);
                this.accept(this.attachedDocument, "attachedDocument", visitor, Reference.class);
                this.accept(this.masterFile, "masterFile", visitor, Reference.class);
                this.accept(this.contact, "contact", visitor, Contact.class);
                this.accept(this.clinicalTrial, "clinicalTrial", visitor, Reference.class);
                this.accept(this.code, "code", visitor, Coding.class);
                this.accept(this.name, "name", visitor, Name.class);
                this.accept(this.crossReference, "crossReference", visitor, CrossReference.class);
                this.accept(this.operation, "operation", visitor, Operation.class);
                this.accept(this.characteristic, "characteristic", visitor, Characteristic.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductDefinition other = (MedicinalProductDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.domain, other.domain) && Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.description, other.description) && Objects.equals(this.combinedPharmaceuticalDoseForm, other.combinedPharmaceuticalDoseForm) && Objects.equals(this.route, other.route) && Objects.equals(this.indication, other.indication) && Objects.equals(this.legalStatusOfSupply, other.legalStatusOfSupply) && Objects.equals(this.additionalMonitoringIndicator, other.additionalMonitoringIndicator) && Objects.equals(this.specialMeasures, other.specialMeasures) && Objects.equals(this.pediatricUseIndicator, other.pediatricUseIndicator) && Objects.equals(this.classification, other.classification) && Objects.equals(this.marketingStatus, other.marketingStatus) && Objects.equals(this.packagedMedicinalProduct, other.packagedMedicinalProduct) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.impurity, other.impurity) && Objects.equals(this.attachedDocument, other.attachedDocument) && Objects.equals(this.masterFile, other.masterFile) && Objects.equals(this.contact, other.contact) && Objects.equals(this.clinicalTrial, other.clinicalTrial) && Objects.equals(this.code, other.code) && Objects.equals(this.name, other.name) && Objects.equals(this.crossReference, other.crossReference) && Objects.equals(this.operation, other.operation) && Objects.equals(this.characteristic, other.characteristic);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.type, this.domain, this.version, this.status, this.statusDate, this.description, this.combinedPharmaceuticalDoseForm, this.route, this.indication, this.legalStatusOfSupply, this.additionalMonitoringIndicator, this.specialMeasures, this.pediatricUseIndicator, this.classification, this.marketingStatus, this.packagedMedicinalProduct, this.ingredient, this.impurity, this.attachedDocument, this.masterFile, this.contact, this.clinicalTrial, this.code, this.name, this.crossReference, this.operation, this.characteristic);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Characteristic
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ProductCharacteristic", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all observable entity codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/product-characteristic-codes")
        @Required
        private final CodeableConcept type;
        @Summary
        @Choice(value={CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class})
        private final Element value;

        private Characteristic(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Characteristic other = (Characteristic)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(LocalDate value) {
                this.value = value == null ? null : Date.of(value);
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Characteristic build() {
                Characteristic characteristic = new Characteristic(this);
                if (this.validating) {
                    this.validate(characteristic);
                }
                return characteristic;
            }

            protected void validate(Characteristic characteristic) {
                super.validate(characteristic);
                ValidationSupport.requireNonNull(characteristic.type, "type");
                ValidationSupport.choiceElement(characteristic.value, "value", CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class);
                ValidationSupport.requireValueOrChildren(characteristic);
            }

            protected Builder from(Characteristic characteristic) {
                super.from(characteristic);
                this.type = characteristic.type;
                this.value = characteristic.value;
                return this;
            }
        }
    }

    public static class Operation
    extends BackboneElement {
        @Summary
        private final CodeableReference type;
        @Summary
        private final Period effectiveDate;
        @Summary
        @ReferenceTarget(value={"Organization"})
        private final List<Reference> organization;
        @Summary
        @Binding(bindingName="ProductConfidentiality", strength=BindingStrength.Value.EXAMPLE, description="Confidentiality rating, e.g. commercial sensitivity for a Medicinal Product.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-confidentiality")
        private final CodeableConcept confidentialityIndicator;

        private Operation(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.effectiveDate = builder.effectiveDate;
            this.organization = Collections.unmodifiableList(builder.organization);
            this.confidentialityIndicator = builder.confidentialityIndicator;
        }

        public CodeableReference getType() {
            return this.type;
        }

        public Period getEffectiveDate() {
            return this.effectiveDate;
        }

        public List<Reference> getOrganization() {
            return this.organization;
        }

        public CodeableConcept getConfidentialityIndicator() {
            return this.confidentialityIndicator;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.effectiveDate != null || !this.organization.isEmpty() || this.confidentialityIndicator != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.effectiveDate, "effectiveDate", visitor);
                    this.accept(this.organization, "organization", visitor, Reference.class);
                    this.accept(this.confidentialityIndicator, "confidentialityIndicator", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Operation other = (Operation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.effectiveDate, other.effectiveDate) && Objects.equals(this.organization, other.organization) && Objects.equals(this.confidentialityIndicator, other.confidentialityIndicator);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.effectiveDate, this.organization, this.confidentialityIndicator);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference type;
            private Period effectiveDate;
            private List<Reference> organization = new ArrayList<Reference>();
            private CodeableConcept confidentialityIndicator;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableReference type) {
                this.type = type;
                return this;
            }

            public Builder effectiveDate(Period effectiveDate) {
                this.effectiveDate = effectiveDate;
                return this;
            }

            public Builder organization(Reference ... organization) {
                for (Reference value : organization) {
                    this.organization.add(value);
                }
                return this;
            }

            public Builder organization(Collection<Reference> organization) {
                this.organization = new ArrayList<Reference>(organization);
                return this;
            }

            public Builder confidentialityIndicator(CodeableConcept confidentialityIndicator) {
                this.confidentialityIndicator = confidentialityIndicator;
                return this;
            }

            @Override
            public Operation build() {
                Operation operation = new Operation(this);
                if (this.validating) {
                    this.validate(operation);
                }
                return operation;
            }

            protected void validate(Operation operation) {
                super.validate(operation);
                ValidationSupport.checkList(operation.organization, "organization", Reference.class);
                ValidationSupport.checkReferenceType(operation.organization, "organization", "Organization");
                ValidationSupport.requireValueOrChildren(operation);
            }

            protected Builder from(Operation operation) {
                super.from(operation);
                this.type = operation.type;
                this.effectiveDate = operation.effectiveDate;
                this.organization.addAll(operation.organization);
                this.confidentialityIndicator = operation.confidentialityIndicator;
                return this;
            }
        }
    }

    public static class CrossReference
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableReference product;
        @Summary
        @Binding(bindingName="ProductCrossReferenceType", strength=BindingStrength.Value.EXAMPLE, description="Extra measures defined for a Medicinal Product, such as heightened reporting requirements.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-cross-reference-type")
        private final CodeableConcept type;

        private CrossReference(Builder builder) {
            super(builder);
            this.product = builder.product;
            this.type = builder.type;
        }

        public CodeableReference getProduct() {
            return this.product;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.product != null || this.type != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.product, "product", visitor);
                    this.accept(this.type, "type", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CrossReference other = (CrossReference)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.product, other.product) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.product, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference product;
            private CodeableConcept type;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder product(CodeableReference product) {
                this.product = product;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            @Override
            public CrossReference build() {
                CrossReference crossReference = new CrossReference(this);
                if (this.validating) {
                    this.validate(crossReference);
                }
                return crossReference;
            }

            protected void validate(CrossReference crossReference) {
                super.validate(crossReference);
                ValidationSupport.requireNonNull(crossReference.product, "product");
                ValidationSupport.requireValueOrChildren(crossReference);
            }

            protected Builder from(CrossReference crossReference) {
                super.from(crossReference);
                this.product = crossReference.product;
                this.type = crossReference.type;
                return this;
            }
        }
    }

    public static class Name
    extends BackboneElement {
        @Summary
        @Required
        private final org.linuxforhealth.fhir.model.type.String productName;
        @Summary
        @Binding(bindingName="ProductNameType", strength=BindingStrength.Value.EXAMPLE, description="Type of a name for a Medicinal Product.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-name-type")
        private final CodeableConcept type;
        @Summary
        private final List<NamePart> namePart;
        @Summary
        private final List<CountryLanguage> countryLanguage;

        private Name(Builder builder) {
            super(builder);
            this.productName = builder.productName;
            this.type = builder.type;
            this.namePart = Collections.unmodifiableList(builder.namePart);
            this.countryLanguage = Collections.unmodifiableList(builder.countryLanguage);
        }

        public org.linuxforhealth.fhir.model.type.String getProductName() {
            return this.productName;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<NamePart> getNamePart() {
            return this.namePart;
        }

        public List<CountryLanguage> getCountryLanguage() {
            return this.countryLanguage;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.productName != null || this.type != null || !this.namePart.isEmpty() || !this.countryLanguage.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.productName, "productName", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.namePart, "namePart", visitor, NamePart.class);
                    this.accept(this.countryLanguage, "countryLanguage", visitor, CountryLanguage.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Name other = (Name)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.productName, other.productName) && Objects.equals(this.type, other.type) && Objects.equals(this.namePart, other.namePart) && Objects.equals(this.countryLanguage, other.countryLanguage);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.productName, this.type, this.namePart, this.countryLanguage);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class CountryLanguage
        extends BackboneElement {
            @Summary
            @Binding(bindingName="Country", strength=BindingStrength.Value.EXAMPLE, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/country")
            @Required
            private final CodeableConcept country;
            @Summary
            @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXAMPLE, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
            private final CodeableConcept jurisdiction;
            @Summary
            @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="IETF language tag", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
            @Required
            private final CodeableConcept language;

            private CountryLanguage(Builder builder) {
                super(builder);
                this.country = builder.country;
                this.jurisdiction = builder.jurisdiction;
                this.language = builder.language;
            }

            public CodeableConcept getCountry() {
                return this.country;
            }

            public CodeableConcept getJurisdiction() {
                return this.jurisdiction;
            }

            public CodeableConcept getLanguage() {
                return this.language;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.country != null || this.jurisdiction != null || this.language != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.country, "country", visitor);
                        this.accept(this.jurisdiction, "jurisdiction", visitor);
                        this.accept(this.language, "language", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                CountryLanguage other = (CountryLanguage)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.country, other.country) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.language, other.language);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.country, this.jurisdiction, this.language);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept country;
                private CodeableConcept jurisdiction;
                private CodeableConcept language;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder country(CodeableConcept country) {
                    this.country = country;
                    return this;
                }

                public Builder jurisdiction(CodeableConcept jurisdiction) {
                    this.jurisdiction = jurisdiction;
                    return this;
                }

                public Builder language(CodeableConcept language) {
                    this.language = language;
                    return this;
                }

                @Override
                public CountryLanguage build() {
                    CountryLanguage countryLanguage = new CountryLanguage(this);
                    if (this.validating) {
                        this.validate(countryLanguage);
                    }
                    return countryLanguage;
                }

                protected void validate(CountryLanguage countryLanguage) {
                    super.validate(countryLanguage);
                    ValidationSupport.requireNonNull(countryLanguage.country, "country");
                    ValidationSupport.requireNonNull(countryLanguage.language, "language");
                    ValidationSupport.checkValueSetBinding(countryLanguage.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
                    ValidationSupport.requireValueOrChildren(countryLanguage);
                }

                protected Builder from(CountryLanguage countryLanguage) {
                    super.from(countryLanguage);
                    this.country = countryLanguage.country;
                    this.jurisdiction = countryLanguage.jurisdiction;
                    this.language = countryLanguage.language;
                    return this;
                }
            }
        }

        public static class NamePart
        extends BackboneElement {
            @Summary
            @Required
            private final org.linuxforhealth.fhir.model.type.String part;
            @Summary
            @Binding(bindingName="ProductNamePartType", strength=BindingStrength.Value.EXAMPLE, description="Type of part of a name for a Medicinal Product.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-name-part-type")
            @Required
            private final CodeableConcept type;

            private NamePart(Builder builder) {
                super(builder);
                this.part = builder.part;
                this.type = builder.type;
            }

            public org.linuxforhealth.fhir.model.type.String getPart() {
                return this.part;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.part != null || this.type != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.part, "part", visitor);
                        this.accept(this.type, "type", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                NamePart other = (NamePart)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.part, other.part) && Objects.equals(this.type, other.type);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.part, this.type);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String part;
                private CodeableConcept type;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder part(String part) {
                    this.part = part == null ? null : org.linuxforhealth.fhir.model.type.String.of(part);
                    return this;
                }

                public Builder part(org.linuxforhealth.fhir.model.type.String part) {
                    this.part = part;
                    return this;
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                @Override
                public NamePart build() {
                    NamePart namePart = new NamePart(this);
                    if (this.validating) {
                        this.validate(namePart);
                    }
                    return namePart;
                }

                protected void validate(NamePart namePart) {
                    super.validate(namePart);
                    ValidationSupport.requireNonNull(namePart.part, "part");
                    ValidationSupport.requireNonNull(namePart.type, "type");
                    ValidationSupport.requireValueOrChildren(namePart);
                }

                protected Builder from(NamePart namePart) {
                    super.from(namePart);
                    this.part = namePart.part;
                    this.type = namePart.type;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String productName;
            private CodeableConcept type;
            private List<NamePart> namePart = new ArrayList<NamePart>();
            private List<CountryLanguage> countryLanguage = new ArrayList<CountryLanguage>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder productName(String productName) {
                this.productName = productName == null ? null : org.linuxforhealth.fhir.model.type.String.of(productName);
                return this;
            }

            public Builder productName(org.linuxforhealth.fhir.model.type.String productName) {
                this.productName = productName;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder namePart(NamePart ... namePart) {
                for (NamePart value : namePart) {
                    this.namePart.add(value);
                }
                return this;
            }

            public Builder namePart(Collection<NamePart> namePart) {
                this.namePart = new ArrayList<NamePart>(namePart);
                return this;
            }

            public Builder countryLanguage(CountryLanguage ... countryLanguage) {
                for (CountryLanguage value : countryLanguage) {
                    this.countryLanguage.add(value);
                }
                return this;
            }

            public Builder countryLanguage(Collection<CountryLanguage> countryLanguage) {
                this.countryLanguage = new ArrayList<CountryLanguage>(countryLanguage);
                return this;
            }

            @Override
            public Name build() {
                Name name = new Name(this);
                if (this.validating) {
                    this.validate(name);
                }
                return name;
            }

            protected void validate(Name name) {
                super.validate(name);
                ValidationSupport.requireNonNull(name.productName, "productName");
                ValidationSupport.checkList(name.namePart, "namePart", NamePart.class);
                ValidationSupport.checkList(name.countryLanguage, "countryLanguage", CountryLanguage.class);
                ValidationSupport.requireValueOrChildren(name);
            }

            protected Builder from(Name name) {
                super.from(name);
                this.productName = name.productName;
                this.type = name.type;
                this.namePart.addAll(name.namePart);
                this.countryLanguage.addAll(name.countryLanguage);
                return this;
            }
        }
    }

    public static class Contact
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ProductContactType", strength=BindingStrength.Value.EXAMPLE, description="Extra measures defined for a Medicinal Product, such as heightened reporting requirements.", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-contact-type")
        private final CodeableConcept type;
        @Summary
        @ReferenceTarget(value={"Organization", "PractitionerRole"})
        @Required
        private final Reference contact;

        private Contact(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.contact = builder.contact;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Reference getContact() {
            return this.contact;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.contact != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.contact, "contact", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Contact other = (Contact)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.contact, other.contact);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.contact);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Reference contact;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder contact(Reference contact) {
                this.contact = contact;
                return this;
            }

            @Override
            public Contact build() {
                Contact contact = new Contact(this);
                if (this.validating) {
                    this.validate(contact);
                }
                return contact;
            }

            protected void validate(Contact contact) {
                super.validate(contact);
                ValidationSupport.requireNonNull(contact.contact, "contact");
                ValidationSupport.checkReferenceType(contact.contact, "contact", "Organization", "PractitionerRole");
                ValidationSupport.requireValueOrChildren(contact);
            }

            protected Builder from(Contact contact) {
                super.from(contact);
                this.type = contact.type;
                this.contact = contact.contact;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept type;
        private CodeableConcept domain;
        private org.linuxforhealth.fhir.model.type.String version;
        private CodeableConcept status;
        private DateTime statusDate;
        private Markdown description;
        private CodeableConcept combinedPharmaceuticalDoseForm;
        private List<CodeableConcept> route = new ArrayList<CodeableConcept>();
        private Markdown indication;
        private CodeableConcept legalStatusOfSupply;
        private CodeableConcept additionalMonitoringIndicator;
        private List<CodeableConcept> specialMeasures = new ArrayList<CodeableConcept>();
        private CodeableConcept pediatricUseIndicator;
        private List<CodeableConcept> classification = new ArrayList<CodeableConcept>();
        private List<MarketingStatus> marketingStatus = new ArrayList<MarketingStatus>();
        private List<CodeableConcept> packagedMedicinalProduct = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> ingredient = new ArrayList<CodeableConcept>();
        private List<CodeableReference> impurity = new ArrayList<CodeableReference>();
        private List<Reference> attachedDocument = new ArrayList<Reference>();
        private List<Reference> masterFile = new ArrayList<Reference>();
        private List<Contact> contact = new ArrayList<Contact>();
        private List<Reference> clinicalTrial = new ArrayList<Reference>();
        private List<Coding> code = new ArrayList<Coding>();
        private List<Name> name = new ArrayList<Name>();
        private List<CrossReference> crossReference = new ArrayList<CrossReference>();
        private List<Operation> operation = new ArrayList<Operation>();
        private List<Characteristic> characteristic = new ArrayList<Characteristic>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder domain(CodeableConcept domain) {
            this.domain = domain;
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder statusDate(DateTime statusDate) {
            this.statusDate = statusDate;
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder combinedPharmaceuticalDoseForm(CodeableConcept combinedPharmaceuticalDoseForm) {
            this.combinedPharmaceuticalDoseForm = combinedPharmaceuticalDoseForm;
            return this;
        }

        public Builder route(CodeableConcept ... route) {
            for (CodeableConcept value : route) {
                this.route.add(value);
            }
            return this;
        }

        public Builder route(Collection<CodeableConcept> route) {
            this.route = new ArrayList<CodeableConcept>(route);
            return this;
        }

        public Builder indication(Markdown indication) {
            this.indication = indication;
            return this;
        }

        public Builder legalStatusOfSupply(CodeableConcept legalStatusOfSupply) {
            this.legalStatusOfSupply = legalStatusOfSupply;
            return this;
        }

        public Builder additionalMonitoringIndicator(CodeableConcept additionalMonitoringIndicator) {
            this.additionalMonitoringIndicator = additionalMonitoringIndicator;
            return this;
        }

        public Builder specialMeasures(CodeableConcept ... specialMeasures) {
            for (CodeableConcept value : specialMeasures) {
                this.specialMeasures.add(value);
            }
            return this;
        }

        public Builder specialMeasures(Collection<CodeableConcept> specialMeasures) {
            this.specialMeasures = new ArrayList<CodeableConcept>(specialMeasures);
            return this;
        }

        public Builder pediatricUseIndicator(CodeableConcept pediatricUseIndicator) {
            this.pediatricUseIndicator = pediatricUseIndicator;
            return this;
        }

        public Builder classification(CodeableConcept ... classification) {
            for (CodeableConcept value : classification) {
                this.classification.add(value);
            }
            return this;
        }

        public Builder classification(Collection<CodeableConcept> classification) {
            this.classification = new ArrayList<CodeableConcept>(classification);
            return this;
        }

        public Builder marketingStatus(MarketingStatus ... marketingStatus) {
            for (MarketingStatus value : marketingStatus) {
                this.marketingStatus.add(value);
            }
            return this;
        }

        public Builder marketingStatus(Collection<MarketingStatus> marketingStatus) {
            this.marketingStatus = new ArrayList<MarketingStatus>(marketingStatus);
            return this;
        }

        public Builder packagedMedicinalProduct(CodeableConcept ... packagedMedicinalProduct) {
            for (CodeableConcept value : packagedMedicinalProduct) {
                this.packagedMedicinalProduct.add(value);
            }
            return this;
        }

        public Builder packagedMedicinalProduct(Collection<CodeableConcept> packagedMedicinalProduct) {
            this.packagedMedicinalProduct = new ArrayList<CodeableConcept>(packagedMedicinalProduct);
            return this;
        }

        public Builder ingredient(CodeableConcept ... ingredient) {
            for (CodeableConcept value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<CodeableConcept> ingredient) {
            this.ingredient = new ArrayList<CodeableConcept>(ingredient);
            return this;
        }

        public Builder impurity(CodeableReference ... impurity) {
            for (CodeableReference value : impurity) {
                this.impurity.add(value);
            }
            return this;
        }

        public Builder impurity(Collection<CodeableReference> impurity) {
            this.impurity = new ArrayList<CodeableReference>(impurity);
            return this;
        }

        public Builder attachedDocument(Reference ... attachedDocument) {
            for (Reference value : attachedDocument) {
                this.attachedDocument.add(value);
            }
            return this;
        }

        public Builder attachedDocument(Collection<Reference> attachedDocument) {
            this.attachedDocument = new ArrayList<Reference>(attachedDocument);
            return this;
        }

        public Builder masterFile(Reference ... masterFile) {
            for (Reference value : masterFile) {
                this.masterFile.add(value);
            }
            return this;
        }

        public Builder masterFile(Collection<Reference> masterFile) {
            this.masterFile = new ArrayList<Reference>(masterFile);
            return this;
        }

        public Builder contact(Contact ... contact) {
            for (Contact value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<Contact> contact) {
            this.contact = new ArrayList<Contact>(contact);
            return this;
        }

        public Builder clinicalTrial(Reference ... clinicalTrial) {
            for (Reference value : clinicalTrial) {
                this.clinicalTrial.add(value);
            }
            return this;
        }

        public Builder clinicalTrial(Collection<Reference> clinicalTrial) {
            this.clinicalTrial = new ArrayList<Reference>(clinicalTrial);
            return this;
        }

        public Builder code(Coding ... code) {
            for (Coding value : code) {
                this.code.add(value);
            }
            return this;
        }

        public Builder code(Collection<Coding> code) {
            this.code = new ArrayList<Coding>(code);
            return this;
        }

        public Builder name(Name ... name) {
            for (Name value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<Name> name) {
            this.name = new ArrayList<Name>(name);
            return this;
        }

        public Builder crossReference(CrossReference ... crossReference) {
            for (CrossReference value : crossReference) {
                this.crossReference.add(value);
            }
            return this;
        }

        public Builder crossReference(Collection<CrossReference> crossReference) {
            this.crossReference = new ArrayList<CrossReference>(crossReference);
            return this;
        }

        public Builder operation(Operation ... operation) {
            for (Operation value : operation) {
                this.operation.add(value);
            }
            return this;
        }

        public Builder operation(Collection<Operation> operation) {
            this.operation = new ArrayList<Operation>(operation);
            return this;
        }

        public Builder characteristic(Characteristic ... characteristic) {
            for (Characteristic value : characteristic) {
                this.characteristic.add(value);
            }
            return this;
        }

        public Builder characteristic(Collection<Characteristic> characteristic) {
            this.characteristic = new ArrayList<Characteristic>(characteristic);
            return this;
        }

        @Override
        public MedicinalProductDefinition build() {
            MedicinalProductDefinition medicinalProductDefinition = new MedicinalProductDefinition(this);
            if (this.validating) {
                this.validate(medicinalProductDefinition);
            }
            return medicinalProductDefinition;
        }

        protected void validate(MedicinalProductDefinition medicinalProductDefinition) {
            super.validate(medicinalProductDefinition);
            ValidationSupport.checkList(medicinalProductDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(medicinalProductDefinition.route, "route", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductDefinition.specialMeasures, "specialMeasures", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductDefinition.classification, "classification", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductDefinition.marketingStatus, "marketingStatus", MarketingStatus.class);
            ValidationSupport.checkList(medicinalProductDefinition.packagedMedicinalProduct, "packagedMedicinalProduct", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductDefinition.ingredient, "ingredient", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductDefinition.impurity, "impurity", CodeableReference.class);
            ValidationSupport.checkList(medicinalProductDefinition.attachedDocument, "attachedDocument", Reference.class);
            ValidationSupport.checkList(medicinalProductDefinition.masterFile, "masterFile", Reference.class);
            ValidationSupport.checkList(medicinalProductDefinition.contact, "contact", Contact.class);
            ValidationSupport.checkList(medicinalProductDefinition.clinicalTrial, "clinicalTrial", Reference.class);
            ValidationSupport.checkList(medicinalProductDefinition.code, "code", Coding.class);
            ValidationSupport.checkNonEmptyList(medicinalProductDefinition.name, "name", Name.class);
            ValidationSupport.checkList(medicinalProductDefinition.crossReference, "crossReference", CrossReference.class);
            ValidationSupport.checkList(medicinalProductDefinition.operation, "operation", Operation.class);
            ValidationSupport.checkList(medicinalProductDefinition.characteristic, "characteristic", Characteristic.class);
            ValidationSupport.checkReferenceType(medicinalProductDefinition.attachedDocument, "attachedDocument", "DocumentReference");
            ValidationSupport.checkReferenceType(medicinalProductDefinition.masterFile, "masterFile", "DocumentReference");
            ValidationSupport.checkReferenceType(medicinalProductDefinition.clinicalTrial, "clinicalTrial", "ResearchStudy");
        }

        protected Builder from(MedicinalProductDefinition medicinalProductDefinition) {
            super.from(medicinalProductDefinition);
            this.identifier.addAll(medicinalProductDefinition.identifier);
            this.type = medicinalProductDefinition.type;
            this.domain = medicinalProductDefinition.domain;
            this.version = medicinalProductDefinition.version;
            this.status = medicinalProductDefinition.status;
            this.statusDate = medicinalProductDefinition.statusDate;
            this.description = medicinalProductDefinition.description;
            this.combinedPharmaceuticalDoseForm = medicinalProductDefinition.combinedPharmaceuticalDoseForm;
            this.route.addAll(medicinalProductDefinition.route);
            this.indication = medicinalProductDefinition.indication;
            this.legalStatusOfSupply = medicinalProductDefinition.legalStatusOfSupply;
            this.additionalMonitoringIndicator = medicinalProductDefinition.additionalMonitoringIndicator;
            this.specialMeasures.addAll(medicinalProductDefinition.specialMeasures);
            this.pediatricUseIndicator = medicinalProductDefinition.pediatricUseIndicator;
            this.classification.addAll(medicinalProductDefinition.classification);
            this.marketingStatus.addAll(medicinalProductDefinition.marketingStatus);
            this.packagedMedicinalProduct.addAll(medicinalProductDefinition.packagedMedicinalProduct);
            this.ingredient.addAll(medicinalProductDefinition.ingredient);
            this.impurity.addAll(medicinalProductDefinition.impurity);
            this.attachedDocument.addAll(medicinalProductDefinition.attachedDocument);
            this.masterFile.addAll(medicinalProductDefinition.masterFile);
            this.contact.addAll(medicinalProductDefinition.contact);
            this.clinicalTrial.addAll(medicinalProductDefinition.clinicalTrial);
            this.code.addAll(medicinalProductDefinition.code);
            this.name.addAll(medicinalProductDefinition.name);
            this.crossReference.addAll(medicinalProductDefinition.crossReference);
            this.operation.addAll(medicinalProductDefinition.operation);
            this.characteristic.addAll(medicinalProductDefinition.characteristic);
            return this;
        }
    }
}

