/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.NamingSystemIdentifierType;
import org.linuxforhealth.fhir.model.type.code.NamingSystemType;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="nsd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/NamingSystem"), @Constraint(id="nsd-1", level="Rule", location="(base)", description="Root systems cannot have uuid identifiers", expression="kind != 'root' or uniqueId.all(type != 'uuid')", source="http://hl7.org/fhir/StructureDefinition/NamingSystem"), @Constraint(id="nsd-2", level="Rule", location="(base)", description="Can't have more than one preferred identifier for a type", expression="uniqueId.where(preferred = true).select(type).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/NamingSystem"), @Constraint(id="namingSystem-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/identifier-type", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/identifier-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/NamingSystem", generated=true), @Constraint(id="namingSystem-4", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/NamingSystem", generated=true)})
public class NamingSystem
extends DomainResource {
    @Summary
    @Required
    private final String name;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    @Binding(bindingName="NamingSystemType", strength=BindingStrength.Value.REQUIRED, description="Identifies the purpose of the naming system.", valueSet="http://hl7.org/fhir/ValueSet/namingsystem-type|4.3.0")
    @Required
    private final NamingSystemType kind;
    @Summary
    @Required
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final String responsible;
    @Binding(bindingName="IdentifierType", strength=BindingStrength.Value.EXTENSIBLE, description="A coded type for an identifier that can be used to determine which identifier to use for a specific purpose.", valueSet="http://hl7.org/fhir/ValueSet/identifier-type")
    private final CodeableConcept type;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final String usage;
    @Summary
    @Required
    private final List<UniqueId> uniqueId;

    private NamingSystem(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.status = builder.status;
        this.kind = builder.kind;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.responsible = builder.responsible;
        this.type = builder.type;
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.usage = builder.usage;
        this.uniqueId = Collections.unmodifiableList(builder.uniqueId);
    }

    public String getName() {
        return this.name;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public NamingSystemType getKind() {
        return this.kind;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public String getUsage() {
        return this.usage;
    }

    public List<UniqueId> getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.name != null || this.status != null || this.kind != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.responsible != null || this.type != null || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.usage != null || !this.uniqueId.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.kind, "kind", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.responsible, "responsible", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.usage, "usage", visitor);
                this.accept(this.uniqueId, "uniqueId", visitor, UniqueId.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamingSystem other = (NamingSystem)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.status, other.status) && Objects.equals(this.kind, other.kind) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.responsible, other.responsible) && Objects.equals(this.type, other.type) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.usage, other.usage) && Objects.equals(this.uniqueId, other.uniqueId);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.name, this.status, this.kind, this.date, this.publisher, this.contact, this.responsible, this.type, this.description, this.useContext, this.jurisdiction, this.usage, this.uniqueId);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class UniqueId
    extends BackboneElement {
        @Summary
        @Binding(bindingName="NamingSystemIdentifierType", strength=BindingStrength.Value.REQUIRED, description="Identifies the style of unique identifier used to identify a namespace.", valueSet="http://hl7.org/fhir/ValueSet/namingsystem-identifier-type|4.3.0")
        @Required
        private final NamingSystemIdentifierType type;
        @Summary
        @Required
        private final String value;
        private final Boolean preferred;
        private final String comment;
        private final Period period;

        private UniqueId(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
            this.preferred = builder.preferred;
            this.comment = builder.comment;
            this.period = builder.period;
        }

        public NamingSystemIdentifierType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public Boolean getPreferred() {
            return this.preferred;
        }

        public String getComment() {
            return this.comment;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null || this.preferred != null || this.comment != null || this.period != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.preferred, "preferred", visitor);
                    this.accept(this.comment, "comment", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueId other = (UniqueId)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.preferred, other.preferred) && Objects.equals(this.comment, other.comment) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value, this.preferred, this.comment, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private NamingSystemIdentifierType type;
            private String value;
            private Boolean preferred;
            private String comment;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(NamingSystemIdentifierType type) {
                this.type = type;
                return this;
            }

            public Builder value(java.lang.String value) {
                this.value = value == null ? null : String.of(value);
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder preferred(java.lang.Boolean preferred) {
                this.preferred = preferred == null ? null : Boolean.of(preferred);
                return this;
            }

            public Builder preferred(Boolean preferred) {
                this.preferred = preferred;
                return this;
            }

            public Builder comment(java.lang.String comment) {
                this.comment = comment == null ? null : String.of(comment);
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public UniqueId build() {
                UniqueId uniqueId = new UniqueId(this);
                if (this.validating) {
                    this.validate(uniqueId);
                }
                return uniqueId;
            }

            protected void validate(UniqueId uniqueId) {
                super.validate(uniqueId);
                ValidationSupport.requireNonNull(uniqueId.type, "type");
                ValidationSupport.requireNonNull(uniqueId.value, "value");
                ValidationSupport.requireValueOrChildren(uniqueId);
            }

            protected Builder from(UniqueId uniqueId) {
                super.from(uniqueId);
                this.type = uniqueId.type;
                this.value = uniqueId.value;
                this.preferred = uniqueId.preferred;
                this.comment = uniqueId.comment;
                this.period = uniqueId.period;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private String name;
        private PublicationStatus status;
        private NamingSystemType kind;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private String responsible;
        private CodeableConcept type;
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private String usage;
        private List<UniqueId> uniqueId = new ArrayList<UniqueId>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder kind(NamingSystemType kind) {
            this.kind = kind;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder responsible(java.lang.String responsible) {
            this.responsible = responsible == null ? null : String.of(responsible);
            return this;
        }

        public Builder responsible(String responsible) {
            this.responsible = responsible;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder usage(java.lang.String usage) {
            this.usage = usage == null ? null : String.of(usage);
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder uniqueId(UniqueId ... uniqueId) {
            for (UniqueId value : uniqueId) {
                this.uniqueId.add(value);
            }
            return this;
        }

        public Builder uniqueId(Collection<UniqueId> uniqueId) {
            this.uniqueId = new ArrayList<UniqueId>(uniqueId);
            return this;
        }

        @Override
        public NamingSystem build() {
            NamingSystem namingSystem = new NamingSystem(this);
            if (this.validating) {
                this.validate(namingSystem);
            }
            return namingSystem;
        }

        protected void validate(NamingSystem namingSystem) {
            super.validate(namingSystem);
            ValidationSupport.requireNonNull(namingSystem.name, "name");
            ValidationSupport.requireNonNull(namingSystem.status, "status");
            ValidationSupport.requireNonNull(namingSystem.kind, "kind");
            ValidationSupport.requireNonNull(namingSystem.date, "date");
            ValidationSupport.checkList(namingSystem.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(namingSystem.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(namingSystem.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkNonEmptyList(namingSystem.uniqueId, "uniqueId", UniqueId.class);
        }

        protected Builder from(NamingSystem namingSystem) {
            super.from(namingSystem);
            this.name = namingSystem.name;
            this.status = namingSystem.status;
            this.kind = namingSystem.kind;
            this.date = namingSystem.date;
            this.publisher = namingSystem.publisher;
            this.contact.addAll(namingSystem.contact);
            this.responsible = namingSystem.responsible;
            this.type = namingSystem.type;
            this.description = namingSystem.description;
            this.useContext.addAll(namingSystem.useContext);
            this.jurisdiction.addAll(namingSystem.jurisdiction);
            this.usage = namingSystem.usage;
            this.uniqueId.addAll(namingSystem.uniqueId);
            return this;
        }
    }
}

