/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Ratio;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.NutritionProductStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class NutritionProduct
extends DomainResource {
    @Summary
    @Binding(bindingName="NutritionProductStatus", strength=BindingStrength.Value.REQUIRED, description="Codes identifying the lifecycle stage of a product.", valueSet="http://hl7.org/fhir/ValueSet/nutritionproduct-status|4.3.0")
    @Required
    private final NutritionProductStatus status;
    @Summary
    @Binding(bindingName="NutritionProductCategory", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying classes of nutrition products.", valueSet="http://hl7.org/fhir/ValueSet/nutrition-product-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="NutritionProductCode", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying specific types of nutrition products.", valueSet="http://hl7.org/fhir/ValueSet/edible-substance-type")
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> manufacturer;
    @Summary
    private final List<Nutrient> nutrient;
    private final List<Ingredient> ingredient;
    @Binding(bindingName="AllergenClass", strength=BindingStrength.Value.EXAMPLE, description="Codes that identify substances that can be an allergen.", valueSet="http://hl7.org/fhir/ValueSet/allergen-class")
    private final List<CodeableReference> knownAllergen;
    private final List<ProductCharacteristic> productCharacteristic;
    private final Instance instance;
    private final List<Annotation> note;

    private NutritionProduct(Builder builder) {
        super(builder);
        this.status = builder.status;
        this.category = Collections.unmodifiableList(builder.category);
        this.code = builder.code;
        this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        this.nutrient = Collections.unmodifiableList(builder.nutrient);
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
        this.knownAllergen = Collections.unmodifiableList(builder.knownAllergen);
        this.productCharacteristic = Collections.unmodifiableList(builder.productCharacteristic);
        this.instance = builder.instance;
        this.note = Collections.unmodifiableList(builder.note);
    }

    public NutritionProductStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public List<Reference> getManufacturer() {
        return this.manufacturer;
    }

    public List<Nutrient> getNutrient() {
        return this.nutrient;
    }

    public List<Ingredient> getIngredient() {
        return this.ingredient;
    }

    public List<CodeableReference> getKnownAllergen() {
        return this.knownAllergen;
    }

    public List<ProductCharacteristic> getProductCharacteristic() {
        return this.productCharacteristic;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.status != null || !this.category.isEmpty() || this.code != null || !this.manufacturer.isEmpty() || !this.nutrient.isEmpty() || !this.ingredient.isEmpty() || !this.knownAllergen.isEmpty() || !this.productCharacteristic.isEmpty() || this.instance != null || !this.note.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                this.accept(this.nutrient, "nutrient", visitor, Nutrient.class);
                this.accept(this.ingredient, "ingredient", visitor, Ingredient.class);
                this.accept(this.knownAllergen, "knownAllergen", visitor, CodeableReference.class);
                this.accept(this.productCharacteristic, "productCharacteristic", visitor, ProductCharacteristic.class);
                this.accept(this.instance, "instance", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutritionProduct other = (NutritionProduct)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.status, other.status) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.nutrient, other.nutrient) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.knownAllergen, other.knownAllergen) && Objects.equals(this.productCharacteristic, other.productCharacteristic) && Objects.equals(this.instance, other.instance) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.status, this.category, this.code, this.manufacturer, this.nutrient, this.ingredient, this.knownAllergen, this.productCharacteristic, this.instance, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Instance
    extends BackboneElement {
        private final SimpleQuantity quantity;
        private final List<Identifier> identifier;
        private final org.linuxforhealth.fhir.model.type.String lotNumber;
        private final DateTime expiry;
        private final DateTime useBy;

        private Instance(Builder builder) {
            super(builder);
            this.quantity = builder.quantity;
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.lotNumber = builder.lotNumber;
            this.expiry = builder.expiry;
            this.useBy = builder.useBy;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public org.linuxforhealth.fhir.model.type.String getLotNumber() {
            return this.lotNumber;
        }

        public DateTime getExpiry() {
            return this.expiry;
        }

        public DateTime getUseBy() {
            return this.useBy;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.quantity != null || !this.identifier.isEmpty() || this.lotNumber != null || this.expiry != null || this.useBy != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.lotNumber, "lotNumber", visitor);
                    this.accept(this.expiry, "expiry", visitor);
                    this.accept(this.useBy, "useBy", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Instance other = (Instance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.lotNumber, other.lotNumber) && Objects.equals(this.expiry, other.expiry) && Objects.equals(this.useBy, other.useBy);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.quantity, this.identifier, this.lotNumber, this.expiry, this.useBy);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private SimpleQuantity quantity;
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private org.linuxforhealth.fhir.model.type.String lotNumber;
            private DateTime expiry;
            private DateTime useBy;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder lotNumber(String lotNumber) {
                this.lotNumber = lotNumber == null ? null : org.linuxforhealth.fhir.model.type.String.of(lotNumber);
                return this;
            }

            public Builder lotNumber(org.linuxforhealth.fhir.model.type.String lotNumber) {
                this.lotNumber = lotNumber;
                return this;
            }

            public Builder expiry(DateTime expiry) {
                this.expiry = expiry;
                return this;
            }

            public Builder useBy(DateTime useBy) {
                this.useBy = useBy;
                return this;
            }

            @Override
            public Instance build() {
                Instance instance = new Instance(this);
                if (this.validating) {
                    this.validate(instance);
                }
                return instance;
            }

            protected void validate(Instance instance) {
                super.validate(instance);
                ValidationSupport.checkList(instance.identifier, "identifier", Identifier.class);
                ValidationSupport.requireValueOrChildren(instance);
            }

            protected Builder from(Instance instance) {
                super.from(instance);
                this.quantity = instance.quantity;
                this.identifier.addAll(instance.identifier);
                this.lotNumber = instance.lotNumber;
                this.expiry = instance.expiry;
                this.useBy = instance.useBy;
                return this;
            }
        }
    }

    public static class ProductCharacteristic
    extends BackboneElement {
        @Binding(bindingName="PropertyCharacteristic", strength=BindingStrength.Value.EXAMPLE, description="Codes that identify properties that can be measured.", valueSet="http://hl7.org/fhir/ValueSet/measurement-property")
        @Required
        private final CodeableConcept type;
        @Choice(value={CodeableConcept.class, org.linuxforhealth.fhir.model.type.String.class, SimpleQuantity.class, Base64Binary.class, Attachment.class, Boolean.class})
        @Required
        private final Element value;

        private ProductCharacteristic(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProductCharacteristic other = (ProductCharacteristic)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value);
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public ProductCharacteristic build() {
                ProductCharacteristic productCharacteristic = new ProductCharacteristic(this);
                if (this.validating) {
                    this.validate(productCharacteristic);
                }
                return productCharacteristic;
            }

            protected void validate(ProductCharacteristic productCharacteristic) {
                super.validate(productCharacteristic);
                ValidationSupport.requireNonNull(productCharacteristic.type, "type");
                ValidationSupport.requireChoiceElement(productCharacteristic.value, "value", CodeableConcept.class, org.linuxforhealth.fhir.model.type.String.class, SimpleQuantity.class, Base64Binary.class, Attachment.class, Boolean.class);
                ValidationSupport.requireValueOrChildren(productCharacteristic);
            }

            protected Builder from(ProductCharacteristic productCharacteristic) {
                super.from(productCharacteristic);
                this.type = productCharacteristic.type;
                this.value = productCharacteristic.value;
                return this;
            }
        }
    }

    public static class Ingredient
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableReference item;
        @Summary
        private final List<Ratio> amount;

        private Ingredient(Builder builder) {
            super(builder);
            this.item = builder.item;
            this.amount = Collections.unmodifiableList(builder.amount);
        }

        public CodeableReference getItem() {
            return this.item;
        }

        public List<Ratio> getAmount() {
            return this.amount;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.item != null || !this.amount.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.item, "item", visitor);
                    this.accept(this.amount, "amount", visitor, Ratio.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ingredient other = (Ingredient)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.item, other.item) && Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.item, this.amount);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference item;
            private List<Ratio> amount = new ArrayList<Ratio>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder item(CodeableReference item) {
                this.item = item;
                return this;
            }

            public Builder amount(Ratio ... amount) {
                for (Ratio value : amount) {
                    this.amount.add(value);
                }
                return this;
            }

            public Builder amount(Collection<Ratio> amount) {
                this.amount = new ArrayList<Ratio>(amount);
                return this;
            }

            @Override
            public Ingredient build() {
                Ingredient ingredient = new Ingredient(this);
                if (this.validating) {
                    this.validate(ingredient);
                }
                return ingredient;
            }

            protected void validate(Ingredient ingredient) {
                super.validate(ingredient);
                ValidationSupport.requireNonNull(ingredient.item, "item");
                ValidationSupport.checkList(ingredient.amount, "amount", Ratio.class);
                ValidationSupport.requireValueOrChildren(ingredient);
            }

            protected Builder from(Ingredient ingredient) {
                super.from(ingredient);
                this.item = ingredient.item;
                this.amount.addAll(ingredient.amount);
                return this;
            }
        }
    }

    public static class Nutrient
    extends BackboneElement {
        @Binding(bindingName="NutritionProductNutrient", strength=BindingStrength.Value.EXAMPLE, description="Codes that identify nutrients that could be parts of nutrition products.", valueSet="http://hl7.org/fhir/ValueSet/nutrition-product-nutrient")
        private final CodeableReference item;
        private final List<Ratio> amount;

        private Nutrient(Builder builder) {
            super(builder);
            this.item = builder.item;
            this.amount = Collections.unmodifiableList(builder.amount);
        }

        public CodeableReference getItem() {
            return this.item;
        }

        public List<Ratio> getAmount() {
            return this.amount;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.item != null || !this.amount.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.item, "item", visitor);
                    this.accept(this.amount, "amount", visitor, Ratio.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Nutrient other = (Nutrient)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.item, other.item) && Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.item, this.amount);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableReference item;
            private List<Ratio> amount = new ArrayList<Ratio>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder item(CodeableReference item) {
                this.item = item;
                return this;
            }

            public Builder amount(Ratio ... amount) {
                for (Ratio value : amount) {
                    this.amount.add(value);
                }
                return this;
            }

            public Builder amount(Collection<Ratio> amount) {
                this.amount = new ArrayList<Ratio>(amount);
                return this;
            }

            @Override
            public Nutrient build() {
                Nutrient nutrient = new Nutrient(this);
                if (this.validating) {
                    this.validate(nutrient);
                }
                return nutrient;
            }

            protected void validate(Nutrient nutrient) {
                super.validate(nutrient);
                ValidationSupport.checkList(nutrient.amount, "amount", Ratio.class);
                ValidationSupport.requireValueOrChildren(nutrient);
            }

            protected Builder from(Nutrient nutrient) {
                super.from(nutrient);
                this.item = nutrient.item;
                this.amount.addAll(nutrient.amount);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private NutritionProductStatus status;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept code;
        private List<Reference> manufacturer = new ArrayList<Reference>();
        private List<Nutrient> nutrient = new ArrayList<Nutrient>();
        private List<Ingredient> ingredient = new ArrayList<Ingredient>();
        private List<CodeableReference> knownAllergen = new ArrayList<CodeableReference>();
        private List<ProductCharacteristic> productCharacteristic = new ArrayList<ProductCharacteristic>();
        private Instance instance;
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder status(NutritionProductStatus status) {
            this.status = status;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder manufacturer(Reference ... manufacturer) {
            for (Reference value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Reference> manufacturer) {
            this.manufacturer = new ArrayList<Reference>(manufacturer);
            return this;
        }

        public Builder nutrient(Nutrient ... nutrient) {
            for (Nutrient value : nutrient) {
                this.nutrient.add(value);
            }
            return this;
        }

        public Builder nutrient(Collection<Nutrient> nutrient) {
            this.nutrient = new ArrayList<Nutrient>(nutrient);
            return this;
        }

        public Builder ingredient(Ingredient ... ingredient) {
            for (Ingredient value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<Ingredient> ingredient) {
            this.ingredient = new ArrayList<Ingredient>(ingredient);
            return this;
        }

        public Builder knownAllergen(CodeableReference ... knownAllergen) {
            for (CodeableReference value : knownAllergen) {
                this.knownAllergen.add(value);
            }
            return this;
        }

        public Builder knownAllergen(Collection<CodeableReference> knownAllergen) {
            this.knownAllergen = new ArrayList<CodeableReference>(knownAllergen);
            return this;
        }

        public Builder productCharacteristic(ProductCharacteristic ... productCharacteristic) {
            for (ProductCharacteristic value : productCharacteristic) {
                this.productCharacteristic.add(value);
            }
            return this;
        }

        public Builder productCharacteristic(Collection<ProductCharacteristic> productCharacteristic) {
            this.productCharacteristic = new ArrayList<ProductCharacteristic>(productCharacteristic);
            return this;
        }

        public Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public NutritionProduct build() {
            NutritionProduct nutritionProduct = new NutritionProduct(this);
            if (this.validating) {
                this.validate(nutritionProduct);
            }
            return nutritionProduct;
        }

        protected void validate(NutritionProduct nutritionProduct) {
            super.validate(nutritionProduct);
            ValidationSupport.requireNonNull(nutritionProduct.status, "status");
            ValidationSupport.checkList(nutritionProduct.category, "category", CodeableConcept.class);
            ValidationSupport.checkList(nutritionProduct.manufacturer, "manufacturer", Reference.class);
            ValidationSupport.checkList(nutritionProduct.nutrient, "nutrient", Nutrient.class);
            ValidationSupport.checkList(nutritionProduct.ingredient, "ingredient", Ingredient.class);
            ValidationSupport.checkList(nutritionProduct.knownAllergen, "knownAllergen", CodeableReference.class);
            ValidationSupport.checkList(nutritionProduct.productCharacteristic, "productCharacteristic", ProductCharacteristic.class);
            ValidationSupport.checkList(nutritionProduct.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(nutritionProduct.manufacturer, "manufacturer", "Organization");
        }

        protected Builder from(NutritionProduct nutritionProduct) {
            super.from(nutritionProduct);
            this.status = nutritionProduct.status;
            this.category.addAll(nutritionProduct.category);
            this.code = nutritionProduct.code;
            this.manufacturer.addAll(nutritionProduct.manufacturer);
            this.nutrient.addAll(nutritionProduct.nutrient);
            this.ingredient.addAll(nutritionProduct.ingredient);
            this.knownAllergen.addAll(nutritionProduct.knownAllergen);
            this.productCharacteristic.addAll(nutritionProduct.productCharacteristic);
            this.instance = nutritionProduct.instance;
            this.note.addAll(nutritionProduct.note);
            return this;
        }
    }
}

