/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.AdministrativeGender;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.ObservationDataType;
import org.linuxforhealth.fhir.model.type.code.ObservationRangeCategory;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="observationDefinition-0", level="Warning", location="quantitativeDetails.customaryUnit", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/ucum-units", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/ucum-units', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/ObservationDefinition", generated=true), @Constraint(id="observationDefinition-1", level="Warning", location="quantitativeDetails.unit", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/ucum-units", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/ucum-units', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/ObservationDefinition", generated=true), @Constraint(id="observationDefinition-2", level="Warning", location="qualifiedInterval.context", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/referencerange-meaning", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/referencerange-meaning', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/ObservationDefinition", generated=true)})
public class ObservationDefinition
extends DomainResource {
    @Summary
    @Binding(bindingName="ObservationCategory", strength=BindingStrength.Value.EXAMPLE, description="Codes for high level observation categories.", valueSet="http://hl7.org/fhir/ValueSet/observation-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="ObservationCode", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying names of simple observations.", valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    @Required
    private final CodeableConcept code;
    @Summary
    private final List<Identifier> identifier;
    @Binding(bindingName="ObservationDataType", strength=BindingStrength.Value.REQUIRED, description="Permitted data type for observation value.", valueSet="http://hl7.org/fhir/ValueSet/permitted-data-type|4.3.0")
    private final List<ObservationDataType> permittedDataType;
    private final Boolean multipleResultsAllowed;
    @Binding(bindingName="ObservationMethod", strength=BindingStrength.Value.EXAMPLE, description="Methods for simple observations.", valueSet="http://hl7.org/fhir/ValueSet/observation-methods")
    private final CodeableConcept method;
    private final String preferredReportName;
    private final QuantitativeDetails quantitativeDetails;
    private final List<QualifiedInterval> qualifiedInterval;
    @ReferenceTarget(value={"ValueSet"})
    private final Reference validCodedValueSet;
    @ReferenceTarget(value={"ValueSet"})
    private final Reference normalCodedValueSet;
    @ReferenceTarget(value={"ValueSet"})
    private final Reference abnormalCodedValueSet;
    @ReferenceTarget(value={"ValueSet"})
    private final Reference criticalCodedValueSet;

    private ObservationDefinition(Builder builder) {
        super(builder);
        this.category = Collections.unmodifiableList(builder.category);
        this.code = builder.code;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.permittedDataType = Collections.unmodifiableList(builder.permittedDataType);
        this.multipleResultsAllowed = builder.multipleResultsAllowed;
        this.method = builder.method;
        this.preferredReportName = builder.preferredReportName;
        this.quantitativeDetails = builder.quantitativeDetails;
        this.qualifiedInterval = Collections.unmodifiableList(builder.qualifiedInterval);
        this.validCodedValueSet = builder.validCodedValueSet;
        this.normalCodedValueSet = builder.normalCodedValueSet;
        this.abnormalCodedValueSet = builder.abnormalCodedValueSet;
        this.criticalCodedValueSet = builder.criticalCodedValueSet;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<ObservationDataType> getPermittedDataType() {
        return this.permittedDataType;
    }

    public Boolean getMultipleResultsAllowed() {
        return this.multipleResultsAllowed;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public String getPreferredReportName() {
        return this.preferredReportName;
    }

    public QuantitativeDetails getQuantitativeDetails() {
        return this.quantitativeDetails;
    }

    public List<QualifiedInterval> getQualifiedInterval() {
        return this.qualifiedInterval;
    }

    public Reference getValidCodedValueSet() {
        return this.validCodedValueSet;
    }

    public Reference getNormalCodedValueSet() {
        return this.normalCodedValueSet;
    }

    public Reference getAbnormalCodedValueSet() {
        return this.abnormalCodedValueSet;
    }

    public Reference getCriticalCodedValueSet() {
        return this.criticalCodedValueSet;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.category.isEmpty() || this.code != null || !this.identifier.isEmpty() || !this.permittedDataType.isEmpty() || this.multipleResultsAllowed != null || this.method != null || this.preferredReportName != null || this.quantitativeDetails != null || !this.qualifiedInterval.isEmpty() || this.validCodedValueSet != null || this.normalCodedValueSet != null || this.abnormalCodedValueSet != null || this.criticalCodedValueSet != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.permittedDataType, "permittedDataType", visitor, ObservationDataType.class);
                this.accept(this.multipleResultsAllowed, "multipleResultsAllowed", visitor);
                this.accept(this.method, "method", visitor);
                this.accept(this.preferredReportName, "preferredReportName", visitor);
                this.accept(this.quantitativeDetails, "quantitativeDetails", visitor);
                this.accept(this.qualifiedInterval, "qualifiedInterval", visitor, QualifiedInterval.class);
                this.accept(this.validCodedValueSet, "validCodedValueSet", visitor);
                this.accept(this.normalCodedValueSet, "normalCodedValueSet", visitor);
                this.accept(this.abnormalCodedValueSet, "abnormalCodedValueSet", visitor);
                this.accept(this.criticalCodedValueSet, "criticalCodedValueSet", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObservationDefinition other = (ObservationDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.permittedDataType, other.permittedDataType) && Objects.equals(this.multipleResultsAllowed, other.multipleResultsAllowed) && Objects.equals(this.method, other.method) && Objects.equals(this.preferredReportName, other.preferredReportName) && Objects.equals(this.quantitativeDetails, other.quantitativeDetails) && Objects.equals(this.qualifiedInterval, other.qualifiedInterval) && Objects.equals(this.validCodedValueSet, other.validCodedValueSet) && Objects.equals(this.normalCodedValueSet, other.normalCodedValueSet) && Objects.equals(this.abnormalCodedValueSet, other.abnormalCodedValueSet) && Objects.equals(this.criticalCodedValueSet, other.criticalCodedValueSet);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.category, this.code, this.identifier, this.permittedDataType, this.multipleResultsAllowed, this.method, this.preferredReportName, this.quantitativeDetails, this.qualifiedInterval, this.validCodedValueSet, this.normalCodedValueSet, this.abnormalCodedValueSet, this.criticalCodedValueSet);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class QualifiedInterval
    extends BackboneElement {
        @Binding(bindingName="ObservationRangeCategory", strength=BindingStrength.Value.REQUIRED, description="Codes identifying the category of observation range.", valueSet="http://hl7.org/fhir/ValueSet/observation-range-category|4.3.0")
        private final ObservationRangeCategory category;
        private final Range range;
        @Binding(bindingName="ObservationRangeMeaning", strength=BindingStrength.Value.EXTENSIBLE, description="Code identifying the health context of a range.", valueSet="http://hl7.org/fhir/ValueSet/referencerange-meaning")
        private final CodeableConcept context;
        @Binding(bindingName="ObservationRangeAppliesTo", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying the population the reference range applies to.", valueSet="http://hl7.org/fhir/ValueSet/referencerange-appliesto")
        private final List<CodeableConcept> appliesTo;
        @Binding(bindingName="AdministrativeGender", strength=BindingStrength.Value.REQUIRED, description="The gender of a person used for administrative purposes.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender|4.3.0")
        private final AdministrativeGender gender;
        private final Range age;
        private final Range gestationalAge;
        private final String condition;

        private QualifiedInterval(Builder builder) {
            super(builder);
            this.category = builder.category;
            this.range = builder.range;
            this.context = builder.context;
            this.appliesTo = Collections.unmodifiableList(builder.appliesTo);
            this.gender = builder.gender;
            this.age = builder.age;
            this.gestationalAge = builder.gestationalAge;
            this.condition = builder.condition;
        }

        public ObservationRangeCategory getCategory() {
            return this.category;
        }

        public Range getRange() {
            return this.range;
        }

        public CodeableConcept getContext() {
            return this.context;
        }

        public List<CodeableConcept> getAppliesTo() {
            return this.appliesTo;
        }

        public AdministrativeGender getGender() {
            return this.gender;
        }

        public Range getAge() {
            return this.age;
        }

        public Range getGestationalAge() {
            return this.gestationalAge;
        }

        public String getCondition() {
            return this.condition;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.category != null || this.range != null || this.context != null || !this.appliesTo.isEmpty() || this.gender != null || this.age != null || this.gestationalAge != null || this.condition != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.range, "range", visitor);
                    this.accept(this.context, "context", visitor);
                    this.accept(this.appliesTo, "appliesTo", visitor, CodeableConcept.class);
                    this.accept(this.gender, "gender", visitor);
                    this.accept(this.age, "age", visitor);
                    this.accept(this.gestationalAge, "gestationalAge", visitor);
                    this.accept(this.condition, "condition", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QualifiedInterval other = (QualifiedInterval)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.range, other.range) && Objects.equals(this.context, other.context) && Objects.equals(this.appliesTo, other.appliesTo) && Objects.equals(this.gender, other.gender) && Objects.equals(this.age, other.age) && Objects.equals(this.gestationalAge, other.gestationalAge) && Objects.equals(this.condition, other.condition);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.category, this.range, this.context, this.appliesTo, this.gender, this.age, this.gestationalAge, this.condition);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ObservationRangeCategory category;
            private Range range;
            private CodeableConcept context;
            private List<CodeableConcept> appliesTo = new ArrayList<CodeableConcept>();
            private AdministrativeGender gender;
            private Range age;
            private Range gestationalAge;
            private String condition;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder category(ObservationRangeCategory category) {
                this.category = category;
                return this;
            }

            public Builder range(Range range) {
                this.range = range;
                return this;
            }

            public Builder context(CodeableConcept context) {
                this.context = context;
                return this;
            }

            public Builder appliesTo(CodeableConcept ... appliesTo) {
                for (CodeableConcept value : appliesTo) {
                    this.appliesTo.add(value);
                }
                return this;
            }

            public Builder appliesTo(Collection<CodeableConcept> appliesTo) {
                this.appliesTo = new ArrayList<CodeableConcept>(appliesTo);
                return this;
            }

            public Builder gender(AdministrativeGender gender) {
                this.gender = gender;
                return this;
            }

            public Builder age(Range age) {
                this.age = age;
                return this;
            }

            public Builder gestationalAge(Range gestationalAge) {
                this.gestationalAge = gestationalAge;
                return this;
            }

            public Builder condition(java.lang.String condition) {
                this.condition = condition == null ? null : String.of(condition);
                return this;
            }

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            @Override
            public QualifiedInterval build() {
                QualifiedInterval qualifiedInterval = new QualifiedInterval(this);
                if (this.validating) {
                    this.validate(qualifiedInterval);
                }
                return qualifiedInterval;
            }

            protected void validate(QualifiedInterval qualifiedInterval) {
                super.validate(qualifiedInterval);
                ValidationSupport.checkList(qualifiedInterval.appliesTo, "appliesTo", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(qualifiedInterval);
            }

            protected Builder from(QualifiedInterval qualifiedInterval) {
                super.from(qualifiedInterval);
                this.category = qualifiedInterval.category;
                this.range = qualifiedInterval.range;
                this.context = qualifiedInterval.context;
                this.appliesTo.addAll(qualifiedInterval.appliesTo);
                this.gender = qualifiedInterval.gender;
                this.age = qualifiedInterval.age;
                this.gestationalAge = qualifiedInterval.gestationalAge;
                this.condition = qualifiedInterval.condition;
                return this;
            }
        }
    }

    public static class QuantitativeDetails
    extends BackboneElement {
        @Binding(bindingName="ObservationUnit", strength=BindingStrength.Value.EXTENSIBLE, description="Codes identifying units of measure.", valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
        private final CodeableConcept customaryUnit;
        @Binding(bindingName="ObservationUnit", strength=BindingStrength.Value.EXTENSIBLE, description="Codes identifying units of measure.", valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
        private final CodeableConcept unit;
        private final Decimal conversionFactor;
        private final Integer decimalPrecision;

        private QuantitativeDetails(Builder builder) {
            super(builder);
            this.customaryUnit = builder.customaryUnit;
            this.unit = builder.unit;
            this.conversionFactor = builder.conversionFactor;
            this.decimalPrecision = builder.decimalPrecision;
        }

        public CodeableConcept getCustomaryUnit() {
            return this.customaryUnit;
        }

        public CodeableConcept getUnit() {
            return this.unit;
        }

        public Decimal getConversionFactor() {
            return this.conversionFactor;
        }

        public Integer getDecimalPrecision() {
            return this.decimalPrecision;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.customaryUnit != null || this.unit != null || this.conversionFactor != null || this.decimalPrecision != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.customaryUnit, "customaryUnit", visitor);
                    this.accept(this.unit, "unit", visitor);
                    this.accept(this.conversionFactor, "conversionFactor", visitor);
                    this.accept(this.decimalPrecision, "decimalPrecision", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QuantitativeDetails other = (QuantitativeDetails)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.customaryUnit, other.customaryUnit) && Objects.equals(this.unit, other.unit) && Objects.equals(this.conversionFactor, other.conversionFactor) && Objects.equals(this.decimalPrecision, other.decimalPrecision);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.customaryUnit, this.unit, this.conversionFactor, this.decimalPrecision);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept customaryUnit;
            private CodeableConcept unit;
            private Decimal conversionFactor;
            private Integer decimalPrecision;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder customaryUnit(CodeableConcept customaryUnit) {
                this.customaryUnit = customaryUnit;
                return this;
            }

            public Builder unit(CodeableConcept unit) {
                this.unit = unit;
                return this;
            }

            public Builder conversionFactor(Decimal conversionFactor) {
                this.conversionFactor = conversionFactor;
                return this;
            }

            public Builder decimalPrecision(java.lang.Integer decimalPrecision) {
                this.decimalPrecision = decimalPrecision == null ? null : Integer.of(decimalPrecision);
                return this;
            }

            public Builder decimalPrecision(Integer decimalPrecision) {
                this.decimalPrecision = decimalPrecision;
                return this;
            }

            @Override
            public QuantitativeDetails build() {
                QuantitativeDetails quantitativeDetails = new QuantitativeDetails(this);
                if (this.validating) {
                    this.validate(quantitativeDetails);
                }
                return quantitativeDetails;
            }

            protected void validate(QuantitativeDetails quantitativeDetails) {
                super.validate(quantitativeDetails);
                ValidationSupport.requireValueOrChildren(quantitativeDetails);
            }

            protected Builder from(QuantitativeDetails quantitativeDetails) {
                super.from(quantitativeDetails);
                this.customaryUnit = quantitativeDetails.customaryUnit;
                this.unit = quantitativeDetails.unit;
                this.conversionFactor = quantitativeDetails.conversionFactor;
                this.decimalPrecision = quantitativeDetails.decimalPrecision;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept code;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<ObservationDataType> permittedDataType = new ArrayList<ObservationDataType>();
        private Boolean multipleResultsAllowed;
        private CodeableConcept method;
        private String preferredReportName;
        private QuantitativeDetails quantitativeDetails;
        private List<QualifiedInterval> qualifiedInterval = new ArrayList<QualifiedInterval>();
        private Reference validCodedValueSet;
        private Reference normalCodedValueSet;
        private Reference abnormalCodedValueSet;
        private Reference criticalCodedValueSet;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder permittedDataType(ObservationDataType ... permittedDataType) {
            for (ObservationDataType value : permittedDataType) {
                this.permittedDataType.add(value);
            }
            return this;
        }

        public Builder permittedDataType(Collection<ObservationDataType> permittedDataType) {
            this.permittedDataType = new ArrayList<ObservationDataType>(permittedDataType);
            return this;
        }

        public Builder multipleResultsAllowed(java.lang.Boolean multipleResultsAllowed) {
            this.multipleResultsAllowed = multipleResultsAllowed == null ? null : Boolean.of(multipleResultsAllowed);
            return this;
        }

        public Builder multipleResultsAllowed(Boolean multipleResultsAllowed) {
            this.multipleResultsAllowed = multipleResultsAllowed;
            return this;
        }

        public Builder method(CodeableConcept method) {
            this.method = method;
            return this;
        }

        public Builder preferredReportName(java.lang.String preferredReportName) {
            this.preferredReportName = preferredReportName == null ? null : String.of(preferredReportName);
            return this;
        }

        public Builder preferredReportName(String preferredReportName) {
            this.preferredReportName = preferredReportName;
            return this;
        }

        public Builder quantitativeDetails(QuantitativeDetails quantitativeDetails) {
            this.quantitativeDetails = quantitativeDetails;
            return this;
        }

        public Builder qualifiedInterval(QualifiedInterval ... qualifiedInterval) {
            for (QualifiedInterval value : qualifiedInterval) {
                this.qualifiedInterval.add(value);
            }
            return this;
        }

        public Builder qualifiedInterval(Collection<QualifiedInterval> qualifiedInterval) {
            this.qualifiedInterval = new ArrayList<QualifiedInterval>(qualifiedInterval);
            return this;
        }

        public Builder validCodedValueSet(Reference validCodedValueSet) {
            this.validCodedValueSet = validCodedValueSet;
            return this;
        }

        public Builder normalCodedValueSet(Reference normalCodedValueSet) {
            this.normalCodedValueSet = normalCodedValueSet;
            return this;
        }

        public Builder abnormalCodedValueSet(Reference abnormalCodedValueSet) {
            this.abnormalCodedValueSet = abnormalCodedValueSet;
            return this;
        }

        public Builder criticalCodedValueSet(Reference criticalCodedValueSet) {
            this.criticalCodedValueSet = criticalCodedValueSet;
            return this;
        }

        @Override
        public ObservationDefinition build() {
            ObservationDefinition observationDefinition = new ObservationDefinition(this);
            if (this.validating) {
                this.validate(observationDefinition);
            }
            return observationDefinition;
        }

        protected void validate(ObservationDefinition observationDefinition) {
            super.validate(observationDefinition);
            ValidationSupport.checkList(observationDefinition.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(observationDefinition.code, "code");
            ValidationSupport.checkList(observationDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(observationDefinition.permittedDataType, "permittedDataType", ObservationDataType.class);
            ValidationSupport.checkList(observationDefinition.qualifiedInterval, "qualifiedInterval", QualifiedInterval.class);
            ValidationSupport.checkReferenceType(observationDefinition.validCodedValueSet, "validCodedValueSet", "ValueSet");
            ValidationSupport.checkReferenceType(observationDefinition.normalCodedValueSet, "normalCodedValueSet", "ValueSet");
            ValidationSupport.checkReferenceType(observationDefinition.abnormalCodedValueSet, "abnormalCodedValueSet", "ValueSet");
            ValidationSupport.checkReferenceType(observationDefinition.criticalCodedValueSet, "criticalCodedValueSet", "ValueSet");
        }

        protected Builder from(ObservationDefinition observationDefinition) {
            super.from(observationDefinition);
            this.category.addAll(observationDefinition.category);
            this.code = observationDefinition.code;
            this.identifier.addAll(observationDefinition.identifier);
            this.permittedDataType.addAll(observationDefinition.permittedDataType);
            this.multipleResultsAllowed = observationDefinition.multipleResultsAllowed;
            this.method = observationDefinition.method;
            this.preferredReportName = observationDefinition.preferredReportName;
            this.quantitativeDetails = observationDefinition.quantitativeDetails;
            this.qualifiedInterval.addAll(observationDefinition.qualifiedInterval);
            this.validCodedValueSet = observationDefinition.validCodedValueSet;
            this.normalCodedValueSet = observationDefinition.normalCodedValueSet;
            this.abnormalCodedValueSet = observationDefinition.abnormalCodedValueSet;
            this.criticalCodedValueSet = observationDefinition.criticalCodedValueSet;
            return this;
        }
    }
}

